#include "DeviceTest.h"
#include "utils/Process.h"
#include <QDir>
#include <QJsonObject>

TEST_F(DeviceTest, md5)
{
    QString dimPath = "/home/zxm/Downloads/boot.dim";
    QString dimMD5Path = dimPath + ".md5";
    QString out, err;
//    bool ret = Process::spawnCmd("sudo", {"/bin/bash -c", " md5sum " + dimPath +" > "+ dimMD5Path}, out, err);
    QStringList args;
//    args<<"-c"<<"sudo md5sum"<<dimPath<<">"<<dimMD5Path<<";sudo chown root:root"<<dimMD5Path;
    QString cmd = QString("sudo md5sum %1 > %2;sudo chown root:root %3").arg(dimPath).arg(dimMD5Path).arg(dimMD5Path);
//    QString cmd = QString("sudo md5sum %1 > %2").arg(dimPath).arg(dimMD5Path);
    bool ret = Process::spawnCmd("/bin/bash", {"-c", cmd}, out, err);
    qInfo()<<"out = "<<out<<", err = "<<err;
    EXPECT_TRUE(ret);
}

TEST_F(DeviceTest, getAllMediaMountPoint)
{
    QList<QString> mountPointList;
    bool retcode = Device::getAllMediaMountPoint(mountPointList);
    EXPECT_TRUE(retcode);
}

TEST_F(DeviceTest, findSuitablePartition)
{
    QDir dir("/media/zxm/ab   12");
    bool exist = dir.exists();
    bool b = dir.cd("/media/zxm/ab   12/a  b");
    QString name = dir.dirName();
    auto absName = dir.absolutePath();

    quint64 dimTotalBytes = 10 * 1024 * 1024 * 1024L;
    quint64 thresholdBytes = 500 * 1024 * 1024L;
    QString partitionPath;
    bool ret = Device::findSuitablePartition(dimTotalBytes, partitionPath, thresholdBytes);
    EXPECT_TRUE(ret);
}

TEST_F(DeviceTest, getDeviceInfoByLsblkOut)
{
 //   QString lsblkOut = Device::getLsblkByOutput();
//    DeviceInfoList allDeviceInfo = Device::getDeviceInfoByLsblkOut(lsblkOut);

    DeviceInfoList allDeviceInfo = Device::getAllDeviceByLsblk();
    EXPECT_TRUE(!allDeviceInfo.isEmpty());
}

TEST_F(DeviceTest, getSysDevicesByFstab)
{
    QString fstabFile = "/etc/fstab";
    QStringList allDevices = Device::getSysDevicesByFstab(fstabFile);
    EXPECT_TRUE(!allDevices.isEmpty());
}

TEST_F(DeviceTest, exportPartitionInfoByLsblk)
{
    QString path = "/home/zxm/Desktop/20221104-100548/partition_policy.json";
    QStringList devLList;
    QString err;
    bool ret = Device::exportPartitionInfoByLsblk(path, devLList, err);
    EXPECT_TRUE(ret);
}

TEST_F(DeviceTest, getMountPointByUUID)
{
    // 自己先构造一个挂载点带空格的外接设备
    QString uuid = "3dcfcfd6-5f1c-44a5-af95-7f5b6ba76a36";
    QString mountPoint;
    bool retcode = Device::getMountPointByUUID(uuid, mountPoint);
    EXPECT_TRUE(retcode);
}

TEST_F(DeviceTest, getVGNames)
{
    QStringList vgs;
    bool retCode = Device::getVGNames(vgs);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, getPvDisplay)
{
 //   DeviceInfoList allDevices = Device::getAllDeviceByLsblk();
    QMap<QString, QString> pvVgMap;
    bool retCode = Device::getPvDisplay(pvVgMap);

    for (auto vgName : pvVgMap.values()) {
        QStringList lvPathList;
        Device::getLvPathsByVgName(vgName, lvPathList);
    }

    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, deleteLVM)
{
    QStringList devices;
    devices<<"/dev/sdc";

    QMap<QString, QString> pvVgMaps;
    bool retCode = Device::getPvDisplay(pvVgMaps);
    EXPECT_TRUE(retCode);

    retCode = Device::deleteLVM(devices, pvVgMaps);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, deleteVG)
{
    QStringList devices;
    devices<<"/dev/sdd";

    QMap<QString, QString> pvVgMaps;
    bool retCode = Device::getPvDisplay(pvVgMaps);
    EXPECT_TRUE(retCode);

    retCode = Device::deleteVG(devices, pvVgMaps);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, renameVG)
{
    QStringList sysVgNames;
    bool retCode = Device::getVGNames(sysVgNames);
    EXPECT_TRUE(retCode);
    QMap<QString, QString> vgMap = {
            {"group1", "group1"},
            {"group2", "group2"},
            {"group10", "group10"}
    };
    retCode = Device::renameVG(sysVgNames, vgMap);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, isMultiFullDiskEncrypt)
{
    QString fstabFile = "/etc/fstab";
    bool retCode = Device::isMultiFullDiskEncrypt(fstabFile);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, getOrganizedDiskList)
{
    DeviceInfoList diskList;
    DeviceInfoList cryptDevList;
    DeviceInfoList noCryptDevList;
    DeviceInfoList partitionList;
    DeviceInfoList lvmList;
    Device::getAllTypeDevice(diskList, cryptDevList, noCryptDevList, partitionList, lvmList);
    DeviceInfoList orgDevList = Device::getOrganizedDiskList(diskList, cryptDevList, noCryptDevList, partitionList, lvmList);

    bool retCode = !orgDevList.isEmpty();
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, getGhostDiskInfo)
{
    QString fstabFile = "/etc/fstab";
    QList<GhostDiskInfo> diskInfoList;
    Device::getGhostDiskInfo(fstabFile, diskInfoList);
    for (auto &disk : diskInfoList) {
        QJsonObject job = disk.marshal();
        GhostDiskInfo tmp;
        tmp.unmarshal(job);
    }

    bool retCode = !diskInfoList.isEmpty();
    EXPECT_TRUE(retCode);
}
