// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    AccelFlags, AccelGroup, Align, Allocation, Buildable, Clipboard, DirectionType, DragResult,
    Orientation, Requisition, SelectionData, Settings, SizeRequestMode, StateFlags, StyleContext,
    TargetList, TextDirection, Tooltip, WidgetHelpType, WidgetPath, Window,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkWidget")]
    pub struct Widget(Object<ffi::GtkWidget, ffi::GtkWidgetClass>) @implements Buildable;

    match fn {
        type_ => || ffi::gtk_widget_get_type(),
    }
}

impl Widget {
    pub const NONE: Option<&'static Widget> = None;

    //#[doc(alias = "gtk_widget_new")]
    //pub fn new(type_: glib::types::Type, first_property_name: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> Widget {
    //    unsafe { TODO: call ffi:gtk_widget_new() }
    //}

    #[doc(alias = "gtk_widget_get_default_direction")]
    #[doc(alias = "get_default_direction")]
    pub fn default_direction() -> TextDirection {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gtk_widget_get_default_direction()) }
    }

    #[doc(alias = "gtk_widget_set_default_direction")]
    pub fn set_default_direction(dir: TextDirection) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_widget_set_default_direction(dir.into_glib());
        }
    }
}

impl fmt::Display for Widget {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&WidgetExt::widget_name(self))
    }
}

pub trait WidgetExt: 'static {
    #[doc(alias = "gtk_widget_activate")]
    fn activate(&self) -> bool;

    #[doc(alias = "gtk_widget_add_accelerator")]
    fn add_accelerator(
        &self,
        accel_signal: &str,
        accel_group: &impl IsA<AccelGroup>,
        accel_key: u32,
        accel_mods: gdk::ModifierType,
        accel_flags: AccelFlags,
    );

    #[doc(alias = "gtk_widget_add_device_events")]
    fn add_device_events(&self, device: &gdk::Device, events: gdk::EventMask);

    #[doc(alias = "gtk_widget_add_mnemonic_label")]
    fn add_mnemonic_label(&self, label: &impl IsA<Widget>);

    #[doc(alias = "gtk_widget_can_activate_accel")]
    fn can_activate_accel(&self, signal_id: u32) -> bool;

    #[doc(alias = "gtk_widget_child_focus")]
    fn child_focus(&self, direction: DirectionType) -> bool;

    #[doc(alias = "gtk_widget_child_notify")]
    fn child_notify(&self, child_property: &str);

    #[doc(alias = "gtk_widget_compute_expand")]
    fn compute_expand(&self, orientation: Orientation) -> bool;

    #[doc(alias = "gtk_widget_create_pango_context")]
    fn create_pango_context(&self) -> pango::Context;

    #[doc(alias = "gtk_widget_create_pango_layout")]
    fn create_pango_layout(&self, text: Option<&str>) -> pango::Layout;

    //#[doc(alias = "gtk_widget_destroyed")]
    //fn destroyed(&self, widget_pointer: impl IsA<Widget>);

    #[doc(alias = "gtk_widget_device_is_shadowed")]
    fn device_is_shadowed(&self, device: &gdk::Device) -> bool;

    #[doc(alias = "gtk_drag_begin_with_coordinates")]
    fn drag_begin_with_coordinates(
        &self,
        targets: &TargetList,
        actions: gdk::DragAction,
        button: i32,
        event: Option<&gdk::Event>,
        x: i32,
        y: i32,
    ) -> Option<gdk::DragContext>;

    #[doc(alias = "gtk_drag_check_threshold")]
    fn drag_check_threshold(
        &self,
        start_x: i32,
        start_y: i32,
        current_x: i32,
        current_y: i32,
    ) -> bool;

    #[doc(alias = "gtk_drag_dest_add_image_targets")]
    fn drag_dest_add_image_targets(&self);

    #[doc(alias = "gtk_drag_dest_add_text_targets")]
    fn drag_dest_add_text_targets(&self);

    #[doc(alias = "gtk_drag_dest_add_uri_targets")]
    fn drag_dest_add_uri_targets(&self);

    #[doc(alias = "gtk_drag_dest_find_target")]
    fn drag_dest_find_target(
        &self,
        context: &gdk::DragContext,
        target_list: Option<&TargetList>,
    ) -> Option<gdk::Atom>;

    #[doc(alias = "gtk_drag_dest_get_target_list")]
    fn drag_dest_get_target_list(&self) -> Option<TargetList>;

    #[doc(alias = "gtk_drag_dest_get_track_motion")]
    fn drag_dest_get_track_motion(&self) -> bool;

    #[doc(alias = "gtk_drag_dest_set_target_list")]
    fn drag_dest_set_target_list(&self, target_list: Option<&TargetList>);

    #[doc(alias = "gtk_drag_dest_set_track_motion")]
    fn drag_dest_set_track_motion(&self, track_motion: bool);

    #[doc(alias = "gtk_drag_dest_unset")]
    fn drag_dest_unset(&self);

    #[doc(alias = "gtk_drag_get_data")]
    fn drag_get_data(&self, context: &gdk::DragContext, target: &gdk::Atom, time_: u32);

    #[doc(alias = "gtk_drag_highlight")]
    fn drag_highlight(&self);

    #[doc(alias = "gtk_drag_source_add_image_targets")]
    fn drag_source_add_image_targets(&self);

    #[doc(alias = "gtk_drag_source_add_text_targets")]
    fn drag_source_add_text_targets(&self);

    #[doc(alias = "gtk_drag_source_add_uri_targets")]
    fn drag_source_add_uri_targets(&self);

    #[doc(alias = "gtk_drag_source_get_target_list")]
    fn drag_source_get_target_list(&self) -> Option<TargetList>;

    #[doc(alias = "gtk_drag_source_set_icon_gicon")]
    fn drag_source_set_icon_gicon(&self, icon: &impl IsA<gio::Icon>);

    #[doc(alias = "gtk_drag_source_set_icon_name")]
    fn drag_source_set_icon_name(&self, icon_name: &str);

    #[doc(alias = "gtk_drag_source_set_icon_pixbuf")]
    fn drag_source_set_icon_pixbuf(&self, pixbuf: &gdk_pixbuf::Pixbuf);

    #[doc(alias = "gtk_drag_source_set_target_list")]
    fn drag_source_set_target_list(&self, target_list: Option<&TargetList>);

    #[doc(alias = "gtk_drag_source_unset")]
    fn drag_source_unset(&self);

    #[doc(alias = "gtk_drag_unhighlight")]
    fn drag_unhighlight(&self);

    #[doc(alias = "gtk_widget_draw")]
    fn draw(&self, cr: &cairo::Context);

    #[doc(alias = "gtk_widget_error_bell")]
    fn error_bell(&self);

    #[doc(alias = "gtk_widget_event")]
    fn event(&self, event: &gdk::Event) -> bool;

    #[doc(alias = "gtk_widget_freeze_child_notify")]
    fn freeze_child_notify(&self);

    #[doc(alias = "gtk_widget_get_accessible")]
    #[doc(alias = "get_accessible")]
    fn accessible(&self) -> Option<atk::Object>;

    #[doc(alias = "gtk_widget_get_action_group")]
    #[doc(alias = "get_action_group")]
    fn action_group(&self, prefix: &str) -> Option<gio::ActionGroup>;

    #[doc(alias = "gtk_widget_get_allocated_baseline")]
    #[doc(alias = "get_allocated_baseline")]
    fn allocated_baseline(&self) -> i32;

    #[doc(alias = "gtk_widget_get_allocated_height")]
    #[doc(alias = "get_allocated_height")]
    fn allocated_height(&self) -> i32;

    #[doc(alias = "gtk_widget_get_allocated_size")]
    #[doc(alias = "get_allocated_size")]
    fn allocated_size(&self) -> (Allocation, i32);

    #[doc(alias = "gtk_widget_get_allocated_width")]
    #[doc(alias = "get_allocated_width")]
    fn allocated_width(&self) -> i32;

    #[doc(alias = "gtk_widget_get_allocation")]
    #[doc(alias = "get_allocation")]
    fn allocation(&self) -> Allocation;

    #[doc(alias = "gtk_widget_get_ancestor")]
    #[doc(alias = "get_ancestor")]
    #[must_use]
    fn ancestor(&self, widget_type: glib::types::Type) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_app_paintable")]
    #[doc(alias = "get_app_paintable")]
    fn is_app_paintable(&self) -> bool;

    #[doc(alias = "gtk_widget_get_can_default")]
    #[doc(alias = "get_can_default")]
    fn can_default(&self) -> bool;

    #[doc(alias = "gtk_widget_get_can_focus")]
    #[doc(alias = "get_can_focus")]
    fn can_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_get_child_visible")]
    #[doc(alias = "get_child_visible")]
    fn is_child_visible(&self) -> bool;

    #[doc(alias = "gtk_widget_get_clip")]
    #[doc(alias = "get_clip")]
    fn clip(&self) -> Allocation;

    #[doc(alias = "gtk_widget_get_clipboard")]
    #[doc(alias = "get_clipboard")]
    fn clipboard(&self, selection: &gdk::Atom) -> Clipboard;

    #[doc(alias = "gtk_widget_get_device_enabled")]
    #[doc(alias = "get_device_enabled")]
    fn device_is_enabled(&self, device: &gdk::Device) -> bool;

    #[doc(alias = "gtk_widget_get_device_events")]
    #[doc(alias = "get_device_events")]
    fn device_events(&self, device: &gdk::Device) -> gdk::EventMask;

    #[doc(alias = "gtk_widget_get_direction")]
    #[doc(alias = "get_direction")]
    fn direction(&self) -> TextDirection;

    #[doc(alias = "gtk_widget_get_display")]
    #[doc(alias = "get_display")]
    fn display(&self) -> gdk::Display;

    #[doc(alias = "gtk_widget_get_double_buffered")]
    #[doc(alias = "get_double_buffered")]
    fn is_double_buffered(&self) -> bool;

    #[doc(alias = "gtk_widget_get_focus_on_click")]
    #[doc(alias = "get_focus_on_click")]
    fn gets_focus_on_click(&self) -> bool;

    #[doc(alias = "gtk_widget_get_font_map")]
    #[doc(alias = "get_font_map")]
    fn font_map(&self) -> Option<pango::FontMap>;

    #[doc(alias = "gtk_widget_get_font_options")]
    #[doc(alias = "get_font_options")]
    fn font_options(&self) -> Option<cairo::FontOptions>;

    #[doc(alias = "gtk_widget_get_frame_clock")]
    #[doc(alias = "get_frame_clock")]
    fn frame_clock(&self) -> Option<gdk::FrameClock>;

    #[doc(alias = "gtk_widget_get_halign")]
    #[doc(alias = "get_halign")]
    fn halign(&self) -> Align;

    #[doc(alias = "gtk_widget_get_has_tooltip")]
    #[doc(alias = "get_has_tooltip")]
    fn has_tooltip(&self) -> bool;

    #[doc(alias = "gtk_widget_get_has_window")]
    #[doc(alias = "get_has_window")]
    fn has_window(&self) -> bool;

    #[doc(alias = "gtk_widget_get_hexpand")]
    #[doc(alias = "get_hexpand")]
    fn hexpands(&self) -> bool;

    #[doc(alias = "gtk_widget_get_hexpand_set")]
    #[doc(alias = "get_hexpand_set")]
    fn is_hexpand_set(&self) -> bool;

    #[doc(alias = "gtk_widget_get_mapped")]
    #[doc(alias = "get_mapped")]
    fn is_mapped(&self) -> bool;

    #[doc(alias = "gtk_widget_get_margin_bottom")]
    #[doc(alias = "get_margin_bottom")]
    fn margin_bottom(&self) -> i32;

    #[doc(alias = "gtk_widget_get_margin_end")]
    #[doc(alias = "get_margin_end")]
    fn margin_end(&self) -> i32;

    #[doc(alias = "gtk_widget_get_margin_start")]
    #[doc(alias = "get_margin_start")]
    fn margin_start(&self) -> i32;

    #[doc(alias = "gtk_widget_get_margin_top")]
    #[doc(alias = "get_margin_top")]
    fn margin_top(&self) -> i32;

    #[doc(alias = "gtk_widget_get_modifier_mask")]
    #[doc(alias = "get_modifier_mask")]
    fn modifier_mask(&self, intent: gdk::ModifierIntent) -> gdk::ModifierType;

    #[doc(alias = "gtk_widget_get_name")]
    #[doc(alias = "get_name")]
    fn widget_name(&self) -> glib::GString;

    #[doc(alias = "gtk_widget_get_no_show_all")]
    #[doc(alias = "get_no_show_all")]
    fn is_no_show_all(&self) -> bool;

    #[doc(alias = "gtk_widget_get_opacity")]
    #[doc(alias = "get_opacity")]
    fn opacity(&self) -> f64;

    #[doc(alias = "gtk_widget_get_pango_context")]
    #[doc(alias = "get_pango_context")]
    fn pango_context(&self) -> pango::Context;

    #[doc(alias = "gtk_widget_get_parent")]
    #[doc(alias = "get_parent")]
    #[must_use]
    fn parent(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_parent_window")]
    #[doc(alias = "get_parent_window")]
    fn parent_window(&self) -> Option<gdk::Window>;

    #[doc(alias = "gtk_widget_get_path")]
    #[doc(alias = "get_path")]
    fn path(&self) -> WidgetPath;

    #[doc(alias = "gtk_widget_get_preferred_height")]
    #[doc(alias = "get_preferred_height")]
    fn preferred_height(&self) -> (i32, i32);

    #[doc(alias = "gtk_widget_get_preferred_height_and_baseline_for_width")]
    #[doc(alias = "get_preferred_height_and_baseline_for_width")]
    fn preferred_height_and_baseline_for_width(&self, width: i32) -> (i32, i32, i32, i32);

    #[doc(alias = "gtk_widget_get_preferred_height_for_width")]
    #[doc(alias = "get_preferred_height_for_width")]
    fn preferred_height_for_width(&self, width: i32) -> (i32, i32);

    #[doc(alias = "gtk_widget_get_preferred_size")]
    #[doc(alias = "get_preferred_size")]
    fn preferred_size(&self) -> (Requisition, Requisition);

    #[doc(alias = "gtk_widget_get_preferred_width")]
    #[doc(alias = "get_preferred_width")]
    fn preferred_width(&self) -> (i32, i32);

    #[doc(alias = "gtk_widget_get_preferred_width_for_height")]
    #[doc(alias = "get_preferred_width_for_height")]
    fn preferred_width_for_height(&self, height: i32) -> (i32, i32);

    #[doc(alias = "gtk_widget_get_realized")]
    #[doc(alias = "get_realized")]
    fn is_realized(&self) -> bool;

    #[doc(alias = "gtk_widget_get_receives_default")]
    #[doc(alias = "get_receives_default")]
    fn receives_default(&self) -> bool;

    #[doc(alias = "gtk_widget_get_request_mode")]
    #[doc(alias = "get_request_mode")]
    fn request_mode(&self) -> SizeRequestMode;

    #[doc(alias = "gtk_widget_get_scale_factor")]
    #[doc(alias = "get_scale_factor")]
    fn scale_factor(&self) -> i32;

    #[doc(alias = "gtk_widget_get_screen")]
    #[doc(alias = "get_screen")]
    fn screen(&self) -> Option<gdk::Screen>;

    #[doc(alias = "gtk_widget_get_sensitive")]
    fn get_sensitive(&self) -> bool;

    #[doc(alias = "gtk_widget_get_settings")]
    #[doc(alias = "get_settings")]
    fn settings(&self) -> Option<Settings>;

    #[doc(alias = "gtk_widget_get_size_request")]
    #[doc(alias = "get_size_request")]
    fn size_request(&self) -> (i32, i32);

    #[doc(alias = "gtk_widget_get_state_flags")]
    #[doc(alias = "get_state_flags")]
    fn state_flags(&self) -> StateFlags;

    #[doc(alias = "gtk_widget_get_style_context")]
    #[doc(alias = "get_style_context")]
    fn style_context(&self) -> StyleContext;

    #[doc(alias = "gtk_widget_get_support_multidevice")]
    #[doc(alias = "get_support_multidevice")]
    fn supports_multidevice(&self) -> bool;

    #[doc(alias = "gtk_widget_get_template_child")]
    #[doc(alias = "get_template_child")]
    fn template_child(&self, widget_type: glib::types::Type, name: &str) -> Option<glib::Object>;

    #[doc(alias = "gtk_widget_get_tooltip_markup")]
    #[doc(alias = "get_tooltip_markup")]
    fn tooltip_markup(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_widget_get_tooltip_text")]
    #[doc(alias = "get_tooltip_text")]
    fn tooltip_text(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_widget_get_tooltip_window")]
    #[doc(alias = "get_tooltip_window")]
    fn tooltip_window(&self) -> Option<Window>;

    #[doc(alias = "gtk_widget_get_toplevel")]
    #[doc(alias = "get_toplevel")]
    #[must_use]
    fn toplevel(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_valign")]
    #[doc(alias = "get_valign")]
    fn valign(&self) -> Align;

    #[doc(alias = "gtk_widget_get_valign_with_baseline")]
    #[doc(alias = "get_valign_with_baseline")]
    fn valign_with_baseline(&self) -> Align;

    #[doc(alias = "gtk_widget_get_vexpand")]
    #[doc(alias = "get_vexpand")]
    fn vexpands(&self) -> bool;

    #[doc(alias = "gtk_widget_get_vexpand_set")]
    #[doc(alias = "get_vexpand_set")]
    fn is_vexpand_set(&self) -> bool;

    #[doc(alias = "gtk_widget_get_visible")]
    fn get_visible(&self) -> bool;

    #[doc(alias = "gtk_widget_get_visual")]
    #[doc(alias = "get_visual")]
    fn visual(&self) -> Option<gdk::Visual>;

    #[doc(alias = "gtk_widget_get_window")]
    #[doc(alias = "get_window")]
    fn window(&self) -> Option<gdk::Window>;

    #[doc(alias = "gtk_grab_add")]
    fn grab_add(&self);

    #[doc(alias = "gtk_widget_grab_default")]
    fn grab_default(&self);

    #[doc(alias = "gtk_widget_grab_focus")]
    fn grab_focus(&self);

    #[doc(alias = "gtk_grab_remove")]
    fn grab_remove(&self);

    #[doc(alias = "gtk_widget_has_default")]
    fn has_default(&self) -> bool;

    #[doc(alias = "gtk_widget_has_focus")]
    fn has_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_has_grab")]
    fn has_grab(&self) -> bool;

    #[doc(alias = "gtk_widget_has_screen")]
    fn has_screen(&self) -> bool;

    #[doc(alias = "gtk_widget_has_visible_focus")]
    fn has_visible_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_hide")]
    fn hide(&self);

    #[doc(alias = "gtk_widget_in_destruction")]
    fn in_destruction(&self) -> bool;

    #[doc(alias = "gtk_widget_init_template")]
    fn init_template(&self);

    #[doc(alias = "gtk_widget_input_shape_combine_region")]
    fn input_shape_combine_region(&self, region: Option<&cairo::Region>);

    #[doc(alias = "gtk_widget_insert_action_group")]
    fn insert_action_group(&self, name: &str, group: Option<&impl IsA<gio::ActionGroup>>);

    #[doc(alias = "gtk_widget_is_ancestor")]
    fn is_ancestor(&self, ancestor: &impl IsA<Widget>) -> bool;

    #[doc(alias = "gtk_widget_is_drawable")]
    fn is_drawable(&self) -> bool;

    #[doc(alias = "gtk_widget_is_focus")]
    fn is_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_is_sensitive")]
    fn is_sensitive(&self) -> bool;

    #[doc(alias = "gtk_widget_is_toplevel")]
    fn is_toplevel(&self) -> bool;

    #[doc(alias = "gtk_widget_is_visible")]
    fn is_visible(&self) -> bool;

    #[doc(alias = "gtk_widget_keynav_failed")]
    fn keynav_failed(&self, direction: DirectionType) -> bool;

    #[doc(alias = "gtk_widget_list_accel_closures")]
    fn list_accel_closures(&self) -> Vec<glib::Closure>;

    #[doc(alias = "gtk_widget_list_action_prefixes")]
    fn list_action_prefixes(&self) -> Vec<glib::GString>;

    #[doc(alias = "gtk_widget_list_mnemonic_labels")]
    fn list_mnemonic_labels(&self) -> Vec<Widget>;

    #[doc(alias = "gtk_widget_map")]
    fn map(&self);

    #[doc(alias = "gtk_widget_mnemonic_activate")]
    fn mnemonic_activate(&self, group_cycling: bool) -> bool;

    #[doc(alias = "gtk_widget_queue_allocate")]
    fn queue_allocate(&self);

    #[doc(alias = "gtk_widget_queue_compute_expand")]
    fn queue_compute_expand(&self);

    #[doc(alias = "gtk_widget_queue_draw")]
    fn queue_draw(&self);

    #[doc(alias = "gtk_widget_queue_draw_area")]
    fn queue_draw_area(&self, x: i32, y: i32, width: i32, height: i32);

    #[doc(alias = "gtk_widget_queue_draw_region")]
    fn queue_draw_region(&self, region: &cairo::Region);

    #[doc(alias = "gtk_widget_queue_resize")]
    fn queue_resize(&self);

    #[doc(alias = "gtk_widget_queue_resize_no_redraw")]
    fn queue_resize_no_redraw(&self);

    #[doc(alias = "gtk_widget_realize")]
    fn realize(&self);

    #[doc(alias = "gtk_widget_register_window")]
    fn register_window(&self, window: &gdk::Window);

    #[doc(alias = "gtk_widget_remove_accelerator")]
    fn remove_accelerator(
        &self,
        accel_group: &impl IsA<AccelGroup>,
        accel_key: u32,
        accel_mods: gdk::ModifierType,
    ) -> bool;

    #[doc(alias = "gtk_widget_remove_mnemonic_label")]
    fn remove_mnemonic_label(&self, label: &impl IsA<Widget>);

    #[doc(alias = "gtk_widget_reset_style")]
    fn reset_style(&self);

    #[doc(alias = "gtk_widget_send_focus_change")]
    fn send_focus_change(&self, event: &gdk::Event) -> bool;

    #[doc(alias = "gtk_widget_set_accel_path")]
    fn set_accel_path(&self, accel_path: Option<&str>, accel_group: Option<&impl IsA<AccelGroup>>);

    #[doc(alias = "gtk_widget_set_allocation")]
    fn set_allocation(&self, allocation: &Allocation);

    #[doc(alias = "gtk_widget_set_app_paintable")]
    fn set_app_paintable(&self, app_paintable: bool);

    #[doc(alias = "gtk_widget_set_can_default")]
    fn set_can_default(&self, can_default: bool);

    #[doc(alias = "gtk_widget_set_can_focus")]
    fn set_can_focus(&self, can_focus: bool);

    #[doc(alias = "gtk_widget_set_child_visible")]
    fn set_child_visible(&self, is_visible: bool);

    #[doc(alias = "gtk_widget_set_clip")]
    fn set_clip(&self, clip: &Allocation);

    #[doc(alias = "gtk_widget_set_device_enabled")]
    fn set_device_enabled(&self, device: &gdk::Device, enabled: bool);

    #[doc(alias = "gtk_widget_set_device_events")]
    fn set_device_events(&self, device: &gdk::Device, events: gdk::EventMask);

    #[doc(alias = "gtk_widget_set_direction")]
    fn set_direction(&self, dir: TextDirection);

    #[doc(alias = "gtk_widget_set_focus_on_click")]
    fn set_focus_on_click(&self, focus_on_click: bool);

    #[doc(alias = "gtk_widget_set_font_map")]
    fn set_font_map(&self, font_map: Option<&impl IsA<pango::FontMap>>);

    #[doc(alias = "gtk_widget_set_font_options")]
    fn set_font_options(&self, options: Option<&cairo::FontOptions>);

    #[doc(alias = "gtk_widget_set_halign")]
    fn set_halign(&self, align: Align);

    #[doc(alias = "gtk_widget_set_has_tooltip")]
    fn set_has_tooltip(&self, has_tooltip: bool);

    #[doc(alias = "gtk_widget_set_has_window")]
    fn set_has_window(&self, has_window: bool);

    #[doc(alias = "gtk_widget_set_hexpand")]
    fn set_hexpand(&self, expand: bool);

    #[doc(alias = "gtk_widget_set_hexpand_set")]
    fn set_hexpand_set(&self, set: bool);

    #[doc(alias = "gtk_widget_set_mapped")]
    fn set_mapped(&self, mapped: bool);

    #[doc(alias = "gtk_widget_set_margin_bottom")]
    fn set_margin_bottom(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_margin_end")]
    fn set_margin_end(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_margin_start")]
    fn set_margin_start(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_margin_top")]
    fn set_margin_top(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_name")]
    #[doc(alias = "set_name")]
    fn set_widget_name(&self, name: &str);

    #[doc(alias = "gtk_widget_set_no_show_all")]
    fn set_no_show_all(&self, no_show_all: bool);

    #[doc(alias = "gtk_widget_set_opacity")]
    fn set_opacity(&self, opacity: f64);

    #[doc(alias = "gtk_widget_set_parent")]
    fn set_parent(&self, parent: &impl IsA<Widget>);

    #[doc(alias = "gtk_widget_set_parent_window")]
    fn set_parent_window(&self, parent_window: &gdk::Window);

    #[doc(alias = "gtk_widget_set_realized")]
    fn set_realized(&self, realized: bool);

    #[doc(alias = "gtk_widget_set_receives_default")]
    fn set_receives_default(&self, receives_default: bool);

    #[doc(alias = "gtk_widget_set_redraw_on_allocate")]
    fn set_redraw_on_allocate(&self, redraw_on_allocate: bool);

    #[doc(alias = "gtk_widget_set_sensitive")]
    fn set_sensitive(&self, sensitive: bool);

    #[doc(alias = "gtk_widget_set_size_request")]
    fn set_size_request(&self, width: i32, height: i32);

    #[doc(alias = "gtk_widget_set_state_flags")]
    fn set_state_flags(&self, flags: StateFlags, clear: bool);

    #[doc(alias = "gtk_widget_set_support_multidevice")]
    fn set_support_multidevice(&self, support_multidevice: bool);

    #[doc(alias = "gtk_widget_set_tooltip_markup")]
    fn set_tooltip_markup(&self, markup: Option<&str>);

    #[doc(alias = "gtk_widget_set_tooltip_text")]
    fn set_tooltip_text(&self, text: Option<&str>);

    #[doc(alias = "gtk_widget_set_tooltip_window")]
    fn set_tooltip_window(&self, custom_window: Option<&impl IsA<Window>>);

    #[doc(alias = "gtk_widget_set_valign")]
    fn set_valign(&self, align: Align);

    #[doc(alias = "gtk_widget_set_vexpand")]
    fn set_vexpand(&self, expand: bool);

    #[doc(alias = "gtk_widget_set_vexpand_set")]
    fn set_vexpand_set(&self, set: bool);

    #[doc(alias = "gtk_widget_set_visible")]
    fn set_visible(&self, visible: bool);

    #[doc(alias = "gtk_widget_set_visual")]
    fn set_visual(&self, visual: Option<&gdk::Visual>);

    #[doc(alias = "gtk_widget_set_window")]
    fn set_window(&self, window: gdk::Window);

    #[doc(alias = "gtk_widget_shape_combine_region")]
    fn shape_combine_region(&self, region: Option<&cairo::Region>);

    #[doc(alias = "gtk_widget_show")]
    fn show(&self);

    #[doc(alias = "gtk_widget_show_all")]
    fn show_all(&self);

    #[doc(alias = "gtk_widget_show_now")]
    fn show_now(&self);

    #[doc(alias = "gtk_widget_size_allocate")]
    fn size_allocate(&self, allocation: &Allocation);

    #[doc(alias = "gtk_widget_size_allocate_with_baseline")]
    fn size_allocate_with_baseline(&self, allocation: &mut Allocation, baseline: i32);

    //#[doc(alias = "gtk_widget_style_get")]
    //fn style_get(&self, first_property_name: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs);

    #[doc(alias = "gtk_widget_style_get_property")]
    fn style_get_property(&self, property_name: &str) -> glib::Value;

    //#[doc(alias = "gtk_widget_style_get_valist")]
    //fn style_get_valist(&self, first_property_name: &str, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported);

    #[doc(alias = "gtk_widget_thaw_child_notify")]
    fn thaw_child_notify(&self);

    #[doc(alias = "gtk_widget_translate_coordinates")]
    fn translate_coordinates(
        &self,
        dest_widget: &impl IsA<Widget>,
        src_x: i32,
        src_y: i32,
    ) -> Option<(i32, i32)>;

    #[doc(alias = "gtk_widget_trigger_tooltip_query")]
    fn trigger_tooltip_query(&self);

    #[doc(alias = "gtk_widget_unmap")]
    fn unmap(&self);

    #[doc(alias = "gtk_widget_unparent")]
    fn unparent(&self);

    #[doc(alias = "gtk_widget_unrealize")]
    fn unrealize(&self);

    #[doc(alias = "gtk_widget_unregister_window")]
    fn unregister_window(&self, window: &gdk::Window);

    #[doc(alias = "gtk_widget_unset_state_flags")]
    fn unset_state_flags(&self, flags: StateFlags);

    #[doc(alias = "composite-child")]
    fn is_composite_child(&self) -> bool;

    fn expands(&self) -> bool;

    fn set_expand(&self, expand: bool);

    #[doc(alias = "has-default")]
    fn set_has_default(&self, has_default: bool);

    #[doc(alias = "has-focus")]
    fn set_has_focus(&self, has_focus: bool);

    #[doc(alias = "height-request")]
    fn height_request(&self) -> i32;

    #[doc(alias = "height-request")]
    fn set_height_request(&self, height_request: i32);

    #[doc(alias = "is-focus")]
    fn set_is_focus(&self, is_focus: bool);

    fn margin(&self) -> i32;

    fn set_margin(&self, margin: i32);

    #[doc(alias = "width-request")]
    fn width_request(&self) -> i32;

    #[doc(alias = "width-request")]
    fn set_width_request(&self, width_request: i32);

    #[doc(alias = "accel-closures-changed")]
    fn connect_accel_closures_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "button-press-event")]
    fn connect_button_press_event<
        F: Fn(&Self, &gdk::EventButton) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "button-release-event")]
    fn connect_button_release_event<
        F: Fn(&Self, &gdk::EventButton) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "can-activate-accel")]
    fn connect_can_activate_accel<F: Fn(&Self, u32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "child-notify")]
    fn connect_child_notify<F: Fn(&Self, &glib::ParamSpec) + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "configure-event")]
    fn connect_configure_event<F: Fn(&Self, &gdk::EventConfigure) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "damage-event")]
    fn connect_damage_event<F: Fn(&Self, &gdk::EventExpose) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "delete-event")]
    fn connect_delete_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "destroy")]
    fn connect_destroy<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "destroy-event")]
    fn connect_destroy_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "direction-changed")]
    fn connect_direction_changed<F: Fn(&Self, TextDirection) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-begin")]
    fn connect_drag_begin<F: Fn(&Self, &gdk::DragContext) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-data-delete")]
    fn connect_drag_data_delete<F: Fn(&Self, &gdk::DragContext) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-data-get")]
    fn connect_drag_data_get<F: Fn(&Self, &gdk::DragContext, &SelectionData, u32, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-data-received")]
    fn connect_drag_data_received<
        F: Fn(&Self, &gdk::DragContext, i32, i32, &SelectionData, u32, u32) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-drop")]
    fn connect_drag_drop<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-end")]
    fn connect_drag_end<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "drag-failed")]
    fn connect_drag_failed<
        F: Fn(&Self, &gdk::DragContext, DragResult) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-leave")]
    fn connect_drag_leave<F: Fn(&Self, &gdk::DragContext, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "drag-motion")]
    fn connect_drag_motion<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "draw")]
    fn connect_draw<F: Fn(&Self, &cairo::Context) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "enter-notify-event")]
    fn connect_enter_notify_event<
        F: Fn(&Self, &gdk::EventCrossing) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "event")]
    fn connect_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "event-after")]
    fn connect_event_after<F: Fn(&Self, &gdk::Event) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "focus")]
    fn connect_focus<F: Fn(&Self, DirectionType) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "focus-in-event")]
    fn connect_focus_in_event<F: Fn(&Self, &gdk::EventFocus) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "focus-out-event")]
    fn connect_focus_out_event<F: Fn(&Self, &gdk::EventFocus) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "grab-broken-event")]
    fn connect_grab_broken_event<
        F: Fn(&Self, &gdk::EventGrabBroken) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "grab-focus")]
    fn connect_grab_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_grab_focus(&self);

    #[doc(alias = "grab-notify")]
    fn connect_grab_notify<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hide")]
    fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hierarchy-changed")]
    fn connect_hierarchy_changed<F: Fn(&Self, Option<&Widget>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "key-press-event")]
    fn connect_key_press_event<F: Fn(&Self, &gdk::EventKey) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "key-release-event")]
    fn connect_key_release_event<F: Fn(&Self, &gdk::EventKey) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "keynav-failed")]
    fn connect_keynav_failed<F: Fn(&Self, DirectionType) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "leave-notify-event")]
    fn connect_leave_notify_event<
        F: Fn(&Self, &gdk::EventCrossing) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "map")]
    fn connect_map<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mnemonic-activate")]
    fn connect_mnemonic_activate<F: Fn(&Self, bool) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "motion-notify-event")]
    fn connect_motion_notify_event<
        F: Fn(&Self, &gdk::EventMotion) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "move-focus")]
    fn connect_move_focus<F: Fn(&Self, DirectionType) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_focus(&self, direction: DirectionType);

    #[doc(alias = "parent-set")]
    fn connect_parent_set<F: Fn(&Self, Option<&Widget>) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "popup-menu")]
    fn connect_popup_menu<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_popup_menu(&self) -> bool;

    #[doc(alias = "property-notify-event")]
    fn connect_property_notify_event<
        F: Fn(&Self, &gdk::EventProperty) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "proximity-in-event")]
    fn connect_proximity_in_event<
        F: Fn(&Self, &gdk::EventProximity) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "proximity-out-event")]
    fn connect_proximity_out_event<
        F: Fn(&Self, &gdk::EventProximity) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "query-tooltip")]
    fn connect_query_tooltip<F: Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "realize")]
    fn connect_realize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "screen-changed")]
    fn connect_screen_changed<F: Fn(&Self, Option<&gdk::Screen>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "scroll-event")]
    fn connect_scroll_event<F: Fn(&Self, &gdk::EventScroll) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "selection-clear-event")]
    fn connect_selection_clear_event<
        F: Fn(&Self, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "selection-get")]
    fn connect_selection_get<F: Fn(&Self, &SelectionData, u32, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "selection-notify-event")]
    fn connect_selection_notify_event<
        F: Fn(&Self, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "selection-received")]
    fn connect_selection_received<F: Fn(&Self, &SelectionData, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "selection-request-event")]
    fn connect_selection_request_event<
        F: Fn(&Self, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "show")]
    fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-help")]
    fn connect_show_help<F: Fn(&Self, WidgetHelpType) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_show_help(&self, help_type: WidgetHelpType) -> bool;

    #[doc(alias = "size-allocate")]
    fn connect_size_allocate<F: Fn(&Self, &Allocation) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "state-flags-changed")]
    fn connect_state_flags_changed<F: Fn(&Self, StateFlags) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "style-updated")]
    fn connect_style_updated<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "touch-event")]
    fn connect_touch_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "unmap")]
    fn connect_unmap<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "unrealize")]
    fn connect_unrealize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "window-state-event")]
    fn connect_window_state_event<
        F: Fn(&Self, &gdk::EventWindowState) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "app-paintable")]
    fn connect_app_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-default")]
    fn connect_can_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-focus")]
    fn connect_can_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "composite-child")]
    fn connect_composite_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "events")]
    fn connect_events_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "expand")]
    fn connect_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "focus-on-click")]
    fn connect_focus_on_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "halign")]
    fn connect_halign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-default")]
    fn connect_has_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-focus")]
    fn connect_has_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-tooltip")]
    fn connect_has_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "height-request")]
    fn connect_height_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hexpand")]
    fn connect_hexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hexpand-set")]
    fn connect_hexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "is-focus")]
    fn connect_is_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin")]
    fn connect_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-bottom")]
    fn connect_margin_bottom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-end")]
    fn connect_margin_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-start")]
    fn connect_margin_start_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-top")]
    fn connect_margin_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "name")]
    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "no-show-all")]
    fn connect_no_show_all_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "opacity")]
    fn connect_opacity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "parent")]
    fn connect_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "receives-default")]
    fn connect_receives_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale-factor")]
    fn connect_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "sensitive")]
    fn connect_sensitive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tooltip-markup")]
    fn connect_tooltip_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tooltip-text")]
    fn connect_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "valign")]
    fn connect_valign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vexpand")]
    fn connect_vexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vexpand-set")]
    fn connect_vexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "visible")]
    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "width-request")]
    fn connect_width_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "window")]
    fn connect_window_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Widget>> WidgetExt for O {
    fn activate(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_activate(self.as_ref().to_glib_none().0)) }
    }

    fn add_accelerator(
        &self,
        accel_signal: &str,
        accel_group: &impl IsA<AccelGroup>,
        accel_key: u32,
        accel_mods: gdk::ModifierType,
        accel_flags: AccelFlags,
    ) {
        unsafe {
            ffi::gtk_widget_add_accelerator(
                self.as_ref().to_glib_none().0,
                accel_signal.to_glib_none().0,
                accel_group.as_ref().to_glib_none().0,
                accel_key,
                accel_mods.into_glib(),
                accel_flags.into_glib(),
            );
        }
    }

    fn add_device_events(&self, device: &gdk::Device, events: gdk::EventMask) {
        unsafe {
            ffi::gtk_widget_add_device_events(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                events.into_glib(),
            );
        }
    }

    fn add_mnemonic_label(&self, label: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_add_mnemonic_label(
                self.as_ref().to_glib_none().0,
                label.as_ref().to_glib_none().0,
            );
        }
    }

    fn can_activate_accel(&self, signal_id: u32) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_can_activate_accel(
                self.as_ref().to_glib_none().0,
                signal_id,
            ))
        }
    }

    fn child_focus(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_child_focus(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    fn child_notify(&self, child_property: &str) {
        unsafe {
            ffi::gtk_widget_child_notify(
                self.as_ref().to_glib_none().0,
                child_property.to_glib_none().0,
            );
        }
    }

    fn compute_expand(&self, orientation: Orientation) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_compute_expand(
                self.as_ref().to_glib_none().0,
                orientation.into_glib(),
            ))
        }
    }

    fn create_pango_context(&self) -> pango::Context {
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn create_pango_layout(&self, text: Option<&str>) -> pango::Layout {
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_layout(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
            ))
        }
    }

    //fn destroyed(&self, widget_pointer: impl IsA<Widget>) {
    //    unsafe { TODO: call ffi:gtk_widget_destroyed() }
    //}

    fn device_is_shadowed(&self, device: &gdk::Device) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_device_is_shadowed(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
            ))
        }
    }

    fn drag_begin_with_coordinates(
        &self,
        targets: &TargetList,
        actions: gdk::DragAction,
        button: i32,
        event: Option<&gdk::Event>,
        x: i32,
        y: i32,
    ) -> Option<gdk::DragContext> {
        unsafe {
            from_glib_none(ffi::gtk_drag_begin_with_coordinates(
                self.as_ref().to_glib_none().0,
                targets.to_glib_none().0,
                actions.into_glib(),
                button,
                mut_override(event.to_glib_none().0),
                x,
                y,
            ))
        }
    }

    fn drag_check_threshold(
        &self,
        start_x: i32,
        start_y: i32,
        current_x: i32,
        current_y: i32,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_drag_check_threshold(
                self.as_ref().to_glib_none().0,
                start_x,
                start_y,
                current_x,
                current_y,
            ))
        }
    }

    fn drag_dest_add_image_targets(&self) {
        unsafe {
            ffi::gtk_drag_dest_add_image_targets(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_dest_add_text_targets(&self) {
        unsafe {
            ffi::gtk_drag_dest_add_text_targets(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_dest_add_uri_targets(&self) {
        unsafe {
            ffi::gtk_drag_dest_add_uri_targets(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_dest_find_target(
        &self,
        context: &gdk::DragContext,
        target_list: Option<&TargetList>,
    ) -> Option<gdk::Atom> {
        unsafe {
            from_glib_none(ffi::gtk_drag_dest_find_target(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
                target_list.to_glib_none().0,
            ))
        }
    }

    fn drag_dest_get_target_list(&self) -> Option<TargetList> {
        unsafe {
            from_glib_none(ffi::gtk_drag_dest_get_target_list(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn drag_dest_get_track_motion(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_drag_dest_get_track_motion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn drag_dest_set_target_list(&self, target_list: Option<&TargetList>) {
        unsafe {
            ffi::gtk_drag_dest_set_target_list(
                self.as_ref().to_glib_none().0,
                target_list.to_glib_none().0,
            );
        }
    }

    fn drag_dest_set_track_motion(&self, track_motion: bool) {
        unsafe {
            ffi::gtk_drag_dest_set_track_motion(
                self.as_ref().to_glib_none().0,
                track_motion.into_glib(),
            );
        }
    }

    fn drag_dest_unset(&self) {
        unsafe {
            ffi::gtk_drag_dest_unset(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_get_data(&self, context: &gdk::DragContext, target: &gdk::Atom, time_: u32) {
        unsafe {
            ffi::gtk_drag_get_data(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
                target.to_glib_none().0,
                time_,
            );
        }
    }

    fn drag_highlight(&self) {
        unsafe {
            ffi::gtk_drag_highlight(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_source_add_image_targets(&self) {
        unsafe {
            ffi::gtk_drag_source_add_image_targets(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_source_add_text_targets(&self) {
        unsafe {
            ffi::gtk_drag_source_add_text_targets(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_source_add_uri_targets(&self) {
        unsafe {
            ffi::gtk_drag_source_add_uri_targets(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_source_get_target_list(&self) -> Option<TargetList> {
        unsafe {
            from_glib_none(ffi::gtk_drag_source_get_target_list(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn drag_source_set_icon_gicon(&self, icon: &impl IsA<gio::Icon>) {
        unsafe {
            ffi::gtk_drag_source_set_icon_gicon(
                self.as_ref().to_glib_none().0,
                icon.as_ref().to_glib_none().0,
            );
        }
    }

    fn drag_source_set_icon_name(&self, icon_name: &str) {
        unsafe {
            ffi::gtk_drag_source_set_icon_name(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
            );
        }
    }

    fn drag_source_set_icon_pixbuf(&self, pixbuf: &gdk_pixbuf::Pixbuf) {
        unsafe {
            ffi::gtk_drag_source_set_icon_pixbuf(
                self.as_ref().to_glib_none().0,
                pixbuf.to_glib_none().0,
            );
        }
    }

    fn drag_source_set_target_list(&self, target_list: Option<&TargetList>) {
        unsafe {
            ffi::gtk_drag_source_set_target_list(
                self.as_ref().to_glib_none().0,
                target_list.to_glib_none().0,
            );
        }
    }

    fn drag_source_unset(&self) {
        unsafe {
            ffi::gtk_drag_source_unset(self.as_ref().to_glib_none().0);
        }
    }

    fn drag_unhighlight(&self) {
        unsafe {
            ffi::gtk_drag_unhighlight(self.as_ref().to_glib_none().0);
        }
    }

    fn draw(&self, cr: &cairo::Context) {
        unsafe {
            ffi::gtk_widget_draw(
                self.as_ref().to_glib_none().0,
                mut_override(cr.to_glib_none().0),
            );
        }
    }

    fn error_bell(&self) {
        unsafe {
            ffi::gtk_widget_error_bell(self.as_ref().to_glib_none().0);
        }
    }

    fn event(&self, event: &gdk::Event) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_event(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    fn freeze_child_notify(&self) {
        unsafe {
            ffi::gtk_widget_freeze_child_notify(self.as_ref().to_glib_none().0);
        }
    }

    fn accessible(&self) -> Option<atk::Object> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_accessible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn action_group(&self, prefix: &str) -> Option<gio::ActionGroup> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_action_group(
                self.as_ref().to_glib_none().0,
                prefix.to_glib_none().0,
            ))
        }
    }

    fn allocated_baseline(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_baseline(self.as_ref().to_glib_none().0) }
    }

    fn allocated_height(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_height(self.as_ref().to_glib_none().0) }
    }

    fn allocated_size(&self) -> (Allocation, i32) {
        unsafe {
            let mut allocation = Allocation::uninitialized();
            let mut baseline = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_allocated_size(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none_mut().0,
                baseline.as_mut_ptr(),
            );
            (allocation, baseline.assume_init())
        }
    }

    fn allocated_width(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_width(self.as_ref().to_glib_none().0) }
    }

    fn allocation(&self) -> Allocation {
        unsafe {
            let mut allocation = Allocation::uninitialized();
            ffi::gtk_widget_get_allocation(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none_mut().0,
            );
            allocation
        }
    }

    fn ancestor(&self, widget_type: glib::types::Type) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_ancestor(
                self.as_ref().to_glib_none().0,
                widget_type.into_glib(),
            ))
        }
    }

    fn is_app_paintable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_app_paintable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn can_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn can_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_child_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_child_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn clip(&self) -> Allocation {
        unsafe {
            let mut clip = Allocation::uninitialized();
            ffi::gtk_widget_get_clip(self.as_ref().to_glib_none().0, clip.to_glib_none_mut().0);
            clip
        }
    }

    fn clipboard(&self, selection: &gdk::Atom) -> Clipboard {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_clipboard(
                self.as_ref().to_glib_none().0,
                selection.to_glib_none().0,
            ))
        }
    }

    fn device_is_enabled(&self, device: &gdk::Device) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_device_enabled(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
            ))
        }
    }

    fn device_events(&self, device: &gdk::Device) -> gdk::EventMask {
        unsafe {
            from_glib(ffi::gtk_widget_get_device_events(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
            ))
        }
    }

    fn direction(&self) -> TextDirection {
        unsafe {
            from_glib(ffi::gtk_widget_get_direction(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn display(&self) -> gdk::Display {
        unsafe { from_glib_none(ffi::gtk_widget_get_display(self.as_ref().to_glib_none().0)) }
    }

    fn is_double_buffered(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_double_buffered(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn gets_focus_on_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_focus_on_click(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn font_map(&self) -> Option<pango::FontMap> {
        unsafe { from_glib_none(ffi::gtk_widget_get_font_map(self.as_ref().to_glib_none().0)) }
    }

    fn font_options(&self) -> Option<cairo::FontOptions> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_font_options(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn frame_clock(&self) -> Option<gdk::FrameClock> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_frame_clock(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn halign(&self) -> Align {
        unsafe { from_glib(ffi::gtk_widget_get_halign(self.as_ref().to_glib_none().0)) }
    }

    fn has_tooltip(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_has_tooltip(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_window(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_has_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hexpands(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_hexpand(self.as_ref().to_glib_none().0)) }
    }

    fn is_hexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_hexpand_set(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_mapped(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_mapped(self.as_ref().to_glib_none().0)) }
    }

    fn margin_bottom(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_bottom(self.as_ref().to_glib_none().0) }
    }

    fn margin_end(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_end(self.as_ref().to_glib_none().0) }
    }

    fn margin_start(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_start(self.as_ref().to_glib_none().0) }
    }

    fn margin_top(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_top(self.as_ref().to_glib_none().0) }
    }

    fn modifier_mask(&self, intent: gdk::ModifierIntent) -> gdk::ModifierType {
        unsafe {
            from_glib(ffi::gtk_widget_get_modifier_mask(
                self.as_ref().to_glib_none().0,
                intent.into_glib(),
            ))
        }
    }

    fn widget_name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_widget_get_name(self.as_ref().to_glib_none().0)) }
    }

    fn is_no_show_all(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_no_show_all(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn opacity(&self) -> f64 {
        unsafe { ffi::gtk_widget_get_opacity(self.as_ref().to_glib_none().0) }
    }

    fn pango_context(&self) -> pango::Context {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_pango_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn parent(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_widget_get_parent(self.as_ref().to_glib_none().0)) }
    }

    fn parent_window(&self) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_parent_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn path(&self) -> WidgetPath {
        unsafe { from_glib_none(ffi::gtk_widget_get_path(self.as_ref().to_glib_none().0)) }
    }

    fn preferred_height(&self) -> (i32, i32) {
        unsafe {
            let mut minimum_height = mem::MaybeUninit::uninit();
            let mut natural_height = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_preferred_height(
                self.as_ref().to_glib_none().0,
                minimum_height.as_mut_ptr(),
                natural_height.as_mut_ptr(),
            );
            (minimum_height.assume_init(), natural_height.assume_init())
        }
    }

    fn preferred_height_and_baseline_for_width(&self, width: i32) -> (i32, i32, i32, i32) {
        unsafe {
            let mut minimum_height = mem::MaybeUninit::uninit();
            let mut natural_height = mem::MaybeUninit::uninit();
            let mut minimum_baseline = mem::MaybeUninit::uninit();
            let mut natural_baseline = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_preferred_height_and_baseline_for_width(
                self.as_ref().to_glib_none().0,
                width,
                minimum_height.as_mut_ptr(),
                natural_height.as_mut_ptr(),
                minimum_baseline.as_mut_ptr(),
                natural_baseline.as_mut_ptr(),
            );
            (
                minimum_height.assume_init(),
                natural_height.assume_init(),
                minimum_baseline.assume_init(),
                natural_baseline.assume_init(),
            )
        }
    }

    fn preferred_height_for_width(&self, width: i32) -> (i32, i32) {
        unsafe {
            let mut minimum_height = mem::MaybeUninit::uninit();
            let mut natural_height = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_preferred_height_for_width(
                self.as_ref().to_glib_none().0,
                width,
                minimum_height.as_mut_ptr(),
                natural_height.as_mut_ptr(),
            );
            (minimum_height.assume_init(), natural_height.assume_init())
        }
    }

    fn preferred_size(&self) -> (Requisition, Requisition) {
        unsafe {
            let mut minimum_size = Requisition::uninitialized();
            let mut natural_size = Requisition::uninitialized();
            ffi::gtk_widget_get_preferred_size(
                self.as_ref().to_glib_none().0,
                minimum_size.to_glib_none_mut().0,
                natural_size.to_glib_none_mut().0,
            );
            (minimum_size, natural_size)
        }
    }

    fn preferred_width(&self) -> (i32, i32) {
        unsafe {
            let mut minimum_width = mem::MaybeUninit::uninit();
            let mut natural_width = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_preferred_width(
                self.as_ref().to_glib_none().0,
                minimum_width.as_mut_ptr(),
                natural_width.as_mut_ptr(),
            );
            (minimum_width.assume_init(), natural_width.assume_init())
        }
    }

    fn preferred_width_for_height(&self, height: i32) -> (i32, i32) {
        unsafe {
            let mut minimum_width = mem::MaybeUninit::uninit();
            let mut natural_width = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_preferred_width_for_height(
                self.as_ref().to_glib_none().0,
                height,
                minimum_width.as_mut_ptr(),
                natural_width.as_mut_ptr(),
            );
            (minimum_width.assume_init(), natural_width.assume_init())
        }
    }

    fn is_realized(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_realized(self.as_ref().to_glib_none().0)) }
    }

    fn receives_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_receives_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn request_mode(&self) -> SizeRequestMode {
        unsafe {
            from_glib(ffi::gtk_widget_get_request_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn scale_factor(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_scale_factor(self.as_ref().to_glib_none().0) }
    }

    fn screen(&self) -> Option<gdk::Screen> {
        unsafe { from_glib_none(ffi::gtk_widget_get_screen(self.as_ref().to_glib_none().0)) }
    }

    fn get_sensitive(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_sensitive(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn settings(&self) -> Option<Settings> {
        unsafe { from_glib_none(ffi::gtk_widget_get_settings(self.as_ref().to_glib_none().0)) }
    }

    fn size_request(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_size_request(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (width.assume_init(), height.assume_init())
        }
    }

    fn state_flags(&self) -> StateFlags {
        unsafe {
            from_glib(ffi::gtk_widget_get_state_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn style_context(&self) -> StyleContext {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_style_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn supports_multidevice(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_support_multidevice(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn template_child(&self, widget_type: glib::types::Type, name: &str) -> Option<glib::Object> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_template_child(
                self.as_ref().to_glib_none().0,
                widget_type.into_glib(),
                name.to_glib_none().0,
            ))
        }
    }

    fn tooltip_markup(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_widget_get_tooltip_markup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tooltip_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_widget_get_tooltip_text(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tooltip_window(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_tooltip_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn toplevel(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_widget_get_toplevel(self.as_ref().to_glib_none().0)) }
    }

    fn valign(&self) -> Align {
        unsafe { from_glib(ffi::gtk_widget_get_valign(self.as_ref().to_glib_none().0)) }
    }

    fn valign_with_baseline(&self) -> Align {
        unsafe {
            from_glib(ffi::gtk_widget_get_valign_with_baseline(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn vexpands(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_vexpand(self.as_ref().to_glib_none().0)) }
    }

    fn is_vexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_vexpand_set(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_visible(self.as_ref().to_glib_none().0)) }
    }

    fn visual(&self) -> Option<gdk::Visual> {
        unsafe { from_glib_none(ffi::gtk_widget_get_visual(self.as_ref().to_glib_none().0)) }
    }

    fn window(&self) -> Option<gdk::Window> {
        unsafe { from_glib_none(ffi::gtk_widget_get_window(self.as_ref().to_glib_none().0)) }
    }

    fn grab_add(&self) {
        unsafe {
            ffi::gtk_grab_add(self.as_ref().to_glib_none().0);
        }
    }

    fn grab_default(&self) {
        unsafe {
            ffi::gtk_widget_grab_default(self.as_ref().to_glib_none().0);
        }
    }

    fn grab_focus(&self) {
        unsafe {
            ffi::gtk_widget_grab_focus(self.as_ref().to_glib_none().0);
        }
    }

    fn grab_remove(&self) {
        unsafe {
            ffi::gtk_grab_remove(self.as_ref().to_glib_none().0);
        }
    }

    fn has_default(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_default(self.as_ref().to_glib_none().0)) }
    }

    fn has_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_focus(self.as_ref().to_glib_none().0)) }
    }

    fn has_grab(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_grab(self.as_ref().to_glib_none().0)) }
    }

    fn has_screen(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_screen(self.as_ref().to_glib_none().0)) }
    }

    fn has_visible_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_visible_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hide(&self) {
        unsafe {
            ffi::gtk_widget_hide(self.as_ref().to_glib_none().0);
        }
    }

    fn in_destruction(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_in_destruction(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn init_template(&self) {
        unsafe {
            ffi::gtk_widget_init_template(self.as_ref().to_glib_none().0);
        }
    }

    fn input_shape_combine_region(&self, region: Option<&cairo::Region>) {
        unsafe {
            ffi::gtk_widget_input_shape_combine_region(
                self.as_ref().to_glib_none().0,
                mut_override(region.to_glib_none().0),
            );
        }
    }

    fn insert_action_group(&self, name: &str, group: Option<&impl IsA<gio::ActionGroup>>) {
        unsafe {
            ffi::gtk_widget_insert_action_group(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                group.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn is_ancestor(&self, ancestor: &impl IsA<Widget>) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_ancestor(
                self.as_ref().to_glib_none().0,
                ancestor.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_drawable(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_drawable(self.as_ref().to_glib_none().0)) }
    }

    fn is_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_focus(self.as_ref().to_glib_none().0)) }
    }

    fn is_sensitive(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_sensitive(self.as_ref().to_glib_none().0)) }
    }

    fn is_toplevel(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_toplevel(self.as_ref().to_glib_none().0)) }
    }

    fn is_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_visible(self.as_ref().to_glib_none().0)) }
    }

    fn keynav_failed(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_keynav_failed(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    fn list_accel_closures(&self) -> Vec<glib::Closure> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_accel_closures(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_action_prefixes(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_action_prefixes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_mnemonic_labels(&self) -> Vec<Widget> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_mnemonic_labels(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn map(&self) {
        unsafe {
            ffi::gtk_widget_map(self.as_ref().to_glib_none().0);
        }
    }

    fn mnemonic_activate(&self, group_cycling: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_mnemonic_activate(
                self.as_ref().to_glib_none().0,
                group_cycling.into_glib(),
            ))
        }
    }

    fn queue_allocate(&self) {
        unsafe {
            ffi::gtk_widget_queue_allocate(self.as_ref().to_glib_none().0);
        }
    }

    fn queue_compute_expand(&self) {
        unsafe {
            ffi::gtk_widget_queue_compute_expand(self.as_ref().to_glib_none().0);
        }
    }

    fn queue_draw(&self) {
        unsafe {
            ffi::gtk_widget_queue_draw(self.as_ref().to_glib_none().0);
        }
    }

    fn queue_draw_area(&self, x: i32, y: i32, width: i32, height: i32) {
        unsafe {
            ffi::gtk_widget_queue_draw_area(self.as_ref().to_glib_none().0, x, y, width, height);
        }
    }

    fn queue_draw_region(&self, region: &cairo::Region) {
        unsafe {
            ffi::gtk_widget_queue_draw_region(
                self.as_ref().to_glib_none().0,
                region.to_glib_none().0,
            );
        }
    }

    fn queue_resize(&self) {
        unsafe {
            ffi::gtk_widget_queue_resize(self.as_ref().to_glib_none().0);
        }
    }

    fn queue_resize_no_redraw(&self) {
        unsafe {
            ffi::gtk_widget_queue_resize_no_redraw(self.as_ref().to_glib_none().0);
        }
    }

    fn realize(&self) {
        unsafe {
            ffi::gtk_widget_realize(self.as_ref().to_glib_none().0);
        }
    }

    fn register_window(&self, window: &gdk::Window) {
        unsafe {
            ffi::gtk_widget_register_window(
                self.as_ref().to_glib_none().0,
                window.to_glib_none().0,
            );
        }
    }

    fn remove_accelerator(
        &self,
        accel_group: &impl IsA<AccelGroup>,
        accel_key: u32,
        accel_mods: gdk::ModifierType,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_remove_accelerator(
                self.as_ref().to_glib_none().0,
                accel_group.as_ref().to_glib_none().0,
                accel_key,
                accel_mods.into_glib(),
            ))
        }
    }

    fn remove_mnemonic_label(&self, label: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_remove_mnemonic_label(
                self.as_ref().to_glib_none().0,
                label.as_ref().to_glib_none().0,
            );
        }
    }

    fn reset_style(&self) {
        unsafe {
            ffi::gtk_widget_reset_style(self.as_ref().to_glib_none().0);
        }
    }

    fn send_focus_change(&self, event: &gdk::Event) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_send_focus_change(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    fn set_accel_path(&self, accel_path: Option<&str>, accel_group: Option<&impl IsA<AccelGroup>>) {
        unsafe {
            ffi::gtk_widget_set_accel_path(
                self.as_ref().to_glib_none().0,
                accel_path.to_glib_none().0,
                accel_group.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_allocation(&self, allocation: &Allocation) {
        unsafe {
            ffi::gtk_widget_set_allocation(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none().0,
            );
        }
    }

    fn set_app_paintable(&self, app_paintable: bool) {
        unsafe {
            ffi::gtk_widget_set_app_paintable(
                self.as_ref().to_glib_none().0,
                app_paintable.into_glib(),
            );
        }
    }

    fn set_can_default(&self, can_default: bool) {
        unsafe {
            ffi::gtk_widget_set_can_default(
                self.as_ref().to_glib_none().0,
                can_default.into_glib(),
            );
        }
    }

    fn set_can_focus(&self, can_focus: bool) {
        unsafe {
            ffi::gtk_widget_set_can_focus(self.as_ref().to_glib_none().0, can_focus.into_glib());
        }
    }

    fn set_child_visible(&self, is_visible: bool) {
        unsafe {
            ffi::gtk_widget_set_child_visible(
                self.as_ref().to_glib_none().0,
                is_visible.into_glib(),
            );
        }
    }

    fn set_clip(&self, clip: &Allocation) {
        unsafe {
            ffi::gtk_widget_set_clip(self.as_ref().to_glib_none().0, clip.to_glib_none().0);
        }
    }

    fn set_device_enabled(&self, device: &gdk::Device, enabled: bool) {
        unsafe {
            ffi::gtk_widget_set_device_enabled(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    fn set_device_events(&self, device: &gdk::Device, events: gdk::EventMask) {
        unsafe {
            ffi::gtk_widget_set_device_events(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                events.into_glib(),
            );
        }
    }

    fn set_direction(&self, dir: TextDirection) {
        unsafe {
            ffi::gtk_widget_set_direction(self.as_ref().to_glib_none().0, dir.into_glib());
        }
    }

    fn set_focus_on_click(&self, focus_on_click: bool) {
        unsafe {
            ffi::gtk_widget_set_focus_on_click(
                self.as_ref().to_glib_none().0,
                focus_on_click.into_glib(),
            );
        }
    }

    fn set_font_map(&self, font_map: Option<&impl IsA<pango::FontMap>>) {
        unsafe {
            ffi::gtk_widget_set_font_map(
                self.as_ref().to_glib_none().0,
                font_map.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_font_options(&self, options: Option<&cairo::FontOptions>) {
        unsafe {
            ffi::gtk_widget_set_font_options(
                self.as_ref().to_glib_none().0,
                options.to_glib_none().0,
            );
        }
    }

    fn set_halign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_halign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    fn set_has_tooltip(&self, has_tooltip: bool) {
        unsafe {
            ffi::gtk_widget_set_has_tooltip(
                self.as_ref().to_glib_none().0,
                has_tooltip.into_glib(),
            );
        }
    }

    fn set_has_window(&self, has_window: bool) {
        unsafe {
            ffi::gtk_widget_set_has_window(self.as_ref().to_glib_none().0, has_window.into_glib());
        }
    }

    fn set_hexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    fn set_hexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand_set(self.as_ref().to_glib_none().0, set.into_glib());
        }
    }

    fn set_mapped(&self, mapped: bool) {
        unsafe {
            ffi::gtk_widget_set_mapped(self.as_ref().to_glib_none().0, mapped.into_glib());
        }
    }

    fn set_margin_bottom(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_bottom(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_margin_end(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_end(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_margin_start(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_start(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_margin_top(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_top(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_widget_name(&self, name: &str) {
        unsafe {
            ffi::gtk_widget_set_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_no_show_all(&self, no_show_all: bool) {
        unsafe {
            ffi::gtk_widget_set_no_show_all(
                self.as_ref().to_glib_none().0,
                no_show_all.into_glib(),
            );
        }
    }

    fn set_opacity(&self, opacity: f64) {
        unsafe {
            ffi::gtk_widget_set_opacity(self.as_ref().to_glib_none().0, opacity);
        }
    }

    fn set_parent(&self, parent: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_set_parent(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_parent_window(&self, parent_window: &gdk::Window) {
        unsafe {
            ffi::gtk_widget_set_parent_window(
                self.as_ref().to_glib_none().0,
                parent_window.to_glib_none().0,
            );
        }
    }

    fn set_realized(&self, realized: bool) {
        unsafe {
            ffi::gtk_widget_set_realized(self.as_ref().to_glib_none().0, realized.into_glib());
        }
    }

    fn set_receives_default(&self, receives_default: bool) {
        unsafe {
            ffi::gtk_widget_set_receives_default(
                self.as_ref().to_glib_none().0,
                receives_default.into_glib(),
            );
        }
    }

    fn set_redraw_on_allocate(&self, redraw_on_allocate: bool) {
        unsafe {
            ffi::gtk_widget_set_redraw_on_allocate(
                self.as_ref().to_glib_none().0,
                redraw_on_allocate.into_glib(),
            );
        }
    }

    fn set_sensitive(&self, sensitive: bool) {
        unsafe {
            ffi::gtk_widget_set_sensitive(self.as_ref().to_glib_none().0, sensitive.into_glib());
        }
    }

    fn set_size_request(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_widget_set_size_request(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn set_state_flags(&self, flags: StateFlags, clear: bool) {
        unsafe {
            ffi::gtk_widget_set_state_flags(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                clear.into_glib(),
            );
        }
    }

    fn set_support_multidevice(&self, support_multidevice: bool) {
        unsafe {
            ffi::gtk_widget_set_support_multidevice(
                self.as_ref().to_glib_none().0,
                support_multidevice.into_glib(),
            );
        }
    }

    fn set_tooltip_markup(&self, markup: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_tooltip_markup(
                self.as_ref().to_glib_none().0,
                markup.to_glib_none().0,
            );
        }
    }

    fn set_tooltip_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_tooltip_text(self.as_ref().to_glib_none().0, text.to_glib_none().0);
        }
    }

    fn set_tooltip_window(&self, custom_window: Option<&impl IsA<Window>>) {
        unsafe {
            ffi::gtk_widget_set_tooltip_window(
                self.as_ref().to_glib_none().0,
                custom_window.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_valign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_valign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    fn set_vexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    fn set_vexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand_set(self.as_ref().to_glib_none().0, set.into_glib());
        }
    }

    fn set_visible(&self, visible: bool) {
        unsafe {
            ffi::gtk_widget_set_visible(self.as_ref().to_glib_none().0, visible.into_glib());
        }
    }

    fn set_visual(&self, visual: Option<&gdk::Visual>) {
        unsafe {
            ffi::gtk_widget_set_visual(self.as_ref().to_glib_none().0, visual.to_glib_none().0);
        }
    }

    fn set_window(&self, window: gdk::Window) {
        unsafe {
            ffi::gtk_widget_set_window(self.as_ref().to_glib_none().0, window.into_glib_ptr());
        }
    }

    fn shape_combine_region(&self, region: Option<&cairo::Region>) {
        unsafe {
            ffi::gtk_widget_shape_combine_region(
                self.as_ref().to_glib_none().0,
                mut_override(region.to_glib_none().0),
            );
        }
    }

    fn show(&self) {
        unsafe {
            ffi::gtk_widget_show(self.as_ref().to_glib_none().0);
        }
    }

    fn show_all(&self) {
        unsafe {
            ffi::gtk_widget_show_all(self.as_ref().to_glib_none().0);
        }
    }

    fn show_now(&self) {
        unsafe {
            ffi::gtk_widget_show_now(self.as_ref().to_glib_none().0);
        }
    }

    fn size_allocate(&self, allocation: &Allocation) {
        unsafe {
            ffi::gtk_widget_size_allocate(
                self.as_ref().to_glib_none().0,
                mut_override(allocation.to_glib_none().0),
            );
        }
    }

    fn size_allocate_with_baseline(&self, allocation: &mut Allocation, baseline: i32) {
        unsafe {
            ffi::gtk_widget_size_allocate_with_baseline(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none_mut().0,
                baseline,
            );
        }
    }

    //fn style_get(&self, first_property_name: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) {
    //    unsafe { TODO: call ffi:gtk_widget_style_get() }
    //}

    fn style_get_property(&self, property_name: &str) -> glib::Value {
        unsafe {
            let mut value = glib::Value::uninitialized();
            ffi::gtk_widget_style_get_property(
                self.as_ref().to_glib_none().0,
                property_name.to_glib_none().0,
                value.to_glib_none_mut().0,
            );
            value
        }
    }

    //fn style_get_valist(&self, first_property_name: &str, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported) {
    //    unsafe { TODO: call ffi:gtk_widget_style_get_valist() }
    //}

    fn thaw_child_notify(&self) {
        unsafe {
            ffi::gtk_widget_thaw_child_notify(self.as_ref().to_glib_none().0);
        }
    }

    fn translate_coordinates(
        &self,
        dest_widget: &impl IsA<Widget>,
        src_x: i32,
        src_y: i32,
    ) -> Option<(i32, i32)> {
        unsafe {
            let mut dest_x = mem::MaybeUninit::uninit();
            let mut dest_y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_widget_translate_coordinates(
                self.as_ref().to_glib_none().0,
                dest_widget.as_ref().to_glib_none().0,
                src_x,
                src_y,
                dest_x.as_mut_ptr(),
                dest_y.as_mut_ptr(),
            ));
            if ret {
                Some((dest_x.assume_init(), dest_y.assume_init()))
            } else {
                None
            }
        }
    }

    fn trigger_tooltip_query(&self) {
        unsafe {
            ffi::gtk_widget_trigger_tooltip_query(self.as_ref().to_glib_none().0);
        }
    }

    fn unmap(&self) {
        unsafe {
            ffi::gtk_widget_unmap(self.as_ref().to_glib_none().0);
        }
    }

    fn unparent(&self) {
        unsafe {
            ffi::gtk_widget_unparent(self.as_ref().to_glib_none().0);
        }
    }

    fn unrealize(&self) {
        unsafe {
            ffi::gtk_widget_unrealize(self.as_ref().to_glib_none().0);
        }
    }

    fn unregister_window(&self, window: &gdk::Window) {
        unsafe {
            ffi::gtk_widget_unregister_window(
                self.as_ref().to_glib_none().0,
                window.to_glib_none().0,
            );
        }
    }

    fn unset_state_flags(&self, flags: StateFlags) {
        unsafe {
            ffi::gtk_widget_unset_state_flags(self.as_ref().to_glib_none().0, flags.into_glib());
        }
    }

    fn is_composite_child(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "composite-child")
    }

    fn expands(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "expand")
    }

    fn set_expand(&self, expand: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "expand", expand)
    }

    fn set_has_default(&self, has_default: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "has-default", has_default)
    }

    fn set_has_focus(&self, has_focus: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "has-focus", has_focus)
    }

    fn height_request(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "height-request")
    }

    fn set_height_request(&self, height_request: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "height-request", height_request)
    }

    fn set_is_focus(&self, is_focus: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "is-focus", is_focus)
    }

    fn margin(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "margin")
    }

    fn set_margin(&self, margin: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "margin", margin)
    }

    fn width_request(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "width-request")
    }

    fn set_width_request(&self, width_request: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "width-request", width_request)
    }

    fn connect_accel_closures_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn accel_closures_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"accel-closures-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    accel_closures_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_button_press_event<
        F: Fn(&Self, &gdk::EventButton) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn button_press_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventButton) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventButton,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"button-press-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    button_press_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_button_release_event<
        F: Fn(&Self, &gdk::EventButton) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn button_release_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventButton) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventButton,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"button-release-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    button_release_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_activate_accel<F: Fn(&Self, u32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn can_activate_accel_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, u32) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            signal_id: libc::c_uint,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref(), signal_id).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"can-activate-accel\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    can_activate_accel_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_child_notify<F: Fn(&Self, &glib::ParamSpec) + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn child_notify_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &glib::ParamSpec) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            child_property: *mut glib::gobject_ffi::GParamSpec,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(child_property),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            let detailed_signal_name = detail.map(|name| format!("child-notify::{name}\0"));
            let signal_name: &[u8] = detailed_signal_name
                .as_ref()
                .map_or(&b"child-notify\0"[..], |n| n.as_bytes());
            connect_raw(
                self.as_ptr() as *mut _,
                signal_name.as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    child_notify_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_configure_event<F: Fn(&Self, &gdk::EventConfigure) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn configure_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventConfigure) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventConfigure,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"configure-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    configure_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_damage_event<F: Fn(&Self, &gdk::EventExpose) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn damage_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventExpose) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventExpose,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"damage-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    damage_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_delete_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn delete_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::Event) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEvent,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_none(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"delete-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    delete_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_destroy<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn destroy_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"destroy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    destroy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_destroy_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn destroy_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::Event) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEvent,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_none(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"destroy-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    destroy_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_direction_changed<F: Fn(&Self, TextDirection) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn direction_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, TextDirection) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            previous_direction: ffi::GtkTextDirection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(previous_direction),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"direction-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    direction_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_begin<F: Fn(&Self, &gdk::DragContext) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_begin_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-begin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_begin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_data_delete<F: Fn(&Self, &gdk::DragContext) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_data_delete_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-data-delete\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_data_delete_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_data_get<
        F: Fn(&Self, &gdk::DragContext, &SelectionData, u32, u32) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_data_get_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext, &SelectionData, u32, u32) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            data: *mut ffi::GtkSelectionData,
            info: libc::c_uint,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                &from_glib_borrow(data),
                info,
                time,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-data-get\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_data_get_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_data_received<
        F: Fn(&Self, &gdk::DragContext, i32, i32, &SelectionData, u32, u32) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_data_received_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext, i32, i32, &SelectionData, u32, u32) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            x: libc::c_int,
            y: libc::c_int,
            data: *mut ffi::GtkSelectionData,
            info: libc::c_uint,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                x,
                y,
                &from_glib_borrow(data),
                info,
                time,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-data-received\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_data_received_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_drop<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_drop_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext, i32, i32, u32) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            x: libc::c_int,
            y: libc::c_int,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                x,
                y,
                time,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-drop\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_drop_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_end<F: Fn(&Self, &gdk::DragContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn drag_end_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-end\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_failed<
        F: Fn(&Self, &gdk::DragContext, DragResult) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_failed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext, DragResult) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            result: ffi::GtkDragResult,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                from_glib(result),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-failed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_failed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_leave<F: Fn(&Self, &gdk::DragContext, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_leave_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext, u32) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                time,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-leave\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_leave_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_drag_motion<F: Fn(&Self, &gdk::DragContext, i32, i32, u32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drag_motion_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::DragContext, i32, i32, u32) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            context: *mut gdk::ffi::GdkDragContext,
            x: libc::c_int,
            y: libc::c_int,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                x,
                y,
                time,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-motion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_motion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_draw<F: Fn(&Self, &cairo::Context) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn draw_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &cairo::Context) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            cr: *mut cairo::ffi::cairo_t,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(cr),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"draw\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    draw_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enter_notify_event<
        F: Fn(&Self, &gdk::EventCrossing) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn enter_notify_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventCrossing) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventCrossing,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"enter-notify-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    enter_notify_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::Event) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEvent,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_none(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_event_after<F: Fn(&Self, &gdk::Event) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn event_after_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::Event) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEvent,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_none(event),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"event-after\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    event_after_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus<F: Fn(&Self, DirectionType) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn focus_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, DirectionType) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            direction: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(direction),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus_in_event<F: Fn(&Self, &gdk::EventFocus) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn focus_in_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventFocus) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventFocus,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"focus-in-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    focus_in_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus_out_event<
        F: Fn(&Self, &gdk::EventFocus) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn focus_out_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventFocus) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventFocus,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"focus-out-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    focus_out_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_grab_broken_event<
        F: Fn(&Self, &gdk::EventGrabBroken) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn grab_broken_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventGrabBroken) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventGrabBroken,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"grab-broken-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    grab_broken_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_grab_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn grab_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"grab-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    grab_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_grab_focus(&self) {
        self.emit_by_name::<()>("grab-focus", &[]);
    }

    fn connect_grab_notify<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn grab_notify_trampoline<P: IsA<Widget>, F: Fn(&P, bool) + 'static>(
            this: *mut ffi::GtkWidget,
            was_grabbed: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(was_grabbed),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"grab-notify\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    grab_notify_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn hide_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"hide\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    hide_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hierarchy_changed<F: Fn(&Self, Option<&Widget>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn hierarchy_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, Option<&Widget>) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            previous_toplevel: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                Option::<Widget>::from_glib_borrow(previous_toplevel)
                    .as_ref()
                    .as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"hierarchy-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    hierarchy_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_key_press_event<F: Fn(&Self, &gdk::EventKey) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn key_press_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventKey) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventKey,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"key-press-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    key_press_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_key_release_event<
        F: Fn(&Self, &gdk::EventKey) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn key_release_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventKey) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventKey,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"key-release-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    key_release_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_keynav_failed<F: Fn(&Self, DirectionType) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn keynav_failed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, DirectionType) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            direction: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(direction),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"keynav-failed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    keynav_failed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_leave_notify_event<
        F: Fn(&Self, &gdk::EventCrossing) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn leave_notify_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventCrossing) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventCrossing,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"leave-notify-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    leave_notify_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_map<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn map_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"map\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    map_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mnemonic_activate<F: Fn(&Self, bool) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn mnemonic_activate_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, bool) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            group_cycling: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(group_cycling),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"mnemonic-activate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    mnemonic_activate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_motion_notify_event<
        F: Fn(&Self, &gdk::EventMotion) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn motion_notify_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventMotion) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventMotion,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"motion-notify-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    motion_notify_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_move_focus<F: Fn(&Self, DirectionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, DirectionType) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            direction: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(direction),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_focus(&self, direction: DirectionType) {
        self.emit_by_name::<()>("move-focus", &[&direction]);
    }

    fn connect_parent_set<F: Fn(&Self, Option<&Widget>) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn parent_set_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, Option<&Widget>) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            old_parent: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                Option::<Widget>::from_glib_borrow(old_parent)
                    .as_ref()
                    .as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"parent-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    parent_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_popup_menu<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn popup_menu_trampoline<P: IsA<Widget>, F: Fn(&P) -> bool + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"popup-menu\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    popup_menu_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_popup_menu(&self) -> bool {
        self.emit_by_name("popup-menu", &[])
    }

    fn connect_property_notify_event<
        F: Fn(&Self, &gdk::EventProperty) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn property_notify_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventProperty) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventProperty,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"property-notify-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    property_notify_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_proximity_in_event<
        F: Fn(&Self, &gdk::EventProximity) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn proximity_in_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventProximity) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventProximity,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"proximity-in-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    proximity_in_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_proximity_out_event<
        F: Fn(&Self, &gdk::EventProximity) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn proximity_out_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventProximity) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventProximity,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"proximity-out-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    proximity_out_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_query_tooltip<F: Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn query_tooltip_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, i32, i32, bool, &Tooltip) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            x: libc::c_int,
            y: libc::c_int,
            keyboard_mode: glib::ffi::gboolean,
            tooltip: *mut ffi::GtkTooltip,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                x,
                y,
                from_glib(keyboard_mode),
                &from_glib_borrow(tooltip),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"query-tooltip\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    query_tooltip_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_realize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn realize_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"realize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    realize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_screen_changed<F: Fn(&Self, Option<&gdk::Screen>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn screen_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, Option<&gdk::Screen>) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            previous_screen: *mut gdk::ffi::GdkScreen,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                Option::<gdk::Screen>::from_glib_borrow(previous_screen)
                    .as_ref()
                    .as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"screen-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    screen_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scroll_event<F: Fn(&Self, &gdk::EventScroll) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn scroll_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventScroll) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventScroll,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"scroll-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    scroll_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_clear_event<
        F: Fn(&Self, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn selection_clear_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventSelection,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-clear-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_clear_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_get<F: Fn(&Self, &SelectionData, u32, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn selection_get_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &SelectionData, u32, u32) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            data: *mut ffi::GtkSelectionData,
            info: libc::c_uint,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(data),
                info,
                time,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-get\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_get_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_notify_event<
        F: Fn(&Self, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn selection_notify_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventSelection,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-notify-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_notify_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_received<F: Fn(&Self, &SelectionData, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn selection_received_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &SelectionData, u32) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            data: *mut ffi::GtkSelectionData,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(data),
                time,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-received\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_received_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_request_event<
        F: Fn(&Self, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn selection_request_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventSelection) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventSelection,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-request-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_request_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn show_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"show\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    show_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_help<F: Fn(&Self, WidgetHelpType) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn show_help_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, WidgetHelpType) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            help_type: ffi::GtkWidgetHelpType,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(help_type),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"show-help\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    show_help_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_show_help(&self, help_type: WidgetHelpType) -> bool {
        self.emit_by_name("show-help", &[&help_type])
    }

    fn connect_size_allocate<F: Fn(&Self, &Allocation) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn size_allocate_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &Allocation) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            allocation: *mut ffi::GtkAllocation,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_none(allocation),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"size-allocate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    size_allocate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_state_flags_changed<F: Fn(&Self, StateFlags) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn state_flags_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, StateFlags) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            flags: ffi::GtkStateFlags,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(flags),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"state-flags-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    state_flags_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_updated<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn style_updated_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"style-updated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    style_updated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_touch_event<F: Fn(&Self, &gdk::Event) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn touch_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::Event) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            object: *mut gdk::ffi::GdkEvent,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_none(object),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"touch-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    touch_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_unmap<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unmap_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unmap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unmap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_unrealize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unrealize_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unrealize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unrealize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_window_state_event<
        F: Fn(&Self, &gdk::EventWindowState) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn window_state_event_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, &gdk::EventWindowState) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            event: *mut gdk::ffi::GdkEventWindowState,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(event),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"window-state-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    window_state_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_app_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_app_paintable_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::app-paintable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_app_paintable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_default_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_composite_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_composite_child_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::composite-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_composite_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_events_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_events_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::events\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_events_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expand_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_expand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus_on_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_on_click_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-on-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focus_on_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_halign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_halign_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::halign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_halign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_default_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_tooltip_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-tooltip\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_tooltip_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_height_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_height_request_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::height-request\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_height_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hexpand_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hexpand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hexpand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hexpand_set_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hexpand-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hexpand_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_is_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_bottom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_bottom_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-bottom\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_bottom_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_end_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-end\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_start_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_start_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-start\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_start_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_top_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-top\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_top_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_name_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_no_show_all_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_no_show_all_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::no-show-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_no_show_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_opacity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_opacity_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::opacity\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_opacity_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_parent_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_receives_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_receives_default_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::receives-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_receives_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_factor_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-factor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_factor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_sensitive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sensitive_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sensitive\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tooltip_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_markup_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_text_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_valign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_valign_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::valign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_valign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vexpand_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vexpand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vexpand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vexpand_set_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vexpand-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vexpand_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_width_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_request_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-request\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_width_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_window_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::window\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_window_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
