/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.directory.BasicAttribute;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.nls.Messages;

public class LdapTypeAndValueList
implements Map {
    private List list = null;
    private static final long serialVersionUID = -4540483835059087783L;
    private Map attributes = new TreeMap();

    public int size() {
        return this.attributes.size();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    public Object get(Object key) {
        return this.attributes.get(key);
    }

    public Object put(Object key, Object value) {
        if (this.attributes.get(new ValueWrapper((String)key)) == null) {
            this.list = new ArrayList();
            this.list.add(new ValueWrapper(value));
            this.attributes.put(new ValueWrapper((String)key), this.list);
        } else {
            this.list = (List)this.attributes.get(new ValueWrapper((String)key));
            this.list.add(new ValueWrapper(value));
            Collections.sort(this.list);
            this.attributes.put(new ValueWrapper((String)key), this.list);
        }
        return this.list;
    }

    public Object remove(Object key) {
        return this.attributes.remove(key);
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException(Messages.getString("ldap.1B"));
    }

    public void clear() {
        this.attributes.clear();
    }

    public Set keySet() {
        return this.attributes.keySet();
    }

    public List toAttributeList() {
        ArrayList<BasicAttribute> list = new ArrayList<BasicAttribute>();
        for (ValueWrapper element : this.keySet()) {
            BasicAttribute ba = new BasicAttribute(element.getStringValue(), true);
            List list2 = (List)this.attributes.get(element);
            for (ValueWrapper elementList : list2) {
                ba.add(elementList.getValue());
            }
            list.add(ba);
        }
        return list;
    }

    public Collection values() {
        throw new UnsupportedOperationException(Messages.getString("ldap.1B"));
    }

    public Set entrySet() {
        return this.attributes.entrySet();
    }

    public String toString() {
        return this.attributes.toString();
    }

    private class ValueWrapper
    implements Comparable {
        private Object value;

        ValueWrapper(Object value) {
            this.value = value;
        }

        public String getStringValue() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return Rdn.escapeValue(this.value);
        }

        public Object getValue() {
            return this.value;
        }

        public int compareTo(Object obj) {
            return this.getStringValue().toUpperCase().compareTo(((ValueWrapper)obj).getStringValue().toUpperCase());
        }
    }
}

