// Code generated by "./generator ./session/org.bluez.obex"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package obex

import (
	"errors"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type ObjectManager interface {
	object_manager.ObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.Object
}

type objectObjectManager struct {
	object_manager.InterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.ImplObject
}

func NewObjectManager(conn *dbus.Conn) ObjectManager {
	obj := new(objectObjectManager)
	obj.ImplObject.Init_(conn, "org.bluez.obex", "/")
	return obj
}

type Manager interface {
	AgentManager() agentManager // interface org.bluez.obex.AgentManager1
	Client() client             // interface org.bluez.obex.Client1
	proxy.Object
}

type objectManager struct {
	interfaceAgentManager // interface org.bluez.obex.AgentManager1
	interfaceClient       // interface org.bluez.obex.Client1
	proxy.ImplObject
}

func NewManager(conn *dbus.Conn) Manager {
	obj := new(objectManager)
	obj.ImplObject.Init_(conn, "org.bluez.obex", "/org/bluez/obex")
	return obj
}

func (obj *objectManager) AgentManager() agentManager {
	return &obj.interfaceAgentManager
}

type agentManager interface {
	GoRegisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call
	RegisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error
	GoUnregisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call
	UnregisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error
}

type interfaceAgentManager struct{}

func (v *interfaceAgentManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceAgentManager) GetInterfaceName_() string {
	return "org.bluez.obex.AgentManager1"
}

// method RegisterAgent

func (v *interfaceAgentManager) GoRegisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterAgent", flags, ch, agent)
}

func (v *interfaceAgentManager) RegisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	return (<-v.GoRegisterAgent(flags, make(chan *dbus.Call, 1), agent).Done).Err
}

// method UnregisterAgent

func (v *interfaceAgentManager) GoUnregisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnregisterAgent", flags, ch, agent)
}

func (v *interfaceAgentManager) UnregisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	return (<-v.GoUnregisterAgent(flags, make(chan *dbus.Call, 1), agent).Done).Err
}

func (obj *objectManager) Client() client {
	return &obj.interfaceClient
}

type client interface {
	GoCreateSession(flags dbus.Flags, ch chan *dbus.Call, destination string, args map[string]dbus.Variant) *dbus.Call
	CreateSession(flags dbus.Flags, destination string, args map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoRemoveSession(flags dbus.Flags, ch chan *dbus.Call, session dbus.ObjectPath) *dbus.Call
	RemoveSession(flags dbus.Flags, session dbus.ObjectPath) error
}

type interfaceClient struct{}

func (v *interfaceClient) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceClient) GetInterfaceName_() string {
	return "org.bluez.obex.Client1"
}

// method CreateSession

func (v *interfaceClient) GoCreateSession(flags dbus.Flags, ch chan *dbus.Call, destination string, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateSession", flags, ch, destination, args)
}

func (*interfaceClient) StoreCreateSession(call *dbus.Call) (session dbus.ObjectPath, err error) {
	err = call.Store(&session)
	return
}

func (v *interfaceClient) CreateSession(flags dbus.Flags, destination string, args map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreCreateSession(
		<-v.GoCreateSession(flags, make(chan *dbus.Call, 1), destination, args).Done)
}

// method RemoveSession

func (v *interfaceClient) GoRemoveSession(flags dbus.Flags, ch chan *dbus.Call, session dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveSession", flags, ch, session)
}

func (v *interfaceClient) RemoveSession(flags dbus.Flags, session dbus.ObjectPath) error {
	return (<-v.GoRemoveSession(flags, make(chan *dbus.Call, 1), session).Done).Err
}

type Session interface {
	Session() session       // interface org.bluez.obex.Session1
	ObjectPush() objectPush // interface org.bluez.obex.ObjectPush1
	proxy.Object
}

type objectSession struct {
	interfaceSession    // interface org.bluez.obex.Session1
	interfaceObjectPush // interface org.bluez.obex.ObjectPush1
	proxy.ImplObject
}

func NewSession(conn *dbus.Conn, path dbus.ObjectPath) (Session, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectSession)
	obj.ImplObject.Init_(conn, "org.bluez.obex", path)
	return obj, nil
}

func (obj *objectSession) Session() session {
	return &obj.interfaceSession
}

type session interface {
	GoGetCapabilities(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetCapabilities(flags dbus.Flags) (string, error)
	Source() proxy.PropString
	Destination() proxy.PropString
	Channel() proxy.PropByte
	Target() proxy.PropString
}

type interfaceSession struct{}

func (v *interfaceSession) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceSession) GetInterfaceName_() string {
	return "org.bluez.obex.Session1"
}

// method GetCapabilities

func (v *interfaceSession) GoGetCapabilities(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetCapabilities", flags, ch)
}

func (*interfaceSession) StoreGetCapabilities(call *dbus.Call) (capabilities string, err error) {
	err = call.Store(&capabilities)
	return
}

func (v *interfaceSession) GetCapabilities(flags dbus.Flags) (string, error) {
	return v.StoreGetCapabilities(
		<-v.GoGetCapabilities(flags, make(chan *dbus.Call, 1)).Done)
}

// property Source s

func (v *interfaceSession) Source() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Source",
	}
}

// property Destination s

func (v *interfaceSession) Destination() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Destination",
	}
}

// property Channel y

func (v *interfaceSession) Channel() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "Channel",
	}
}

// property Target s

func (v *interfaceSession) Target() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Target",
	}
}

func (obj *objectSession) ObjectPush() objectPush {
	return &obj.interfaceObjectPush
}

type objectPush interface {
	GoSendFile(flags dbus.Flags, ch chan *dbus.Call, sourcefile string) *dbus.Call
	SendFile(flags dbus.Flags, sourcefile string) (dbus.ObjectPath, map[string]dbus.Variant, error)
	GoPullBusinessCard(flags dbus.Flags, ch chan *dbus.Call, targetfile string) *dbus.Call
	PullBusinessCard(flags dbus.Flags, targetfile string) (dbus.ObjectPath, map[string]dbus.Variant, error)
	GoExchangeBusinessCards(flags dbus.Flags, ch chan *dbus.Call, clientfile string, targetfile string) *dbus.Call
	ExchangeBusinessCards(flags dbus.Flags, clientfile string, targetfile string) (dbus.ObjectPath, map[string]dbus.Variant, error)
}

type interfaceObjectPush struct{}

func (v *interfaceObjectPush) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceObjectPush) GetInterfaceName_() string {
	return "org.bluez.obex.ObjectPush1"
}

// method SendFile

func (v *interfaceObjectPush) GoSendFile(flags dbus.Flags, ch chan *dbus.Call, sourcefile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SendFile", flags, ch, sourcefile)
}

func (*interfaceObjectPush) StoreSendFile(call *dbus.Call) (transfer dbus.ObjectPath, properties map[string]dbus.Variant, err error) {
	err = call.Store(&transfer, &properties)
	return
}

func (v *interfaceObjectPush) SendFile(flags dbus.Flags, sourcefile string) (dbus.ObjectPath, map[string]dbus.Variant, error) {
	return v.StoreSendFile(
		<-v.GoSendFile(flags, make(chan *dbus.Call, 1), sourcefile).Done)
}

// method PullBusinessCard

func (v *interfaceObjectPush) GoPullBusinessCard(flags dbus.Flags, ch chan *dbus.Call, targetfile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PullBusinessCard", flags, ch, targetfile)
}

func (*interfaceObjectPush) StorePullBusinessCard(call *dbus.Call) (transfer dbus.ObjectPath, properties map[string]dbus.Variant, err error) {
	err = call.Store(&transfer, &properties)
	return
}

func (v *interfaceObjectPush) PullBusinessCard(flags dbus.Flags, targetfile string) (dbus.ObjectPath, map[string]dbus.Variant, error) {
	return v.StorePullBusinessCard(
		<-v.GoPullBusinessCard(flags, make(chan *dbus.Call, 1), targetfile).Done)
}

// method ExchangeBusinessCards

func (v *interfaceObjectPush) GoExchangeBusinessCards(flags dbus.Flags, ch chan *dbus.Call, clientfile string, targetfile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ExchangeBusinessCards", flags, ch, clientfile, targetfile)
}

func (*interfaceObjectPush) StoreExchangeBusinessCards(call *dbus.Call) (transfer dbus.ObjectPath, properties map[string]dbus.Variant, err error) {
	err = call.Store(&transfer, &properties)
	return
}

func (v *interfaceObjectPush) ExchangeBusinessCards(flags dbus.Flags, clientfile string, targetfile string) (dbus.ObjectPath, map[string]dbus.Variant, error) {
	return v.StoreExchangeBusinessCards(
		<-v.GoExchangeBusinessCards(flags, make(chan *dbus.Call, 1), clientfile, targetfile).Done)
}

type Transfer interface {
	transfer // interface org.bluez.obex.Transfer1
	proxy.Object
}

type objectTransfer struct {
	interfaceTransfer // interface org.bluez.obex.Transfer1
	proxy.ImplObject
}

func NewTransfer(conn *dbus.Conn, path dbus.ObjectPath) (Transfer, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectTransfer)
	obj.ImplObject.Init_(conn, "org.bluez.obex", path)
	return obj, nil
}

type transfer interface {
	GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Cancel(flags dbus.Flags) error
	Status() proxy.PropString
	Session() proxy.PropObjectPath
	Name() proxy.PropString
	Type() proxy.PropString
	Size() proxy.PropUint64
	Time() proxy.PropUint64
	Filename() proxy.PropString
	Transferred() proxy.PropUint64
}

type interfaceTransfer struct{}

func (v *interfaceTransfer) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceTransfer) GetInterfaceName_() string {
	return "org.bluez.obex.Transfer1"
}

// method Cancel

func (v *interfaceTransfer) GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Cancel", flags, ch)
}

func (v *interfaceTransfer) Cancel(flags dbus.Flags) error {
	return (<-v.GoCancel(flags, make(chan *dbus.Call, 1)).Done).Err
}

// property Status s

func (v *interfaceTransfer) Status() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Status",
	}
}

// property Session o

func (v *interfaceTransfer) Session() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Session",
	}
}

// property Name s

func (v *interfaceTransfer) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Type s

func (v *interfaceTransfer) Type() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Type",
	}
}

// property Size t

func (v *interfaceTransfer) Size() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Size",
	}
}

// property Time t

func (v *interfaceTransfer) Time() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Time",
	}
}

// property Filename s

func (v *interfaceTransfer) Filename() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Filename",
	}
}

// property Transferred t

func (v *interfaceTransfer) Transferred() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Transferred",
	}
}
