// Code generated by smithy-go-codegen DO NOT EDIT.

package textract

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/textract/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the results for an Amazon Textract asynchronous operation that analyzes
// invoices and receipts. Amazon Textract finds contact information, items
// purchased, and vendor name, from input invoices and receipts.
//
// You start asynchronous invoice/receipt analysis by calling StartExpenseAnalysis, which returns a
// job identifier ( JobId ). Upon completion of the invoice/receipt analysis,
// Amazon Textract publishes the completion status to the Amazon Simple
// Notification Service (Amazon SNS) topic. This topic must be registered in the
// initial call to StartExpenseAnalysis . To get the results of the invoice/receipt
// analysis operation, first ensure that the status value published to the Amazon
// SNS topic is SUCCEEDED . If so, call GetExpenseAnalysis , and pass the job
// identifier ( JobId ) from the initial call to StartExpenseAnalysis .
//
// Use the MaxResults parameter to limit the number of blocks that are returned.
// If there are more results than specified in MaxResults , the value of NextToken
// in the operation response contains a pagination token for getting the next set
// of results. To get the next page of results, call GetExpenseAnalysis , and
// populate the NextToken request parameter with the token value that's returned
// from the previous call to GetExpenseAnalysis .
//
// For more information, see [Analyzing Invoices and Receipts].
//
// [Analyzing Invoices and Receipts]: https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html
func (c *Client) GetExpenseAnalysis(ctx context.Context, params *GetExpenseAnalysisInput, optFns ...func(*Options)) (*GetExpenseAnalysisOutput, error) {
	if params == nil {
		params = &GetExpenseAnalysisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetExpenseAnalysis", params, optFns, c.addOperationGetExpenseAnalysisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetExpenseAnalysisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetExpenseAnalysisInput struct {

	// A unique identifier for the text detection job. The JobId is returned from
	// StartExpenseAnalysis . A JobId value is only valid for 7 days.
	//
	// This member is required.
	JobId *string

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 20. If you specify a value greater than 20, a maximum of 20
	// results is returned. The default value is 20.
	MaxResults *int32

	// If the previous response was incomplete (because there are more blocks to
	// retrieve), Amazon Textract returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of blocks.
	NextToken *string

	noSmithyDocumentSerde
}

type GetExpenseAnalysisOutput struct {

	// The current model version of AnalyzeExpense.
	AnalyzeExpenseModelVersion *string

	// Information about a document that Amazon Textract processed. DocumentMetadata
	// is returned in every page of paginated responses from an Amazon Textract
	// operation.
	DocumentMetadata *types.DocumentMetadata

	// The expenses detected by Amazon Textract.
	ExpenseDocuments []types.ExpenseDocument

	// The current status of the text detection job.
	JobStatus types.JobStatus

	// If the response is truncated, Amazon Textract returns this token. You can use
	// this token in the subsequent request to retrieve the next set of text-detection
	// results.
	NextToken *string

	// Returns if the detection job could not be completed. Contains explanation for
	// what error occured.
	StatusMessage *string

	// A list of warnings that occurred during the text-detection operation for the
	// document.
	Warnings []types.Warning

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetExpenseAnalysisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetExpenseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetExpenseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetExpenseAnalysis"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetExpenseAnalysisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetExpenseAnalysis(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetExpenseAnalysis(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetExpenseAnalysis",
	}
}
