/*
* Copyright (C) 2019 ~ 2021 Uniontech Software Technology Co.,Ltd.
*
* Author:     xiepengfei <xiepengfei@uniontech.com>
*
* Maintainer: xiepengfei <xiepengfei@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef QUICKLYSTARTWIDGET_H
#define QUICKLYSTARTWIDGET_H

#include <QtGlobal>

#if (QT_VERSION < QT_VERSION_CHECK(6, 0, 0))
#include <QEvent>
using EnterEvent = QEvent;
#else
#include <QEnterEvent>
using EnterEvent = QEnterEvent;
#endif

#include <DFrame>

DWIDGET_USE_NAMESPACE

class QuicklyStartWidget : public DFrame
{
    Q_OBJECT
public:
    explicit QuicklyStartWidget(QPixmap pixmap, QString text, QWidget *parent = nullptr);
    void setMethod(QString method) {m_method = method;}
    QString getMethod() {return m_method;}

protected:
    void paintEvent(QPaintEvent *event) Q_DECL_OVERRIDE;
    void enterEvent(EnterEvent *event) Q_DECL_OVERRIDE;
    void leaveEvent(QEvent *event) Q_DECL_OVERRIDE;
    void mouseReleaseEvent(QMouseEvent *event) Q_DECL_OVERRIDE;

signals:
    void clicked();

private:
    QString m_text;
    QString m_method;
    QPixmap m_pixmap;
    bool m_hover;
};

#endif
