// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_MLA_4H_TRACE_AARCH64_H_
#define VIXL_SIM_MLA_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_mla_4H[] = {
  0x3e04, 0x3f02, 0x5c2b, 0x8e49, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e82, 0x664e, 0xeef1, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x331a, 0x552c, 0xe669, 0xd566, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd6, 0x7e84, 0x199c, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe86, 0x7f03, 0x4ccf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0x7f82, 0x0002, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0001, 0x3335, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0080, 0x6668, 0x5560, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x00ff, 0x3332, 0xaa91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x07f1, 0xffe9, 0xffe6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07e0, 0x3e04, 0x331c, 0x553b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3d86, 0x3e83, 0x664f, 0xeeff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e04, 0x3f02, 0x5c2b, 0x8e49, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e82, 0x664e, 0xeef1, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x331a, 0x552c, 0xe669, 0xd566, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd6, 0x7e84, 0x199c, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe86, 0x7f03, 0x4ccf, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0x7f82, 0x8002, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x8001, 0xb335, 0x1c82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8080, 0xdde0, 0xbbcc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0xaa57, 0x70a6, 0x5590, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0x9935, 0x6682, 0xaae5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc68, 0xc081, 0x99b5, 0x003a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc100, 0xc100, 0xcce8, 0x558f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc0ff, 0xcce7, 0x5581, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc17e, 0x001a, 0xaab2, 0x8019, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc1fd, 0xccd1, 0x0003, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf810, 0x6668, 0x5558, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe83, 0x999b, 0xaaad, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xccce, 0x0002, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x0001, 0x5557, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3334, 0xaaac, 0xffe0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x6667, 0x5552, 0x7e99, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x3331, 0xaa83, 0xfe96, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07f0, 0xffe8, 0xffd8, 0x7e93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e03, 0x331b, 0x552d, 0xe677, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e82, 0x664e, 0xeef1, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f01, 0x5c2a, 0x8e3b, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000,
  0x664d, 0xeef0, 0x8003, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x552b, 0xe668, 0xd558, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7e83, 0x199b, 0x2aad, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f02, 0x4cce, 0x8002, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x8001, 0xd557, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xb334, 0x1c74, 0x99ac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xdddf, 0xbbbe, 0x0190, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa56, 0x70a5, 0x5582, 0x818d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9934, 0x6681, 0xaad7, 0x018a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc080, 0x99b4, 0x002c, 0x8187, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99b3, 0x002b, 0x8179, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcce6, 0x5580, 0x0032, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0019, 0xaab1, 0x800b, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccd0, 0x0002, 0x0008, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6667, 0x5557, 0x8005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0xaaac, 0x0002, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0x0001, 0x7fff, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5556, 0xfffc, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0xaaab, 0xffd2, 0x7f16, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x5551, 0x7e8b, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3330, 0xaa82, 0xfe88, 0x7f12, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe7, 0xffd7, 0x7e85, 0x19aa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x331a, 0x552c, 0xe669, 0xd566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x664d, 0xeef0, 0x8003, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5c29, 0x8e3a, 0x000b, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0x8002, 0x8008, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xd557, 0x0005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aac, 0x8002, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x8001, 0xffff, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xd556, 0x0004, 0x6678, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0x1c73, 0x999e, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xbbbd, 0x0182, 0x810e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x70a4, 0x5581, 0x817f, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6680, 0xaad6, 0x017c, 0x810a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaad5, 0x017b, 0x80fc, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x002a, 0x8178, 0x0022, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x557f, 0x0031, 0x8008, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaab0, 0x800a, 0x0006, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0007, 0x8004, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x8004, 0x0002, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0x0001, 0x8000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7ffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0xfffb, 0xffe2, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xffd1, 0x7f08, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5550, 0x7e8a, 0xff06, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa81, 0xfe87, 0x7f04, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd6, 0x7e84, 0x199c, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x552b, 0xe668, 0xd558, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0x8002, 0x8008, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8e39, 0x000a, 0x0006, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8007, 0x8004, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0x0004, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x8001, 0x8000, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xfffe, 0xaaae, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0x0003, 0x666a, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1c72, 0x999d, 0x0102, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbbbc, 0x0181, 0x8100, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5580, 0x817e, 0x00fe, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x817d, 0x00fd, 0x807f, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x017a, 0x80fb, 0x0012, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8177, 0x0021, 0x8005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0030, 0x8007, 0x0004, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8009, 0x0005, 0x8003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x8003, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x0001, 0x8001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7fff, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0xfffd, 0xfff2, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffe1, 0x7f85, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd0, 0x7f07, 0xff84, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7e89, 0xff05, 0x7f83, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe86, 0x7f03, 0x4ccf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7e83, 0x199b, 0x2aad, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xd557, 0x0005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8007, 0x8004, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0005, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x8003, 0x8002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0001, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x7fff, 0x5558, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xaaad, 0x3336, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x6669, 0x0082, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999c, 0x0101, 0x8081, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0180, 0x80ff, 0x0080, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x80fe, 0x007f, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x807e, 0x0002, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x80fa, 0x0011, 0x0002, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0020, 0x8004, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x0003, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x8002, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x0001, 0x0002, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8000, 0x0002, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xffff, 0x0002, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfff1, 0x0002, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe0, 0x7f84, 0x0002, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f06, 0xff83, 0x0002, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0x7f82, 0x0002, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f02, 0x4cce, 0x0002, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aac, 0x0002, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0x0004, 0x0002, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x8003, 0x0002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x0002, 0x0002, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8001, 0x0002, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0002, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x5557, 0x0002, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x3335, 0x0002, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6668, 0x0081, 0x0002, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0100, 0x8080, 0x0002, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x0001, 0xff85, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0001, 0xfff2, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x0001, 0xffff, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0001, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x0001, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0001, 0x0002, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x0001, 0x0003, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0004, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0001, 0x0012, 0x010a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0001, 0x007f, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x0001, 0x0080, 0x010e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x0001, 0x0081, 0x6676, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0001, 0x3335, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x0001, 0x5557, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x0001, 0x7fff, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x0001, 0x8000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0001, 0x8001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x0001, 0x8002, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x8003, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0001, 0xaaac, 0x99a8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0xccce, 0xff10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x0001, 0xff82, 0xff12, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x0001, 0xff83, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0001, 0xff84, 0xff16, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff83, 0xff08, 0xff10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff84, 0xffe2, 0xffe0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfff1, 0xfffc, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffff, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0002, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0004, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0006, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0003, 0x0022, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0011, 0x00fc, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x007e, 0x00fe, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x007f, 0x0100, 0x3340, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0080, 0x6668, 0x5560, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3334, 0xaaac, 0xffe0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5556, 0xfffc, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7ffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7fff, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8000, 0x0002, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8001, 0x0004, 0xaab0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8002, 0x5556, 0xccd0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xaaab, 0x999a, 0xf810, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcccd, 0xff02, 0xf820, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff81, 0xff04, 0xf830, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff82, 0xff06, 0xf840, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff05, 0xf832, 0xf840, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff07, 0xff02, 0xfe99, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xffe1, 0xffd2, 0xff16, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xfffb, 0xffe2, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffd, 0xfff2, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0x0002, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0012, 0x010a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0003, 0x0022, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0005, 0x0102, 0x3d19, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0021, 0x07d2, 0x3d96, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x00fb, 0x07e2, 0x3e13, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x00fd, 0x07f2, 0xfff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x00ff, 0x3332, 0xaa91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x6667, 0x5552, 0x7e99, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0xaaab, 0xffd2, 0x7f16, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0xfffb, 0xffe2, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0xfffd, 0xfff2, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xffff, 0x0002, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0001, 0x0012, 0x5512, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0003, 0xaaa2, 0xffac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x5555, 0xccc2, 0xc190, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x9999, 0xf802, 0xc20d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff01, 0xf812, 0xc28a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff03, 0xf822, 0xc307, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xf821, 0xc2f9, 0xf830, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xf831, 0xf832, 0xfe96, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff06, 0xff01, 0xfe8b, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe0, 0xffd1, 0xff08, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffe1, 0xff85, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfff1, 0x0002, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0001, 0x007f, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0011, 0x00fc, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0021, 0x07d2, 0x3d96, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x0101, 0x3d0b, 0x3e14, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0020, 0x07d1, 0x3d88, 0x3e92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fa, 0x07e1, 0x3e05, 0x332a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x07f1, 0xffe9, 0xffe6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x3331, 0xaa83, 0xfe96, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x5551, 0x7e8b, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xffd1, 0x7f08, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffe1, 0x7f85, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfff1, 0x8002, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0001, 0x807f, 0xffbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0011, 0x5504, 0xcc78, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0xaaa1, 0xff9e, 0xc110, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0xccc1, 0xc182, 0xc18e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9998, 0xf801, 0xc1ff, 0xc20c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff00, 0xf811, 0xc27c, 0xc28a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf810, 0xc27b, 0xc27c, 0xf820, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf820, 0xc2f8, 0xf822, 0xfe93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf830, 0xf831, 0xfe88, 0xff12, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff00, 0xfe8a, 0xff06, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd0, 0xff07, 0xff84, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe0, 0xff84, 0x0002, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x0001, 0x0080, 0x010e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x007e, 0x00fe, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x00fb, 0x07e2, 0x3e13, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0020, 0x07d1, 0x3d88, 0x3e92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0100, 0x3d0a, 0x3e06, 0x3f11, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07d0, 0x3d87, 0x3e84, 0x665d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07e0, 0x3e04, 0x331c, 0x553b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07f0, 0xffe8, 0xffd8, 0x7e93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3330, 0xaa82, 0xfe88, 0x7f12, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5550, 0x7e8a, 0xff06, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd0, 0x7f07, 0xff84, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe0, 0x7f84, 0x0002, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x8001, 0x0080, 0xaa66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x807e, 0xffae, 0x9944, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x5503, 0xcc6a, 0xc090, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa0, 0xff9d, 0xc102, 0xc10f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccc0, 0xc181, 0xc180, 0xc18e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf800, 0xc1fe, 0xc1fe, 0xc20d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc1fd, 0xc1fd, 0xc1ff, 0xcce0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc27a, 0xc27b, 0xf812, 0x6677, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc2f7, 0xf821, 0xfe85, 0x99aa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf830, 0xfe87, 0xff04, 0xccdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe89, 0xff05, 0xff83, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff06, 0xff83, 0x0002, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0x0001, 0x0081, 0x6676, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x007f, 0x0100, 0x3340, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x00fd, 0x07f2, 0xfff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fa, 0x07e1, 0x3e05, 0x332a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07d0, 0x3d87, 0x3e84, 0x665d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3d09, 0x3e05, 0x3f03, 0x5c39, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3d86, 0x3e83, 0x664f, 0xeeff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e03, 0x331b, 0x552d, 0xe677, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe7, 0xffd7, 0x7e85, 0x19aa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa81, 0xfe87, 0x7f04, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7e89, 0xff05, 0x7f83, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f06, 0xff83, 0x8002, 0xb343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x0001, 0x8081, 0xddee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x007f, 0xaa58, 0x70b4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0xffad, 0x9936, 0x6690, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5502, 0xcc69, 0xc082, 0x99c3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff9c, 0xc101, 0xc101, 0xccf6, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc180, 0xc17f, 0xc180, 0x0029, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc17e, 0xc17f, 0x001b, 0xaac0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc1fc, 0xc1fe, 0xccd2, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc27a, 0xf811, 0x6669, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf820, 0xfe84, 0x999c, 0xaabb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe86, 0xff03, 0xcccf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xff82, 0x0002, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0001, 0x3335, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0080, 0x6668, 0x5560, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x00ff, 0x3332, 0xaa91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x07f1, 0xffe9, 0xffe6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07e0, 0x3e04, 0x331c, 0x553b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3d86, 0x3e83, 0x664f, 0xeeff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e04, 0x3f02, 0x5c2b, 0x8e49, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e82, 0x664e, 0xeef1, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x331a, 0x552c, 0xe669, 0xd566, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd6, 0x7e84, 0x199c, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe86, 0x7f03, 0x4ccf, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0x7f82, 0x8002, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x8001, 0xb335, 0x1c82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8080, 0xdde0, 0xbbcc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0xaa57, 0x70a6, 0x5590, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0x9935, 0x6682, 0xaae5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc68, 0xc081, 0x99b5, 0x003a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc100, 0xc100, 0xcce8, 0x558f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc0ff, 0xcce7, 0x5581, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc17e, 0x001a, 0xaab2, 0x8019, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc1fd, 0xccd1, 0x0003, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf810, 0x6668, 0x5558, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe83, 0x999b, 0xaaad, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xccce, 0x0002, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x0001, 0x5557, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3334, 0xaaac, 0xffe0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x6667, 0x5552, 0x7e99, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x3331, 0xaa83, 0xfe96, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07f0, 0xffe8, 0xffd8, 0x7e93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e03, 0x331b, 0x552d, 0xe677, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e82, 0x664e, 0xeef1, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f01, 0x5c2a, 0x8e3b, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000,
  0x664d, 0xeef0, 0x8003, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x552b, 0xe668, 0xd558, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7e83, 0x199b, 0x2aad, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f02, 0x4cce, 0x8002, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x8001, 0xd557, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xb334, 0x1c74, 0x99ac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xdddf, 0xbbbe, 0x0190, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa56, 0x70a5, 0x5582, 0x818d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9934, 0x6681, 0xaad7, 0x018a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc080, 0x99b4, 0x002c, 0x8187, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99b3, 0x002b, 0x8179, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcce6, 0x5580, 0x0032, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0019, 0xaab1, 0x800b, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccd0, 0x0002, 0x0008, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6667, 0x5557, 0x8005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0xaaac, 0x0002, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0x0001, 0x7fff, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5556, 0xfffc, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0xaaab, 0xffd2, 0x7f16, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x5551, 0x7e8b, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3330, 0xaa82, 0xfe88, 0x7f12, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe7, 0xffd7, 0x7e85, 0x19aa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x331a, 0x552c, 0xe669, 0xd566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x664d, 0xeef0, 0x8003, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5c29, 0x8e3a, 0x000b, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0x8002, 0x8008, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xd557, 0x0005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aac, 0x8002, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x8001, 0xffff, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xd556, 0x0004, 0x6678, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0x1c73, 0x999e, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xbbbd, 0x0182, 0x810e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x70a4, 0x5581, 0x817f, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6680, 0xaad6, 0x017c, 0x810a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaad5, 0x017b, 0x80fc, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x002a, 0x8178, 0x0022, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x557f, 0x0031, 0x8008, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaab0, 0x800a, 0x0006, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0007, 0x8004, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x8004, 0x0002, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0x0001, 0x8000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7ffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0xfffb, 0xffe2, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xffd1, 0x7f08, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5550, 0x7e8a, 0xff06, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa81, 0xfe87, 0x7f04, 0x4cdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd6, 0x7e84, 0x199c, 0x2abb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x552b, 0xe668, 0xd558, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0x8002, 0x8008, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8e39, 0x000a, 0x0006, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8007, 0x8004, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0x0004, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x8001, 0x8000, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xfffe, 0xaaae, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0x0003, 0x666a, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1c72, 0x999d, 0x0102, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbbbc, 0x0181, 0x8100, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5580, 0x817e, 0x00fe, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x817d, 0x00fd, 0x807f, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x017a, 0x80fb, 0x0012, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8177, 0x0021, 0x8005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0030, 0x8007, 0x0004, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8009, 0x0005, 0x8003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x8003, 0x0002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x0001, 0x8001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7fff, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0xfffd, 0xfff2, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffe1, 0x7f85, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd0, 0x7f07, 0xff84, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7e89, 0xff05, 0x7f83, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfe86, 0x7f03, 0x4ccf, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7e83, 0x199b, 0x2aad, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xd557, 0x0005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8007, 0x8004, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0005, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x8003, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0001, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x7fff, 0x5558, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xaaad, 0x3336, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x6669, 0x0082, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999c, 0x0101, 0x8081, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0180, 0x80ff, 0x0080, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x80fe, 0x007f, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x807e, 0x0002, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x80fa, 0x0011, 0x8002, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0020, 0x8004, 0x0002, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x0003, 0x8002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x8002, 0x0002, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x0001, 0x8002, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8000, 0x0002, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xffff, 0x0002, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfff1, 0x8002, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe0, 0x7f84, 0x0002, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f06, 0xff83, 0x8002, 0xb343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0x7f82, 0x8002, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f02, 0x4cce, 0x8002, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aac, 0x8002, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0x0004, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x8003, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x0002, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8001, 0x8002, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0002, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x5557, 0x0002, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x3335, 0x0002, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6668, 0x0081, 0x8002, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0100, 0x8080, 0x0002, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x0001, 0x7f85, 0x5570, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x8001, 0xfff2, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x0001, 0x7fff, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x8001, 0x0000, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x0001, 0x8001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x8001, 0x0002, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x0001, 0x8003, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8001, 0x0004, 0xaab0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0001, 0x0012, 0x5512, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0001, 0x807f, 0xffbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x8001, 0x0080, 0xaa66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x0001, 0x8081, 0xddee, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x8001, 0xb335, 0x1c82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x8001, 0xd557, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x8001, 0xffff, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x8001, 0x8000, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0001, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8001, 0x8002, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0003, 0x38f4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0xaaac, 0x7788, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0xccce, 0xab10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x0001, 0xff82, 0x55ba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x0001, 0x7f83, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x8001, 0xff84, 0xab0e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xff83, 0xab00, 0x3350, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7f84, 0x5562, 0x99ac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xfff1, 0x0004, 0x6678, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7ffe, 0xaaae, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xffff, 0x5558, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8000, 0x0002, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0001, 0xaaac, 0x99a8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8002, 0x5556, 0xccd0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0003, 0xaaa2, 0xffac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0011, 0x5504, 0xcc78, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x807e, 0xffae, 0x9944, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x007f, 0xaa58, 0x70b4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8080, 0xdde0, 0xbbcc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xb334, 0x1c74, 0x99ac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xd556, 0x0004, 0x6678, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xfffe, 0xaaae, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x7fff, 0x5558, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0002, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0xaaac, 0x7788, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x38e6, 0xc2a0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xaaab, 0x777a, 0x9a10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcccd, 0xab02, 0x66dc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff81, 0x55ac, 0x33a8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7f82, 0x0056, 0x0074, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x0055, 0x0066, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xaaff, 0x3342, 0x0190, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x5561, 0x999e, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x0003, 0x666a, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0xaaad, 0x3336, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x5557, 0x0002, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0001, 0xccce, 0xff10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xaaab, 0x999a, 0xf810, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x5555, 0xccc2, 0xc190, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0xaaa1, 0xff9e, 0xc110, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x5503, 0xcc6a, 0xc090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0xffad, 0x9936, 0x6690, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0xaa57, 0x70a6, 0x5590, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xdddf, 0xbbbe, 0x0190, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0x1c73, 0x999e, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0x0003, 0x666a, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xaaad, 0x3336, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x5557, 0x0002, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0xccce, 0xab10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xaaab, 0x777a, 0x9a10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x38e5, 0xc292, 0x4010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x7779, 0x9a02, 0x3f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xab01, 0x66ce, 0x3f10, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0x55ab, 0x339a, 0x3e90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55aa, 0x3399, 0x3e82, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0054, 0x0065, 0x0802, 0x018d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaafe, 0x3341, 0x0182, 0x010e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5560, 0x999d, 0x0102, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x6669, 0x0082, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x3335, 0x0002, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x0001, 0xff82, 0xff12, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcccd, 0xff02, 0xf820, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x9999, 0xf802, 0xc20d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0xccc1, 0xc182, 0xc18e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa0, 0xff9d, 0xc102, 0xc10f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5502, 0xcc69, 0xc082, 0x99c3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0x9935, 0x6682, 0xaae5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa56, 0x70a5, 0x5582, 0x818d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xbbbd, 0x0182, 0x810e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1c72, 0x999d, 0x0102, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x6669, 0x0082, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x3335, 0x0002, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x0001, 0xff82, 0x55ba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcccd, 0xab02, 0x66dc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x7779, 0x9a02, 0x3f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x38e4, 0xc291, 0x4002, 0x3f11, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7778, 0x9a01, 0x3f82, 0x3e92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab00, 0x66cd, 0x3f02, 0x3e13, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66cc, 0x3f01, 0x3e05, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3398, 0x3e81, 0x07f2, 0x018a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0064, 0x0801, 0x017f, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3340, 0x0181, 0x0100, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999c, 0x0101, 0x0081, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6668, 0x0081, 0x0002, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x0001, 0xff83, 0xff14, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff81, 0xff04, 0xf830, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff01, 0xf812, 0xc28a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9998, 0xf801, 0xc1ff, 0xc20c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccc0, 0xc181, 0xc180, 0xc18e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff9c, 0xc101, 0xc101, 0xccf6, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc68, 0xc081, 0x99b5, 0x003a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9934, 0x6681, 0xaad7, 0x018a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x70a4, 0x5581, 0x817f, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbbbc, 0x0181, 0x8100, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999c, 0x0101, 0x8081, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6668, 0x0081, 0x8002, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x0001, 0x7f83, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff81, 0x55ac, 0x33a8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xab01, 0x66ce, 0x3f10, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7778, 0x9a01, 0x3f82, 0x3e92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc290, 0x4001, 0x3f03, 0x3e14, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9a00, 0x3f81, 0x3e84, 0x3d96, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f80, 0x3e83, 0x3d88, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f00, 0x3e04, 0x07e2, 0x0187, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3e80, 0x07f1, 0x017c, 0x010a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0800, 0x017e, 0x00fe, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0180, 0x00ff, 0x0080, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0100, 0x0080, 0x0002, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0001, 0xff84, 0xff16, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff82, 0xff06, 0xf840, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff03, 0xf822, 0xc307, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff00, 0xf811, 0xc27c, 0xc28a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xf800, 0xc1fe, 0xc1fe, 0xc20d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc180, 0xc17f, 0xc180, 0x0029, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc100, 0xc100, 0xcce8, 0x558f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc080, 0x99b4, 0x002c, 0x8187, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6680, 0xaad6, 0x017c, 0x810a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5580, 0x817e, 0x00fe, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0180, 0x80ff, 0x0080, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0100, 0x8080, 0x0002, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x8001, 0xff84, 0xab0e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7f82, 0x0056, 0x0074, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0x55ab, 0x339a, 0x3e90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab00, 0x66cd, 0x3f02, 0x3e13, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9a00, 0x3f81, 0x3e84, 0x3d96, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x3f02, 0x3e06, 0x3d19, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_mla_4H = 576;

#endif  // VIXL_SIM_MLA_4H_TRACE_AARCH64_H_
