.\" Tgif's man pages.
.\"
.\" @(#)$Header: /mm2/home/cvs/bc-src/tgif/tgif.man,v 1.104 2011/05/23 02:56:57 william Exp $
.\"
.\"
.\"
.\"
.\"
.\"
.\"
.TH tgif n "Version 4.2 Patchlevel 3 and Above" "Tgif"
.\"
.SH NAME
.\"
\fItgif\fR \- Xlib based interactive 2-D drawing facility under X11.
Supports hierarchical construction of drawings and easy navigation between
sets of drawings.  It's also a hyper-graphics
(or hyper-structured-graphics) browser on the World-Wide-Web.
.\"
.SH SYNOPSIS
.\"
.B tgif
[\fB-display\fR displayname]
[\fB-fg\fR <color>]
[\fB-bg\fR <color>]
[\fB-bd\fR <color>]
[\fB-rv\fR]
[\fB-nv\fR]
[\fB-bw\fR]
[\fB-reqcolor\fR]
[\fB-cwo[+sbwarp]\fR]
[\fB-hyper\fR]
[\fB-exec <file>\fR]
[\fB-dbim {xcin|chinput|xim|kinput2|tgtwb5[,font]}\fR]
[\fB-sbim xim\fR]
[\fB-usexlib\fR]
[\fB{-a4|-letter}\fR]
[\fB-listdontreencode\fR]
[\fB-version\fR]
[\fB-pdfspd | -pdfspd=true | -pdfspd=false \fR]
[\fB-pssetup "<string>" \fR]
[\fB-tgwb2 [-rmcastlibdir <directory> | -rmcastlibpath <path>]\fR]
[\fB-nomode\fR]
[\fB-geometry\fR <geom>]
[\fB=<geom>\fR]
[{\fIfile\fR[.\fIobj\fR]|\fB-merge\fR
\fIfile1\fR[.\fIobj\fR] \fIfile2\fR[.\fIobj\fR] ...}]
.PP
or
.PP
.B tgif
\fB-print\fR
[\fB-eps\fR]
[\fB-p\fR]
[\fB-ps\fR]
[\fB-f\fR]
[\fB-text\fR]
[\fB-epsi\fR]
[\fB-tiffepsi\fR]
[\fB-gif\fR]
[\fB-png\fR]
[\fB-jpeg\fR]
[\fB-ppm\fR]
[\fB-pbm\fR]
[\fB-xpm\fR]
[\fB-xbm\fR]
[\fB-html\fR]
[\fB-pdf\fR]
[\fB-netlist\fR]
[\fB-svg\fR]
[\fB-display\fR displayname]
[\fB-stdout\fR]
[\fB-raw[+h[eaderonly]]\fR]
[\fB-dosepsfilter\fR [\fB-previewonly\fR]]
[\fB-status\fR]
[\fB-gray\fR]
[\fB-color | -reqcolor\fR]
[\fB-adobe | -adobe=<number>/<number> | -adobe=false \fR]
[\fB-dontreencode=<string> | -listdontreencode\fR]
[\fB-version\fR | \fB-justversion\fR]
[\fB-producedby=<string>\fR]
[\fB-page <number>\fR]
[\fB-print_cmd "<command>"\fR]
[\fB-one_file_per_page\fR]
[\fB-pepsc\fR]
[\fB-pdfspd | -pdfspd=true | -pdfspd=false \fR]
[\fB-pssetup "<string>" \fR]
[\fB-j2p6_cmd "<command>" \fR]
[\fB-dontcondense | -condensed\fR]
[\fB{-a4|-letter}\fR]
[\fB-noshowpageineps\fR]
[\fB-quiet\fR]
[\fB-bop_hook "<string>"\fR]
[\fB-eop_hook "<string>"\fR]
[\fB-tmp_file_mode "<octal number>"\fR]
[\fB-patterndir "<xbm directory>"\fR]
[\fB-o\fR<dir>]
[\fB-exec <file>\fR]
[\fIfile1\fR[.\fIobj\fR] \fIfile2\fR[.\fIobj\fR] ...]
.\"
.SH DESCRIPTION
.\"
\fITgif\fR is an interactive drawing tool that allows the user to draw and
manipulate objects in the X Window System.  Tgif runs interactively in
the first form.
In the second form shown in the SYNOPSIS section,
tgif just prints \fIfile1.obj\fR, \fIfile2.obj\fR,
etc.  (generated by \fItgif\fR)
into PostScript(TM) page description files
(without opening windows or fonts)
and pipes them to lpr(1) if none of the
\fB-eps\fR, \fB-p\fR, \fB-epsi\fR, \fB-tiffepsi\fR, \fB-gif\fR,
\fB-png\fR, \fB-jpeg\fR, \fB-ppm\fR, \fB-pbm\fR, \fB-xpm\fR, \fB-xbm\fR,
\fB-html\fR, \fB-pdf\fR, \fB-ps\fR, \fB-f\fR, \fB-text\fR, \fB-netlist\fR, or
\fB-svg\fR options
are specified.  This form of \fIprinting\fR is tgif's way of \fIexporting\fR
a tgif file to another format.  In this case,
any other unrecognized command line options are sent to lpr(1).
In this mode, tgif is compatible with the obsoleted \fIprtgif\fR.
A symbol file (see descriptions below) can also be printed by
specifying the \fI.sym\fR extension explicitly.
.PP
The command line argument \fIfile\fR
specifies a file or an Uniform Resource Locator (URL) of
objects to be initially edited by tgif.
Only HTTP or FTP URL's are supported.
(For a more detailed description of URL and the World-Wide-Web,
the reader is referred to [1].)
.PP
Tgif is purely based on \fIXlib\fR.
It is tested under X11R6, and
it requires a 3 button mouse.
.\"
.SH OPTIONS
.\"
In the first form shown in the SYNOPSIS section,
the command line arguments can be:
.TP
.B -fg
Foreground color specified in <color>.
.TP
.B -bg
Background color specified in <color>.
.TP
.B -bd
Border color specified in <color>.
.TP
.B -rv
Start tgif in reversed-video mode.
.TP
.B -nv
Start tgif in normal-video mode.
.TP
.B -bw
Start tgif in black and white mode.
.TP
.B -reqcolor
Same effect as setting the
Tgif.PrintUsingRequestedColor X default to true
(see the X DEFAULTS section below).
.TP
.B -cwo
Canvas Window Only.  Only the canvas window (see TGIF SUBWINDOWS
section below) will be displayed.
This has the same effect as setting the Tgif.CanvasWindowOnly X default to true.
.TP
.B -cwo+sbwarp
If \fB-cwo+sbwarp\fR is used, single-button-warp (clicking the
left mouse button to warp) is used to activate teleporting
(see TELEPORT/HYPERJUMP section below).
.TP
.B -hyper
Start tgif in the \fIhyperspace\fR mode
(see HYPERSPACE section below).
.TP
.B -exec <file>
After tgif starts, execute the internal command in <file>
(see INTERNAL COMMANDS section below).
If <file> is the string "-", tgif executes internal commands from the
standard input.
.TP
.B -dbim \fImethod\fR
Use \fImethod\fR as the input method for double-byte fonts
(see SQUARE DOUBLE BYTE FONTS section below).
This cannot be used in conjunction with \fI-sbim\fR.
.TP
.B -sbim \fImethod\fR
Use \fImethod\fR as the input method for single-byte fonts.
This is useful if the X Keyboard Extension is used in
inputing international characters (with dead keys).
This cannot be used in conjunction with \fI-dbim\fR.
.TP
.B -usexlib
If tgif is compiled with -DUSE_XT_INITIALIZE, X Toolkit initialization
routines will be used to setup tgif.  Using this command line option will
force tgif to ignore the -DUSE_XT_INITIALIZE compiler option and use
Xlib only.  This is useful when the system resource file for tgif is
not installed properly or messed up and needs to be bypassed.
.TP
.B -a4
Using this option has the same effect as setting the Tgif.PSA4PaperSize
X default to true.
.TP
.B -letter
Using this option has the same effect as setting the Tgif.InitialPaperSize
X default to "letter"
.TP
.B -noshowpageineps
Using this option has the same effect as setting the Tgif.ShowPageInEPS
X default to false.
.TP
.B -quiet
If this option is used, tgif will suppress standard messages.
.TP
.B -listdontreencode=<string>
If this option is used, tgif will print out the list of PostScript
font names specified in the -D_DONT_REENCODE compiler option used
in compiling tgif.
.PP
In the second form shown in the SYNOPSIS section,
the command line arguments can be:
.TP
.B -version
If this option is used, tgif will print out its version number
and copyright on the command line.
.TP
.B -justversion
If this option is used, tgif will print out its version number
and copyright on the command line and exits immediately.
.TP
.B -nomode
Using this option has the same effect as setting the Tgif.NoModeWindow
X default to true.
.TP
.B -eps \fR(or\fB -p\fR)\fB
Generates an Encapsulated PostScript(TM) file in \fIfile.eps\fR;
this file can be included in a LaTeX file through the
\\psfig, \\epsf, or \\psfile construct (see the LATEX FIGURE FORMATS section
below).
.TP
.B -ps \fR(or\fB -f\fR)\fB
Generates a PostScript file in \fIfile.ps\fR;
this file can be printed to a PostScript printer with lpr(1).
.TP
.B -text
Generates a text file in \fIfile.txt\fR;
the text file contains all visible text and can be fed to a spell checker.
.TP
.B -epsi
Generates an Encapsulated PostScript (EPS) file with a preview bitmap
in \fIfile.eps\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -tiffepsi
Generates an EPS file with a
DOS EPS Binary File Header and a trailing TIFF image in \fIfile.eps\fR.
See the GENERATING MICROSOFT WINDOWS EPSI FILES section for more details.
Tgif aborts if a valid display is not accessible.
.TP
.B -gif
Generates a GIF file in \fIfile.gif\fR.
Please see the notes for Tgif.GifToXpm in the X DEFAULTS section below.
Tgif aborts if a valid display is not accessible.
.TP
.B -png
Generates a PNG file in \fIfile.png\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -jpeg
Generates a JPEG file in \fIfile.jpg\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -ppm
Generates a PPM file in \fIfile.ppm\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -pbm
Generates a PBM file in \fIfile.pbm\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -xpm
Generates an X11 pixmap (XPM) file in \fIfile.xpm\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -xbm
Generates an X11 bitmap (XBM) file in \fIfile.xbm\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -html
Generates a GIF file in \fIfile.gif\fR and an HTML file in \fIfile.html\fR.
Tgif aborts if a valid display is not accessible.
.TP
.B -pdf
Generates a PDF file in \fIfile.pdf\fR.
Please see the notes for Tgif.PsToPdf in the X DEFAULTS section below.
.TP
.B -netlist
Generates a text file in \fIfile.net\fR and a text file in \fIfile.cmp\fR.
\fIfile.net\fR contains netlist information stored in a table.
The first line in it contains column names and
each line in it is a port name (surrounded by double-quotes),
followed by a comma and a <TAB> character, followed by a signal name
(also surrounded by double-quotes).
\fIfile.cmp\fR contains information about components in the file.
Each component begins with its name followed by its type.  The attributes
of a component are printed afterwards (indented by <TAB> characters).
.TP
.B -svg
Generates an SVG file in \fIfile.svg\fR.
Please see the notes for Tgif.EpsToTmpSvg and Tgif.TmpSvgToSvg
in the X DEFAULTS section below.
.TP
.B -stdout
Sends the output to the standard output instead of generating the
output in a file.
.TP
.B -raw
Causes the content of the files to be dumped to stdout.
.TP
.B -raw+h
If \fB-raw+h\fR is used and if the file is an HTTP URL, the HTTP header is also
dumped to stdout.
.TP
.B -raw+headeronly
If \fB-raw+headeronly\fR is used and if the file is an HTTP URL,
the HTTP header is dumped to stdout.
.TP
.B -dosepsfilter
Makes tgif act as a filter for getting rid of the
DOS EPS Binary File Header and the trailing TIFF image in
a DOS/Windows EPS file.
.TP
.B -previewonly
If \fB-dosepsfilter\fR is specified, \fB-previewonly\fR makes tgif
act as a filter for extracting the preview bitmap
from the trailing TIFF image in a DOS/Windows EPS file.
.TP
.B -status
If this option is used in conjunction with either
\fB-raw\fR, \fB-raw+h\fR, or \fB-raw+headeronly\fR causes
a status line to be displayed in stderr.
.TP
.B -gray
Using this option has the same effect as setting the
Tgif.UseGrayScale X default to true (see the X DEFAULTS section below).
.TP
.B -color \fR(or\fB -reqcolor\fR)\fB
To print in color, one can use either the \fB-color\fR or the \fB-reqcolor\fR
option.  The only difference between the two is that using
\fB-reqcolor\fR has the same effect as setting the
Tgif.PrintUsingRequestedColor X default to true
(see the X DEFAULTS section below).
.TP
.B -adobe \fR(or\fB -adobe=<number>/<number> -adobe=false\fR)\fB
Using this option has the same effect as specifying the
Tgif.UsePsAdobeString X default.
.TP
.B -dontreencode=<string>
Using this option has the same effect as specifying the
Tgif.DontReencode X default.
.TP
.B -producedby=<string>
Using this option has the same effect as specifying the
Tgif.ProducedBy X default.
.TP
.B -page
Causes a specified page (specified by <number>) to be printed.
.TP
.B -print_cmd
Using this option has the same effect as specifying the
Tgif.PrintCommand X default.
.TP
.B -one_file_per_page
Causes each page to be printed into a separate file.
.TP
.B -pepsc
Preserve EPS Comment.  This command line option became obsolete since
EPS comments are always preserved starting from tgif-4.0.11.
.TP
.B -nolandpdfspd
This commandline option became obsolete in tgif-4.1.42.
It is interpreted as -nopdfspd.
.TP
.B -pdfspd \fR(or\fB -pdfspd=true -pdfspd=false\fR)\fB
If -pdfspd or -pdfspd=true is specified,
"setpagedevice" is generated in the interim PostScript file
when exporting PDF files or in the final PostScript file
when exporting PS files.  If -pdfspd=false is specified,
no "setpagedevice" will be generated in the interim PostScript file
when exporting PDF files or in the final PostScript file
when exporting PS files.
This option overrides the Tgif.PdfSetPageDevice X default.
.TP
.B -pssetup
Using these options have the same effect
as specifying the Tgif.AdditionalPSSetup X default.
.TP
.B -tgwb2
This commandline option enables the Tangram Whiteboard
feature in tgif.  It requires \fBlibrmcast.so\fR
(Reliable IP-multicast library).  The location of
the rmcast library can be specified by the optional
commandline argument \fB-rmcastlibdir\fR.  Alternatively,
the full path to the rmcast library can be specified by using the optional
commandline argument \fB-rmcastlibpath\fR.
(Please note that the rmcast library has only been
extensively tested on Linux machines.)
.TP
.B -j2p6_cmd
Using this option has the same effect as specifying the
Tgif.JpegToPpm6 X default.
.TP
.B -dontcondense
Using this option has the same effect as setting the Tgif.DontCondensePSFile
X default to true.
.TP
.B -condensed
Using this option has the same effect as setting the Tgif.DontCondensePSFile
X default to false.
.TP
.B -bop_hook \fRand\fB -eop_hook
Using these options have the same effect
as specifying the Tgif.PSBopHook and Tgif.PSEpsHook X defaults.
.TP
.B -tmp_file_mode
Using this option have the same effect
as specifying the Tgif.TmpFileMode X defaults.
.TP
.B -patterndir
Using this option have the same effect
as specifying the Tgif.CustomPatternDir X defaults.
.TP
.B -o
If this option is not specified, the output file (eps, ps, etc.)
goes into the same directory as the input file.  If \fB-o\fR<dir>
is specified, the output file goes into the directory specified
by \fB<dir>\fR.
.TP
.B -merge \fIfile1\fR \fIfile2\fR ...
Using this option merges \fIfile1\fR.obj, \fIfile2\fR.obj, etc.
into a multipage file.
.\"
.SH BASIC FUNCTIONALITIES
.\"
Primitive objects supported by tgif
are rectangles, ovals, rounded-corner rectangles, arcs,
polylines, polygons, open-splines, closed-splines, text, X11 bitmaps,
some specific forms of X11 pixmaps, and Encapsulated PostScript.
(Please note that the splines tgif draw are \fInot\fR Bezier curves.)
Objects can be grouped together to form a \fIgrouped\fR object.
A primitive or a grouped object can be made into an \fIicon\fR object or a
\fIsymbol\fR object through user commands.
.PP
Tgif objects are stored in two types of files.  A file with a
.I \.obj
extension (referred to as an \fIobject\fR file)
is a file of objects, and a file with a
.I \.sym
extension (referred to as a \fIsymbol\fR file)
specifies a ``building-block'' object.
A \fIteleport\fR mechanism is provided to \fItravel\fR (or \fIhyperjump\fR)
among the .obj files.
A building-block object consists of the
\fIrepresentation\fR part and the \fIdefinition\fR
part (which can be empty) of the object.
Tgif supports the ``bottom-up'' construction of hierarchical
drawings by providing the capability to ``instantiate'' a
building-block object in a drawing.  Tgif also supports the ``top-down''
specification of drawings by allowing the user to make any
object a \fIrepresentation\fR
of an un-specified subsystem.
Both types of files are stored in the
form of Prolog facts.  Prolog code can be written to interpret
the drawings!  (It is left to the user to produce the code.
See the PROLOG/C TESTDRIVE section for more details.)
Prolog engines are referred to as
\fIdrivers\fR in the sections to follow.  (Other types of drivers
are also allowed, e.g., written in C.)
.PP
Text based \fIattributes\fR can be attached to any non-text object.
Attributes specified in the representation part of a
building-block object are non-detachable when such an object is instantiated.
See the ATTRIBUTES section for details.
.PP
Tgif can generate output in a few different formats.
By default, the output is in the PostScript format (color PostScript
is supported), and it is generated into a file named
/tmp/Tgifa* (produced by mktemp() calls) where * is a number;
this file is piped to lpr(1).  This takes place when the
laser-printer icon is displayed in the Choice Window
(see the TGIF SUBWINDOWS section for the naming of tgif windows).
This output can be redirected to a file with a
.I \.ps
extension.  This takes place when the \fIPS\fR icon is displayed
in the Choice Window.
When the \fIPDF\fR icon is displayed in the
Choice Window, the output is generated into a file with a
.I \.pdf
extension.  By default, tgif calls ps2pdf(1) from the ghostscript(1)
package to convert a \fIPS\fR file to a \fIPDF\fR file.
When the \fILaTeX\fR (or \fIEPSI\fR) icon is displayed in the
Choice Window, the output is generated into a file with a
.I \.eps
extension.  This file is in the Encapsulated PostScript (or Encapsulated
PostScript Interchange) format;
it can be included in a LaTeX document with the
\fI\\psfig\fR or the \fI\\epsf\fR construct; this will be discussed later.
The only difference between the EPS and EPSI formats is that an EPSI
file contains a preview bitmap.  However, it takes time to generate the
preview bitmap.  If the EPS/EPSI file is to be incorporated into some
tool that does not know how to use the preview bitmap, time can be saved
by not using the EPSI format.
When the \fIT\fR icon is displayed in the Choice Window,
the output is generated into a file with a
.I \.txt
extension.  This is a text file containing all visible text;
it can be fed to a spell checker.
When the \fIx11bm\fR (X11 bitmap) icon is displayed in the
Choice Window and color output is \fInot\fR selected,
tgif generates the output with the
.I \.xbm
extension; the output is in the X11 bitmap format.
However, if the x11bm icon is displayed in the
Choice Window and color output \fIis\fR selected (through the ^#k
keyboard command -- ^ denotes the <Control> and # denotes the <Meta>
or <Alt> key),
then tgif generates the output with the
.I \.xpm
extension, and the output is in the X11 pixmap format
(the version of this XPM format depends on the settings of the
Tgif.XPmOutputVersion X default).
When the \fIGIF\fR icon is displayed in the
Choice Window, the output is generated into a file with a
.I \.gif
extension.  By default, tgif calls xpmtoppm and ppmtogif from the netpbm(1)
package to convert an \fIXPM\fR file to a \fIGIF\fR file.
.PP
X11 bitmap files, certain forms of X11 pixmap files
(such as the one generated by tgif; see the section on X11 PIXMAP
for details), GIF files, and Encapsulated PostScript (EPS) files
can be \fIimported\fR into tgif and be represented
as tgif primitive objects.  Files in other raster formats (e.g,
JPEG, TIFF, etc.) can also be imported into tgif if external tools
can be used to convert them into X11 pixmap files.  Please see the
IMPORT RASTER GRAPHICS section for details.
.PP
Tgif drawings are supposed to be printed on letter size paper (8.5in by 11in).
Both landscape and portrait page styles are supported by tgif.
Reduction (or magnification) can be controlled by the #% keyboard
command to set the reduction/magnification.  If the compiler
flag -DA4PAPER is defined (in Imakefile or Makefile.noimake),
then the output is supposed to be printed on A4 papers (which
has approximate dimensions of 8.25in by 11.7in).
.\"
.SH GRAPHICAL OBJECTS
.\"
An object in an \fIobject\fR (\fI.obj\fR) file can be a primitive object,
a grouped object, or an \fIicon\fR object.
A \fIsymbol\fR (\fI.sym\fR) file can have any number of objects allowed in an
object file and exactly one \fIsymbol\fR object.
(Recall that a symbol file specifies a building-block
object.)  The symbol object in a symbol file is the representation
part of the building-block object, and the rest of the
symbol file is the definition
part of the building-block object.  The symbol object is highlighted
with a dashed outline to distinguish it from the rest of
the objects.  When a building-block object is instantiated,
the symbol part of the file is copied into the graphics editor, and it
becomes the icon for the building-block object.
.PP
All objects in tgif can be moved, duplicated, deleted, rotated, flipped,
and sheared.
However, in the non-stretchable text mode, text objects can not be stretched.
For an text object, if it has not been stretched,
rotated, or sheared, flipping it horizontally will
cause the text justification to change and flipping it
vertically has no effect.
.PP
Tgif supports 32 fill patterns, 32 pen patterns, 7 default line widths, 4 line
styles (plain, head arrow, tail arrow, double arrows) for
polylines and open-splines, 9 dash patterns,
3 types of text justifications, 4 text
styles (roman, italic, bold, bold-italic), 11 default text sizes
(8, 10, 12, 14, 18, and 24 for the 75dpi fonts and
11, 14, 17, 20, 25, and 34 for the 100dpi fonts), 5 default fonts
(Times, Courier,
Helvetica, New-Century-Schoolbook, Symbol), and 11 default colors (magenta,
red, green, blue, yellow, pink, cyan, cadet-blue, white, black,
dark-slate-gray).
Additional line widths can be added through the use of
Tgif.MaxLineWidths, Tgif.LineWidth#, Tgif.ArrowWidth#, and
Tgif.ArrowHeight# X defaults.
Additional text sizes can be added through the use of
Tgif.FontSizes X default.
Additional fonts can be added through the use of
Tgif.AdditionalFonts X default.  If the defaults fonts are not
available, their replacement fonts can be specified by
Tgif.HasAlternateDefaultFonts and related X defaults.
Additional colors can be added through the use of
Tgif.MaxColors, and Tgif.Color# X defaults.  One can also select
AddColor() or ChooseColor() from the Properties Menu to add a color.
Alternate startup colors can be selected through the use of the
Tgif.ColorFromXPixmap,
Tgif.UseStdPalette8, Tgif.UseStdPalette27, Tgif.UseStdPalette64,
Tgif.UseStdPalette216, Tgif.UseMobileWebSafePalette,
Tgif.UseOpenOfficeGalaxyPalette, Tgif.UseOpenOfficeGooglePalette,
and Tgif.AdditionalColors X defaults.
.PP
Most commands in tgif can either be activated by a
popup menu or by typing an appropriate
non-alphanumeric key.  All operations that change any object can be undone
and then redone.  Commands such as zoom, scroll, change fonts while no
text objects are selected, etc. are not undoable.  The undo/redo
history buffer size can be set using the Tgif.HistoryDepth X default.
.\"
.SH TGIF SUBWINDOWS
.\"
The tgif windows are described in this section.
.TP
.I Top Window
Displays the current domain and the
name of the file tgif is looking at.  Mouse clicks
and key presses have no effect.
.TP
.I Menubar Window
This window is right under the Top Window.
Pull-down menus can be activated from it with any mouse buttons.
Key presses have no effect.  If HideMenubar() is selected from the Layout Menu,
this window becomes invisible.  If ShowMenubar() is selected from the
Layout Menu (which can be activated from the Canvas Window below), this
window becomes visible.
.PP
.RS
The View, Text, and Graphics pull-down menus are cascading menus and can
not be \fIpinned\fR (see the \fIPopup Menus\fR subsection below for a
description).
.RE
.TP
.I Message Window
This is right under the Menubar Window and to the right
It displays tgif messages.
Clicking the left mouse button
in this window scrolls
the messages towards the bottom, clicking the right mouse
button scrolls towards
the top, and clicking or dragging the middle mouse button scrolls
to the location in the
message history depending on where the mouse is clicked.
If the <Shift> (or <Control>) key is held down when clicking the
left/right mouse button, it scrolls right/left.
.TP
.I Panel (Choice) Window
This is the window to the left of the Message Window, and it
contains a collection of icons (not to be confused with the tgif icon objects)
reflecting the current state of tgif.
In top/bottom, left/right order, it
displays the current drawing mode, the
page style (portrait or landscape), edit (see below),
print/export mode, zoom factor,
move and stretch mode (constrained or unconstrained),
radius for rounded-corner rectangles,
text rotation, page number or row/column, page layout mode
(stacked or tiled), horizontal alignment (L C R S -),
vertical alignment (T M B S -),
font, text size, vertical spacing between lines of text within
the same text object, text justification,
shape (see below), stretchable or non-stretchable text mode, dash pattern,
line style, polyline, spline, or interpolated spline,
line width, fill pattern, pen pattern,
color, and special (see below).
Key presses have no effect in this window.
.PP
.RS
In addition to displaying the current state of tgif, the icons in the
Choice Window can also be used to change the current state.
Each icon is associated with a particular state variable of tgif.
Clicking the left mouse button on top of an icon cycles the
state variable associated with the icon forward; clicking the right mouse
button cycles the state variable backwards.  Dragging the middle mouse button
on top of an icon usually generates a popup menu which corresponds to
an entry in the Main Menu for the Canvas Window below.
(The ``edit'', ``shape'',  and ``special'' icons mentioned above are
dummy icons that allow the ``edit'', ``shape'', and ``special'' menus to be
accessed in the Choice Window.  They do not respond to left and right
mouse clicks.)
The response to the dragging of the middle mouse button is different for
the zoom, radius, and vertical spacing icons.  Dragging the mouse
left or up increases the zoom or decreases the radius or vertical spacing;
dragging the mouse right or down has the opposite effect.
.RE
.PP
.RS
If there are objects selected in the
canvas window, then the action of the mouse will cause the selected
objects to change to the newly selected mode; note that in this
case, the current choice won't change if the middle mouse button
is used (unless the Tgif.StickyMenuSelection X default is set to true).
.RE
.PP
.RS
The settings of the horizontal and vertical
alignments determine how objects (or vertices) align with
each other when the ^l keyboard command is issued,
how each individual object (or vertex) aligns with the grids
when the ^t keyboard command is issued,
how objects or vertices distribute spatially with respect to each other when
the #l keyboard command is issued,
and how each icon replaces the old icon when the ^#u
keyboard command is issued.  The horizontal
alignments are left (L), center (C), right (R), space (S), and ignore (-).
The vertical alignments are top (T), middle (M), bottom (B), space (S), and
ignore (-).  In aligning operations, the space (S) and the ignore (-)
settings have the same effect.  The space settings are used to distribute
objects such that the gaps between any two neighboring objects are equal.
In vertex mode, any non-ignore setting will cause the selected vertices
to be spaced out evenly.
The best way to understand them is to try them out.
.RE
.PP
.RS
The text vertical spacing determines the vertical distance to advance
when a carriage return is pressed during text editing.  If the user
tries to set the
value too negative, such that the next line is exactly at
the same position as the current line, such a setting will not be
allowed (this distance depends on the current font and font size).
.RE
.TP
.I Canvas Window
This is the drawing area.  The effects of the actions of the mouse are
determined by the current drawing mode.  Before tgif-4.x,
dragging the right mouse button will generate the Mode Menu.
This is disabled by default in tgif-4.x, but you can turn it on using
the Tgif.Btn3PopupModeMenu X default.
.PP
.RS
The drawing modes are (in order,
as they appear in the Mode Menu) select, text, rectangle,
corner oval, center oval, edge circle,
polyline (open-spline), polygon (closed-spline),
arc (center first), arc (endpoints first), rounded-corner rectangle,
freehand polyline (open-spline),
select vertices, and rotate/shear.
When drawing a rectangle, an oval, or a rounded-corner
rectangle, if the <Shift>
key is held down, a square, a circle, or a rounded-corner square is drawn.
Dragging the middle mouse button will generate the Main Menu.
.RE
.PP
.RS
In the select mode, left mouse button selects, moves, stretches,
and reshapes objects (double-click will ``de-select'' all selected objects
in vertex mode).  When an object is selected, it is highlighted by
little squares (referred as handles here) at the corners/vertices
(using the Tgif.HandleSize X default,
the sizes of the handles can be customized).  Dragging one of the handles
stretches/reshapes the selected object.  If one wants to move a selected
object, one should not drag the handles.  Instead, one should
drag other parts of the object.  For example, if the object is a
hollow rectangle (the fill is NONE and the pen is not NONE), in order to select
the rectangle, one should click on the outline of the rectangle
with the left mouse button.  If one would like to move the rectangle, one
should drag the outline of the rectangle with the left mouse button.
If the object is a filled rectangle (fill is not NONE), one can
click inside the rectangle to select it and
drag anywhere inside the rectangle to move it.
.RE
.PP
.RS
Holding down the <Shift> key and clicking the left mouse
on an object which is not currently selected will add the
object to the list of already selected objects.  The same
action applied to an object which is already selected will cause
it to be de-selected.
When stretching objects (not reshaping poly-type objects),
holding down the <Shift> key \fIafter\fR stretching is initiated activates
proportional stretching (basically, a scale operation
is being performed).
In non-stretchable text mode, text objects can not be stretched or scaled.
.RE
.PP
.RS
Double-clicking or clicking the middle mouse button
while the <Shift> key is held down will activate
the \fIteleport\fR (or \fItravel\fR), the \fIlaunch\fR,
or the \fIexecute internal command\fR mechanism.  See the sections on
TELEPORT/HYPERJUMP, LAUNCH APPLICATIONS, and INTERNAL COMMANDS for details.
Teleporting has precedence over launching, which has precedence over
executing an internal command.
In the text drawing mode, dragging the middle mouse button
while the <Cntrl> key is held down inside the edit text area
will move the edit text area.
.RE
.PP
.RS
The arrow keys can also be used to move selected objects.  However,
if no objects
are selected, using the arrow keys will scroll the drawing area by a small
amount, and using the arrow keys when <Control> key is held down will
scroll a screen full.
.RE
.PP
.RS
In the select vertices mode, left mouse button selects and moves
vertices.  Only the top-level polyline/open-spline and polygon/closed-spline
objects which are selected when the vertex mode is activated
are eligible for vertex operations.  In this mode, all
eligible objects have their vertices highlighted with squares.
When a vertex is selected (using similar mechanism as selecting
objects described above), it is doubly highlighted with a '+' sign.
Operations available to these doubly highlighted vertices are move, delete,
align (with each other), distribute (space them equally), and align to grid.
The arrow keys can also be used to move selected vertices.
.RE
.PP
.RS
Objects can be locked (through the #< keyboard command).
Locked object are shown
with gray handles, and they can not be moved, stretched, flipped, rotated,
or sheared.
When objects are grouped, the resulting grouped object
will also be locked if any one of it's constituents is locked.
Locked objects can have their properties, such as color, font, pen, etc.,
changed; furthermore, they can be deleted.
.RE
.PP
.RS
If the current move/stretch mode is of the constrained type (activated
and deactivated by the #@ keyboard command), top-level polylines will have the
following behavior.  In a move operation, if both endpoints of a
polyline lie inside the objects being moved, then the whole polyline
is moved; otherwise, if only one endpoint falls inside the objects
being moved, then that endpoint is moved.  The vertex that is the
neighbor of the moved endpoint may also be moved either horizontally
or vertically.  If the last line segment is horizontal or vertical,
then the neighbor vertex may be moved so that the direction of the last
line segment is maintained.
In a stretch (not reshape)
operation, if an endpoint of a polyline lies inside the objects being moved,
that endpoint will be moved.  The vertex that is the neighbor of
the moved endpoint will also be moved in the same manner as described above.
.RE
.PP
.RS
When the drawing mode is set to
text (a vertical-bar cursor is shown),
clicking the left mouse button causes selected text to go into edit mode.
Dragging the left mouse button or
clicking the left mouse button while the <Shift> key is held down highlights
substrings of the text.  Double-clicking causes a word to be selected.
In edit mode,
key presses are treated as text strings being
inputed, and arrow keys are used to move the current input
position.  If a key press is preceded by an <ESC> key,
then the character's bit 7 is turned on.  This allows
non-ASCII (international) characters to be entered.  One can use xfd(1) to
see what the corresponding international character is for an ASCII character.
For the Symbol font, symbols such as the integral, partial derivative, and
copyright symbols can all be found in this range.
There are some characters
that are supported by X11 but not by PostScript; these characters
are not accepted by tgif.
If the text being edited is an attribute of a object, <Meta><Tab>
will move the cursor to the next visible attribute and <Shift><Tab> will
move the cursor to the previous visible attribute.
.RE
.PP
.RS
If the drawing mode is set to draw polygons (not closed-splines) and
if the <Shift> key is held down, the rubber-banded polygon will be self-closing.
.RE
.PP
.RS
The freehand drawing mode can be used to draw polylines and open splines.
All intermediate points are specified by moving the mouse (as opposed to
clicking the mouse buttons as in the polyline mode).  The
second endpoint is specified by releasing the mouse button.
.RE
.PP
.RS
In all drawing modes (other than the text mode), pressing the <ESC>
key cancels the drawing (creation) of the current object.
.RE
.PP
.RS
Middle mouse button always generates the main
tgif popup menu.  Holding down the <Shift> key and clicking the right
mouse button will change the drawing mode to \fIselect\fR.
Key presses with the <Control> or <Meta> key held down
(referred to as \fInon-alphanumeric\fR key presses since
they can also generate control characters)
are treated as commands, and their
bindings are summarized in the next section.  Users can also
define single key commands to emulate the functions of the
non-alphanumeric key commands.
The SHORTCUTS section will describe the details.
.RE
.TP
.I Scrollbars
Clicking the left mouse button in the vertical/horizontal scrollbar causes the
canvas window to scroll down/right by a small distance; clicking the
right mouse button has the reverse effect.  (The scrollbars in the popup
windows for selecting file names and domain names behave similarly.)
Clicking with the <Shift> key held down will scroll a window full.
Clicking or dragging the middle button will cause the page to scroll
to the location which corresponds to the gray area in the scrollbars.
(Tgif insists that the left-top corner of the Canvas Window is at
a distance that is a nonnegative multiple of some internal units
from the left-top corner of the actual page.)
.TP
.I Rulers
.br
They track the mouse location.
Mouse clicks and key presses have no effect.
When the page reduction/magnification is set at 100%,
the markings in the rulers correspond to centimeters when the metric
grid system is used, and they correspond to inches when the English
grid system is used.  When the page reduction/magnification is not
set at 100%, the markings do not correspond to the above mentioned
units any more (this is considered as a known bug).
.TP
.I Interrupt/Hyperspace Window
.br
This window is right below the Message Window and to the left of the
horizontal ruler.  When the Tgif.IntrCheckInterval X default has a
positive value, an interrupt icon is visible when the Canvas Window
is being redrawn.  If the user clicks on this window when the
interrupt icon is visible, tgif aborts the repainting of the objects.
If this is done when a file is being opened (either through Open()
or Push()), the drawing of objects is stopped, but the reading of
the file continues (reading of the file is not aborted).
.PP
.RS
If tgif is currently in the \fIhyperspace\fR mode (please see the HYPERSPACE
section below for more details), a space ship icon will be displayed when
the interrupt icon is not being displayed.  Clicking any button in this
window will switch tgif in and out of the hyperspace mode.
.RE
.TP
.I Page Control Window
.br
The Page Control Window is to the left of the horizontal scrollbar.
This window is empty if the current page mode is set to the \fItiled\fR
page mode.
If the current page mode is set to the \fIstacked\fR page mode,
each page has a tab in tabs subwindow of this window.  Clicking
the left mouse button
on a tab goes to the corresponding page.  Clicking the middle mouse
button brings up the Page Menu.  When there are too many pages in
a drawing so that one can not see the tabs for all the pages, one
can use the icons to the left side of the Page Control Window to
scroll the tabs subwindow.  Clicking on the first icon scrolls the
tabs subwindow such that the first tab is visible.  Clicking on
the 4th icon scrolls the tabs subwindow such that the last tab is
visible.  Clicking on the 2nd icon scrolls the tabs subwindow towards
the first tab by one tab and clicking on the 3rd icon scrolls the tabs
subwindow towards the last tab by one tab.
.TP
.I Status Window
This window is below the horizontal scrollbar.  It shows what action
will be taken if a mouse button is depressed.  When a menu is pulled down
or popped up, this window shows what action will be taken if a menu item
is selected.  It also displays miscellaneous status information.
Mouse clicks and key presses have no effect.
If HideStatus() is selected from the Layout Menu,
this window becomes invisible.  If ShowStatus() is selected from the
Layout Menu, this window becomes visible.
.PP
.RS
By default, when this window is displaying mouse button status,
right-handed mouse is assumed.  Setting the Tgif.ReverseMouseStatusButtons
X default to true will reverse the status (as if a left-handed mouse is used).
.RE
.TP
.I Popup Menus
.br
When a menu is popped up by a mouse drag, the menu can be \fIpinned\fR
if it is dragged far enough horizontally
(the distance is determined by the
setting of the Tgif.MainMenuPinDistance X default).
Clicking the right mouse
button in a pinned menu will cause it to disappear.  Dragging
the left mouse button in a pinned menu will reposition the menu
(except when the Tgif.TitledPinnedMenu X default is set to true
in which case the left mouse button performs the same function
as the middle mouse button).
Clicking the middle mouse button in it will activate the item right
below the mouse.
.\"
.SH NON-ALPHANUMERIC KEY BINDINGS
.\"
Most operations that can be performed in tgif can be activated
through non-alphanumeric keys (some operations can only be
activated through popup menus or shortcut keys).
This section summarizes the operations that can be activated
by a key stroke with the <Control> and/or the <Meta> key held down.
``^'' denotes the <Control> key and ``#'' denotes the <Meta> key
in the following description.  (The ``\fIkeys.obj\fR'' file, distributed
with tgif, also summarizes the same information, but it is organized
differently.  This file can be viewed with tgif, and if installed properly,
it can be found in the same directory as the ``tgificon.obj'' file,
mentioned in the FILES section of this document.)
.PP
  ^a	select all
  ^b	send selected objects to the back
  ^c	copy selected objects into the cut buffer
  ^d	duplicate selected objects
  ^e	save/restore drawing mode
  ^f	send selected objects to the front
  ^g	group selected objects (the grouped object will be brought to the front)
  ^i	instantiate a building-block object
  ^k	pop back to (or return to) a higher level and close the symbol file
(reverse of ^v)
  ^l	align selected objects according to the current alignment settings
  ^n	open a new un-named object file
  ^o	open an object file to edit
  ^p	print the current page (or export in XBM, XPM, GIF, HTML, PDF, EPS,
or PS formats)
  ^q	quit tgif
  ^r	redraw the page
  ^s	save the current object/symbol file
  ^t	align selected objects to the grid according to the current alignment
  ^u	ungroup selected objects
  ^v	paste from the cut buffer
  ^w	change the drawing mode to text
  ^x	delete all selected objects
  ^y	change domain
  ^z	escape to driver
  ^,	scroll left
  ^.	scroll right
  ^-	print the current page with a specified command

  #a	attach selected text objects to a selected non-text object as attributes
  #b	escape to driver
  #c	rotate selected objects counter-clockwise
  #d	decrement the grid size
  #e	send a token on a selected polyline
  #f	flash a selected polyline
  #g	show/un-show grid points
  #h	flip the selected objects horizontally
  #i	increment the grid size
  #j	hide the attribute names of the selected objects
  #k	change the drawing mode to select
  #l	distribute selected objects according to the current alignment
  #m	move/justify an attribute of a selected object
  #n	show all the attribute names of the selected objects
  #o	zoom out
  #p	import a .obj or a .sym file into the current file
  #q	change the drawing mode to polyline/open-spline
  #r	change the drawing mode to rectangle
  #s	escape to driver
  #t	detach all the attributes of the selected objects
  #u	undo
  #v	flip the selected objects vertically
  #w	rotate the selected objects clockwise
  #x	escape to driver
  #y	escape to driver
  #z	zoom in
  #9	create a user-specified arc (12 o'clock position is 0 degree)
  #0	update the selected objects according to current settings
  #,	scroll up
  #.	scroll down
  #-	show all the attributes of the selected objects
  #[	align the left sides of objects
  #=	align the horizontal centers of objects
  #]	align the right sides of objects
  #{	align the top sides of objects
  #+	align the vertical centers of objects
  #}	align the bottom sides of objects
  #"	make the selected polygon regular (fit the original bounding box)
  #%	set the percent print reduction (if < 100%) or magnification (if > 100%)
  #:	go to default zoom
  #`	zoom out all the way so that the whole page is visible
  #~	save selected objects in a new file
  #;	cut and/or magnify a selected bitmap/pixmap object
  #_	abut selected objects horizontally
  #|	abut selected objects vertically
  ##	break up text objects into single character text objects
  #^	scroll to the origin set by SaveOrigin()
  #@	toggle between constrained and unconstrained move (stretch) modes
  #$	change the drawing mode to select vertices
  #&	align selected objects to the paper according to the current alignment
  #*	redo
  #(	import an Encapsulated PostScript file
  #)	scale selected objects by specifying X and Y scaling factors
  #<	lock the selected objects (can't be moved, stretched, flipped, or
rotated)
  #>	unlock the selected objects

 ^#a	add points to the selected poly or spline
 ^#b	change the text style to bold
 ^#c	change to center justified text
 ^#d	delete points from the selected poly or spline
 ^#e	change the drawing mode to rounded-corner rectangles
 ^#f	reverse-video the selected bitmap objects
 ^#g	toggle snapping to the grid points
 ^#h	hide all attributes of the selected objects
 ^#i	make the selected object iconic
 ^#j	make the selected icon object a grouped object
 ^#k	select color or black-and-white output
 ^#l	change to left justified text
 ^#m	make the selected object symbolic
 ^#n	make the selected symbol object a grouped object
 ^#o	change the text style to roman
 ^#p	change the text style to bold-italic
 ^#q	change the drawing mode to polygon/closed-spline
 ^#r	change to right justified text
 ^#s	save the file under a new name
 ^#t	change the text style to italic
 ^#u	update iconic representations of selected objects
 ^#v	change the drawing mode to oval
 ^#w	toggle between poly and spline
 ^#x	cycle among the various output file formats
 ^#y	push into (or edit) the definition part of a building-block (icon)
object
 ^#z	change the drawing mode to arcs
 ^#.	import an X11 bitmap file
 ^#,	import an X11 pixmap file
 ^#-	toggle between English and Metric grid systems
 ^#=	repeat the last Find command
.br
.\"
.SH SHORTCUTS
.\"
The user can define single character \fIshortcut\fR keys to emulate
the function of
the non-alphanumeric key presses to activate commands.
This is done through the use of the Tgif.ShortCuts X default.
(Please note that these shortcut keys are only active when
the drawing mode is \fInot\fR set to the text mode.)
The Tgif.ShortCuts consists of a list of items, each of which
specifies the bindings between
a key (may be case sensitive) and a command.  The items are
separated by blanks, and each item is interpreted as
follows.  It consists of two parts, KEY and COMMAND, which
are concatenated together with a ':' character.
The format of the KEY part is one of
\fI:<Key>x\fR, \fI!<Key>x\fR, or \fI<Key>x\fR (here the
character 'x' is used as an example; furthermore, the substring
\fI<Key>\fR must be spelled exactly the way it appears here).
The first 2 formats are
equivalent, they specify the \fIlower case\fR x; the 3rd
format specifies both the characters 'x' and 'X'.
The COMMAND part is a string that matches strings in tgif's popup menus
with space characters removed (exceptions are noted below).
This is illustrated by the following example.
In the Edit menu, two of the entries are,
.PP
   "Delete	^x"
.br
   "SelectAll	^a"
.PP
which means that <Control>x activates and Delete() command,
and <Control>a activates the SelectAll() command.
Therefore, both Delete() and SelectAll() are valid names for the COMMAND part of
a shortcut specification.  To complete the example,
the following line can be used to bind the lower case 'x' to
Delete() and 'a' or 'A' to SelectAll():
.PP
   Tgif.ShortCuts:	!<Key>x:Delete() \\n\\
.br
   			<Key>a:SelectAll()
.PP
For more examples, please
see the sample X defaults file, tgif.Xdefaults, included in the tgif
distribution.
.PP
Here is a list of exceptions where the COMMAND does not match
a command name in a menu entry.  The left entry is a proper
COMMAND name, and the right is a list of strings that's shown
in popup menus which the COMMAND would correspond to.
.PP
   CyclePrintFormat()	Printer, LaTeXFig, RawPSFile, XBitmap, TextFile, EPSI, GIF/ISMAP, TiffEPSI, NetList
   ToggleBW/ColorPS()	BlkWhtPS, ColorPS
   ToggleGridSystem()	EnglishGrid, MetricGrid
   ToggleMapShown()	ShowBit/Pixmap, HideBit/Pixmap
   ToggleUseGrayScale()	UseGrayScale, NoGrayScale
   ToggleMoveMode()	ConstMove, UnConstMove
   ToggleShowMeasurement()	ShowMeasurement, HideMeasurement

   ToggleLineType()	(advances between different curved shapes)
   ScrollPageUp()	(scroll up a window full)
   ScrollPageDown()	(scroll down a window full)
   ScrollPageLeft()	(scroll left a window full)
   ScrollPageRight()	(scroll right a window full)
   FreeHandMode()	(change the drawing mode to freehand poly/open-spline)
   CenterAnEndPoint()	(move an endpoint of a polyline object to the center
of another object)
   ToggleNamedAttrShown(<x>=)	(toggle name shown for the attribute <x>)
   ToggleSmoothHinge()	(convert smooth to hinge and hinge to smooth points)
   ToggleShowMenubar()	ShowMenubar, HideMenubar
   ToggleShowStatus()	ShowStatus, HideStatus
   ToggleShowMode()	ShowMode, HideMode
   ToggleOneMotionSelMove()	OneMotionSelMove, ClickSelClickMove
   ToggleHyperSpace()	GoHyperSpace, LeaveHyperSpace
   ImportOtherFileType(<x>)	(import using a filter named <x>)
   BrowseOtherType(<x>)	(browse using a filter named <x>)
   PrintSelectedObjs()	(print selected objects)
.br
.PP
In addition to the above list, the following are
also valid COMMAND names (having the obvious meaning):
ScrollLeft(), ScrollRight(), ScrollUp(), ScrollDown(),
SelectMode(), DrawText(), DrawBox(), DrawOval(), DrawPoly(),
DrawPolygon(), DrawRCBox(), DrawArc(), and SelectVertexMode().
.\"
.SH COLORS AND COLORMAPS
.\"
In most X environments, only 256 colors can be displayed at once.
In these environment, if an application needs 128 colors and
another application needs a totally different 129 colors, both
applications can not be displayed at once with all the colors
they want.  X solves the problem by allowing applications to
use their own colormaps (known as private colormaps).  Each
private colormap can have at most 256 colors.  There is also a
shared colormap available for applications that do not wish to
use private colormaps.  The main problem with using private
colormaps is that a user will see the the well-known
\fIcolormap flashing\fR phenomenon when he/she
switches in and out of applications that use private colormaps.
.PP
Tgif uses the shared colormap initially.  When it needs more
color than what is available in the shared colormap, it will use a
private colormap automatically.  When tgif no longer needs the
extra colors, it does \fInot\fR automatically revert to using
the shared colormap because it needs to be able to undo
operations that use the extra colors.  If one does no longer needs
the objects in the undo buffer, one can select FlushUndoBuffer()
from the Edit Menu to flush the undo buffer.  At this point,
tgif will attempt to use the shared colormap to avoid the
colormap flashing problem.  If one often uses XPM and GIF objects,
one can bind the <Shift>f key to the FlushUndoBuffer() operation
by setting the following X default and uses the <Shift>f key
to regain entries in the colormap when an XPM/GIF object is deleted:
.PP
.RS
Tgif.ShortCuts: !<Key>F:FlushUndoBuffer()
.br
.RE
.br
.PP
Even when a private colormap is used, only 256 colors can be used
at once.  Therefore, it is not possible to import two 256-colors GIF files
into the same drawing unless the colors are somehow reduced to fit in
the 256-colors colormap.  This can be done through \fIdithering\fR
which is described in the IMPORT RASTER GRAPHICS section below.
.\"
.SH IMPORT RASTER GRAPHICS
.\"
The native raster graphics formats that tgif supports are the XBM and
XPM formats.  In order to import color raster graphics file of another
format, tgif can work with external tools that can
convert non-XPM format files to an XPM files.  A popular raster
format conversion toolkit is the \fIpbmplus\fR(1) (also known as the
\fInetpbm\fR(1)) toolkit.  It can convert a GIF file (e.g., "foo.gif")
to an XPM file (e.g., "foo.xpm") with the following command
(\fIgiftopnm\fR is in netpbm; an earlier version of it called
\fIgiftoppm\fR exists in pbmplus):
.PP
.RS
giftopnm foo.gif | ppmtoxpm > foo.xpm
.br
.RE
.br
.PP
When working with tgif, a GIF file name will be supplied by
tgif and the output of ppmtoxpm will be directly read by tgif
through a pipe;
therefore, the previous sequence is replaced by an X default
containing the following form (which happens to be the
default setting for the Tgif.GifToXpm X default):
.PP
.RS
giftopnm %s | ppmtoxpm
.br
.RE
.br
.PP
The "%s" is to be replaced by a GIF file name.  The above is
referred to as a \fIfilter\fR.
.PP
To be able to import other types of raster graphics files, one can
use Tgif.MaxImportFilters and Tgif.ImportFilter# X defaults to
specify additional filters.
The following example adds a JPEG filter:
.PP
.RS
Tgif.MaxImportFilters: 1
.br
Tgif.ImportFilter0: \\n\\
.br
        JPEG-222 jpg;jpeg \\n\\
.br
        djpeg -gif -colors 222 %s | \\n\\
.br
        giftopnm | ppmtoxpm
.br
.RE
.br
.PP
The "JPEG-222" above is the name given to the filter
(must not contain any space character).
The "jpg;jpeg" are possible file extensions separated
by semicolons.  The rest is the filter specification.  The
djpeg(1) program is part of the libjpeg distribution.  It can convert
a JPEG file to a GIF file.  The above filter also restrict the
output to have a maximum of 222 colors.  (The 222 is chosen arbitrarily.
Many XPM files use some ``standard'' 32 colors, so one may want to
leave room form them.)
.PP
To invoke a filter, one can select ImportOtherFile() or BrowseOther()
commands from the File Menu.  This will bring up a dialogbox listing the
available filters by their names (e.g., "JPEG-222").  After selecting
a filter, tgif continues in a similar manner as with invoking
ImportXPixmap() or BrowseXPixmap() commands from the File Menu.
.PP
The above example is not suitable for the BrowseOther() command because
only 256 colors can be used in a drawing (as explained in the COLORS
AND COLORMAPS section above).  In order for BrowseOther() to work well,
one can use \fIdithering\fR to represent an image with a \fIdithered\fR
image that only uses a set of standard colors.  The example below uses
ppmdither from the pbmplus/netpbm toolkit:
.PP
.RS
Tgif.MaxImportFilters: 2
.br
Tgif.ImportFilter0: \\n\\
.br
        JPEG-222 jpg;jpeg \\n\\
.br
        djpeg -gif -colors 222 %s | \\n\\
.br
        giftopnm | ppmtoxpm
.br
Tgif.ImportFilter1: \\n\\
.br
        JPEG-dithered jpg;jpeg \\n\\
.br
        djpeg -gif %s | \\n\\
.br
        giftopnm | ppmdither | ppmtoxpm
.br
.RE
.br
.PP
If one is working with one JPEG image, one can select ImportOtherFile()
then select "JPEG-222" to get as many as 222 colors.  If one is
browsing for JPEG images, one can select BrowseOther() then select
"JPEG-dithered".
.\"
.SH OBJECT NAMES
.\"
If an object contains an attribute (please see the ATTRIBUTES sections
below for details) whose name is the string \fI"name"\fR (case-sensitive),
the value part
of the attribute is the \fIname\fR of the object.  Subobject of a
composite object can be named using a \fIpath\fR, e.g.,
\fI<t>!<s1>!<s2>!...\fR, where \fI<t>\fR is the name of a top-level object
which directly contains \fI<s1>\fR which directly contains \fI<s2>\fR, etc.
\fI!*\fR refers to the currently selected object (if
more than one object is selected, the top-most object in the stacking order
is used).
\fI!*<s1>!<s2>\fR names the \fI<s2>\fR subobject of the \fI<s1>\fR subobject
of the currently selected object.
.PP
The following is \fInot fully\fR supported, yet (only the \fI#<page>\fR
form is supported at this time).
Every object in a tgif file can be uniquely named using the notation
\fI#<page>!<path>\fR, where \fI<page>\fR can be a string that specifies the
name of a page or \fI#<number>\fR which specifies a page number.  The
\fI<path>\fR is described in the previous paragraph.  If an object \fIo1\fR
is referenced by another object \fIo2\fR within the same file 
(no file name or URL is specified before \fI#\fR) and \fI<page>\fR is
omitted, then \fIo1\fR must be on the same page as \fIo2\fR.
If a file name or URL is specified before \fI#\fR and \fI<page>\fR is
omitted, then \fIo1\fR must be on the first page.
.\"
.SH ATTRIBUTES
.\"
Attributes are text strings of the form \fIname=value\fR or \fIvalue\fR
which are attached to either the current drawing or any non-text objects.
An attribute attached to the current drawing is called a \fIfile attribute\fR;
otherwise, it is a \fIregular attribute\fR.
Attributes can be attached and detached from these objects
except in the following case:
.IP
Attributes appearing in the symbol object
in a building-block object file can not
be detached when the building-block object is instantiated.
These attributes are considered to be the ``inherited'' attributes
of the icon object.  (If it is really necessary to detach inherited
attributes of an icon object, the icon object
can be ``de-iconified'' by using UnMakeIconic() in the Special Menu
to make it a grouped object; then the attributes can be detached.)
.PP
A file attribute is always invisible.
For a regular attribute,
the user has control over which part of the attribute is displayed.
An entire attribute can be made invisible, or only its name
can be made invisible (accomplished through the commands under the
special menu, such as #m, #n, #j, #-, and ^#h).
.\"
.SH TELEPORT/HYPERJUMP
.\"
Tgif provides the mechanism to travel between .obj and .sym files.
If the middle mouse button is clicked on an object with the
<Shift> key held down (or double-clicking such an object), tgif
looks for an attribute named
\fIwarp_to\fR (by default) or \fIhref\fR of that object.
The only difference between \fIwarp_to\fR and \fIhref\fR is that
".obj" is automatically appended to the value of a \fIwarp_to\fR
attribute while the value of a \fIhref\fR attribute is taken as is.
(Please note that \fIwarp_to\fR is obsolete now.  It is still
supported for the sake of compatibility.)
If such an attribute is found, the value part of
the attribute is interpreted as the name of a .obj file to
\fItravel\fR to.
(If tgif is in the \fIhyperspace\fR mode, then clicking
the left mouse button has the same effect.)
If there are multiple \fIhref\fR attributes on the object,
but are in different colors, tgif will use the one that has
the same color as the current color appearing in the Choice Window.
If the current file is modified, the user
is prompted to save the file before traveling to the next file.
If the value part of the \fIhref\fR attribute starts with the '/'
character, the value is treated as an absolute file name;
otherwise, it is treated as a relative file name.
.\"
.SH HYPERSPACE
.\"
Tgif provides a \fIhyperspace\fR mode to facilitate traveling
between .obj files.  The hyperspace mode is entered when
GoHyperSpace() is selected from the Navigate Menu.  In
hyperspace mode, the little window below the Message Window will show
a little space ship.  The hyperspace mode is also automatically
entered when a remote URL is opened (unless the Tgif.AutoHyperSpaceOnRemote
X default is set to false).
.PP
In the hyperspace mode, certain objects are considered \fIhot-links\fR.
When the cursor is placed on top of these object, it will change from
a pointer to a hand to indicate that clicking on the left mouse button
will invoke some actions.
An object is a hot-link if it contains an attribute described in either
the TELEPORT/HYPERJUMP, LAUNCH APPLICATIONS, or INTERNAL COMMANDS section.
.PP
The hyperspace mode is exited when the drawing mode is changed or
the LeaveHyperSpace() is selected from the Navigate Menu.
.\"
.SH LAUNCH APPLICATIONS
.\"
Tgif provides the mechanism to launch applications.
If the middle mouse button is clicked on an object with the
<Shift> key held down (or double-clicking such an object), tgif
looks for an attribute named \fIlaunch\fR (by default) of
that object.  If such an attribute is found, the value part of
the attribute is interpreted as a sh(1) command to execute.
Same color rule applies as described in the TELEPORT/HYPERJUMP section above.
If the command ends with the '&' character, tgif forks itself (what
actual happens depends on whether the _BACKGROUND_DONT_FORK
compiler flag is defined or not at compile time) and
the command is executed by the child process; otherwise, popen()
is used to execute the command (in this case, if the command hangs,
there is no way provided to terminate the command, and
tgif will not be able to recover from it).
Within the command, values of other attributes of the same object can
be used.  The syntax is:  \fI$(attr)\fR, where \fIattr\fR is the name
of another attribute.

For example, if one wants to perform a man(1) function, one can draw
a box; enter a line of text "title=tgif"; enter another line of text
"launch=xterm -rw -e man $(title)"; select all three objects using ^a
keyboard command; attach the text strings to the box using #a keyboard
command; and launch the man(1) command by clicking the middle mouse button
on the box (or the text strings) with the <Shift> key held down.
If one wants to be more fancy, the box can be replaced by an X11 pixmap
object; the 'launch' attribute can be made invisible; and the 'title'
attribute can be center justified and with its name hidden using the #m
keyboard command.

By default, launching of an application is disabled in the
\fIhyperspace\fR mode for security considerations
(this can be overridden by the Tgif.AllowLaunchInHyperSpace X default
setting).
If a lunch command is encountered in the \fIhyperspace\fR mode,
the command is displayed and the user is prompted to see if
he/she wants to execute the command.
.\"
.SH INTERNAL COMMANDS
.\"
Tgif provides the mechanism to execute internal commands.
If the middle mouse button
is clicked on an object with the <Shift> key held down
(or double-clicking such an object), tgif looks for an
attribute named \fIexec\fR (by default) of that object.  If such an
attribute is found, the value part of the attribute is interpreted as
a list of internal commands (separated by semicolon) to execute.
Same color rule applies as described in the TELEPORT/HYPERJUMP section above.
A command usually takes the form:
.PP
.RS
<cmd_name> ( <arg1>, <arg2>, ..., <argN> )
.br
.RE
.br
.PP
An argument of a command can be a string argument or a numeric argument.
A string argument must be enclosed in double-quotes.  A numeric argument
can be a numerical value or a string of the form "$(\fIx\fR)", where \fIx\fR
is the name of another attribute (this form is referred as the
substitution form).  A string argument can also contain substitution form.
Please note that only one-level substitution are performed (the
collection of internal commands should be viewed as a simple
scripting language and \fInot\fR a declaration language).

When an attribute is referenced in an internal command, the attribute
name can be in the form, \fI<obj_name>.<string>\fR, where \fI<obj_name>\fR
must be in the form specified in the OBJECT NAMES section above
and \fI<string>\fR contains only alphanumeric characters and
the underscore ('_') character.
If the first 2 characters of an attribute name is "!.", the rest of the
attribute name names a file attribute.
If the first 2 characters of an attribute name is "!*", the rest of the
attribute name names an attribute of the currently selected object (if
more than one object is selected, the top-most object in the stacking order
is used).

Please note that lines that begin with "//" are treated as comments.

The following internal commands are supported:
.TP
.I launch(<attr_name>)
The value of the attribute specified by <attr_name> is interpreted as a
sh(1) command to execute.  Please see the LAUNCH APPLICATIONS section
above for more details.
.TP
.I exec(<attr_name>)
The value of the attribute specified by <attr_name> is interpreted as an
internal command to execute.  This is similar to a subroutine call.
Please note that the internal command is executed in the context of the
top-level which contain the attribute.
.TP
.I mktemp(<str>,<attr_name>)
This command makes a unique file name.
The <str> argument is a template string, e.g., "/tmp/TgifXXXXXX", and
it requires at least two "/" in it.
The result of mktemp() is stored as the value of the attribute specified
by <attr_name>.
Please see the man pages of the C library function on mktemp(3C) for more
details.  (If tgif is compiled with the -D_USE_TMPFILE compiler option,
then tempnam(3S) is used instead.)
.TP
.I create_file_using_simple_template(<template>,<output>,<str>,<attr_name>)
The file specified by <template> is scanned for a line that matches <str>.
When such a line is found, that line is replaced by the value of the
attribute specified by <attr_name>.  The result is put into the file
specified as <output>.
.TP
.I update_eps_child(<eps_file_name>)
This only works if the object being executed is a composite object.
If the object has a component which is an imported EPS (Encapsulated
PostScript) object, it is replaced by the EPS file specified by
<eps_file_name>.  If the object does not contain an EPS subobject,
an EPS subobject is created.
.TP
.I update_xbm_child(<xbm_file_name>)
This only works if the object being executed is a composite object.
If the object has a component which is an imported XBM (X11 bitmap) object,
it is replaced by the XBM file specified by <xbm_file_name>.
If the object does not contain an XBM subobject, an XBM subobject is created.
.TP
.I update_xpm_child(<xpm_file_name>)
This only works if the object being executed is a composite object.
If the object has a component which is an imported XPM (X11 pixmap) object,
it is replaced by the XPM file specified by <xpm_file_name>.
If the object does not contain an XPM subobject, an XPM subobject is created.
.TP
.I delete_eps_child(<obj_name>)
This only works if the object named <obj_name> is a composite object.
If the object has a component which is an EPS (Encapsulated PostScript)
object, it is deleted.  If the object does not contain an EPS subobject,
no operation is performed.
.TP
.I delete_xpm_child(<obj_name>)
This only works if the object named <obj_name> is a composite object.
If the object has a component which is an XPM (X11 pixmap) object,
it is deleted.  If the object does not contain an XPM subobject,
no operation is performed.
.TP
.I delete_xbm_child(<obj_name>)
This only works if the object named <obj_name> is a composite object.
If the object has a component which is an XBM (X11 bitmap) object,
it is deleted.  If the object does not contain an XBM subobject,
no operation is performed.
.TP
.I flip_deck(<times>,<frames_per_second>,<style>)
This only works if the object being executed is a composite object
and all subobjects of the composite object are X11 bitmap or X11 pixmap
objects and have identical positions and sizes.
The <times> argument specifies the number of times the deck is flipped.
It can be a number or the string "infinite".
The <frames_per_second> argument must be a number between 1 and 60.
The <style> argument can be either "linear" or "ping_pong".
When this command is being executed, any mouse button click or key click
aborts command execution.
.TP
.I read_file_into_attr(<file_name>,<attr_name>)
This command reads a file into an attribute.
The <file_name> argument names a file, e.g., "/tmp/foo".
The content of the file is read as the value of the attribute specified
by <attr_name>.  If the file can not be opened for read, the attribute's
value is set to an empty string.
.TP
.I write_attr_into_file(<attr_name>,<file_name>)
This command writes the value of an attribute into a file.
The <file_name> argument names a file, e.g., "/tmp/foo".
The value of the attribute specified by <attr_name> is
written into <file_name>.
.TP
.I append_attr_into_file(<attr_name>,<file_name>)
This command appends the value of an attribute into a file.
The <file_name> argument names a file, e.g., "/tmp/foo".
The value of the attribute specified by <attr_name> is
appended into <file_name>.
.TP
.I select_obj_by_name(<obj_name>)
This command silently (no highlighting handles) selects an
object named <obj_name>.  Please see the OBJECT NAMES section
above for the specification of object names.
.TP
.I select_top_obj()
This command silently (no highlighting handles) selects the top object.
This command fails if there is no object in the current page.
.TP
.I delete_selected_obj()
This command deletes all selected objects.
This command fails if no object is selected.
.TP
.I unselect_all_obj()
This command de-selects all selected objects.  If the select_obj_by_name()
command is used, this command must be used eventually.
.TP
.I move_selected_obj_relative(<dx>,<dy>)
This command moves the selected object by <dx> absolute units in the
x direction and <dy> absolute units in the y direction.
.TP
.I repeat(<cmd_attr_name>,<times>)
This command executes the internal command in the <cmd_attr_name> attribute
<times> times.
.TP
.I hyperjump(<attr_name>)
This command teleports to the file name or URL name found in the
<attr_name> attribute.
.TP
.I make_cgi_query(<dest_attr_name>,<url_name>,<list_attr_name>)
This command constructs an URL in the Common Gateway Interface (CGI)
format in the <dest_attr_name> attribute.
<url_name> names the CGI server script and <list_attr_name> names an attribute
whose value are comma-separated attribute names.  For example, if an
object has the following attributes:
.PP
.RS
.RS
attr_list=last_name,first_name
.br
last_name=Cheng
.br
first_name=Bill
.br
final_url=
.br
exec=make_cgi_query(final_url,
.br
    http://bourbon.usc.edu:8001/cgi-bin/test-cgi,
.br
    attr_list)
.RE
.PP
Executing this object will construct the following string in final_url:
.PP
.RS
http://bourbon.usc.edu:8001/cgi-bin/test-cgi?last_name=Cheng&first_name=Bill
.RE
.PP
An subsequent hyperjump(final_url) command can be invoked to execute the
corresponding
"test-cgi" CGI server script with the last_name and first_name arguments.
.PP
For a detailed description of CGI scripts, the reader is referred to [2].
.RE
.TP
.I wait_click(<cursor_name>,<grab>,<attr_name>)
This command displays the <cursor_name> cursor and waits for the user to
click a mouse button.
If <cursor_name> is the string \fINULL\fR (case-sensitive),
the cursor will not change.
If <Btn1> is clicked, the command terminates and
1 is placed in <attr_name>.  If <Btn2> is clicked, 2 is placed in <attr_name>,
etc.  If <grab> set to \fITRUE\fR (case-sensitive), then the mouse is
grabbed by tgif.  Valid
<cursor_name> can be found in <X11/cursorfont.h> (without the XC_ prefix).
.TP
.I sleep(<cursor_name>,<ms_interval>)
This command displays the <cursor_name> cursor and waits for <ms_interval>
milliseconds to elapse.
If <cursor_name> is the string \fINULL\fR (case-sensitive),
the cursor will not change.
This command can be interrupted (and aborted)
by any mouse clicks or key strokes.
Valid <cursor_name> can be found in <X11/cursorfont.h>
(without the XC_ prefix).
.TP
.I begin_animate()
This command is used to start an animation sequence (using double-buffering).
Please note that, by default, tgif
prepares for undo/redo.  For a long animation sequence, the undo/redo
records may take up a lot of memory.  In this case, disable_undo() (described
below) should be used before this command.
.TP
.I end_animate()
This command is used to terminate an animation sequence.
.TP
.I set_redraw(<true_or_false>)
This command is used to temporarily disable redraw if <true_or_false>
is \fIFALSE\fR (case-sensitive) when tgif is in the \fIanimation\fR
mode (turned on by begin_animate()).  If a shuffle_obj_to_top()
or a shuffle_obj_to_bottom() command is
used before a move command, set_redraw(FALSE) and set_redraw(TRUE)
should be used immediately before and immediately after, respectively, the
shuffle_obj_to_top() or shuffle_obj_to_bottom() command.
.TP
.I set_selected_obj_color(<color_str>)
This command changes the color of the selected object to <color_str>.
If no object is selected, the current color will be changed to <color_str>.
.TP
.I set_selected_obj_fill(<fill_index>)
This command changes the fill pattern of the selected object to
<fill_index>, which must be between 0 (for
no fill) and 31.
If no object is selected, the current fill pattern will be changed to
<fill_index>.
.TP
.I set_selected_obj_pen(<pen_index>)
This command changes the pen of the selected object to <pen_index>,
which must be between 0 (for no pen) and 31.
If no object is selected, the current pen will be changed to
<pen_index>.
.TP
.I set_selected_obj_line_width(<width>,<arrow_w>,<arrow_h>)
This command changes the line width, arrow width, and arrow height of the
selected object to <width>, <arrow_w>, and <arrow_h>,
respectively.  If <arrow_w> or <arrow_h> is -1, the
arrow width or arrow height, respectively, is not changed.
If no object is selected, the current line width will be changed to
the one that matches <width>, <arrow_w>, and <arrow_h> most closely.
(Closeness is measured such that the difference in width is counted
10 times the difference in arrow width and arrow height.)
.TP
.I set_selected_obj_spline(<spline_type>)
This command changes the spline type of the selected object to
<spline_type>, which can be \fIstraight\fR, \fIspline\fR,
\fIinterpolated\fR, or \fIstructured\fR.
If no object is selected, the current spline type will be changed to
<spline_type>.
.TP
.I set_selected_obj_arrow(<arrow_type>)
This command changes the arrow type of the selected object to
<arrow_type>, which can be \fInone\fR, \fIright\fR, \fIleft\fR, or
\fIdouble\fR.
If no object is selected, the current arrow type will be changed to
<arrow_type>.
.TP
.I set_selected_obj_dash(<dash_index>)
This command changes the dash type of the selected object to
<dash_index>, which must be between 0 (solid) and 8.
If no object is selected, the current dash type will be changed to
<dash_index>.
.TP
.I set_selected_obj_trans_pat(<trans_pat>)
This command changes selected object to have opaque pattern if <trans_pat>
is 0; it changes selected object to have transparent pattern if
<trans_pat> is any other numeric value.
If no object is selected, the current fill and pen pattern will be
opaque if <trans_pat> is 0 and will be transparent if
<trans_pat> is any other numeric value.
.TP
.I set_selected_obj_rcb_radius(<rcb_radius>)
This command changes the rcbox radius of the selected object to <rcb_radius>,
which must be greater or equal to 4.
If no object is selected, the current rcbox radius will be changed to
<rcb_radius>.
.TP
.I set_selected_text_vspace(<vspace>)
This command changes the text vspace of the selected object to <vspace>.
If no object is selected, the current text vspace will be changed to <vspace>.
.TP
.I set_selected_text_just(<justification>)
This command changes the text justification of the selected object to
<justification>, which can be \fIleft\fR, \fIcenter\fR, or
\fIright\fR.
If no object is selected, the current text justification will be changed to
<justification>.
.TP
.I set_selected_text_font(<ps_font_name>)
This command changes the font and text style of the selected object to match
<ps_font_name>.  Examples of valid <ps_font_name> can be found when one
selects CopyProperties() from the Properties Menu.  The item listed under
\fItext font\fR is a valid <ps_font_name>.
If no object is selected, the current font and text style will be changed to
match <ps_font_name>.
This command fails if no match can be found.
.TP
.I set_selected_text_style(<textstyle>)
This command changes the text style of the selected object to
<textstyle>, which can be \fIr\fR (for roman), \fIb\fR (for bold),
\fIi\fR (for italic), or \fIbi\fR (for bold-italic).
If no object is selected, the current text style will be changed to
<textstyle>.
.TP
.I set_selected_text_size(<size>)
This command changes the text size of the selected object to
<size>.  If <size> ends with the substring "pt", then point size is
used instead of text size.  If such as size cannot be found in the
Size Menu, the closest size in the Size Menu will be used.
If no object is selected, the current text size will be changed to
<size> or the closest size.
.TP
.I set_selected_text_underline(<underline>)
This command removes text underline from the selected object if
<underline> is 0; it underlines text in the selected object if
<underline> is any other numeric value.
If no object is selected, the current text underline will be changed
accordingly.
.TP
.I set_selected_text_overline(<overline>)
This command removes text overline from the selected object if
<overline> is 0; it overlines text in the selected object if
<overline> is any other numeric value.
If no object is selected, the current text overline will be changed
accordingly.
.TP
.I inc(<attr_name>,<expr>)
This command increment <attr_name> by the expression
<expr>.  Both the value of <attr_name> and <expr> must be integers.
Please see the ARITHMETIC EXPRESSIONS section below for details about
expressions.
.TP
.I dec(<attr_name>,<expr>)
This command decrement <attr_name> by
<expr>.  Both the value of <attr_name> and
<expr> must be integers.
.TP
.I shuffle_obj_to_top(<obj_name>)
This command move <obj_name> to the top.  If <obj_name>
is a subobject, it is raised to the top, relative to its siblings.
This command is useful in animation where a selected frame (subobject)
can be raised to the top.
.TP
.I shuffle_obj_to_bottom(<obj_name>)
This command move <obj_name> to the bottom.  If <obj_name>
is a subobject, it is dropped to the bottom, relative to its siblings.
This command is useful in animation where a selected frame (subobject)
can be dropped to the bottom.
.TP
.I disable_undo()
This command cleans up the undo/redo records and disable undo (and
stop recording undo/redo information).  The original history depth
is saved away.
This command should be used before a long animation sequence.
.TP
.I enable_undo()
This command restores the history depth saved away by the disable_undo()
command and enables undo/redo.
This command should be eventually used after disable_undo() is called.
.TP
.I get_drawing_area(<ltx_attr>,<lty_attr>,<rbx_attr>,<rby_attr>)
This command stores the absolute coordinate of the current drawing
area in the specified attributes.
<ltx_attr> stores the left-top X coordinate,
<lty_attr> stores the left-top Y coordinate,
<rbx_attr> stores the right-bottom X coordinate, and
<rby_attr> stores the right-bottom Y coordinate.
.TP
.I get_selected_obj_bbox(<ltx_attr>,<lty_attr>,<rbx_attr>,<rby_attr>)
This command stores the absolute coordinate of the bounding box
of the selected object in the specified attributes.
<ltx_attr> stores the left-top X coordinate,
<lty_attr> stores the left-top Y coordinate,
<rbx_attr> stores the right-bottom X coordinate, and
<rby_attr> stores the right-bottom Y coordinate.
The bounding box is computed assuming that all lines are of width 0.
.TP
.I get_named_obj_bbox(<obj_name>,<ltx_attr>,<lty_attr>,<rbx_attr>,<rby_attr>)
This command stores the absolute coordinate of the bounding box
of the object named <obj_name> in the specified attributes.
<ltx_attr> stores the left-top X coordinate,
<lty_attr> stores the left-top Y coordinate,
<rbx_attr> stores the right-bottom X coordinate, and
<rby_attr> stores the right-bottom Y coordinate.
The bounding box is computed assuming that all lines are of width 0.
.TP
.I move_selected_obj_absolute(<ltx>,<lty>)
This command moves left-top corner of the selected object to (<ltx>,<lty>).
.TP
.I assign(<attr_name>,<expr>)
This command assigns <expr> to the attribute specified by <attr_name>.
<expr> must be evaluated to a numeric value.
.TP
.I strcpy(<attr_name>,<string>)
This command copies <string> into the attribute specified by <attr_name>.
.TP
.I copy_string_to_cut_buffer(<string>)
This command copies <string> into the cut buffer.
.TP
.I strcat(<attr_name>,<string>)
This command appends <string> to the attribute specified by <attr_name>.
.TP
.I while(<expr>,<cmd_attr_name>)
This command keeps executing the internal command in
<cmd_attr_name> until <expr> evaluates to 0.
.TP
.I if(<expr>,<then_cmd_attr_name>,<else_cmd_attr_name>)
If <expr> evaluates to 0, the internal command in
<else_cmd_attr_name> is executed; otherwise, the
internal command in <then_cmd_attr_name> is executed.
<then_cmd_attr_name> or <else_cmd_attr_name> can be
the string \fINULL\fR (case-sensitive);
in this case, no corresponding action is taken.
.TP
.I get_current_file(<attr_name>)
This command stores the full path name of the current file in <attr_name>.
.TP
.I get_current_export_file(<attr_name>)
This command stores the full path name of the output (print/export) file in
<attr_name>.
.TP
.I get_current_dir(<attr_name>)
This command stores the current directory in <attr_name>.
.TP
.I getenv(<attr_name>,<env_var_name>)
This command stores the environment variable named <env_var_name>
in <attr_name>.
.TP
.I strlen(<attr_name>,<string>)
This command assigns the number of characters in <string> to <attr_name>.
.TP
.I substr(<attr_name>,<string>,<start_index>,<length>)
This command copies <length> characters, starting from the character index
<start_index>, of <string> into <attr_name>.  The <start_index> is zero-based.
.TP
.I strstr(<attr_name>,<string>,<sub_string>)
This command finds the first occurrence of <sub_string> in <string> and
copies <sub_string> and the rest of the string into <attr_name>.
.TP
.I strrstr(<attr_name>,<string>,<sub_string>)
This command finds the last occurrence of <sub_string> in <string> and
copies <sub_string> and the rest of the string into <attr_name>.
.TP
.I unmake_selected_obj_iconic()
This command has the same effect as selecting UnMakeIconic() from the
Special Menu except that at least one object must be selected already.
.TP
.I hyperjump_then_exec(<attr_name>,<attr_name_to_exec>)
This command teleports to the file name or URL name found in the
<attr_name> attribute then executes the internal command specified by the
<attr_name_to_exec> attribute in the new file.
.TP
.I show_attr(<attr_name>)
This command makes the <attr_name> attribute visible.
.TP
.I hide_attr(<attr_name>)
This command makes the <attr_name> attribute invisible.
.TP
.I show_attr_name(<attr_name>)
This command makes the name part of the <attr_name> attribute visible.
.TP
.I hide_attr_name(<attr_name>)
This command makes the name part of the <attr_name> attribute invisible.
.TP
.I show_value(<attr_value>)
This command makes the attribute whose name is empty and whose
value is <attr_value> visible.
.TP
.I hide_value(<attr_value>)
This command makes the attribute whose name is empty and whose
value is <attr_value> invisible.
.TP
.I get_attr_bbox(<ltx_attr>,<lty_attr>,<rbx_attr>,<rby_attr>,<attr_name>)
This command stores the absolute coordinate of the bounding box
of the <attr_name> attribute in the specified attributes.
<ltx_attr> stores the left-top X coordinate,
<lty_attr> stores the left-top Y coordinate,
<rbx_attr> stores the right-bottom X coordinate, and
<rby_attr> stores the right-bottom Y coordinate.
The bounding box is computed assuming that all lines are of width 0.
.TP
.I size_selected_obj_absolute(<abs_w>,<abs_h>)
This command stretches the right-bottom corner of the selected object
so that its width becomes <abs_w> and height becomes <abs_h>.
.TP
.I size_named_obj_absolute(<obj_name>,<abs_w>,<abs_h>)
This command stretches the right-bottom corner of the object named <obj_name>
so that its width becomes <abs_w> and height becomes <abs_h>.
.TP
.I message_box(<attr_name>,<msg>,<title>,<style>)
This command displays a messagebox with <title> as the title and <msg>
as the message.  <style> can be the string "info", "ync", "yn", or "stop".
The messagebox display an OK button for the "info" or "stop" styles,
YES/NO/CANCEL buttons for the "ync" style, YES/NO buttons for the "yn" style.
When the user click a button in the messagebox, the name of the button
will be placed in <attr_name>.  If the user cancels the messagebox by
typing the <ESC> key, <attr_name> will be set to the string "CANCEL".
If <attr_name> is the string \fINULL\fR (case-sensitive), the information
about which button is clicked is not written anywhere.  If <title> is
the string \fINULL\fR, \fITgif\fR will be the title for the messagebox.
.TP
.I get_user_input(<attr_name>,<msg1>,<msg2>)
This command displays a dialogbox with <msg1> in the first line and
<msg2> in the second line.  If <msg2> is the string "USE_CURRENT_DIR",
the second line displays the current directory.  The user can type in
a line in the dialogbox which get placed in <attr_name>.  If the user
cancels the dialog by typing the <ESC> key, <attr_name> will be set to
the empty string.
.TP
.I add_attr_to_selected_obj(<attr_name>,<attr_value>,<abs_x>,<abs_y>)
This command adds <attr_name>=<attr_value> to a selected object and
place the attribute at (<abs_x>,<abs_y>).  If <attr_name> is the string
\fINULL\fR (case-sensitive), the attribute's name will be the empty
string.  If <abs_x> and <abs_y> are both \fINULL\fR (case-sensitive),
the attribute will be placed below the lower left corner of the object.
If <attr_name> starts with "!.", a \fIfile attribute\fR will be added.
.TP
.I delete_attr_from_selected_obj(<attr_name>)
This command deletes an attribute named <attr_name> from a selected object.
If <attr_name> starts with "!.", a \fIfile attribute\fR will be deleted.
.TP
.I user_end_an_edge(<attr_name>,<abs_x>,<abs_y>)
This command starts a polyline/open-spline at (<abs_x>,<abs_y>),
switches the drawing mode to the draw polyline/open-spline, and
lets the user finish the polyline/open-spline.  If the endpoint
falls in an object having an attribute \fItype=port\fR, that object's
name will be placed in <attr_name>, if <attr_name> is not the string
\fINULL\fR (case-sensitive).
.TP
.I user_draw_an_edge(<start_attr_name>,<end_attr_name>)
This command switches the drawing mode to the draw polyline/open-spline and
lets the user draw a polyline/open-spline.
If the first endpoint falls in an object having an attribute
\fItype=port\fR, that object's name will be placed in <start_attr_name>,
if <end_attr_name> is not the string \fINULL\fR (case-sensitive).
If the last endpoint falls in an object having an attribute
\fItype=port\fR, that object's name will be placed in <end_attr_name>,
if <attr_name> is not the string \fINULL\fR (case-sensitive).
.TP
.I get_a_poly_vertex_absolute(<x_attr_name>,<y_attr_name>,<obj_name>,<index>)
This command stores the absolute coordinate of the <index>\fIth\fR vertex
of <obj_name> in attributes specified by <x_attr_name> and <y_attr_name>.
The object specified by <obj_name> must be either a poly/open-spline or a
polygon/closed-spline object.
.TP
.I move_a_poly_vertex_absolute(<obj_name>,<index>,<abs_x>,<abs_y>)
This command moves the <index>\fIth\fR vertex
of <obj_name> to the absolute coordinate (<abs_x>,<abs_y>).
The object specified by <obj_name> must be either a poly/open-spline or a
polygon/closed-spline object.
.TP
.I post_attr_and_get_cgi_result(<url_attr>,<query_attr>,<result_attr>)
This command makes an HTTP request using the \fIPOST\fR method.
<url_attr> names the attribute that contains the URL (which usually names
a CGI server script).  <query_attr> names
the attribute whose value is the data to be posted.  <result_attr> names
the attribute for receiving the results.
For example, if an object has the following attributes:
.PP
.RS
.RS
url=http://bourbon.usc.edu:8001/cgi-bin/echo-post
.br
query=Hello World!
.br
result=
.br
exec=post_attr_and_get_cgi_result(url,query,result)
.RE
.RE
.PP
.RS
executing this object will post "Hello World!" to the specified
CGI script.  In this case, the result of executing the script just
echoes "Hello World!" back (along with some other bookkeeping information).
.RE
.TP
.I navigate_back()
This command performs the same operation as if the NavigateBack() is
selected from the Navigate Menu.
.TP
.I stop()
This command stops the execution of all internal commands.
.TP
.I sqrt(<attr_name>,<expr>)
This command assigns the square-root of <expr> to <attr_name>.
<expr> must be evaluated to a non-negative numeric value.
.TP
.I random(<attr_name>)
This command assigns a random integer to <attr_name> using the C
library function \fIrand()\fR.  0 is used as a seed for the random
number generator.
.TP
.I srand48(<use_cur_time_as_seed>)
This command seeds the random generator used by the C library function
\fIdrand48()\fR.
If <use_cur_time_as_seed> is 0, 0 will be used as a seed.
Otherwise, the current time will be used as a seed.
.TP
.I drand48(<attr_name>)
This command assigns a floating pointer number between 0.0 and 1.0
to <attr_name> using the C library function \fIdrand48()\fR.
.TP
.I round(<attr_name>,<expr>)
This command assigns the round of <expr> to <attr_name>.
.TP
.I redraw_obj(<obj_name>)
This command redraws the area occupied by <obj_name>.
.TP
.I redraw_drawing_area()
This command redraws the whole drawing area (visible through
the Canvas Window).
.TP
.I itox(<attr_name>,<digits>,<expr>)
This command assigns <attr_name> to be the hex value of <expr>.
<digits> (which must be between 1 and 8, inclusive) is the final
width of the hex value (zeroes are added on the left).
.TP
.I for_i(<attr_name>,<min_val>,<max_val>,<increment>,<cmd_attr_name>)
This command is the same as the following sequence of commands:
.PP
.RS
.RS
assign(<attr_name>,<min_val>);
.br
while($(<attr_name>) <= <max_val>,\fIloop\fR)
.RE
.RE
.PP
.RS
where \fIloop\fR has the following value:
.RE
.PP
.RS
.RS
exec(<cmd_attr_name>);
.br
inc(<attr_name>,<increment>)
.RE
.RE
.PP
.RS
Please note that <min_val>, <max_val>, and <increment> are
only evaluated once prior the execution of this command.
.RE
.TP
.I set_file_not_modified()
This command sets the file modified flag to false.
.TP
.I new_id(<attr_name>)
This command generates an object ID, which is unique in
the current drawing, and stores it in <attr_name>.
.TP
.I rotate_selected_obj(<angle>)
This command rotates the selected object by <angle> degrees.
Positive angle is clockwise.
.TP
.I call_simple_shortcut(<shortcut_name>)
This command calls a shortcut named <shortcut_name> which takes no arguments.
Please see the SHORTCUTS section for a description of shortcuts.
.TP
.I call_one_arg_shortcut(<shortcut_name>,<arg>)
This command calls a shortcut named <shortcut_name> that takes one argument
and passes <arg> to it.
Please see the SHORTCUTS section for a description of shortcuts.
.TP
.I substitute_attr(<attr_name>,<src_attr_name>,<replace_attr_name>,<pattern_str>)
This command replaces occurrences of <pattern_str> in the value part of the
attribute specified by <src_attr_name> by the value of the attribute
specified by <replace_attr_name> and write the result into the attribute
specified by <attr_name>.
.TP
.I get_file_size(<attr_name>,<file_name>)
This command puts the size of file specified by <file_name> in the
attribute specified by <attr_name>.
.TP
.I is_file(<attr_name>,<file_name>)
This command puts a "1" in the attribute specified by <attr_name> if the
file specified by <file_name> exists.  It puts a "0" otherwise.
.TP
.I index(<attr_name>,<string>,<sub_string>)
This command finds the first occurrence of <sub_string> in <string> and
copies the zero-based index into <attr_name>.
.TP
.I rindex(<attr_name>,<string>,<sub_string>)
This command finds the last occurrence of <sub_string> in <string> and
copies the zero-based index into <attr_name>.
.TP
.I get_number_of_lines_in_attr(<result_attr>,<attr_name>)
This command counts the number of lines in the attribute specified by
<attr_name> and writes the count into <result_attr>.
.TP
.I get_line_in_attr(<result_attr>,<attr_name>,<line_number>)
This command copies the \fIn\fRth line of the attribute specified by
<attr_name> into <result_attr>, where \fIn\fR is a zero-based index
specified by <line_number>.
.TP
.I trim(<attr_name>)
This command removes leading and trailing blank characters from
the attribute specified by <attr_name>.
.TP
.I is_attr(<result_attr>,<attr_name>)
This command writes a "1" into <result_attr> if the attribute
specified by <attr_name> exists.  It writes a "0" into <result_attr>
otherwise.
.TP
.I find_obj_names(<result_attr>,<obj_name>,<attr_name_value>)
This command finds all objects that are direct sub-objects of the
object specified by <obj_name> and writes their names into <result_attr>.
If <obj_name> is an empty string, all top-level objects are scanned.
.PP
.RS
<attr_name_value> specifies a filter for the objects.  If
<attr_name_value> is the empty string, all qualifying objects are selected.
If <attr_name_value> is of the form "<string>=*", an object is selected
if it has an attribute named <string>.
If <attr_name_value> is of the form "<string>=<value>", an object is
selected if it has an
attribute named <string> and its corresponding value is <value>.
If <attr_name_value> does not contain the '=' character,
an object is selected if it has an attribute whose name is empty and
the corresponding value is identical to <attr_name_value>.
.RE
.PP
.RS
If \fIn\fR objects are matched, the attribute specified by <result_attr>
is updated with \fIn+1\fR lines.  The value of the zeroth line becomes
\fIn\fR and the object names becomes lines 1 through \fIn\fR of <result_attr>.
The get_line_in_attr() internal command can be used to retrieve the
object names.
.RE
.TP
.I find_obj_names_on_all_pages(<result_attr>,<attr_name_value>)
This command is similar to find_obj_names() above, except that it
only finds top-level objects on all pages.
The result is written into <result_attr>.  For a multi-page file,
a top-level object name \fI<name>\fR will be written into <result_attr>
as \fI##<page_num>!<name>\fR.  For a single-page file, this command behaves
exactly the same as find_obj_names(<result_attr,"",<attr_name_value>).
.TP
.I tg2_find_obj_names_on_all_pages(<result_attr>,<attr_name_value>)
This command is identical to find_obj_names_on_all_pages() above, except
that for a multi-page file, a top-level object name \fI<name>\fR will be
written into <result_attr> as \fI<name>_Page<page_num>\fR.
.TP
.I tokenize(<result_attr>,<string>,<separator>)
This command breaks <string> into tokens which are separated by the
<separator> character and writes the tokens (in the same fashion as
in the find_obj_names() internal command above) into <result_attr>.
<separator> must be a string of length of 1 and it must not be the space
character, the single-quote character, or the double-quote character.
If a token contains the separator character, the token can be surrounded
by a pair of single-quotes or double-quotes which are automatically removed
when this command is executed.
.PP
.RS
If \fIn\fR tokens are found, the attribute specified by <result_attr>
is updated with \fIn+1\fR lines.  The value of the zeroth line becomes
\fIn\fR and the tokens becomes lines 1 through \fIn\fR of <result_attr>.
The get_line_in_attr() internal command can be used to retrieve the
tokens.
.RE
.TP
.I move_attr_relative(<attr_name>,<dx>,<dy>)
This command moves the attribute whose name is <attr_name> by <dx> absolute
units in the x direction and <dy> absolute units in the y direction.
.TP
.I get_number_of_vertices(<result_attr>,<obj_name>)
This command copies the number of vertices of the object specified by
<obj_name> into <result_attr>.  The specified object must be a polyline
(open-spline) or a polygon (closed-spline).
.TP
.I is_obj_transformed(<result_attr>,<obj_name>)
This command writes a "1" into <result_attr> if the object
specified by <obj_name> is transformed (rotated or sheared).
It writes a "0" into <result_attr> otherwise.
.TP
.I make_selected_obj_iconic(<sym_path>)
This command works like the MakeIconic() command from the Special Menu,
except that the user is not prompted for the name of the icon.  Instead,
<sym_path> is used to specify the full path name of the icon.
.TP
.I get_tgif_version(<major_attr,minor_attr,patchlevel_attr,build_attr>)
This command writes tgif's major version number, minor version number,
patchlevel, and build information into
<major_attr>, <minor_attr>, <patchlevel_attr> and <build_attr>, respectively.
If an argument is the string \fINULL\fR (case-sensitive), that
information is skipped.
.TP
.I get_tgif_dir(<result_attr>)
This command writes "$HOME/.Tgif" into <result_attr> where $HOME is the
home directory of the user.
.TP
.I get_profile_string(<result_attr>,<section>,<key>,<def_value>,<ini_path>)
This command gets the value associated with the key specified by <key>
from the section specified by <section> in the file specified by the full
path <ini_path> and stores it into the attribute specified by
<result_attr>.  If there is not value associated with the specified key,
<def_value> is stored into <result_attr>.
If <key> is an empty string, all the key names in
<section> of <ini_path> will be written (in the same fashion as in the
find_obj_names() internal command above) into <result_attr>.
If <section> is an empty string, all the section names in
<ini_path> will be written (in the same fashion as in the
find_obj_names() internal command above) into <result_attr>.
.TP
.I write_profile_string(<section>,<key>,<value>,<ini_path>)
This command sets the value associated with the key
specified by <key> of the section specified by <section>
in the file specified by the full path <ini_path> to be <value>.
If <key> is an empty string, all key/value pairs in
<section> of <ini_path> will be cleared.
<section> should not be an empty string.
.TP
.I select_additional_obj(<obj_name>)
This command silently (no highlighting handles) selects an additional
object named <obj_name>.  Please see the OBJECT NAMES section
above for the specification of object names.
.TP
.I open_file(<file_number>,<file_name>,<file_mode>)
This command opens the file specified by <file_name> in the
mode specified by <file_mode> and assigns the opened file a file reference
number of <file_number>.  <file_number> must be 0 or between 3 and 15.
Opening file 0 \fIrewinds\fR the standard input.
Examples of modes are "r" for reading, "w"
for writing, and "a" for appending.
A file is always opened in text (non-binary) mode.
.TP
.I close_file(<file_number>)
This command closes the file associated with file reference number
<file_number>.  <file_number> must be 0 or between 3 and 15.
.TP
.I read_file(<file_number>,<result_attr>)
This command reads a line from the file associated with file reference number
<file_number> and put the line in the attribute specified by <result_attr>.
<file_number> must be between 0 (for standard input) or between 3 and 15.
.TP
.I write_file(<file_number>,<string>)
This command writes <string> to the file associated with file reference number
<file_number>.  <file_number> must be between 1 and 15.
Numbers 1 and 2 are for standard output and standard error files.
.TP
.I flush_file(<file_number>)
This command flushes the file associated with file reference number
<file_number>.  <file_number> must be between 1 and 15.
Numbers 1 and 2 are for standard output and standard error files.
.TP
.I append_file(<dest_file_name>,<src_file_name>)
This command appends the file specified by <src_file_name> to the file
specified by <dest_file_name>.
.TP
.I set_output_format(<format>,<color_output>)
This command sets the output format to <format>.  If <color_output>
is 0, black and white output (printing) mode will be used; otherwise,
color output (printing) mode will be used.
Please see the Tgif.WhereToPrint X default for a list of possible formats.
.TP
.I set_export_clip_rect(<ltx>,<lty>,<rbx>,<rby>)
This command sets the export clipping rectangle to be a rectangular
region with left-top corner at (<ltx>,<lty>) and right-bottom corner
at (<rbx>,<rby>).  <ltx> must be strictly less than <rbx> and
<lty> must be strictly less than <rby>.
.TP
.I import_file(<file_name>,<format>,<ltx>,<lty>)
This command imports the file specified by <file_name> and places it
at (<ltx>,<lty>).  The file is expected to be in the format specified
by <format>, which can be "XBM", "XPM", "GIF", "PNG", "JPEG", "PBM",
"PGM", "PPM", and names specified by the Tgif.ImportFilter# X defaults.
If <format> is "TGIF", the file should either be a tgif file.
.TP
.I set_xpm_output_version(<version_number>)
This command sets the XPM version number when outputting in the X11 pixmap
format to be <version_number>.  <version_number> can take on values 1 or 3.
.TP
.I edit_ini_section(<attr_name>,<title>,<section>,<ini_path>)
This command brings up a dialogbox to edit the section specified by <section>
in the file specified by the full path <ini_path>.  If the user press the
OK button in the dialogbox, the section is cleared and the content of
the dialogbox is written back into the file, and "OK" is placed in the
attribute specified by <attr_name>.  If the user press the
CANCEL button in the dialogbox, the file is unmodified, and "CANCEL" is
placed in the attribute specified by <attr_name>.
.TP
.I select_from_ini_section(<attr_name>,<title>,<section>,<ini_path>)
This command brings up a list to select an entry from the section specified
by <section> in the file specified by the full path <ini_path>.
If nothing is selected, the attribute specified by <attr_name> will be
cleared.  Otherwise, the selected entry will be written into the
attribute specified by <attr_name>.
.TP
.I append_line_into_attr(<attr_name>,<string>)
This command appends the line specified by <string> to the attribute
specified by <attr_name>.
.TP
.I insert_line_into_attr(<attr_name>,<string>,<line_number>)
This command inserts the line specified by <string> as the
\fIn\fRth line of the attribute specified by <attr_name>, where
\fIn\fR is a zero-based index specified by <line_number>.
\fIn\fR must be at least 1.
If \fIn\fR is larger than the number of lines in the attribute, blank
lines are automatically inserted.
.TP
.I clear_attr(<attr_name>)
This command clears the attribute value of the attribute
specified by <attr_name> and deletes all other lines of the attribute
if the attribute contains multiple lines.
.TP
.I create_text_obj(<abs_x>,<abs_baseline_y>,<string>)
This command creates a text object at the location (<abs_x>,<abs_baseline_y>)
with the text specified by <string>.
.TP
.I create_box_obj(<abs_ltx>,<abs_lty>,<abs_rbx>,<abs_rby>)
This command creates a rectangle defined by (<abs_ltx>,<abs_lty>)
and (<abs_rbx>,<abs_rby>).
.TP
.I create_corner_oval_obj(<abs_ltx>,<abs_lty>,<abs_rbx>,<abs_rby>)
This command creates a corner oval defined by (<abs_ltx>,<abs_lty>)
and (<abs_rbx>,<abs_rby>).
.TP
.I create_center_oval_obj(<abs_x>,<abs_y>,<radius>)
This command creates a center oval centered at (<abs_x>,<abs_y>)
with radius specified by <radius>.
.TP
.I create_edge_oval_obj(<abs_ltx>,<abs_lty>,<abs_rbx>,<abs_rby>)
This command creates an edge circle defined by (<abs_ltx>,<abs_lty>)
and (<abs_rbx>,<abs_rby>).
.TP
.I create_rcbox_obj(<abs_ltx>,<abs_lty>,<abs_rbx>,<abs_rby>)
This command creates a rounded-corner rectangle defined by
(<abs_ltx>,<abs_lty>) and (<abs_rbx>,<abs_rby>).
.TP
.I create_arc_obj(<abs_x>,<abs_y>,<radius>,<dir>,<angle1>,<angle2>)
This command creates an arc centered at (<abs_x>,<abs_y>)
with radius, direction, start angle, and end angle specified by
<radius>, <dir>, <angle1>, and <angle2>, respectively.  The
<radius>, <dir>, <angle1>, and <angle2> are specified in the same way
as they are specified in the SpecifyAnArc()
command under the CreateObject submenu of the Edit Menu.
<dir> can be "+" or "-" where "+" is clockwise.
<angle1> and <angle2> are in degrees with 0 degree at the 12 o'clock
position.
.TP
.I create_first_vertex(<abs_x>,<abs_y>)
This command is used in conjunction with the create_next_vertex()
and create_poly_obj() commands to create a polyline/open-spline object.
It can also be used in conjunction with the create_next_vertex()
and create_polygon_obj() commands to create a polygon/closed-spline object.
This command sets the starting point of the polyline/open-spline
object or the polygon/closed-spline object to be
at (<abs_x>,<abs_y>).
.TP
.I create_next_vertex(<abs_x>,<abs_y>)
This command is used in conjunction with the create_first_vertex()
and create_poly_obj() commands to create a polyline/open-spline object.
It can also be used in conjunction with the create_first_vertex()
and create_polygon_obj() commands to create a polygon/closed-spline object.
This command sets the next vertex of the polyline/open-spline
object or the polygon/closed-spline object to be
at (<abs_x>,<abs_y>).
.TP
.I create_poly_obj()
This command is used in conjunction with the create_first_vertex()
and create_next_vertex() commands to create a polyline/open-spline object.
.TP
.I create_polygon_obj()
This command is used in conjunction with the create_first_vertex()
and create_next_vertex() commands to create a polygon/closed-spline object.
.TP
.I start_create_group_obj()
This command is used in conjunction with the create_group_obj() command
to create a grouped object.
This command marks the beginning of the group.
.TP
.I create_group_obj()
This command is used in conjunction with the start_create_group_obj() command
to create a grouped object.
This command groups all objects created since the last start_create_group_obj()
call into a grouped object.
.TP
.I set_allow_interrupt(<true_or_false>)
If <true_or_false> is \fIFALSE\fR (case-sensitive),
this command is used to temporarily disable an user interrupt when tgif
is executing internal commands.  If a user interrupt is received
when interrupt is disabled, it will be queued and will interrupt
the execution of internal commands when
set_allow_interrupt() is called again with <true_or_false> being \fITRUE\fR
(case-sensitive).
.TP
.I select_each_obj_and_exec(<attr_name_to_exec>)
This command first unselects any object that is selected.  It then
selects each object in the current drawing in turn and
executes the internal command specified by the
<attr_name_to_exec> attribute.  If this command is executed as a result
of a mouse click over an object, only objects in the current page will
be scanned for execution.  If this command is executed from a script file,
objects in every page will be scanned for execution.
.TP
.I edit_attr_in_text_mode(<attr_name>)
When this command is executed, tgif enters the text drawing mode and
edits the attribute specified by <attr_name>.
.TP
.I set_file_unsavable()
This command is used to make the current file unsavable.
.TP
.I pstoepsi(<target_eps_path>,<src_ps_path>,<scale>)
This command generates a preview bitmap for the PostScript
file in <src_ps_path> and prepends it to <src_ps_path> and
save the output in <target_eps_path> (<src_ps_path> is unmodified).
The only accepted values of <scale> is 1 or 2.
If the Tgif.ExternalPsToEpsi X default is set to true,
this command will simply invoke
"pstoepsi <src_ps_path> <target_eps_path>" externally if <scale> is 1 and
will invoke
"pstoepsi -2x <src_ps_path> <target_eps_path>" if <scale> is 2.
This command only works if tgif is running in the interactive (non-batch) mode.
.TP
.I objs_bbox_intersect(<obj1_name>,<obj2_name>,<result_attr>)
This command sets the value of the attribute specified by <result_attr>
to "1" if the boundingboxes of objects named <obj1_name> and <obj2_name>
intersect.  It sets the value of the attribute specified by <result_attr>
to "0" otherwise.
.TP
.I delete_all_attr_from_selected_objs()
This command deletes all attributes from selected objects.
Please only use this command when commands are taken from
an external file!
.TP
.I random_permute_lines_in_attr(<attr_name>)
This command randomly permutes lines of an attribute specified by <attr_name>.
.\"
.SH ARITHMETIC EXPRESSIONS
.\"
Certain internal commands allow arithmetic expressions as arguments.
Infix notation is used.  Supported operators (and their precedences)
are listed below.
.PP
 ?   1	if-then-else, e.g. <rel> ? <iftrue> : <else>
 :   2	if-then-else, e.g. <rel> ? <iftrue> : <else>
 ||  3	logical OR
 &&  4	logical AND
 |   5	bit-wise OR
 ^   5	bit-wise XOR
 &   5	bit-wise AND
 ==  6	equal
 !=  6	not-equal
 >   7	greater than
 <   7	less than
 >=  7	greater than or equal to
 <=  7	less than or equal to
 <<  8	shift left
 >>  8	shift right
 +   9	add
 -   9	subtract
 *  10 	multiple
 /  10 	divide
 // 10 	integer divide
 %  10 	mod
 !  11 	logical NOT
 ~  11 	bit-wise invert/NOT
 )  12 	closed parenthesis
 (  13 	open parenthesis
.\"
.SH GENERATING IMAGEMAP FILES
.\"
This section describes how to generate NCSA imagemap and CERN
clickable image files.
The Tgif.ImageMapFileFormat X default decides whether to generate
a NCSA imagemap or a CERN clickable image file.
Since the two formats are very similar, we will
only discuss how to generate NCSA imagemap files.
For more information about NCSA imagemap, please see [3].
For more information about CERN clickable image, please see [4].
.PP
The Tgif.GenerateImageMap X default should be set to ``true''
to enable the imagemap generation.
When printing in the GIF format (see the BASIC FUNCTIONALITIES
section about printing), an XPM file (which will be removed at the end
of this process) is generated first.
(The value specified by the Tgif.InitExportPixelTrim X default is
used to trim extra pixels.  Using these values forms an escape
mechanism to fix an idiosyncrasy that tgif can not figure out exactly
how big the whole image is.)
.PP
The XPM version is specified by
the Tgif.XPmOutputVersion X default unless the Tgif.UseXPmVersion1ForImageMap
X default is set to ``true'', which forces the XPM1 format.  Then the command
specified by the Tgif.XpmToGif X default is executed to convert the
XPM file into a GIF (Generic Interchange Format) file which can be used by
software such as NCSA's Mosaic(1).  The file extension for the GIF file is
specified by the Tgif.GifFileExtension X default.  Together with the
GIF file, an imagemap file with file extension specified by the
Tgif.ImageMapFileExtension X default is generated.  The content of the
imagemap is generated as follows.
.PP
Tgif first looks for a \fIfile attribute\fR with attribute name \fIhref\fR.
The value of the attribute is written as the \fIdefault URL\fR.
If such a file attribute can not be found, imagemap generation is aborted.
If it is found, then all objects in the file are scanned.
For an object having an
attribute named \fIhref\fR, the value of the attribute is written
as the \fIURL\fR for a \fImethod\fR line in the imagemap.
If the object is neither a circle nor a poly/polygon, the \fIrectangle\fR
method is used.
.PP
Similar mechanism is used when printing in the HTML format, except
that a generic HTML file is generated with an imagemap in the
Spy Glass Client-side Imagemap format.  You can generate a custom
HTML file if you specify an HTML export template using
SetHTMLExportTemplate() from the File Menu.  Details about the template
file is described below.
.\"
.SH HTML EXPORT TEMPLATE
.\"
If an HTML export template file is specified with the
SetHTMLExportTemplate() from the File Menu, custom HTML files can
be generated when printing in the HTML format.  The customization
is done through the use of variables embedded in the HTML export
template file.  These variables have the syntax of an HTML character entity.
They all starts with "&tgv" and ends with ";".  They are:
.TP
.I &tgvfilename;
This variable will be replaced by the name of the file (without file
extension).
.TP
.I &tgvcurnum;
This variable will be replaced by current page number.
.TP
.I &tgvfirstnum;
This variable will be replaced by the first page number (usually 1).
.TP
.I &tgvlastnum;
This variable will be replaced by last page number.
.TP
.I &tgvprevnum;
This variable will be replaced by the previous page number (with wrap around).
.TP
.I &tgvprevnumnowrap;
This variable will be replaced by the previous page number
(with no wrap around).
.TP
.I &tgvnextnum;
This variable will be replaced by the next page number (with wrap around).
.TP
.I &tgvnextnumnowrap;
This variable will be replaced by the next page number (with no wrap around).
.TP
.I &tgvtitle;
This variable will be replaced by the title the page or of the file.
.TP
.I &tgvmapobjs;
This variable will be replaced by the objects (specified as <AREA> tabs)
in a client-side image map.
.PP
For example, if a template specifies:
.PP
.RS
<IMG SRC="&tgvfilename;-&tgvcurnum;.gif"
.RS
USEMAP="#p0">
.RE
<MAP NAME="p0">
.br
&tgvmapobjs;
.br
<AREA SHAPE="RECT"
.RS
COORDS="0,0,&tgvmapwidth;,&tgvmapheight;"
.RE
.RS
HREF="&tgvfilename;-&tgvnextnum;.html">
.RE
</MAP>
.RE
.PP
Exporting using PrintOneFilePerPage() with this template may get
(for page 2 of a file name "foo.obj" with 5 pages):
.PP
.RS
<IMG SRC="foo-2.gif"
.RS
USEMAP="#p0">
.RE
<MAP NAME="p0">
.br
<AREA SHAPE="RECT" ...>
.br
 ...
.br
<AREA SHAPE="RECT" ...>
.br
<AREA SHAPE="RECT"
.RS
COORDS="0,0,145,97"
.RE
.RS
HREF="foo-3.html">
.RE
</MAP>
.RE
.\"
.SH GENERATING MICROSOFT WINDOWS EPSI FILES
.\"
Some Microsoft Windows (TM) applications do not understand standard
PostScript %%BeginPreview, %%EndImage, and %%EndPreview comments.
This section describes how to generate an EPSI file which is understood
by them.  This feature is invoked when the current print format is TiffEPSI.
In this case,
the generated EPSI file will contain 30 bytes of binary information in
the beginning of the file and a TIFF image (also binary) at the end of
the file.  This file also will not contain the
%%BeginPreview, %%EndImage, and %%EndPreview comments.
A file in this format is normally not considered to be a
PostScript file except under Windows.
.PP
When this feature is enabled, tgif generates
a normal EPSI file first, then dump the current content of the file
into an X11 bitmap file.  The command specified in Tgif.XbmToTiff is
executed to generate a TIFF image which is then append at the end of
the EPSI file.
.\"
.SH LOCKING OBJECTS
.\"
Objects can be locked and unlocked using #< and #> keyboard commands.
When a selected object is locked, it is shown with gray handles.
A locked object cannot be moved, stretched, flipped, or rotated;
however, its properties, such as fill pattern, width, etc., can
be changed.  Locked objects can also be deleted.  When a locked
object is grouped with other objects, the resulting grouped object
is also locked.  A locked object can be used as an anchor to
align other objects; however, DistributeObjs() command will fail
if any objects are locked.  Locked objects do not participate
in any operations in the select vertex mode.
.\"
.SH UNDO/REDO
.\"
Most operations can be undone and redone.  The Tgif.HistoryDepth
X default controls the size of the undo buffer.  If it is set
to -1, then the undo buffer's size is infinite.  The undo buffer
is flushed when the New() or Open() commands are executed (from
the File Menu), when the FlushUndoBuffer() command is executed
from the Edit Menu, or when Pop() is executed from a .sym file.
If a private colormap is used (automatically done when new colors
can not be allocated from the default colormap), executing FlushUndoBuffer()
will attempt to reset the colormap (if the -DDONT_FREE_COLORMAP
compile option is not used).
.\"
.SH DOMAINS
.\"
A \fIdomain\fR is a collection of library symbols suitable for
instantiations.  A library is implemented as a directory of .sym files,
and therefore, a domain is implemented as a search path.
If there are symbols with the same file name which reside
in different directories specified in the search path, then
the one closer to the front of the search path will be made
available for the user to instantiate.
.PP
The number of domains is specified by the MaxDomains X default,
and the names of the domains are specified by the DomainPath# X default.
The library search paths are specified by csh environment variables.
See the section on X DEFAULTS for more details.
.PP
Domain information can also be loaded into the ~/.Tgif/domain.ini file
by setting Tgif.DomainInIni to true and selecting Reload Domain Info From X
from the Domain submenu of the File Menu.
.\"
.SH SELECTING A NAME FROM A POPUP WINDOW
.\"
When selecting a file name, a symbol name, or a domain name,
tgif pops up a window with appropriate names for the user to
choose from.  The user can use mouse clicks to select an entry.
Key strokes can also be used to specify the desired name; however,
tgif attempts to match the key strokes with names in the selection
on the fly.  If a match can not be found, the key strokes are
ignored.  ^n, ^j, or the DownArrow key advances the selection
down by 1 entry; ^p, ^k, or the UpArrow key
advances the selection up by 1 entry.  ^f, ^d, or the DownArrow
key with <Control> key held down advances the
selection down by 10 entries; ^b, ^u, or the UpArrow
key with <Control> key held down advances the selection up by
10 entries.  '$' will select the last entry, while '^' will
select the first entry.  ^w or ^y un-select the selected entry.
If the selected entry is a directory, hitting <CR> will change
directory; if not, hitting <CR> finishes the selection process
and the selected entry is returned.
.PP
In selecting file names to open or import,
typing '/' is interpreted as going to the root directory or
specifying an URL.
At this point, the automatic matching of key strokes is
temporarily disabled until either a <TAB> or a <CR> is pressed.
Also, clicking the middle mouse button in the file name area
pastes from the clipboard.
.PP
The automatic appending of \fIindex.obj\fR or \fI.obj\fR (introduced
in version 2.16) became obsolete and an URL is never modified.
.PP
The current selection is displayed near the top of the popup
window.  Back-space should be used with caution because it might
change the current directory to the parent directory.
.\"
.SH IMPORTING EPS FILES
.\"
Encapsulated PostScript (EPS) files can be imported using the #(
keyboard command.  If the EPS file has a preview bitmap
(can be generated using the \fIpstoepsi\fR tool), tgif will
display it (HideBit/Pixmap() from the Layout Menu can be used to
disable the displaying of bitmap/pixmaps).  When the EPS object
is saved in a .obj or .sym file, neither the preview bitmap, nor
the PostScript content of the EPS file is saved.  Therefore,
when printing such a file (either from tgif or using prtgif),
the EPS file must be present at the same place from which it was
originally imported.
.\"
.SH ADDITIONAL FONTS
.\"
In addition to the Times, Courier, Helvetica, NewCentury, and Symbol fonts,
additional fonts can be specified using the Tgif.AdditionalFonts X default.
(The default screen fonts can also be replaced, please see
Tgif.HasAlternateDefaultFonts in the X DEFAULTS section for more details.)
Each additional font requires \fI4\fR parts, one for each font style
(in the order of Roman, Bold, Italic, and BoldItalic).
Each part contains \fI3\fR strings.  The first string specifies the
family, weight, slant, and width of the font (please see the man pages
for xfontsel(1) for more details; also there is a second form which
is described below).  The second string specifies the
registry and encoding of the font (see xfontsel(1) again).  (One can use
xlsfonts(1) to see what fonts are available and pick out the just mentioned
two strings from the output.)  The third string specifies the PostScript
font name.
.PP
For example, if one wants to use the X Lucida font to represent the
PostScript ZapfChancery-MediumItalic font, one can set Tgif.AdditionalFonts
as follows:
.PP
Tgif.AdditionalFonts: \\n\\
.br
        lucida-medium-r-normal \\n\\
.br
        iso8859-1 \\n\\
.br
        ZapfChancery-MediumItalic \\n\\
.br
        \\n\\
.br
        lucida-demibold-r-normal \\n\\
.br
        iso8859-1 \\n\\
.br
        ZapfChancery-MediumItalic \\n\\
.br
        \\n\\
.br
        lucida-medium-i-normal \\n\\
.br
        iso8859-1 \\n\\
.br
        ZapfChancery-MediumItalic \\n\\
.br
        \\n\\
.br
        lucida-demibold-i-normal \\n\\
.br
        iso8859-1 \\n\\
.br
        ZapfChancery-MediumItalic
.br
.PP
The above maps all four font styles of the Lucida font to the
ZapfChancery-MediumItalic font (similar to how Symbol font is handled).

The first string can also be specified in a second form which is
identified by having "%d" as part of the string.  For example, one
can use "lucidasans-%d" as the first string.  In this case, the
actual X font used will be the specified string with "%d" replaced by
the font size.  The encoding string (second string) is ignored (but
must be present).  The font name prefix (please see Tgif.FontNamePrefix
entry in the X DEFAULTS section) is also ignored.
.\"
.SH POSTSCRIPT CHARACTER ENCODING FOR INTERNATINOAL CHARACTERS
.\"
Sometimes, different encodings of the same PostScript font is needed for
characters \fIwith character codes between 161 and 255 (inclusive)\fR.
This can be accomplished in two ways.  One way is to use
Tgif.AdditionalDontReencode (and Tgif.DontReencode).  Another
way is to use Tgif.PSFontNeedCharSubs.  The difference is that
with Tgif.AdditionalDontReencode, a PostScript font's encoding is skipped.
With Tgif.PSFontNeedCharSubs, characters in a PostScript font can be given
specific encoding.
.PP
In both cases, there is a need to introduce fake font names (place holders).
For example,
.PP
.RS
Tgif.AdditionalFonts: \\n\\
.br
        utopia-medium-r-normal \\n\\
.br
        adobe-fontspecific \\n\\
.br
        UtopiaTmp-Regular \\n\\
.br
        \\n\\
.br
        utopia-bold-r-normal \\n\\
.br
        adobe-fontspecific \\n\\
.br
        UtopiaTmp-Bold \\n\\
.br
        \\n\\
.br
        utopia-medium-i-normal \\n\\
.br
        adobe-fontspecific \\n\\
.br
        UtopiaTmp-Italic \\n\\
.br
        \\n\\
.br
        utopia-bold-i-normal \\n\\
.br
        adobe-fontspecific \\n\\
.br
        UtopiaTmp-BoldItalic
.br
Tgif.PSFontAliases: \\n\\
.br
        UtopiaTmp-Regular=Utopia-Regular \\n\\
.br
        UtopiaTmp-Bold=Utopia-Bold \\n\\
.br
        UtopiaTmp-Italic=Utopia-Italic \\n\\
.br
        UtopiaTmp-BoldItalic=Utopia-BoldItalic
.RE
.br
.PP
In the above example, 4 fake PostScript font names are created (all have a
common "UtopiaTmp" prefix).  The encoding for these fonts is
adobe-fontspecific, according the X11 fonts being used.
Tgif.PSFontAliases maps the fake PostScript font names to the corresponding
real PostScript font names.  (If Tgif.PSFontAliases is missing,
non-existent PostScript font names such as UtopiaTmp-Regular will
appear in a PostScript file.)
.PP
To skip a PostScript font's encoding, one can use the
Tgif.AdditionalDontReencode X default.  For example, if one specifies:
.PP
.RS
Tgif.AdditionalDontReencode: UtopiaTmp
.br
.RE
.PP
characters with character codes between 161 and 255 (inclusive)
will not be encoded with ISO-Latin-1 character names.
For a list of characters names that are ISO-Latin-1 encoded, please see
.br
<URL:http://bourbon.usc.edu/tgif/faq/charencode.html#iso8859-1>.
.PP
To substitute characters in a PostScript font with specific encoding,
one can use the Tgif.PSFontNeedCharSubs and Tgif.PSCharSubs_*
X defaults.  (You still need Tgif.AdditionalFonts and
Tgif.PSFontAliases setup as above.)  Here is an example:
.PP
.RS
Tgif.PSFontNeedCharSubs: \\n\\
.br
        Utopia-Regular=Foo \\n\\
.br
        Utopia-Bold=Foo \\n\\
.br
        Utopia-Italic=Foo \\n\\
.br
        Utopia-BoldItalic=Foo
.br
Tgif.PSCharSubs_Foo: \\n\\
.br
        exclamdown/Aogonek \\n\\
.br
        AE/Cacute \\n\\
.br
        ecircumflex/eogonek
.RE
.br
.PP
In the above example, Tgif.PSFontNeedCharSubs specified a list of
fake PostScript font names that requires character substitutions
and their corresponding TOKEN names.
For a fake PostScript font name that maps to \fITOKEN\fR, the list of
characters to be substituted is specified in the Tgif.PSCharSubs_TOKEN
X default.  The format for Tgif.PSCharSubs_TOKEN is a list of
OLDCHARCODE/NEWCHARNAME strings where OLDCHARCODE is a character code in
decimal or octal format and NEWCHARNAME must be the name of a PostScript
character.
In the above example, \fIFoo\fR was used as the TOKEN name.
In real use, something like \fIiso8895-2\fR may be more appropriate
for a TOKEN name.  Since decimal or octal codes are allowed, the following
is equivalent to the above:
.PP
.RS
Tgif.PSFontNeedCharSubs: \\n\\
.br
        Utopia-Regular=iso8859-2 \\n\\
.br
        Utopia-Bold=iso8859-2 \\n\\
.br
        Utopia-Italic=iso8859-2 \\n\\
.br
        Utopia-BoldItalic=iso8859-2
.br
Tgif.PSCharSubs_iso8859-2: \\n\\
.br
        161/Aogonek \\n\\
.br
        8#306/Cacute \\n\\
.br
        8#312/eogonek
.RE
.br
.PP
Please note that substitution \fIonly\fR occurs for
characters with character codes between 161 and 255 (inclusive).
.PP
For more information, please see
.br
<URL:http://bourbon.usc.edu/tgif/faq/charencode.html#charsubs>.
.\"
.SH SQUARE DOUBLE BYTE FONTS
.\"
Starting with version 4.0 of tgif, double-byte fonts are supported.
But only double-fonts where every character has the same width and
height are supported.
Double-byte fonts is specified using the Tgif.SquareDoubleByteFonts X default.
The format of this X default is similar to that of the Tgif.AdditionalFonts
X default described in the ADDITIONAL FONTS section above with differences
described here.
Each double-byte font requires \fI4\fR parts, one for each font style
(in the order of Roman, Bold, Italic, and BoldItalic).
Each part contains \fI3\fR strings.  The first string specifies the
name of the font.  It must contain a "%d" as part of the string.  The
actual X font used will be the specified string with "%d" replaced by
the font size.
The second string can be either "*", "H", or "V".  When it is the "V"
string, each character is rotated 90 degrees counter-clockwise.  Otherwise,
the characters are not rotated.
The third string specifies the PostScript font name.
.PP
Using input methods (specified by the Tgif.DoubleByteInputMethod X default)
one can mix english (single-byte) substrings within a double-byte string.
The font to use for the english substring is specified by the
Tgif.DefaultSingleByteFont X default.
.PP
For example, if one wants to use the X Song Ti font to represent
PostScript GB-Song-Regular font, one can set Tgif.SquareDoubleByteFonts
as follows:
.PP
Tgif.DefaultSingleByteFont: Helvetica
.br
Tgif.GBShowFontChar: \271\372
Tgif.GBConvFromUTF8: iconv -f utf8 -t gb2312
Tgif.GBUConvToUTF8: iconv -f gb2312 -t utf8
.br
Tgif.SquareDoubleByteFonts: \\n\\
.br
       -isas-song ti-*-*-*--%d-*-*-*-*-*-gb2312.1980-0 \\n\\
.br
               * \\n\\
.br
               GB-Song-Regular \\n\\
.br
       \\n\\
.br
       -isas-song ti-*-*-*--%d-*-*-*-*-*-gb2312.1980-0 \\n\\
.br
               * \\n\\
.br
               GB-Song-Regular \\n\\
.br
       \\n\\
.br
       -isas-song ti-*-*-*--%d-*-*-*-*-*-gb2312.1980-0 \\n\\
.br
               * \\n\\
.br
               GB-Song-Regular \\n\\
.br
       \\n\\
.br
       -isas-song ti-*-*-*--%d-*-*-*-*-*-gb2312.1980-0 \\n\\
.br
               * \\n\\
.br
               GB-Song-Regular
.br
.PP
In the above example, the Song Ti font doesn't have styles such as
italic and bold, so all four parts are identical.
The Tgif.GBShowFontChar X default specifies a double-byte octal character
to be used to represent this font in the Choice Window when this font
is selected.
The Tgif.GBUConvFromUTF8 X default specifies a command to run
when an UTF8-encoded string is to be pasted into a text object
in the GB font.
The Tgif.GBUConvToUTF8 X default specifies a command to run
in a copy operation to convert a selected string (in GB font)
to the UTF8 format then copied to the clipboard.
.PP
Below is another example of using the X JIS fonts to represent
PostScript Ryumin-Light-EUC-H and Ryumin-Light-EUC-V fonts
as follows:
.PP
Tgif.RyuminShowFontChar: \244\242
.br
Tgif.SquareDoubleByteFonts: \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               H \\n\\
.br
               Ryumin-Light-EUC-H \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               H \\n\\
.br
               Ryumin-Light-EUC-H \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               H \\n\\
.br
               Ryumin-Light-EUC-H \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               H \\n\\
.br
               Ryumin-Light-EUC-H \\n\\
.br
       \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               V \\n\\
.br
               Ryumin-Light-EUC-V \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               V \\n\\
.br
               Ryumin-Light-EUC-V \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               V \\n\\
.br
               Ryumin-Light-EUC-V \\n\\
.br
       -jis-fixed-*-*-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
.br
               V \\n\\
.br
               Ryumin-Light-EUC-V
.br
.\"
.SH MULTIPAGE DRAWING
.\"
An object file can contain multiple pages.  Two layout modes,
\fIstacked\fR and \fItiled\fR, for a multipage drawing are supported.
In \fIstacked\fR layout mode, pages are considered to be stacked on
top of each other, and therefore, an object can only appear on one page.
In \fItiled\fR layout mode, pages are tiled to form a large logical page;
in this case, an object can exist on several physical pages simultaneously.
Swiching between the two modes are considered rare events and can not be undone.
Tgif does not allow switching from the tiled layout mode to the stacked
mode when there exists an object that spans physical page boundaries because
it can not decide which physical page the object belongs.

Page numbers are supported through the use of page numbering objects.  A page
number objecting is an object that contains an attribute whose name is
\fI!PAGE_NUM\fR (the name is case-sensitive) and the name part of that
attribute is not shown (hiding an attribute name can be achieved by using
the Move/JustifyAttr() command under the Attribute submenu of the Special Menu).
The value of the attribute determines how the page number is printed.
If the value of the attribute contains a \fI!(STACKED_PAGE_NUM)\fR substring,
that part of the substring will be replaced by the page number if the
page layout mode is \fIstacked\fR.  If the page layout mode is tiled, the string
will be printed out as is.
If the value of the attribute contains a \fI!(STACKED_NUM_PAGES)\fR substring,
that part of the substring will be replaced by the number of pages if the
page layout mode is \fIstacked\fR.
If the value of the attribute contains a
\fI!(TILED_PAGE_ROW)\fR or \fI!(TILED_PAGE_COL)\fR substring, that part of
the substring will be replaced by the row number or the column number of
the physical page if the page layout mode is \fItiled\fR.
.\"
.SH SPECIAL ATTRIBUTES
.\"
There are a few special attributes that tgif recognized.  There are described
in this section.  They are all case-sensitive.
.IP !PAGE_NUM=<page_number>
This specifies the page numbers in a multipage drawing.  Please see the
MULTIPAGE DRAWING section for details.
.IP auto_center_attr
If an attribute's name is empty and the value is \fIauto_center_attr\fR, then
all the visible attributes of the owner object will automatically be centered
relative to the bounding box of the owner object.  It doesn't really make
sense to have multiple visible attributes because they will overlap.  This
attribute is useful for making simple flowchart elements.
.IP unmakeiconic_on_instantiate
If a symbol object's attribute has an empty attribute name and
the value is \fIunmakeiconic_on_instantiate\fR,
then when the symbol is instantiated, the following commands are
performed on the just-instantiated icon object: 1) UnMakeIconic() command
from the Special Menu, 2) UnGroup() command from the Arrange Menu, and 3) the
"unmakeiconic_on_instantiate" text object is removed.  This attribute is
useful for making simple flowchart segments.
.IP unmakeiconic_on_instantiate_delete_attrs
If a symbol object's attribute has an empty attribute name and
the value is \fIunmakeiconic_on_instantiate_delete_attrs\fR,
then when the symbol is instantiated, the following commands are
performed on the just-instantiated icon object: 1) UnMakeIconic() command
from the Special Menu, 2) delete all attributes from this object,
and 3) UnGroup() command from the Arrange Menu.  This attribute is
useful for putting a group of "useful" objects into a symbol object.
.IP retracted_arrows
If an attribute's name is empty and the value is \fIretracted_arrows\fR
for a polyline or open-spline object with more than 2 vertices,
then the arrows of the spline object is retracted by one vertex.
.IP auto_retracted_arrows
This is very similar to the \fIretracted_arrows\fR above except that the
object must be an interpolated open-spline with only one arrow head.
The spline object is
forced to have 3 vertices and the middle vertex of the spline object
is automatically adjusted when an endpoint is moved.
.IP auto_exec=<internal_command>
If such a file attribute exists, the value is executed when the file
is opened (unless the file is opened as a result of executing the
hyperjump_then_exec() internal command).
.IP edit_attrs_in_context_menu=...
If an object has an attribute named \fIedit_attrs_in_context_menu\fR,
the values (starting from the 2nd line and separated by linebreaks)
of this attribute are treated as attribute names.  The named attributes
will be visible in the Edit Attribute In Editor submenu of the
Context Menu.  For example, if an object has the following attributes:
.PP
.RS
.RS
edit_attrs_in_context_menu=
.br
.RS
x
.br
y
.br
z
.RE
w=greetings
.br
x=hello
.br
y=world
.br
z=how are you
.br
good-bye
.RE
.RE
.PP
.RS
the Edit Attribute In Editor submenu of the Context Menu will only
show "x=hello", "y=world", and "z=how are you".
.RE
.\"
.SH EXPORT TO TABLE
.\"
When the ExportToTable() command is selected from the Table submenu of
the Special Menu, certain
attributes of selected objects are written into a user-specified output file
in a format which can be easily imported by a spreadsheet program or to be
used by the MergeWithTable() command described in the next section.  An output
file contains columns of strings.  Two columns are separated by a single
<TAB> character.  The first row of a output file contains the column names
and all other rows contain values.
.PP
The names of the attributes to be written are specified by the
\fIfile attribute\fR named \fITABLE_ATTRS\fR (which is denoted by
\fI!.TABLE_ATTRS\fR here).  The value of the TABLE_ATTRS
file attribute is a list of comma-separated attribute names.  When
ExportToTable() command is executed, the attribute names specified by
!.TABLE_ATTRS are written to the output file first.  Then,
for each selected object, every one of its attribute which appears in the
list specified by !.TABLE_ATTRS are written to the output file in one line.
If an object has no attributes that match the specification, no
corresponding line is generated.
.\"
.SH MERGE WITH TABLE
.\"
When the MergeWithTable() command is selected from the Table submenu of
the Special Menu, a
selected object is \fImerged\fR (also known as \fImail-merged\fR on PCs)
with a table (data) file (in the same format as the output file described
in the previous section) to generate a new multipage drawing having the
\fIstacked\fR page layout mode.
.PP
The selected object contains formating information, and it is also used as
a template to be replicated for each
data row in the table file.  If an attribute of the replica matches the
column name of the table, the attribute value is set to the value in the
table file.  The replicas are tiled horizontally first.
.PP
Eight attributes must be specified in the template object.  They are all
case-sensitive.  The ones that measure distances can be specified in
inches ("in"), centi-meters ("cm"), or pixels (if no units are specified).
.RS
.TP
.I PAPER_WIDTH
This specifies the width of the paper.
.TP
.I PAPER_HEIGHT
This specifies the height of the paper.
.TP
.I LEFT_MARGIN
This specifies the distance to the left edge of the paper.
.TP
.I TOP_MARGIN
This specifies the distance to the top edge of the paper.
.TP
.I H_PITCH
This specifies the distance between the left edges of the replicas.
.TP
.I V_PITCH
This specifies the distance between the top edges of the replicas.
.TP
.I NUM_COLS
This specifies the number of replicas to tile horizontally before
moving down to the next row.
.TP
.I NUM_ROWS
This specifies the number of replicas to tile vertically before
moving to the next page.
.RE
.PP
After each replica is generated, filled with the data from the
table file, and placed, its attribute named \fIexec\fR is
executed (unless an attribute named \fIEXEC_AFTER_MERGE\fR is
specified, in which case, the attribute named by the \fIEXEC_AFTER_MERGE\fR
attribute is executed instead).  If there is no attribute named by the
\fIEXEC_AFTER_MERGE\fR attribute, nothing is executed.
(Please see the INTERNAL COMMANDS section for details on command execution.)
One can use the \fIexec\fR command to construct other attributes
from the attributes associated with the data table.
.PP
If an attribute whose name is empty and whose value is the string
\fIUSER_PLACEMENT\fR, the user will be asked to place the replica
(object name will be displayed in the Status Window when the object
is being placed).
In this case, the 8 placement related attributes are ignored.
.PP
If an attribute whose name is empty and whose value is the string
\fISTRIP_DOUBLE_QUOTES\fR, data fields surrounded by double-quotes are
stripped.
.\"
.SH MIME TYPES AND MAILCAPS
.\"
When an URL names an HTTP server, the HTTP server sends the \fIContent-type\fR
of the URL along with the remote file referenced by the URL to tgif.
The \fIContent-type\fR contains information such as the type/subtype of the
file plus some optional fields.  If the
file is not a tgif file, the following mechanism is used to view the file.
.PP
First, the X defaults are looked up to see if there is an external
viewer specified for the file.  Please see Tgif.@@@Viewer in the X DEFAULTS
section below for details.  If there's no match, the type/subtype is
matched against entries in the MIME-types file.
The default MIME-types file is \fI.mime.types\fR in user's home directory.
Please see Tgif.MimeTypesFile in the X DEFAULTS section on how to override
the default MIME-types file.  The first field in each line of the MIME-types
file specifies type/subtype information.
If there is a type/subtype match in the MIME-types files,
the MailCap files are consulted as follows.
.PP
A line in a MailCap file consists of fields separated by semi-colons.
The first field specifies the type/subtype and the second field specifies
a \fIview command\fR for viewing a file that matches the type/subtype.
For tgif, the view command must contains a single \fI%s\fR substring
to be replaced by local copy of the URL.  Only the \fI%t\fR and the \fI%{}\fR
optional fields are supported by tgif.  The \fImultipart\fR MIME-type is
not supported.  The type/subtype information of the remote file is matches
against the MailCap files.  If a match is found, the corresponding view command
is executed.  If no match is found, but the type of the remote file is either
\fIapplication\fR, \fIaudio\fR, \fIimage\fR, or \fIvideo\fR, the file is
saved and no external viewer is launched.  Otherwise, the remote file is
assumed to be pure text and tgif will create a text object to view the text.
.PP
The MailCap files are the (colon-separated) files specified by the
MAILCAP environment variable (if defined).
If MAILCAP is not defined, the \fI.mailcap\fR file in
the user's home directory is used.
.PP
MIME is the Multipurpose Internet Mail Extensions specified in RFC1521,
and MAILCAP is specified in RFC1524.
.\"
.SH HOW TO MAKE A BUILDING-BLOCK OBJECT (SYMBOL FILE)
.\"
Here are the steps for defining a building-block object, to be used
in a hierarchical design.
.IP 1)
Draw the representation part of the building-block object.  Group everything
together.  Select this grouped object.
.IP 2)
Popup the main menu with the middle mouse button; select ``Special''.
Select ``MakeSymbolic'' from the next popup menu.
The selected object becomes a symbol and gets a dashed boundary.
.IP 3)
Type in attributes as individual text strings.  Select the
symbol object and all the
text strings to be attached to the symbol.  Type #a (for \fIAttach\fR)
to attach attributes to the symbol.
.IP 4)
(This step is optional.)  Build
the definition part of the building-block object.  Look at the
``flip-flop.sym'' file for an example.  To look at that file, first,
instantiate a ``flip-flop'' by typing ^i (for \fIInstantiate\fR).
Select the flip-flop from
the popup window; place the flip-flop; select the flip-flop and
type #v (for \fIPush\fR) to see the symbol file.
.IP 5)
Save and name the file.  If the current library path contains the
current directory (or '.'), the symbol just built should be
instantiatable by typing ^i.
.\"
.SH X11 PIXMAP (XPM) FORMATS
.\"
Tgif can only import X11 pixmaps that satisfy the constraints
described here.  The format of the X11 pixmap must be either 1 (XPM1)
or 3 (XPM3).  Only a subset of the XPM3 format is supported, namely,
the \fIkey\fR field for the color specification must be 'c' (for
color visuals).
Tools that generate XPM1 format files are
(they might have been upgraded to support XPM3), \fIpbmplus\fR
(or \fInetpbm\fR), which is
a set of bitmap and pixmap conversion freeware (together with
\fIxv\fR, the colors for pixmap objects can be manipulated),
and \fIxgrabsc\fR, another freeware; also, \fIxloadimage\fR
can display XPM1 files.
Tools that can generate XPM3 format files are, for example,
\fIxsnap\fR(1) and \fIsxpm\fR(1).
For each color specified in the color string, a color cell
is allocated.  If the allocation fails,
the current color will be used for that color string.
If the first color character is a back-quote (`) or a space, then
the corresponding color is substituted with the \fIbackground\fR
color of the tgif window if the Tgif.GuessXPmBgColor X default is
set to ``true''.  (This design choice is made because the pixmap will then
look ``right'' on both regular and reverse video.)
The following is an example of a very small pixmap file (in XPM1
format).
.PP
.RS
#define arrow_format 1
.br
#define arrow_width 5
.br
#define arrow_height 3
.br
#define arrow_ncolors 3
.br
#define arrow_chars_per_pixel 1
.br
static char *arrow_colors[] = {
.br
   "`", "Black",
   "a", "red",
   "b", "yellow"
.br
};
.br
static char *arrow_pixels[] = {
.br
"`a```",
.br
"aabbb",
.br
"`a```"
.br
};
.br
.RE
.\"
.SH LATEX FIGURE FORMATS
.\"
Here we show how to make a figure for a LaTeX file, first with
the \fI\\psfig\fR (or \fI\\epsf\fR) special construct, then with the
\fIpsfile\fR special construct.  (The author does not recommend
the \fIpsfile\fR construct.)  An example of both can be found
in ``example.tex'' which is included with the tgif distribution.
.PP
To print a tgif file to be included in a LaTeX document with
the \fI\\psfig\fR or \fI\\epsf\fR special construct
(files generated will be in the
\fIEncapsulated PostScript\fR format), first
select LaTeX format in the panel window (click the left mouse
button on the laser printer icon), then type ^p to generate
the Encapsulated PostScript file.
If the file name is ``an-sr-flip-flop.obj'',
then the LaTeX figure file generated will be named
``an-sr-flip-flop.eps''.  This file can be included in a LaTeX
document as follows,
.PP
.RS
\\input{psfig}
.br
\\begin{figure*}[htb]
.br
\\centerline{\\psfig{figure=an-sr-flip-flop.eps}}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.RE
.br
.PP
An alternative way is to use the \fI\\epsf\fR construct as follows,
.PP
.RS
\\input{epsf}
.br
\\begin{figure*}[htb]
.br
\\centerline{\\epsffile{an-sr-flip-flop.eps}}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.RE
.br
.PP
The \\centerline command above centers the picture.
If one has multiple tgif figures in one's LaTeX document,
one only have to include the psfig macro (\\input{psfig} or \\input{epsf})
once, right after the \\begin{document} statement.
.PP
If Encapsulated PostScript is not available, the \fIpsfile\fR
special construct can be used as described here.
In this case, since LaTeX doesn't not know where the bounding
box of the drawing is, it takes some practice to get this just right.
Here is something that seems to work.
First, center the picture
on the page (e.g., the width of a portrait style page is 8.5 inch, so the
center of the page is at the 4.25 inch mark),
and make the top object in the picture about 1/4 inch away from
the top of the page.
Select the LaTeX format in the panel window,
then print in the LaTeX format.
As with the \fIpsfig\fR construct, a file with the \fI.eps\fR
extension will be generated.
This file can be included in a LaTeX document as follows,
.PP
.RS
\\begin{figure*}[htb]
.br
\\special{psfile="an-sr-flip-flop.eps" hoffset=-40}
.br
\\rule{0in}{1.1in}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.RE
.br
.PP
The \\rule{0in}{1.1in} above specifies an invisible box of 1.1 inches
high, which is the total height of the picture in an-sr-flip-flop.
.\"
.SH CONNECTING OBJECTS
.\"
In the world of E-CAD, an icon object can represent an electronic component
and a line object can represent a connection between a pair of pins of
two electronic components.  When a component moves, the endpoint of
a wire connecting to the component will also move with the component.
Tgif simulates these functionalities in a limited fashion.
.PP
In tgif, a connection is represented by matching signal names.
A wire is defined as a polyline object having a \fItype=tgWire\fR attribute
and an attribute named \fIsignal_name\fR.  The definition of a \fIpin\fR
is more complicated.  It is described in the next paragraph.
If two pins have identical values for the \fIsignal_name\fR attribute,
they are considered to be connected (they do not have to be visually
connected by a wire).
.PP
A \fIpin\fR object must
have a \fItype=port\fR attribute and attributes named \fIsignal_name\fR
and \fIname\fR.
But not all objects having such attributes are pins.
In addition, a pin object must be either:
.IP (1)
a top-level symbol or an icon object
.PP
or:
.IP (2)
an immediate subobject of a \fIowner\fR symbol or icon object.
or:
.IP (3)
an immediate subobject of a \fIowner\fR grouped object which has
a \fItype=tgBroadcastWire\fR attribute.
.PP
In (2) above, the \fIowner\fR object must also
have an attribute named \fIname\fR
and must \fInot\fR be a subobject of another
symbol or icon object.  If the \fIowner\fR object is a subobject
of a grouped object, the \fIname\fR attributes of the grouped
object will be ignored.
.PP
In (3) above, that grouped object can be created using the
ConnectPortsToBroadcastWire() command in the PortsAndSignals
submenu of the Special Menu when a polyline object and some
floating port objects are selected.
.PP
A \fIpin\fR object can have a connected view and a disconnected view.
A connected view is a subobject with a \fIview=conn,FILL,PEN\fR
attribute and
a disconnected view is a subobject with a \fIview=disconn,FILL,PEN\fR
attribute;
FILL and PEN are numeric values between 0 and 31 (inclusive).  The
value corresponds to patterns in the Fill Menu and the Pen Menu.
Normally, only 0 or 1 should be used.
When the \fIsignal_name\fR attribute of a pin object is changed from
an empty string to a non-empty string, the pen and fill of the subobject that
corresponds to the disconnected view will be set to 0 (meaning NONE)
and the pen and fill of the subobject that
corresponds to the connected view will be set to the values specified
in the \fIview\fR attribute of the connected view.
When the \fIsignal_name\fR attribute of a pin object is changed from
a non-empty string to an empty string, the pen and fill of the subobject that
corresponds to the connected view will be set to 0
and the pen and fill of the subobject that
corresponds to the disconnected view will be set to the values specified
in the \fIview\fR attribute of the disconnected view.
.PP
A connection can be created using the ConnectTwoPortsByAWire()
command from the PortsAndSignals submenu of the
Special Menu.  Please note that if a pin is
part of another object, that object must also have a \fIname\fR
attribute with a non-empty value.  When two pins are connected using this
command, the \fIsignal_name\fR attributes of the pins and the wire will be
set to have the same value.
.PP
The moving of endpoints when a component moves is implemented in tgif
using the constrained move mode from the MoveMode Menu (please see
Tgif.ConstrainedMove in the X DEFAULTS section for additional information).
Please note that a connected wire that is not visually connected will not
automatically extends itself to follow a connected component even in the
constrained move mode.  Also, when a wire object is deleted, the
\fIsignal_name\fR attributes of connected pins do not change (since
they are not really "connected").
.\"
.SH X DEFAULTS
.\"
.TP
.I Tgif.Geometry: WIDTHxHEIGHT+X+Y
.TP
.I Tgif.IconGeometry: +X+Y
.TP
.I Tgif.Foreground: COLORSTRING
The default foreground color is Black.
.TP
.I Tgif.Background: COLORSTRING
The default background color is White.
.TP
.I Tgif.BorderColor: COLORSTRING
If not specified, the foreground color will be used.
.TP
.I Tgif.ReverseVideo: [on,off]
For black and white terminal, reverse video ``on'' means the background
is black.  For color terminal, reverse video ``on'' means the background
is specified by the Tgif.Foreground color.
The default is off.
.TP
.I Tgif.InitialFont: [Times,Courier,Helvetica,NewCentury,Symbol]
This specifies the initial font.
The default is Courier.
.TP
.I Tgif.InitialFontStyle: [Roman,Bold,Italic,BoldItalic]
This specifies the initial font style.
The default is Roman.
.TP
.I Tgif.InitialFontJust: [Left,Center,Right]
This specifies the initial font justification.
The default is Left.
.TP
.I Tgif.InitialFontDPI: [75,100]
\fIObsoleted\fR.
.TP
.I Tgif.InitialFontSizeIndex: [0,1,2,3,4,5]
\fIObsoleted\fR.
.TP
.I Tgif.InitialFontSize: NUMBER
This specifies the size of the start-up font.  The default is 14.
An alternative form allows "pt" to be specified immediately after
NUMBER (with no space between "pt" and the NUMBER).
.TP
.I Tgif.MsgFontSizeIndex: [0,1,2,3,4,5]
\fIObsoleted\fR.
.TP
.I Tgif.MsgFontSize: NUMBER
This specifies the size of the font used for messages, menues,
and popup windows.  The default is 14.
.TP
.I Tgif.RulerFontSize: NUMBER
This specifies the size of the font used for ruler windows.
The default is 10.
.TP
.I Tgif.DefaultFontSize: NUMBER
This specifies the size of the font to be used when a requested for a font size
can not satisfied.  This size \fImust\fR exist for \fIall\fR fonts used in
tgif.  The default is 14.
.TP
.I Tgif.FontSizes: NUMBER1 NUMBER2, ...
This specified the font sizes.
The default is \fI8 10 11 12 14 17 18 20 24 25 34\fR.
An alternative form allows "pt" to be specified immediately after
a NUMBER (with no space between "pt" the the NUMBER).
Please also use Tgif.InitialFontSize to specify the initial
font size to use if 14 is not in the specified font sizes.
.TP
.I Tgif.AdditionalFonts: FONT_SPEC1 FONT_SPEC2 ...
In addition to the Times, Courier, Helvetica, NewCentury, and Symbol fonts,
additional fonts can be specified here.  Please see the ADDITIONAL FONTS
section for details.
.TP
.I Tgif.FontNamePrefix: [\fI-*\fR, \fI*\fR]
This specified the prefix to be used when tgif makes a request to the X server.
The default is \fI-*\fR.  Certain fonts have obscure font names (e.g., does
not start with the \fI-\fR character).  In order to use these fonts, this
X default can be set to \fI*\fR.
.TP
.I Tgif.DefaultLatin1FontCharEncoding: STRING
Tgif uses 4 default fonts, "times", "courier", "helvetica", and
"new century schoolbook".  By default, the character encoding
for these fonts is iso8859-1.  These fonts are usually scalable
and pre-installed in older Linux systems.  In newer Linux system,
this is no longer the case.  Only a small number of font sizes
are pre-installed.  The pre-installed scalable versions of these
fonts are iso10646-1 (Universal Character Set) encoded.  This
X default can be used to specify a different character encoding 
(such as iso10646-1) for the 4 default fonts.  This X default
does not apply to alternate default fonts or fonts specified by 
the Tgif.AdditionalFonts X default.
The default is iso8859-1.
.TP
.I Tgif.HasAlternateDefaultFonts: [true,false]
The default value of this X default is false.
If it is set to ``false'', tgif uses the iso8859 registry
with ASN1 encoded screen fonts (unless it's overridden by the
Tgif.DefaultFontCharEncoding X default),
and it looks for "times", "courier", "helvetica", "new century schoolbook",
and "symbol" as part of the screen font names.  Some X servers do not support
these fonts.  In this case, this X default can be used to make tgif use
user specified screen and PostScript fonts.
If this X default is set to ``true'', tgif will look for additional
X defaults of the form \fITgif.<ps_font_name>\fR, where \fI<ps_font_name>\fR
can be one of the following strings:
.PP
.RS
.RS
Times-Roman
.br
Times-Bold
.br
Times-Italic
.br
Times-BoldItalic
.br
Courier
.br
Courier-Bold
.br
Courier-Oblique
.br
Courier-BoldOblique
.br
Helvetica
.br
Helvetica-Bold
.br
Helvetica-Oblique
.br
Helvetica-BoldOblique
.br
NewCenturySchlbk-Roman
.br
NewCenturySchlbk-Bold
.br
NewCenturySchlbk-Italic
.br
NewCenturySchlbk-BoldItalic
.br
Symbol
.br
.RE
.RE
.br
.PP
.RS
The corresponding value of the X default must contain "%d" as part of
the string, and the "%d" string will be replaced by the font size when
the font is requested.  For example, The following lines will use the
Times New Roman screen font instead of the Times screen font and use
the Bookman PostScript font instead of the Times PostScript font, if
Tgif.HasAlternateDefaultFonts is ``true'':
.RE
.PP
.RS
Tgif.Times-Roman: *-times new roman-medium-r-*--%d-*,Bookman-Light
.br
Tgif.Times-Bold: *-times new roman-bold-r-*--%d-*,Bookman-Demi
.br
Tgif.Times-Italic: *-times new roman-medium-i-*--%d-*,Bookman-LightItalic
.br
Tgif.Times-BoldItalic: *-times new roman-bold-i-*--%d-*,Bookman-DemiItalic
.br
.RE
.br
.PP
.RS
Please note that certain X servers require the right-hand-side
font specifications to have all the dashes in place.
.RE
.TP
.I Tgif.DefaultCursor: [x_cursor,arrow,...]
This specifies the select cursor.  Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is arrow.
.TP
.I Tgif.DrawCursor: [x_cursor,arrow,...]
This specifies the cursor used when drawing objects.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is the same as Tgif.DefaultCursor.
.TP
.I Tgif.DragCursor: [x_cursor,arrow,...]
This specifies the cursor used when dragging.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is hand2.
.TP
.I Tgif.VertexCursor: [x_cursor,arrow,...]
This specifies the cursor used in the select vertices mode.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is plus.
.TP
.I Tgif.FreeHandCursor: [x_cursor,arrow,...]
This specifies the cursor used in freehand drawing mode.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is pencil.
.TP
.I Tgif.RubberBandColor: COLORSTRING
This specifies the color to be used for rubber-banding (XORing).
The default color is the same as the foreground color.
.TP
.I Tgif.MaxColors: NUMBER
This specifies the maximum number of colors.  Color0 through ColorMax,
where Max is NUMBER-1, in X defaults are queried.  If NUMBER is greater
than the default of 11, Color11 through ColorMax \fImust\fR all exist
in X defaults.  Please see the GRAPHICAL OBJECTS section for a list of
the default colors.
.TP
.I Tgif.Color#: COLORSTRING
This specifies the correspondence between a color number and a color.
.TP
.I Tgif.DefaultColorIndex: NUMBER
This specifies the default color index if a certain color can not be found.
The default is 0.  Please note Tgif.DefaultColor takes precedence over this
X default.
.TP
.I Tgif.ShortCuts: ITEM1 ITEM2 ...
The ITEM specifies the correspondence between a key (may be case
sensitive) and a non-alphanumeric key command.  Please see
the SHORTCUTS section for details.
.TP
.I Tgif.MaxLineWidths: NUMBER
This specifies the maximum number of line widths.  LineWidth0 through
LineWidthMax, ArrowWidth0 through ArrowWidthMax, and ArrowHeight0
through ArrowHeightMax, where Max is NUMBER-1, in X defaults are
queried.  If NUMBER is greater than the default value of 7,
LineWidth7 through LineWidthMax, ArrowWidth7 through ArrowWidthMax,
and ArrowHeight7 through ArrowHeightMax
\fImust\fR all exist in X defaults.
Some default values will be used for those that are
not specified in the X defaults.
.TP
.I Tgif.DefaultLineWidth: NUMBER
This specifies the initial line width \fIindex\fR.
The default is 0.
.TP
.I Tgif.LineWidth#: NUMBER
This specifies a line width.
The default line widths are 1, 2, 3, 4, 5, 6, and 7.
.TP
.I Tgif.ArrowWidth#: NUMBER
This specifies the width (when the arrow is pointing horizontally)
of the arrow head for arc and open-spline objects.
The default arrow widths are 8, 10, 12, 14, 18, 20, and 22.
.TP
.I Tgif.ArrowHeight#: NUMBER
This specifies \fIhalf\fR the height (when the arrow is also pointing
horizontally) of the arrow head for arc and open-spline objects.
The default arrow heights are 3, 4, 5, 6, 7, 8, and 9.
.TP
.I Tgif.MaxDomains: NUMBER
This specifies that NUMBER is the number of domains.
DomainPath0,DomainPath1,...,DomainPathM all must exist in X defaults.
Here M=NUMBER-1.
.TP
.I Tgif.DomainPath#: DOMAINSTRING
This specifies the correspondence between a domain number, a domain name,
and the path associated with a domain.
Hence one DomainPath# X default is required for each domain defined.
Here the # should be replaced with a domain number.  The domain numbers
should be 0,1,...,MAXDOMAINS-1, where MAXDOMAINS is set in the MaxDomain
X default above.  The MaxDomain X default in combination with
the DomainPath# X default are required to use domains.
.PP
.RS
DOMAINSTRING contains strings which are separated by the ':' symbol.
The first string is the name of the domain.
Each of the rest of the strings specifies a directory where symbol files are to
be searched when the Instantiate command is executed (please see the
HOW TO MAKE A BUILDING-BLOCK OBJECT section for details).  Another way to
look at the DOMAINSTRING specification is that removing the first
string (which specifies the domain name) and the first ':' symbol, a
DOMAINSTRING has the form of the \fIPATH\fR csh(1) environment variable.
For example, to specify the symbol path for domain \fIDEFAULT\fR
to look for symbol files, first in the library directory /tmp/tgif/symbols,
then in the current directory,
DOMAINSTRING should be set to the following value:
.RE
.PP
.RS
.RS
DEFAULT:/tmp/tgif/symbols:.
.br
.RE
.RE
.br
.TP
.I Tgif.DefaultDomain: NUMBER
This specifies the default domain when tgif starts up.
The default is 0.
.TP
.I Tgif.PrintCommand: COMMAND
This specifies the print command used for printing the PostScript file.
The default is lpr(1).  An example would be
\fIlpr -h -Pprintername\fR.
If COMMAND contains a \fI%s\fR substring, the \fI%s\fR will be replaced
by the full path name of the PostScript file which is normally sent to
the print command.  Therefore, COMMAND without a \fI%s\fR substring behaves
identically to \fICOMMAND %s\fR.  Please note that this only works
when running tgif without the -print command line option.
This can be used to send a font
file to the printer before the tgif PostScript file is sent as in the
following example:
.PP
.RS
.RS
cat /somewhere/sansfex.pfa %s | lpr -Pmyprinter
.RE
.RE
.PP
.TP
.I Tgif.WhereToPrint: STRING
This specifies the initial print/export destination/format.
STRING can be Printer, EPS, PS, Bitmap, Text, EPSI, GIF, HTML, PDF, WinEPSI,
PNG, JPEG, PPM, or NetList.
The default is EPS.
.TP
.I Tgif.PrintDirectory: PATH
This specifies the print directory when the output destination
is not the printer.
The default is a null string, which means that the output goes
into the directory in which the current file resides.
.TP
.I Tgif.NoTgifIcon: [true,false]
If set to ``true'', tgif will not use its own icon window.  In this case,
one should also set Tgif.UseWMIconPixmap described below to true.
Modern window managers usually do not allow an application to draw
its own icon window, so this X default would have no effect when tgif
is running under these window managers.
The default is false.
.TP
.I Tgif.UseWMIconPixmap: [true,false]
If set to ``true'', tgif will use the standard icon pixmap.  Also,
Tgif.NoTgifIcon will be ignored.
The default is true.
.TP
.I Tgif.DontShowVersion: [true,false]
If set to ``true'', the tgif version will not be displayed on top of the
tgif window.
The default is true.
.TP
.I Tgif.XBmReverseVideo: [true,false]
If set to ``true'', an invert bitmap operation will be performed
when importing an X11 bitmap file.
The default is false.
.TP
.I Tgif.AskForXBmSpec: [true,false]
If set to ``true'', the user will be asked to specify
magnification and geometry for an X11 bitmap file being imported.
Format of the specification is \fIMAG=WxH+X+Y\fR, where
MAG is the magnification, W and H specifies the width and height,
and the location specification can be +X+Y, +X-Y, -X+Y, and -X-Y.
The '=' is mandatory if any of the geometry information is
specified.
The default is false.
.TP
.I Tgif.AskForXPmSpec: [true,false]
If set to ``true'', the user will be asked to specify
magnification and geometry for an X11 pixmap file being imported.
The format of the specification is the same as for AskForXBmSpec.
The default is false.
.TP
.I Tgif.StripEPSComments: (obsolete)
This X default became obsolete in tgif-4.0.11
because it turns out that it's not always
okay to strip PS comments (it should always be set to false).
.TP
.I Tgif.GuessXPmBgColor: [true,false]
If set to ``true'', then when tgif imports an X11 pixmap file
with the first color string being ' ' (the space character) or '`'
(the back quote character), it will treat the first color
as a \fIbackground\fR color.  This means that
the specified color in the X11 pixmap file will be changed to
the current background color.
The default is false.  (Please note that this default was \fItrue\fR
before patch 2 of tgif-2.7.  This X default is there for compatibility
reasons; it should be considered obsolete.)
.TP
.I Tgif.XPmOutputVersion: NUMBER
This specifies the XPM version number when outputting in the X11 pixmap
format.  NUMBER can take on values 1 or 3.  The default is 1.
.TP
.I Tgif.XPmInXGrabSCFormat: [true,false]
If Tgif.XpmOutputVersion is set to 1, setting this to ``true'' will
force the X11 pixmap output to resemble what xgrabsc generates
(i.e., color names will not be used).
The default is false.
.TP
.I Tgif.UseGrayScale: [true,false]
If set to ``true'', gray scales will be used for tiling patterns
to speed up printing.
The default is false.
.TP
.I Tgif.AutoPanInEditText: [true,false]
If set to ``true'', auto panning will be used such that the text cursor
is always visible in text edit mode (except when the cursor is to the
left or on top of the paper).
This should probably be turned off on slow servers.
The default is true.
.TP
.I Tgif.PercentPrintReduction: NUMBER
This specifies the initial percent print reduction/magnification.
The default is 100.
.TP
.I Tgif.ConstrainedMove: [true,false]
This specifies the initial move mode.
When set to ``true'', moving or stretching an object will cause the
endpoints of all
polylines or open-splines, whose endpoints fall within the object,
and may be the neighboring vertices, to be moved.  Please see the
IDIOSYNCRASIES section for more details.
The default value is false.
.TP
.I Tgif.DoubleQuoteDoubleQuote: [true,false]
When set to ``true'', output of the double-quote character will be preceded
by a double-quote character; when set to false, output of the double-quote
character will be preceded by a back-slash character.
The default value is false.
.TP
.I Tgif.GridSystem: [English,Metric]
This sets the initial grid system.  The default is English.
.TP
.I Tgif.InitialGrid: NUMBER
This specifies the initial grid size.
For the English grid system, NUMBER can be -2, -1, 0, +1, or +2 for grid
sizes of 1/32, 1/16, 1/8, 1/4, and 1/2 inch.
For the Metric grid system, NUMBER can be -1, 0, +1, or +2 for grid
sizes of 1mm, 2mm, 5mm, and 1cm.
The default value is 0.
.TP
.I Tgif.DropObsIconAttrWhenUpdate: [true,false]
If set to ``true'', obsolete icon attributes will be dropped without
confirmation when the UpdateSymbols command is executed.  If set to ``false'',
a popup window will prompt the user to specify what to do
with the obsoleted icon attributes.
The default is false.
.TP
.I Tgif.UseRecentDupDistance: [true,false]
If set to ``true'', the most recent change in position produced by a combination
of a duplicate and a move command will be used for the new duplicate command.
Otherwise, some default distance will be used to position the duplicate.
The default is true.
.TP
.I Tgif.SplineTolerance: NUMBER
This specifies the tolerance of spline drawing.
The smaller the number, the smoother the spline.
The default is 9 (min is 3 and max is 13).
.TP
.I Tgif.SplineRubberband: (obsolete)
If set to ``true'', spline rubber-bands will be used
in drawing, moving, and stretching open and closed splines.
(This might not be desirable if the spline contains too many vertices.)
The default is true.  This X default became obsolete since tgif-4.2 due
to the addition of structured spline objects.
.TP
.I Tgif.Synchronize: [on,off]
XSynchronize is called if this X default is set to ``on''.  The default is off.
.TP
.I Tgif.DoubleClickUnIconify: [true,false]
If set to ``true'', double mouse clicks are used to de-iconify
the icon window (in this mode, the icon window ignores single
mouse clicks and drags).
The default is false.
.TP
.I Tgif.MainMenuPinDistance: NUMBER
This specifies the horizontal distance (in pixels) the user needs to
drag a popup menu before the popup menu is to be pinned down.
The default is 80.  (If pinned popup menus are not desired, then this should
be set to a value greater than the screen width.)
Dragging the left mouse button can be used to move the pinned popup menu;
clicking the right button in the popup menu will remove it.
.TP
.I Tgif.DoubleClickInterval: NUMBER
This specifies the maximum interval (in milliseconds)
between two mouse clicked to be recognized as one double-click.
The default is 300.
.TP
.I Tgif.HandleSize: NUMBER
This specifies (half) the size of the handle used to highlight objects.
Its allowable value is between 2 and 6.
The default is 3.
.TP
.I Tgif.HistoryDepth: NUMBER
This specifies the size of the undo/redo buffer; negative values
mean that the buffer is unbounded.
The default is -1.
.TP
.I Tgif.SaveTmpOnReturn: [true,false]
If set to ``true'', a tmpmodel file will be saved automatically before
returning to the driver.  Otherwise, no files will be
saved automatically.
The default is true.
.TP
.I Tgif.ImportFromLibrary: [true,false]
If set to ``true'', the library directories specified by the
current domain are searched for .obj, .sym, xbitmap/xpixmap, and EPS files to
import.  Otherwise, the current directory will be used as the starting point.
The default is false.
.TP
.I Tgif.WarpToWinCenter: [true,false]
If set to ``true'', the mouse is warped to the center of popup
windows.  Otherwise, the mouse is not warped.
The default is true.
.TP
.I Tgif.SaveCommentsInSaveNew: [true,false]
If set to ``true'', "%%" type comments in the file will be stored in the
newly created file.
The default is true.
.TP
.I Tgif.CanvasWindowOnly: [true,false]
If set to ``true'', only the canvas window will be displayed (this is
a kind of the ``demo'' mode).
The default is false.
.TP
.I Tgif.UsePsAdobeString: [true,false,NUMBER_1/NUMBER_2]
If set to ``true'', the first line in the PS or EPS file will be
"%!PS-Adobe-2.0 EPSF-1.2".  If set to ``false'', it is just "%!".
If the PS-Adobe string confuses the document
manager (such as Transcript) on your site, you should set it to
``false''.
If the third form is used, the first line will be
"%!PS-Adobe-NUMBER_1 EPSF-NUMBER_2".
The default is false.
.TP
.I Tgif.HalfToneBitmap: [true,false]
If set to ``true'', the Floyd-Steinberg half-tone method will be used
when printing in the X11 bitmap format.  This is useful when the drawing
contains X11 pixmap objects.
The default is false.
.TP
.I Tgif.ThresholdBitmap: [true,false]
If set to ``true'', a simple thresholding method will be used to decide whether
a bit is turned on or off when printing in the X11 bitmap format.
If Tgif.HalfToneBitmap is set to true, this X default is ignored.
The default is false.
.TP
.I Tgif.BitmapThreshold: NUMBER
This specifies the threshold value used in either the Floyd-Steinberg half-tone
algorithm or the simple thresholding algorithm.  NUMBER must be between 0 and 1.
This X default is only active
when either the Tgif.HalfToneBitmap or the Tgif.ThresholdBitmap
X default is set to true.
The default value is 0.5 if Tgif.HalfToneBitmap is true, and is 1.0
if Tgif.ThresholdBitmap is true
(basically, anything that is not white will be black).
.TP
.I Tgif.EPSIThresholdPreviewBitmap: [true,false]
If set to ``true'', a simple thresholding method will be used to decide whether
a bit is turned on or off in the preview bitmap when
printing in the EPSI format.
The default is false.
.TP
.I Tgif.EPSIPreviewBitmapThreshold: NUMBER
This specifies the threshold value used in the 
simple thresholding algorithm to decide whether a bit is turned on or off in
the preview bitmap when printing in the EPSI format.
NUMBER must be between 0 and 1.
The default value is 0.5 if Tgif.EPSIThresholdPreviewBitmap is true, and is 1.0
if Tgif.EPSIThresholdPreviewBitmap is false
(basically, anything that is not white will be black).
.TP
.I Tgif.GroupedTextEditable: [true,false]
If set to ``false'', only top level text objects and attributes of top
level objects can be edited when the drawing mode is set to the text mode.
If set to ``true'', text objects and attributes everywhere can be edited.
The default is false.
.TP
.I Tgif.DefaultEPSScaling: NUMBER
This specifies the scaling factor applied to an imported PS or EPS image.
As mentioned in the IDIOSYNCRASIES section below, tgif treats 128 pixels
as an inch and PostScript treats 72 points as an inch.  In order to have
real-size PostScript images, this parameter should be set to 1.7778
(which is 128/72).
The default value is 1.
.TP
.I Tgif.IntrCheckInterval: NUMBER
This specifies the number of objects drawn before tgif checks for
interrupts.  If this is set to be 0 or less, interrupt is not allowed.
The default value is 10.
.TP
.I Tgif.TiledPageScaling: NUMBER
This specifies the scaling value used when a multipage drawing in
tiled page mode is printed.  Since most PostScript printers do not
use the full page as the drawing area, setting this number to 1
may get truncated output.
The default value is 0.9.
.TP
.I Tgif.TGIFPATH: STRING
This specifies the directory where the files, mentioned in the FILES
section below, can be found.  The TGIFPATH environment variable may
override this option.
The default value is specified by the compiler option TGIF_PATH.
.TP
.I Tgif.TGIFICON: STRING
This specifies the name of the object file to be displayed when tgif
is iconified.  If it starts with a / character, absolute path is used;
otherwise, the actual path of the icon file is $TGIFPATH/STRING where
TGIFPATH is either defined using the X defaults or an environment variable.
The default value is ``tgificon.obj''.
.TP
.I Tgif.StickyMenuSelection: [true,false]
If set to ``true'', when patterns/linewidths/linestyles/... of objects are
changed using a menu action, the corresponding
pattern/linewidth/linestyle/... becomes the current selection.
The default is true.
.TP
.I Tgif.PSBopHook: STRING
If specified, the following PostScript line is added at the beginning of
each page when printing to the printer or to a PS file,
.PP
.RS
.RS
userdict /STRING known { STRING } if
.br
.RE
.RE
.PP
.RS
This option should only be used if one is very familiar with PostScript.
(Setting STRING to "tgif-bop-hook" is recommended since it would not have
a name conflict with existing software, such as dvips(1).)
.RE
.TP
.I Tgif.PSEopHook: STRING
If specified, the following PostScript line is added at the end of
each page when printing to the printer or to a PS file,
.PP
.RS
.RS
userdict /STRING known { STRING } if
.br
.RE
.RE
.PP
.RS
This option should only be used if one is very familiar with PostScript.
(Setting STRING to "tgif-eop-hook" is recommended since it would not have
a name conflict with existing software, such as dvips(1).)
.RE
.TP
.I Tgif.MinimalEPS: [true,false]
If set to ``false'', comments such as %%Pages, %%DocumentFonts, %%EndComments,
%%BeginProlog, %%EndProlog, %%Page, %%Trailer, and %%EOF will be generated
in an EPS output.  These comments may confuse certain ``document managers''.
Therefore, the default is true if Tgif.UsePsAdobeString is not specified
(and the default is false if Tgif.UsePsAdobeString is specified).
.TP
.I Tgif.InitialPrintInColor: [true,false]
If set to ``true'', color output (printing) mode is enabled on startup.
Please note that in black and white PS/EPS/EPSI printing mode, the
\fIwhite\fR color will be printed as black (only \fIbackground\fR
will be printed as white).
The default is true (except when the \fB-print\fR command line option
is used).
.TP
.I Tgif.InitialShowGrid: [true,false]
If set to ``false'', showing grid is disabled on startup.
The default is true.
.TP
.I Tgif.InitialSnapOn: [true,false]
If set to ``false'', snapping to the grid points is disabled on startup.
The default is true.
.TP
.I Tgif.NoMenubar: [true,false]
If set to ``true'', no menubar will be shown initially.
The default is false.
.TP
.I Tgif.NoStatusWindow: [true,false]
If set to ``true'', no Status Window will be shown initially.
The default is false.
.TP
.I Tgif.ReverseMouseStatusButtons: [true,false]
If set to ``true'', the left mouse status and the right mouse status are
swapped.  This should be used when a ``left-handed mouse'' is used.
The default is false.
.TP
.I Tgif.MinimalMenubar: [true,false]
If set to ``false'', the menu items in the Menubar Window will be the
same as the main popup menu.  This would take up much more space.
If set to ``true'', the Page, PageLayout, HoriAlign, VertAlign, and MoveMode
menus are collapsed into the View cascading menu; the Font, TextStyle, and
TextSize menus are collapsed into the Text cascading menu; and the LineDash,
LineStyle, LineType, LineWidth, Fill, and Pen menus are collapsed into the
Graphics cascading menu.
The default is true.
.TP
.I Tgif.ColorBgInPrintingColorPS: [true,false]
If set to ``true'', the window background color is used as the background
color when generating color PostScript output.  If set to ``false'',
no background color is used.
The default is false.
.TP
.I Tgif.ScrollBarWidth: NUMBER
This specifies the width of a scroll bar.
NUMBER must be between 2 and 16.  The default is 16.
.TP
.I Tgif.InitialPaperSize: STRING
The STRING specifies the initial width and height of the paper.
STRING is in the "<width> x <height>" form.  <width> and <height> is a
numeric value immediately followed by either "in" (inch) or "cm" (centi-meter).
The " x " that separate the <width> and <height> is mandatory.
If A4PAPER is defined in the Makefile, the default value is "21cm x 29.7cm".
If A4PAPER is not defined in the Makefile, the default value is "8.5in x 11in".
.TP
.I Tgif.UpdateChildUsingAlignment: [true,false,no_overlap]
If set to ``true'' or 'no_overlap', when update_eps_child(), update_xbm_child(),
or update_xpm_child() internal command is executed, the current
horizontal and vertical alignments are used to place the EPS/XBM/XPM
subobject.  If the horizontal alignment is L, C, R, S, or -, the subobject
is aligned to the left, center, right, center, or left, respectively,
to the parent object.
If the vertical alignment is T, M, B, S, or -,
the subobject is placed above, middle, below, middle, or below the
parent object if this X default is set to 'no_overlap'; the
subobject is aligned to the top, middle, bottom, middle, or below the
parent object if this X default is set to ``true''.
If this X default is set to ``false'', the subobject
is placed left aligned and below the parent object.
The default is false.
.TP
.I Tgif.GenerateImageMap: [true,false]
If set to ``true'', NCSA \fIimagemap\fR or CERN \fIClickable Image\fR
files will be generated when print in GIF format.  In this case,
Tgif.XpmToGif, Tgif.ImageMapFileExtension, Tgif.GifFileExtension,
Tgif.ImageMapFileFormat, and Tgif.UseXPmVersion1ForImageMap X defaults,
described below, will be interpreted; otherwise, they are ignored.
Please see the section on
GENERATING IMAGEMAP FILES for details.
The default is false.
.TP
.I Tgif.XpmToGif: STRING
The STRING specifies a command used to convert an XPM file to a GIF file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the XPM file.
The default is "xpmtoppm %s | ppmtogif".
.TP
.I Tgif.ImageMapFileExtension: STRING
The STRING specifies the file extension for a imagemap file.
The default is "map".
.TP
.I Tgif.GifFileExtension: STRING
The STRING specifies the file extension for a GIF file.
The default is "gif" (lower case).
.TP
.I Tgif.ImageMapFileFormat: [NCSA,CERN]
The STRING specifies either the NCSA imagemap or the CERN clickable image
format.
The default is NCSA for the NCSA imagemap format.
.TP
.I Tgif.UseXPmVersion1ForImageMap: [true,false]
The setting of this X default should depend on the setting of the
Tgif.XpmToGif X default above.
If set to ``true'', XPM1 file is generated regardless of the setting of the
Tgif.XPmOutputVersion X default.
The default is true.
.TP
.I Tgif.UsePaperSizeStoredInFile: [true,false]
If set to ``true'', the paper size information stored in a just opened file
is used.
The default is true.
.TP
.I Tgif.OneMotionSelMove: [true,false]
If set to ``true'', one can select and move an object in one motion.
The default is false.
.TP
.I Tgif.TiffEPSI: (obsolete)
This X default became obsolete because TiffEPSI became a supported export
format since tgif-4.0.
.TP
.I Tgif.XbmToTiff: STRING
The STRING specifies a command used to convert an XBM file to a TIFF file.
The STRING \fImust\fR contain either one or two \fI%s\fR substring.  The
first \fI%s\fR substring is to be replaced by the full path name of the
XBM file.  The optional second \fI%s\fR substring is to be replaced by
the full path name of the generated TIFF image.
The default is "xbmtopbm %s | pnmtotiff -none > %s".
.TP
.I Tgif.EPSIExportExtension: STRING
STRING specifies the file extension used for exporting \fIEPSI\fR files.
The default is "eps".
.TP
.I Tgif.HotListFileName: STRING
STRING specifies a full path name of a file used to store the hot file list.
By default, this file is .Tgif_hotlist in the user's home directory.
.TP
.I Tgif.@@@Viewer: STRING
STRING specifies an external viewer for an remote URL with a file
extension of @@@.  STRING can be in 3 forms.  It can be the string "NONE"
to indicate that when such a remote file is encountered, tgif should retrieve
the file into a user specified directory.  For example, if one wishes to
retrieve .gz files, one can use:
.PP
.RS
.RS
Tgif.gzViewer: NONE
.br
.RE
.RE
.PP
.RS
STRING can also contain the string %S (S is capitalized), this indicates
that %S is to be replaced by the URL.  For example, if one wishes to
view .html files using xmosaic, one can use:
.RE
.PP
.RS
.RS
Tgif.htmlViewer: xmosaic %S
.br
.RE
.RE
.PP
.RS
Another form of STRING contains the string %s (S is lower-case),
this indicates that the remote file is
to be retrieved into a user specified directory
and view by a tool.  For example, if one wishes to
view .gif files using xv, one can use:
.RE
.PP
.RS
.RS
Tgif.gifViewer: xv %s
.br
.RE
.RE
.PP
.RS
Please note that this mechanism has precedence over the mechanism described
in the MIME TYPES AND MAILCAPS section above.
.RE
.TP
.I Tgif.AutoHyperSpaceOnRemote: [true,false]
If set to ``false'', tgif will not go into the \fIhyperspace\fR mode
when a remote URL is visited.
The default is true.
.TP
.I Tgif.AllowLaunchInHyperSpace: [true,false]
If set to ``true'', launching of applications is enabled in the
\fIhyperspace\fR mode when a remote URL is visited.  This is
potentially very dangerous because the application may do
catastrophic damages.  Therefore, it is strongly recommended that it is
set to false.
The default is false.
.TP
.I Tgif.CanChangeAttrColor: [true,false]
If set to ``true'', color of an attribute can be changed when it is
attached to an object.
The default is false.
.TP
.I Tgif.MimeTypesFile: STRING
STRING specifies a full path name of the MIME-types file.  Tgif only
uses the type/subtype field in the MIME-types file and ignores all other
fields.
The default MIME-types file is \fI.mime.types\fR in user's home directory.
.TP
.I Tgif.LocalRGBTxt: STRING
If one would like to override certain system colors, one can use STRING
to specify a full path name of a file to be consulted first before
looking up the color in the server.  The file must be in the same format
as the \fIrgb.txt\fR file.  Namely, each line contains 4 fields, the
first 3 fields correspond to the red, green, and blue components of the
color, and the 4th field is the name of the color.  A color component
must have a value between 0 and 255 (inclusive).
.TP
.I Tgif.PrintUsingRequestedColor: [true,false]
If set to ``true'', the color PostScript file being printed will use the
\fIrequested\fR color instead of the color returned by the X server.
The default is false.
.TP
.I Tgif.ShowMeasurement: [true,false]
If set to ``true'', the location of the cursor and the width and height
of the object being drawn/dragged/stretched will be shown.
The default is false.
.TP
.I Tgif.ShowMeasurementUnit: STRING
The STRING specifies the unit used to display the measurement cursor.
There are 2 basic formats.  One is just the word "pixel", "inch", or "cm".
There are also known as basic units.  Another format is NUM BASIC-UNIT/NEW-UNIT,
where NUM is a numeric value, BASIC-UNIT is one of the basic units, and
NEW-UNIT is any string.  For example, "0.1 cm/mm" means that the new
display unit is "mm" and 1 "mm" is 0.1 cm.  "50 pixel/cm" is identical
to "1 cm/cm" and "128 pixel/inch" is identical to "1 inch/inch".
The default is pixel.
.TP
.I Tgif.PageStyleLandscape: [true,false]
If set to ``true'', tgif comes up in landscape mode.
The default is false.
.TP
.I Tgif.QueryZoomInPoint: [true,false] or [always,no_select,no_query,never]
If set to ``true'' (or ``always''), the user will be asked to select a
center point when zooming in.  If set to ``no_select'', the user will
be asked to select a center point when zooming in if no objects are
selected.  If set to ``no_query'', the position of the mouse is the zoom-in
point.  In this case, it is not desirable to zooms in using a menu selection.
The default is false (or never).
.TP
.I Tgif.GZipCmd: STRING
The STRING specifies a command used to gzip a .obj file.
The command \fImust\fR produce output into its stdout.
If the command contains a \fI%s\fR substring, the \fI%s\fR will be replace
by the full path name of a temporary copy of the .obj file.
The default is "gzip -c".
.TP
.I Tgif.GUnZipCmd: STRING
The STRING specifies a command used to unzip a zipped tgif file
(with extension .obj.gz or .sym.gz) into a tgif file.  The command \fImust\fR
produce output into its stdout.  If the command contains a \fI%s\fR
substring, the \fI%s\fR will be replace by the full path name of a
temporary copy of the zipped file.
The default is "gunzip -c".
.TP
.I Tgif.HttpProxy: STRING
The STRING specifies a host name and a port number of an HTTP proxy server.
Format of the specification is \fI<host>:<port>\fR.  If \fI:<port>\fR is
omitted, 80 is used as the default port number.  The environment variable
\fIhttp_proxy\fR has precedence over this X default.
The default is not to use an HTTP proxy server.
.TP
.I Tgif.FtpProxy: STRING
The STRING specifies a host name and a port number of an FTP proxy server.
Format of the specification is \fI<host>:<port>\fR.  If \fI:<port>\fR is
omitted, 21 is used as the default port number.  The environment variable
\fIftp_proxy\fR has precedence over this X default.
The default is not to use an FTP proxy server.
.TP
.I Tgif.InitialArrowStyle: [NONE,RIGHT,LEFT,DOUBLE]
This specifies the initial arrow style for polyline/open-splines/arcs.
The default is RIGHT.
.TP
.I Tgif.ShowPageInEPS: [true,false]
If set to ``true'', a \fIshowpage\fR PostScript command will be generated
for an EPS or EPSI file.
The default is true.
.TP
.I Tgif.MaxNavigateCacheBuffers: NUMBER
This specifies the number of cache buffers allocated to cache remote files
(to minimize communication).
NUMBER must be non-negative.  The default is 40.
.TP
.I Tgif.NumberFileInPrintOnePage: [true,false]
If set to ``true'', when PrintOnePage from the Print Menu
is selected for a stacked multipage drawing (e.g., file.obj), file_\fIN\fR
with the proper file extension will be generated, where \fIN\fR corresponds
to the selected page number.
The default is false.
.TP
.I Tgif.OneMotionTimeout: NUMBER
When Tgif.OneMotionSelMove is set to true, moving an object is considered to
be making a selection if the elapse time between mouse-down and mouse-up is
smaller than the timeout value specified by this X default (in milliseconds).
The default is 200.
.TP
.I Tgif.MinMoveInterval: NUMBER
When Tgif.OneMotionSelMove is set to false, moving an object is considered to
be making a selection if the elapse time between mouse-down and mouse-up is
smaller than the interval specified by this X default (in milliseconds).
The default is 0.
.TP
.I Tgif.GifToXpm: STRING
The STRING specifies a command used to convert a GIF file to an XPM file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the GIF file.
The default is "giftopnm %s | ppmtoxpm".
.TP
.I Tgif.InitExportPixelTrim: LEFT_NUMBER,TOP_NUMBER,RIGHT_NUMBER,BOTTOM_NUMBER
The numbers specify the number of pixels to trim when printing or exporting in
the XBM, XPM, or GIF format.  The use of these values forms an escape
mechanism to fix an idiosyncrasy that tgif can not figure out exactly
how big the whole image is.
The default values are all 0's.
.TP
.I Tgif.QuantizingLevels: NUMBER
Some image functions such as Sharpen() uses convolution
and may generate an image that uses more than 256 colors
which tgif can not handle.
The NUMBER specifies the number of colors to quantize
down to when such a situation occurs.  The default is 222.
.TP
.I Tgif.RotateCursor: [x_cursor,arrow,...]
This specifies the cursor used in the rotate mode.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is crosshair.
.TP
.I Tgif.ColorLayers: [true,false]
If set to ``true'', each color is considered to be
a different layer which can be individually turned
on and off.  If a color layer is turned off, primitive objects in that layer
will not be visible.  A grouped object only becomes invisible
when all its constituent objects are invisible.
The default is false.
.TP
.I Tgif.TiffToXbm: STRING
The STRING specifies a command used to convert a TIFF file to an XBM file.
This command is used when importing an EPSI file generated by a Windows
application.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the TIFF file.
The default is "tifftopnm %s | pgmtopbm | pbmtoxbm".
.TP
.I Tgif.DefFixedWidthFont: STRING
The STRING specifies a font to be used as the default font for the
Status Window, menus, dialogboxes, etc.
The default is "-*-courier-medium-r-normal-*-14-*-*-*-*-*-iso8859-1".
.TP
.I Tgif.DefFixedWidthRulerFont: STRING
The STRING specifies a font to be used in the horizontal and vertical
ruler windows.
The default is "-*-courier-medium-r-normal-*-10-*-*-*-*-*-iso8859-1".
.TP
.I Tgif.MenuFont: STRING
The STRING specifies a font to be used in menus.
If this X default is not specified, the default font is used in menus.
.TP
.I Tgif.BoldMsgFont: STRING
The STRING specifies a bold font to be used in buttons and dialogboxes.
If this X default is not specified but Tgif.MenuFont is specified,
this will take on the value of Tgif.MenuFont.
If this X default and Tgif.MenuFont are not specified, the default font is used
in bold messages.
.TP
.I Tgif.MsgFont: STRING
The STRING specifies a thin font to be used in the Status Window and
dialogboxes.
If this X default is not specified, the default font is used in messages.
.TP
.I Tgif.BggenToXpm: STRING
The STRING specifies a command for generating an X11 pixmap file
to be executed when RunBggen() is selected from the ImageProc Menu.
The STRING \fImust\fR contain two \fI%s\fR substrings.  The first \fI%s\fR
is to be replaced by a user specified string.  The second \fI%s\fR is to
be replaced by the geometry of the image.
The default is "bggen %s -g %s | ppmquant 64 | ppmtoxpm".
Please note that bggen(1) is part of the xv(1) package.
.TP
.I Tgif.BggenToPpm6: STRING
The STRING specifies a command for generating a PPM file
to be executed when RunBggen() is selected from the ImageProc Menu.
The STRING \fImust\fR contain two \fI%s\fR substrings.  The first \fI%s\fR
is to be replaced by a user specified string.  The second \fI%s\fR is to
be replaced by the geometry of the image.
The default is "bggen %s -g %s".
Please note that bggen(1) is part of the xv(1) package.
.TP
.I Tgif.LittleEndianPpm6: [true,false]
If set to ``true'', when reading a PPM (or PGM) file that uses a maxval
of 65535, little endian format will be assumed (the standard for such
a format calls for the big endian format).
The default is false.
.TP
.I Tgif.DefaultErrorDiffuseLevels: R_NUMBER G_NUMBER B_NUMBER
The NUMBERs specify the number of bits of red, green, and blue to
be used when ReduceToDefaultColors() or DefaultErrorDiffuse() are
selected from the ImageProc Menu.  These values determine a set of
default colors to be used for color quantization for the
ReduceToDefaultColors() and DefaultErrorDiffuse() methods.
R_NUMBER+G_NUMBER+B_NUMBER must be less than or equal to 8, and
each number must be greater than 0.
The default is 2 2 2.
.TP
.I Tgif.MaxImportFilters: NUMBER
This specifies the maximum number of import filters.
ImportFilter0 through ImportFilterMax,
where Max is NUMBER-1, in X defaults are queried.
The default is 0.
.TP
.I Tgif.ImportFilter#: FILTERSTRING
This specifies an import filter.  FILTERSTRING has 3 parts (separated by
space characters).  The first part is the name of the filter.  It must
not contain a space character.  The second part contains semicolon-separated
file extensions.  The third part is the actual filter command for converting
the named external file type to an X11 pixmap file.
Please see the IMPORT RASTER GRAPHICS section for details.
.TP
.I Tgif.ShowFileNameOnBrowse: [true,false]
If set to ``true'', file names will be shown when BrowseXBitmap(),
BrowseXPixmap(), or BrowseOther() are selected from the File Menu.
The default is true.
.TP
.I Tgif.HtmlFileExtension: STRING
The STRING specifies the file extension used when printing in the HTML format.
The default is "html".
.TP
.I Tgif.GenerateHtmlHref: [true,false]
If set to ``true'' and when printing in the HTML format,
the value of an \fIhref\fR attribute is parsed.  If the value references
a .obj file, it's changed to have a HTML file extension.
If it is set to ``false'', no conversion will be performed.
The default is true.
.TP
.I Tgif.RotationIncrement: NUMBER
This specifies the initial rotation increment in degrees.
The default is 45.
.TP
.I Tgif.PSA4PaperSize: [true,false]
If set to ``true'' and A4 size paper is specified, the following line
is added to a PS/EPS/EPSI file (before "%%EndComments"):
.PP
.RS
.RS
%%DocumentPaperSizes: a4
.br
.RE
.RE
.PP
.RS
The default is false.
.RE
.TP
.I Tgif.ShapeShadowSpec: STRING
The STRING specifies the initial
horizontal and vertical offsets of a shape shadow.  If both values are zeroes,
a shape is created without a shadow.  When creating a shape with a shadow,
background fill pattern (3rd pattern in the first column of the Fill Menu)
usually gives the best result.
The default is "0,0".
.TP
.I Tgif.StretchableText: [true,false]
If set to ``true'', stretchable text mode is the initial mode.
The default is true.
.TP
.I Tgif.EditTextSize: NUMBER
This specifies the text size to be used in editing existing text
objects.  NUMBER should either be 0 or a value between 4 and 34 (inclusive).
If NUMBER is 0, the actual text size is used in editing existing text objects.
The value of the edit text size can later be changed by selecting
SetEditTextSize() from the Properties Menu.
The default is 0.
.TP
.I Tgif.IconPixmap: (obsolete)
This X default became obsolete in tgif-4.2 because it clashes with the Xtoolket.
It's renamed to Tgif.WMIconPixmap.
.TP
.I Tgif.WMIconPixmap: STRING
STRING specifies the path of an XBM or XPM file to be used as tgif's
desktop icon.
If STRING starts with a / character, absolute path is used;
otherwise, the actual path of the icon file is $TGIFPATH/STRING where
TGIFPATH is either defined using the X defaults or an environment variable.
This X default is only enabled if Tgif.UseWMIcon is set to true.
The default value is ``tgificon.xbm'' (which is compiled into tgif).
.TP
.I Tgif.TmpFileMode: NUMBER (OCTAL)
This specifies file mode for temporary and exported files.
NUMBER must be an octal number.  If NUMBER is 0, no attempt is made to
change the file mode.  If this value is specified (even if it's 0), it
overrides the PSFILE_MOD compile option.
There is no default value.
.TP
.I Tgif.TitledPinnedMenu: [true,false]
If set to ``true'', pinned menu will have a title bar and left button
is used for selecting menu items in a pinned menu.
The default is true.
.TP
.I Tgif.ColorFromXPixmap: STRING
STRING specifies the path of an XPM file to be used to load the initial colors.
If this X default is specified, the Tgif.Color# X defaults are ignored but
Tgif.AdditionalColors X default can be used to specify additional colors when
tgif starts up.
.TP
.I Tgif.VectorWarpSoftness: NUMBER
This specifies the softness value used when VectorWarp() is selected
from the ImageProc Menu.  VectorWarp() lets the user warp pixels in
an X11 pixmap object by specifying a vector.  The size of the
affected area is controlled by this value, which must lie between 1.0
and 4.0.  The larger the value, the larger the affected area.
The default value is 2.0.
.TP
.I Tgif.ChangePropertiesOfAttrs: [true,false]
If set to ``true'', changing a property (such as font, font size, color, etc.)
of an object will change the property of the attributes attached to
the object in the same way.
The default is false.
.TP
.I Tgif.ShiftForDiagMouseMove: [true,false]
If set to ``true'', certain mouse movements are restricted to
multiple of 45 degrees.
The default is true.
.TP
.I Tgif.UseRecentForDiagMouseMove: [true,false]
If set to ``true'', the object that is used as anchor for measuring the
moving distance is used as an anchor when objects.  This only works if
Tgif.UseRecentDupDistance and Tgif.ShiftForDiagMouseMove
are both set to true,
The default is false.
.TP
.I Tgif.FlushColormapOnOpen: [true,false]
If set to ``true'', colormap is flushed and the initial tgif colors are
reloaded when a new file is opened.
The default is false.
.TP
.I Tgif.TransparentPattern: [true,false]
If set to ``true'', fill and pen patterns are transparent initially.
The default is false.
.TP
.I Tgif.DontReencode: STRING
For fonts that are not iso8859-1 encoded, non-ASCII portion of the font
(characters with bit 7 on) is by default reencoded as if it were iso8859-1
encoded.  If this is not desirable for a font, reencoding can be bypassed
by including the first part of the PostScript font name of the font in STRING.
Fields in STRING are colon-separated.
For example, if STRING is "Times:Courier:Helvetica", PostScript fonts that
begins with "Times", "Courier", or "Helvetica" will not be reencoded.
(Please note that this X default overwrite the fonts specified
by -D_DONT_REENCODE at compile time.)
Please also see the POSTSCRIPT CHARACTER ENCODING FOR INTERNATINOAL CHARACTERS
section for an example.
.TP
.I Tgif.AdditionalDontReencode: STRING
Use this X default to augment Tgif.DontReencode (or the fonts specified
by -D_DONT_REENCODE at compile time).  STRING here is basically concatenated
to the STRING specified by Tgif.DontReencode (or the fonts specified
by -D_DONT_REENCODE at compile time).
.TP
.I Tgif.UnsignedInXBmExport: [true,false]
If set to ``true'', \fIunsigned char\fR will be used instead of \fIchar\fR
in exported XBM files.
The default is false.
.TP
.I Tgif.CommentInBitmapExport: [true,false]
If set to ``true'', a blank \fIRCS Header\fR comment will be prepended to
exported XBM and XPM files.
The default is false.
.TP
.I Tgif.ShowFontSizeInPoints: [true,false]
If set to ``true'', font sizes are displayed in the unit of point sizes.
The default is false.
.TP
.I Tgif.DontCondensePSFile: [true,false]
By default, PS/EPS files generated by tgif are not condensed.  If this
X default is set to ``false'', tgif will generate condensed PS/EPS files.
The default is true.
.TP
.I Tgif.StripCondensedPSComments: (obsolete)
This X default became obsolete in tgif-4.0.11
because it turns out that it's not always
okay to strip PS comments (it should always be set to false).
.TP
.I Tgif.PdfFileExtension: STRING
The STRING specifies the file extension used when printing in the PDF format.
The default is "pdf".
.TP
.I Tgif.PsToPdf: STRING
The STRING specifies a command used to convert a PS file to a PDF file.
The STRING \fImust\fR contain 2 \fI%s\fR substrings to be replaced by the
full path name of the PS file and the full path name of the PDF file.
The default is:
.PP
.RS
.RS
ps2pdf "%s" "%s"
.br
.RE
.RE
.PP
.RS
(If you like to use "epstopdf",
you can try setting this to "epstopdf %s --outfile=%s".)
.RE
.TP
.I Tgif.EpsToTmpSvg: STRING
Converting an EPS file to an SVG file is done in two steps.  First
the EPS file is converted to a temporary file and then the
temporary file is converted to an SVG file.  By default, the
uniconvertor(1) format is used for the temporary file.
The STRING here specifies a command for the first part and it
\fImust\fR contain 2 \fI%s\fR substrings to be replaced by the
full path name of the EPS file and the full path name of the temporary file.
The default is:
.PP
.RS
.RS
pstoedit -dt -f sk "%s" "%s"
.br
.RE
.RE
.TP
.I Tgif.TmpSvgToSvg: STRING
This X default is to be used in conjunction with Tgif.EpsToTmpSvg above.
The STRING here specifies a command for the second part of the conversion
and it \fImust\fR contain 2 \fI%s\fR substrings to be replaced by the
full path name of the temporary file and the full path name of the SVG file.
The default is:
.PP
.RS
.RS
uniconvertor "%s" "%s"
.br
.RE
.RE
.TP
.I Tgif.TmpSvgFileExtension: STRING
The STRING specifies the file extension used for the intermediary file
when converting an EPS to an SVG file.
The default is "sk".
.TP
.I Tgif.3DLook: [true,false]
If set to ``false'', no 3D decoration of windows and buttons will be used.
The default is true.
.TP
.I Tgif.XpmDeckToGifAnim: STRING
The STRING specifies a command used to convert a list of GIF file to a
GIF animation file.
The STRING \fImust not\fR contain any \fI%s\fR substring.
The default is "gifsicle -lforever --delay 10".  Gifsicle's home page is
<URL:http://www.lcdf.org/gifsicle/>.  One can also set this X default
to "whirlgif -loop -time 10".  Whirlgif's home page is
<URL:http://www.msg.net/utility/whirlgif/>.
.TP
.I Tgif.GifAnimExplode: STRING
The STRING specifies a command used to explode an animated GIF file into its
constituent GIF files.
The STRING \fImust not\fR contain any \fI%s\fR substring.
The constituent GIF files must have the following file names.  If the
animated GIF file is named "foo.gif", the constituent GIF files must
be named "foo.gif.0", "foo.gif.1", etc.
The default is "gifsicle -eU".  Gifsicle's home page is
<URL:http://www.lcdf.org/gifsicle/>.
.TP
.I Tgif.Btn3PopupModeMenu: [true,false]
If set to ``true'', pressing the right mouse button in the canvas window
will generate the Mode Menu.
The default is false.
.TP
.I Tgif.ScriptFraction: NUMBER
This specifies the size of the super/subscript relative to the size
of the normal text.  The value must be between 0.2 and 0.8.
The default value is 0.6.
.TP
.I Tgif.DeleteNextCharWithDelKey: [true,false]
If set to ``true'', pressing the Delete key on the keyboard will
delete the character to the right of the cursor in text mode.
The default is true.
.TP
.I Tgif.SquareDoubleByteFonts: FONT_SPEC1 FONT_SPEC2 ...
Starting with version 4.0 of tgif, double-byte fonts are supported.
But only double-fonts where every character has the same width and
height are supported.  Please see the SQUARE DOUBLE FONTS
section for details.
.TP
.I Tgif.DefaultSingleByteFont: STRING
Using input methods (specified by the Tgif.DoubleByteInputMethod X default
below),
one can mix english (single-byte) substrings within a double-byte string.
The font to use for the english substring is specified by this X default.
The default is Times.
.TP
.I Tgif.@@@ShowFontChar: OCTAL STRING
OCTAL STRING specifies a double-byte octal character
to be used to represent a double-byte font in the
Choice Window when the font is selected.
@@@ should be replaced by the name of the double-byte font.
Please see the SQUARE DOUBLE FONTS section for examples.
.TP
.I Tgif.@@@ConvFromUTF8: STRING
The STRING specifies a command to be used to convert an UTF8 encoded
string to a string to be pasted into a text object when the current
font is a double-byte font whose name matches @@@.
Please see the SQUARE DOUBLE FONTS section for examples.
.TP
.I Tgif.@@@ConvToUTF8: STRING
The STRING specifies a command to be used to convert
a selected string (whose font name matches @@@ and is a double-byte font)
to be copied to the clipboard to a string in the UTF8 format.
Please see the SQUARE DOUBLE FONTS section for examples.
.TP
.I Tgif.DoubleByteInputMethod: STRING
This specifies the input method for double-byte fonts.
Currently, the following values are supported: "xcin", "chinput", "kinput2",
"xim", and "tgtwb5".
If you are using xcin-2.5 or above, please use "xim" instead of
"xcin".
The "tgtwb5" input method is built into tgif and can take an optional
parameter (by appending ",FONTNAME" after "tgtwb5")
specifying a Big5 X font name to be used in selecting a character.
If FONTNAME is not specified,
"-taipei-fixed-medium-r-normal--16-150-75-75-c-160-big5-0" will be
used.
Please see the SQUARE DOUBLE BYTE FONTS section for details.
.TP
.I Tgif.UseNKF: [true,false]
If set to ``true'', Network Kanji Filter (NKF) will be used.
The default is false.
.TP
.I Tgif.CopyAndPasteJIS: [true,false]
If set to ``true'', copying and pasting text strings will go through
additional JIS to EUC conversion.
The default is false.
.TP
.I Tgif.PreeditType: [overthespot,root]
If set to ``overthespot'', over-the-spot preediting will be used.
The default is root.
.TP
.I Tgif.Lang: STRING
This specifies the locale.  The environment variables LANG can override
this setting.
.TP
.I Tgif.Modifiers: STRING
This specifies the locale modifiers.  The environment variables
XMODIFIERS can override this setting.
.TP
.I Tgif.ConvSelection: STRING
This specifies the name of the selection used in converting kinput2 strings.
The default value is _JAPANESE_CONVERSION.
.TP
.I Tgif.VisibleGridInSlideShow: STRING
If set to ``true'', grids will be visible in slideshow mode.
The default is false.
.TP
.I Tgif.SmoothScrollingCanvas: [off,jump,smooth]
If set to ``smooth'', scrolling the main canvas window will be smooth.
However, there may be a delay when scrolling starts to cache
the image.  If set to ``jump'', scrolling the main canvas window will
be jumpy.  If set to ``off'', scrolling the main canvas window will
not change the canvas until the mouse button is released.
The default is jump.
.TP
.I Tgif.LightGrayColor: COLORSTRING
This specifies the color to be used for the background of buttons, menus, etc.
The default is gray75.
.TP
.I Tgif.DarkGrayColor: COLORSTRING
This specifies the color to be used for the shadow of buttons, menus, etc.
The default is gray50.
.TP
.I Tgif.DefaultObjectBackground: COLORSTRING
This specifies the color to be used for the background of objects.
By default, the default background color is used.
.TP
.I Tgif.UseImagePixelsForTrueColorExport: [true,false]
If set to ``true'', the color table of an exported XPM/GIF file
will be obtained from the actual image pixels for a TrueColor visual.
The default is false.
.TP
.I Tgif.DialogboxUse3DBorder: [true,false]
If set to ``false'', dialogboxes will not have 3D borders.  This should
be used with X servers such as X-Win32 because dialogboxes already have
3D borders.
The default is true.
.TP
.I Tgif.MenuFontSet: STRING
This X default is only used if tgif is compiled with the ENABLE_NLS
compiler option.  The STRING specifies a list of fonts to be used in menus.
STRING can be ``none'' to indicate not to use menu font set.
The default is
"-*-helvetica-medium-r-normal--12-*-*-*-*-*-*-*,-*-*-medium-r-*--12-*-*-*-*-*-*-*".
.TP
.I Tgif.MsgFontSet: STRING
This X default is only used if tgif is compiled with the ENABLE_NLS
compiler option.  The STRING specifies a list of fonts to be used in status
messages.
STRING can be ``none'' to indicate not to use message font set.
The default is
"-*-helvetica-medium-r-normal--12-*-*-*-*-*-*-*,-*-*-medium-r-*--12-*-*-*-*-*-*-*".
.TP
.I Tgif.BoldMsgFontSet: STRING
This X default is only used if tgif is compiled with the ENABLE_NLS
compiler option.  The STRING specifies a list of fonts to be used in
messageboxes.
STRING can be ``none'' to indicate not to use bold message font set.
The default is
"-*-helvetica-bold-r-normal--12-*-*-*-*-*-*-*,-*-*-medium-r-*--12-*-*-*-*-*-*-*".
.TP
.I Tgif.BoldMsgFontDoubleByte: [true,false]
This X default is only used if tgif is compiled with the ENABLE_NLS
compiler option.  This X default should be set to ``true'' if the
strings used in messageboxes may contain double-byte characters.
The default is false.
.TP
.I Tgif.LocaleDir: STRING
This X default is only used if tgif is compiled with the ENABLE_NLS
compiler option.  The STRING specifies a full path name of a locale directory.
.TP
.I Tgif.PsRegMarksInTiledPageMode: [true,false]
If set to ``true'', small crosshairs will be drawn at the
corners defining the clipping regions when printing/exporting
PS/EPS files in the tiled page mode.  The greyness of the cross
hairs will be determined by the Tgif.PsRegMarksGray X default.
The default is false.
.TP
.I Tgif.PsRegMarksGray: NUMBER
This specifies the greyness of the crosshairs used when
Tgif.PsRegMarksInTiledPageMode is set to true.
The default value is 0.95
.TP
.I Tgif.PSFontAliases: PSFONTALIAS_SPEC1 PSFONTALIAS_SPEC2 ...
Font aliases can be used to represent different encoding, etc.
Please see the POSTSCRIPT CHARACTER ENCODING FOR INTERNATINOAL CHARACTERS
section for details.
.TP
.I Tgif.DomainInIni: [true,false]
If set to ``true'', domain information will be loaded from
the ~/.Tgif/domain.ini file and all the menu items in the Domain submenu
of the File Menu will be enabled.
The default is false.
.TP
.I Tgif.UndoRedoRestoreDrawingMode: [true,false]
If set to ``true'', the drawing mode just before an undo/redo operation
will be restored after undo/redo.
The default is true.
.TP
.I Tgif.MenuRowsBeforeScroll: NUMBER
This specifies the maximum number of rows in a user-specifiable text menu
(such as the Font Menu and the FontSize Menu) before a vertical scrollbar is
automatically used.
The default value is 20.
.TP
.I Tgif.MenuColsBeforeScroll: NUMBER
This specifies the maximum number of rows in a user-specifiable bitmap menu
(such as the Color Menu) before a horizontal scrollbar is automatically used.
The default value is 26.
.TP
.I Tgif.PngToXpm: STRING
The STRING specifies a command used to convert a PNG file to an XPM file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PNG file.
The default is "pngtopnm %s | pnmdepth 255 | ppmquant 222 | ppmtoxpm".
.TP
.I Tgif.JpegToXpm: STRING
The STRING specifies a command used to convert a JPEG file to an XPM file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the JPEG file.
The default is "djpeg -gif -color 222 %s | giftopnm | ppmtoxpm".
.TP
.I Tgif.PbmToXbm: STRING
The STRING specifies a command used to convert a PBM file to an XBM file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PBM file.
The default is "pbmtoxbm %s".
.TP
.I Tgif.PgmToXpm: STRING
The STRING specifies a command used to convert a PGM file to an XPM file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PGM file.
The default is "ppmtoxpm %s".
.TP
.I Tgif.PpmToXpm: STRING
The STRING specifies a command used to convert a PPM file to an XPM file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PPM file.
The default is "ppmquant 222 %s | ppmtoxpm".
.TP
.I Tgif.XpmToPng: STRING
The STRING specifies a command used to convert an XPM file to a PNG file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the XPM file.
The default is "xpmtoppm %s | pnmtopng".
.TP
.I Tgif.PngFileExtension: STRING
The STRING specifies the file extension for a PNG file.
The default is "png" (lower case).
.TP
.I Tgif.XpmToJpeg: STRING
The STRING specifies a command used to convert an XPM file to a JPEG file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the XPM file.
The default is "xpmtoppm %s | cjpeg".
.TP
.I Tgif.PpmToGif: STRING
The STRING specifies a command used to convert a PPM file to a GIF file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PPM file.
The default is "ppmquant 222 %s | ppmtogif".
.TP
.I Tgif.PpmToPng: STRING
The STRING specifies a command used to convert a PPM file to a PNG file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PPM file.
The default is "pnmtopng %s".
.TP
.I Tgif.PpmToJpeg: STRING
The STRING specifies a command used to convert a PPM file to a JPEG file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PPM file.
The default is "cjpeg %s".
.TP
.I Tgif.Ppm6ToXpm3: STRING
The STRING specifies a command used to convert a PPM (P6) file to a
version 3 XPM file.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PPM file.
The default is "ppmtoxpm %s".
.TP
.I Tgif.PpmQuantize: STRING
The STRING specifies a command used to quantize the colors of a PPM file
down to a specified number.
The STRING \fImust\fR contain
(1) a \fI%d\fR substring to be replaced by the number of colors to reduce to
and (2) a \fI%s\fR substring to be replaced by the
full path name of the PPM file.
The default is "pnmquant %d %s".
.TP
.I Tgif.PpmFSQuantize: STRING
The STRING specifies a command used to quantize the colors of a PPM file
down to a specified number using the Floyd-Steinberg half-tone algorithm.
The STRING \fImust\fR contain
(1) a \fI%d\fR substring to be replaced by the number of colors to reduce to
and (2) a \fI%s\fR substring to be replaced by the
full path name of the PPM file.
The default is "pnmquant -fs %d %s".
.TP
.I Tgif.JpegFileExtension: STRING
The STRING specifies the file extension for a JPEG file.
The default is "jpg" (lower case).
.TP
.I Tgif.ProducedBy: STRING
When printing/exporting PS/EPS files, STRING will appear in a %%ProducedBy
line in a exported PS/EPS file.  Please include your name and e-mail address
in STRING.
The default is "(unknown)".
.TP
.I Tgif.Editor: STRING
STRING specifies a text editor to use for editing attributes.
The STRING \fImust\fR contain two \fI%s\fR substrings to be replaced by the
window title and the full path name of the text file.  For example,
you can use "xemacs -title '%s' '%s'".
The default is "xterm -title '%s' -e vi '%s'".
.TP
.I Tgif.GoHyperSpaceInSlideShow: [true,false]
If set to ``true'', \fIhyperspace\fR mode will be entered when tgif
enters the slideshow mode.
The default is false.
.TP
.I Tgif.LineWidthIndexInSlideShow: NUMBER
This specifies the line width \fIindex\fR
to use when tgif is in the slideshow mode.
The default value is 4.
.TP
.I Tgif.MaxRecentFiles: NUMBER
This specifies the maximum number of files to remember in the recently
used file list.
The default value is 10.
.TP
.I Tgif.ResetOriginOnAdvancePage: [true,false]
If set to ``true'', tgif will scroll to the left-top corner of the
page when pages are advanced.
The default is false.
.TP
.I Tgif.UseMeasureTooltip: [true,false]
If set to ``true'', the location of the cursor and the width and height
of the object being drawn/dragged/stretched will be shown in a tooltip
window.  This X default only takes effect if Tgif.ShowMeasurement is true.
The default is false.
.TP
.I Tgif.MeasureTooltipXFollowMouse: [true,false]
If set to ``true'', the X position of the measurement tooptip will
follow the mouse.
The default is false.
.TP
.I Tgif.MeasureTooltipYFollowMouse: [true,false]
If set to ``true'', the Y position of the measurement tooptip will
follow the mouse.
The default is false.
.TP
.I Tgif.MeasureTooltipHorizontalPosition: [left,center,right]
Fix the X position of the measurement tooltip to the left, center, or right.
This X default only takes effect if Tgif.MeasureTooltipXFollowMouse is false.
The default is left.
.TP
.I Tgif.MeasureTooltipVerticalPosition: [top,middle,bottom]
Fix the Y position of the measurement tooltip to the top, middle, or bottom.
This X default only takes effect if Tgif.MeasureTooltipYFollowMouse is false.
The default is top.
.TP
.I Tgif.MeasureTooltipVerbose: [true,false]
If set to ``true'', additional information about the positions
and sizes of objects will be displayed in the tooltip window.
The default is false.
.TP
.I Tgif.NoMinWinSize: [true,false]
If set to ``false'', tgif will have a minimum window size so that the
whole panel window is always visible.
The problem with this setting is that some window manager
will show the wrong window size when you resize the window.
This setting is left for compatibility reasons.
If set to ``true'', a side effect is that the menubar will no longer
automatically wraps around when Tgif.MinimalMenubar is set to true.
The default is true.
.TP
.I Tgif.AutoWrapMenubar: [true,false]
If set to ``true'', the menubar will automatically wrap around.
If Tgif.MinimalMenubar is set to false, menubar will always
wrap around automatically.
The default is false.
.TP
.I Tgif.AutoEPSPreviewBitmap: [true,false]
If set to ``true'', when importing a PS/EPS file, tgif will automatically
generate a preview bitmap if the file does not already contain one.
The default is false.
.TP
.I Tgif.PsToXbm: STRING
STRING specifies a command used to convert a PS file to a XBM file.
The STRING \fImust\fR contain a single \fI%s\fR substrings to be replaced by the
full path name of the PS file.  Please note that the above command usually
generates a bitmap that's much larger than image in the file.  Tgif
automatically trims out the blank space similar to the way pbmtoepsi works.
The default is "gs -q -dNOPAUSE -sDEVICE=pbm -sOutputFile=- -- "%s" | pbmtoxbm".
.TP
.I Tgif.TmpDirInHomeDir: [true,false]
If set to ``true'', tgif will use the $HOME/.Tgif directory as the
temporary directory (unless the Tgif.TmpDir X default below is used)
and the compiler option -DTMP_DIR is ignored.
The default is false if the -D_TMP_DIR_IN_HOME_DIR compiler option is used.
The default is true if the -D_TMP_DIR_IN_HOME_DIR compiler option is \fInot\fR
used.
.TP
.I Tgif.TmpDir: STRING
STRING specifies a directory to be used as the temporary directory.
The use of this X default is discouraged, especially if tgif is compiled
with -DUSE_XT_INITIALIZE and a X resource file found in the directory
search path specified by the environment variable $XAPPLRESDIR is used.
By default, tgif uses /tmp as the temporary directory.
.TP
.I Tgif.ThumbnailGeometry: WIDTHxHEIGHT
This X default specifies the geometry of thumbnails.
The default is 160x120.
.TP
.I Tgif.ThumbnailPadding: NUMBER
This specifies the padding (in pixels) for thumbnail images.
The default value is 8.
.TP
.I Tgif.ThumbnailXGap: NUMBER
This specifies the horizontal gap (in pixels) for thumbnail images.
The default value is 16.
.TP
.I Tgif.ThumbnailYGap: NUMBER
This specifies the vertical gap (in pixels) for thumbnail images.
The default value is 0.
.TP
.I Tgif.ThumbnailX: NUMBER
This specifies the starting x location (in pixels) for thumbnail images.
The default value is 32.
.TP
.I Tgif.ThumbnailY: NUMBER
This specifies the starting y location (in pixels) for thumbnail images.
The default value is 32.
.TP
.I Tgif.ShowWireSignalName: [true,false]
If set to ``false'', when connecting ports, tgif will automatically
place the signal name and hide it.  Otherwise, the user will be prompted
to place the signal name and it will be visible.
The default is true.
.TP
.I Tgif.LandscapePdfSetPageDevice: (obsolete)
This X default became obsolete in tgif-4.1.42
because the name is misleading.  Please see Tgif.PdfSetPageDevice below.
.TP
.I Tgif.PdfSetPageDevice: [true,false]
If set to ``true'', when exporting PDF (or PS) files, tgif will use PostScript
"setpagedevice" command to specify the paper size in the generated PostScript
file before calling ps2pdf(1) (if exporting in PDF format).
This should not be necessary (and is considered a bug in ps2pdf).
In the future, this X default can be
used to turn off the generation of the "setpagedevice" command when ps2pdf
can handle landscape PostScript files correctly.
.TP
.I Tgif.DeleteCmdAsCut: (obsolete)
This X default became obsolete in tgif-4.2.3.  Now <Cntrl>x binds to
the Cut command.
.I Tgif.EnableMouseWheel: [true,false]
If set to ``false'', Button4 and Button5 mouse wheel scrolling events will
be ignored.
The default is true.
.I Tgif.Btn2PopupMainMenu: [true,false]
If set to ``false'', Button2 events will not bring up the Main Menu in
the canvas window.
The default is true.
.TP
.I Tgif.NoChoiceWindow: [true,false]
If set to ``true'', no Choice and Message Windows will be shown initially.
The default is false.
.TP
.I Tgif.UseXPmVersion1ForXPmDeck: [true,false]
The setting of this X default should depend on the setting of the
Tgif.XpmDeckToGifAnim X default above.
If set to ``true'', XPM1 file is generated when a deck of X11 pixmap objects
is being converted to a GIF animation file regardless of the setting of the
Tgif.XPmOutputVersion X default.
The default is true.
.TP
.I Tgif.SlideShowWindowOffsets: X_OFFSET,Y_OFFSET
The numbers specify the number of pixels to adjust for the slideshow mode.
If only one value is given, both X and Y offsets are set to the same value.
The default values are all 0's.
.TP
.I Tgif.SlideShowBorderColor: COLORSTRING
This specifies the color to be used for the area outside of the
paper boundary in slideshow mode.
By default, the color of the border is the same as the background color.
.TP
.I Tgif.ConvertToBezierSegments: NUMBER
This specifies the number of segments used in converting a polyline/spline
object to a Bezier curve.
The default value is 50.
.TP
.I Tgif.TickMarkSize: NUMBER
This specifies the size of a tick mark to be used when tick marks are added
at a vertex of a polyline/polygon/spline.
The default value is 8.
.TP
.I Tgif.NoModeWindow: [true,false]
If set to ``true'', no Mode Window will be shown initially.
The default is false.
.TP
.I Tgif.MakeUnsavableInSlideShow: [true,false]
If set to ``true'', the current file will be made unsavable when
slideshow mode is entered.  (If the current file contains auto page
numbering objects, the file will be made unsavable regardless of
the setting of this X default.)
The default is false.
.TP
.I Tgif.SingleByteInputMethod: STRING
This specifies the input method for single-byte fonts.
Currently, only "xim" is supported.
.TP
.I Tgif.IgnoreSlideShowOffsetsInFile: [true,false]
If set to ``false'', the slideshow offsets stored in a file will
override the Tgif.SlideShowWindowOffsets setting.
The default is true.
.TP
.I Tgif.ItalicMsgFont: STRING
The STRING specifies a italic font to be used in some buttons.
If this X default is not specified but Tgif.MenuFont is specified,
this will take on the value of Tgif.MenuFont.
If this X default and Tgif.MenuFont are not specified,
the default font is used in italic messages.
.TP
.I Tgif.ItalicMsgFontSet: STRING
This X default is only used if tgif is compiled with the ENABLE_NLS
compiler option.  The STRING specifies a list of fonts to be used in
messageboxes.  STRING can be ``none'' to indicate not to use italic
message font set.  The default is
"-*-helvetica-medium-o-normal--12-*-*-*-*-*-*-*,-*-*-medium-r-*--12-*-*-*-*-*-*-*".
.TP
.I Tgif.BoldItalicMsgFont: STRING
The STRING specifies a bold italic font to be used in some text.
If this X default is not specified but Tgif.MenuFont is specified,
this will take on the value of Tgif.MenuFont.
If this X default and Tgif.MenuFont are not specified,
the default font is used in bold italic messages.
.TP
.I Tgif.BoldItalicMsgFontSet: STRING
This X default is only used if tgif is compiled with the ENABLE_NLS
compiler option.  The STRING specifies a list of fonts to be used in
some text.  STRING can be ``none'' to indicate not to use bold italic
message font set.  The default is
"-*-helvetica-bold-o-normal--12-*-*-*-*-*-*-*,-*-*-medium-r-*--12-*-*-*-*-*-*-*".
.TP
.I Tgif.ExternalPsToEpsi: [true,false]
If set to ``true'', the execution of the pstoepsi() internal command
will simply invoke pstoepsi externally.
The default is false.
.TP
.I Tgif.GsPath: STRING
The STRING specifies a full path name of the gs (ghostscript) program.
The default is "gs" (which implies that the "gs" excutable is in your PATH).
.TP
.I Tgif.CompoundObjWithTextStretchableForPSE: [true,false]
If set to ``false'', when executing the Precise Scale Everything command,
a compound object will \fBnot\fR be stretched if it contains a text subobject.
This X default only has effect if tgif is in the non-stretchable text mode.
(If tgif is in the stretchable text mode, this X default is ignored.)
The default is false.
.TP
.I Tgif.HideWindowsInSlideShow: [true,false]
If set to ``false'', tgif will keep all windows visible in slideshow mode.
Otherwise, only the canvas window will be visible in slideshow mode.
The default is true.
.TP
.I Tgif.PSDistillerNoImageCompress: [true,false]
If set to ``true'', tgif will generate PostScript code so that
images in a generated PostScript file will \fInot\fR be compressed
by a distiller program such as ps2pdf.
The default is false.
.TP
.I Tgif.AdditionalPSSetup: STRING
If specified, the PostScript line specified by STRING is inserted
at the end of PostScript file setup (right before %%EndSetup).
This option should only be used if one is very familiar with PostScript.
Here is an example to ask distiller programs not to compress bitmap images:
.PP
.RS
.RS
Tgif.AdditionalPSSetup: \\n\\
.br
    systemdict /setdistillerparams known \\n\\
.br
    { << /AutoFilterGrayImages false \\n\\
.br
    /AutoFilterColorImages false \\n\\
.br
    /ColorImageFilter /FlateEncode \\n\\
.br
    /GrayImageFilter /FlateEncode \\n\\
.br
    >> setdistillerparams } if
.br
.RE
.RE
.PP
.TP
.I Tgif.PSFontNeedCharSubs: FONTSUB_SPEC1 FONTSUB_SPEC2 ...
The format of FONTSUB_SPEC is FONTNAME=TOKENNAME where FONTNAME is
the name of a PostScript font and TOKENNAME is the name of the extension for
the Tgif.PSCharSubs_TOKENNAME X default.
For PostScript font names that begins with a string that matches
a FONTNAME part of a FONTSUB_SPEC, tgif will read the
Tgif.PSCharSubs_TOKENNAME X default
to determine which characters will be substituted.

For fonts that are not iso8859-1 encoded, non-ASCII portion of the font
(characters with bit 7 on) is by default reencoded as if it were iso8859-1
encoded when PS output is generated.
If this is not desired, different named PS characters can be substituted
for characters with bit 7 on.
Please also see the POSTSCRIPT CHARACTER ENCODING FOR INTERNATINOAL CHARACTERS
section for an example.
.TP
.I Tgif.PSCharSubs_TOKENNAME: PSCHARSUBS_SPEC1 PSCHARSUBS_SPEC2 ...
TOKENNAME must match a FONTSUB_SPEC in the Tgif.PSFontNeedCharSubs X default.
The format for PSCHARSUBS_SPEC is OLDCHARCODE/NEWCHARNAME where
OLDCHARCODE is a character code in octal format and
NEWCHARNAME is a PostScript character name to use.  For more information,
please see the POSTSCRIPT CHARACTER ENCODING FOR INTERNATINOAL CHARACTERS
section.
.TP
.I Tgif.DrawTextFuncKey_F#: INTERNAL COMMAND LIST
This specifies the correspondence between a function key and a list
of internal commands.  When function key F# is pressed when tgif is
in the text drawing mode, the corresponding
list of internal commands is executed.  Tgif only recognizes function
keys F1 through F12.
.TP
.I Tgif.PasteFromXSelectionOnly: [true,false]
If set to ``false'', if tgif has failed to perform a paste via the X Selections
mechanism, it will attempt the old style paste (directly fetch bytes
from the X server).  This is mainly used with an older X servers.
The default is true.
.TP
.I Tgif.PasteFromSelectionTimeout: NUMBER
This specifies the number of seconds for a paste operation to timeout.
The default value is 10.
.TP
.I Tgif.LengthLimit256InInsertChar: [true,false]
If set to ``true'', the maximum number of characters per line of text
is set at 256.  Additional characters are ignored.
The default is false.
.TP
.I Tgif.JpegToPpm6: STRING
The STRING specifies a command used to convert a JPEG file to a PPM file
in the P6 format.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the JPEG file.
The default is:
.PP
.RS
.RS
djpeg -ppm "%s"
.br
.RE
.RE
.TP
.I Tgif.PngToPpm6: STRING
The STRING specifies a command used to convert a PNG file to a PPM file
in the P6 format.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the PNG file.
The default is:
.PP
.RS
.RS
pngtopnm "%s"
.br
.RE
.RE
.TP
.I Tgif.ObjectShadowOffsets: X_OFFSET,Y_OFFSET
The numbers specify the number of pixels to be offseted when creating a
generic object shadow.
If only one value is given, both X and Y offsets are set to the same value.
The default values are all 2's.
.TP
.I Tgif.ObjectShadowColor: COLORSTRING
This specifies the color to be used for generic object shadow.
The default value is "#c0c0c0".
.TP
.I Tgif.IgnoreObjectShadowInfoInFile: [true,false]
If set to ``false'', the generic object shadow information stored in a file will
override the Tgif.ObjectShadowOffsets and Tgif.ObjectShadowColor settings.
The default is true.
.TP
.I Tgif.ReportMissingFonts: [true,false]
If set to ``true'', when tgif starts, missing X fonts will be printed
to the terminal.
The default is false.
.TP
.I Tgif.CustomPatternDir: STRING
STRING specifies a directory that contains custom fill and pen patterns.
Any valid XBM file, encoding a bitmap of arbitrary dimensions,
name \fBpat\fI#\fB.xbm (for 3<=\f#\fR<=31) in this directory will
replace the corresponding default pattern \f#\fR.
.TP
.I Tgif.EnableTrueColorImages: [true,false]
If set to ``true'', on a TrueColor display,
PPM and JPEG objects will use 24-bit color.
Tgif must be compiled with zlib support to enable this.
The default is true.
.TP
.I Tgif.AutoRotatePivot: [true,false]
If set to ``true'', user-specified rotation pivot will be disabled.
The default is false.
.TP
.I Tgif.RightMargin: STRING
The STRING specifies the right margin.  The right margin must be
specified with a unit (the choices are "pixel", "in", or "cm").
The default is "1 in" if Tgif.GridSystem is "English" and "2.5 cm"
if Tgif.GridSystem is "Metric".
.TP
.I Tgif.EnableRightMargin: [true,false]
If set to ``true'', a simple right-margin will be used when entering text.
This is not a full-featured right-margin.  It is only activated under the
following conditions: text object is not transformed, text is left-justified,
text cursor is not inside a superscript or a subscript, no zoome, and
Tgif.EditTextSize is not used.
The default is false.
.TP
.I Tgif.NoOrientationIfPdfSetPageDevice: [true,false]
If set to ``true'', the "%%Orientation:" line is not generated
in the PostScript file if "setpagedevice" is active
when exporting a PS/EPS/PDF file.  Please see Tgif.PdfSetPageDevice above.
The default is false.
.TP
.I Tgif.PNGExportHasTransparentColor: [true,false]
If set to ``true'', the color specified by the Tgif.PNGExportTransparentColor
X default will be made transparent when printing in the PNG format.
The default is false.
.TP
.I Tgif.PNGExportTransparentColor: COLORSTRING
This specifies the color to be made transparent when printing in the PNG format.
By default, the default background color is used.
.TP
.I Tgif.PpmToPngWithTransparentColor: STRING
The STRING specifies a command used to convert a PPM file to a PNG file
with a transparent color.
The STRING \fImust\fR contain exactly two \fI%s\fR substring to be replaced by the
transparent color and full path name of a PPM file.
The default is "pnmtopng -transparent '%s' '%s'".
.TP
.I Tgif.EnableThresholdFloodReplaceColor: [true,false]
If set to ``true'', threshold-based Flood Fill and Replace Color
will be used.
The default is false.
.TP
.I Tgif.FloodReplaceColorThreshold: RED_THRESH,GREEN_THRESH,BLUE_THRESH
In threshold-based Flood Fill and Replace Color, after a
pixel is selected, pixels that have colors similar to the selected pixel
will also change color.  The similarity is defined by these 3 threshold
values.  Each value must be between 0 and 255, inclusive.
The default values are all 15's.
.TP
.I Tgif.UseStdPalette8: [true,false]
If set to ``true'', a standard 8 palette will be used as the
startup colors.  These colors correspond to all 8 combination of
0x00 and 0xff in red, green, and blue color components.
If this X default is used, the Tgif.AdditionalColors X default
can be used to specify additional colors when tgif starts up.
The default is false.
.TP
.I Tgif.UseStdPalette27: [true,false]
If set to ``true'', a standard 27-color palette will be used as the
startup colors.  These colors correspond to all 27 combination of
0x00, 0x80, and 0xff in red, green, and blue color components.
If this X default is used, the Tgif.AdditionalColors X default
can be used to specify additional colors when tgif starts up.
The default is false.
.TP
.I Tgif.UseStdPalette64: [true,false]
If set to ``true'', a standard 64-color palette will be used as the
startup colors.  These colors correspond to all 64 combination of
0x00, 0x55, 0xaa, and 0xff in red, green, and blue color components.
If this X default is used, the Tgif.AdditionalColors X default
can be used to specify additional colors when tgif starts up.
The default is false.
.TP
.I Tgif.UseStdPalette216: [true,false]
If set to ``true'', a standard 216 palette will be used as the
startup colors.  These colors are known as Mobile Web-safe colors and
they correspond to all 216 combination of
0x00, 0x33, 0x66, 0x99, 0xcc, and 0xff in red, green, and blue color components.
If this X default is used, the Tgif.AdditionalColors X default
can be used to specify additional colors when tgif starts up.
The default is false.
.TP
.I Tgif.UseMobileWebSafePalette: [true,false]
This is identical to Tgif.UseStdPalette216.
.TP
.I Tgif.UseOpenOfficeGalaxyPalette: [true,false]
If set to ``true'', the OpenOffice Galaxy (53-color) palette will be used as the
startup colors.
If this X default is used, the Tgif.AdditionalColors X default
can be used to specify additional colors when tgif starts up.
The default is false.
.TP
.I Tgif.UseOpenOfficeGooglePalette: [true,false]
If set to ``true'', the OpenOffice Google (80-color) palette will be used as the
startup colors.
If this X default is used, the Tgif.AdditionalColors X default
can be used to specify additional colors when tgif starts up.
The default is false.
.TP
.I Tgif.AdditionalColors: COLOR1, COLOR2 ...
If any of the 
Tgif.ColorFromXPixmap,
Tgif.UseStdPalette8, Tgif.UseStdPalette27, Tgif.UseStdPalette64,
Tgif.UseStdPalette216, Tgif.UseMobileWebSafePalette,
Tgif.UseOpenOfficeGalaxyPalette, or Tgif.UseOpenOfficeGooglePalette
X defaults is used, additional startup colors can be specified
using this X default.  Since color names can contain space
characters, the colors must be separated by commas.
.TP
.I Tgif.DefaultColor: COLORSTRING
This specifies the default color if a certain color can not be found.
It has precedence over the Tgif.DefaultColorIndex X default.
If this X default is not specified, Tgif.DefaultColorIndex will determine
the default color.
.I Tgif.GifToPpm6: STRING
The STRING specifies a command used to convert a GIF file to a PPM file
in the P6 format.
The STRING \fImust\fR contain a \fI%s\fR substring to be replaced by the
full path name of the GIF file.
The default is:
.PP
.RS
.RS
giftopnm "%s"
.br
.RE
.RE
.TP
.\"
.\" add new X defaults here
.\"
.SH ENVIRONMENT VARIABLE
.\"
.TP
.I TGIFPATH
This environment variable should be set such that the files, mentioned in the
FILES section below, can be found.
.TP
.I TGIFICON
This environment variable should be set to the name of the object
file to be displayed when tgif is iconified.  By default, it is
set to ``tgificon''.
If it starts with a / character, absolute path is used; otherwise,
the icon file is assumed to be $TGIFPATH/$TGIFICON.
.TP
.I TGIF_[Domain]
\fIObsoleted\fR.
.\"
.SH FILES
.\"
$TGIFPATH/tgificon.obj contains the default tgif icon.
.br
.PP
$TGIFPATH/keys.obj contains a summary of the non-alphanumeric key
bindings.
.br
.\"
.SH PROLOG/C TESTDRIVE
.\"
In the tgif distribution, there are three Prolog files which illustrate
a simple Prolog driver.  \fItgif.pl\fR contains predicates for parsing
tgif files (both .obj and .sym).  \fIfrontend.pl\fR contains predicates
for talking to Prolog engines, such as that of Quintus and SISCtus,
through the foreign function interface.  To use frontend.pl,
\fIfrontend11.o\fR needs to be built (which requires the
\fIfrontend11.o\fR entry to be uncommented from the makefiles).
Finally, \fItestdrive.pl\fR contains a program which will print
out the ID files of all objects in the current drawing, if tgif
is escaped with the Solve() (or #s) command.  This is also
a good way of finding out the structure of a tgif file (especially
because the structure is not documented due to the complexity
introduced to keep tgif compatible with files created by older versions).
.PP
A very simple C driver, \fItestdrive.c\fR, is also provided with
the tgif distribution which
perform the same function as the Prolog driver.  The extra code present
in this file (and not present in tgif.c) is used to illustrate how
the in-memory objects and attributes can be traversed and how new
objects can be created and manipulated.
.\"
.SH SEE ALSO
.\"
\fBlatex\fR(1L), \fBlpr\fR(1), \fBghostscript\fR(1), \fBenv\fR(1), \fBX\fR(1),
\fBdvips\fR(1), \fBcsh\fR(1), \fBpbmplus\fR(1), \fBnetpbm\fR(1),
\fBdjpeg\fR(1), \fBbitmap\fR(1), \fBXPM\fR(1), \fBnetpbm\fR(1),
\fBxfontsel\fR(1), \fBxlsfonts\fR(1), \fBxgrabsc\fR(1), \fBxloadimage\fR(1),
\fBxsnap\fR(1), \fBsxpm\fR(1), \fBxv\fR(1), \fBpstoepsi\fR(1),
\fBMosaic\fR(1), \fBbggen\fR(1), \fBrand\fR(3C), \fBps2pdf\fR(1)
.\"
.SH IDIOSYNCRASIES
.\"
When any of the ``escape to driver'' commands are (accidentally)
executed, the current content of the drawing is saved into
``tmpmodel.obj'' if the drawing indicates that it is a .obj file;
then tgif escapes to the driver and returns right away.
If the drawing indicates that it is a .sym file, then the content
is saved into ``tmpmodel.sym'', but tgif does not return to the driver.
.PP
The paste operation works on a cut buffer generated by tgif or by non-tgif
tools (such as \fIxterm\fR).
If the cut buffer is \fInot\fR generated by tgif, its content is treated as
a collection of
ASCII character strings, which is inserted into the current drawing
as a text object (current settings for text objects are used
to create the text object).
If the cut buffer \fIis\fR generated by tgif, then all the current
settings are ignored.
.PP
The font sizes are the \fIscreen\fR font sizes (which correspond to
the X fonts that are used to draw the text on the screen).
They appear smaller on the printout.
When a 24 point text is printed, it would correspond to about a 13.5 point
PostScript text.  This is because tgif treats 128 pixels as an inch, and
PostScript treats 72 points as an inch.
.PP
Because characters supported by X11 and PostScript are different,
not all the characters, especially in the range 128 to 255 (or \\200 to \\377),
which are supported by X11, but are not accepted
by tgif.  Furthermore, in order to print the supported subset
of these characters, character codes must be re-encoded.
Therefore, if one would like to hack tgif to support other personalized fonts,
one should be careful about the re-encoding mechanism.
.PP
The grids are not absolute; they are specified as screen
pixels, and they scale with the current zoom.  For example,
if the grid is set at 16 pixels at maximum zoom, and if the
user zooms out once, objects can be drawn, moved, or stretched
at 16 screen pixel increments, but this corresponds to 32 pixels in the real
coordinate system.
.PP
If the vertical text spacing is set to negative values, highlighted
text will look a little strange due to XOR operations.
If the vertical text spacing is set to be greater than 100 or less
than -100, the panel window will not be cleared properly; to clear
the panel window, the user may have to close the tgif window and then
open it again.
.PP
As described in the TGIF SUBWINDOWS section,
in constrained move mode, if both endpoints of a not-selected polyline
lie inside the object being moved, then the whole polyline is moved.
This may look strange sometimes because,
for example, if one starts with a line segment pointing to an object,
just moving the object will cause the line segment to be ``stretched'';
however, if one eventually moves the object so that the other endpoint
is also inside the object, any future movement of the object will cause
the whole line segment to move (instead of just moving the original
endpoint).  The moving of the vertex which is the neighbor of
a moved endpoint may also look strange at times.
At this point, one should switch to the unconstrained move mode.
.PP
Another idiosyncrasy with respect to the
constrained move is that right after duplicating
an object, the constrained move is disabled temporarily because it is
assumed that at this point the user would want to move the
new object to a desirable position, and only after this new object is
``settled down'', the constrained move will be re-enabled.  Settling
down is signified by doing something other than moving the new
object.
.PP
Locked objects can be deleted.
.PP
Under the Edit Menu, PasteFromFile() reads a file into the drawing.
Pasting from a file is different from the normal pasting operation
where copying is performed in something like xterm because tabs are
automatically converted to spaces.  Tabs are ignored when pasting from a file.
.PP
When printing a multipage drawing, all pages (even the ones that contains
no objects) will be printed.  Using the PrintOnePage() command under the
Page Menu one can print the selected page (in \fIstacked\fR page layout mode,
this is the current page; in \fItiled\fR page layout mode, the user is
prompted to select a visible page).
.PP
Tgif can be setup to use its own icon window (the Tgif.NoTgifIcon
and the Tgif.UseWMIconPixmap X defaults must both be set to false).
However, it may confuse certain window managers.  So, if the effect
is undesirable, one can set the Tgif.UseWMIconPixmap X defaults to true.
.\"
.SH BUGS
.\"
There seems to be a problem with printing Courier fonts with
a non-solid pen on the Apple LaserWriter.  (Printing single
character does seem to work fine.)
As pointed out by the PostScript reference
manual, Courier is a ``stroked font'', and it is usually ``difficult'' to
construct character paths for such types of fonts.
However, Courier fonts work fine with ghostscript(1) and dxpsview.
It's not clear how this problem can be fixed.  The author
recommends avoiding Courier fonts when printing in color
if a non-solid pen is desired.
.PP
Arcs with arrow tips don't look very sharp (the tip is not pointed
as in open-splines with arrow tips).
.PP
At high magnifications, \fIstretching\fR arcs may cause anomalous
behavior due to round off errors.
.PP
When page reduction/magnification is not set at 100%, the markings in
the Ruler Windows do not correspond to real measurements.
.PP
Copying/pasting large objects might not work because tgif does
not use the ``selection'' mechanism (yet).
.PP
If and when tgif crashes, it will try to save the
current content of the drawing in a file called
``EmergencySave.obj'' (or ``EmergencySave.sym'' if the current
drawing specifies a symbol object).
Often, the drawing can be restored by loading the ``EmergencySave.obj'' file.
Nevertheless, if the cause of
the crash is that some objects are corrupted (due to programming
bugs), then the ``EmergencySave.obj'' file may also be corrupted.
.PP
When launching an application, if the command does not end with the '&'
character and the command does not terminate, tgif also hangs.  In this
case, kill(1) should be used to send HUP signal to the tgif process if
one wants to save the content of tgif in ``EmergencySave.obj''.
.PP
The file \fIexec.c\fR may not compile properly on AIX machines.  One might
have to add -D_BSD to the DEFINES in either the Imakefile or Makefile.noimake.
.\"
.SH COPYRIGHT
.\"
Please see the ``Copyright'' file for details on the copyrights.
.PP
\fIPostScript\fR is a trademark of Adobe Systems Incorporated.
.\"
.SH STATUS
.\"
The current status of tgif can be obtained from tgif's
World-Wide-Web home page at <URL:http://bourbon.usc.edu/tgif/>.
.\"
.SH AUTHOR
.\"
William Chia-Wei Cheng (bill.cheng@acm.org)
.br
<URL:http://merlot.usc.edu/william/usc/>
.SH REFERENCES
.IP [1]
``\fIA Beginner's Guild to HTML\fR'',
<URL:http://www.ncsa.uiuc.edu/General/Internet/WWW/HTMLPrimer.html>.
.IP [2]
``\fICGI - Common Gateway Interface\fR'',
<URL:http://www.w3.org/CGI/overview.html>.
.IP [3]
``\fINCSA Imagemap\fR'',
<URL:http://hoohoo.ncsa.uiuc.edu/docs/tutorials/imagemapping.html>.
.IP [4]
``\fICERN Clickable Image\fR'',
<URL:http://www.w3.org/hypertext/WWW/Daemon/User/CGI/HTImageDoc.html>.
