% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_info.R
\name{font_info}
\alias{font_info}
\title{Query font-specific information}
\usage{
font_info(
  family = "",
  italic = FALSE,
  bold = FALSE,
  size = 12,
  res = 72,
  path = NULL,
  index = 0
)
}
\arguments{
\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{bold}{logical indicating whether the font weight}

\item{size}{The pointsize of the font to use for size related measures}

\item{res}{The ppi of the size related mesures}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
A data.frame giving info on the requested font + size combinations. The
data.frame will contain the following columns:

\describe{
\item{path}{The path to the font file}
\item{index}{The 0-based index of the font in the fontfile}
\item{family}{The family name of the font}
\item{style}{The style name of the font}
\item{italic}{A logical giving if the font is italic}
\item{bold}{A logical giving if the font is bold}
\item{monospace}{A logical giving if the font is monospace}
\item{weight}{A factor giving the weight of the font}
\item{width}{A factor giving the width of the font}
\item{kerning}{A logical giving if the font supports kerning}
\item{color}{A logical giving if the font has color glyphs}
\item{scalable}{A logical giving if the font is scalable}
\item{vertical}{A logical giving if the font is vertical}
\item{n_glyphs}{The number of glyphs in the font}
\item{n_sizes}{The number of predefined sizes in the font}
\item{n_charmaps}{The number of character mappings in the font file}
\item{bbox}{A bounding box large enough to contain any of the glyphs in the font}
\item{max_ascend}{The maximum ascend of the tallest glyph in the font}
\item{max_descent}{The maximum descend of the most descending glyph in the font}
\item{max_advance_width}{The maximum horizontal advance a glyph can make}
\item{max_advance_height}{The maximum vertical advance a glyph can make}
\item{lineheight}{The height of a single line of text in the font}
\item{underline_pos}{The position of a potential underlining segment}
\item{underline_size}{The width the the underline}
}
}
\description{
Get general information about a font, relative to a given size. Size specific
measures will be returned in pixel units. The function is vectorised to the
length of the longest argument.
}
\examples{
font_info('serif')

# Avoid lookup if font file is already known
sans <- match_fonts('sans')
font_info(path = sans$path, index = sans$index)

}
