% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle_future.R
\name{Extract.rle}
\alias{Extract.rle}
\alias{[.rle}
\alias{[<-.rle}
\alias{[[.rle}
\alias{[[<-.rle}
\alias{$.rle}
\alias{$<-.rle}
\title{Indexing Methods for \code{rle} Objects}
\usage{
\method{[}{rle}(x, i, ...)

\method{[}{rle}(x, i, ...) <- value

\method{[[}{rle}(x, i, ...)

\method{[[}{rle}(x, i, ...) <- value

\method{$}{rle}(x, name)

\method{$}{rle}(x, name) <- value
}
\arguments{
\item{x, i, name, value, ...}{Arguments to indexing operators. See
\link{Extract} documentation in the \code{base} package.}
}
\value{
At this time, all functions raise an error except for
\code{\link{character}} indices. This behaviour can be overridden by
setting \code{options(rle.unclass_index=TRUE)}, which effectively
\code{\link{unclass}}es the objects before indexing.
}
\description{
These methods are defined and produce an error (except
for \code{\link{character}} input) to future-proof code that depends on the
\code{rle} package by preventing their use.
}
\details{
At this time, the \code{rle} package does not support indexing
operations by \code{\link{logical}} or \code{\link{numeric}} indices, but it is
likely to do so in the future. Therefore, we reserve the syntax
now to prevent users of this package from relying on the default
behaviour of the indexing operators.
}
\examples{

# Indexing by character or by $ works, including sub-indexing.
x <- rle(1:5)
x[["values"]] <- 2:6
x
x$values[2:3] <- 7:8
x


\dontrun{
# Numerical indexing doesn't, unless `options(rle.unclass_index=TRUE)` is set.
x[1]
x[[1]]
}
}
