% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sis.R
\name{sis}
\alias{sis}
\alias{sis.array}
\alias{sis.matrix}
\alias{sis.default}
\title{Standard importance sampling (SIS)}
\usage{
sis(log_ratios, ...)

\method{sis}{array}(log_ratios, ..., r_eff = NULL, cores = getOption("mc.cores", 1))

\method{sis}{matrix}(log_ratios, ..., r_eff = NULL, cores = getOption("mc.cores", 1))

\method{sis}{default}(log_ratios, ..., r_eff = NULL)
}
\arguments{
\item{log_ratios}{An array, matrix, or vector of importance ratios on the log
scale (for Importance sampling LOO, these are \emph{negative} log-likelihood
values). See the \strong{Methods (by class)} section below for a detailed
description of how to specify the inputs for each method.}

\item{...}{Arguments passed on to the various methods.}

\item{r_eff}{Vector of relative effective sample size estimates containing
one element per observation. The values provided should be the relative
effective sample sizes of \code{1/exp(log_ratios)} (i.e., \code{1/ratios}).
This is related to the relative efficiency of estimating the normalizing
term in self-normalizing importance sampling. See the \code{\link[=relative_eff]{relative_eff()}}
helper function for computing \code{r_eff}. If using \code{psis} with
draws of the \code{log_ratios} not obtained from MCMC then the warning
message thrown when not specifying \code{r_eff} can be disabled by
setting \code{r_eff} to \code{NA}.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}
}
\value{
The \code{sis()} methods return an object of class \code{"sis"},
which is a named list with the following components:

\describe{
\item{\code{log_weights}}{
Vector or matrix of smoothed but \emph{unnormalized} log
weights. To get normalized weights use the
\code{\link[=weights.importance_sampling]{weights()}} method provided for objects of
class \code{sis}.
}
\item{\code{diagnostics}}{
A named list containing one vector:
\itemize{
\item \code{pareto_k}: Not used in \code{sis}, all set to 0.
\item \code{n_eff}: effective sample size estimates.
}
}
}

Objects of class \code{"sis"} also have the following \link[=attributes]{attributes}:
\describe{
\item{\code{norm_const_log}}{
Vector of precomputed values of \code{colLogSumExps(log_weights)} that are
used internally by the \code{weights} method to normalize the log weights.
}
\item{\code{r_eff}}{
If specified, the user's \code{r_eff} argument.
}
\item{\code{tail_len}}{
Not used for \code{sis}.
}
\item{\code{dims}}{
Integer vector of length 2 containing \code{S} (posterior sample size)
and \code{N} (number of observations).
}
\item{\code{method}}{
Method used for importance sampling, here \code{sis}.
}
}
}
\description{
Implementation of standard importance sampling (SIS).
}
\section{Methods (by class)}{
\itemize{
\item \code{sis(array)}: An \eqn{I} by \eqn{C} by \eqn{N} array, where \eqn{I}
is the number of MCMC iterations per chain, \eqn{C} is the number of
chains, and \eqn{N} is the number of data points.

\item \code{sis(matrix)}: An \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size
of the posterior sample (with all chains merged) and \eqn{N} is the number
of data points.

\item \code{sis(default)}: A vector of length \eqn{S} (posterior sample size).

}}
\examples{
log_ratios <- -1 * example_loglik_array()
r_eff <- relative_eff(exp(-log_ratios))
sis_result <- sis(log_ratios, r_eff = r_eff)
str(sis_result)

# extract smoothed weights
lw <- weights(sis_result) # default args are log=TRUE, normalize=TRUE
ulw <- weights(sis_result, normalize=FALSE) # unnormalized log-weights

w <- weights(sis_result, log=FALSE) # normalized weights (not log-weights)
uw <- weights(sis_result, log=FALSE, normalize = FALSE) # unnormalized weights

}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2017). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC.
\emph{Statistics and Computing}. 27(5), 1413--1432. doi:10.1007/s11222-016-9696-4
(\href{https://link.springer.com/article/10.1007/s11222-016-9696-4}{journal version},
\href{https://arxiv.org/abs/1507.04544}{preprint arXiv:1507.04544}).

Vehtari, A., Simpson, D., Gelman, A., Yao, Y., and Gabry, J. (2024).
Pareto smoothed importance sampling. \emph{Journal of Machine Learning Research},
25(72):1-58.
\href{https://jmlr.org/papers/v25/19-556.html}{PDF}
}
\seealso{
\itemize{
\item \code{\link[=psis]{psis()}} for approximate LOO-CV using PSIS.
\item \code{\link[=loo]{loo()}} for approximate LOO-CV.
\item \link{pareto-k-diagnostic} for PSIS diagnostics.
}
}
