% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/fitDTU.R
\name{fitDTU}
\alias{fitDTU}
\alias{fitDTU,SummarizedExperiment-method}
\title{fitDTU}
\usage{
fitDTU(object, ...)

\S4method{fitDTU}{SummarizedExperiment}(
  object,
  formula,
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  verbose = TRUE
)
}
\arguments{
\item{object}{A `SummarizedExperiment` instance generated with the
SummarizedExperiment function of the SummarizedExperiment package.
In the assay slot, provide the transcript-level expression counts as an
ordinary `matrix`, `DataFrame`, a `sparseMatrix` or a `DelayedMatrix`.
The `rowData` slot must be a `DataFrame` object describing the rows,
which must contain a column `isoform_id` with the row names of
the expression matrix and a column `gene_id` with the corresponding gene
identifiers of each transcript. `colData` is a `DataFrame` describing
the samples or cells in the experiment. Finally, specify the
experimental design as a formula in the metadata slot. This formula must
be based on the colData. See the documentation examples and the vignette
for more details.}

\item{...}{parameters including:}

\item{formula}{Model formula. The model is built based on the
covariates in the data object.}

\item{parallel}{Logical, defaults to FALSE. Set to TRUE if you want to
parallellize the fitting procedure.}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{bpparam} in \code{BiocParallel} package for details.}

\item{verbose}{Logical, should progress be printed?}
}
\value{
An updated `SummarizedExperiment` instance. The instance now includes
    a new list of models ("fitDTUModels") in its rowData slot,
    which can be accessed by rowData(object)[["fitDTUModels"]].
}
\description{
Parameter estimation of quasi-binomial models.
}
\examples{
data(sumExp_example, package = "satuRn")
sumExp <- fitDTU(
    object = sumExp_example,
    formula = ~ 0 + group,
    parallel = FALSE,
    BPPARAM = BiocParallel::bpparam(),
    verbose = TRUE
)
}
\author{
Jeroen Gilis
}
