% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-coercion.r
\name{Coercion methods}
\alias{Coercion methods}
\alias{as.data.frame.DiffusionMap}
\alias{fortify.DiffusionMap}
\alias{as.data.frame.DPT}
\alias{fortify.DPT}
\alias{as.matrix.DPT}
\alias{as.data.frame,DiffusionMap-method}
\alias{as.data.frame,DPT-method}
\alias{as.matrix,DPT-method}
\title{Coercion methods}
\usage{
\S4method{as.data.frame}{DiffusionMap}(x, row.names = NULL, optional = FALSE, ...)

fortify.DiffusionMap(model, data, ...)

\S4method{as.data.frame}{DPT}(x, row.names = NULL, optional = FALSE, ...)

fortify.DPT(model, data, ...)

\S4method{as.matrix}{DPT}(x, ...)
}
\arguments{
\item{x, model}{A \code{\link{DiffusionMap}} or \code{\link{DPT}} object}

\item{row.names}{NULL or a character vector giving the row names for the data frame. Missing values are not allowed.}

\item{optional}{logical. If TRUE, setting row names and converting column names (to syntactic names: see make.names) is optional.}

\item{...}{Passed to \code{\link[base]{as.data.frame}}}

\item{data}{ignored}
}
\value{
An object of the desired class
}
\description{
Convert a \code{\link{DiffusionMap}} or \code{\link{DPT}} object to other classes
}
\details{
\link[ggplot2]{fortify} is a ggplot2 generic allowing a diffusion map to be used as \code{data} parameter in \link[ggplot2]{ggplot} or \link[ggplot2]{qplot}.
}
\examples{
library(Biobase)
data(guo)
dm <- DiffusionMap(guo)
classes <- vapply(as.data.frame(dm), class, character(1L))
stopifnot(all(classes[paste0('DC', 1:20)] == 'numeric'))
stopifnot(all(classes[featureNames(guo) ] == 'numeric'))
stopifnot(all(classes[   varLabels(guo) ] == c('factor', 'integer')))

}
\seealso{
\link{DiffusionMap accession methods}, \link{Extraction methods}, \link{DiffusionMap methods} for more
}
