# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web.aio import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementDomainsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_check_availability(self, resource_group):
        response = await self.client.domains.check_availability(
            identifier={"name": "str"},
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_list(self, resource_group):
        response = self.client.domains.list(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_get_control_center_sso_request(self, resource_group):
        response = await self.client.domains.get_control_center_sso_request(
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_list_recommendations(self, resource_group):
        response = self.client.domains.list_recommendations(
            parameters={"keywords": "str", "maxDomainRecommendations": 0},
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_list_by_resource_group(self, resource_group):
        response = self.client.domains.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_get(self, resource_group):
        response = await self.client.domains.get(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.domains.begin_create_or_update(
                resource_group_name=resource_group.name,
                domain_name="str",
                domain={
                    "location": "str",
                    "authCode": "str",
                    "autoRenew": True,
                    "consent": {"agreedAt": "2020-02-20 00:00:00", "agreedBy": "str", "agreementKeys": ["str"]},
                    "contactAdmin": {
                        "email": "str",
                        "nameFirst": "str",
                        "nameLast": "str",
                        "phone": "str",
                        "addressMailing": {
                            "address1": "str",
                            "city": "str",
                            "country": "str",
                            "postalCode": "str",
                            "state": "str",
                            "address2": "str",
                        },
                        "fax": "str",
                        "jobTitle": "str",
                        "nameMiddle": "str",
                        "organization": "str",
                    },
                    "contactBilling": {
                        "email": "str",
                        "nameFirst": "str",
                        "nameLast": "str",
                        "phone": "str",
                        "addressMailing": {
                            "address1": "str",
                            "city": "str",
                            "country": "str",
                            "postalCode": "str",
                            "state": "str",
                            "address2": "str",
                        },
                        "fax": "str",
                        "jobTitle": "str",
                        "nameMiddle": "str",
                        "organization": "str",
                    },
                    "contactRegistrant": {
                        "email": "str",
                        "nameFirst": "str",
                        "nameLast": "str",
                        "phone": "str",
                        "addressMailing": {
                            "address1": "str",
                            "city": "str",
                            "country": "str",
                            "postalCode": "str",
                            "state": "str",
                            "address2": "str",
                        },
                        "fax": "str",
                        "jobTitle": "str",
                        "nameMiddle": "str",
                        "organization": "str",
                    },
                    "contactTech": {
                        "email": "str",
                        "nameFirst": "str",
                        "nameLast": "str",
                        "phone": "str",
                        "addressMailing": {
                            "address1": "str",
                            "city": "str",
                            "country": "str",
                            "postalCode": "str",
                            "state": "str",
                            "address2": "str",
                        },
                        "fax": "str",
                        "jobTitle": "str",
                        "nameMiddle": "str",
                        "organization": "str",
                    },
                    "createdTime": "2020-02-20 00:00:00",
                    "dnsType": "str",
                    "dnsZoneId": "str",
                    "domainNotRenewableReasons": ["str"],
                    "expirationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "kind": "str",
                    "lastRenewedTime": "2020-02-20 00:00:00",
                    "managedHostNames": [
                        {
                            "azureResourceName": "str",
                            "azureResourceType": "str",
                            "customHostNameDnsRecordType": "str",
                            "hostNameType": "str",
                            "name": "str",
                            "siteNames": ["str"],
                        }
                    ],
                    "name": "str",
                    "nameServers": ["str"],
                    "privacy": bool,
                    "provisioningState": "str",
                    "readyForDnsRecordManagement": bool,
                    "registrationStatus": "str",
                    "tags": {"str": "str"},
                    "targetDnsType": "str",
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_delete(self, resource_group):
        response = await self.client.domains.delete(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_update(self, resource_group):
        response = await self.client.domains.update(
            resource_group_name=resource_group.name,
            domain_name="str",
            domain={
                "authCode": "str",
                "autoRenew": True,
                "consent": {"agreedAt": "2020-02-20 00:00:00", "agreedBy": "str", "agreementKeys": ["str"]},
                "contactAdmin": {
                    "email": "str",
                    "nameFirst": "str",
                    "nameLast": "str",
                    "phone": "str",
                    "addressMailing": {
                        "address1": "str",
                        "city": "str",
                        "country": "str",
                        "postalCode": "str",
                        "state": "str",
                        "address2": "str",
                    },
                    "fax": "str",
                    "jobTitle": "str",
                    "nameMiddle": "str",
                    "organization": "str",
                },
                "contactBilling": {
                    "email": "str",
                    "nameFirst": "str",
                    "nameLast": "str",
                    "phone": "str",
                    "addressMailing": {
                        "address1": "str",
                        "city": "str",
                        "country": "str",
                        "postalCode": "str",
                        "state": "str",
                        "address2": "str",
                    },
                    "fax": "str",
                    "jobTitle": "str",
                    "nameMiddle": "str",
                    "organization": "str",
                },
                "contactRegistrant": {
                    "email": "str",
                    "nameFirst": "str",
                    "nameLast": "str",
                    "phone": "str",
                    "addressMailing": {
                        "address1": "str",
                        "city": "str",
                        "country": "str",
                        "postalCode": "str",
                        "state": "str",
                        "address2": "str",
                    },
                    "fax": "str",
                    "jobTitle": "str",
                    "nameMiddle": "str",
                    "organization": "str",
                },
                "contactTech": {
                    "email": "str",
                    "nameFirst": "str",
                    "nameLast": "str",
                    "phone": "str",
                    "addressMailing": {
                        "address1": "str",
                        "city": "str",
                        "country": "str",
                        "postalCode": "str",
                        "state": "str",
                        "address2": "str",
                    },
                    "fax": "str",
                    "jobTitle": "str",
                    "nameMiddle": "str",
                    "organization": "str",
                },
                "createdTime": "2020-02-20 00:00:00",
                "dnsType": "str",
                "dnsZoneId": "str",
                "domainNotRenewableReasons": ["str"],
                "expirationTime": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "lastRenewedTime": "2020-02-20 00:00:00",
                "managedHostNames": [
                    {
                        "azureResourceName": "str",
                        "azureResourceType": "str",
                        "customHostNameDnsRecordType": "str",
                        "hostNameType": "str",
                        "name": "str",
                        "siteNames": ["str"],
                    }
                ],
                "name": "str",
                "nameServers": ["str"],
                "privacy": bool,
                "provisioningState": "str",
                "readyForDnsRecordManagement": bool,
                "registrationStatus": "str",
                "targetDnsType": "str",
                "type": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_list_ownership_identifiers(self, resource_group):
        response = self.client.domains.list_ownership_identifiers(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_get_ownership_identifier(self, resource_group):
        response = await self.client.domains.get_ownership_identifier(
            resource_group_name=resource_group.name,
            domain_name="str",
            name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_create_or_update_ownership_identifier(self, resource_group):
        response = await self.client.domains.create_or_update_ownership_identifier(
            resource_group_name=resource_group.name,
            domain_name="str",
            name="str",
            domain_ownership_identifier={
                "id": "str",
                "kind": "str",
                "name": "str",
                "ownershipId": "str",
                "type": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_delete_ownership_identifier(self, resource_group):
        response = await self.client.domains.delete_ownership_identifier(
            resource_group_name=resource_group.name,
            domain_name="str",
            name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_update_ownership_identifier(self, resource_group):
        response = await self.client.domains.update_ownership_identifier(
            resource_group_name=resource_group.name,
            domain_name="str",
            name="str",
            domain_ownership_identifier={
                "id": "str",
                "kind": "str",
                "name": "str",
                "ownershipId": "str",
                "type": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_renew(self, resource_group):
        response = await self.client.domains.renew(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_domains_transfer_out(self, resource_group):
        response = await self.client.domains.transfer_out(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...
