<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# array2buffer

> Allocate a [buffer][@stdlib/buffer/ctor] using an octet array.

<!-- Section to include introductory text. Make sure to keep an empty line after the intro `section` element and another before the `/section` close. -->

<section class="intro">

</section>

<!-- /.intro -->

<!-- Package usage documentation. -->

<section class="usage">

## Usage

```javascript
var array2buffer = require( '@stdlib/buffer/from-array' );
```

#### array2buffer( arr )

Allocates a [buffer][@stdlib/buffer/ctor] using an `array` (or array-like `object`) of octets.

```javascript
var buf = array2buffer( [ 1, 2, 3, 4 ] );
// returns <Buffer>[ 1, 2, 3, 4 ]
```

</section>

<!-- /.usage -->

<!-- Package usage notes. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="notes">

</section>

<!-- /.notes -->

<!-- Package usage examples. -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var array2buffer = require( '@stdlib/buffer/from-array' );

var octets;
var buf;
var str;
var i;

// Define a string we want to convert to a buffer:
str = 'this is a string.';

// Manually convert the string to an array of octets...
octets = new Array( str.length );
for ( i = 0; i < str.length; i++ ) {
    octets[ i ] = str.charCodeAt( i ) % 256;
}

// Create a buffer from the octet array:
buf = array2buffer( octets );
console.log( buf.toString() );
```

</section>

<!-- /.examples -->

<!-- Section to include cited references. If references are included, add a horizontal rule *before* the section. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="references">

</section>

<!-- /.references -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[@stdlib/buffer/ctor]: https://github.com/stdlib-js/buffer/tree/main/ctor

</section>

<!-- /.links -->
