//start of DisconnectableOutputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * DisconnectableOutputStream.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.Disconnectable;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;

/**
 * f[^ďo͂o̓Xg[
 * f[^foCXɏo͂Xg[Ƃ
 * ڑ邽߂̃[eBeBNXB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: DisconnectableOutputStream.java,v $
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     ^up~
 *     CZX̏C
 *     \[X
 * 
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class DisconnectableOutputStream extends OutputStream
                                        implements Disconnectable {

    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private OutputStream out
    //------------------------------------------------------------------
    /**
     * ڑꂽo̓Xg[
     */
    private OutputStream out;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private DisconnectableOutputStream()
    //  public DisconnectableOutputStream( OutputStream out )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private DisconnectableOutputStream(){   }

    /**
     * out Ƃ̐ڑ\ȏo̓Xg[\zB
     * 
     * @param out o̓Xg[
     */
    public DisconnectableOutputStream( OutputStream out ){
        if( out != null ){
            this.out = out;
        }else{
            throw new NullPointerException( "out" );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream method
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void write( int data )
    //  public void write( byte[] buffer )
    //  public void write( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * ڑꂽo̓Xg[ 1oCg̃f[^o͂B<br>
     * 
     * @param data ܂ׂ 1oCg̃f[^B<br>
     *             ʓIɏ3oCg͖B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( int data ) throws IOException {
        this.out.write( data );                                                 //throws IOException
    }

    /**
     * ڑꂽo̓Xg[ buffer̃f[^
     * Sďo͂B<br>
     * 
     * @param buffer ܂ׂf[^i[
     *               oCgzB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( byte[] buffer ) throws IOException {
        this.out.write( buffer, 0, buffer.length );                             //throws IOException
    }

    /**
     * ڑꂽo̓Xg[ buffer̃f[^
     * indexŎw肳ꂽʒu lengthoCgo͂B<br>
     * 
     * @param buffer ܂ׂf[^i[
     *               oCgzB<br>
     * @param index  buffeȑނׂf[^̊JnʒuB<br>
     * @param length ނׂf[^ʁB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( byte[] buffer, int index, int length )
                                                           throws IOException {
        this.out.write( buffer, index, length );                                //throws IOException
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ڑꂽo̓Xg[ɒ~ꂽf[^Sďo͂
     * 悤ɎwB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void flush() throws IOException {
        this.out.flush();
    }

    /**
     * ڑꂽo̓Xg[Ƃ̐ڑB<br>
     * ̃\bh disconnect() ĂяołB<br>
     */
    public void close(){
        this.disconnect();
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.io.Disconnectable
    //------------------------------------------------------------------
    //  public void disconnect()
    //------------------------------------------------------------------
    /**
     * ڑꂽo̓Xg[Ƃ̐ڑB<br>
     */
    public void disconnect(){
        this.out = null;
    }

}
//end of DisconnectableOutputStream.java
