/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.navigation;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class KotlinGotoTestGenerated extends AbstractKotlinGotoTest {
    @TestMetadata("idea/testData/navigation/gotoClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class GotoClass extends AbstractKotlinGotoTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doClassTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInGotoClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/navigation/gotoClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("builtInAny.kt")
        public void testBuiltInAny() throws Exception {
            runTest("idea/testData/navigation/gotoClass/builtInAny.kt");
        }

        @TestMetadata("builtInInt.kt")
        public void testBuiltInInt() throws Exception {
            runTest("idea/testData/navigation/gotoClass/builtInInt.kt");
        }

        @TestMetadata("enumEntries.kt")
        public void testEnumEntries() throws Exception {
            runTest("idea/testData/navigation/gotoClass/enumEntries.kt");
        }

        @TestMetadata("inClassObject.kt")
        public void testInClassObject() throws Exception {
            runTest("idea/testData/navigation/gotoClass/inClassObject.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("idea/testData/navigation/gotoClass/innerClass.kt");
        }

        @TestMetadata("localDeclarations.kt")
        public void testLocalDeclarations() throws Exception {
            runTest("idea/testData/navigation/gotoClass/localDeclarations.kt");
        }

        @TestMetadata("noImplementationTrait.kt")
        public void testNoImplementationTrait() throws Exception {
            runTest("idea/testData/navigation/gotoClass/noImplementationTrait.kt");
        }

        @TestMetadata("simpleClass.kt")
        public void testSimpleClass() throws Exception {
            runTest("idea/testData/navigation/gotoClass/simpleClass.kt");
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("idea/testData/navigation/gotoClass/simpleObject.kt");
        }

        @TestMetadata("traitWithFunImplement.kt")
        public void testTraitWithFunImplement() throws Exception {
            runTest("idea/testData/navigation/gotoClass/traitWithFunImplement.kt");
        }

        @TestMetadata("typealias.kt")
        public void testTypealias() throws Exception {
            runTest("idea/testData/navigation/gotoClass/typealias.kt");
        }
    }

    @TestMetadata("idea/testData/navigation/gotoSymbol")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class GotoSymbol extends AbstractKotlinGotoTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doSymbolTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInGotoSymbol() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/navigation/gotoSymbol"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("builtInArrayOfNulls.kt")
        public void testBuiltInArrayOfNulls() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/builtInArrayOfNulls.kt");
        }

        @TestMetadata("builtInInt.kt")
        public void testBuiltInInt() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/builtInInt.kt");
        }

        @TestMetadata("enumConstants.kt")
        public void testEnumConstants() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/enumConstants.kt");
        }

        @TestMetadata("functions.kt")
        public void testFunctions() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/functions.kt");
        }

        @TestMetadata("javaMethods.kt")
        public void testJavaMethods() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/javaMethods.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/localFunction.kt");
        }

        @TestMetadata("privateTopLevelDeclarations.kt")
        public void testPrivateTopLevelDeclarations() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/privateTopLevelDeclarations.kt");
        }

        @TestMetadata("properties.kt")
        public void testProperties() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/properties.kt");
        }

        @TestMetadata("stdLibArrayListOf.kt")
        public void testStdLibArrayListOf() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/stdLibArrayListOf.kt");
        }

        @TestMetadata("stdLibArrayListOfNoSources.kt")
        public void testStdLibArrayListOfNoSources() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/stdLibArrayListOfNoSources.kt");
        }

        @TestMetadata("stdLibJoinToString.kt")
        public void testStdLibJoinToString() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/stdLibJoinToString.kt");
        }

        @TestMetadata("typealias.kt")
        public void testTypealias() throws Exception {
            runTest("idea/testData/navigation/gotoSymbol/typealias.kt");
        }
    }
}
