
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCompleter.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCompleter>
#include <QAbstractItemModel>
#include <QAbstractItemView>
#include <QChildEvent>
#include <QEvent>
#include <QModelIndex>
#include <QObject>
#include <QRect>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCompleter

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCompleter::staticMetaObject);
}


// Qt::CaseSensitivity QCompleter::caseSensitivity()


static void _init_f_caseSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ();
}

static void _call_f_caseSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ((qt_gsi::Converter<Qt::CaseSensitivity>::target_type)qt_gsi::CppToQtAdaptor<Qt::CaseSensitivity>(((QCompleter *)cls)->caseSensitivity ()));
}


// void QCompleter::complete(const QRect &rect)


static void _init_f_complete_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRect()");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_complete_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args ? gsi::arg_reader<const QRect & >() (args, heap) : gsi::arg_maker<const QRect & >() (QRect(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->complete (arg1);
}


// int QCompleter::completionColumn()


static void _init_f_completionColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_completionColumn_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCompleter *)cls)->completionColumn ());
}


// int QCompleter::completionCount()


static void _init_f_completionCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_completionCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCompleter *)cls)->completionCount ());
}


// QCompleter::CompletionMode QCompleter::completionMode()


static void _init_f_completionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCompleter::CompletionMode>::target_type > ();
}

static void _call_f_completionMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCompleter::CompletionMode>::target_type > ((qt_gsi::Converter<QCompleter::CompletionMode>::target_type)qt_gsi::CppToQtAdaptor<QCompleter::CompletionMode>(((QCompleter *)cls)->completionMode ()));
}


// QAbstractItemModel *QCompleter::completionModel()


static void _init_f_completionModel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_completionModel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QCompleter *)cls)->completionModel ());
}


// QString QCompleter::completionPrefix()


static void _init_f_completionPrefix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_completionPrefix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QCompleter *)cls)->completionPrefix ());
}


// int QCompleter::completionRole()


static void _init_f_completionRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_completionRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCompleter *)cls)->completionRole ());
}


// QString QCompleter::currentCompletion()


static void _init_f_currentCompletion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_currentCompletion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QCompleter *)cls)->currentCompletion ());
}


// QModelIndex QCompleter::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QModelIndex > ((QModelIndex)((QCompleter *)cls)->currentIndex ());
}


// int QCompleter::currentRow()


static void _init_f_currentRow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentRow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCompleter *)cls)->currentRow ());
}


// int QCompleter::maxVisibleItems()


static void _init_f_maxVisibleItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maxVisibleItems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCompleter *)cls)->maxVisibleItems ());
}


// QAbstractItemModel *QCompleter::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QCompleter *)cls)->model ());
}


// QCompleter::ModelSorting QCompleter::modelSorting()


static void _init_f_modelSorting_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCompleter::ModelSorting>::target_type > ();
}

static void _call_f_modelSorting_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCompleter::ModelSorting>::target_type > ((qt_gsi::Converter<QCompleter::ModelSorting>::target_type)qt_gsi::CppToQtAdaptor<QCompleter::ModelSorting>(((QCompleter *)cls)->modelSorting ()));
}


// QString QCompleter::pathFromIndex(const QModelIndex &index)


static void _init_f_pathFromIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_pathFromIndex_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QString > ((QString)((QCompleter *)cls)->pathFromIndex (arg1));
}


// QAbstractItemView *QCompleter::popup()


static void _init_f_popup_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemView * > ();
}

static void _call_f_popup_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemView * > ((QAbstractItemView *)((QCompleter *)cls)->popup ());
}


// void QCompleter::setCaseSensitivity(Qt::CaseSensitivity caseSensitivity)


static void _init_f_setCaseSensitivity_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("caseSensitivity");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaseSensitivity_2324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setCaseSensitivity (qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg1).cref());
}


// void QCompleter::setCompletionColumn(int column)


static void _init_f_setCompletionColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompletionColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setCompletionColumn (arg1);
}


// void QCompleter::setCompletionMode(QCompleter::CompletionMode mode)


static void _init_f_setCompletionMode_3011 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCompleter::CompletionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompletionMode_3011 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCompleter::CompletionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCompleter::CompletionMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setCompletionMode (qt_gsi::QtToCppAdaptor<QCompleter::CompletionMode>(arg1).cref());
}


// void QCompleter::setCompletionPrefix(const QString &prefix)


static void _init_f_setCompletionPrefix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompletionPrefix_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setCompletionPrefix (arg1);
}


// void QCompleter::setCompletionRole(int role)


static void _init_f_setCompletionRole_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompletionRole_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setCompletionRole (arg1);
}


// bool QCompleter::setCurrentRow(int row)


static void _init_f_setCurrentRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setCurrentRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QCompleter *)cls)->setCurrentRow (arg1));
}


// void QCompleter::setMaxVisibleItems(int maxItems)


static void _init_f_setMaxVisibleItems_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxItems");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaxVisibleItems_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setMaxVisibleItems (arg1);
}


// void QCompleter::setModel(QAbstractItemModel *c)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setModel (arg1);
}


// void QCompleter::setModelSorting(QCompleter::ModelSorting sorting)


static void _init_f_setModelSorting_2811 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sorting");
  decl->add_arg<const qt_gsi::Converter<QCompleter::ModelSorting>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModelSorting_2811 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCompleter::ModelSorting>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCompleter::ModelSorting>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setModelSorting (qt_gsi::QtToCppAdaptor<QCompleter::ModelSorting>(arg1).cref());
}


// void QCompleter::setPopup(QAbstractItemView *popup)


static void _init_f_setPopup_2333 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("popup");
  decl->add_arg<QAbstractItemView * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPopup_2333 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemView *arg1 = gsi::arg_reader<QAbstractItemView * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setPopup (arg1);
}


// void QCompleter::setWidget(QWidget *widget)


static void _init_f_setWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setWidget (arg1);
}


// void QCompleter::setWrapAround(bool wrap)


static void _init_f_setWrapAround_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("wrap");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWrapAround_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter *)cls)->setWrapAround (arg1);
}


// QStringList QCompleter::splitPath(const QString &path)


static void _init_f_splitPath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_splitPath_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStringList > ((QStringList)((QCompleter *)cls)->splitPath (arg1));
}


// QWidget *QCompleter::widget()


static void _init_f_widget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QCompleter *)cls)->widget ());
}


// bool QCompleter::wrapAround()


static void _init_f_wrapAround_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_wrapAround_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCompleter *)cls)->wrapAround ());
}


// static QString QCompleter::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QCompleter::tr (arg1, arg2));
}


// static QString QCompleter::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QCompleter::tr (arg1, arg2, arg3));
}


// static QString QCompleter::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QCompleter::trUtf8 (arg1, arg2));
}


// static QString QCompleter::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QCompleter::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCompleter () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":caseSensitivity", "@brief Method Qt::CaseSensitivity QCompleter::caseSensitivity()\n", true, &_init_f_caseSensitivity_c0, &_call_f_caseSensitivity_c0);
  methods += new qt_gsi::GenericMethod ("complete", "@brief Method void QCompleter::complete(const QRect &rect)\n", false, &_init_f_complete_1792, &_call_f_complete_1792);
  methods += new qt_gsi::GenericMethod (":completionColumn", "@brief Method int QCompleter::completionColumn()\n", true, &_init_f_completionColumn_c0, &_call_f_completionColumn_c0);
  methods += new qt_gsi::GenericMethod ("completionCount", "@brief Method int QCompleter::completionCount()\n", true, &_init_f_completionCount_c0, &_call_f_completionCount_c0);
  methods += new qt_gsi::GenericMethod (":completionMode", "@brief Method QCompleter::CompletionMode QCompleter::completionMode()\n", true, &_init_f_completionMode_c0, &_call_f_completionMode_c0);
  methods += new qt_gsi::GenericMethod ("completionModel", "@brief Method QAbstractItemModel *QCompleter::completionModel()\n", true, &_init_f_completionModel_c0, &_call_f_completionModel_c0);
  methods += new qt_gsi::GenericMethod (":completionPrefix", "@brief Method QString QCompleter::completionPrefix()\n", true, &_init_f_completionPrefix_c0, &_call_f_completionPrefix_c0);
  methods += new qt_gsi::GenericMethod (":completionRole", "@brief Method int QCompleter::completionRole()\n", true, &_init_f_completionRole_c0, &_call_f_completionRole_c0);
  methods += new qt_gsi::GenericMethod ("currentCompletion", "@brief Method QString QCompleter::currentCompletion()\n", true, &_init_f_currentCompletion_c0, &_call_f_currentCompletion_c0);
  methods += new qt_gsi::GenericMethod ("currentIndex", "@brief Method QModelIndex QCompleter::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
  methods += new qt_gsi::GenericMethod ("currentRow", "@brief Method int QCompleter::currentRow()\n", true, &_init_f_currentRow_c0, &_call_f_currentRow_c0);
  methods += new qt_gsi::GenericMethod (":maxVisibleItems", "@brief Method int QCompleter::maxVisibleItems()\n", true, &_init_f_maxVisibleItems_c0, &_call_f_maxVisibleItems_c0);
  methods += new qt_gsi::GenericMethod (":model", "@brief Method QAbstractItemModel *QCompleter::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
  methods += new qt_gsi::GenericMethod (":modelSorting", "@brief Method QCompleter::ModelSorting QCompleter::modelSorting()\n", true, &_init_f_modelSorting_c0, &_call_f_modelSorting_c0);
  methods += new qt_gsi::GenericMethod ("pathFromIndex", "@brief Method QString QCompleter::pathFromIndex(const QModelIndex &index)\n", true, &_init_f_pathFromIndex_c2395, &_call_f_pathFromIndex_c2395);
  methods += new qt_gsi::GenericMethod (":popup", "@brief Method QAbstractItemView *QCompleter::popup()\n", true, &_init_f_popup_c0, &_call_f_popup_c0);
  methods += new qt_gsi::GenericMethod ("setCaseSensitivity|caseSensitivity=", "@brief Method void QCompleter::setCaseSensitivity(Qt::CaseSensitivity caseSensitivity)\n", false, &_init_f_setCaseSensitivity_2324, &_call_f_setCaseSensitivity_2324);
  methods += new qt_gsi::GenericMethod ("setCompletionColumn|completionColumn=", "@brief Method void QCompleter::setCompletionColumn(int column)\n", false, &_init_f_setCompletionColumn_767, &_call_f_setCompletionColumn_767);
  methods += new qt_gsi::GenericMethod ("setCompletionMode|completionMode=", "@brief Method void QCompleter::setCompletionMode(QCompleter::CompletionMode mode)\n", false, &_init_f_setCompletionMode_3011, &_call_f_setCompletionMode_3011);
  methods += new qt_gsi::GenericMethod ("setCompletionPrefix|completionPrefix=", "@brief Method void QCompleter::setCompletionPrefix(const QString &prefix)\n", false, &_init_f_setCompletionPrefix_2025, &_call_f_setCompletionPrefix_2025);
  methods += new qt_gsi::GenericMethod ("setCompletionRole|completionRole=", "@brief Method void QCompleter::setCompletionRole(int role)\n", false, &_init_f_setCompletionRole_767, &_call_f_setCompletionRole_767);
  methods += new qt_gsi::GenericMethod ("setCurrentRow", "@brief Method bool QCompleter::setCurrentRow(int row)\n", false, &_init_f_setCurrentRow_767, &_call_f_setCurrentRow_767);
  methods += new qt_gsi::GenericMethod ("setMaxVisibleItems|maxVisibleItems=", "@brief Method void QCompleter::setMaxVisibleItems(int maxItems)\n", false, &_init_f_setMaxVisibleItems_767, &_call_f_setMaxVisibleItems_767);
  methods += new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QCompleter::setModel(QAbstractItemModel *c)\n", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
  methods += new qt_gsi::GenericMethod ("setModelSorting|modelSorting=", "@brief Method void QCompleter::setModelSorting(QCompleter::ModelSorting sorting)\n", false, &_init_f_setModelSorting_2811, &_call_f_setModelSorting_2811);
  methods += new qt_gsi::GenericMethod ("setPopup|popup=", "@brief Method void QCompleter::setPopup(QAbstractItemView *popup)\n", false, &_init_f_setPopup_2333, &_call_f_setPopup_2333);
  methods += new qt_gsi::GenericMethod ("setWidget|widget=", "@brief Method void QCompleter::setWidget(QWidget *widget)\n", false, &_init_f_setWidget_1315, &_call_f_setWidget_1315);
  methods += new qt_gsi::GenericMethod ("setWrapAround|wrapAround=", "@brief Method void QCompleter::setWrapAround(bool wrap)\n", false, &_init_f_setWrapAround_864, &_call_f_setWrapAround_864);
  methods += new qt_gsi::GenericMethod ("splitPath", "@brief Method QStringList QCompleter::splitPath(const QString &path)\n", true, &_init_f_splitPath_c2025, &_call_f_splitPath_c2025);
  methods += new qt_gsi::GenericMethod (":widget", "@brief Method QWidget *QCompleter::widget()\n", true, &_init_f_widget_c0, &_call_f_widget_c0);
  methods += new qt_gsi::GenericMethod (":wrapAround", "@brief Method bool QCompleter::wrapAround()\n", true, &_init_f_wrapAround_c0, &_call_f_wrapAround_c0);
  methods += gsi::qt_signal<const QString & > ("activated(const QString &)", "activated_qs", gsi::arg("text"), "@brief Signal declaration for QCompleter::activated(const QString &text)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("activated(const QModelIndex &)", "activated", gsi::arg("index"), "@brief Signal declaration for QCompleter::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCompleter::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("highlighted(const QString &)", "highlighted_qs", gsi::arg("text"), "@brief Signal declaration for QCompleter::highlighted(const QString &text)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("highlighted(const QModelIndex &)", "highlighted", gsi::arg("index"), "@brief Signal declaration for QCompleter::highlighted(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCompleter::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCompleter::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCompleter::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCompleter::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QCompleter> decl_QCompleter (qtdecl_QObject (), "QtGui", "QCompleter_Native",
  methods_QCompleter (),
  "@hide\n@alias QCompleter");

GSI_QTGUI_PUBLIC gsi::Class<QCompleter> &qtdecl_QCompleter () { return decl_QCompleter; }

}


class QCompleter_Adaptor : public QCompleter, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCompleter_Adaptor();

  //  [adaptor ctor] QCompleter::QCompleter(QObject *parent)
  QCompleter_Adaptor() : QCompleter()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCompleter::QCompleter(QObject *parent)
  QCompleter_Adaptor(QObject *parent) : QCompleter(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCompleter::QCompleter(QAbstractItemModel *model, QObject *parent)
  QCompleter_Adaptor(QAbstractItemModel *model) : QCompleter(model)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCompleter::QCompleter(QAbstractItemModel *model, QObject *parent)
  QCompleter_Adaptor(QAbstractItemModel *model, QObject *parent) : QCompleter(model, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCompleter::QCompleter(const QStringList &completions, QObject *parent)
  QCompleter_Adaptor(const QStringList &completions) : QCompleter(completions)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCompleter::QCompleter(const QStringList &completions, QObject *parent)
  QCompleter_Adaptor(const QStringList &completions, QObject *parent) : QCompleter(completions, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QCompleter::receivers(const char *signal)
  int fp_QCompleter_receivers_c1731 (const char *signal) const {
    return QCompleter::receivers(signal);
  }

  //  [expose] QObject *QCompleter::sender()
  QObject * fp_QCompleter_sender_c0 () const {
    return QCompleter::sender();
  }

  //  [adaptor impl] QString QCompleter::pathFromIndex(const QModelIndex &index)
  QString cbs_pathFromIndex_c2395_0(const QModelIndex &index) const
  {
    return QCompleter::pathFromIndex(index);
  }

  virtual QString pathFromIndex(const QModelIndex &index) const
  {
    if (cb_pathFromIndex_c2395_0.can_issue()) {
      return cb_pathFromIndex_c2395_0.issue<QCompleter_Adaptor, QString, const QModelIndex &>(&QCompleter_Adaptor::cbs_pathFromIndex_c2395_0, index);
    } else {
      return QCompleter::pathFromIndex(index);
    }
  }

  //  [adaptor impl] QStringList QCompleter::splitPath(const QString &path)
  QStringList cbs_splitPath_c2025_0(const QString &path) const
  {
    return QCompleter::splitPath(path);
  }

  virtual QStringList splitPath(const QString &path) const
  {
    if (cb_splitPath_c2025_0.can_issue()) {
      return cb_splitPath_c2025_0.issue<QCompleter_Adaptor, QStringList, const QString &>(&QCompleter_Adaptor::cbs_splitPath_c2025_0, path);
    } else {
      return QCompleter::splitPath(path);
    }
  }

  //  [emitter impl] void QCompleter::activated(const QString &text)
  void emitter_QCompleter_activated_2025(const QString &text)
  {
    emit QCompleter::activated(text);
  }

  //  [emitter impl] void QCompleter::activated(const QModelIndex &index)
  void emitter_QCompleter_activated_2395(const QModelIndex &index)
  {
    emit QCompleter::activated(index);
  }

  //  [adaptor impl] void QCompleter::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCompleter::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCompleter_Adaptor, QChildEvent *>(&QCompleter_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCompleter::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCompleter::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCompleter::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCompleter_Adaptor, QEvent *>(&QCompleter_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCompleter::customEvent(arg1);
    }
  }

  //  [emitter impl] void QCompleter::destroyed(QObject *)
  void emitter_QCompleter_destroyed_1302(QObject *arg1)
  {
    emit QCompleter::destroyed(arg1);
  }

  //  [adaptor impl] void QCompleter::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QCompleter::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QCompleter_Adaptor, const char *>(&QCompleter_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QCompleter::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QCompleter::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCompleter::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCompleter_Adaptor, bool, QEvent *>(&QCompleter_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCompleter::event(arg1);
    }
  }

  //  [adaptor impl] bool QCompleter::eventFilter(QObject *o, QEvent *e)
  bool cbs_eventFilter_2411_0(QObject *o, QEvent *e)
  {
    return QCompleter::eventFilter(o, e);
  }

  virtual bool eventFilter(QObject *o, QEvent *e)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCompleter_Adaptor, bool, QObject *, QEvent *>(&QCompleter_Adaptor::cbs_eventFilter_2411_0, o, e);
    } else {
      return QCompleter::eventFilter(o, e);
    }
  }

  //  [emitter impl] void QCompleter::highlighted(const QString &text)
  void emitter_QCompleter_highlighted_2025(const QString &text)
  {
    emit QCompleter::highlighted(text);
  }

  //  [emitter impl] void QCompleter::highlighted(const QModelIndex &index)
  void emitter_QCompleter_highlighted_2395(const QModelIndex &index)
  {
    emit QCompleter::highlighted(index);
  }

  //  [adaptor impl] void QCompleter::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCompleter::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCompleter_Adaptor, QTimerEvent *>(&QCompleter_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCompleter::timerEvent(arg1);
    }
  }

  gsi::Callback cb_pathFromIndex_c2395_0;
  gsi::Callback cb_splitPath_c2025_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCompleter_Adaptor::~QCompleter_Adaptor() { }

//  Constructor QCompleter::QCompleter(QObject *parent) (adaptor class)

static void _init_ctor_QCompleter_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QCompleter_Adaptor> ();
}

static void _call_ctor_QCompleter_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCompleter_Adaptor *> (new QCompleter_Adaptor (arg1));
}


//  Constructor QCompleter::QCompleter(QAbstractItemModel *model, QObject *parent) (adaptor class)

static void _init_ctor_QCompleter_Adaptor_3613 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCompleter_Adaptor> ();
}

static void _call_ctor_QCompleter_Adaptor_3613 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCompleter_Adaptor *> (new QCompleter_Adaptor (arg1, arg2));
}


//  Constructor QCompleter::QCompleter(const QStringList &completions, QObject *parent) (adaptor class)

static void _init_ctor_QCompleter_Adaptor_3631 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("completions");
  decl->add_arg<const QStringList & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCompleter_Adaptor> ();
}

static void _call_ctor_QCompleter_Adaptor_3631 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCompleter_Adaptor *> (new QCompleter_Adaptor (arg1, arg2));
}


// emitter void QCompleter::activated(const QString &text)

static void _init_emitter_activated_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activated_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCompleter_Adaptor *)cls)->emitter_QCompleter_activated_2025 (arg1);
}


// emitter void QCompleter::activated(const QModelIndex &index)

static void _init_emitter_activated_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activated_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QCompleter_Adaptor *)cls)->emitter_QCompleter_activated_2395 (arg1);
}


// void QCompleter::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCompleter::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCompleter::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QCompleter_Adaptor *)cls)->emitter_QCompleter_destroyed_1302 (arg1);
}


// void QCompleter::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QCompleter::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCompleter_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCompleter::eventFilter(QObject *o, QEvent *e)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("o");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("e");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCompleter_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QCompleter::highlighted(const QString &text)

static void _init_emitter_highlighted_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_highlighted_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCompleter_Adaptor *)cls)->emitter_QCompleter_highlighted_2025 (arg1);
}


// emitter void QCompleter::highlighted(const QModelIndex &index)

static void _init_emitter_highlighted_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_highlighted_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QCompleter_Adaptor *)cls)->emitter_QCompleter_highlighted_2395 (arg1);
}


// QString QCompleter::pathFromIndex(const QModelIndex &index)

static void _init_cbs_pathFromIndex_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_pathFromIndex_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QString > ((QString)((QCompleter_Adaptor *)cls)->cbs_pathFromIndex_c2395_0 (arg1));
}

static void _set_callback_cbs_pathFromIndex_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_pathFromIndex_c2395_0 = cb;
}


// exposed int QCompleter::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCompleter_Adaptor *)cls)->fp_QCompleter_receivers_c1731 (arg1));
}


// exposed QObject *QCompleter::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCompleter_Adaptor *)cls)->fp_QCompleter_sender_c0 ());
}


// QStringList QCompleter::splitPath(const QString &path)

static void _init_cbs_splitPath_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_cbs_splitPath_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QStringList > ((QStringList)((QCompleter_Adaptor *)cls)->cbs_splitPath_c2025_0 (arg1));
}

static void _set_callback_cbs_splitPath_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_splitPath_c2025_0 = cb;
}


// void QCompleter::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCompleter_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCompleter_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCompleter> &qtdecl_QCompleter ();

static gsi::Methods methods_QCompleter_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCompleter::QCompleter(QObject *parent)\nThis method creates an object of class QCompleter.", &_init_ctor_QCompleter_Adaptor_1302, &_call_ctor_QCompleter_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCompleter::QCompleter(QAbstractItemModel *model, QObject *parent)\nThis method creates an object of class QCompleter.", &_init_ctor_QCompleter_Adaptor_3613, &_call_ctor_QCompleter_Adaptor_3613);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCompleter::QCompleter(const QStringList &completions, QObject *parent)\nThis method creates an object of class QCompleter.", &_init_ctor_QCompleter_Adaptor_3631, &_call_ctor_QCompleter_Adaptor_3631);
  methods += new qt_gsi::GenericMethod ("emit_activated_qs", "@brief Emitter for signal void QCompleter::activated(const QString &text)\nCall this method to emit this signal.", false, &_init_emitter_activated_2025, &_call_emitter_activated_2025);
  methods += new qt_gsi::GenericMethod ("emit_activated", "@brief Emitter for signal void QCompleter::activated(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_activated_2395, &_call_emitter_activated_2395);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCompleter::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCompleter::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCompleter::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCompleter::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QCompleter::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QCompleter::eventFilter(QObject *o, QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_highlighted_qs", "@brief Emitter for signal void QCompleter::highlighted(const QString &text)\nCall this method to emit this signal.", false, &_init_emitter_highlighted_2025, &_call_emitter_highlighted_2025);
  methods += new qt_gsi::GenericMethod ("emit_highlighted", "@brief Emitter for signal void QCompleter::highlighted(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_highlighted_2395, &_call_emitter_highlighted_2395);
  methods += new qt_gsi::GenericMethod ("pathFromIndex", "@brief Virtual method QString QCompleter::pathFromIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pathFromIndex_c2395_0, &_call_cbs_pathFromIndex_c2395_0);
  methods += new qt_gsi::GenericMethod ("pathFromIndex", "@hide", true, &_init_cbs_pathFromIndex_c2395_0, &_call_cbs_pathFromIndex_c2395_0, &_set_callback_cbs_pathFromIndex_c2395_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCompleter::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCompleter::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("splitPath", "@brief Virtual method QStringList QCompleter::splitPath(const QString &path)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_splitPath_c2025_0, &_call_cbs_splitPath_c2025_0);
  methods += new qt_gsi::GenericMethod ("splitPath", "@hide", true, &_init_cbs_splitPath_c2025_0, &_call_cbs_splitPath_c2025_0, &_set_callback_cbs_splitPath_c2025_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCompleter::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCompleter_Adaptor> decl_QCompleter_Adaptor (qtdecl_QCompleter (), "QtGui", "QCompleter",
  methods_QCompleter_Adaptor (),
  "@qt\n@brief Binding of QCompleter");

}


//  Implementation of the enum wrapper class for QCompleter::CompletionMode
namespace qt_gsi
{

static gsi::Enum<QCompleter::CompletionMode> decl_QCompleter_CompletionMode_Enum ("QtGui", "QCompleter_CompletionMode",
    gsi::enum_const ("PopupCompletion", QCompleter::PopupCompletion, "@brief Enum constant QCompleter::PopupCompletion") +
    gsi::enum_const ("UnfilteredPopupCompletion", QCompleter::UnfilteredPopupCompletion, "@brief Enum constant QCompleter::UnfilteredPopupCompletion") +
    gsi::enum_const ("InlineCompletion", QCompleter::InlineCompletion, "@brief Enum constant QCompleter::InlineCompletion"),
  "@qt\n@brief This class represents the QCompleter::CompletionMode enum");

static gsi::QFlagsClass<QCompleter::CompletionMode > decl_QCompleter_CompletionMode_Enums ("QtGui", "QCompleter_QFlags_CompletionMode",
  "@qt\n@brief This class represents the QFlags<QCompleter::CompletionMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCompleter> inject_QCompleter_CompletionMode_Enum_in_parent (decl_QCompleter_CompletionMode_Enum.defs ());
static gsi::ClassExt<QCompleter> decl_QCompleter_CompletionMode_Enum_as_child (decl_QCompleter_CompletionMode_Enum, "CompletionMode");
static gsi::ClassExt<QCompleter> decl_QCompleter_CompletionMode_Enums_as_child (decl_QCompleter_CompletionMode_Enums, "QFlags_CompletionMode");

}


//  Implementation of the enum wrapper class for QCompleter::ModelSorting
namespace qt_gsi
{

static gsi::Enum<QCompleter::ModelSorting> decl_QCompleter_ModelSorting_Enum ("QtGui", "QCompleter_ModelSorting",
    gsi::enum_const ("UnsortedModel", QCompleter::UnsortedModel, "@brief Enum constant QCompleter::UnsortedModel") +
    gsi::enum_const ("CaseSensitivelySortedModel", QCompleter::CaseSensitivelySortedModel, "@brief Enum constant QCompleter::CaseSensitivelySortedModel") +
    gsi::enum_const ("CaseInsensitivelySortedModel", QCompleter::CaseInsensitivelySortedModel, "@brief Enum constant QCompleter::CaseInsensitivelySortedModel"),
  "@qt\n@brief This class represents the QCompleter::ModelSorting enum");

static gsi::QFlagsClass<QCompleter::ModelSorting > decl_QCompleter_ModelSorting_Enums ("QtGui", "QCompleter_QFlags_ModelSorting",
  "@qt\n@brief This class represents the QFlags<QCompleter::ModelSorting> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCompleter> inject_QCompleter_ModelSorting_Enum_in_parent (decl_QCompleter_ModelSorting_Enum.defs ());
static gsi::ClassExt<QCompleter> decl_QCompleter_ModelSorting_Enum_as_child (decl_QCompleter_ModelSorting_Enum, "ModelSorting");
static gsi::ClassExt<QCompleter> decl_QCompleter_ModelSorting_Enums_as_child (decl_QCompleter_ModelSorting_Enums, "QFlags_ModelSorting");

}

