# Gitaly RFCs

This directory contains all accepted Gitaly RFCs.

This document describes the rationale and process for Request For Comments (RFCs) in the Gitaly project.

## What is an RFC?

A Gitaly RFC is a document that communicates something related to Gitaly. Once approved, the RFC acts as a guideline for Gitaly contributors. In this way, it is like a Gitaly specific version of the [GitLab handbook](https://about.gitlab.com/handbook/).

## Why RFCs?

The motivation behind an RFC process is to address shortfalls in the typical GitLab workflow. GitLab embraces small iterations, boring solutions, and breadth of features. Gitaly is known to have complex and deep design goals (e.g. Praefect). These goals may traverse many merge requests, issues, epics and contributors.

In order to preserve architectural integrity, we sometimes require thought frameworks to keep everything and everyone aligned while contributing. The inverse is also true. We sometimes end up with knowledge spread out across GitLab that we wish to collate and digest into a more accessible form.

## When to use an RFC?

- Use an RFC when the idea you are communicating is difficult to capture with traditional methods.
- Use an RFC to vet a complex concept with your peers and reach consensus on an approach.
- Use an RFC to retroactively capture the thinking behind design decisions.

Note: this is not an exhaustive list. Be creative `:)`

## When NOT to use an RFC?

- Don't use an RFC when an different approach works better (e.g. issue or MR).
- An RFC is a heavier process that consumes more time. Use appropriately when long term thinking and extensive peer review is desired.

## Process

### Creating a new RFC

1. Start by duplicating the [RFC template](template.md) and replacing all required placeholders.
1. Name the file using an abbreviated form of the RFC title.
1. When ready for peer review, create a merge request using the `RFC` merge request template.
1. Follow the template steps.

### Updating an existing RFC

When updating an RFC, use discretion when deciding between using the normal merge request process, or using the more process heavy RFC process. The RFC process should be used for more substantial revisions of an RFC.
