// Code generated by smithy-go-codegen DO NOT EDIT.

package panorama

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/panorama/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of application instance dependencies.
func (c *Client) ListApplicationInstanceDependencies(ctx context.Context, params *ListApplicationInstanceDependenciesInput, optFns ...func(*Options)) (*ListApplicationInstanceDependenciesOutput, error) {
	if params == nil {
		params = &ListApplicationInstanceDependenciesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListApplicationInstanceDependencies", params, optFns, c.addOperationListApplicationInstanceDependenciesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListApplicationInstanceDependenciesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListApplicationInstanceDependenciesInput struct {

	// The application instance's ID.
	//
	// This member is required.
	ApplicationInstanceId *string

	// The maximum number of application instance dependencies to return in one page
	// of results.
	MaxResults int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListApplicationInstanceDependenciesOutput struct {

	// A pagination token that's included if more results are available.
	NextToken *string

	// A list of package objects.
	PackageObjects []types.PackageObject

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListApplicationInstanceDependenciesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListApplicationInstanceDependencies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListApplicationInstanceDependencies{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListApplicationInstanceDependencies"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListApplicationInstanceDependenciesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListApplicationInstanceDependencies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListApplicationInstanceDependenciesAPIClient is a client that implements the
// ListApplicationInstanceDependencies operation.
type ListApplicationInstanceDependenciesAPIClient interface {
	ListApplicationInstanceDependencies(context.Context, *ListApplicationInstanceDependenciesInput, ...func(*Options)) (*ListApplicationInstanceDependenciesOutput, error)
}

var _ ListApplicationInstanceDependenciesAPIClient = (*Client)(nil)

// ListApplicationInstanceDependenciesPaginatorOptions is the paginator options
// for ListApplicationInstanceDependencies
type ListApplicationInstanceDependenciesPaginatorOptions struct {
	// The maximum number of application instance dependencies to return in one page
	// of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListApplicationInstanceDependenciesPaginator is a paginator for
// ListApplicationInstanceDependencies
type ListApplicationInstanceDependenciesPaginator struct {
	options   ListApplicationInstanceDependenciesPaginatorOptions
	client    ListApplicationInstanceDependenciesAPIClient
	params    *ListApplicationInstanceDependenciesInput
	nextToken *string
	firstPage bool
}

// NewListApplicationInstanceDependenciesPaginator returns a new
// ListApplicationInstanceDependenciesPaginator
func NewListApplicationInstanceDependenciesPaginator(client ListApplicationInstanceDependenciesAPIClient, params *ListApplicationInstanceDependenciesInput, optFns ...func(*ListApplicationInstanceDependenciesPaginatorOptions)) *ListApplicationInstanceDependenciesPaginator {
	if params == nil {
		params = &ListApplicationInstanceDependenciesInput{}
	}

	options := ListApplicationInstanceDependenciesPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListApplicationInstanceDependenciesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListApplicationInstanceDependenciesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListApplicationInstanceDependencies page.
func (p *ListApplicationInstanceDependenciesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListApplicationInstanceDependenciesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListApplicationInstanceDependencies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListApplicationInstanceDependencies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListApplicationInstanceDependencies",
	}
}
