// Code generated by smithy-go-codegen DO NOT EDIT.

package iottwinmaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iottwinmaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API lists the properties of a component.
func (c *Client) ListProperties(ctx context.Context, params *ListPropertiesInput, optFns ...func(*Options)) (*ListPropertiesOutput, error) {
	if params == nil {
		params = &ListPropertiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProperties", params, optFns, c.addOperationListPropertiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPropertiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPropertiesInput struct {

	// The ID for the entity whose metadata (component/properties) is returned by the
	// operation.
	//
	// This member is required.
	EntityId *string

	// The workspace ID.
	//
	// This member is required.
	WorkspaceId *string

	// The name of the component whose properties are returned by the operation.
	ComponentName *string

	// This string specifies the path to the composite component, starting from the
	// top-level component.
	ComponentPath *string

	// The maximum number of results returned at one time. The default is 25.
	MaxResults *int32

	// The string that specifies the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPropertiesOutput struct {

	// A list of objects that contain information about the properties.
	//
	// This member is required.
	PropertySummaries []types.PropertySummary

	// The string that specifies the next page of property results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPropertiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListProperties{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListProperties{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListProperties"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListPropertiesMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListPropertiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProperties(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opListPropertiesMiddleware struct {
}

func (*endpointPrefix_opListPropertiesMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListPropertiesMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListPropertiesMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListPropertiesMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListPropertiesAPIClient is a client that implements the ListProperties
// operation.
type ListPropertiesAPIClient interface {
	ListProperties(context.Context, *ListPropertiesInput, ...func(*Options)) (*ListPropertiesOutput, error)
}

var _ ListPropertiesAPIClient = (*Client)(nil)

// ListPropertiesPaginatorOptions is the paginator options for ListProperties
type ListPropertiesPaginatorOptions struct {
	// The maximum number of results returned at one time. The default is 25.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPropertiesPaginator is a paginator for ListProperties
type ListPropertiesPaginator struct {
	options   ListPropertiesPaginatorOptions
	client    ListPropertiesAPIClient
	params    *ListPropertiesInput
	nextToken *string
	firstPage bool
}

// NewListPropertiesPaginator returns a new ListPropertiesPaginator
func NewListPropertiesPaginator(client ListPropertiesAPIClient, params *ListPropertiesInput, optFns ...func(*ListPropertiesPaginatorOptions)) *ListPropertiesPaginator {
	if params == nil {
		params = &ListPropertiesInput{}
	}

	options := ListPropertiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPropertiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPropertiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListProperties page.
func (p *ListPropertiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPropertiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListProperties(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListProperties(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListProperties",
	}
}
