// Code generated by smithy-go-codegen DO NOT EDIT.

package internetmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/internetmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information that Amazon CloudWatch Internet Monitor has generated about an
// internet event. Internet Monitor displays information about recent global health
// events, called internet events, on a global outages map that is available to all
// Amazon Web Services customers.
//
// The information returned here includes the impacted location, when the event
// started and (if the event is over) ended, the type of event ( PERFORMANCE or
// AVAILABILITY ), and the status ( ACTIVE or RESOLVED ).
func (c *Client) GetInternetEvent(ctx context.Context, params *GetInternetEventInput, optFns ...func(*Options)) (*GetInternetEventOutput, error) {
	if params == nil {
		params = &GetInternetEventInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetInternetEvent", params, optFns, c.addOperationGetInternetEventMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetInternetEventOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetInternetEventInput struct {

	// The EventId of the internet event to return information for.
	//
	// This member is required.
	EventId *string

	noSmithyDocumentSerde
}

type GetInternetEventOutput struct {

	// The impacted location, such as a city, where clients access Amazon Web Services
	// application resources.
	//
	// This member is required.
	ClientLocation *types.ClientLocation

	// The Amazon Resource Name (ARN) of the internet event.
	//
	// This member is required.
	EventArn *string

	// The internally-generated identifier of an internet event.
	//
	// This member is required.
	EventId *string

	// The status of the internet event.
	//
	// This member is required.
	EventStatus types.InternetEventStatus

	// The type of network impairment.
	//
	// This member is required.
	EventType types.InternetEventType

	// The time when the internet event started.
	//
	// This member is required.
	StartedAt *time.Time

	// The time when the internet event ended. If the event hasn't ended yet, this
	// value is empty.
	EndedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetInternetEventMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetInternetEvent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetInternetEvent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetInternetEvent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetInternetEventValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetInternetEvent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetInternetEvent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetInternetEvent",
	}
}
