//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SQLVulnerabilityAssessmentScansClient contains the methods for the SQLVulnerabilityAssessmentScans group.
// Don't use this type directly, use NewSQLVulnerabilityAssessmentScansClient() instead.
type SQLVulnerabilityAssessmentScansClient struct {
	host string
	pl   runtime.Pipeline
}

// NewSQLVulnerabilityAssessmentScansClient creates a new instance of SQLVulnerabilityAssessmentScansClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewSQLVulnerabilityAssessmentScansClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SQLVulnerabilityAssessmentScansClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &SQLVulnerabilityAssessmentScansClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Get - Gets the scan details of a single scan record.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// scanID - The scan Id. Type 'latest' to get the scan record for the latest scan.
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the SQLVulnerabilityAssessmentScansClient.Get
// method.
func (client *SQLVulnerabilityAssessmentScansClient) Get(ctx context.Context, scanID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientGetOptions) (SQLVulnerabilityAssessmentScansClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, scanID, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *SQLVulnerabilityAssessmentScansClient) getCreateRequest(ctx context.Context, scanID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}"
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SQLVulnerabilityAssessmentScansClient) getHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentScansClientGetResponse, error) {
	result := SQLVulnerabilityAssessmentScansClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Scan); err != nil {
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	return result, nil
}

// List - Gets a list of scan records.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentScansClientListOptions contains the optional parameters for the SQLVulnerabilityAssessmentScansClient.List
// method.
func (client *SQLVulnerabilityAssessmentScansClient) List(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientListOptions) (SQLVulnerabilityAssessmentScansClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentScansClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *SQLVulnerabilityAssessmentScansClient) listCreateRequest(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SQLVulnerabilityAssessmentScansClient) listHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentScansClientListResponse, error) {
	result := SQLVulnerabilityAssessmentScansClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Scans); err != nil {
		return SQLVulnerabilityAssessmentScansClientListResponse{}, err
	}
	return result, nil
}
