//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatashare

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ShareSubscriptionsClient contains the methods for the ShareSubscriptions group.
// Don't use this type directly, use NewShareSubscriptionsClient() instead.
type ShareSubscriptionsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewShareSubscriptionsClient creates a new instance of ShareSubscriptionsClient with the specified values.
// subscriptionID - The subscription identifier
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewShareSubscriptionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ShareSubscriptionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ShareSubscriptionsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCancelSynchronization - Request to cancel a synchronization.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of the shareSubscription.
// shareSubscriptionSynchronization - Share Subscription Synchronization payload.
// options - ShareSubscriptionsClientBeginCancelSynchronizationOptions contains the optional parameters for the ShareSubscriptionsClient.BeginCancelSynchronization
// method.
func (client *ShareSubscriptionsClient) BeginCancelSynchronization(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, options *ShareSubscriptionsClientBeginCancelSynchronizationOptions) (*runtime.Poller[ShareSubscriptionsClientCancelSynchronizationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.cancelSynchronization(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscriptionSynchronization, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[ShareSubscriptionsClientCancelSynchronizationResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[ShareSubscriptionsClientCancelSynchronizationResponse](options.ResumeToken, client.pl, nil)
	}
}

// CancelSynchronization - Request to cancel a synchronization.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
func (client *ShareSubscriptionsClient) cancelSynchronization(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, options *ShareSubscriptionsClientBeginCancelSynchronizationOptions) (*http.Response, error) {
	req, err := client.cancelSynchronizationCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscriptionSynchronization, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// cancelSynchronizationCreateRequest creates the CancelSynchronization request.
func (client *ShareSubscriptionsClient) cancelSynchronizationCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, options *ShareSubscriptionsClientBeginCancelSynchronizationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/cancelSynchronization"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, shareSubscriptionSynchronization)
}

// Create - Create a shareSubscription in an account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of the shareSubscription.
// shareSubscription - create parameters for shareSubscription
// options - ShareSubscriptionsClientCreateOptions contains the optional parameters for the ShareSubscriptionsClient.Create
// method.
func (client *ShareSubscriptionsClient) Create(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscription ShareSubscription, options *ShareSubscriptionsClientCreateOptions) (ShareSubscriptionsClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscription, options)
	if err != nil {
		return ShareSubscriptionsClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ShareSubscriptionsClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ShareSubscriptionsClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *ShareSubscriptionsClient) createCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscription ShareSubscription, options *ShareSubscriptionsClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, shareSubscription)
}

// createHandleResponse handles the Create response.
func (client *ShareSubscriptionsClient) createHandleResponse(resp *http.Response) (ShareSubscriptionsClientCreateResponse, error) {
	result := ShareSubscriptionsClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ShareSubscription); err != nil {
		return ShareSubscriptionsClientCreateResponse{}, err
	}
	return result, nil
}

// BeginDelete - Delete a shareSubscription in an account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of the shareSubscription.
// options - ShareSubscriptionsClientBeginDeleteOptions contains the optional parameters for the ShareSubscriptionsClient.BeginDelete
// method.
func (client *ShareSubscriptionsClient) BeginDelete(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientBeginDeleteOptions) (*runtime.Poller[ShareSubscriptionsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, accountName, shareSubscriptionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ShareSubscriptionsClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ShareSubscriptionsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Delete a shareSubscription in an account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
func (client *ShareSubscriptionsClient) deleteOperation(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ShareSubscriptionsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a shareSubscription in an account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of the shareSubscription.
// options - ShareSubscriptionsClientGetOptions contains the optional parameters for the ShareSubscriptionsClient.Get method.
func (client *ShareSubscriptionsClient) Get(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientGetOptions) (ShareSubscriptionsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, options)
	if err != nil {
		return ShareSubscriptionsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ShareSubscriptionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ShareSubscriptionsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ShareSubscriptionsClient) getCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ShareSubscriptionsClient) getHandleResponse(resp *http.Response) (ShareSubscriptionsClientGetResponse, error) {
	result := ShareSubscriptionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ShareSubscription); err != nil {
		return ShareSubscriptionsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByAccountPager - List share subscriptions in an account
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// options - ShareSubscriptionsClientListByAccountOptions contains the optional parameters for the ShareSubscriptionsClient.ListByAccount
// method.
func (client *ShareSubscriptionsClient) NewListByAccountPager(resourceGroupName string, accountName string, options *ShareSubscriptionsClientListByAccountOptions) *runtime.Pager[ShareSubscriptionsClientListByAccountResponse] {
	return runtime.NewPager(runtime.PagingHandler[ShareSubscriptionsClientListByAccountResponse]{
		More: func(page ShareSubscriptionsClientListByAccountResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ShareSubscriptionsClientListByAccountResponse) (ShareSubscriptionsClientListByAccountResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByAccountCreateRequest(ctx, resourceGroupName, accountName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ShareSubscriptionsClientListByAccountResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ShareSubscriptionsClientListByAccountResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ShareSubscriptionsClientListByAccountResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByAccountHandleResponse(resp)
		},
	})
}

// listByAccountCreateRequest creates the ListByAccount request.
func (client *ShareSubscriptionsClient) listByAccountCreateRequest(ctx context.Context, resourceGroupName string, accountName string, options *ShareSubscriptionsClientListByAccountOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Orderby != nil {
		reqQP.Set("$orderby", *options.Orderby)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByAccountHandleResponse handles the ListByAccount response.
func (client *ShareSubscriptionsClient) listByAccountHandleResponse(resp *http.Response) (ShareSubscriptionsClientListByAccountResponse, error) {
	result := ShareSubscriptionsClientListByAccountResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ShareSubscriptionList); err != nil {
		return ShareSubscriptionsClientListByAccountResponse{}, err
	}
	return result, nil
}

// NewListSourceShareSynchronizationSettingsPager - Get synchronization settings set on a share
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of the shareSubscription.
// options - ShareSubscriptionsClientListSourceShareSynchronizationSettingsOptions contains the optional parameters for the
// ShareSubscriptionsClient.ListSourceShareSynchronizationSettings method.
func (client *ShareSubscriptionsClient) NewListSourceShareSynchronizationSettingsPager(resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientListSourceShareSynchronizationSettingsOptions) *runtime.Pager[ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse]{
		More: func(page ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse) (ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSourceShareSynchronizationSettingsCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSourceShareSynchronizationSettingsHandleResponse(resp)
		},
	})
}

// listSourceShareSynchronizationSettingsCreateRequest creates the ListSourceShareSynchronizationSettings request.
func (client *ShareSubscriptionsClient) listSourceShareSynchronizationSettingsCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientListSourceShareSynchronizationSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSourceShareSynchronizationSettings"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSourceShareSynchronizationSettingsHandleResponse handles the ListSourceShareSynchronizationSettings response.
func (client *ShareSubscriptionsClient) listSourceShareSynchronizationSettingsHandleResponse(resp *http.Response) (ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse, error) {
	result := ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SourceShareSynchronizationSettingList); err != nil {
		return ShareSubscriptionsClientListSourceShareSynchronizationSettingsResponse{}, err
	}
	return result, nil
}

// NewListSynchronizationDetailsPager - List synchronization details
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of the share subscription.
// shareSubscriptionSynchronization - Share Subscription Synchronization payload.
// options - ShareSubscriptionsClientListSynchronizationDetailsOptions contains the optional parameters for the ShareSubscriptionsClient.ListSynchronizationDetails
// method.
func (client *ShareSubscriptionsClient) NewListSynchronizationDetailsPager(resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, options *ShareSubscriptionsClientListSynchronizationDetailsOptions) *runtime.Pager[ShareSubscriptionsClientListSynchronizationDetailsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ShareSubscriptionsClientListSynchronizationDetailsResponse]{
		More: func(page ShareSubscriptionsClientListSynchronizationDetailsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ShareSubscriptionsClientListSynchronizationDetailsResponse) (ShareSubscriptionsClientListSynchronizationDetailsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSynchronizationDetailsCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscriptionSynchronization, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ShareSubscriptionsClientListSynchronizationDetailsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ShareSubscriptionsClientListSynchronizationDetailsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ShareSubscriptionsClientListSynchronizationDetailsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSynchronizationDetailsHandleResponse(resp)
		},
	})
}

// listSynchronizationDetailsCreateRequest creates the ListSynchronizationDetails request.
func (client *ShareSubscriptionsClient) listSynchronizationDetailsCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, options *ShareSubscriptionsClientListSynchronizationDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizationDetails"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Orderby != nil {
		reqQP.Set("$orderby", *options.Orderby)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, shareSubscriptionSynchronization)
}

// listSynchronizationDetailsHandleResponse handles the ListSynchronizationDetails response.
func (client *ShareSubscriptionsClient) listSynchronizationDetailsHandleResponse(resp *http.Response) (ShareSubscriptionsClientListSynchronizationDetailsResponse, error) {
	result := ShareSubscriptionsClientListSynchronizationDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SynchronizationDetailsList); err != nil {
		return ShareSubscriptionsClientListSynchronizationDetailsResponse{}, err
	}
	return result, nil
}

// NewListSynchronizationsPager - List synchronizations of a share subscription
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of the share subscription.
// options - ShareSubscriptionsClientListSynchronizationsOptions contains the optional parameters for the ShareSubscriptionsClient.ListSynchronizations
// method.
func (client *ShareSubscriptionsClient) NewListSynchronizationsPager(resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientListSynchronizationsOptions) *runtime.Pager[ShareSubscriptionsClientListSynchronizationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ShareSubscriptionsClientListSynchronizationsResponse]{
		More: func(page ShareSubscriptionsClientListSynchronizationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ShareSubscriptionsClientListSynchronizationsResponse) (ShareSubscriptionsClientListSynchronizationsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSynchronizationsCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ShareSubscriptionsClientListSynchronizationsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ShareSubscriptionsClientListSynchronizationsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ShareSubscriptionsClientListSynchronizationsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSynchronizationsHandleResponse(resp)
		},
	})
}

// listSynchronizationsCreateRequest creates the ListSynchronizations request.
func (client *ShareSubscriptionsClient) listSynchronizationsCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, options *ShareSubscriptionsClientListSynchronizationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Orderby != nil {
		reqQP.Set("$orderby", *options.Orderby)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSynchronizationsHandleResponse handles the ListSynchronizations response.
func (client *ShareSubscriptionsClient) listSynchronizationsHandleResponse(resp *http.Response) (ShareSubscriptionsClientListSynchronizationsResponse, error) {
	result := ShareSubscriptionsClientListSynchronizationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ShareSubscriptionSynchronizationList); err != nil {
		return ShareSubscriptionsClientListSynchronizationsResponse{}, err
	}
	return result, nil
}

// BeginSynchronize - Initiate a copy
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
// resourceGroupName - The resource group name.
// accountName - The name of the share account.
// shareSubscriptionName - The name of share subscription
// synchronize - Synchronize payload
// options - ShareSubscriptionsClientBeginSynchronizeOptions contains the optional parameters for the ShareSubscriptionsClient.BeginSynchronize
// method.
func (client *ShareSubscriptionsClient) BeginSynchronize(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, synchronize Synchronize, options *ShareSubscriptionsClientBeginSynchronizeOptions) (*runtime.Poller[ShareSubscriptionsClientSynchronizeResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.synchronize(ctx, resourceGroupName, accountName, shareSubscriptionName, synchronize, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[ShareSubscriptionsClientSynchronizeResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[ShareSubscriptionsClientSynchronizeResponse](options.ResumeToken, client.pl, nil)
	}
}

// Synchronize - Initiate a copy
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-09-01
func (client *ShareSubscriptionsClient) synchronize(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, synchronize Synchronize, options *ShareSubscriptionsClientBeginSynchronizeOptions) (*http.Response, error) {
	req, err := client.synchronizeCreateRequest(ctx, resourceGroupName, accountName, shareSubscriptionName, synchronize, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// synchronizeCreateRequest creates the Synchronize request.
func (client *ShareSubscriptionsClient) synchronizeCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, synchronize Synchronize, options *ShareSubscriptionsClientBeginSynchronizeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/synchronize"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareSubscriptionName == "" {
		return nil, errors.New("parameter shareSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareSubscriptionName}", url.PathEscape(shareSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, synchronize)
}
