//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// WebAppsClient contains the methods for the WebApps group.
// Don't use this type directly, use NewWebAppsClient() instead.
type WebAppsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewWebAppsClient creates a new instance of WebAppsClient with the specified values.
// subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewWebAppsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*WebAppsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &WebAppsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// AddPremierAddOn - Description for Updates a named add-on of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// premierAddOnName - Add-on name.
// premierAddOn - A JSON representation of the edited premier add-on.
// options - WebAppsClientAddPremierAddOnOptions contains the optional parameters for the WebAppsClient.AddPremierAddOn method.
func (client *WebAppsClient) AddPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, options *WebAppsClientAddPremierAddOnOptions) (WebAppsClientAddPremierAddOnResponse, error) {
	req, err := client.addPremierAddOnCreateRequest(ctx, resourceGroupName, name, premierAddOnName, premierAddOn, options)
	if err != nil {
		return WebAppsClientAddPremierAddOnResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientAddPremierAddOnResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientAddPremierAddOnResponse{}, runtime.NewResponseError(resp)
	}
	return client.addPremierAddOnHandleResponse(resp)
}

// addPremierAddOnCreateRequest creates the AddPremierAddOn request.
func (client *WebAppsClient) addPremierAddOnCreateRequest(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, options *WebAppsClientAddPremierAddOnOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if premierAddOnName == "" {
		return nil, errors.New("parameter premierAddOnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{premierAddOnName}", url.PathEscape(premierAddOnName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, premierAddOn)
}

// addPremierAddOnHandleResponse handles the AddPremierAddOn response.
func (client *WebAppsClient) addPremierAddOnHandleResponse(resp *http.Response) (WebAppsClientAddPremierAddOnResponse, error) {
	result := WebAppsClientAddPremierAddOnResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PremierAddOn); err != nil {
		return WebAppsClientAddPremierAddOnResponse{}, err
	}
	return result, nil
}

// AddPremierAddOnSlot - Description for Updates a named add-on of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// premierAddOnName - Add-on name.
// slot - Name of the deployment slot. If a slot is not specified, the API will update the named add-on for the production
// slot.
// premierAddOn - A JSON representation of the edited premier add-on.
// options - WebAppsClientAddPremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.AddPremierAddOnSlot
// method.
func (client *WebAppsClient) AddPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, premierAddOn PremierAddOn, options *WebAppsClientAddPremierAddOnSlotOptions) (WebAppsClientAddPremierAddOnSlotResponse, error) {
	req, err := client.addPremierAddOnSlotCreateRequest(ctx, resourceGroupName, name, premierAddOnName, slot, premierAddOn, options)
	if err != nil {
		return WebAppsClientAddPremierAddOnSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientAddPremierAddOnSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientAddPremierAddOnSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.addPremierAddOnSlotHandleResponse(resp)
}

// addPremierAddOnSlotCreateRequest creates the AddPremierAddOnSlot request.
func (client *WebAppsClient) addPremierAddOnSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, premierAddOn PremierAddOn, options *WebAppsClientAddPremierAddOnSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if premierAddOnName == "" {
		return nil, errors.New("parameter premierAddOnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{premierAddOnName}", url.PathEscape(premierAddOnName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, premierAddOn)
}

// addPremierAddOnSlotHandleResponse handles the AddPremierAddOnSlot response.
func (client *WebAppsClient) addPremierAddOnSlotHandleResponse(resp *http.Response) (WebAppsClientAddPremierAddOnSlotResponse, error) {
	result := WebAppsClientAddPremierAddOnSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PremierAddOn); err != nil {
		return WebAppsClientAddPremierAddOnSlotResponse{}, err
	}
	return result, nil
}

// AnalyzeCustomHostname - Description for Analyze a custom hostname.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientAnalyzeCustomHostnameOptions contains the optional parameters for the WebAppsClient.AnalyzeCustomHostname
// method.
func (client *WebAppsClient) AnalyzeCustomHostname(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientAnalyzeCustomHostnameOptions) (WebAppsClientAnalyzeCustomHostnameResponse, error) {
	req, err := client.analyzeCustomHostnameCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientAnalyzeCustomHostnameResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientAnalyzeCustomHostnameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientAnalyzeCustomHostnameResponse{}, runtime.NewResponseError(resp)
	}
	return client.analyzeCustomHostnameHandleResponse(resp)
}

// analyzeCustomHostnameCreateRequest creates the AnalyzeCustomHostname request.
func (client *WebAppsClient) analyzeCustomHostnameCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientAnalyzeCustomHostnameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.HostName != nil {
		reqQP.Set("hostName", *options.HostName)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// analyzeCustomHostnameHandleResponse handles the AnalyzeCustomHostname response.
func (client *WebAppsClient) analyzeCustomHostnameHandleResponse(resp *http.Response) (WebAppsClientAnalyzeCustomHostnameResponse, error) {
	result := WebAppsClientAnalyzeCustomHostnameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CustomHostnameAnalysisResult); err != nil {
		return WebAppsClientAnalyzeCustomHostnameResponse{}, err
	}
	return result, nil
}

// AnalyzeCustomHostnameSlot - Description for Analyze a custom hostname.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientAnalyzeCustomHostnameSlotOptions contains the optional parameters for the WebAppsClient.AnalyzeCustomHostnameSlot
// method.
func (client *WebAppsClient) AnalyzeCustomHostnameSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientAnalyzeCustomHostnameSlotOptions) (WebAppsClientAnalyzeCustomHostnameSlotResponse, error) {
	req, err := client.analyzeCustomHostnameSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientAnalyzeCustomHostnameSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientAnalyzeCustomHostnameSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientAnalyzeCustomHostnameSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.analyzeCustomHostnameSlotHandleResponse(resp)
}

// analyzeCustomHostnameSlotCreateRequest creates the AnalyzeCustomHostnameSlot request.
func (client *WebAppsClient) analyzeCustomHostnameSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientAnalyzeCustomHostnameSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.HostName != nil {
		reqQP.Set("hostName", *options.HostName)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// analyzeCustomHostnameSlotHandleResponse handles the AnalyzeCustomHostnameSlot response.
func (client *WebAppsClient) analyzeCustomHostnameSlotHandleResponse(resp *http.Response) (WebAppsClientAnalyzeCustomHostnameSlotResponse, error) {
	result := WebAppsClientAnalyzeCustomHostnameSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CustomHostnameAnalysisResult); err != nil {
		return WebAppsClientAnalyzeCustomHostnameSlotResponse{}, err
	}
	return result, nil
}

// ApplySlotConfigToProduction - Description for Applies the configuration settings from the target slot onto the current
// slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slotSwapEntity - JSON object that contains the target slot name. See example.
// options - WebAppsClientApplySlotConfigToProductionOptions contains the optional parameters for the WebAppsClient.ApplySlotConfigToProduction
// method.
func (client *WebAppsClient) ApplySlotConfigToProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, options *WebAppsClientApplySlotConfigToProductionOptions) (WebAppsClientApplySlotConfigToProductionResponse, error) {
	req, err := client.applySlotConfigToProductionCreateRequest(ctx, resourceGroupName, name, slotSwapEntity, options)
	if err != nil {
		return WebAppsClientApplySlotConfigToProductionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientApplySlotConfigToProductionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientApplySlotConfigToProductionResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientApplySlotConfigToProductionResponse{}, nil
}

// applySlotConfigToProductionCreateRequest creates the ApplySlotConfigToProduction request.
func (client *WebAppsClient) applySlotConfigToProductionCreateRequest(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, options *WebAppsClientApplySlotConfigToProductionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, slotSwapEntity)
}

// ApplySlotConfigurationSlot - Description for Applies the configuration settings from the target slot onto the current slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the source slot. If a slot is not specified, the production slot is used as the source slot.
// slotSwapEntity - JSON object that contains the target slot name. See example.
// options - WebAppsClientApplySlotConfigurationSlotOptions contains the optional parameters for the WebAppsClient.ApplySlotConfigurationSlot
// method.
func (client *WebAppsClient) ApplySlotConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string, slotSwapEntity CsmSlotEntity, options *WebAppsClientApplySlotConfigurationSlotOptions) (WebAppsClientApplySlotConfigurationSlotResponse, error) {
	req, err := client.applySlotConfigurationSlotCreateRequest(ctx, resourceGroupName, name, slot, slotSwapEntity, options)
	if err != nil {
		return WebAppsClientApplySlotConfigurationSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientApplySlotConfigurationSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientApplySlotConfigurationSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientApplySlotConfigurationSlotResponse{}, nil
}

// applySlotConfigurationSlotCreateRequest creates the ApplySlotConfigurationSlot request.
func (client *WebAppsClient) applySlotConfigurationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, slotSwapEntity CsmSlotEntity, options *WebAppsClientApplySlotConfigurationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, slotSwapEntity)
}

// BeginApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// options - WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionOptions contains the optional parameters for the WebAppsClient.BeginApproveOrRejectPrivateEndpointConnection
// method.
func (client *WebAppsClient) BeginApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*runtime.Poller[WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.approveOrRejectPrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse](options.ResumeToken, client.pl, nil)
	}
}

// ApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) approveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*http.Response, error) {
	req, err := client.approveOrRejectPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// approveOrRejectPrivateEndpointConnectionCreateRequest creates the ApproveOrRejectPrivateEndpointConnection request.
func (client *WebAppsClient) approveOrRejectPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, privateEndpointWrapper)
}

// BeginApproveOrRejectPrivateEndpointConnectionSlot - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// options - WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionSlotOptions contains the optional parameters for the
// WebAppsClient.BeginApproveOrRejectPrivateEndpointConnectionSlot method.
func (client *WebAppsClient) BeginApproveOrRejectPrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionSlotOptions) (*runtime.Poller[WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.approveOrRejectPrivateEndpointConnectionSlot(ctx, resourceGroupName, name, privateEndpointConnectionName, slot, privateEndpointWrapper, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// ApproveOrRejectPrivateEndpointConnectionSlot - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) approveOrRejectPrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionSlotOptions) (*http.Response, error) {
	req, err := client.approveOrRejectPrivateEndpointConnectionSlotCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, slot, privateEndpointWrapper, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// approveOrRejectPrivateEndpointConnectionSlotCreateRequest creates the ApproveOrRejectPrivateEndpointConnectionSlot request.
func (client *WebAppsClient) approveOrRejectPrivateEndpointConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, privateEndpointWrapper)
}

// Backup - Description for Creates a backup of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// request - Backup configuration. You can use the JSON response from the POST action as input here.
// options - WebAppsClientBackupOptions contains the optional parameters for the WebAppsClient.Backup method.
func (client *WebAppsClient) Backup(ctx context.Context, resourceGroupName string, name string, request BackupRequest, options *WebAppsClientBackupOptions) (WebAppsClientBackupResponse, error) {
	req, err := client.backupCreateRequest(ctx, resourceGroupName, name, request, options)
	if err != nil {
		return WebAppsClientBackupResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientBackupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientBackupResponse{}, runtime.NewResponseError(resp)
	}
	return client.backupHandleResponse(resp)
}

// backupCreateRequest creates the Backup request.
func (client *WebAppsClient) backupCreateRequest(ctx context.Context, resourceGroupName string, name string, request BackupRequest, options *WebAppsClientBackupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, request)
}

// backupHandleResponse handles the Backup response.
func (client *WebAppsClient) backupHandleResponse(resp *http.Response) (WebAppsClientBackupResponse, error) {
	result := WebAppsClientBackupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItem); err != nil {
		return WebAppsClientBackupResponse{}, err
	}
	return result, nil
}

// BackupSlot - Description for Creates a backup of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will create a backup for the production slot.
// request - Backup configuration. You can use the JSON response from the POST action as input here.
// options - WebAppsClientBackupSlotOptions contains the optional parameters for the WebAppsClient.BackupSlot method.
func (client *WebAppsClient) BackupSlot(ctx context.Context, resourceGroupName string, name string, slot string, request BackupRequest, options *WebAppsClientBackupSlotOptions) (WebAppsClientBackupSlotResponse, error) {
	req, err := client.backupSlotCreateRequest(ctx, resourceGroupName, name, slot, request, options)
	if err != nil {
		return WebAppsClientBackupSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientBackupSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientBackupSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.backupSlotHandleResponse(resp)
}

// backupSlotCreateRequest creates the BackupSlot request.
func (client *WebAppsClient) backupSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, request BackupRequest, options *WebAppsClientBackupSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, request)
}

// backupSlotHandleResponse handles the BackupSlot response.
func (client *WebAppsClient) backupSlotHandleResponse(resp *http.Response) (WebAppsClientBackupSlotResponse, error) {
	result := WebAppsClientBackupSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItem); err != nil {
		return WebAppsClientBackupSlotResponse{}, err
	}
	return result, nil
}

// CreateDeployment - Description for Create a deployment for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - ID of an existing deployment.
// deployment - Deployment details.
// options - WebAppsClientCreateDeploymentOptions contains the optional parameters for the WebAppsClient.CreateDeployment
// method.
func (client *WebAppsClient) CreateDeployment(ctx context.Context, resourceGroupName string, name string, id string, deployment Deployment, options *WebAppsClientCreateDeploymentOptions) (WebAppsClientCreateDeploymentResponse, error) {
	req, err := client.createDeploymentCreateRequest(ctx, resourceGroupName, name, id, deployment, options)
	if err != nil {
		return WebAppsClientCreateDeploymentResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateDeploymentResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateDeploymentResponse{}, runtime.NewResponseError(resp)
	}
	return client.createDeploymentHandleResponse(resp)
}

// createDeploymentCreateRequest creates the CreateDeployment request.
func (client *WebAppsClient) createDeploymentCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, deployment Deployment, options *WebAppsClientCreateDeploymentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, deployment)
}

// createDeploymentHandleResponse handles the CreateDeployment response.
func (client *WebAppsClient) createDeploymentHandleResponse(resp *http.Response) (WebAppsClientCreateDeploymentResponse, error) {
	result := WebAppsClientCreateDeploymentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Deployment); err != nil {
		return WebAppsClientCreateDeploymentResponse{}, err
	}
	return result, nil
}

// CreateDeploymentSlot - Description for Create a deployment for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - ID of an existing deployment.
// slot - Name of the deployment slot. If a slot is not specified, the API creates a deployment for the production slot.
// deployment - Deployment details.
// options - WebAppsClientCreateDeploymentSlotOptions contains the optional parameters for the WebAppsClient.CreateDeploymentSlot
// method.
func (client *WebAppsClient) CreateDeploymentSlot(ctx context.Context, resourceGroupName string, name string, id string, slot string, deployment Deployment, options *WebAppsClientCreateDeploymentSlotOptions) (WebAppsClientCreateDeploymentSlotResponse, error) {
	req, err := client.createDeploymentSlotCreateRequest(ctx, resourceGroupName, name, id, slot, deployment, options)
	if err != nil {
		return WebAppsClientCreateDeploymentSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateDeploymentSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateDeploymentSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createDeploymentSlotHandleResponse(resp)
}

// createDeploymentSlotCreateRequest creates the CreateDeploymentSlot request.
func (client *WebAppsClient) createDeploymentSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, slot string, deployment Deployment, options *WebAppsClientCreateDeploymentSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, deployment)
}

// createDeploymentSlotHandleResponse handles the CreateDeploymentSlot response.
func (client *WebAppsClient) createDeploymentSlotHandleResponse(resp *http.Response) (WebAppsClientCreateDeploymentSlotResponse, error) {
	result := WebAppsClientCreateDeploymentSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Deployment); err != nil {
		return WebAppsClientCreateDeploymentSlotResponse{}, err
	}
	return result, nil
}

// BeginCreateFunction - Description for Create function for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// functionEnvelope - Function details.
// options - WebAppsClientBeginCreateFunctionOptions contains the optional parameters for the WebAppsClient.BeginCreateFunction
// method.
func (client *WebAppsClient) BeginCreateFunction(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope FunctionEnvelope, options *WebAppsClientBeginCreateFunctionOptions) (*runtime.Poller[WebAppsClientCreateFunctionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createFunction(ctx, resourceGroupName, name, functionName, functionEnvelope, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateFunctionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateFunctionResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateFunction - Description for Create function for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createFunction(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope FunctionEnvelope, options *WebAppsClientBeginCreateFunctionOptions) (*http.Response, error) {
	req, err := client.createFunctionCreateRequest(ctx, resourceGroupName, name, functionName, functionEnvelope, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createFunctionCreateRequest creates the CreateFunction request.
func (client *WebAppsClient) createFunctionCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope FunctionEnvelope, options *WebAppsClientBeginCreateFunctionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, functionEnvelope)
}

// BeginCreateInstanceFunctionSlot - Description for Create function for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// slot - Name of the deployment slot.
// functionEnvelope - Function details.
// options - WebAppsClientBeginCreateInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceFunctionSlot
// method.
func (client *WebAppsClient) BeginCreateInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope FunctionEnvelope, options *WebAppsClientBeginCreateInstanceFunctionSlotOptions) (*runtime.Poller[WebAppsClientCreateInstanceFunctionSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createInstanceFunctionSlot(ctx, resourceGroupName, name, functionName, slot, functionEnvelope, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateInstanceFunctionSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateInstanceFunctionSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateInstanceFunctionSlot - Description for Create function for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope FunctionEnvelope, options *WebAppsClientBeginCreateInstanceFunctionSlotOptions) (*http.Response, error) {
	req, err := client.createInstanceFunctionSlotCreateRequest(ctx, resourceGroupName, name, functionName, slot, functionEnvelope, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createInstanceFunctionSlotCreateRequest creates the CreateInstanceFunctionSlot request.
func (client *WebAppsClient) createInstanceFunctionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope FunctionEnvelope, options *WebAppsClientBeginCreateInstanceFunctionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, functionEnvelope)
}

// BeginCreateInstanceMSDeployOperation - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// instanceID - ID of web app instance.
// msDeploy - Details of MSDeploy operation
// options - WebAppsClientBeginCreateInstanceMSDeployOperationOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceMSDeployOperation
// method.
func (client *WebAppsClient) BeginCreateInstanceMSDeployOperation(ctx context.Context, resourceGroupName string, name string, instanceID string, msDeploy MSDeploy, options *WebAppsClientBeginCreateInstanceMSDeployOperationOptions) (*runtime.Poller[WebAppsClientCreateInstanceMSDeployOperationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createInstanceMSDeployOperation(ctx, resourceGroupName, name, instanceID, msDeploy, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateInstanceMSDeployOperationResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateInstanceMSDeployOperationResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateInstanceMSDeployOperation - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createInstanceMSDeployOperation(ctx context.Context, resourceGroupName string, name string, instanceID string, msDeploy MSDeploy, options *WebAppsClientBeginCreateInstanceMSDeployOperationOptions) (*http.Response, error) {
	req, err := client.createInstanceMSDeployOperationCreateRequest(ctx, resourceGroupName, name, instanceID, msDeploy, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createInstanceMSDeployOperationCreateRequest creates the CreateInstanceMSDeployOperation request.
func (client *WebAppsClient) createInstanceMSDeployOperationCreateRequest(ctx context.Context, resourceGroupName string, name string, instanceID string, msDeploy MSDeploy, options *WebAppsClientBeginCreateInstanceMSDeployOperationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, msDeploy)
}

// BeginCreateInstanceMSDeployOperationSlot - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// instanceID - ID of web app instance.
// msDeploy - Details of MSDeploy operation
// options - WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceMSDeployOperationSlot
// method.
func (client *WebAppsClient) BeginCreateInstanceMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, msDeploy MSDeploy, options *WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions) (*runtime.Poller[WebAppsClientCreateInstanceMSDeployOperationSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createInstanceMSDeployOperationSlot(ctx, resourceGroupName, name, slot, instanceID, msDeploy, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateInstanceMSDeployOperationSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateInstanceMSDeployOperationSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateInstanceMSDeployOperationSlot - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createInstanceMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, msDeploy MSDeploy, options *WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions) (*http.Response, error) {
	req, err := client.createInstanceMSDeployOperationSlotCreateRequest(ctx, resourceGroupName, name, slot, instanceID, msDeploy, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createInstanceMSDeployOperationSlotCreateRequest creates the CreateInstanceMSDeployOperationSlot request.
func (client *WebAppsClient) createInstanceMSDeployOperationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, msDeploy MSDeploy, options *WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, msDeploy)
}

// BeginCreateMSDeployOperation - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// msDeploy - Details of MSDeploy operation
// options - WebAppsClientBeginCreateMSDeployOperationOptions contains the optional parameters for the WebAppsClient.BeginCreateMSDeployOperation
// method.
func (client *WebAppsClient) BeginCreateMSDeployOperation(ctx context.Context, resourceGroupName string, name string, msDeploy MSDeploy, options *WebAppsClientBeginCreateMSDeployOperationOptions) (*runtime.Poller[WebAppsClientCreateMSDeployOperationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createMSDeployOperation(ctx, resourceGroupName, name, msDeploy, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateMSDeployOperationResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateMSDeployOperationResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateMSDeployOperation - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createMSDeployOperation(ctx context.Context, resourceGroupName string, name string, msDeploy MSDeploy, options *WebAppsClientBeginCreateMSDeployOperationOptions) (*http.Response, error) {
	req, err := client.createMSDeployOperationCreateRequest(ctx, resourceGroupName, name, msDeploy, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createMSDeployOperationCreateRequest creates the CreateMSDeployOperation request.
func (client *WebAppsClient) createMSDeployOperationCreateRequest(ctx context.Context, resourceGroupName string, name string, msDeploy MSDeploy, options *WebAppsClientBeginCreateMSDeployOperationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, msDeploy)
}

// BeginCreateMSDeployOperationSlot - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// msDeploy - Details of MSDeploy operation
// options - WebAppsClientBeginCreateMSDeployOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateMSDeployOperationSlot
// method.
func (client *WebAppsClient) BeginCreateMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, msDeploy MSDeploy, options *WebAppsClientBeginCreateMSDeployOperationSlotOptions) (*runtime.Poller[WebAppsClientCreateMSDeployOperationSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createMSDeployOperationSlot(ctx, resourceGroupName, name, slot, msDeploy, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateMSDeployOperationSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateMSDeployOperationSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateMSDeployOperationSlot - Description for Invoke the MSDeploy web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, msDeploy MSDeploy, options *WebAppsClientBeginCreateMSDeployOperationSlotOptions) (*http.Response, error) {
	req, err := client.createMSDeployOperationSlotCreateRequest(ctx, resourceGroupName, name, slot, msDeploy, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createMSDeployOperationSlotCreateRequest creates the CreateMSDeployOperationSlot request.
func (client *WebAppsClient) createMSDeployOperationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, msDeploy MSDeploy, options *WebAppsClientBeginCreateMSDeployOperationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, msDeploy)
}

// CreateOneDeployOperation - Description for Invoke the OneDeploy publish web app extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientCreateOneDeployOperationOptions contains the optional parameters for the WebAppsClient.CreateOneDeployOperation
// method.
func (client *WebAppsClient) CreateOneDeployOperation(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientCreateOneDeployOperationOptions) (WebAppsClientCreateOneDeployOperationResponse, error) {
	req, err := client.createOneDeployOperationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientCreateOneDeployOperationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOneDeployOperationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOneDeployOperationResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOneDeployOperationHandleResponse(resp)
}

// createOneDeployOperationCreateRequest creates the CreateOneDeployOperation request.
func (client *WebAppsClient) createOneDeployOperationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientCreateOneDeployOperationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/onedeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// createOneDeployOperationHandleResponse handles the CreateOneDeployOperation response.
func (client *WebAppsClient) createOneDeployOperationHandleResponse(resp *http.Response) (WebAppsClientCreateOneDeployOperationResponse, error) {
	result := WebAppsClientCreateOneDeployOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Interface); err != nil {
		return WebAppsClientCreateOneDeployOperationResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Description for Creates a new web, mobile, or API app in an existing resource group, or updates an
// existing app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
// siteEnvelope - A JSON representation of the app properties. See example.
// options - WebAppsClientBeginCreateOrUpdateOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdate
// method.
func (client *WebAppsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, options *WebAppsClientBeginCreateOrUpdateOptions) (*runtime.Poller[WebAppsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, name, siteEnvelope, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing
// app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createOrUpdate(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, options *WebAppsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, name, siteEnvelope, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *WebAppsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, options *WebAppsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, siteEnvelope)
}

// CreateOrUpdateConfiguration - Description for Updates the configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// siteConfig - JSON representation of a SiteConfig object. See example.
// options - WebAppsClientCreateOrUpdateConfigurationOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateConfiguration
// method.
func (client *WebAppsClient) CreateOrUpdateConfiguration(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfigResource, options *WebAppsClientCreateOrUpdateConfigurationOptions) (WebAppsClientCreateOrUpdateConfigurationResponse, error) {
	req, err := client.createOrUpdateConfigurationCreateRequest(ctx, resourceGroupName, name, siteConfig, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateConfigurationHandleResponse(resp)
}

// createOrUpdateConfigurationCreateRequest creates the CreateOrUpdateConfiguration request.
func (client *WebAppsClient) createOrUpdateConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfigResource, options *WebAppsClientCreateOrUpdateConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, siteConfig)
}

// createOrUpdateConfigurationHandleResponse handles the CreateOrUpdateConfiguration response.
func (client *WebAppsClient) createOrUpdateConfigurationHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateConfigurationResponse, error) {
	result := WebAppsClientCreateOrUpdateConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResource); err != nil {
		return WebAppsClientCreateOrUpdateConfigurationResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateConfigurationSlot - Description for Updates the configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will update configuration for the production slot.
// siteConfig - JSON representation of a SiteConfig object. See example.
// options - WebAppsClientCreateOrUpdateConfigurationSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateConfigurationSlot
// method.
func (client *WebAppsClient) CreateOrUpdateConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string, siteConfig SiteConfigResource, options *WebAppsClientCreateOrUpdateConfigurationSlotOptions) (WebAppsClientCreateOrUpdateConfigurationSlotResponse, error) {
	req, err := client.createOrUpdateConfigurationSlotCreateRequest(ctx, resourceGroupName, name, slot, siteConfig, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateConfigurationSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateConfigurationSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateConfigurationSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateConfigurationSlotHandleResponse(resp)
}

// createOrUpdateConfigurationSlotCreateRequest creates the CreateOrUpdateConfigurationSlot request.
func (client *WebAppsClient) createOrUpdateConfigurationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, siteConfig SiteConfigResource, options *WebAppsClientCreateOrUpdateConfigurationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, siteConfig)
}

// createOrUpdateConfigurationSlotHandleResponse handles the CreateOrUpdateConfigurationSlot response.
func (client *WebAppsClient) createOrUpdateConfigurationSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateConfigurationSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateConfigurationSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResource); err != nil {
		return WebAppsClientCreateOrUpdateConfigurationSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateDomainOwnershipIdentifier - Description for Creates a domain ownership identifier for web app, or updates
// an existing ownership identifier.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// domainOwnershipIdentifierName - Name of domain ownership identifier.
// domainOwnershipIdentifier - A JSON representation of the domain ownership properties.
// options - WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateDomainOwnershipIdentifier
// method.
func (client *WebAppsClient) CreateOrUpdateDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, options *WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions) (WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse, error) {
	req, err := client.createOrUpdateDomainOwnershipIdentifierCreateRequest(ctx, resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateDomainOwnershipIdentifierHandleResponse(resp)
}

// createOrUpdateDomainOwnershipIdentifierCreateRequest creates the CreateOrUpdateDomainOwnershipIdentifier request.
func (client *WebAppsClient) createOrUpdateDomainOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, options *WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainOwnershipIdentifierName == "" {
		return nil, errors.New("parameter domainOwnershipIdentifierName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainOwnershipIdentifierName}", url.PathEscape(domainOwnershipIdentifierName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, domainOwnershipIdentifier)
}

// createOrUpdateDomainOwnershipIdentifierHandleResponse handles the CreateOrUpdateDomainOwnershipIdentifier response.
func (client *WebAppsClient) createOrUpdateDomainOwnershipIdentifierHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse, error) {
	result := WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Identifier); err != nil {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateDomainOwnershipIdentifierSlot - Description for Creates a domain ownership identifier for web app, or updates
// an existing ownership identifier.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// domainOwnershipIdentifierName - Name of domain ownership identifier.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// domainOwnershipIdentifier - A JSON representation of the domain ownership properties.
// options - WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateDomainOwnershipIdentifierSlot
// method.
func (client *WebAppsClient) CreateOrUpdateDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, domainOwnershipIdentifier Identifier, options *WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions) (WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse, error) {
	req, err := client.createOrUpdateDomainOwnershipIdentifierSlotCreateRequest(ctx, resourceGroupName, name, domainOwnershipIdentifierName, slot, domainOwnershipIdentifier, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateDomainOwnershipIdentifierSlotHandleResponse(resp)
}

// createOrUpdateDomainOwnershipIdentifierSlotCreateRequest creates the CreateOrUpdateDomainOwnershipIdentifierSlot request.
func (client *WebAppsClient) createOrUpdateDomainOwnershipIdentifierSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, domainOwnershipIdentifier Identifier, options *WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainOwnershipIdentifierName == "" {
		return nil, errors.New("parameter domainOwnershipIdentifierName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainOwnershipIdentifierName}", url.PathEscape(domainOwnershipIdentifierName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, domainOwnershipIdentifier)
}

// createOrUpdateDomainOwnershipIdentifierSlotHandleResponse handles the CreateOrUpdateDomainOwnershipIdentifierSlot response.
func (client *WebAppsClient) createOrUpdateDomainOwnershipIdentifierSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Identifier); err != nil {
		return WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateFunctionSecret - Description for Add or update a function secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - The name of the function.
// keyName - The name of the key.
// key - The key to create or update
// options - WebAppsClientCreateOrUpdateFunctionSecretOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateFunctionSecret
// method.
func (client *WebAppsClient) CreateOrUpdateFunctionSecret(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, key KeyInfo, options *WebAppsClientCreateOrUpdateFunctionSecretOptions) (WebAppsClientCreateOrUpdateFunctionSecretResponse, error) {
	req, err := client.createOrUpdateFunctionSecretCreateRequest(ctx, resourceGroupName, name, functionName, keyName, key, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateFunctionSecretResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateFunctionSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return WebAppsClientCreateOrUpdateFunctionSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateFunctionSecretHandleResponse(resp)
}

// createOrUpdateFunctionSecretCreateRequest creates the CreateOrUpdateFunctionSecret request.
func (client *WebAppsClient) createOrUpdateFunctionSecretCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, key KeyInfo, options *WebAppsClientCreateOrUpdateFunctionSecretOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, key)
}

// createOrUpdateFunctionSecretHandleResponse handles the CreateOrUpdateFunctionSecret response.
func (client *WebAppsClient) createOrUpdateFunctionSecretHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateFunctionSecretResponse, error) {
	result := WebAppsClientCreateOrUpdateFunctionSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyInfo); err != nil {
		return WebAppsClientCreateOrUpdateFunctionSecretResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateFunctionSecretSlot - Description for Add or update a function secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - The name of the function.
// keyName - The name of the key.
// slot - Name of the deployment slot.
// key - The key to create or update
// options - WebAppsClientCreateOrUpdateFunctionSecretSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateFunctionSecretSlot
// method.
func (client *WebAppsClient) CreateOrUpdateFunctionSecretSlot(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, key KeyInfo, options *WebAppsClientCreateOrUpdateFunctionSecretSlotOptions) (WebAppsClientCreateOrUpdateFunctionSecretSlotResponse, error) {
	req, err := client.createOrUpdateFunctionSecretSlotCreateRequest(ctx, resourceGroupName, name, functionName, keyName, slot, key, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateFunctionSecretSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateFunctionSecretSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return WebAppsClientCreateOrUpdateFunctionSecretSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateFunctionSecretSlotHandleResponse(resp)
}

// createOrUpdateFunctionSecretSlotCreateRequest creates the CreateOrUpdateFunctionSecretSlot request.
func (client *WebAppsClient) createOrUpdateFunctionSecretSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, key KeyInfo, options *WebAppsClientCreateOrUpdateFunctionSecretSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/keys/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, key)
}

// createOrUpdateFunctionSecretSlotHandleResponse handles the CreateOrUpdateFunctionSecretSlot response.
func (client *WebAppsClient) createOrUpdateFunctionSecretSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateFunctionSecretSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateFunctionSecretSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyInfo); err != nil {
		return WebAppsClientCreateOrUpdateFunctionSecretSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateHostNameBinding - Description for Creates a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// hostName - Hostname in the hostname binding.
// hostNameBinding - Binding details. This is the JSON representation of a HostNameBinding object.
// options - WebAppsClientCreateOrUpdateHostNameBindingOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostNameBinding
// method.
func (client *WebAppsClient) CreateOrUpdateHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, options *WebAppsClientCreateOrUpdateHostNameBindingOptions) (WebAppsClientCreateOrUpdateHostNameBindingResponse, error) {
	req, err := client.createOrUpdateHostNameBindingCreateRequest(ctx, resourceGroupName, name, hostName, hostNameBinding, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostNameBindingResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostNameBindingResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateHostNameBindingResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHostNameBindingHandleResponse(resp)
}

// createOrUpdateHostNameBindingCreateRequest creates the CreateOrUpdateHostNameBinding request.
func (client *WebAppsClient) createOrUpdateHostNameBindingCreateRequest(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, options *WebAppsClientCreateOrUpdateHostNameBindingOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if hostName == "" {
		return nil, errors.New("parameter hostName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostName}", url.PathEscape(hostName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, hostNameBinding)
}

// createOrUpdateHostNameBindingHandleResponse handles the CreateOrUpdateHostNameBinding response.
func (client *WebAppsClient) createOrUpdateHostNameBindingHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateHostNameBindingResponse, error) {
	result := WebAppsClientCreateOrUpdateHostNameBindingResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostNameBinding); err != nil {
		return WebAppsClientCreateOrUpdateHostNameBindingResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateHostNameBindingSlot - Description for Creates a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// hostName - Hostname in the hostname binding.
// slot - Name of the deployment slot. If a slot is not specified, the API will create a binding for the production slot.
// hostNameBinding - Binding details. This is the JSON representation of a HostNameBinding object.
// options - WebAppsClientCreateOrUpdateHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostNameBindingSlot
// method.
func (client *WebAppsClient) CreateOrUpdateHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, hostName string, slot string, hostNameBinding HostNameBinding, options *WebAppsClientCreateOrUpdateHostNameBindingSlotOptions) (WebAppsClientCreateOrUpdateHostNameBindingSlotResponse, error) {
	req, err := client.createOrUpdateHostNameBindingSlotCreateRequest(ctx, resourceGroupName, name, hostName, slot, hostNameBinding, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostNameBindingSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostNameBindingSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateHostNameBindingSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHostNameBindingSlotHandleResponse(resp)
}

// createOrUpdateHostNameBindingSlotCreateRequest creates the CreateOrUpdateHostNameBindingSlot request.
func (client *WebAppsClient) createOrUpdateHostNameBindingSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, hostName string, slot string, hostNameBinding HostNameBinding, options *WebAppsClientCreateOrUpdateHostNameBindingSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if hostName == "" {
		return nil, errors.New("parameter hostName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostName}", url.PathEscape(hostName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, hostNameBinding)
}

// createOrUpdateHostNameBindingSlotHandleResponse handles the CreateOrUpdateHostNameBindingSlot response.
func (client *WebAppsClient) createOrUpdateHostNameBindingSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateHostNameBindingSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateHostNameBindingSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostNameBinding); err != nil {
		return WebAppsClientCreateOrUpdateHostNameBindingSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateHostSecret - Description for Add or update a host level secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// keyType - The type of host key.
// keyName - The name of the key.
// key - The key to create or update
// options - WebAppsClientCreateOrUpdateHostSecretOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostSecret
// method.
func (client *WebAppsClient) CreateOrUpdateHostSecret(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, key KeyInfo, options *WebAppsClientCreateOrUpdateHostSecretOptions) (WebAppsClientCreateOrUpdateHostSecretResponse, error) {
	req, err := client.createOrUpdateHostSecretCreateRequest(ctx, resourceGroupName, name, keyType, keyName, key, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostSecretResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return WebAppsClientCreateOrUpdateHostSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHostSecretHandleResponse(resp)
}

// createOrUpdateHostSecretCreateRequest creates the CreateOrUpdateHostSecret request.
func (client *WebAppsClient) createOrUpdateHostSecretCreateRequest(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, key KeyInfo, options *WebAppsClientCreateOrUpdateHostSecretOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if keyType == "" {
		return nil, errors.New("parameter keyType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyType}", url.PathEscape(keyType))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, key)
}

// createOrUpdateHostSecretHandleResponse handles the CreateOrUpdateHostSecret response.
func (client *WebAppsClient) createOrUpdateHostSecretHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateHostSecretResponse, error) {
	result := WebAppsClientCreateOrUpdateHostSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyInfo); err != nil {
		return WebAppsClientCreateOrUpdateHostSecretResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateHostSecretSlot - Description for Add or update a host level secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// keyType - The type of host key.
// keyName - The name of the key.
// slot - Name of the deployment slot.
// key - The key to create or update
// options - WebAppsClientCreateOrUpdateHostSecretSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostSecretSlot
// method.
func (client *WebAppsClient) CreateOrUpdateHostSecretSlot(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, key KeyInfo, options *WebAppsClientCreateOrUpdateHostSecretSlotOptions) (WebAppsClientCreateOrUpdateHostSecretSlotResponse, error) {
	req, err := client.createOrUpdateHostSecretSlotCreateRequest(ctx, resourceGroupName, name, keyType, keyName, slot, key, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostSecretSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateHostSecretSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return WebAppsClientCreateOrUpdateHostSecretSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHostSecretSlotHandleResponse(resp)
}

// createOrUpdateHostSecretSlotCreateRequest creates the CreateOrUpdateHostSecretSlot request.
func (client *WebAppsClient) createOrUpdateHostSecretSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, key KeyInfo, options *WebAppsClientCreateOrUpdateHostSecretSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/{keyType}/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if keyType == "" {
		return nil, errors.New("parameter keyType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyType}", url.PathEscape(keyType))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, key)
}

// createOrUpdateHostSecretSlotHandleResponse handles the CreateOrUpdateHostSecretSlot response.
func (client *WebAppsClient) createOrUpdateHostSecretSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateHostSecretSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateHostSecretSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyInfo); err != nil {
		return WebAppsClientCreateOrUpdateHostSecretSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateHybridConnection - Description for Creates a new Hybrid Connection using a Service Bus relay.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// namespaceName - The namespace for this hybrid connection.
// relayName - The relay name for this hybrid connection.
// connectionEnvelope - The details of the hybrid connection.
// options - WebAppsClientCreateOrUpdateHybridConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHybridConnection
// method.
func (client *WebAppsClient) CreateOrUpdateHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, options *WebAppsClientCreateOrUpdateHybridConnectionOptions) (WebAppsClientCreateOrUpdateHybridConnectionResponse, error) {
	req, err := client.createOrUpdateHybridConnectionCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateHybridConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateHybridConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateHybridConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHybridConnectionHandleResponse(resp)
}

// createOrUpdateHybridConnectionCreateRequest creates the CreateOrUpdateHybridConnection request.
func (client *WebAppsClient) createOrUpdateHybridConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, options *WebAppsClientCreateOrUpdateHybridConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateHybridConnectionHandleResponse handles the CreateOrUpdateHybridConnection response.
func (client *WebAppsClient) createOrUpdateHybridConnectionHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateHybridConnectionResponse, error) {
	result := WebAppsClientCreateOrUpdateHybridConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnection); err != nil {
		return WebAppsClientCreateOrUpdateHybridConnectionResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateHybridConnectionSlot - Description for Creates a new Hybrid Connection using a Service Bus relay.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// namespaceName - The namespace for this hybrid connection.
// relayName - The relay name for this hybrid connection.
// slot - The name of the slot for the web app.
// connectionEnvelope - The details of the hybrid connection.
// options - WebAppsClientCreateOrUpdateHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHybridConnectionSlot
// method.
func (client *WebAppsClient) CreateOrUpdateHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, connectionEnvelope HybridConnection, options *WebAppsClientCreateOrUpdateHybridConnectionSlotOptions) (WebAppsClientCreateOrUpdateHybridConnectionSlotResponse, error) {
	req, err := client.createOrUpdateHybridConnectionSlotCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, slot, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateHybridConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateHybridConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateHybridConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHybridConnectionSlotHandleResponse(resp)
}

// createOrUpdateHybridConnectionSlotCreateRequest creates the CreateOrUpdateHybridConnectionSlot request.
func (client *WebAppsClient) createOrUpdateHybridConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, connectionEnvelope HybridConnection, options *WebAppsClientCreateOrUpdateHybridConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateHybridConnectionSlotHandleResponse handles the CreateOrUpdateHybridConnectionSlot response.
func (client *WebAppsClient) createOrUpdateHybridConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateHybridConnectionSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateHybridConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnection); err != nil {
		return WebAppsClientCreateOrUpdateHybridConnectionSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdatePublicCertificate - Description for Creates a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// publicCertificateName - Public certificate name.
// publicCertificate - Public certificate details. This is the JSON representation of a PublicCertificate object.
// options - WebAppsClientCreateOrUpdatePublicCertificateOptions contains the optional parameters for the WebAppsClient.CreateOrUpdatePublicCertificate
// method.
func (client *WebAppsClient) CreateOrUpdatePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate, options *WebAppsClientCreateOrUpdatePublicCertificateOptions) (WebAppsClientCreateOrUpdatePublicCertificateResponse, error) {
	req, err := client.createOrUpdatePublicCertificateCreateRequest(ctx, resourceGroupName, name, publicCertificateName, publicCertificate, options)
	if err != nil {
		return WebAppsClientCreateOrUpdatePublicCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdatePublicCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdatePublicCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdatePublicCertificateHandleResponse(resp)
}

// createOrUpdatePublicCertificateCreateRequest creates the CreateOrUpdatePublicCertificate request.
func (client *WebAppsClient) createOrUpdatePublicCertificateCreateRequest(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate, options *WebAppsClientCreateOrUpdatePublicCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if publicCertificateName == "" {
		return nil, errors.New("parameter publicCertificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publicCertificateName}", url.PathEscape(publicCertificateName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, publicCertificate)
}

// createOrUpdatePublicCertificateHandleResponse handles the CreateOrUpdatePublicCertificate response.
func (client *WebAppsClient) createOrUpdatePublicCertificateHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdatePublicCertificateResponse, error) {
	result := WebAppsClientCreateOrUpdatePublicCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublicCertificate); err != nil {
		return WebAppsClientCreateOrUpdatePublicCertificateResponse{}, err
	}
	return result, nil
}

// CreateOrUpdatePublicCertificateSlot - Description for Creates a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// publicCertificateName - Public certificate name.
// slot - Name of the deployment slot. If a slot is not specified, the API will create a binding for the production slot.
// publicCertificate - Public certificate details. This is the JSON representation of a PublicCertificate object.
// options - WebAppsClientCreateOrUpdatePublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdatePublicCertificateSlot
// method.
func (client *WebAppsClient) CreateOrUpdatePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, slot string, publicCertificate PublicCertificate, options *WebAppsClientCreateOrUpdatePublicCertificateSlotOptions) (WebAppsClientCreateOrUpdatePublicCertificateSlotResponse, error) {
	req, err := client.createOrUpdatePublicCertificateSlotCreateRequest(ctx, resourceGroupName, name, publicCertificateName, slot, publicCertificate, options)
	if err != nil {
		return WebAppsClientCreateOrUpdatePublicCertificateSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdatePublicCertificateSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdatePublicCertificateSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdatePublicCertificateSlotHandleResponse(resp)
}

// createOrUpdatePublicCertificateSlotCreateRequest creates the CreateOrUpdatePublicCertificateSlot request.
func (client *WebAppsClient) createOrUpdatePublicCertificateSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, slot string, publicCertificate PublicCertificate, options *WebAppsClientCreateOrUpdatePublicCertificateSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if publicCertificateName == "" {
		return nil, errors.New("parameter publicCertificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publicCertificateName}", url.PathEscape(publicCertificateName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, publicCertificate)
}

// createOrUpdatePublicCertificateSlotHandleResponse handles the CreateOrUpdatePublicCertificateSlot response.
func (client *WebAppsClient) createOrUpdatePublicCertificateSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdatePublicCertificateSlotResponse, error) {
	result := WebAppsClientCreateOrUpdatePublicCertificateSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublicCertificate); err != nil {
		return WebAppsClientCreateOrUpdatePublicCertificateSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateRelayServiceConnection - Description for Creates a new hybrid connection configuration (PUT), or updates
// an existing one (PATCH).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// entityName - Name of the hybrid connection configuration.
// connectionEnvelope - Details of the hybrid connection configuration.
// options - WebAppsClientCreateOrUpdateRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateRelayServiceConnection
// method.
func (client *WebAppsClient) CreateOrUpdateRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, options *WebAppsClientCreateOrUpdateRelayServiceConnectionOptions) (WebAppsClientCreateOrUpdateRelayServiceConnectionResponse, error) {
	req, err := client.createOrUpdateRelayServiceConnectionCreateRequest(ctx, resourceGroupName, name, entityName, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateRelayServiceConnectionHandleResponse(resp)
}

// createOrUpdateRelayServiceConnectionCreateRequest creates the CreateOrUpdateRelayServiceConnection request.
func (client *WebAppsClient) createOrUpdateRelayServiceConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, options *WebAppsClientCreateOrUpdateRelayServiceConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if entityName == "" {
		return nil, errors.New("parameter entityName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{entityName}", url.PathEscape(entityName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateRelayServiceConnectionHandleResponse handles the CreateOrUpdateRelayServiceConnection response.
func (client *WebAppsClient) createOrUpdateRelayServiceConnectionHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateRelayServiceConnectionResponse, error) {
	result := WebAppsClientCreateOrUpdateRelayServiceConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RelayServiceConnectionEntity); err != nil {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateRelayServiceConnectionSlot - Description for Creates a new hybrid connection configuration (PUT), or updates
// an existing one (PATCH).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// entityName - Name of the hybrid connection configuration.
// slot - Name of the deployment slot. If a slot is not specified, the API will create or update a hybrid connection for the
// production slot.
// connectionEnvelope - Details of the hybrid connection configuration.
// options - WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateRelayServiceConnectionSlot
// method.
func (client *WebAppsClient) CreateOrUpdateRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, connectionEnvelope RelayServiceConnectionEntity, options *WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions) (WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse, error) {
	req, err := client.createOrUpdateRelayServiceConnectionSlotCreateRequest(ctx, resourceGroupName, name, entityName, slot, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateRelayServiceConnectionSlotHandleResponse(resp)
}

// createOrUpdateRelayServiceConnectionSlotCreateRequest creates the CreateOrUpdateRelayServiceConnectionSlot request.
func (client *WebAppsClient) createOrUpdateRelayServiceConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, connectionEnvelope RelayServiceConnectionEntity, options *WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if entityName == "" {
		return nil, errors.New("parameter entityName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{entityName}", url.PathEscape(entityName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateRelayServiceConnectionSlotHandleResponse handles the CreateOrUpdateRelayServiceConnectionSlot response.
func (client *WebAppsClient) createOrUpdateRelayServiceConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RelayServiceConnectionEntity); err != nil {
		return WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdateSlot - Description for Creates a new web, mobile, or API app in an existing resource group, or updates
// an existing app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
// slot - Name of the deployment slot to create or update. By default, this API attempts to create or modify the production
// slot.
// siteEnvelope - A JSON representation of the app properties. See example.
// options - WebAppsClientBeginCreateOrUpdateSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSlot
// method.
func (client *WebAppsClient) BeginCreateOrUpdateSlot(ctx context.Context, resourceGroupName string, name string, slot string, siteEnvelope Site, options *WebAppsClientBeginCreateOrUpdateSlotOptions) (*runtime.Poller[WebAppsClientCreateOrUpdateSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateSlot(ctx, resourceGroupName, name, slot, siteEnvelope, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateOrUpdateSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateOrUpdateSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateSlot - Description for Creates a new web, mobile, or API app in an existing resource group, or updates an
// existing app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createOrUpdateSlot(ctx context.Context, resourceGroupName string, name string, slot string, siteEnvelope Site, options *WebAppsClientBeginCreateOrUpdateSlotOptions) (*http.Response, error) {
	req, err := client.createOrUpdateSlotCreateRequest(ctx, resourceGroupName, name, slot, siteEnvelope, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateSlotCreateRequest creates the CreateOrUpdateSlot request.
func (client *WebAppsClient) createOrUpdateSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, siteEnvelope Site, options *WebAppsClientBeginCreateOrUpdateSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, siteEnvelope)
}

// BeginCreateOrUpdateSourceControl - Description for Updates the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// siteSourceControl - JSON representation of a SiteSourceControl object. See example.
// options - WebAppsClientBeginCreateOrUpdateSourceControlOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSourceControl
// method.
func (client *WebAppsClient) BeginCreateOrUpdateSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, options *WebAppsClientBeginCreateOrUpdateSourceControlOptions) (*runtime.Poller[WebAppsClientCreateOrUpdateSourceControlResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateSourceControl(ctx, resourceGroupName, name, siteSourceControl, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateOrUpdateSourceControlResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateOrUpdateSourceControlResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateSourceControl - Description for Updates the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createOrUpdateSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, options *WebAppsClientBeginCreateOrUpdateSourceControlOptions) (*http.Response, error) {
	req, err := client.createOrUpdateSourceControlCreateRequest(ctx, resourceGroupName, name, siteSourceControl, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateSourceControlCreateRequest creates the CreateOrUpdateSourceControl request.
func (client *WebAppsClient) createOrUpdateSourceControlCreateRequest(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, options *WebAppsClientBeginCreateOrUpdateSourceControlOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, siteSourceControl)
}

// BeginCreateOrUpdateSourceControlSlot - Description for Updates the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will update the source control configuration for
// the production slot.
// siteSourceControl - JSON representation of a SiteSourceControl object. See example.
// options - WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSourceControlSlot
// method.
func (client *WebAppsClient) BeginCreateOrUpdateSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string, siteSourceControl SiteSourceControl, options *WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions) (*runtime.Poller[WebAppsClientCreateOrUpdateSourceControlSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateSourceControlSlot(ctx, resourceGroupName, name, slot, siteSourceControl, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientCreateOrUpdateSourceControlSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientCreateOrUpdateSourceControlSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateSourceControlSlot - Description for Updates the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) createOrUpdateSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string, siteSourceControl SiteSourceControl, options *WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions) (*http.Response, error) {
	req, err := client.createOrUpdateSourceControlSlotCreateRequest(ctx, resourceGroupName, name, slot, siteSourceControl, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateSourceControlSlotCreateRequest creates the CreateOrUpdateSourceControlSlot request.
func (client *WebAppsClient) createOrUpdateSourceControlSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, siteSourceControl SiteSourceControl, options *WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, siteSourceControl)
}

// CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck - Description for Integrates this Web App with a Virtual Network.
// This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has
// already been
// delegated, and is not in use by another App Service Plan other than the one this App is in.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// connectionEnvelope - Properties of the Virtual Network connection. See example.
// options - WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckOptions contains the optional parameters for
// the WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck method.
func (client *WebAppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck(ctx context.Context, resourceGroupName string, name string, connectionEnvelope SwiftVirtualNetwork, options *WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckOptions) (WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse, error) {
	req, err := client.createOrUpdateSwiftVirtualNetworkConnectionWithCheckCreateRequest(ctx, resourceGroupName, name, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateSwiftVirtualNetworkConnectionWithCheckHandleResponse(resp)
}

// createOrUpdateSwiftVirtualNetworkConnectionWithCheckCreateRequest creates the CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck request.
func (client *WebAppsClient) createOrUpdateSwiftVirtualNetworkConnectionWithCheckCreateRequest(ctx context.Context, resourceGroupName string, name string, connectionEnvelope SwiftVirtualNetwork, options *WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateSwiftVirtualNetworkConnectionWithCheckHandleResponse handles the CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck response.
func (client *WebAppsClient) createOrUpdateSwiftVirtualNetworkConnectionWithCheckHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse, error) {
	result := WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SwiftVirtualNetwork); err != nil {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot - Description for Integrates this Web App with a Virtual Network.
// This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has
// already been
// delegated, and is not in use by another App Service Plan other than the one this App is in.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will add or update connections for the production
// slot.
// connectionEnvelope - Properties of the Virtual Network connection. See example.
// options - WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions contains the optional parameters
// for the WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot method.
func (client *WebAppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot(ctx context.Context, resourceGroupName string, name string, slot string, connectionEnvelope SwiftVirtualNetwork, options *WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions) (WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse, error) {
	req, err := client.createOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotCreateRequest(ctx, resourceGroupName, name, slot, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotHandleResponse(resp)
}

// createOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotCreateRequest creates the CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot request.
func (client *WebAppsClient) createOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, connectionEnvelope SwiftVirtualNetwork, options *WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotHandleResponse handles the CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot response.
func (client *WebAppsClient) createOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SwiftVirtualNetwork); err != nil {
		return WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateVnetConnection - Description for Adds a Virtual Network connection to an app or slot (PUT) or updates the
// connection properties (PATCH).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of an existing Virtual Network.
// connectionEnvelope - Properties of the Virtual Network connection. See example.
// options - WebAppsClientCreateOrUpdateVnetConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnection
// method.
func (client *WebAppsClient) CreateOrUpdateVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfoResource, options *WebAppsClientCreateOrUpdateVnetConnectionOptions) (WebAppsClientCreateOrUpdateVnetConnectionResponse, error) {
	req, err := client.createOrUpdateVnetConnectionCreateRequest(ctx, resourceGroupName, name, vnetName, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateVnetConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateVnetConnectionHandleResponse(resp)
}

// createOrUpdateVnetConnectionCreateRequest creates the CreateOrUpdateVnetConnection request.
func (client *WebAppsClient) createOrUpdateVnetConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfoResource, options *WebAppsClientCreateOrUpdateVnetConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateVnetConnectionHandleResponse handles the CreateOrUpdateVnetConnection response.
func (client *WebAppsClient) createOrUpdateVnetConnectionHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateVnetConnectionResponse, error) {
	result := WebAppsClientCreateOrUpdateVnetConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetInfoResource); err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateVnetConnectionGateway - Description for Adds a gateway to a connected Virtual Network (PUT) or updates it
// (PATCH).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the Virtual Network.
// gatewayName - Name of the gateway. Currently, the only supported string is "primary".
// connectionEnvelope - The properties to update this gateway with.
// options - WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionGateway
// method.
func (client *WebAppsClient) CreateOrUpdateVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, options *WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions) (WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse, error) {
	req, err := client.createOrUpdateVnetConnectionGatewayCreateRequest(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateVnetConnectionGatewayHandleResponse(resp)
}

// createOrUpdateVnetConnectionGatewayCreateRequest creates the CreateOrUpdateVnetConnectionGateway request.
func (client *WebAppsClient) createOrUpdateVnetConnectionGatewayCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, options *WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if gatewayName == "" {
		return nil, errors.New("parameter gatewayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gatewayName}", url.PathEscape(gatewayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateVnetConnectionGatewayHandleResponse handles the CreateOrUpdateVnetConnectionGateway response.
func (client *WebAppsClient) createOrUpdateVnetConnectionGatewayHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse, error) {
	result := WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetGateway); err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateVnetConnectionGatewaySlot - Description for Adds a gateway to a connected Virtual Network (PUT) or updates
// it (PATCH).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the Virtual Network.
// gatewayName - Name of the gateway. Currently, the only supported string is "primary".
// slot - Name of the deployment slot. If a slot is not specified, the API will add or update a gateway for the production
// slot's Virtual Network.
// connectionEnvelope - The properties to update this gateway with.
// options - WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionGatewaySlot
// method.
func (client *WebAppsClient) CreateOrUpdateVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string, connectionEnvelope VnetGateway, options *WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions) (WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse, error) {
	req, err := client.createOrUpdateVnetConnectionGatewaySlotCreateRequest(ctx, resourceGroupName, name, vnetName, gatewayName, slot, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateVnetConnectionGatewaySlotHandleResponse(resp)
}

// createOrUpdateVnetConnectionGatewaySlotCreateRequest creates the CreateOrUpdateVnetConnectionGatewaySlot request.
func (client *WebAppsClient) createOrUpdateVnetConnectionGatewaySlotCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string, connectionEnvelope VnetGateway, options *WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if gatewayName == "" {
		return nil, errors.New("parameter gatewayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gatewayName}", url.PathEscape(gatewayName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateVnetConnectionGatewaySlotHandleResponse handles the CreateOrUpdateVnetConnectionGatewaySlot response.
func (client *WebAppsClient) createOrUpdateVnetConnectionGatewaySlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse, error) {
	result := WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetGateway); err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateVnetConnectionSlot - Description for Adds a Virtual Network connection to an app or slot (PUT) or updates
// the connection properties (PATCH).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of an existing Virtual Network.
// slot - Name of the deployment slot. If a slot is not specified, the API will add or update connections for the production
// slot.
// connectionEnvelope - Properties of the Virtual Network connection. See example.
// options - WebAppsClientCreateOrUpdateVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionSlot
// method.
func (client *WebAppsClient) CreateOrUpdateVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, connectionEnvelope VnetInfoResource, options *WebAppsClientCreateOrUpdateVnetConnectionSlotOptions) (WebAppsClientCreateOrUpdateVnetConnectionSlotResponse, error) {
	req, err := client.createOrUpdateVnetConnectionSlotCreateRequest(ctx, resourceGroupName, name, vnetName, slot, connectionEnvelope, options)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientCreateOrUpdateVnetConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateVnetConnectionSlotHandleResponse(resp)
}

// createOrUpdateVnetConnectionSlotCreateRequest creates the CreateOrUpdateVnetConnectionSlot request.
func (client *WebAppsClient) createOrUpdateVnetConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, connectionEnvelope VnetInfoResource, options *WebAppsClientCreateOrUpdateVnetConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, connectionEnvelope)
}

// createOrUpdateVnetConnectionSlotHandleResponse handles the CreateOrUpdateVnetConnectionSlot response.
func (client *WebAppsClient) createOrUpdateVnetConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientCreateOrUpdateVnetConnectionSlotResponse, error) {
	result := WebAppsClientCreateOrUpdateVnetConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetInfoResource); err != nil {
		return WebAppsClientCreateOrUpdateVnetConnectionSlotResponse{}, err
	}
	return result, nil
}

// Delete - Description for Deletes a web, mobile, or API app, or one of the deployment slots.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app to delete.
// options - WebAppsClientDeleteOptions contains the optional parameters for the WebAppsClient.Delete method.
func (client *WebAppsClient) Delete(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteOptions) (WebAppsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *WebAppsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.DeleteMetrics != nil {
		reqQP.Set("deleteMetrics", strconv.FormatBool(*options.DeleteMetrics))
	}
	if options != nil && options.DeleteEmptyServerFarm != nil {
		reqQP.Set("deleteEmptyServerFarm", strconv.FormatBool(*options.DeleteEmptyServerFarm))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteBackup - Description for Deletes a backup of an app by its ID.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// backupID - ID of the backup.
// options - WebAppsClientDeleteBackupOptions contains the optional parameters for the WebAppsClient.DeleteBackup method.
func (client *WebAppsClient) DeleteBackup(ctx context.Context, resourceGroupName string, name string, backupID string, options *WebAppsClientDeleteBackupOptions) (WebAppsClientDeleteBackupResponse, error) {
	req, err := client.deleteBackupCreateRequest(ctx, resourceGroupName, name, backupID, options)
	if err != nil {
		return WebAppsClientDeleteBackupResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteBackupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteBackupResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteBackupResponse{}, nil
}

// deleteBackupCreateRequest creates the DeleteBackup request.
func (client *WebAppsClient) deleteBackupCreateRequest(ctx context.Context, resourceGroupName string, name string, backupID string, options *WebAppsClientDeleteBackupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if backupID == "" {
		return nil, errors.New("parameter backupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupId}", url.PathEscape(backupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteBackupConfiguration - Description for Deletes the backup configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientDeleteBackupConfigurationOptions contains the optional parameters for the WebAppsClient.DeleteBackupConfiguration
// method.
func (client *WebAppsClient) DeleteBackupConfiguration(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteBackupConfigurationOptions) (WebAppsClientDeleteBackupConfigurationResponse, error) {
	req, err := client.deleteBackupConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientDeleteBackupConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteBackupConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteBackupConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteBackupConfigurationResponse{}, nil
}

// deleteBackupConfigurationCreateRequest creates the DeleteBackupConfiguration request.
func (client *WebAppsClient) deleteBackupConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteBackupConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteBackupConfigurationSlot - Description for Deletes the backup configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the backup configuration for the production
// slot.
// options - WebAppsClientDeleteBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.DeleteBackupConfigurationSlot
// method.
func (client *WebAppsClient) DeleteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteBackupConfigurationSlotOptions) (WebAppsClientDeleteBackupConfigurationSlotResponse, error) {
	req, err := client.deleteBackupConfigurationSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientDeleteBackupConfigurationSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteBackupConfigurationSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteBackupConfigurationSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteBackupConfigurationSlotResponse{}, nil
}

// deleteBackupConfigurationSlotCreateRequest creates the DeleteBackupConfigurationSlot request.
func (client *WebAppsClient) deleteBackupConfigurationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteBackupConfigurationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteBackupSlot - Description for Deletes a backup of an app by its ID.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// backupID - ID of the backup.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete a backup of the production slot.
// options - WebAppsClientDeleteBackupSlotOptions contains the optional parameters for the WebAppsClient.DeleteBackupSlot
// method.
func (client *WebAppsClient) DeleteBackupSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, options *WebAppsClientDeleteBackupSlotOptions) (WebAppsClientDeleteBackupSlotResponse, error) {
	req, err := client.deleteBackupSlotCreateRequest(ctx, resourceGroupName, name, backupID, slot, options)
	if err != nil {
		return WebAppsClientDeleteBackupSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteBackupSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteBackupSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteBackupSlotResponse{}, nil
}

// deleteBackupSlotCreateRequest creates the DeleteBackupSlot request.
func (client *WebAppsClient) deleteBackupSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, options *WebAppsClientDeleteBackupSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if backupID == "" {
		return nil, errors.New("parameter backupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupId}", url.PathEscape(backupID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteContinuousWebJob - Description for Delete a continuous web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// options - WebAppsClientDeleteContinuousWebJobOptions contains the optional parameters for the WebAppsClient.DeleteContinuousWebJob
// method.
func (client *WebAppsClient) DeleteContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientDeleteContinuousWebJobOptions) (WebAppsClientDeleteContinuousWebJobResponse, error) {
	req, err := client.deleteContinuousWebJobCreateRequest(ctx, resourceGroupName, name, webJobName, options)
	if err != nil {
		return WebAppsClientDeleteContinuousWebJobResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteContinuousWebJobResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteContinuousWebJobResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteContinuousWebJobResponse{}, nil
}

// deleteContinuousWebJobCreateRequest creates the DeleteContinuousWebJob request.
func (client *WebAppsClient) deleteContinuousWebJobCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientDeleteContinuousWebJobOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteContinuousWebJobSlot - Description for Delete a continuous web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// slot - Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
// options - WebAppsClientDeleteContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.DeleteContinuousWebJobSlot
// method.
func (client *WebAppsClient) DeleteContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientDeleteContinuousWebJobSlotOptions) (WebAppsClientDeleteContinuousWebJobSlotResponse, error) {
	req, err := client.deleteContinuousWebJobSlotCreateRequest(ctx, resourceGroupName, name, webJobName, slot, options)
	if err != nil {
		return WebAppsClientDeleteContinuousWebJobSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteContinuousWebJobSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteContinuousWebJobSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteContinuousWebJobSlotResponse{}, nil
}

// deleteContinuousWebJobSlotCreateRequest creates the DeleteContinuousWebJobSlot request.
func (client *WebAppsClient) deleteContinuousWebJobSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientDeleteContinuousWebJobSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteDeployment - Description for Delete a deployment by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - Deployment ID.
// options - WebAppsClientDeleteDeploymentOptions contains the optional parameters for the WebAppsClient.DeleteDeployment
// method.
func (client *WebAppsClient) DeleteDeployment(ctx context.Context, resourceGroupName string, name string, id string, options *WebAppsClientDeleteDeploymentOptions) (WebAppsClientDeleteDeploymentResponse, error) {
	req, err := client.deleteDeploymentCreateRequest(ctx, resourceGroupName, name, id, options)
	if err != nil {
		return WebAppsClientDeleteDeploymentResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteDeploymentResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteDeploymentResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteDeploymentResponse{}, nil
}

// deleteDeploymentCreateRequest creates the DeleteDeployment request.
func (client *WebAppsClient) deleteDeploymentCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, options *WebAppsClientDeleteDeploymentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteDeploymentSlot - Description for Delete a deployment by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - Deployment ID.
// slot - Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
// options - WebAppsClientDeleteDeploymentSlotOptions contains the optional parameters for the WebAppsClient.DeleteDeploymentSlot
// method.
func (client *WebAppsClient) DeleteDeploymentSlot(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *WebAppsClientDeleteDeploymentSlotOptions) (WebAppsClientDeleteDeploymentSlotResponse, error) {
	req, err := client.deleteDeploymentSlotCreateRequest(ctx, resourceGroupName, name, id, slot, options)
	if err != nil {
		return WebAppsClientDeleteDeploymentSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteDeploymentSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteDeploymentSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteDeploymentSlotResponse{}, nil
}

// deleteDeploymentSlotCreateRequest creates the DeleteDeploymentSlot request.
func (client *WebAppsClient) deleteDeploymentSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *WebAppsClientDeleteDeploymentSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteDomainOwnershipIdentifier - Description for Deletes a domain ownership identifier for a web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// domainOwnershipIdentifierName - Name of domain ownership identifier.
// options - WebAppsClientDeleteDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.DeleteDomainOwnershipIdentifier
// method.
func (client *WebAppsClient) DeleteDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, options *WebAppsClientDeleteDomainOwnershipIdentifierOptions) (WebAppsClientDeleteDomainOwnershipIdentifierResponse, error) {
	req, err := client.deleteDomainOwnershipIdentifierCreateRequest(ctx, resourceGroupName, name, domainOwnershipIdentifierName, options)
	if err != nil {
		return WebAppsClientDeleteDomainOwnershipIdentifierResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteDomainOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteDomainOwnershipIdentifierResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteDomainOwnershipIdentifierResponse{}, nil
}

// deleteDomainOwnershipIdentifierCreateRequest creates the DeleteDomainOwnershipIdentifier request.
func (client *WebAppsClient) deleteDomainOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, options *WebAppsClientDeleteDomainOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainOwnershipIdentifierName == "" {
		return nil, errors.New("parameter domainOwnershipIdentifierName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainOwnershipIdentifierName}", url.PathEscape(domainOwnershipIdentifierName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteDomainOwnershipIdentifierSlot - Description for Deletes a domain ownership identifier for a web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// domainOwnershipIdentifierName - Name of domain ownership identifier.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// options - WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.DeleteDomainOwnershipIdentifierSlot
// method.
func (client *WebAppsClient) DeleteDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, options *WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions) (WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse, error) {
	req, err := client.deleteDomainOwnershipIdentifierSlotCreateRequest(ctx, resourceGroupName, name, domainOwnershipIdentifierName, slot, options)
	if err != nil {
		return WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse{}, nil
}

// deleteDomainOwnershipIdentifierSlotCreateRequest creates the DeleteDomainOwnershipIdentifierSlot request.
func (client *WebAppsClient) deleteDomainOwnershipIdentifierSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, options *WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainOwnershipIdentifierName == "" {
		return nil, errors.New("parameter domainOwnershipIdentifierName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainOwnershipIdentifierName}", url.PathEscape(domainOwnershipIdentifierName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteFunction - Description for Delete a function for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// options - WebAppsClientDeleteFunctionOptions contains the optional parameters for the WebAppsClient.DeleteFunction method.
func (client *WebAppsClient) DeleteFunction(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientDeleteFunctionOptions) (WebAppsClientDeleteFunctionResponse, error) {
	req, err := client.deleteFunctionCreateRequest(ctx, resourceGroupName, name, functionName, options)
	if err != nil {
		return WebAppsClientDeleteFunctionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteFunctionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteFunctionResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteFunctionResponse{}, nil
}

// deleteFunctionCreateRequest creates the DeleteFunction request.
func (client *WebAppsClient) deleteFunctionCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientDeleteFunctionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteFunctionSecret - Description for Delete a function secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - The name of the function.
// keyName - The name of the key.
// options - WebAppsClientDeleteFunctionSecretOptions contains the optional parameters for the WebAppsClient.DeleteFunctionSecret
// method.
func (client *WebAppsClient) DeleteFunctionSecret(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, options *WebAppsClientDeleteFunctionSecretOptions) (WebAppsClientDeleteFunctionSecretResponse, error) {
	req, err := client.deleteFunctionSecretCreateRequest(ctx, resourceGroupName, name, functionName, keyName, options)
	if err != nil {
		return WebAppsClientDeleteFunctionSecretResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteFunctionSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteFunctionSecretResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteFunctionSecretResponse{}, nil
}

// deleteFunctionSecretCreateRequest creates the DeleteFunctionSecret request.
func (client *WebAppsClient) deleteFunctionSecretCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, options *WebAppsClientDeleteFunctionSecretOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteFunctionSecretSlot - Description for Delete a function secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - The name of the function.
// keyName - The name of the key.
// slot - Name of the deployment slot.
// options - WebAppsClientDeleteFunctionSecretSlotOptions contains the optional parameters for the WebAppsClient.DeleteFunctionSecretSlot
// method.
func (client *WebAppsClient) DeleteFunctionSecretSlot(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, options *WebAppsClientDeleteFunctionSecretSlotOptions) (WebAppsClientDeleteFunctionSecretSlotResponse, error) {
	req, err := client.deleteFunctionSecretSlotCreateRequest(ctx, resourceGroupName, name, functionName, keyName, slot, options)
	if err != nil {
		return WebAppsClientDeleteFunctionSecretSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteFunctionSecretSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteFunctionSecretSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteFunctionSecretSlotResponse{}, nil
}

// deleteFunctionSecretSlotCreateRequest creates the DeleteFunctionSecretSlot request.
func (client *WebAppsClient) deleteFunctionSecretSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, options *WebAppsClientDeleteFunctionSecretSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/keys/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteHostNameBinding - Description for Deletes a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// hostName - Hostname in the hostname binding.
// options - WebAppsClientDeleteHostNameBindingOptions contains the optional parameters for the WebAppsClient.DeleteHostNameBinding
// method.
func (client *WebAppsClient) DeleteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, options *WebAppsClientDeleteHostNameBindingOptions) (WebAppsClientDeleteHostNameBindingResponse, error) {
	req, err := client.deleteHostNameBindingCreateRequest(ctx, resourceGroupName, name, hostName, options)
	if err != nil {
		return WebAppsClientDeleteHostNameBindingResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteHostNameBindingResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteHostNameBindingResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteHostNameBindingResponse{}, nil
}

// deleteHostNameBindingCreateRequest creates the DeleteHostNameBinding request.
func (client *WebAppsClient) deleteHostNameBindingCreateRequest(ctx context.Context, resourceGroupName string, name string, hostName string, options *WebAppsClientDeleteHostNameBindingOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if hostName == "" {
		return nil, errors.New("parameter hostName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostName}", url.PathEscape(hostName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteHostNameBindingSlot - Description for Deletes a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// hostName - Hostname in the hostname binding.
// options - WebAppsClientDeleteHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.DeleteHostNameBindingSlot
// method.
func (client *WebAppsClient) DeleteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string, options *WebAppsClientDeleteHostNameBindingSlotOptions) (WebAppsClientDeleteHostNameBindingSlotResponse, error) {
	req, err := client.deleteHostNameBindingSlotCreateRequest(ctx, resourceGroupName, name, slot, hostName, options)
	if err != nil {
		return WebAppsClientDeleteHostNameBindingSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteHostNameBindingSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteHostNameBindingSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteHostNameBindingSlotResponse{}, nil
}

// deleteHostNameBindingSlotCreateRequest creates the DeleteHostNameBindingSlot request.
func (client *WebAppsClient) deleteHostNameBindingSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, hostName string, options *WebAppsClientDeleteHostNameBindingSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if hostName == "" {
		return nil, errors.New("parameter hostName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostName}", url.PathEscape(hostName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteHostSecret - Description for Delete a host level secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// keyType - The type of host key.
// keyName - The name of the key.
// options - WebAppsClientDeleteHostSecretOptions contains the optional parameters for the WebAppsClient.DeleteHostSecret
// method.
func (client *WebAppsClient) DeleteHostSecret(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, options *WebAppsClientDeleteHostSecretOptions) (WebAppsClientDeleteHostSecretResponse, error) {
	req, err := client.deleteHostSecretCreateRequest(ctx, resourceGroupName, name, keyType, keyName, options)
	if err != nil {
		return WebAppsClientDeleteHostSecretResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteHostSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteHostSecretResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteHostSecretResponse{}, nil
}

// deleteHostSecretCreateRequest creates the DeleteHostSecret request.
func (client *WebAppsClient) deleteHostSecretCreateRequest(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, options *WebAppsClientDeleteHostSecretOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if keyType == "" {
		return nil, errors.New("parameter keyType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyType}", url.PathEscape(keyType))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteHostSecretSlot - Description for Delete a host level secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// keyType - The type of host key.
// keyName - The name of the key.
// slot - Name of the deployment slot.
// options - WebAppsClientDeleteHostSecretSlotOptions contains the optional parameters for the WebAppsClient.DeleteHostSecretSlot
// method.
func (client *WebAppsClient) DeleteHostSecretSlot(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, options *WebAppsClientDeleteHostSecretSlotOptions) (WebAppsClientDeleteHostSecretSlotResponse, error) {
	req, err := client.deleteHostSecretSlotCreateRequest(ctx, resourceGroupName, name, keyType, keyName, slot, options)
	if err != nil {
		return WebAppsClientDeleteHostSecretSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteHostSecretSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteHostSecretSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteHostSecretSlotResponse{}, nil
}

// deleteHostSecretSlotCreateRequest creates the DeleteHostSecretSlot request.
func (client *WebAppsClient) deleteHostSecretSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, options *WebAppsClientDeleteHostSecretSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/{keyType}/{keyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if keyType == "" {
		return nil, errors.New("parameter keyType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyType}", url.PathEscape(keyType))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteHybridConnection - Description for Removes a Hybrid Connection from this site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// namespaceName - The namespace for this hybrid connection.
// relayName - The relay name for this hybrid connection.
// options - WebAppsClientDeleteHybridConnectionOptions contains the optional parameters for the WebAppsClient.DeleteHybridConnection
// method.
func (client *WebAppsClient) DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *WebAppsClientDeleteHybridConnectionOptions) (WebAppsClientDeleteHybridConnectionResponse, error) {
	req, err := client.deleteHybridConnectionCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, options)
	if err != nil {
		return WebAppsClientDeleteHybridConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteHybridConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteHybridConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteHybridConnectionResponse{}, nil
}

// deleteHybridConnectionCreateRequest creates the DeleteHybridConnection request.
func (client *WebAppsClient) deleteHybridConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *WebAppsClientDeleteHybridConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteHybridConnectionSlot - Description for Removes a Hybrid Connection from this site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// namespaceName - The namespace for this hybrid connection.
// relayName - The relay name for this hybrid connection.
// slot - The name of the slot for the web app.
// options - WebAppsClientDeleteHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteHybridConnectionSlot
// method.
func (client *WebAppsClient) DeleteHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, options *WebAppsClientDeleteHybridConnectionSlotOptions) (WebAppsClientDeleteHybridConnectionSlotResponse, error) {
	req, err := client.deleteHybridConnectionSlotCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, slot, options)
	if err != nil {
		return WebAppsClientDeleteHybridConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteHybridConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteHybridConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteHybridConnectionSlotResponse{}, nil
}

// deleteHybridConnectionSlotCreateRequest creates the DeleteHybridConnectionSlot request.
func (client *WebAppsClient) deleteHybridConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, options *WebAppsClientDeleteHybridConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteInstanceFunctionSlot - Description for Delete a function for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// slot - Name of the deployment slot.
// options - WebAppsClientDeleteInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.DeleteInstanceFunctionSlot
// method.
func (client *WebAppsClient) DeleteInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientDeleteInstanceFunctionSlotOptions) (WebAppsClientDeleteInstanceFunctionSlotResponse, error) {
	req, err := client.deleteInstanceFunctionSlotCreateRequest(ctx, resourceGroupName, name, functionName, slot, options)
	if err != nil {
		return WebAppsClientDeleteInstanceFunctionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteInstanceFunctionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteInstanceFunctionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteInstanceFunctionSlotResponse{}, nil
}

// deleteInstanceFunctionSlotCreateRequest creates the DeleteInstanceFunctionSlot request.
func (client *WebAppsClient) deleteInstanceFunctionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientDeleteInstanceFunctionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteInstanceProcess - Description for Terminate a process by its ID for a web site, or a deployment slot, or specific
// scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientDeleteInstanceProcessOptions contains the optional parameters for the WebAppsClient.DeleteInstanceProcess
// method.
func (client *WebAppsClient) DeleteInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientDeleteInstanceProcessOptions) (WebAppsClientDeleteInstanceProcessResponse, error) {
	req, err := client.deleteInstanceProcessCreateRequest(ctx, resourceGroupName, name, processID, instanceID, options)
	if err != nil {
		return WebAppsClientDeleteInstanceProcessResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteInstanceProcessResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteInstanceProcessResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteInstanceProcessResponse{}, nil
}

// deleteInstanceProcessCreateRequest creates the DeleteInstanceProcess request.
func (client *WebAppsClient) deleteInstanceProcessCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientDeleteInstanceProcessOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteInstanceProcessSlot - Description for Terminate a process by its ID for a web site, or a deployment slot, or specific
// scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientDeleteInstanceProcessSlotOptions contains the optional parameters for the WebAppsClient.DeleteInstanceProcessSlot
// method.
func (client *WebAppsClient) DeleteInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientDeleteInstanceProcessSlotOptions) (WebAppsClientDeleteInstanceProcessSlotResponse, error) {
	req, err := client.deleteInstanceProcessSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, instanceID, options)
	if err != nil {
		return WebAppsClientDeleteInstanceProcessSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteInstanceProcessSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteInstanceProcessSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteInstanceProcessSlotResponse{}, nil
}

// deleteInstanceProcessSlotCreateRequest creates the DeleteInstanceProcessSlot request.
func (client *WebAppsClient) deleteInstanceProcessSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientDeleteInstanceProcessSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeletePremierAddOn - Description for Delete a premier add-on from an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// premierAddOnName - Add-on name.
// options - WebAppsClientDeletePremierAddOnOptions contains the optional parameters for the WebAppsClient.DeletePremierAddOn
// method.
func (client *WebAppsClient) DeletePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, options *WebAppsClientDeletePremierAddOnOptions) (WebAppsClientDeletePremierAddOnResponse, error) {
	req, err := client.deletePremierAddOnCreateRequest(ctx, resourceGroupName, name, premierAddOnName, options)
	if err != nil {
		return WebAppsClientDeletePremierAddOnResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeletePremierAddOnResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeletePremierAddOnResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeletePremierAddOnResponse{}, nil
}

// deletePremierAddOnCreateRequest creates the DeletePremierAddOn request.
func (client *WebAppsClient) deletePremierAddOnCreateRequest(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, options *WebAppsClientDeletePremierAddOnOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if premierAddOnName == "" {
		return nil, errors.New("parameter premierAddOnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{premierAddOnName}", url.PathEscape(premierAddOnName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeletePremierAddOnSlot - Description for Delete a premier add-on from an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// premierAddOnName - Add-on name.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the named add-on for the production
// slot.
// options - WebAppsClientDeletePremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.DeletePremierAddOnSlot
// method.
func (client *WebAppsClient) DeletePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, options *WebAppsClientDeletePremierAddOnSlotOptions) (WebAppsClientDeletePremierAddOnSlotResponse, error) {
	req, err := client.deletePremierAddOnSlotCreateRequest(ctx, resourceGroupName, name, premierAddOnName, slot, options)
	if err != nil {
		return WebAppsClientDeletePremierAddOnSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeletePremierAddOnSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeletePremierAddOnSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeletePremierAddOnSlotResponse{}, nil
}

// deletePremierAddOnSlotCreateRequest creates the DeletePremierAddOnSlot request.
func (client *WebAppsClient) deletePremierAddOnSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, options *WebAppsClientDeletePremierAddOnSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if premierAddOnName == "" {
		return nil, errors.New("parameter premierAddOnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{premierAddOnName}", url.PathEscape(premierAddOnName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// options - WebAppsClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the WebAppsClient.BeginDeletePrivateEndpointConnection
// method.
func (client *WebAppsClient) BeginDeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *WebAppsClientBeginDeletePrivateEndpointConnectionOptions) (*runtime.Poller[WebAppsClientDeletePrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deletePrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientDeletePrivateEndpointConnectionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientDeletePrivateEndpointConnectionResponse](options.ResumeToken, client.pl, nil)
	}
}

// DeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) deletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *WebAppsClientBeginDeletePrivateEndpointConnectionOptions) (*http.Response, error) {
	req, err := client.deletePrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deletePrivateEndpointConnectionCreateRequest creates the DeletePrivateEndpointConnection request.
func (client *WebAppsClient) deletePrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *WebAppsClientBeginDeletePrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeletePrivateEndpointConnectionSlot - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// options - WebAppsClientBeginDeletePrivateEndpointConnectionSlotOptions contains the optional parameters for the WebAppsClient.BeginDeletePrivateEndpointConnectionSlot
// method.
func (client *WebAppsClient) BeginDeletePrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, options *WebAppsClientBeginDeletePrivateEndpointConnectionSlotOptions) (*runtime.Poller[WebAppsClientDeletePrivateEndpointConnectionSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deletePrivateEndpointConnectionSlot(ctx, resourceGroupName, name, privateEndpointConnectionName, slot, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientDeletePrivateEndpointConnectionSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientDeletePrivateEndpointConnectionSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// DeletePrivateEndpointConnectionSlot - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) deletePrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, options *WebAppsClientBeginDeletePrivateEndpointConnectionSlotOptions) (*http.Response, error) {
	req, err := client.deletePrivateEndpointConnectionSlotCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, slot, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deletePrivateEndpointConnectionSlotCreateRequest creates the DeletePrivateEndpointConnectionSlot request.
func (client *WebAppsClient) deletePrivateEndpointConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, options *WebAppsClientBeginDeletePrivateEndpointConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteProcess - Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// options - WebAppsClientDeleteProcessOptions contains the optional parameters for the WebAppsClient.DeleteProcess method.
func (client *WebAppsClient) DeleteProcess(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientDeleteProcessOptions) (WebAppsClientDeleteProcessResponse, error) {
	req, err := client.deleteProcessCreateRequest(ctx, resourceGroupName, name, processID, options)
	if err != nil {
		return WebAppsClientDeleteProcessResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteProcessResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteProcessResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteProcessResponse{}, nil
}

// deleteProcessCreateRequest creates the DeleteProcess request.
func (client *WebAppsClient) deleteProcessCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientDeleteProcessOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteProcessSlot - Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientDeleteProcessSlotOptions contains the optional parameters for the WebAppsClient.DeleteProcessSlot
// method.
func (client *WebAppsClient) DeleteProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientDeleteProcessSlotOptions) (WebAppsClientDeleteProcessSlotResponse, error) {
	req, err := client.deleteProcessSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, options)
	if err != nil {
		return WebAppsClientDeleteProcessSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteProcessSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteProcessSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteProcessSlotResponse{}, nil
}

// deleteProcessSlotCreateRequest creates the DeleteProcessSlot request.
func (client *WebAppsClient) deleteProcessSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientDeleteProcessSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeletePublicCertificate - Description for Deletes a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// publicCertificateName - Public certificate name.
// options - WebAppsClientDeletePublicCertificateOptions contains the optional parameters for the WebAppsClient.DeletePublicCertificate
// method.
func (client *WebAppsClient) DeletePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, options *WebAppsClientDeletePublicCertificateOptions) (WebAppsClientDeletePublicCertificateResponse, error) {
	req, err := client.deletePublicCertificateCreateRequest(ctx, resourceGroupName, name, publicCertificateName, options)
	if err != nil {
		return WebAppsClientDeletePublicCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeletePublicCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeletePublicCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeletePublicCertificateResponse{}, nil
}

// deletePublicCertificateCreateRequest creates the DeletePublicCertificate request.
func (client *WebAppsClient) deletePublicCertificateCreateRequest(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, options *WebAppsClientDeletePublicCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if publicCertificateName == "" {
		return nil, errors.New("parameter publicCertificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publicCertificateName}", url.PathEscape(publicCertificateName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeletePublicCertificateSlot - Description for Deletes a hostname binding for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// publicCertificateName - Public certificate name.
// options - WebAppsClientDeletePublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.DeletePublicCertificateSlot
// method.
func (client *WebAppsClient) DeletePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string, options *WebAppsClientDeletePublicCertificateSlotOptions) (WebAppsClientDeletePublicCertificateSlotResponse, error) {
	req, err := client.deletePublicCertificateSlotCreateRequest(ctx, resourceGroupName, name, slot, publicCertificateName, options)
	if err != nil {
		return WebAppsClientDeletePublicCertificateSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeletePublicCertificateSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeletePublicCertificateSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeletePublicCertificateSlotResponse{}, nil
}

// deletePublicCertificateSlotCreateRequest creates the DeletePublicCertificateSlot request.
func (client *WebAppsClient) deletePublicCertificateSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string, options *WebAppsClientDeletePublicCertificateSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if publicCertificateName == "" {
		return nil, errors.New("parameter publicCertificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publicCertificateName}", url.PathEscape(publicCertificateName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteRelayServiceConnection - Description for Deletes a relay service connection by its name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// entityName - Name of the hybrid connection configuration.
// options - WebAppsClientDeleteRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.DeleteRelayServiceConnection
// method.
func (client *WebAppsClient) DeleteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, options *WebAppsClientDeleteRelayServiceConnectionOptions) (WebAppsClientDeleteRelayServiceConnectionResponse, error) {
	req, err := client.deleteRelayServiceConnectionCreateRequest(ctx, resourceGroupName, name, entityName, options)
	if err != nil {
		return WebAppsClientDeleteRelayServiceConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteRelayServiceConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteRelayServiceConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteRelayServiceConnectionResponse{}, nil
}

// deleteRelayServiceConnectionCreateRequest creates the DeleteRelayServiceConnection request.
func (client *WebAppsClient) deleteRelayServiceConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, entityName string, options *WebAppsClientDeleteRelayServiceConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if entityName == "" {
		return nil, errors.New("parameter entityName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{entityName}", url.PathEscape(entityName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteRelayServiceConnectionSlot - Description for Deletes a relay service connection by its name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// entityName - Name of the hybrid connection configuration.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete a hybrid connection for the production
// slot.
// options - WebAppsClientDeleteRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteRelayServiceConnectionSlot
// method.
func (client *WebAppsClient) DeleteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, options *WebAppsClientDeleteRelayServiceConnectionSlotOptions) (WebAppsClientDeleteRelayServiceConnectionSlotResponse, error) {
	req, err := client.deleteRelayServiceConnectionSlotCreateRequest(ctx, resourceGroupName, name, entityName, slot, options)
	if err != nil {
		return WebAppsClientDeleteRelayServiceConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteRelayServiceConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteRelayServiceConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteRelayServiceConnectionSlotResponse{}, nil
}

// deleteRelayServiceConnectionSlotCreateRequest creates the DeleteRelayServiceConnectionSlot request.
func (client *WebAppsClient) deleteRelayServiceConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, options *WebAppsClientDeleteRelayServiceConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if entityName == "" {
		return nil, errors.New("parameter entityName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{entityName}", url.PathEscape(entityName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteSiteExtension - Description for Remove a site extension from a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// siteExtensionID - Site extension name.
// options - WebAppsClientDeleteSiteExtensionOptions contains the optional parameters for the WebAppsClient.DeleteSiteExtension
// method.
func (client *WebAppsClient) DeleteSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *WebAppsClientDeleteSiteExtensionOptions) (WebAppsClientDeleteSiteExtensionResponse, error) {
	req, err := client.deleteSiteExtensionCreateRequest(ctx, resourceGroupName, name, siteExtensionID, options)
	if err != nil {
		return WebAppsClientDeleteSiteExtensionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteSiteExtensionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteSiteExtensionResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteSiteExtensionResponse{}, nil
}

// deleteSiteExtensionCreateRequest creates the DeleteSiteExtension request.
func (client *WebAppsClient) deleteSiteExtensionCreateRequest(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *WebAppsClientDeleteSiteExtensionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if siteExtensionID == "" {
		return nil, errors.New("parameter siteExtensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteExtensionId}", url.PathEscape(siteExtensionID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteSiteExtensionSlot - Description for Remove a site extension from a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// siteExtensionID - Site extension name.
// slot - Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
// options - WebAppsClientDeleteSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.DeleteSiteExtensionSlot
// method.
func (client *WebAppsClient) DeleteSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *WebAppsClientDeleteSiteExtensionSlotOptions) (WebAppsClientDeleteSiteExtensionSlotResponse, error) {
	req, err := client.deleteSiteExtensionSlotCreateRequest(ctx, resourceGroupName, name, siteExtensionID, slot, options)
	if err != nil {
		return WebAppsClientDeleteSiteExtensionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteSiteExtensionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebAppsClientDeleteSiteExtensionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteSiteExtensionSlotResponse{}, nil
}

// deleteSiteExtensionSlotCreateRequest creates the DeleteSiteExtensionSlot request.
func (client *WebAppsClient) deleteSiteExtensionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *WebAppsClientDeleteSiteExtensionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if siteExtensionID == "" {
		return nil, errors.New("parameter siteExtensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteExtensionId}", url.PathEscape(siteExtensionID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteSlot - Description for Deletes a web, mobile, or API app, or one of the deployment slots.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app to delete.
// slot - Name of the deployment slot to delete. By default, the API deletes the production slot.
// options - WebAppsClientDeleteSlotOptions contains the optional parameters for the WebAppsClient.DeleteSlot method.
func (client *WebAppsClient) DeleteSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteSlotOptions) (WebAppsClientDeleteSlotResponse, error) {
	req, err := client.deleteSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientDeleteSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteSlotResponse{}, nil
}

// deleteSlotCreateRequest creates the DeleteSlot request.
func (client *WebAppsClient) deleteSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.DeleteMetrics != nil {
		reqQP.Set("deleteMetrics", strconv.FormatBool(*options.DeleteMetrics))
	}
	if options != nil && options.DeleteEmptyServerFarm != nil {
		reqQP.Set("deleteEmptyServerFarm", strconv.FormatBool(*options.DeleteEmptyServerFarm))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteSourceControl - Description for Deletes the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientDeleteSourceControlOptions contains the optional parameters for the WebAppsClient.DeleteSourceControl
// method.
func (client *WebAppsClient) DeleteSourceControl(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteSourceControlOptions) (WebAppsClientDeleteSourceControlResponse, error) {
	req, err := client.deleteSourceControlCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientDeleteSourceControlResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteSourceControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return WebAppsClientDeleteSourceControlResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteSourceControlResponse{}, nil
}

// deleteSourceControlCreateRequest creates the DeleteSourceControl request.
func (client *WebAppsClient) deleteSourceControlCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteSourceControlOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.AdditionalFlags != nil {
		reqQP.Set("additionalFlags", *options.AdditionalFlags)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteSourceControlSlot - Description for Deletes the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the source control configuration for
// the production slot.
// options - WebAppsClientDeleteSourceControlSlotOptions contains the optional parameters for the WebAppsClient.DeleteSourceControlSlot
// method.
func (client *WebAppsClient) DeleteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteSourceControlSlotOptions) (WebAppsClientDeleteSourceControlSlotResponse, error) {
	req, err := client.deleteSourceControlSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientDeleteSourceControlSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteSourceControlSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return WebAppsClientDeleteSourceControlSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteSourceControlSlotResponse{}, nil
}

// deleteSourceControlSlotCreateRequest creates the DeleteSourceControlSlot request.
func (client *WebAppsClient) deleteSourceControlSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteSourceControlSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.AdditionalFlags != nil {
		reqQP.Set("additionalFlags", *options.AdditionalFlags)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteSwiftVirtualNetwork - Description for Deletes a Swift Virtual Network connection from an app (or deployment slot).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientDeleteSwiftVirtualNetworkOptions contains the optional parameters for the WebAppsClient.DeleteSwiftVirtualNetwork
// method.
func (client *WebAppsClient) DeleteSwiftVirtualNetwork(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteSwiftVirtualNetworkOptions) (WebAppsClientDeleteSwiftVirtualNetworkResponse, error) {
	req, err := client.deleteSwiftVirtualNetworkCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientDeleteSwiftVirtualNetworkResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteSwiftVirtualNetworkResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteSwiftVirtualNetworkResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteSwiftVirtualNetworkResponse{}, nil
}

// deleteSwiftVirtualNetworkCreateRequest creates the DeleteSwiftVirtualNetwork request.
func (client *WebAppsClient) deleteSwiftVirtualNetworkCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientDeleteSwiftVirtualNetworkOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteSwiftVirtualNetworkSlot - Description for Deletes a Swift Virtual Network connection from an app (or deployment slot).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the connection for the production slot.
// options - WebAppsClientDeleteSwiftVirtualNetworkSlotOptions contains the optional parameters for the WebAppsClient.DeleteSwiftVirtualNetworkSlot
// method.
func (client *WebAppsClient) DeleteSwiftVirtualNetworkSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteSwiftVirtualNetworkSlotOptions) (WebAppsClientDeleteSwiftVirtualNetworkSlotResponse, error) {
	req, err := client.deleteSwiftVirtualNetworkSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientDeleteSwiftVirtualNetworkSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteSwiftVirtualNetworkSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteSwiftVirtualNetworkSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteSwiftVirtualNetworkSlotResponse{}, nil
}

// deleteSwiftVirtualNetworkSlotCreateRequest creates the DeleteSwiftVirtualNetworkSlot request.
func (client *WebAppsClient) deleteSwiftVirtualNetworkSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientDeleteSwiftVirtualNetworkSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteTriggeredWebJob - Description for Delete a triggered web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// options - WebAppsClientDeleteTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.DeleteTriggeredWebJob
// method.
func (client *WebAppsClient) DeleteTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientDeleteTriggeredWebJobOptions) (WebAppsClientDeleteTriggeredWebJobResponse, error) {
	req, err := client.deleteTriggeredWebJobCreateRequest(ctx, resourceGroupName, name, webJobName, options)
	if err != nil {
		return WebAppsClientDeleteTriggeredWebJobResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteTriggeredWebJobResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteTriggeredWebJobResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteTriggeredWebJobResponse{}, nil
}

// deleteTriggeredWebJobCreateRequest creates the DeleteTriggeredWebJob request.
func (client *WebAppsClient) deleteTriggeredWebJobCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientDeleteTriggeredWebJobOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteTriggeredWebJobSlot - Description for Delete a triggered web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// slot - Name of the deployment slot. If a slot is not specified, the API deletes web job for the production slot.
// options - WebAppsClientDeleteTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.DeleteTriggeredWebJobSlot
// method.
func (client *WebAppsClient) DeleteTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientDeleteTriggeredWebJobSlotOptions) (WebAppsClientDeleteTriggeredWebJobSlotResponse, error) {
	req, err := client.deleteTriggeredWebJobSlotCreateRequest(ctx, resourceGroupName, name, webJobName, slot, options)
	if err != nil {
		return WebAppsClientDeleteTriggeredWebJobSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteTriggeredWebJobSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientDeleteTriggeredWebJobSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteTriggeredWebJobSlotResponse{}, nil
}

// deleteTriggeredWebJobSlotCreateRequest creates the DeleteTriggeredWebJobSlot request.
func (client *WebAppsClient) deleteTriggeredWebJobSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientDeleteTriggeredWebJobSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteVnetConnection - Description for Deletes a connection from an app (or deployment slot to a named virtual network.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the virtual network.
// options - WebAppsClientDeleteVnetConnectionOptions contains the optional parameters for the WebAppsClient.DeleteVnetConnection
// method.
func (client *WebAppsClient) DeleteVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, options *WebAppsClientDeleteVnetConnectionOptions) (WebAppsClientDeleteVnetConnectionResponse, error) {
	req, err := client.deleteVnetConnectionCreateRequest(ctx, resourceGroupName, name, vnetName, options)
	if err != nil {
		return WebAppsClientDeleteVnetConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteVnetConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteVnetConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteVnetConnectionResponse{}, nil
}

// deleteVnetConnectionCreateRequest creates the DeleteVnetConnection request.
func (client *WebAppsClient) deleteVnetConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, options *WebAppsClientDeleteVnetConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteVnetConnectionSlot - Description for Deletes a connection from an app (or deployment slot to a named virtual network.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the virtual network.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the connection for the production slot.
// options - WebAppsClientDeleteVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteVnetConnectionSlot
// method.
func (client *WebAppsClient) DeleteVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, options *WebAppsClientDeleteVnetConnectionSlotOptions) (WebAppsClientDeleteVnetConnectionSlotResponse, error) {
	req, err := client.deleteVnetConnectionSlotCreateRequest(ctx, resourceGroupName, name, vnetName, slot, options)
	if err != nil {
		return WebAppsClientDeleteVnetConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDeleteVnetConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDeleteVnetConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientDeleteVnetConnectionSlotResponse{}, nil
}

// deleteVnetConnectionSlotCreateRequest creates the DeleteVnetConnectionSlot request.
func (client *WebAppsClient) deleteVnetConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, options *WebAppsClientDeleteVnetConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DiscoverBackup - Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use
// this to get information about the databases stored in a backup.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// request - A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
// options - WebAppsClientDiscoverBackupOptions contains the optional parameters for the WebAppsClient.DiscoverBackup method.
func (client *WebAppsClient) DiscoverBackup(ctx context.Context, resourceGroupName string, name string, request RestoreRequest, options *WebAppsClientDiscoverBackupOptions) (WebAppsClientDiscoverBackupResponse, error) {
	req, err := client.discoverBackupCreateRequest(ctx, resourceGroupName, name, request, options)
	if err != nil {
		return WebAppsClientDiscoverBackupResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDiscoverBackupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDiscoverBackupResponse{}, runtime.NewResponseError(resp)
	}
	return client.discoverBackupHandleResponse(resp)
}

// discoverBackupCreateRequest creates the DiscoverBackup request.
func (client *WebAppsClient) discoverBackupCreateRequest(ctx context.Context, resourceGroupName string, name string, request RestoreRequest, options *WebAppsClientDiscoverBackupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/discoverbackup"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, request)
}

// discoverBackupHandleResponse handles the DiscoverBackup response.
func (client *WebAppsClient) discoverBackupHandleResponse(resp *http.Response) (WebAppsClientDiscoverBackupResponse, error) {
	result := WebAppsClientDiscoverBackupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RestoreRequest); err != nil {
		return WebAppsClientDiscoverBackupResponse{}, err
	}
	return result, nil
}

// DiscoverBackupSlot - Description for Discovers an existing app backup that can be restored from a blob in Azure storage.
// Use this to get information about the databases stored in a backup.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will perform discovery for the production slot.
// request - A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
// options - WebAppsClientDiscoverBackupSlotOptions contains the optional parameters for the WebAppsClient.DiscoverBackupSlot
// method.
func (client *WebAppsClient) DiscoverBackupSlot(ctx context.Context, resourceGroupName string, name string, slot string, request RestoreRequest, options *WebAppsClientDiscoverBackupSlotOptions) (WebAppsClientDiscoverBackupSlotResponse, error) {
	req, err := client.discoverBackupSlotCreateRequest(ctx, resourceGroupName, name, slot, request, options)
	if err != nil {
		return WebAppsClientDiscoverBackupSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientDiscoverBackupSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientDiscoverBackupSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.discoverBackupSlotHandleResponse(resp)
}

// discoverBackupSlotCreateRequest creates the DiscoverBackupSlot request.
func (client *WebAppsClient) discoverBackupSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, request RestoreRequest, options *WebAppsClientDiscoverBackupSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/discoverbackup"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, request)
}

// discoverBackupSlotHandleResponse handles the DiscoverBackupSlot response.
func (client *WebAppsClient) discoverBackupSlotHandleResponse(resp *http.Response) (WebAppsClientDiscoverBackupSlotResponse, error) {
	result := WebAppsClientDiscoverBackupSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RestoreRequest); err != nil {
		return WebAppsClientDiscoverBackupSlotResponse{}, err
	}
	return result, nil
}

// GenerateNewSitePublishingPassword - Description for Generates a new publishing password for an app (or deployment slot,
// if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGenerateNewSitePublishingPasswordOptions contains the optional parameters for the WebAppsClient.GenerateNewSitePublishingPassword
// method.
func (client *WebAppsClient) GenerateNewSitePublishingPassword(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGenerateNewSitePublishingPasswordOptions) (WebAppsClientGenerateNewSitePublishingPasswordResponse, error) {
	req, err := client.generateNewSitePublishingPasswordCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGenerateNewSitePublishingPasswordResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGenerateNewSitePublishingPasswordResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientGenerateNewSitePublishingPasswordResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGenerateNewSitePublishingPasswordResponse{}, nil
}

// generateNewSitePublishingPasswordCreateRequest creates the GenerateNewSitePublishingPassword request.
func (client *WebAppsClient) generateNewSitePublishingPasswordCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGenerateNewSitePublishingPasswordOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GenerateNewSitePublishingPasswordSlot - Description for Generates a new publishing password for an app (or deployment slot,
// if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API generate a new publishing password for the production
// slot.
// options - WebAppsClientGenerateNewSitePublishingPasswordSlotOptions contains the optional parameters for the WebAppsClient.GenerateNewSitePublishingPasswordSlot
// method.
func (client *WebAppsClient) GenerateNewSitePublishingPasswordSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGenerateNewSitePublishingPasswordSlotOptions) (WebAppsClientGenerateNewSitePublishingPasswordSlotResponse, error) {
	req, err := client.generateNewSitePublishingPasswordSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGenerateNewSitePublishingPasswordSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGenerateNewSitePublishingPasswordSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientGenerateNewSitePublishingPasswordSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGenerateNewSitePublishingPasswordSlotResponse{}, nil
}

// generateNewSitePublishingPasswordSlotCreateRequest creates the GenerateNewSitePublishingPasswordSlot request.
func (client *WebAppsClient) generateNewSitePublishingPasswordSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGenerateNewSitePublishingPasswordSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Description for Gets the details of a web, mobile, or API app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetOptions contains the optional parameters for the WebAppsClient.Get method.
func (client *WebAppsClient) Get(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetOptions) (WebAppsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *WebAppsClient) getCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *WebAppsClient) getHandleResponse(resp *http.Response) (WebAppsClientGetResponse, error) {
	result := WebAppsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Site); err != nil {
		return WebAppsClientGetResponse{}, err
	}
	return result, nil
}

// GetAppSettingKeyVaultReference - Description for Gets the config reference and status of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// appSettingKey - App Setting key name.
// options - WebAppsClientGetAppSettingKeyVaultReferenceOptions contains the optional parameters for the WebAppsClient.GetAppSettingKeyVaultReference
// method.
func (client *WebAppsClient) GetAppSettingKeyVaultReference(ctx context.Context, resourceGroupName string, name string, appSettingKey string, options *WebAppsClientGetAppSettingKeyVaultReferenceOptions) (WebAppsClientGetAppSettingKeyVaultReferenceResponse, error) {
	req, err := client.getAppSettingKeyVaultReferenceCreateRequest(ctx, resourceGroupName, name, appSettingKey, options)
	if err != nil {
		return WebAppsClientGetAppSettingKeyVaultReferenceResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAppSettingKeyVaultReferenceResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAppSettingKeyVaultReferenceResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAppSettingKeyVaultReferenceHandleResponse(resp)
}

// getAppSettingKeyVaultReferenceCreateRequest creates the GetAppSettingKeyVaultReference request.
func (client *WebAppsClient) getAppSettingKeyVaultReferenceCreateRequest(ctx context.Context, resourceGroupName string, name string, appSettingKey string, options *WebAppsClientGetAppSettingKeyVaultReferenceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings/{appSettingKey}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if appSettingKey == "" {
		return nil, errors.New("parameter appSettingKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{appSettingKey}", url.PathEscape(appSettingKey))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAppSettingKeyVaultReferenceHandleResponse handles the GetAppSettingKeyVaultReference response.
func (client *WebAppsClient) getAppSettingKeyVaultReferenceHandleResponse(resp *http.Response) (WebAppsClientGetAppSettingKeyVaultReferenceResponse, error) {
	result := WebAppsClientGetAppSettingKeyVaultReferenceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReference); err != nil {
		return WebAppsClientGetAppSettingKeyVaultReferenceResponse{}, err
	}
	return result, nil
}

// GetAppSettingKeyVaultReferenceSlot - Description for Gets the config reference and status of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// appSettingKey - App Setting key name.
// options - WebAppsClientGetAppSettingKeyVaultReferenceSlotOptions contains the optional parameters for the WebAppsClient.GetAppSettingKeyVaultReferenceSlot
// method.
func (client *WebAppsClient) GetAppSettingKeyVaultReferenceSlot(ctx context.Context, resourceGroupName string, name string, appSettingKey string, slot string, options *WebAppsClientGetAppSettingKeyVaultReferenceSlotOptions) (WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse, error) {
	req, err := client.getAppSettingKeyVaultReferenceSlotCreateRequest(ctx, resourceGroupName, name, appSettingKey, slot, options)
	if err != nil {
		return WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAppSettingKeyVaultReferenceSlotHandleResponse(resp)
}

// getAppSettingKeyVaultReferenceSlotCreateRequest creates the GetAppSettingKeyVaultReferenceSlot request.
func (client *WebAppsClient) getAppSettingKeyVaultReferenceSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, appSettingKey string, slot string, options *WebAppsClientGetAppSettingKeyVaultReferenceSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/appsettings/{appSettingKey}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if appSettingKey == "" {
		return nil, errors.New("parameter appSettingKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{appSettingKey}", url.PathEscape(appSettingKey))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAppSettingKeyVaultReferenceSlotHandleResponse handles the GetAppSettingKeyVaultReferenceSlot response.
func (client *WebAppsClient) getAppSettingKeyVaultReferenceSlotHandleResponse(resp *http.Response) (WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse, error) {
	result := WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReference); err != nil {
		return WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse{}, err
	}
	return result, nil
}

// NewGetAppSettingsKeyVaultReferencesPager - Description for Gets the config reference app settings and status of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetAppSettingsKeyVaultReferencesOptions contains the optional parameters for the WebAppsClient.GetAppSettingsKeyVaultReferences
// method.
func (client *WebAppsClient) NewGetAppSettingsKeyVaultReferencesPager(resourceGroupName string, name string, options *WebAppsClientGetAppSettingsKeyVaultReferencesOptions) *runtime.Pager[WebAppsClientGetAppSettingsKeyVaultReferencesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientGetAppSettingsKeyVaultReferencesResponse]{
		More: func(page WebAppsClientGetAppSettingsKeyVaultReferencesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientGetAppSettingsKeyVaultReferencesResponse) (WebAppsClientGetAppSettingsKeyVaultReferencesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getAppSettingsKeyVaultReferencesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientGetAppSettingsKeyVaultReferencesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientGetAppSettingsKeyVaultReferencesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientGetAppSettingsKeyVaultReferencesResponse{}, runtime.NewResponseError(resp)
			}
			return client.getAppSettingsKeyVaultReferencesHandleResponse(resp)
		},
	})
}

// getAppSettingsKeyVaultReferencesCreateRequest creates the GetAppSettingsKeyVaultReferences request.
func (client *WebAppsClient) getAppSettingsKeyVaultReferencesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetAppSettingsKeyVaultReferencesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAppSettingsKeyVaultReferencesHandleResponse handles the GetAppSettingsKeyVaultReferences response.
func (client *WebAppsClient) getAppSettingsKeyVaultReferencesHandleResponse(resp *http.Response) (WebAppsClientGetAppSettingsKeyVaultReferencesResponse, error) {
	result := WebAppsClientGetAppSettingsKeyVaultReferencesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReferenceCollection); err != nil {
		return WebAppsClientGetAppSettingsKeyVaultReferencesResponse{}, err
	}
	return result, nil
}

// NewGetAppSettingsKeyVaultReferencesSlotPager - Description for Gets the config reference app settings and status of an
// app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetAppSettingsKeyVaultReferencesSlotOptions contains the optional parameters for the WebAppsClient.GetAppSettingsKeyVaultReferencesSlot
// method.
func (client *WebAppsClient) NewGetAppSettingsKeyVaultReferencesSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientGetAppSettingsKeyVaultReferencesSlotOptions) *runtime.Pager[WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse]{
		More: func(page WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse) (WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getAppSettingsKeyVaultReferencesSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.getAppSettingsKeyVaultReferencesSlotHandleResponse(resp)
		},
	})
}

// getAppSettingsKeyVaultReferencesSlotCreateRequest creates the GetAppSettingsKeyVaultReferencesSlot request.
func (client *WebAppsClient) getAppSettingsKeyVaultReferencesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetAppSettingsKeyVaultReferencesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/appsettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAppSettingsKeyVaultReferencesSlotHandleResponse handles the GetAppSettingsKeyVaultReferencesSlot response.
func (client *WebAppsClient) getAppSettingsKeyVaultReferencesSlotHandleResponse(resp *http.Response) (WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse, error) {
	result := WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReferenceCollection); err != nil {
		return WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse{}, err
	}
	return result, nil
}

// GetAuthSettings - Description for Gets the Authentication/Authorization settings of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetAuthSettingsOptions contains the optional parameters for the WebAppsClient.GetAuthSettings method.
func (client *WebAppsClient) GetAuthSettings(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetAuthSettingsOptions) (WebAppsClientGetAuthSettingsResponse, error) {
	req, err := client.getAuthSettingsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetAuthSettingsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAuthSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAuthSettingsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAuthSettingsHandleResponse(resp)
}

// getAuthSettingsCreateRequest creates the GetAuthSettings request.
func (client *WebAppsClient) getAuthSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetAuthSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAuthSettingsHandleResponse handles the GetAuthSettings response.
func (client *WebAppsClient) getAuthSettingsHandleResponse(resp *http.Response) (WebAppsClientGetAuthSettingsResponse, error) {
	result := WebAppsClientGetAuthSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteAuthSettings); err != nil {
		return WebAppsClientGetAuthSettingsResponse{}, err
	}
	return result, nil
}

// GetAuthSettingsSlot - Description for Gets the Authentication/Authorization settings of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the settings for the production slot.
// options - WebAppsClientGetAuthSettingsSlotOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsSlot
// method.
func (client *WebAppsClient) GetAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetAuthSettingsSlotOptions) (WebAppsClientGetAuthSettingsSlotResponse, error) {
	req, err := client.getAuthSettingsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetAuthSettingsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAuthSettingsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAuthSettingsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAuthSettingsSlotHandleResponse(resp)
}

// getAuthSettingsSlotCreateRequest creates the GetAuthSettingsSlot request.
func (client *WebAppsClient) getAuthSettingsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetAuthSettingsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAuthSettingsSlotHandleResponse handles the GetAuthSettingsSlot response.
func (client *WebAppsClient) getAuthSettingsSlotHandleResponse(resp *http.Response) (WebAppsClientGetAuthSettingsSlotResponse, error) {
	result := WebAppsClientGetAuthSettingsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteAuthSettings); err != nil {
		return WebAppsClientGetAuthSettingsSlotResponse{}, err
	}
	return result, nil
}

// GetAuthSettingsV2 - Description for Gets site's Authentication / Authorization settings for apps via the V2 format
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetAuthSettingsV2Options contains the optional parameters for the WebAppsClient.GetAuthSettingsV2
// method.
func (client *WebAppsClient) GetAuthSettingsV2(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetAuthSettingsV2Options) (WebAppsClientGetAuthSettingsV2Response, error) {
	req, err := client.getAuthSettingsV2CreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2Response{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2Response{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAuthSettingsV2Response{}, runtime.NewResponseError(resp)
	}
	return client.getAuthSettingsV2HandleResponse(resp)
}

// getAuthSettingsV2CreateRequest creates the GetAuthSettingsV2 request.
func (client *WebAppsClient) getAuthSettingsV2CreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetAuthSettingsV2Options) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAuthSettingsV2HandleResponse handles the GetAuthSettingsV2 response.
func (client *WebAppsClient) getAuthSettingsV2HandleResponse(resp *http.Response) (WebAppsClientGetAuthSettingsV2Response, error) {
	result := WebAppsClientGetAuthSettingsV2Response{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteAuthSettingsV2); err != nil {
		return WebAppsClientGetAuthSettingsV2Response{}, err
	}
	return result, nil
}

// GetAuthSettingsV2Slot - Description for Gets site's Authentication / Authorization settings for apps via the V2 format
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the settings for the production slot.
// options - WebAppsClientGetAuthSettingsV2SlotOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsV2Slot
// method.
func (client *WebAppsClient) GetAuthSettingsV2Slot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetAuthSettingsV2SlotOptions) (WebAppsClientGetAuthSettingsV2SlotResponse, error) {
	req, err := client.getAuthSettingsV2SlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2SlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2SlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAuthSettingsV2SlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAuthSettingsV2SlotHandleResponse(resp)
}

// getAuthSettingsV2SlotCreateRequest creates the GetAuthSettingsV2Slot request.
func (client *WebAppsClient) getAuthSettingsV2SlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetAuthSettingsV2SlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAuthSettingsV2SlotHandleResponse handles the GetAuthSettingsV2Slot response.
func (client *WebAppsClient) getAuthSettingsV2SlotHandleResponse(resp *http.Response) (WebAppsClientGetAuthSettingsV2SlotResponse, error) {
	result := WebAppsClientGetAuthSettingsV2SlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteAuthSettingsV2); err != nil {
		return WebAppsClientGetAuthSettingsV2SlotResponse{}, err
	}
	return result, nil
}

// GetAuthSettingsV2WithoutSecrets - Description for Gets site's Authentication / Authorization settings for apps via the
// V2 format
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetAuthSettingsV2WithoutSecretsOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsV2WithoutSecrets
// method.
func (client *WebAppsClient) GetAuthSettingsV2WithoutSecrets(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetAuthSettingsV2WithoutSecretsOptions) (WebAppsClientGetAuthSettingsV2WithoutSecretsResponse, error) {
	req, err := client.getAuthSettingsV2WithoutSecretsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAuthSettingsV2WithoutSecretsHandleResponse(resp)
}

// getAuthSettingsV2WithoutSecretsCreateRequest creates the GetAuthSettingsV2WithoutSecrets request.
func (client *WebAppsClient) getAuthSettingsV2WithoutSecretsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetAuthSettingsV2WithoutSecretsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAuthSettingsV2WithoutSecretsHandleResponse handles the GetAuthSettingsV2WithoutSecrets response.
func (client *WebAppsClient) getAuthSettingsV2WithoutSecretsHandleResponse(resp *http.Response) (WebAppsClientGetAuthSettingsV2WithoutSecretsResponse, error) {
	result := WebAppsClientGetAuthSettingsV2WithoutSecretsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteAuthSettingsV2); err != nil {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsResponse{}, err
	}
	return result, nil
}

// GetAuthSettingsV2WithoutSecretsSlot - Gets site's Authentication / Authorization settings for apps via the V2 format
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the settings for the production slot.
// options - WebAppsClientGetAuthSettingsV2WithoutSecretsSlotOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsV2WithoutSecretsSlot
// method.
func (client *WebAppsClient) GetAuthSettingsV2WithoutSecretsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetAuthSettingsV2WithoutSecretsSlotOptions) (WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse, error) {
	req, err := client.getAuthSettingsV2WithoutSecretsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAuthSettingsV2WithoutSecretsSlotHandleResponse(resp)
}

// getAuthSettingsV2WithoutSecretsSlotCreateRequest creates the GetAuthSettingsV2WithoutSecretsSlot request.
func (client *WebAppsClient) getAuthSettingsV2WithoutSecretsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetAuthSettingsV2WithoutSecretsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAuthSettingsV2WithoutSecretsSlotHandleResponse handles the GetAuthSettingsV2WithoutSecretsSlot response.
func (client *WebAppsClient) getAuthSettingsV2WithoutSecretsSlotHandleResponse(resp *http.Response) (WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse, error) {
	result := WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteAuthSettingsV2); err != nil {
		return WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse{}, err
	}
	return result, nil
}

// GetBackupConfiguration - Description for Gets the backup configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetBackupConfigurationOptions contains the optional parameters for the WebAppsClient.GetBackupConfiguration
// method.
func (client *WebAppsClient) GetBackupConfiguration(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetBackupConfigurationOptions) (WebAppsClientGetBackupConfigurationResponse, error) {
	req, err := client.getBackupConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetBackupConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetBackupConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetBackupConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBackupConfigurationHandleResponse(resp)
}

// getBackupConfigurationCreateRequest creates the GetBackupConfiguration request.
func (client *WebAppsClient) getBackupConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetBackupConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBackupConfigurationHandleResponse handles the GetBackupConfiguration response.
func (client *WebAppsClient) getBackupConfigurationHandleResponse(resp *http.Response) (WebAppsClientGetBackupConfigurationResponse, error) {
	result := WebAppsClientGetBackupConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupRequest); err != nil {
		return WebAppsClientGetBackupConfigurationResponse{}, err
	}
	return result, nil
}

// GetBackupConfigurationSlot - Description for Gets the backup configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the backup configuration for the production
// slot.
// options - WebAppsClientGetBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetBackupConfigurationSlot
// method.
func (client *WebAppsClient) GetBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetBackupConfigurationSlotOptions) (WebAppsClientGetBackupConfigurationSlotResponse, error) {
	req, err := client.getBackupConfigurationSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetBackupConfigurationSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetBackupConfigurationSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetBackupConfigurationSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBackupConfigurationSlotHandleResponse(resp)
}

// getBackupConfigurationSlotCreateRequest creates the GetBackupConfigurationSlot request.
func (client *WebAppsClient) getBackupConfigurationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetBackupConfigurationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBackupConfigurationSlotHandleResponse handles the GetBackupConfigurationSlot response.
func (client *WebAppsClient) getBackupConfigurationSlotHandleResponse(resp *http.Response) (WebAppsClientGetBackupConfigurationSlotResponse, error) {
	result := WebAppsClientGetBackupConfigurationSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupRequest); err != nil {
		return WebAppsClientGetBackupConfigurationSlotResponse{}, err
	}
	return result, nil
}

// GetBackupStatus - Description for Gets a backup of an app by its ID.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// backupID - ID of the backup.
// options - WebAppsClientGetBackupStatusOptions contains the optional parameters for the WebAppsClient.GetBackupStatus method.
func (client *WebAppsClient) GetBackupStatus(ctx context.Context, resourceGroupName string, name string, backupID string, options *WebAppsClientGetBackupStatusOptions) (WebAppsClientGetBackupStatusResponse, error) {
	req, err := client.getBackupStatusCreateRequest(ctx, resourceGroupName, name, backupID, options)
	if err != nil {
		return WebAppsClientGetBackupStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetBackupStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetBackupStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBackupStatusHandleResponse(resp)
}

// getBackupStatusCreateRequest creates the GetBackupStatus request.
func (client *WebAppsClient) getBackupStatusCreateRequest(ctx context.Context, resourceGroupName string, name string, backupID string, options *WebAppsClientGetBackupStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if backupID == "" {
		return nil, errors.New("parameter backupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupId}", url.PathEscape(backupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBackupStatusHandleResponse handles the GetBackupStatus response.
func (client *WebAppsClient) getBackupStatusHandleResponse(resp *http.Response) (WebAppsClientGetBackupStatusResponse, error) {
	result := WebAppsClientGetBackupStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItem); err != nil {
		return WebAppsClientGetBackupStatusResponse{}, err
	}
	return result, nil
}

// GetBackupStatusSlot - Description for Gets a backup of an app by its ID.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// backupID - ID of the backup.
// slot - Name of the deployment slot. If a slot is not specified, the API will get a backup of the production slot.
// options - WebAppsClientGetBackupStatusSlotOptions contains the optional parameters for the WebAppsClient.GetBackupStatusSlot
// method.
func (client *WebAppsClient) GetBackupStatusSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, options *WebAppsClientGetBackupStatusSlotOptions) (WebAppsClientGetBackupStatusSlotResponse, error) {
	req, err := client.getBackupStatusSlotCreateRequest(ctx, resourceGroupName, name, backupID, slot, options)
	if err != nil {
		return WebAppsClientGetBackupStatusSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetBackupStatusSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetBackupStatusSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBackupStatusSlotHandleResponse(resp)
}

// getBackupStatusSlotCreateRequest creates the GetBackupStatusSlot request.
func (client *WebAppsClient) getBackupStatusSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, options *WebAppsClientGetBackupStatusSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if backupID == "" {
		return nil, errors.New("parameter backupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupId}", url.PathEscape(backupID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBackupStatusSlotHandleResponse handles the GetBackupStatusSlot response.
func (client *WebAppsClient) getBackupStatusSlotHandleResponse(resp *http.Response) (WebAppsClientGetBackupStatusSlotResponse, error) {
	result := WebAppsClientGetBackupStatusSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItem); err != nil {
		return WebAppsClientGetBackupStatusSlotResponse{}, err
	}
	return result, nil
}

// GetConfiguration - Description for Gets the configuration of an app, such as platform version and bitness, default documents,
// virtual applications, Always On, etc.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetConfigurationOptions contains the optional parameters for the WebAppsClient.GetConfiguration
// method.
func (client *WebAppsClient) GetConfiguration(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetConfigurationOptions) (WebAppsClientGetConfigurationResponse, error) {
	req, err := client.getConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.getConfigurationHandleResponse(resp)
}

// getConfigurationCreateRequest creates the GetConfiguration request.
func (client *WebAppsClient) getConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getConfigurationHandleResponse handles the GetConfiguration response.
func (client *WebAppsClient) getConfigurationHandleResponse(resp *http.Response) (WebAppsClientGetConfigurationResponse, error) {
	result := WebAppsClientGetConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResource); err != nil {
		return WebAppsClientGetConfigurationResponse{}, err
	}
	return result, nil
}

// GetConfigurationSlot - Description for Gets the configuration of an app, such as platform version and bitness, default
// documents, virtual applications, Always On, etc.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will return configuration for the production slot.
// options - WebAppsClientGetConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSlot
// method.
func (client *WebAppsClient) GetConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetConfigurationSlotOptions) (WebAppsClientGetConfigurationSlotResponse, error) {
	req, err := client.getConfigurationSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetConfigurationSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetConfigurationSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetConfigurationSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getConfigurationSlotHandleResponse(resp)
}

// getConfigurationSlotCreateRequest creates the GetConfigurationSlot request.
func (client *WebAppsClient) getConfigurationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetConfigurationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getConfigurationSlotHandleResponse handles the GetConfigurationSlot response.
func (client *WebAppsClient) getConfigurationSlotHandleResponse(resp *http.Response) (WebAppsClientGetConfigurationSlotResponse, error) {
	result := WebAppsClientGetConfigurationSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResource); err != nil {
		return WebAppsClientGetConfigurationSlotResponse{}, err
	}
	return result, nil
}

// GetConfigurationSnapshot - Description for Gets a snapshot of the configuration of an app at a previous point in time.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// snapshotID - The ID of the snapshot to read.
// options - WebAppsClientGetConfigurationSnapshotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSnapshot
// method.
func (client *WebAppsClient) GetConfigurationSnapshot(ctx context.Context, resourceGroupName string, name string, snapshotID string, options *WebAppsClientGetConfigurationSnapshotOptions) (WebAppsClientGetConfigurationSnapshotResponse, error) {
	req, err := client.getConfigurationSnapshotCreateRequest(ctx, resourceGroupName, name, snapshotID, options)
	if err != nil {
		return WebAppsClientGetConfigurationSnapshotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetConfigurationSnapshotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetConfigurationSnapshotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getConfigurationSnapshotHandleResponse(resp)
}

// getConfigurationSnapshotCreateRequest creates the GetConfigurationSnapshot request.
func (client *WebAppsClient) getConfigurationSnapshotCreateRequest(ctx context.Context, resourceGroupName string, name string, snapshotID string, options *WebAppsClientGetConfigurationSnapshotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if snapshotID == "" {
		return nil, errors.New("parameter snapshotID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{snapshotId}", url.PathEscape(snapshotID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getConfigurationSnapshotHandleResponse handles the GetConfigurationSnapshot response.
func (client *WebAppsClient) getConfigurationSnapshotHandleResponse(resp *http.Response) (WebAppsClientGetConfigurationSnapshotResponse, error) {
	result := WebAppsClientGetConfigurationSnapshotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResource); err != nil {
		return WebAppsClientGetConfigurationSnapshotResponse{}, err
	}
	return result, nil
}

// GetConfigurationSnapshotSlot - Description for Gets a snapshot of the configuration of an app at a previous point in time.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// snapshotID - The ID of the snapshot to read.
// slot - Name of the deployment slot. If a slot is not specified, the API will return configuration for the production slot.
// options - WebAppsClientGetConfigurationSnapshotSlotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSnapshotSlot
// method.
func (client *WebAppsClient) GetConfigurationSnapshotSlot(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string, options *WebAppsClientGetConfigurationSnapshotSlotOptions) (WebAppsClientGetConfigurationSnapshotSlotResponse, error) {
	req, err := client.getConfigurationSnapshotSlotCreateRequest(ctx, resourceGroupName, name, snapshotID, slot, options)
	if err != nil {
		return WebAppsClientGetConfigurationSnapshotSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetConfigurationSnapshotSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetConfigurationSnapshotSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getConfigurationSnapshotSlotHandleResponse(resp)
}

// getConfigurationSnapshotSlotCreateRequest creates the GetConfigurationSnapshotSlot request.
func (client *WebAppsClient) getConfigurationSnapshotSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string, options *WebAppsClientGetConfigurationSnapshotSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if snapshotID == "" {
		return nil, errors.New("parameter snapshotID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{snapshotId}", url.PathEscape(snapshotID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getConfigurationSnapshotSlotHandleResponse handles the GetConfigurationSnapshotSlot response.
func (client *WebAppsClient) getConfigurationSnapshotSlotHandleResponse(resp *http.Response) (WebAppsClientGetConfigurationSnapshotSlotResponse, error) {
	result := WebAppsClientGetConfigurationSnapshotSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResource); err != nil {
		return WebAppsClientGetConfigurationSnapshotSlotResponse{}, err
	}
	return result, nil
}

// GetContainerLogsZip - Description for Gets the ZIP archived docker log files for the given site
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetContainerLogsZipOptions contains the optional parameters for the WebAppsClient.GetContainerLogsZip
// method.
func (client *WebAppsClient) GetContainerLogsZip(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetContainerLogsZipOptions) (WebAppsClientGetContainerLogsZipResponse, error) {
	req, err := client.getContainerLogsZipCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetContainerLogsZipResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetContainerLogsZipResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientGetContainerLogsZipResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetContainerLogsZipResponse{Body: resp.Body}, nil
}

// getContainerLogsZipCreateRequest creates the GetContainerLogsZip request.
func (client *WebAppsClient) getContainerLogsZipCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetContainerLogsZipOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs/zip/download"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/zip"}
	return req, nil
}

// GetContainerLogsZipSlot - Description for Gets the ZIP archived docker log files for the given site
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientGetContainerLogsZipSlotOptions contains the optional parameters for the WebAppsClient.GetContainerLogsZipSlot
// method.
func (client *WebAppsClient) GetContainerLogsZipSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetContainerLogsZipSlotOptions) (WebAppsClientGetContainerLogsZipSlotResponse, error) {
	req, err := client.getContainerLogsZipSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetContainerLogsZipSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetContainerLogsZipSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientGetContainerLogsZipSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetContainerLogsZipSlotResponse{Body: resp.Body}, nil
}

// getContainerLogsZipSlotCreateRequest creates the GetContainerLogsZipSlot request.
func (client *WebAppsClient) getContainerLogsZipSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetContainerLogsZipSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs/zip/download"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/zip"}
	return req, nil
}

// GetContinuousWebJob - Description for Gets a continuous web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// options - WebAppsClientGetContinuousWebJobOptions contains the optional parameters for the WebAppsClient.GetContinuousWebJob
// method.
func (client *WebAppsClient) GetContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientGetContinuousWebJobOptions) (WebAppsClientGetContinuousWebJobResponse, error) {
	req, err := client.getContinuousWebJobCreateRequest(ctx, resourceGroupName, name, webJobName, options)
	if err != nil {
		return WebAppsClientGetContinuousWebJobResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetContinuousWebJobResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetContinuousWebJobResponse{}, runtime.NewResponseError(resp)
	}
	return client.getContinuousWebJobHandleResponse(resp)
}

// getContinuousWebJobCreateRequest creates the GetContinuousWebJob request.
func (client *WebAppsClient) getContinuousWebJobCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientGetContinuousWebJobOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getContinuousWebJobHandleResponse handles the GetContinuousWebJob response.
func (client *WebAppsClient) getContinuousWebJobHandleResponse(resp *http.Response) (WebAppsClientGetContinuousWebJobResponse, error) {
	result := WebAppsClientGetContinuousWebJobResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ContinuousWebJob); err != nil {
		return WebAppsClientGetContinuousWebJobResponse{}, err
	}
	return result, nil
}

// GetContinuousWebJobSlot - Description for Gets a continuous web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// slot - Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
// options - WebAppsClientGetContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetContinuousWebJobSlot
// method.
func (client *WebAppsClient) GetContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientGetContinuousWebJobSlotOptions) (WebAppsClientGetContinuousWebJobSlotResponse, error) {
	req, err := client.getContinuousWebJobSlotCreateRequest(ctx, resourceGroupName, name, webJobName, slot, options)
	if err != nil {
		return WebAppsClientGetContinuousWebJobSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetContinuousWebJobSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetContinuousWebJobSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getContinuousWebJobSlotHandleResponse(resp)
}

// getContinuousWebJobSlotCreateRequest creates the GetContinuousWebJobSlot request.
func (client *WebAppsClient) getContinuousWebJobSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientGetContinuousWebJobSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getContinuousWebJobSlotHandleResponse handles the GetContinuousWebJobSlot response.
func (client *WebAppsClient) getContinuousWebJobSlotHandleResponse(resp *http.Response) (WebAppsClientGetContinuousWebJobSlotResponse, error) {
	result := WebAppsClientGetContinuousWebJobSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ContinuousWebJob); err != nil {
		return WebAppsClientGetContinuousWebJobSlotResponse{}, err
	}
	return result, nil
}

// GetDeployment - Description for Get a deployment by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - Deployment ID.
// options - WebAppsClientGetDeploymentOptions contains the optional parameters for the WebAppsClient.GetDeployment method.
func (client *WebAppsClient) GetDeployment(ctx context.Context, resourceGroupName string, name string, id string, options *WebAppsClientGetDeploymentOptions) (WebAppsClientGetDeploymentResponse, error) {
	req, err := client.getDeploymentCreateRequest(ctx, resourceGroupName, name, id, options)
	if err != nil {
		return WebAppsClientGetDeploymentResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetDeploymentResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetDeploymentResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDeploymentHandleResponse(resp)
}

// getDeploymentCreateRequest creates the GetDeployment request.
func (client *WebAppsClient) getDeploymentCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, options *WebAppsClientGetDeploymentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeploymentHandleResponse handles the GetDeployment response.
func (client *WebAppsClient) getDeploymentHandleResponse(resp *http.Response) (WebAppsClientGetDeploymentResponse, error) {
	result := WebAppsClientGetDeploymentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Deployment); err != nil {
		return WebAppsClientGetDeploymentResponse{}, err
	}
	return result, nil
}

// GetDeploymentSlot - Description for Get a deployment by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - Deployment ID.
// slot - Name of the deployment slot. If a slot is not specified, the API gets a deployment for the production slot.
// options - WebAppsClientGetDeploymentSlotOptions contains the optional parameters for the WebAppsClient.GetDeploymentSlot
// method.
func (client *WebAppsClient) GetDeploymentSlot(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *WebAppsClientGetDeploymentSlotOptions) (WebAppsClientGetDeploymentSlotResponse, error) {
	req, err := client.getDeploymentSlotCreateRequest(ctx, resourceGroupName, name, id, slot, options)
	if err != nil {
		return WebAppsClientGetDeploymentSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetDeploymentSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetDeploymentSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDeploymentSlotHandleResponse(resp)
}

// getDeploymentSlotCreateRequest creates the GetDeploymentSlot request.
func (client *WebAppsClient) getDeploymentSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *WebAppsClientGetDeploymentSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeploymentSlotHandleResponse handles the GetDeploymentSlot response.
func (client *WebAppsClient) getDeploymentSlotHandleResponse(resp *http.Response) (WebAppsClientGetDeploymentSlotResponse, error) {
	result := WebAppsClientGetDeploymentSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Deployment); err != nil {
		return WebAppsClientGetDeploymentSlotResponse{}, err
	}
	return result, nil
}

// GetDiagnosticLogsConfiguration - Description for Gets the logging configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetDiagnosticLogsConfigurationOptions contains the optional parameters for the WebAppsClient.GetDiagnosticLogsConfiguration
// method.
func (client *WebAppsClient) GetDiagnosticLogsConfiguration(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetDiagnosticLogsConfigurationOptions) (WebAppsClientGetDiagnosticLogsConfigurationResponse, error) {
	req, err := client.getDiagnosticLogsConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetDiagnosticLogsConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetDiagnosticLogsConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetDiagnosticLogsConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDiagnosticLogsConfigurationHandleResponse(resp)
}

// getDiagnosticLogsConfigurationCreateRequest creates the GetDiagnosticLogsConfiguration request.
func (client *WebAppsClient) getDiagnosticLogsConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetDiagnosticLogsConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDiagnosticLogsConfigurationHandleResponse handles the GetDiagnosticLogsConfiguration response.
func (client *WebAppsClient) getDiagnosticLogsConfigurationHandleResponse(resp *http.Response) (WebAppsClientGetDiagnosticLogsConfigurationResponse, error) {
	result := WebAppsClientGetDiagnosticLogsConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteLogsConfig); err != nil {
		return WebAppsClientGetDiagnosticLogsConfigurationResponse{}, err
	}
	return result, nil
}

// GetDiagnosticLogsConfigurationSlot - Description for Gets the logging configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the logging configuration for the production
// slot.
// options - WebAppsClientGetDiagnosticLogsConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetDiagnosticLogsConfigurationSlot
// method.
func (client *WebAppsClient) GetDiagnosticLogsConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetDiagnosticLogsConfigurationSlotOptions) (WebAppsClientGetDiagnosticLogsConfigurationSlotResponse, error) {
	req, err := client.getDiagnosticLogsConfigurationSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetDiagnosticLogsConfigurationSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetDiagnosticLogsConfigurationSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetDiagnosticLogsConfigurationSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDiagnosticLogsConfigurationSlotHandleResponse(resp)
}

// getDiagnosticLogsConfigurationSlotCreateRequest creates the GetDiagnosticLogsConfigurationSlot request.
func (client *WebAppsClient) getDiagnosticLogsConfigurationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetDiagnosticLogsConfigurationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDiagnosticLogsConfigurationSlotHandleResponse handles the GetDiagnosticLogsConfigurationSlot response.
func (client *WebAppsClient) getDiagnosticLogsConfigurationSlotHandleResponse(resp *http.Response) (WebAppsClientGetDiagnosticLogsConfigurationSlotResponse, error) {
	result := WebAppsClientGetDiagnosticLogsConfigurationSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteLogsConfig); err != nil {
		return WebAppsClientGetDiagnosticLogsConfigurationSlotResponse{}, err
	}
	return result, nil
}

// GetDomainOwnershipIdentifier - Description for Get domain ownership identifier for web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// domainOwnershipIdentifierName - Name of domain ownership identifier.
// options - WebAppsClientGetDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.GetDomainOwnershipIdentifier
// method.
func (client *WebAppsClient) GetDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, options *WebAppsClientGetDomainOwnershipIdentifierOptions) (WebAppsClientGetDomainOwnershipIdentifierResponse, error) {
	req, err := client.getDomainOwnershipIdentifierCreateRequest(ctx, resourceGroupName, name, domainOwnershipIdentifierName, options)
	if err != nil {
		return WebAppsClientGetDomainOwnershipIdentifierResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetDomainOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetDomainOwnershipIdentifierResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDomainOwnershipIdentifierHandleResponse(resp)
}

// getDomainOwnershipIdentifierCreateRequest creates the GetDomainOwnershipIdentifier request.
func (client *WebAppsClient) getDomainOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, options *WebAppsClientGetDomainOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainOwnershipIdentifierName == "" {
		return nil, errors.New("parameter domainOwnershipIdentifierName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainOwnershipIdentifierName}", url.PathEscape(domainOwnershipIdentifierName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDomainOwnershipIdentifierHandleResponse handles the GetDomainOwnershipIdentifier response.
func (client *WebAppsClient) getDomainOwnershipIdentifierHandleResponse(resp *http.Response) (WebAppsClientGetDomainOwnershipIdentifierResponse, error) {
	result := WebAppsClientGetDomainOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Identifier); err != nil {
		return WebAppsClientGetDomainOwnershipIdentifierResponse{}, err
	}
	return result, nil
}

// GetDomainOwnershipIdentifierSlot - Description for Get domain ownership identifier for web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// domainOwnershipIdentifierName - Name of domain ownership identifier.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// options - WebAppsClientGetDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.GetDomainOwnershipIdentifierSlot
// method.
func (client *WebAppsClient) GetDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, options *WebAppsClientGetDomainOwnershipIdentifierSlotOptions) (WebAppsClientGetDomainOwnershipIdentifierSlotResponse, error) {
	req, err := client.getDomainOwnershipIdentifierSlotCreateRequest(ctx, resourceGroupName, name, domainOwnershipIdentifierName, slot, options)
	if err != nil {
		return WebAppsClientGetDomainOwnershipIdentifierSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetDomainOwnershipIdentifierSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetDomainOwnershipIdentifierSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDomainOwnershipIdentifierSlotHandleResponse(resp)
}

// getDomainOwnershipIdentifierSlotCreateRequest creates the GetDomainOwnershipIdentifierSlot request.
func (client *WebAppsClient) getDomainOwnershipIdentifierSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string, options *WebAppsClientGetDomainOwnershipIdentifierSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainOwnershipIdentifierName == "" {
		return nil, errors.New("parameter domainOwnershipIdentifierName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainOwnershipIdentifierName}", url.PathEscape(domainOwnershipIdentifierName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDomainOwnershipIdentifierSlotHandleResponse handles the GetDomainOwnershipIdentifierSlot response.
func (client *WebAppsClient) getDomainOwnershipIdentifierSlotHandleResponse(resp *http.Response) (WebAppsClientGetDomainOwnershipIdentifierSlotResponse, error) {
	result := WebAppsClientGetDomainOwnershipIdentifierSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Identifier); err != nil {
		return WebAppsClientGetDomainOwnershipIdentifierSlotResponse{}, err
	}
	return result, nil
}

// GetFtpAllowed - Description for Returns whether FTP is allowed on the site or not.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetFtpAllowedOptions contains the optional parameters for the WebAppsClient.GetFtpAllowed method.
func (client *WebAppsClient) GetFtpAllowed(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetFtpAllowedOptions) (WebAppsClientGetFtpAllowedResponse, error) {
	req, err := client.getFtpAllowedCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetFtpAllowedResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetFtpAllowedResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetFtpAllowedResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFtpAllowedHandleResponse(resp)
}

// getFtpAllowedCreateRequest creates the GetFtpAllowed request.
func (client *WebAppsClient) getFtpAllowedCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetFtpAllowedOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/ftp"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFtpAllowedHandleResponse handles the GetFtpAllowed response.
func (client *WebAppsClient) getFtpAllowedHandleResponse(resp *http.Response) (WebAppsClientGetFtpAllowedResponse, error) {
	result := WebAppsClientGetFtpAllowedResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmPublishingCredentialsPoliciesEntity); err != nil {
		return WebAppsClientGetFtpAllowedResponse{}, err
	}
	return result, nil
}

// GetFtpAllowedSlot - Description for Returns whether FTP is allowed on the site or not.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetFtpAllowedSlotOptions contains the optional parameters for the WebAppsClient.GetFtpAllowedSlot
// method.
func (client *WebAppsClient) GetFtpAllowedSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetFtpAllowedSlotOptions) (WebAppsClientGetFtpAllowedSlotResponse, error) {
	req, err := client.getFtpAllowedSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetFtpAllowedSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetFtpAllowedSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetFtpAllowedSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFtpAllowedSlotHandleResponse(resp)
}

// getFtpAllowedSlotCreateRequest creates the GetFtpAllowedSlot request.
func (client *WebAppsClient) getFtpAllowedSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetFtpAllowedSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/ftp"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFtpAllowedSlotHandleResponse handles the GetFtpAllowedSlot response.
func (client *WebAppsClient) getFtpAllowedSlotHandleResponse(resp *http.Response) (WebAppsClientGetFtpAllowedSlotResponse, error) {
	result := WebAppsClientGetFtpAllowedSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmPublishingCredentialsPoliciesEntity); err != nil {
		return WebAppsClientGetFtpAllowedSlotResponse{}, err
	}
	return result, nil
}

// GetFunction - Description for Get function information by its ID for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// options - WebAppsClientGetFunctionOptions contains the optional parameters for the WebAppsClient.GetFunction method.
func (client *WebAppsClient) GetFunction(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientGetFunctionOptions) (WebAppsClientGetFunctionResponse, error) {
	req, err := client.getFunctionCreateRequest(ctx, resourceGroupName, name, functionName, options)
	if err != nil {
		return WebAppsClientGetFunctionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetFunctionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetFunctionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFunctionHandleResponse(resp)
}

// getFunctionCreateRequest creates the GetFunction request.
func (client *WebAppsClient) getFunctionCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientGetFunctionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFunctionHandleResponse handles the GetFunction response.
func (client *WebAppsClient) getFunctionHandleResponse(resp *http.Response) (WebAppsClientGetFunctionResponse, error) {
	result := WebAppsClientGetFunctionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionEnvelope); err != nil {
		return WebAppsClientGetFunctionResponse{}, err
	}
	return result, nil
}

// GetFunctionsAdminToken - Description for Fetch a short lived token that can be exchanged for a master key.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetFunctionsAdminTokenOptions contains the optional parameters for the WebAppsClient.GetFunctionsAdminToken
// method.
func (client *WebAppsClient) GetFunctionsAdminToken(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetFunctionsAdminTokenOptions) (WebAppsClientGetFunctionsAdminTokenResponse, error) {
	req, err := client.getFunctionsAdminTokenCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetFunctionsAdminTokenResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetFunctionsAdminTokenResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetFunctionsAdminTokenResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFunctionsAdminTokenHandleResponse(resp)
}

// getFunctionsAdminTokenCreateRequest creates the GetFunctionsAdminToken request.
func (client *WebAppsClient) getFunctionsAdminTokenCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetFunctionsAdminTokenOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/token"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFunctionsAdminTokenHandleResponse handles the GetFunctionsAdminToken response.
func (client *WebAppsClient) getFunctionsAdminTokenHandleResponse(resp *http.Response) (WebAppsClientGetFunctionsAdminTokenResponse, error) {
	result := WebAppsClientGetFunctionsAdminTokenResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Value); err != nil {
		return WebAppsClientGetFunctionsAdminTokenResponse{}, err
	}
	return result, nil
}

// GetFunctionsAdminTokenSlot - Description for Fetch a short lived token that can be exchanged for a master key.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientGetFunctionsAdminTokenSlotOptions contains the optional parameters for the WebAppsClient.GetFunctionsAdminTokenSlot
// method.
func (client *WebAppsClient) GetFunctionsAdminTokenSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetFunctionsAdminTokenSlotOptions) (WebAppsClientGetFunctionsAdminTokenSlotResponse, error) {
	req, err := client.getFunctionsAdminTokenSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetFunctionsAdminTokenSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetFunctionsAdminTokenSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetFunctionsAdminTokenSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFunctionsAdminTokenSlotHandleResponse(resp)
}

// getFunctionsAdminTokenSlotCreateRequest creates the GetFunctionsAdminTokenSlot request.
func (client *WebAppsClient) getFunctionsAdminTokenSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetFunctionsAdminTokenSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/admin/token"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFunctionsAdminTokenSlotHandleResponse handles the GetFunctionsAdminTokenSlot response.
func (client *WebAppsClient) getFunctionsAdminTokenSlotHandleResponse(resp *http.Response) (WebAppsClientGetFunctionsAdminTokenSlotResponse, error) {
	result := WebAppsClientGetFunctionsAdminTokenSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Value); err != nil {
		return WebAppsClientGetFunctionsAdminTokenSlotResponse{}, err
	}
	return result, nil
}

// GetHostNameBinding - Description for Get the named hostname binding for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// hostName - Hostname in the hostname binding.
// options - WebAppsClientGetHostNameBindingOptions contains the optional parameters for the WebAppsClient.GetHostNameBinding
// method.
func (client *WebAppsClient) GetHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, options *WebAppsClientGetHostNameBindingOptions) (WebAppsClientGetHostNameBindingResponse, error) {
	req, err := client.getHostNameBindingCreateRequest(ctx, resourceGroupName, name, hostName, options)
	if err != nil {
		return WebAppsClientGetHostNameBindingResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetHostNameBindingResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetHostNameBindingResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHostNameBindingHandleResponse(resp)
}

// getHostNameBindingCreateRequest creates the GetHostNameBinding request.
func (client *WebAppsClient) getHostNameBindingCreateRequest(ctx context.Context, resourceGroupName string, name string, hostName string, options *WebAppsClientGetHostNameBindingOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if hostName == "" {
		return nil, errors.New("parameter hostName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostName}", url.PathEscape(hostName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHostNameBindingHandleResponse handles the GetHostNameBinding response.
func (client *WebAppsClient) getHostNameBindingHandleResponse(resp *http.Response) (WebAppsClientGetHostNameBindingResponse, error) {
	result := WebAppsClientGetHostNameBindingResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostNameBinding); err != nil {
		return WebAppsClientGetHostNameBindingResponse{}, err
	}
	return result, nil
}

// GetHostNameBindingSlot - Description for Get the named hostname binding for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API the named binding for the production slot.
// hostName - Hostname in the hostname binding.
// options - WebAppsClientGetHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.GetHostNameBindingSlot
// method.
func (client *WebAppsClient) GetHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string, options *WebAppsClientGetHostNameBindingSlotOptions) (WebAppsClientGetHostNameBindingSlotResponse, error) {
	req, err := client.getHostNameBindingSlotCreateRequest(ctx, resourceGroupName, name, slot, hostName, options)
	if err != nil {
		return WebAppsClientGetHostNameBindingSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetHostNameBindingSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetHostNameBindingSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHostNameBindingSlotHandleResponse(resp)
}

// getHostNameBindingSlotCreateRequest creates the GetHostNameBindingSlot request.
func (client *WebAppsClient) getHostNameBindingSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, hostName string, options *WebAppsClientGetHostNameBindingSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if hostName == "" {
		return nil, errors.New("parameter hostName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostName}", url.PathEscape(hostName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHostNameBindingSlotHandleResponse handles the GetHostNameBindingSlot response.
func (client *WebAppsClient) getHostNameBindingSlotHandleResponse(resp *http.Response) (WebAppsClientGetHostNameBindingSlotResponse, error) {
	result := WebAppsClientGetHostNameBindingSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostNameBinding); err != nil {
		return WebAppsClientGetHostNameBindingSlotResponse{}, err
	}
	return result, nil
}

// GetHybridConnection - Description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// namespaceName - The namespace for this hybrid connection.
// relayName - The relay name for this hybrid connection.
// options - WebAppsClientGetHybridConnectionOptions contains the optional parameters for the WebAppsClient.GetHybridConnection
// method.
func (client *WebAppsClient) GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *WebAppsClientGetHybridConnectionOptions) (WebAppsClientGetHybridConnectionResponse, error) {
	req, err := client.getHybridConnectionCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, options)
	if err != nil {
		return WebAppsClientGetHybridConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetHybridConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetHybridConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHybridConnectionHandleResponse(resp)
}

// getHybridConnectionCreateRequest creates the GetHybridConnection request.
func (client *WebAppsClient) getHybridConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *WebAppsClientGetHybridConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHybridConnectionHandleResponse handles the GetHybridConnection response.
func (client *WebAppsClient) getHybridConnectionHandleResponse(resp *http.Response) (WebAppsClientGetHybridConnectionResponse, error) {
	result := WebAppsClientGetHybridConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnection); err != nil {
		return WebAppsClientGetHybridConnectionResponse{}, err
	}
	return result, nil
}

// GetHybridConnectionSlot - Description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// namespaceName - The namespace for this hybrid connection.
// relayName - The relay name for this hybrid connection.
// slot - The name of the slot for the web app.
// options - WebAppsClientGetHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetHybridConnectionSlot
// method.
func (client *WebAppsClient) GetHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, options *WebAppsClientGetHybridConnectionSlotOptions) (WebAppsClientGetHybridConnectionSlotResponse, error) {
	req, err := client.getHybridConnectionSlotCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, slot, options)
	if err != nil {
		return WebAppsClientGetHybridConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetHybridConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetHybridConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHybridConnectionSlotHandleResponse(resp)
}

// getHybridConnectionSlotCreateRequest creates the GetHybridConnectionSlot request.
func (client *WebAppsClient) getHybridConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string, options *WebAppsClientGetHybridConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHybridConnectionSlotHandleResponse handles the GetHybridConnectionSlot response.
func (client *WebAppsClient) getHybridConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientGetHybridConnectionSlotResponse, error) {
	result := WebAppsClientGetHybridConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnection); err != nil {
		return WebAppsClientGetHybridConnectionSlotResponse{}, err
	}
	return result, nil
}

// GetInstanceFunctionSlot - Description for Get function information by its ID for web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// slot - Name of the deployment slot.
// options - WebAppsClientGetInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceFunctionSlot
// method.
func (client *WebAppsClient) GetInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientGetInstanceFunctionSlotOptions) (WebAppsClientGetInstanceFunctionSlotResponse, error) {
	req, err := client.getInstanceFunctionSlotCreateRequest(ctx, resourceGroupName, name, functionName, slot, options)
	if err != nil {
		return WebAppsClientGetInstanceFunctionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceFunctionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceFunctionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceFunctionSlotHandleResponse(resp)
}

// getInstanceFunctionSlotCreateRequest creates the GetInstanceFunctionSlot request.
func (client *WebAppsClient) getInstanceFunctionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientGetInstanceFunctionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceFunctionSlotHandleResponse handles the GetInstanceFunctionSlot response.
func (client *WebAppsClient) getInstanceFunctionSlotHandleResponse(resp *http.Response) (WebAppsClientGetInstanceFunctionSlotResponse, error) {
	result := WebAppsClientGetInstanceFunctionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionEnvelope); err != nil {
		return WebAppsClientGetInstanceFunctionSlotResponse{}, err
	}
	return result, nil
}

// GetInstanceInfo - Description for Gets all scale-out instances of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetInstanceInfoOptions contains the optional parameters for the WebAppsClient.GetInstanceInfo method.
func (client *WebAppsClient) GetInstanceInfo(ctx context.Context, resourceGroupName string, name string, instanceID string, options *WebAppsClientGetInstanceInfoOptions) (WebAppsClientGetInstanceInfoResponse, error) {
	req, err := client.getInstanceInfoCreateRequest(ctx, resourceGroupName, name, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceInfoResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceInfoResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceInfoHandleResponse(resp)
}

// getInstanceInfoCreateRequest creates the GetInstanceInfo request.
func (client *WebAppsClient) getInstanceInfoCreateRequest(ctx context.Context, resourceGroupName string, name string, instanceID string, options *WebAppsClientGetInstanceInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceInfoHandleResponse handles the GetInstanceInfo response.
func (client *WebAppsClient) getInstanceInfoHandleResponse(resp *http.Response) (WebAppsClientGetInstanceInfoResponse, error) {
	result := WebAppsClientGetInstanceInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebSiteInstanceStatus); err != nil {
		return WebAppsClientGetInstanceInfoResponse{}, err
	}
	return result, nil
}

// GetInstanceInfoSlot - Description for Gets all scale-out instances of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API gets the production slot instances.
// options - WebAppsClientGetInstanceInfoSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceInfoSlot
// method.
func (client *WebAppsClient) GetInstanceInfoSlot(ctx context.Context, resourceGroupName string, name string, instanceID string, slot string, options *WebAppsClientGetInstanceInfoSlotOptions) (WebAppsClientGetInstanceInfoSlotResponse, error) {
	req, err := client.getInstanceInfoSlotCreateRequest(ctx, resourceGroupName, name, instanceID, slot, options)
	if err != nil {
		return WebAppsClientGetInstanceInfoSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceInfoSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceInfoSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceInfoSlotHandleResponse(resp)
}

// getInstanceInfoSlotCreateRequest creates the GetInstanceInfoSlot request.
func (client *WebAppsClient) getInstanceInfoSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, instanceID string, slot string, options *WebAppsClientGetInstanceInfoSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceInfoSlotHandleResponse handles the GetInstanceInfoSlot response.
func (client *WebAppsClient) getInstanceInfoSlotHandleResponse(resp *http.Response) (WebAppsClientGetInstanceInfoSlotResponse, error) {
	result := WebAppsClientGetInstanceInfoSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebSiteInstanceStatus); err != nil {
		return WebAppsClientGetInstanceInfoSlotResponse{}, err
	}
	return result, nil
}

// GetInstanceMSDeployLog - Description for Get the MSDeploy Log for the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// instanceID - ID of web app instance.
// options - WebAppsClientGetInstanceMSDeployLogOptions contains the optional parameters for the WebAppsClient.GetInstanceMSDeployLog
// method.
func (client *WebAppsClient) GetInstanceMSDeployLog(ctx context.Context, resourceGroupName string, name string, instanceID string, options *WebAppsClientGetInstanceMSDeployLogOptions) (WebAppsClientGetInstanceMSDeployLogResponse, error) {
	req, err := client.getInstanceMSDeployLogCreateRequest(ctx, resourceGroupName, name, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceMSDeployLogResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceMSDeployLogResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceMSDeployLogResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceMSDeployLogHandleResponse(resp)
}

// getInstanceMSDeployLogCreateRequest creates the GetInstanceMSDeployLog request.
func (client *WebAppsClient) getInstanceMSDeployLogCreateRequest(ctx context.Context, resourceGroupName string, name string, instanceID string, options *WebAppsClientGetInstanceMSDeployLogOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy/log"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceMSDeployLogHandleResponse handles the GetInstanceMSDeployLog response.
func (client *WebAppsClient) getInstanceMSDeployLogHandleResponse(resp *http.Response) (WebAppsClientGetInstanceMSDeployLogResponse, error) {
	result := WebAppsClientGetInstanceMSDeployLogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployLog); err != nil {
		return WebAppsClientGetInstanceMSDeployLogResponse{}, err
	}
	return result, nil
}

// GetInstanceMSDeployLogSlot - Description for Get the MSDeploy Log for the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// instanceID - ID of web app instance.
// options - WebAppsClientGetInstanceMSDeployLogSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceMSDeployLogSlot
// method.
func (client *WebAppsClient) GetInstanceMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, options *WebAppsClientGetInstanceMSDeployLogSlotOptions) (WebAppsClientGetInstanceMSDeployLogSlotResponse, error) {
	req, err := client.getInstanceMSDeployLogSlotCreateRequest(ctx, resourceGroupName, name, slot, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceMSDeployLogSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceMSDeployLogSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceMSDeployLogSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceMSDeployLogSlotHandleResponse(resp)
}

// getInstanceMSDeployLogSlotCreateRequest creates the GetInstanceMSDeployLogSlot request.
func (client *WebAppsClient) getInstanceMSDeployLogSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, options *WebAppsClientGetInstanceMSDeployLogSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy/log"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceMSDeployLogSlotHandleResponse handles the GetInstanceMSDeployLogSlot response.
func (client *WebAppsClient) getInstanceMSDeployLogSlotHandleResponse(resp *http.Response) (WebAppsClientGetInstanceMSDeployLogSlotResponse, error) {
	result := WebAppsClientGetInstanceMSDeployLogSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployLog); err != nil {
		return WebAppsClientGetInstanceMSDeployLogSlotResponse{}, err
	}
	return result, nil
}

// GetInstanceMsDeployStatus - Description for Get the status of the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// instanceID - ID of web app instance.
// options - WebAppsClientGetInstanceMsDeployStatusOptions contains the optional parameters for the WebAppsClient.GetInstanceMsDeployStatus
// method.
func (client *WebAppsClient) GetInstanceMsDeployStatus(ctx context.Context, resourceGroupName string, name string, instanceID string, options *WebAppsClientGetInstanceMsDeployStatusOptions) (WebAppsClientGetInstanceMsDeployStatusResponse, error) {
	req, err := client.getInstanceMsDeployStatusCreateRequest(ctx, resourceGroupName, name, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceMsDeployStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceMsDeployStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceMsDeployStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceMsDeployStatusHandleResponse(resp)
}

// getInstanceMsDeployStatusCreateRequest creates the GetInstanceMsDeployStatus request.
func (client *WebAppsClient) getInstanceMsDeployStatusCreateRequest(ctx context.Context, resourceGroupName string, name string, instanceID string, options *WebAppsClientGetInstanceMsDeployStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceMsDeployStatusHandleResponse handles the GetInstanceMsDeployStatus response.
func (client *WebAppsClient) getInstanceMsDeployStatusHandleResponse(resp *http.Response) (WebAppsClientGetInstanceMsDeployStatusResponse, error) {
	result := WebAppsClientGetInstanceMsDeployStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployStatus); err != nil {
		return WebAppsClientGetInstanceMsDeployStatusResponse{}, err
	}
	return result, nil
}

// GetInstanceMsDeployStatusSlot - Description for Get the status of the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// instanceID - ID of web app instance.
// options - WebAppsClientGetInstanceMsDeployStatusSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceMsDeployStatusSlot
// method.
func (client *WebAppsClient) GetInstanceMsDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, options *WebAppsClientGetInstanceMsDeployStatusSlotOptions) (WebAppsClientGetInstanceMsDeployStatusSlotResponse, error) {
	req, err := client.getInstanceMsDeployStatusSlotCreateRequest(ctx, resourceGroupName, name, slot, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceMsDeployStatusSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceMsDeployStatusSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceMsDeployStatusSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceMsDeployStatusSlotHandleResponse(resp)
}

// getInstanceMsDeployStatusSlotCreateRequest creates the GetInstanceMsDeployStatusSlot request.
func (client *WebAppsClient) getInstanceMsDeployStatusSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, options *WebAppsClientGetInstanceMsDeployStatusSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceMsDeployStatusSlotHandleResponse handles the GetInstanceMsDeployStatusSlot response.
func (client *WebAppsClient) getInstanceMsDeployStatusSlotHandleResponse(resp *http.Response) (WebAppsClientGetInstanceMsDeployStatusSlotResponse, error) {
	result := WebAppsClientGetInstanceMsDeployStatusSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployStatus); err != nil {
		return WebAppsClientGetInstanceMsDeployStatusSlotResponse{}, err
	}
	return result, nil
}

// GetInstanceProcess - Description for Get process information by its ID for a specific scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientGetInstanceProcessOptions contains the optional parameters for the WebAppsClient.GetInstanceProcess
// method.
func (client *WebAppsClient) GetInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientGetInstanceProcessOptions) (WebAppsClientGetInstanceProcessResponse, error) {
	req, err := client.getInstanceProcessCreateRequest(ctx, resourceGroupName, name, processID, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceProcessResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceProcessResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceProcessResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceProcessHandleResponse(resp)
}

// getInstanceProcessCreateRequest creates the GetInstanceProcess request.
func (client *WebAppsClient) getInstanceProcessCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientGetInstanceProcessOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceProcessHandleResponse handles the GetInstanceProcess response.
func (client *WebAppsClient) getInstanceProcessHandleResponse(resp *http.Response) (WebAppsClientGetInstanceProcessResponse, error) {
	result := WebAppsClientGetInstanceProcessResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfo); err != nil {
		return WebAppsClientGetInstanceProcessResponse{}, err
	}
	return result, nil
}

// GetInstanceProcessDump - Description for Get a memory dump of a process by its ID for a specific scaled-out instance in
// a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientGetInstanceProcessDumpOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessDump
// method.
func (client *WebAppsClient) GetInstanceProcessDump(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientGetInstanceProcessDumpOptions) (WebAppsClientGetInstanceProcessDumpResponse, error) {
	req, err := client.getInstanceProcessDumpCreateRequest(ctx, resourceGroupName, name, processID, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceProcessDumpResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceProcessDumpResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceProcessDumpResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetInstanceProcessDumpResponse{Body: resp.Body}, nil
}

// getInstanceProcessDumpCreateRequest creates the GetInstanceProcessDump request.
func (client *WebAppsClient) getInstanceProcessDumpCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientGetInstanceProcessDumpOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/dump"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetInstanceProcessDumpSlot - Description for Get a memory dump of a process by its ID for a specific scaled-out instance
// in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientGetInstanceProcessDumpSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessDumpSlot
// method.
func (client *WebAppsClient) GetInstanceProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientGetInstanceProcessDumpSlotOptions) (WebAppsClientGetInstanceProcessDumpSlotResponse, error) {
	req, err := client.getInstanceProcessDumpSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceProcessDumpSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceProcessDumpSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceProcessDumpSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetInstanceProcessDumpSlotResponse{Body: resp.Body}, nil
}

// getInstanceProcessDumpSlotCreateRequest creates the GetInstanceProcessDumpSlot request.
func (client *WebAppsClient) getInstanceProcessDumpSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientGetInstanceProcessDumpSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/dump"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetInstanceProcessModule - Description for Get process information by its ID for a specific scaled-out instance in a web
// site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// baseAddress - Module base address.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientGetInstanceProcessModuleOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessModule
// method.
func (client *WebAppsClient) GetInstanceProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, instanceID string, options *WebAppsClientGetInstanceProcessModuleOptions) (WebAppsClientGetInstanceProcessModuleResponse, error) {
	req, err := client.getInstanceProcessModuleCreateRequest(ctx, resourceGroupName, name, processID, baseAddress, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceProcessModuleResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceProcessModuleResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceProcessModuleResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceProcessModuleHandleResponse(resp)
}

// getInstanceProcessModuleCreateRequest creates the GetInstanceProcessModule request.
func (client *WebAppsClient) getInstanceProcessModuleCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, instanceID string, options *WebAppsClientGetInstanceProcessModuleOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if baseAddress == "" {
		return nil, errors.New("parameter baseAddress cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baseAddress}", url.PathEscape(baseAddress))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceProcessModuleHandleResponse handles the GetInstanceProcessModule response.
func (client *WebAppsClient) getInstanceProcessModuleHandleResponse(resp *http.Response) (WebAppsClientGetInstanceProcessModuleResponse, error) {
	result := WebAppsClientGetInstanceProcessModuleResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfo); err != nil {
		return WebAppsClientGetInstanceProcessModuleResponse{}, err
	}
	return result, nil
}

// GetInstanceProcessModuleSlot - Description for Get process information by its ID for a specific scaled-out instance in
// a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// baseAddress - Module base address.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientGetInstanceProcessModuleSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessModuleSlot
// method.
func (client *WebAppsClient) GetInstanceProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string, options *WebAppsClientGetInstanceProcessModuleSlotOptions) (WebAppsClientGetInstanceProcessModuleSlotResponse, error) {
	req, err := client.getInstanceProcessModuleSlotCreateRequest(ctx, resourceGroupName, name, processID, baseAddress, slot, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceProcessModuleSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceProcessModuleSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceProcessModuleSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceProcessModuleSlotHandleResponse(resp)
}

// getInstanceProcessModuleSlotCreateRequest creates the GetInstanceProcessModuleSlot request.
func (client *WebAppsClient) getInstanceProcessModuleSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string, options *WebAppsClientGetInstanceProcessModuleSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if baseAddress == "" {
		return nil, errors.New("parameter baseAddress cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baseAddress}", url.PathEscape(baseAddress))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceProcessModuleSlotHandleResponse handles the GetInstanceProcessModuleSlot response.
func (client *WebAppsClient) getInstanceProcessModuleSlotHandleResponse(resp *http.Response) (WebAppsClientGetInstanceProcessModuleSlotResponse, error) {
	result := WebAppsClientGetInstanceProcessModuleSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfo); err != nil {
		return WebAppsClientGetInstanceProcessModuleSlotResponse{}, err
	}
	return result, nil
}

// GetInstanceProcessSlot - Description for Get process information by its ID for a specific scaled-out instance in a web
// site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientGetInstanceProcessSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessSlot
// method.
func (client *WebAppsClient) GetInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientGetInstanceProcessSlotOptions) (WebAppsClientGetInstanceProcessSlotResponse, error) {
	req, err := client.getInstanceProcessSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, instanceID, options)
	if err != nil {
		return WebAppsClientGetInstanceProcessSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetInstanceProcessSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetInstanceProcessSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getInstanceProcessSlotHandleResponse(resp)
}

// getInstanceProcessSlotCreateRequest creates the GetInstanceProcessSlot request.
func (client *WebAppsClient) getInstanceProcessSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientGetInstanceProcessSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInstanceProcessSlotHandleResponse handles the GetInstanceProcessSlot response.
func (client *WebAppsClient) getInstanceProcessSlotHandleResponse(resp *http.Response) (WebAppsClientGetInstanceProcessSlotResponse, error) {
	result := WebAppsClientGetInstanceProcessSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfo); err != nil {
		return WebAppsClientGetInstanceProcessSlotResponse{}, err
	}
	return result, nil
}

// GetMSDeployLog - Description for Get the MSDeploy Log for the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetMSDeployLogOptions contains the optional parameters for the WebAppsClient.GetMSDeployLog method.
func (client *WebAppsClient) GetMSDeployLog(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetMSDeployLogOptions) (WebAppsClientGetMSDeployLogResponse, error) {
	req, err := client.getMSDeployLogCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetMSDeployLogResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetMSDeployLogResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetMSDeployLogResponse{}, runtime.NewResponseError(resp)
	}
	return client.getMSDeployLogHandleResponse(resp)
}

// getMSDeployLogCreateRequest creates the GetMSDeployLog request.
func (client *WebAppsClient) getMSDeployLogCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetMSDeployLogOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy/log"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMSDeployLogHandleResponse handles the GetMSDeployLog response.
func (client *WebAppsClient) getMSDeployLogHandleResponse(resp *http.Response) (WebAppsClientGetMSDeployLogResponse, error) {
	result := WebAppsClientGetMSDeployLogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployLog); err != nil {
		return WebAppsClientGetMSDeployLogResponse{}, err
	}
	return result, nil
}

// GetMSDeployLogSlot - Description for Get the MSDeploy Log for the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientGetMSDeployLogSlotOptions contains the optional parameters for the WebAppsClient.GetMSDeployLogSlot
// method.
func (client *WebAppsClient) GetMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetMSDeployLogSlotOptions) (WebAppsClientGetMSDeployLogSlotResponse, error) {
	req, err := client.getMSDeployLogSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetMSDeployLogSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetMSDeployLogSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetMSDeployLogSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getMSDeployLogSlotHandleResponse(resp)
}

// getMSDeployLogSlotCreateRequest creates the GetMSDeployLogSlot request.
func (client *WebAppsClient) getMSDeployLogSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetMSDeployLogSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy/log"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMSDeployLogSlotHandleResponse handles the GetMSDeployLogSlot response.
func (client *WebAppsClient) getMSDeployLogSlotHandleResponse(resp *http.Response) (WebAppsClientGetMSDeployLogSlotResponse, error) {
	result := WebAppsClientGetMSDeployLogSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployLog); err != nil {
		return WebAppsClientGetMSDeployLogSlotResponse{}, err
	}
	return result, nil
}

// GetMSDeployStatus - Description for Get the status of the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetMSDeployStatusOptions contains the optional parameters for the WebAppsClient.GetMSDeployStatus
// method.
func (client *WebAppsClient) GetMSDeployStatus(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetMSDeployStatusOptions) (WebAppsClientGetMSDeployStatusResponse, error) {
	req, err := client.getMSDeployStatusCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetMSDeployStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetMSDeployStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetMSDeployStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.getMSDeployStatusHandleResponse(resp)
}

// getMSDeployStatusCreateRequest creates the GetMSDeployStatus request.
func (client *WebAppsClient) getMSDeployStatusCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetMSDeployStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMSDeployStatusHandleResponse handles the GetMSDeployStatus response.
func (client *WebAppsClient) getMSDeployStatusHandleResponse(resp *http.Response) (WebAppsClientGetMSDeployStatusResponse, error) {
	result := WebAppsClientGetMSDeployStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployStatus); err != nil {
		return WebAppsClientGetMSDeployStatusResponse{}, err
	}
	return result, nil
}

// GetMSDeployStatusSlot - Description for Get the status of the last MSDeploy operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientGetMSDeployStatusSlotOptions contains the optional parameters for the WebAppsClient.GetMSDeployStatusSlot
// method.
func (client *WebAppsClient) GetMSDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetMSDeployStatusSlotOptions) (WebAppsClientGetMSDeployStatusSlotResponse, error) {
	req, err := client.getMSDeployStatusSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetMSDeployStatusSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetMSDeployStatusSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetMSDeployStatusSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getMSDeployStatusSlotHandleResponse(resp)
}

// getMSDeployStatusSlotCreateRequest creates the GetMSDeployStatusSlot request.
func (client *WebAppsClient) getMSDeployStatusSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetMSDeployStatusSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMSDeployStatusSlotHandleResponse handles the GetMSDeployStatusSlot response.
func (client *WebAppsClient) getMSDeployStatusSlotHandleResponse(resp *http.Response) (WebAppsClientGetMSDeployStatusSlotResponse, error) {
	result := WebAppsClientGetMSDeployStatusSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MSDeployStatus); err != nil {
		return WebAppsClientGetMSDeployStatusSlotResponse{}, err
	}
	return result, nil
}

// GetMigrateMySQLStatus - Description for Returns the status of MySql in app migration, if one is active, and whether or
// not MySql in app is enabled
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetMigrateMySQLStatusOptions contains the optional parameters for the WebAppsClient.GetMigrateMySQLStatus
// method.
func (client *WebAppsClient) GetMigrateMySQLStatus(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetMigrateMySQLStatusOptions) (WebAppsClientGetMigrateMySQLStatusResponse, error) {
	req, err := client.getMigrateMySQLStatusCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetMigrateMySQLStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetMigrateMySQLStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetMigrateMySQLStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.getMigrateMySQLStatusHandleResponse(resp)
}

// getMigrateMySQLStatusCreateRequest creates the GetMigrateMySQLStatus request.
func (client *WebAppsClient) getMigrateMySQLStatusCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetMigrateMySQLStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMigrateMySQLStatusHandleResponse handles the GetMigrateMySQLStatus response.
func (client *WebAppsClient) getMigrateMySQLStatusHandleResponse(resp *http.Response) (WebAppsClientGetMigrateMySQLStatusResponse, error) {
	result := WebAppsClientGetMigrateMySQLStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MigrateMySQLStatus); err != nil {
		return WebAppsClientGetMigrateMySQLStatusResponse{}, err
	}
	return result, nil
}

// GetMigrateMySQLStatusSlot - Description for Returns the status of MySql in app migration, if one is active, and whether
// or not MySql in app is enabled
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of the deployment slot.
// options - WebAppsClientGetMigrateMySQLStatusSlotOptions contains the optional parameters for the WebAppsClient.GetMigrateMySQLStatusSlot
// method.
func (client *WebAppsClient) GetMigrateMySQLStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetMigrateMySQLStatusSlotOptions) (WebAppsClientGetMigrateMySQLStatusSlotResponse, error) {
	req, err := client.getMigrateMySQLStatusSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetMigrateMySQLStatusSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetMigrateMySQLStatusSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetMigrateMySQLStatusSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getMigrateMySQLStatusSlotHandleResponse(resp)
}

// getMigrateMySQLStatusSlotCreateRequest creates the GetMigrateMySQLStatusSlot request.
func (client *WebAppsClient) getMigrateMySQLStatusSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetMigrateMySQLStatusSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMigrateMySQLStatusSlotHandleResponse handles the GetMigrateMySQLStatusSlot response.
func (client *WebAppsClient) getMigrateMySQLStatusSlotHandleResponse(resp *http.Response) (WebAppsClientGetMigrateMySQLStatusSlotResponse, error) {
	result := WebAppsClientGetMigrateMySQLStatusSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MigrateMySQLStatus); err != nil {
		return WebAppsClientGetMigrateMySQLStatusSlotResponse{}, err
	}
	return result, nil
}

// GetNetworkTraceOperation - Description for Gets a named operation for a network trace capturing (or deployment slot, if
// specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// options - WebAppsClientGetNetworkTraceOperationOptions contains the optional parameters for the WebAppsClient.GetNetworkTraceOperation
// method.
func (client *WebAppsClient) GetNetworkTraceOperation(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTraceOperationOptions) (WebAppsClientGetNetworkTraceOperationResponse, error) {
	req, err := client.getNetworkTraceOperationCreateRequest(ctx, resourceGroupName, name, operationID, options)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return WebAppsClientGetNetworkTraceOperationResponse{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTraceOperationHandleResponse(resp)
}

// getNetworkTraceOperationCreateRequest creates the GetNetworkTraceOperation request.
func (client *WebAppsClient) getNetworkTraceOperationCreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTraceOperationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/operationresults/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTraceOperationHandleResponse handles the GetNetworkTraceOperation response.
func (client *WebAppsClient) getNetworkTraceOperationHandleResponse(resp *http.Response) (WebAppsClientGetNetworkTraceOperationResponse, error) {
	result := WebAppsClientGetNetworkTraceOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTraceOperationResponse{}, err
	}
	return result, nil
}

// GetNetworkTraceOperationSlot - Description for Gets a named operation for a network trace capturing (or deployment slot,
// if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// slot - Name of the deployment slot. If a slot is not specified, the API will get an operation for the production slot.
// options - WebAppsClientGetNetworkTraceOperationSlotOptions contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationSlot
// method.
func (client *WebAppsClient) GetNetworkTraceOperationSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTraceOperationSlotOptions) (WebAppsClientGetNetworkTraceOperationSlotResponse, error) {
	req, err := client.getNetworkTraceOperationSlotCreateRequest(ctx, resourceGroupName, name, operationID, slot, options)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return WebAppsClientGetNetworkTraceOperationSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTraceOperationSlotHandleResponse(resp)
}

// getNetworkTraceOperationSlotCreateRequest creates the GetNetworkTraceOperationSlot request.
func (client *WebAppsClient) getNetworkTraceOperationSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTraceOperationSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/operationresults/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTraceOperationSlotHandleResponse handles the GetNetworkTraceOperationSlot response.
func (client *WebAppsClient) getNetworkTraceOperationSlotHandleResponse(resp *http.Response) (WebAppsClientGetNetworkTraceOperationSlotResponse, error) {
	result := WebAppsClientGetNetworkTraceOperationSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTraceOperationSlotResponse{}, err
	}
	return result, nil
}

// GetNetworkTraceOperationSlotV2 - Description for Gets a named operation for a network trace capturing (or deployment slot,
// if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// slot - Name of the deployment slot. If a slot is not specified, the API will get an operation for the production slot.
// options - WebAppsClientGetNetworkTraceOperationSlotV2Options contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationSlotV2
// method.
func (client *WebAppsClient) GetNetworkTraceOperationSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTraceOperationSlotV2Options) (WebAppsClientGetNetworkTraceOperationSlotV2Response, error) {
	req, err := client.getNetworkTraceOperationSlotV2CreateRequest(ctx, resourceGroupName, name, operationID, slot, options)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationSlotV2Response{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationSlotV2Response{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return WebAppsClientGetNetworkTraceOperationSlotV2Response{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTraceOperationSlotV2HandleResponse(resp)
}

// getNetworkTraceOperationSlotV2CreateRequest creates the GetNetworkTraceOperationSlotV2 request.
func (client *WebAppsClient) getNetworkTraceOperationSlotV2CreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTraceOperationSlotV2Options) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/current/operationresults/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTraceOperationSlotV2HandleResponse handles the GetNetworkTraceOperationSlotV2 response.
func (client *WebAppsClient) getNetworkTraceOperationSlotV2HandleResponse(resp *http.Response) (WebAppsClientGetNetworkTraceOperationSlotV2Response, error) {
	result := WebAppsClientGetNetworkTraceOperationSlotV2Response{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTraceOperationSlotV2Response{}, err
	}
	return result, nil
}

// GetNetworkTraceOperationV2 - Description for Gets a named operation for a network trace capturing (or deployment slot,
// if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// options - WebAppsClientGetNetworkTraceOperationV2Options contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationV2
// method.
func (client *WebAppsClient) GetNetworkTraceOperationV2(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTraceOperationV2Options) (WebAppsClientGetNetworkTraceOperationV2Response, error) {
	req, err := client.getNetworkTraceOperationV2CreateRequest(ctx, resourceGroupName, name, operationID, options)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationV2Response{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTraceOperationV2Response{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return WebAppsClientGetNetworkTraceOperationV2Response{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTraceOperationV2HandleResponse(resp)
}

// getNetworkTraceOperationV2CreateRequest creates the GetNetworkTraceOperationV2 request.
func (client *WebAppsClient) getNetworkTraceOperationV2CreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTraceOperationV2Options) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/current/operationresults/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTraceOperationV2HandleResponse handles the GetNetworkTraceOperationV2 response.
func (client *WebAppsClient) getNetworkTraceOperationV2HandleResponse(resp *http.Response) (WebAppsClientGetNetworkTraceOperationV2Response, error) {
	result := WebAppsClientGetNetworkTraceOperationV2Response{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTraceOperationV2Response{}, err
	}
	return result, nil
}

// GetNetworkTraces - Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// options - WebAppsClientGetNetworkTracesOptions contains the optional parameters for the WebAppsClient.GetNetworkTraces
// method.
func (client *WebAppsClient) GetNetworkTraces(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTracesOptions) (WebAppsClientGetNetworkTracesResponse, error) {
	req, err := client.getNetworkTracesCreateRequest(ctx, resourceGroupName, name, operationID, options)
	if err != nil {
		return WebAppsClientGetNetworkTracesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTracesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetNetworkTracesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTracesHandleResponse(resp)
}

// getNetworkTracesCreateRequest creates the GetNetworkTraces request.
func (client *WebAppsClient) getNetworkTracesCreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTracesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTracesHandleResponse handles the GetNetworkTraces response.
func (client *WebAppsClient) getNetworkTracesHandleResponse(resp *http.Response) (WebAppsClientGetNetworkTracesResponse, error) {
	result := WebAppsClientGetNetworkTracesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTracesResponse{}, err
	}
	return result, nil
}

// GetNetworkTracesSlot - Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// slot - Name of the deployment slot. If a slot is not specified, the API will get an operation for the production slot.
// options - WebAppsClientGetNetworkTracesSlotOptions contains the optional parameters for the WebAppsClient.GetNetworkTracesSlot
// method.
func (client *WebAppsClient) GetNetworkTracesSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTracesSlotOptions) (WebAppsClientGetNetworkTracesSlotResponse, error) {
	req, err := client.getNetworkTracesSlotCreateRequest(ctx, resourceGroupName, name, operationID, slot, options)
	if err != nil {
		return WebAppsClientGetNetworkTracesSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTracesSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetNetworkTracesSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTracesSlotHandleResponse(resp)
}

// getNetworkTracesSlotCreateRequest creates the GetNetworkTracesSlot request.
func (client *WebAppsClient) getNetworkTracesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTracesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTracesSlotHandleResponse handles the GetNetworkTracesSlot response.
func (client *WebAppsClient) getNetworkTracesSlotHandleResponse(resp *http.Response) (WebAppsClientGetNetworkTracesSlotResponse, error) {
	result := WebAppsClientGetNetworkTracesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTracesSlotResponse{}, err
	}
	return result, nil
}

// GetNetworkTracesSlotV2 - Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// slot - Name of the deployment slot. If a slot is not specified, the API will get an operation for the production slot.
// options - WebAppsClientGetNetworkTracesSlotV2Options contains the optional parameters for the WebAppsClient.GetNetworkTracesSlotV2
// method.
func (client *WebAppsClient) GetNetworkTracesSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTracesSlotV2Options) (WebAppsClientGetNetworkTracesSlotV2Response, error) {
	req, err := client.getNetworkTracesSlotV2CreateRequest(ctx, resourceGroupName, name, operationID, slot, options)
	if err != nil {
		return WebAppsClientGetNetworkTracesSlotV2Response{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTracesSlotV2Response{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetNetworkTracesSlotV2Response{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTracesSlotV2HandleResponse(resp)
}

// getNetworkTracesSlotV2CreateRequest creates the GetNetworkTracesSlotV2 request.
func (client *WebAppsClient) getNetworkTracesSlotV2CreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, slot string, options *WebAppsClientGetNetworkTracesSlotV2Options) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTracesSlotV2HandleResponse handles the GetNetworkTracesSlotV2 response.
func (client *WebAppsClient) getNetworkTracesSlotV2HandleResponse(resp *http.Response) (WebAppsClientGetNetworkTracesSlotV2Response, error) {
	result := WebAppsClientGetNetworkTracesSlotV2Response{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTracesSlotV2Response{}, err
	}
	return result, nil
}

// GetNetworkTracesV2 - Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// operationID - GUID of the operation.
// options - WebAppsClientGetNetworkTracesV2Options contains the optional parameters for the WebAppsClient.GetNetworkTracesV2
// method.
func (client *WebAppsClient) GetNetworkTracesV2(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTracesV2Options) (WebAppsClientGetNetworkTracesV2Response, error) {
	req, err := client.getNetworkTracesV2CreateRequest(ctx, resourceGroupName, name, operationID, options)
	if err != nil {
		return WebAppsClientGetNetworkTracesV2Response{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetNetworkTracesV2Response{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetNetworkTracesV2Response{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkTracesV2HandleResponse(resp)
}

// getNetworkTracesV2CreateRequest creates the GetNetworkTracesV2 request.
func (client *WebAppsClient) getNetworkTracesV2CreateRequest(ctx context.Context, resourceGroupName string, name string, operationID string, options *WebAppsClientGetNetworkTracesV2Options) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/{operationId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkTracesV2HandleResponse handles the GetNetworkTracesV2 response.
func (client *WebAppsClient) getNetworkTracesV2HandleResponse(resp *http.Response) (WebAppsClientGetNetworkTracesV2Response, error) {
	result := WebAppsClientGetNetworkTracesV2Response{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkTraceArray); err != nil {
		return WebAppsClientGetNetworkTracesV2Response{}, err
	}
	return result, nil
}

// GetOneDeployStatus - Description for Invoke onedeploy status API /api/deployments and gets the deployment status for the
// site
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetOneDeployStatusOptions contains the optional parameters for the WebAppsClient.GetOneDeployStatus
// method.
func (client *WebAppsClient) GetOneDeployStatus(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetOneDeployStatusOptions) (WebAppsClientGetOneDeployStatusResponse, error) {
	req, err := client.getOneDeployStatusCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetOneDeployStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetOneDeployStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetOneDeployStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.getOneDeployStatusHandleResponse(resp)
}

// getOneDeployStatusCreateRequest creates the GetOneDeployStatus request.
func (client *WebAppsClient) getOneDeployStatusCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetOneDeployStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/onedeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOneDeployStatusHandleResponse handles the GetOneDeployStatus response.
func (client *WebAppsClient) getOneDeployStatusHandleResponse(resp *http.Response) (WebAppsClientGetOneDeployStatusResponse, error) {
	result := WebAppsClientGetOneDeployStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Interface); err != nil {
		return WebAppsClientGetOneDeployStatusResponse{}, err
	}
	return result, nil
}

// GetPremierAddOn - Description for Gets a named add-on of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// premierAddOnName - Add-on name.
// options - WebAppsClientGetPremierAddOnOptions contains the optional parameters for the WebAppsClient.GetPremierAddOn method.
func (client *WebAppsClient) GetPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, options *WebAppsClientGetPremierAddOnOptions) (WebAppsClientGetPremierAddOnResponse, error) {
	req, err := client.getPremierAddOnCreateRequest(ctx, resourceGroupName, name, premierAddOnName, options)
	if err != nil {
		return WebAppsClientGetPremierAddOnResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPremierAddOnResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPremierAddOnResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPremierAddOnHandleResponse(resp)
}

// getPremierAddOnCreateRequest creates the GetPremierAddOn request.
func (client *WebAppsClient) getPremierAddOnCreateRequest(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, options *WebAppsClientGetPremierAddOnOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if premierAddOnName == "" {
		return nil, errors.New("parameter premierAddOnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{premierAddOnName}", url.PathEscape(premierAddOnName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPremierAddOnHandleResponse handles the GetPremierAddOn response.
func (client *WebAppsClient) getPremierAddOnHandleResponse(resp *http.Response) (WebAppsClientGetPremierAddOnResponse, error) {
	result := WebAppsClientGetPremierAddOnResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PremierAddOn); err != nil {
		return WebAppsClientGetPremierAddOnResponse{}, err
	}
	return result, nil
}

// GetPremierAddOnSlot - Description for Gets a named add-on of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// premierAddOnName - Add-on name.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the named add-on for the production slot.
// options - WebAppsClientGetPremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.GetPremierAddOnSlot
// method.
func (client *WebAppsClient) GetPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, options *WebAppsClientGetPremierAddOnSlotOptions) (WebAppsClientGetPremierAddOnSlotResponse, error) {
	req, err := client.getPremierAddOnSlotCreateRequest(ctx, resourceGroupName, name, premierAddOnName, slot, options)
	if err != nil {
		return WebAppsClientGetPremierAddOnSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPremierAddOnSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPremierAddOnSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPremierAddOnSlotHandleResponse(resp)
}

// getPremierAddOnSlotCreateRequest creates the GetPremierAddOnSlot request.
func (client *WebAppsClient) getPremierAddOnSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string, options *WebAppsClientGetPremierAddOnSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if premierAddOnName == "" {
		return nil, errors.New("parameter premierAddOnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{premierAddOnName}", url.PathEscape(premierAddOnName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPremierAddOnSlotHandleResponse handles the GetPremierAddOnSlot response.
func (client *WebAppsClient) getPremierAddOnSlotHandleResponse(resp *http.Response) (WebAppsClientGetPremierAddOnSlotResponse, error) {
	result := WebAppsClientGetPremierAddOnSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PremierAddOn); err != nil {
		return WebAppsClientGetPremierAddOnSlotResponse{}, err
	}
	return result, nil
}

// GetPrivateAccess - Description for Gets data around private site access enablement and authorized Virtual Networks that
// can access the site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// options - WebAppsClientGetPrivateAccessOptions contains the optional parameters for the WebAppsClient.GetPrivateAccess
// method.
func (client *WebAppsClient) GetPrivateAccess(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetPrivateAccessOptions) (WebAppsClientGetPrivateAccessResponse, error) {
	req, err := client.getPrivateAccessCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetPrivateAccessResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPrivateAccessResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPrivateAccessResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateAccessHandleResponse(resp)
}

// getPrivateAccessCreateRequest creates the GetPrivateAccess request.
func (client *WebAppsClient) getPrivateAccessCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetPrivateAccessOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateAccessHandleResponse handles the GetPrivateAccess response.
func (client *WebAppsClient) getPrivateAccessHandleResponse(resp *http.Response) (WebAppsClientGetPrivateAccessResponse, error) {
	result := WebAppsClientGetPrivateAccessResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateAccess); err != nil {
		return WebAppsClientGetPrivateAccessResponse{}, err
	}
	return result, nil
}

// GetPrivateAccessSlot - Description for Gets data around private site access enablement and authorized Virtual Networks
// that can access the site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// slot - The name of the slot for the web app.
// options - WebAppsClientGetPrivateAccessSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateAccessSlot
// method.
func (client *WebAppsClient) GetPrivateAccessSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetPrivateAccessSlotOptions) (WebAppsClientGetPrivateAccessSlotResponse, error) {
	req, err := client.getPrivateAccessSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetPrivateAccessSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPrivateAccessSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPrivateAccessSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateAccessSlotHandleResponse(resp)
}

// getPrivateAccessSlotCreateRequest creates the GetPrivateAccessSlot request.
func (client *WebAppsClient) getPrivateAccessSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetPrivateAccessSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateAccessSlotHandleResponse handles the GetPrivateAccessSlot response.
func (client *WebAppsClient) getPrivateAccessSlotHandleResponse(resp *http.Response) (WebAppsClientGetPrivateAccessSlotResponse, error) {
	result := WebAppsClientGetPrivateAccessSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateAccess); err != nil {
		return WebAppsClientGetPrivateAccessSlotResponse{}, err
	}
	return result, nil
}

// GetPrivateEndpointConnection - Description for Gets a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// privateEndpointConnectionName - Name of the private endpoint connection.
// options - WebAppsClientGetPrivateEndpointConnectionOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnection
// method.
func (client *WebAppsClient) GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *WebAppsClientGetPrivateEndpointConnectionOptions) (WebAppsClientGetPrivateEndpointConnectionResponse, error) {
	req, err := client.getPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return WebAppsClientGetPrivateEndpointConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPrivateEndpointConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPrivateEndpointConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateEndpointConnectionHandleResponse(resp)
}

// getPrivateEndpointConnectionCreateRequest creates the GetPrivateEndpointConnection request.
func (client *WebAppsClient) getPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *WebAppsClientGetPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionHandleResponse handles the GetPrivateEndpointConnection response.
func (client *WebAppsClient) getPrivateEndpointConnectionHandleResponse(resp *http.Response) (WebAppsClientGetPrivateEndpointConnectionResponse, error) {
	result := WebAppsClientGetPrivateEndpointConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemotePrivateEndpointConnectionARMResource); err != nil {
		return WebAppsClientGetPrivateEndpointConnectionResponse{}, err
	}
	return result, nil
}

// NewGetPrivateEndpointConnectionListPager - Description for Gets the list of private endpoint connections associated with
// a site
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// options - WebAppsClientGetPrivateEndpointConnectionListOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnectionList
// method.
func (client *WebAppsClient) NewGetPrivateEndpointConnectionListPager(resourceGroupName string, name string, options *WebAppsClientGetPrivateEndpointConnectionListOptions) *runtime.Pager[WebAppsClientGetPrivateEndpointConnectionListResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientGetPrivateEndpointConnectionListResponse]{
		More: func(page WebAppsClientGetPrivateEndpointConnectionListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientGetPrivateEndpointConnectionListResponse) (WebAppsClientGetPrivateEndpointConnectionListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getPrivateEndpointConnectionListCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientGetPrivateEndpointConnectionListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientGetPrivateEndpointConnectionListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientGetPrivateEndpointConnectionListResponse{}, runtime.NewResponseError(resp)
			}
			return client.getPrivateEndpointConnectionListHandleResponse(resp)
		},
	})
}

// getPrivateEndpointConnectionListCreateRequest creates the GetPrivateEndpointConnectionList request.
func (client *WebAppsClient) getPrivateEndpointConnectionListCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetPrivateEndpointConnectionListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionListHandleResponse handles the GetPrivateEndpointConnectionList response.
func (client *WebAppsClient) getPrivateEndpointConnectionListHandleResponse(resp *http.Response) (WebAppsClientGetPrivateEndpointConnectionListResponse, error) {
	result := WebAppsClientGetPrivateEndpointConnectionListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateEndpointConnectionCollection); err != nil {
		return WebAppsClientGetPrivateEndpointConnectionListResponse{}, err
	}
	return result, nil
}

// NewGetPrivateEndpointConnectionListSlotPager - Description for Gets the list of private endpoint connections associated
// with a site
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// slot - Name of the site deployment slot.
// options - WebAppsClientGetPrivateEndpointConnectionListSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnectionListSlot
// method.
func (client *WebAppsClient) NewGetPrivateEndpointConnectionListSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientGetPrivateEndpointConnectionListSlotOptions) *runtime.Pager[WebAppsClientGetPrivateEndpointConnectionListSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientGetPrivateEndpointConnectionListSlotResponse]{
		More: func(page WebAppsClientGetPrivateEndpointConnectionListSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientGetPrivateEndpointConnectionListSlotResponse) (WebAppsClientGetPrivateEndpointConnectionListSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getPrivateEndpointConnectionListSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientGetPrivateEndpointConnectionListSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientGetPrivateEndpointConnectionListSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientGetPrivateEndpointConnectionListSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.getPrivateEndpointConnectionListSlotHandleResponse(resp)
		},
	})
}

// getPrivateEndpointConnectionListSlotCreateRequest creates the GetPrivateEndpointConnectionListSlot request.
func (client *WebAppsClient) getPrivateEndpointConnectionListSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetPrivateEndpointConnectionListSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionListSlotHandleResponse handles the GetPrivateEndpointConnectionListSlot response.
func (client *WebAppsClient) getPrivateEndpointConnectionListSlotHandleResponse(resp *http.Response) (WebAppsClientGetPrivateEndpointConnectionListSlotResponse, error) {
	result := WebAppsClientGetPrivateEndpointConnectionListSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateEndpointConnectionCollection); err != nil {
		return WebAppsClientGetPrivateEndpointConnectionListSlotResponse{}, err
	}
	return result, nil
}

// GetPrivateEndpointConnectionSlot - Description for Gets a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// privateEndpointConnectionName - Name of the private endpoint connection.
// slot - Name of the site deployment slot.
// options - WebAppsClientGetPrivateEndpointConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnectionSlot
// method.
func (client *WebAppsClient) GetPrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, options *WebAppsClientGetPrivateEndpointConnectionSlotOptions) (WebAppsClientGetPrivateEndpointConnectionSlotResponse, error) {
	req, err := client.getPrivateEndpointConnectionSlotCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, slot, options)
	if err != nil {
		return WebAppsClientGetPrivateEndpointConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPrivateEndpointConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPrivateEndpointConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateEndpointConnectionSlotHandleResponse(resp)
}

// getPrivateEndpointConnectionSlotCreateRequest creates the GetPrivateEndpointConnectionSlot request.
func (client *WebAppsClient) getPrivateEndpointConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string, options *WebAppsClientGetPrivateEndpointConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionSlotHandleResponse handles the GetPrivateEndpointConnectionSlot response.
func (client *WebAppsClient) getPrivateEndpointConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientGetPrivateEndpointConnectionSlotResponse, error) {
	result := WebAppsClientGetPrivateEndpointConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemotePrivateEndpointConnectionARMResource); err != nil {
		return WebAppsClientGetPrivateEndpointConnectionSlotResponse{}, err
	}
	return result, nil
}

// GetPrivateLinkResources - Description for Gets the private link resources
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// options - WebAppsClientGetPrivateLinkResourcesOptions contains the optional parameters for the WebAppsClient.GetPrivateLinkResources
// method.
func (client *WebAppsClient) GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetPrivateLinkResourcesOptions) (WebAppsClientGetPrivateLinkResourcesResponse, error) {
	req, err := client.getPrivateLinkResourcesCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetPrivateLinkResourcesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPrivateLinkResourcesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPrivateLinkResourcesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateLinkResourcesHandleResponse(resp)
}

// getPrivateLinkResourcesCreateRequest creates the GetPrivateLinkResources request.
func (client *WebAppsClient) getPrivateLinkResourcesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetPrivateLinkResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateLinkResources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateLinkResourcesHandleResponse handles the GetPrivateLinkResources response.
func (client *WebAppsClient) getPrivateLinkResourcesHandleResponse(resp *http.Response) (WebAppsClientGetPrivateLinkResourcesResponse, error) {
	result := WebAppsClientGetPrivateLinkResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResourcesWrapper); err != nil {
		return WebAppsClientGetPrivateLinkResourcesResponse{}, err
	}
	return result, nil
}

// GetPrivateLinkResourcesSlot - Description for Gets the private link resources
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the site.
// options - WebAppsClientGetPrivateLinkResourcesSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateLinkResourcesSlot
// method.
func (client *WebAppsClient) GetPrivateLinkResourcesSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetPrivateLinkResourcesSlotOptions) (WebAppsClientGetPrivateLinkResourcesSlotResponse, error) {
	req, err := client.getPrivateLinkResourcesSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetPrivateLinkResourcesSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPrivateLinkResourcesSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPrivateLinkResourcesSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateLinkResourcesSlotHandleResponse(resp)
}

// getPrivateLinkResourcesSlotCreateRequest creates the GetPrivateLinkResourcesSlot request.
func (client *WebAppsClient) getPrivateLinkResourcesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetPrivateLinkResourcesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateLinkResources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateLinkResourcesSlotHandleResponse handles the GetPrivateLinkResourcesSlot response.
func (client *WebAppsClient) getPrivateLinkResourcesSlotHandleResponse(resp *http.Response) (WebAppsClientGetPrivateLinkResourcesSlotResponse, error) {
	result := WebAppsClientGetPrivateLinkResourcesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResourcesWrapper); err != nil {
		return WebAppsClientGetPrivateLinkResourcesSlotResponse{}, err
	}
	return result, nil
}

// GetProcess - Description for Get process information by its ID for a specific scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// options - WebAppsClientGetProcessOptions contains the optional parameters for the WebAppsClient.GetProcess method.
func (client *WebAppsClient) GetProcess(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientGetProcessOptions) (WebAppsClientGetProcessResponse, error) {
	req, err := client.getProcessCreateRequest(ctx, resourceGroupName, name, processID, options)
	if err != nil {
		return WebAppsClientGetProcessResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetProcessResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetProcessResponse{}, runtime.NewResponseError(resp)
	}
	return client.getProcessHandleResponse(resp)
}

// getProcessCreateRequest creates the GetProcess request.
func (client *WebAppsClient) getProcessCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientGetProcessOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getProcessHandleResponse handles the GetProcess response.
func (client *WebAppsClient) getProcessHandleResponse(resp *http.Response) (WebAppsClientGetProcessResponse, error) {
	result := WebAppsClientGetProcessResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfo); err != nil {
		return WebAppsClientGetProcessResponse{}, err
	}
	return result, nil
}

// GetProcessDump - Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// options - WebAppsClientGetProcessDumpOptions contains the optional parameters for the WebAppsClient.GetProcessDump method.
func (client *WebAppsClient) GetProcessDump(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientGetProcessDumpOptions) (WebAppsClientGetProcessDumpResponse, error) {
	req, err := client.getProcessDumpCreateRequest(ctx, resourceGroupName, name, processID, options)
	if err != nil {
		return WebAppsClientGetProcessDumpResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetProcessDumpResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetProcessDumpResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetProcessDumpResponse{Body: resp.Body}, nil
}

// getProcessDumpCreateRequest creates the GetProcessDump request.
func (client *WebAppsClient) getProcessDumpCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientGetProcessDumpOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/dump"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetProcessDumpSlot - Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web
// site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientGetProcessDumpSlotOptions contains the optional parameters for the WebAppsClient.GetProcessDumpSlot
// method.
func (client *WebAppsClient) GetProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientGetProcessDumpSlotOptions) (WebAppsClientGetProcessDumpSlotResponse, error) {
	req, err := client.getProcessDumpSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, options)
	if err != nil {
		return WebAppsClientGetProcessDumpSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetProcessDumpSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetProcessDumpSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetProcessDumpSlotResponse{Body: resp.Body}, nil
}

// getProcessDumpSlotCreateRequest creates the GetProcessDumpSlot request.
func (client *WebAppsClient) getProcessDumpSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientGetProcessDumpSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/dump"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetProcessModule - Description for Get process information by its ID for a specific scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// baseAddress - Module base address.
// options - WebAppsClientGetProcessModuleOptions contains the optional parameters for the WebAppsClient.GetProcessModule
// method.
func (client *WebAppsClient) GetProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, options *WebAppsClientGetProcessModuleOptions) (WebAppsClientGetProcessModuleResponse, error) {
	req, err := client.getProcessModuleCreateRequest(ctx, resourceGroupName, name, processID, baseAddress, options)
	if err != nil {
		return WebAppsClientGetProcessModuleResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetProcessModuleResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetProcessModuleResponse{}, runtime.NewResponseError(resp)
	}
	return client.getProcessModuleHandleResponse(resp)
}

// getProcessModuleCreateRequest creates the GetProcessModule request.
func (client *WebAppsClient) getProcessModuleCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, options *WebAppsClientGetProcessModuleOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules/{baseAddress}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if baseAddress == "" {
		return nil, errors.New("parameter baseAddress cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baseAddress}", url.PathEscape(baseAddress))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getProcessModuleHandleResponse handles the GetProcessModule response.
func (client *WebAppsClient) getProcessModuleHandleResponse(resp *http.Response) (WebAppsClientGetProcessModuleResponse, error) {
	result := WebAppsClientGetProcessModuleResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfo); err != nil {
		return WebAppsClientGetProcessModuleResponse{}, err
	}
	return result, nil
}

// GetProcessModuleSlot - Description for Get process information by its ID for a specific scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// baseAddress - Module base address.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientGetProcessModuleSlotOptions contains the optional parameters for the WebAppsClient.GetProcessModuleSlot
// method.
func (client *WebAppsClient) GetProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, options *WebAppsClientGetProcessModuleSlotOptions) (WebAppsClientGetProcessModuleSlotResponse, error) {
	req, err := client.getProcessModuleSlotCreateRequest(ctx, resourceGroupName, name, processID, baseAddress, slot, options)
	if err != nil {
		return WebAppsClientGetProcessModuleSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetProcessModuleSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetProcessModuleSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getProcessModuleSlotHandleResponse(resp)
}

// getProcessModuleSlotCreateRequest creates the GetProcessModuleSlot request.
func (client *WebAppsClient) getProcessModuleSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, options *WebAppsClientGetProcessModuleSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules/{baseAddress}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if baseAddress == "" {
		return nil, errors.New("parameter baseAddress cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baseAddress}", url.PathEscape(baseAddress))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getProcessModuleSlotHandleResponse handles the GetProcessModuleSlot response.
func (client *WebAppsClient) getProcessModuleSlotHandleResponse(resp *http.Response) (WebAppsClientGetProcessModuleSlotResponse, error) {
	result := WebAppsClientGetProcessModuleSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfo); err != nil {
		return WebAppsClientGetProcessModuleSlotResponse{}, err
	}
	return result, nil
}

// GetProcessSlot - Description for Get process information by its ID for a specific scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientGetProcessSlotOptions contains the optional parameters for the WebAppsClient.GetProcessSlot method.
func (client *WebAppsClient) GetProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientGetProcessSlotOptions) (WebAppsClientGetProcessSlotResponse, error) {
	req, err := client.getProcessSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, options)
	if err != nil {
		return WebAppsClientGetProcessSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetProcessSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetProcessSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getProcessSlotHandleResponse(resp)
}

// getProcessSlotCreateRequest creates the GetProcessSlot request.
func (client *WebAppsClient) getProcessSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientGetProcessSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getProcessSlotHandleResponse handles the GetProcessSlot response.
func (client *WebAppsClient) getProcessSlotHandleResponse(resp *http.Response) (WebAppsClientGetProcessSlotResponse, error) {
	result := WebAppsClientGetProcessSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfo); err != nil {
		return WebAppsClientGetProcessSlotResponse{}, err
	}
	return result, nil
}

// BeginGetProductionSiteDeploymentStatus - Gets the deployment status for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// deploymentStatusID - GUID of the deployment operation.
// options - WebAppsClientBeginGetProductionSiteDeploymentStatusOptions contains the optional parameters for the WebAppsClient.BeginGetProductionSiteDeploymentStatus
// method.
func (client *WebAppsClient) BeginGetProductionSiteDeploymentStatus(ctx context.Context, resourceGroupName string, name string, deploymentStatusID string, options *WebAppsClientBeginGetProductionSiteDeploymentStatusOptions) (*runtime.Poller[WebAppsClientGetProductionSiteDeploymentStatusResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.getProductionSiteDeploymentStatus(ctx, resourceGroupName, name, deploymentStatusID, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientGetProductionSiteDeploymentStatusResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientGetProductionSiteDeploymentStatusResponse](options.ResumeToken, client.pl, nil)
	}
}

// GetProductionSiteDeploymentStatus - Gets the deployment status for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) getProductionSiteDeploymentStatus(ctx context.Context, resourceGroupName string, name string, deploymentStatusID string, options *WebAppsClientBeginGetProductionSiteDeploymentStatusOptions) (*http.Response, error) {
	req, err := client.getProductionSiteDeploymentStatusCreateRequest(ctx, resourceGroupName, name, deploymentStatusID, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// getProductionSiteDeploymentStatusCreateRequest creates the GetProductionSiteDeploymentStatus request.
func (client *WebAppsClient) getProductionSiteDeploymentStatusCreateRequest(ctx context.Context, resourceGroupName string, name string, deploymentStatusID string, options *WebAppsClientBeginGetProductionSiteDeploymentStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deploymentStatus/{deploymentStatusId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if deploymentStatusID == "" {
		return nil, errors.New("parameter deploymentStatusID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStatusId}", url.PathEscape(deploymentStatusID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetPublicCertificate - Description for Get the named public certificate for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// publicCertificateName - Public certificate name.
// options - WebAppsClientGetPublicCertificateOptions contains the optional parameters for the WebAppsClient.GetPublicCertificate
// method.
func (client *WebAppsClient) GetPublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, options *WebAppsClientGetPublicCertificateOptions) (WebAppsClientGetPublicCertificateResponse, error) {
	req, err := client.getPublicCertificateCreateRequest(ctx, resourceGroupName, name, publicCertificateName, options)
	if err != nil {
		return WebAppsClientGetPublicCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPublicCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPublicCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPublicCertificateHandleResponse(resp)
}

// getPublicCertificateCreateRequest creates the GetPublicCertificate request.
func (client *WebAppsClient) getPublicCertificateCreateRequest(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, options *WebAppsClientGetPublicCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if publicCertificateName == "" {
		return nil, errors.New("parameter publicCertificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publicCertificateName}", url.PathEscape(publicCertificateName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPublicCertificateHandleResponse handles the GetPublicCertificate response.
func (client *WebAppsClient) getPublicCertificateHandleResponse(resp *http.Response) (WebAppsClientGetPublicCertificateResponse, error) {
	result := WebAppsClientGetPublicCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublicCertificate); err != nil {
		return WebAppsClientGetPublicCertificateResponse{}, err
	}
	return result, nil
}

// GetPublicCertificateSlot - Description for Get the named public certificate for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API the named binding for the production slot.
// publicCertificateName - Public certificate name.
// options - WebAppsClientGetPublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.GetPublicCertificateSlot
// method.
func (client *WebAppsClient) GetPublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string, options *WebAppsClientGetPublicCertificateSlotOptions) (WebAppsClientGetPublicCertificateSlotResponse, error) {
	req, err := client.getPublicCertificateSlotCreateRequest(ctx, resourceGroupName, name, slot, publicCertificateName, options)
	if err != nil {
		return WebAppsClientGetPublicCertificateSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetPublicCertificateSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetPublicCertificateSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPublicCertificateSlotHandleResponse(resp)
}

// getPublicCertificateSlotCreateRequest creates the GetPublicCertificateSlot request.
func (client *WebAppsClient) getPublicCertificateSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string, options *WebAppsClientGetPublicCertificateSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if publicCertificateName == "" {
		return nil, errors.New("parameter publicCertificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publicCertificateName}", url.PathEscape(publicCertificateName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPublicCertificateSlotHandleResponse handles the GetPublicCertificateSlot response.
func (client *WebAppsClient) getPublicCertificateSlotHandleResponse(resp *http.Response) (WebAppsClientGetPublicCertificateSlotResponse, error) {
	result := WebAppsClientGetPublicCertificateSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublicCertificate); err != nil {
		return WebAppsClientGetPublicCertificateSlotResponse{}, err
	}
	return result, nil
}

// GetRelayServiceConnection - Description for Gets a hybrid connection configuration by its name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// entityName - Name of the hybrid connection.
// options - WebAppsClientGetRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.GetRelayServiceConnection
// method.
func (client *WebAppsClient) GetRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, options *WebAppsClientGetRelayServiceConnectionOptions) (WebAppsClientGetRelayServiceConnectionResponse, error) {
	req, err := client.getRelayServiceConnectionCreateRequest(ctx, resourceGroupName, name, entityName, options)
	if err != nil {
		return WebAppsClientGetRelayServiceConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetRelayServiceConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetRelayServiceConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getRelayServiceConnectionHandleResponse(resp)
}

// getRelayServiceConnectionCreateRequest creates the GetRelayServiceConnection request.
func (client *WebAppsClient) getRelayServiceConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, entityName string, options *WebAppsClientGetRelayServiceConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if entityName == "" {
		return nil, errors.New("parameter entityName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{entityName}", url.PathEscape(entityName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRelayServiceConnectionHandleResponse handles the GetRelayServiceConnection response.
func (client *WebAppsClient) getRelayServiceConnectionHandleResponse(resp *http.Response) (WebAppsClientGetRelayServiceConnectionResponse, error) {
	result := WebAppsClientGetRelayServiceConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RelayServiceConnectionEntity); err != nil {
		return WebAppsClientGetRelayServiceConnectionResponse{}, err
	}
	return result, nil
}

// GetRelayServiceConnectionSlot - Description for Gets a hybrid connection configuration by its name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// entityName - Name of the hybrid connection.
// slot - Name of the deployment slot. If a slot is not specified, the API will get a hybrid connection for the production
// slot.
// options - WebAppsClientGetRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetRelayServiceConnectionSlot
// method.
func (client *WebAppsClient) GetRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, options *WebAppsClientGetRelayServiceConnectionSlotOptions) (WebAppsClientGetRelayServiceConnectionSlotResponse, error) {
	req, err := client.getRelayServiceConnectionSlotCreateRequest(ctx, resourceGroupName, name, entityName, slot, options)
	if err != nil {
		return WebAppsClientGetRelayServiceConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetRelayServiceConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetRelayServiceConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getRelayServiceConnectionSlotHandleResponse(resp)
}

// getRelayServiceConnectionSlotCreateRequest creates the GetRelayServiceConnectionSlot request.
func (client *WebAppsClient) getRelayServiceConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, entityName string, slot string, options *WebAppsClientGetRelayServiceConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if entityName == "" {
		return nil, errors.New("parameter entityName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{entityName}", url.PathEscape(entityName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRelayServiceConnectionSlotHandleResponse handles the GetRelayServiceConnectionSlot response.
func (client *WebAppsClient) getRelayServiceConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientGetRelayServiceConnectionSlotResponse, error) {
	result := WebAppsClientGetRelayServiceConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RelayServiceConnectionEntity); err != nil {
		return WebAppsClientGetRelayServiceConnectionSlotResponse{}, err
	}
	return result, nil
}

// GetScmAllowed - Description for Returns whether Scm basic auth is allowed on the site or not.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetScmAllowedOptions contains the optional parameters for the WebAppsClient.GetScmAllowed method.
func (client *WebAppsClient) GetScmAllowed(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetScmAllowedOptions) (WebAppsClientGetScmAllowedResponse, error) {
	req, err := client.getScmAllowedCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetScmAllowedResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetScmAllowedResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetScmAllowedResponse{}, runtime.NewResponseError(resp)
	}
	return client.getScmAllowedHandleResponse(resp)
}

// getScmAllowedCreateRequest creates the GetScmAllowed request.
func (client *WebAppsClient) getScmAllowedCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetScmAllowedOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/scm"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getScmAllowedHandleResponse handles the GetScmAllowed response.
func (client *WebAppsClient) getScmAllowedHandleResponse(resp *http.Response) (WebAppsClientGetScmAllowedResponse, error) {
	result := WebAppsClientGetScmAllowedResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmPublishingCredentialsPoliciesEntity); err != nil {
		return WebAppsClientGetScmAllowedResponse{}, err
	}
	return result, nil
}

// GetScmAllowedSlot - Description for Returns whether Scm basic auth is allowed on the site or not.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetScmAllowedSlotOptions contains the optional parameters for the WebAppsClient.GetScmAllowedSlot
// method.
func (client *WebAppsClient) GetScmAllowedSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetScmAllowedSlotOptions) (WebAppsClientGetScmAllowedSlotResponse, error) {
	req, err := client.getScmAllowedSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetScmAllowedSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetScmAllowedSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetScmAllowedSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getScmAllowedSlotHandleResponse(resp)
}

// getScmAllowedSlotCreateRequest creates the GetScmAllowedSlot request.
func (client *WebAppsClient) getScmAllowedSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetScmAllowedSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/scm"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getScmAllowedSlotHandleResponse handles the GetScmAllowedSlot response.
func (client *WebAppsClient) getScmAllowedSlotHandleResponse(resp *http.Response) (WebAppsClientGetScmAllowedSlotResponse, error) {
	result := WebAppsClientGetScmAllowedSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmPublishingCredentialsPoliciesEntity); err != nil {
		return WebAppsClientGetScmAllowedSlotResponse{}, err
	}
	return result, nil
}

// GetSiteConnectionStringKeyVaultReference - Description for Gets the config reference and status of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetSiteConnectionStringKeyVaultReferenceOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReference
// method.
func (client *WebAppsClient) GetSiteConnectionStringKeyVaultReference(ctx context.Context, resourceGroupName string, name string, connectionStringKey string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferenceOptions) (WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse, error) {
	req, err := client.getSiteConnectionStringKeyVaultReferenceCreateRequest(ctx, resourceGroupName, name, connectionStringKey, options)
	if err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteConnectionStringKeyVaultReferenceHandleResponse(resp)
}

// getSiteConnectionStringKeyVaultReferenceCreateRequest creates the GetSiteConnectionStringKeyVaultReference request.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferenceCreateRequest(ctx context.Context, resourceGroupName string, name string, connectionStringKey string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferenceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/connectionstrings/{connectionStringKey}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if connectionStringKey == "" {
		return nil, errors.New("parameter connectionStringKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionStringKey}", url.PathEscape(connectionStringKey))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteConnectionStringKeyVaultReferenceHandleResponse handles the GetSiteConnectionStringKeyVaultReference response.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferenceHandleResponse(resp *http.Response) (WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse, error) {
	result := WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReference); err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse{}, err
	}
	return result, nil
}

// GetSiteConnectionStringKeyVaultReferenceSlot - Description for Gets the config reference and status of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReferenceSlot
// method.
func (client *WebAppsClient) GetSiteConnectionStringKeyVaultReferenceSlot(ctx context.Context, resourceGroupName string, name string, connectionStringKey string, slot string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotOptions) (WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse, error) {
	req, err := client.getSiteConnectionStringKeyVaultReferenceSlotCreateRequest(ctx, resourceGroupName, name, connectionStringKey, slot, options)
	if err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteConnectionStringKeyVaultReferenceSlotHandleResponse(resp)
}

// getSiteConnectionStringKeyVaultReferenceSlotCreateRequest creates the GetSiteConnectionStringKeyVaultReferenceSlot request.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferenceSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, connectionStringKey string, slot string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/connectionstrings/{connectionStringKey}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if connectionStringKey == "" {
		return nil, errors.New("parameter connectionStringKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionStringKey}", url.PathEscape(connectionStringKey))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteConnectionStringKeyVaultReferenceSlotHandleResponse handles the GetSiteConnectionStringKeyVaultReferenceSlot response.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferenceSlotHandleResponse(resp *http.Response) (WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse, error) {
	result := WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReference); err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse{}, err
	}
	return result, nil
}

// NewGetSiteConnectionStringKeyVaultReferencesPager - Description for Gets the config reference app settings and status of
// an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetSiteConnectionStringKeyVaultReferencesOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReferences
// method.
func (client *WebAppsClient) NewGetSiteConnectionStringKeyVaultReferencesPager(resourceGroupName string, name string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferencesOptions) *runtime.Pager[WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse]{
		More: func(page WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse) (WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getSiteConnectionStringKeyVaultReferencesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse{}, runtime.NewResponseError(resp)
			}
			return client.getSiteConnectionStringKeyVaultReferencesHandleResponse(resp)
		},
	})
}

// getSiteConnectionStringKeyVaultReferencesCreateRequest creates the GetSiteConnectionStringKeyVaultReferences request.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferencesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferencesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/connectionstrings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteConnectionStringKeyVaultReferencesHandleResponse handles the GetSiteConnectionStringKeyVaultReferences response.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferencesHandleResponse(resp *http.Response) (WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse, error) {
	result := WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReferenceCollection); err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse{}, err
	}
	return result, nil
}

// NewGetSiteConnectionStringKeyVaultReferencesSlotPager - Description for Gets the config reference app settings and status
// of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReferencesSlot
// method.
func (client *WebAppsClient) NewGetSiteConnectionStringKeyVaultReferencesSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotOptions) *runtime.Pager[WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse]{
		More: func(page WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse) (WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getSiteConnectionStringKeyVaultReferencesSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.getSiteConnectionStringKeyVaultReferencesSlotHandleResponse(resp)
		},
	})
}

// getSiteConnectionStringKeyVaultReferencesSlotCreateRequest creates the GetSiteConnectionStringKeyVaultReferencesSlot request.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferencesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/connectionstrings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteConnectionStringKeyVaultReferencesSlotHandleResponse handles the GetSiteConnectionStringKeyVaultReferencesSlot response.
func (client *WebAppsClient) getSiteConnectionStringKeyVaultReferencesSlotHandleResponse(resp *http.Response) (WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse, error) {
	result := WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APIKVReferenceCollection); err != nil {
		return WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse{}, err
	}
	return result, nil
}

// GetSiteExtension - Description for Get site extension information by its ID for a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// siteExtensionID - Site extension name.
// options - WebAppsClientGetSiteExtensionOptions contains the optional parameters for the WebAppsClient.GetSiteExtension
// method.
func (client *WebAppsClient) GetSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *WebAppsClientGetSiteExtensionOptions) (WebAppsClientGetSiteExtensionResponse, error) {
	req, err := client.getSiteExtensionCreateRequest(ctx, resourceGroupName, name, siteExtensionID, options)
	if err != nil {
		return WebAppsClientGetSiteExtensionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSiteExtensionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSiteExtensionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteExtensionHandleResponse(resp)
}

// getSiteExtensionCreateRequest creates the GetSiteExtension request.
func (client *WebAppsClient) getSiteExtensionCreateRequest(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *WebAppsClientGetSiteExtensionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if siteExtensionID == "" {
		return nil, errors.New("parameter siteExtensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteExtensionId}", url.PathEscape(siteExtensionID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteExtensionHandleResponse handles the GetSiteExtension response.
func (client *WebAppsClient) getSiteExtensionHandleResponse(resp *http.Response) (WebAppsClientGetSiteExtensionResponse, error) {
	result := WebAppsClientGetSiteExtensionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteExtensionInfo); err != nil {
		return WebAppsClientGetSiteExtensionResponse{}, err
	}
	return result, nil
}

// GetSiteExtensionSlot - Description for Get site extension information by its ID for a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// siteExtensionID - Site extension name.
// slot - Name of the deployment slot. If a slot is not specified, the API uses the production slot.
// options - WebAppsClientGetSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.GetSiteExtensionSlot
// method.
func (client *WebAppsClient) GetSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *WebAppsClientGetSiteExtensionSlotOptions) (WebAppsClientGetSiteExtensionSlotResponse, error) {
	req, err := client.getSiteExtensionSlotCreateRequest(ctx, resourceGroupName, name, siteExtensionID, slot, options)
	if err != nil {
		return WebAppsClientGetSiteExtensionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSiteExtensionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSiteExtensionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSiteExtensionSlotHandleResponse(resp)
}

// getSiteExtensionSlotCreateRequest creates the GetSiteExtensionSlot request.
func (client *WebAppsClient) getSiteExtensionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *WebAppsClientGetSiteExtensionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if siteExtensionID == "" {
		return nil, errors.New("parameter siteExtensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteExtensionId}", url.PathEscape(siteExtensionID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSiteExtensionSlotHandleResponse handles the GetSiteExtensionSlot response.
func (client *WebAppsClient) getSiteExtensionSlotHandleResponse(resp *http.Response) (WebAppsClientGetSiteExtensionSlotResponse, error) {
	result := WebAppsClientGetSiteExtensionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteExtensionInfo); err != nil {
		return WebAppsClientGetSiteExtensionSlotResponse{}, err
	}
	return result, nil
}

// GetSitePhpErrorLogFlag - Description for Gets web app's event logs.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetSitePhpErrorLogFlagOptions contains the optional parameters for the WebAppsClient.GetSitePhpErrorLogFlag
// method.
func (client *WebAppsClient) GetSitePhpErrorLogFlag(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetSitePhpErrorLogFlagOptions) (WebAppsClientGetSitePhpErrorLogFlagResponse, error) {
	req, err := client.getSitePhpErrorLogFlagCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetSitePhpErrorLogFlagResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSitePhpErrorLogFlagResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSitePhpErrorLogFlagResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSitePhpErrorLogFlagHandleResponse(resp)
}

// getSitePhpErrorLogFlagCreateRequest creates the GetSitePhpErrorLogFlag request.
func (client *WebAppsClient) getSitePhpErrorLogFlagCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetSitePhpErrorLogFlagOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSitePhpErrorLogFlagHandleResponse handles the GetSitePhpErrorLogFlag response.
func (client *WebAppsClient) getSitePhpErrorLogFlagHandleResponse(resp *http.Response) (WebAppsClientGetSitePhpErrorLogFlagResponse, error) {
	result := WebAppsClientGetSitePhpErrorLogFlagResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SitePhpErrorLogFlag); err != nil {
		return WebAppsClientGetSitePhpErrorLogFlagResponse{}, err
	}
	return result, nil
}

// GetSitePhpErrorLogFlagSlot - Description for Gets web app's event logs.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientGetSitePhpErrorLogFlagSlotOptions contains the optional parameters for the WebAppsClient.GetSitePhpErrorLogFlagSlot
// method.
func (client *WebAppsClient) GetSitePhpErrorLogFlagSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSitePhpErrorLogFlagSlotOptions) (WebAppsClientGetSitePhpErrorLogFlagSlotResponse, error) {
	req, err := client.getSitePhpErrorLogFlagSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetSitePhpErrorLogFlagSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSitePhpErrorLogFlagSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSitePhpErrorLogFlagSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSitePhpErrorLogFlagSlotHandleResponse(resp)
}

// getSitePhpErrorLogFlagSlotCreateRequest creates the GetSitePhpErrorLogFlagSlot request.
func (client *WebAppsClient) getSitePhpErrorLogFlagSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSitePhpErrorLogFlagSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSitePhpErrorLogFlagSlotHandleResponse handles the GetSitePhpErrorLogFlagSlot response.
func (client *WebAppsClient) getSitePhpErrorLogFlagSlotHandleResponse(resp *http.Response) (WebAppsClientGetSitePhpErrorLogFlagSlotResponse, error) {
	result := WebAppsClientGetSitePhpErrorLogFlagSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SitePhpErrorLogFlag); err != nil {
		return WebAppsClientGetSitePhpErrorLogFlagSlotResponse{}, err
	}
	return result, nil
}

// GetSlot - Description for Gets the details of a web, mobile, or API app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. By default, this API returns the production slot.
// options - WebAppsClientGetSlotOptions contains the optional parameters for the WebAppsClient.GetSlot method.
func (client *WebAppsClient) GetSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSlotOptions) (WebAppsClientGetSlotResponse, error) {
	req, err := client.getSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSlotHandleResponse(resp)
}

// getSlotCreateRequest creates the GetSlot request.
func (client *WebAppsClient) getSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSlotHandleResponse handles the GetSlot response.
func (client *WebAppsClient) getSlotHandleResponse(resp *http.Response) (WebAppsClientGetSlotResponse, error) {
	result := WebAppsClientGetSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Site); err != nil {
		return WebAppsClientGetSlotResponse{}, err
	}
	return result, nil
}

// BeginGetSlotSiteDeploymentStatusSlot - Gets the deployment status for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the deployment status for the production
// slot.
// deploymentStatusID - GUID of the deployment operation.
// options - WebAppsClientBeginGetSlotSiteDeploymentStatusSlotOptions contains the optional parameters for the WebAppsClient.BeginGetSlotSiteDeploymentStatusSlot
// method.
func (client *WebAppsClient) BeginGetSlotSiteDeploymentStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, deploymentStatusID string, options *WebAppsClientBeginGetSlotSiteDeploymentStatusSlotOptions) (*runtime.Poller[WebAppsClientGetSlotSiteDeploymentStatusSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.getSlotSiteDeploymentStatusSlot(ctx, resourceGroupName, name, slot, deploymentStatusID, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientGetSlotSiteDeploymentStatusSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientGetSlotSiteDeploymentStatusSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// GetSlotSiteDeploymentStatusSlot - Gets the deployment status for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) getSlotSiteDeploymentStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, deploymentStatusID string, options *WebAppsClientBeginGetSlotSiteDeploymentStatusSlotOptions) (*http.Response, error) {
	req, err := client.getSlotSiteDeploymentStatusSlotCreateRequest(ctx, resourceGroupName, name, slot, deploymentStatusID, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// getSlotSiteDeploymentStatusSlotCreateRequest creates the GetSlotSiteDeploymentStatusSlot request.
func (client *WebAppsClient) getSlotSiteDeploymentStatusSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, deploymentStatusID string, options *WebAppsClientBeginGetSlotSiteDeploymentStatusSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deploymentStatus/{deploymentStatusId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if deploymentStatusID == "" {
		return nil, errors.New("parameter deploymentStatusID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStatusId}", url.PathEscape(deploymentStatusID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetSourceControl - Description for Gets the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetSourceControlOptions contains the optional parameters for the WebAppsClient.GetSourceControl
// method.
func (client *WebAppsClient) GetSourceControl(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetSourceControlOptions) (WebAppsClientGetSourceControlResponse, error) {
	req, err := client.getSourceControlCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetSourceControlResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSourceControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return WebAppsClientGetSourceControlResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSourceControlHandleResponse(resp)
}

// getSourceControlCreateRequest creates the GetSourceControl request.
func (client *WebAppsClient) getSourceControlCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetSourceControlOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSourceControlHandleResponse handles the GetSourceControl response.
func (client *WebAppsClient) getSourceControlHandleResponse(resp *http.Response) (WebAppsClientGetSourceControlResponse, error) {
	result := WebAppsClientGetSourceControlResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteSourceControl); err != nil {
		return WebAppsClientGetSourceControlResponse{}, err
	}
	return result, nil
}

// GetSourceControlSlot - Description for Gets the source control configuration of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the source control configuration for the
// production slot.
// options - WebAppsClientGetSourceControlSlotOptions contains the optional parameters for the WebAppsClient.GetSourceControlSlot
// method.
func (client *WebAppsClient) GetSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSourceControlSlotOptions) (WebAppsClientGetSourceControlSlotResponse, error) {
	req, err := client.getSourceControlSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetSourceControlSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSourceControlSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return WebAppsClientGetSourceControlSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSourceControlSlotHandleResponse(resp)
}

// getSourceControlSlotCreateRequest creates the GetSourceControlSlot request.
func (client *WebAppsClient) getSourceControlSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSourceControlSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSourceControlSlotHandleResponse handles the GetSourceControlSlot response.
func (client *WebAppsClient) getSourceControlSlotHandleResponse(resp *http.Response) (WebAppsClientGetSourceControlSlotResponse, error) {
	result := WebAppsClientGetSourceControlSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteSourceControl); err != nil {
		return WebAppsClientGetSourceControlSlotResponse{}, err
	}
	return result, nil
}

// GetSwiftVirtualNetworkConnection - Description for Gets a Swift Virtual Network connection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientGetSwiftVirtualNetworkConnectionOptions contains the optional parameters for the WebAppsClient.GetSwiftVirtualNetworkConnection
// method.
func (client *WebAppsClient) GetSwiftVirtualNetworkConnection(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetSwiftVirtualNetworkConnectionOptions) (WebAppsClientGetSwiftVirtualNetworkConnectionResponse, error) {
	req, err := client.getSwiftVirtualNetworkConnectionCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetSwiftVirtualNetworkConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSwiftVirtualNetworkConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSwiftVirtualNetworkConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSwiftVirtualNetworkConnectionHandleResponse(resp)
}

// getSwiftVirtualNetworkConnectionCreateRequest creates the GetSwiftVirtualNetworkConnection request.
func (client *WebAppsClient) getSwiftVirtualNetworkConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetSwiftVirtualNetworkConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSwiftVirtualNetworkConnectionHandleResponse handles the GetSwiftVirtualNetworkConnection response.
func (client *WebAppsClient) getSwiftVirtualNetworkConnectionHandleResponse(resp *http.Response) (WebAppsClientGetSwiftVirtualNetworkConnectionResponse, error) {
	result := WebAppsClientGetSwiftVirtualNetworkConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SwiftVirtualNetwork); err != nil {
		return WebAppsClientGetSwiftVirtualNetworkConnectionResponse{}, err
	}
	return result, nil
}

// GetSwiftVirtualNetworkConnectionSlot - Description for Gets a Swift Virtual Network connection.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get a gateway for the production slot's Virtual
// Network.
// options - WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetSwiftVirtualNetworkConnectionSlot
// method.
func (client *WebAppsClient) GetSwiftVirtualNetworkConnectionSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions) (WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse, error) {
	req, err := client.getSwiftVirtualNetworkConnectionSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSwiftVirtualNetworkConnectionSlotHandleResponse(resp)
}

// getSwiftVirtualNetworkConnectionSlotCreateRequest creates the GetSwiftVirtualNetworkConnectionSlot request.
func (client *WebAppsClient) getSwiftVirtualNetworkConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSwiftVirtualNetworkConnectionSlotHandleResponse handles the GetSwiftVirtualNetworkConnectionSlot response.
func (client *WebAppsClient) getSwiftVirtualNetworkConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse, error) {
	result := WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SwiftVirtualNetwork); err != nil {
		return WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse{}, err
	}
	return result, nil
}

// GetTriggeredWebJob - Description for Gets a triggered web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// options - WebAppsClientGetTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJob
// method.
func (client *WebAppsClient) GetTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientGetTriggeredWebJobOptions) (WebAppsClientGetTriggeredWebJobResponse, error) {
	req, err := client.getTriggeredWebJobCreateRequest(ctx, resourceGroupName, name, webJobName, options)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetTriggeredWebJobResponse{}, runtime.NewResponseError(resp)
	}
	return client.getTriggeredWebJobHandleResponse(resp)
}

// getTriggeredWebJobCreateRequest creates the GetTriggeredWebJob request.
func (client *WebAppsClient) getTriggeredWebJobCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientGetTriggeredWebJobOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getTriggeredWebJobHandleResponse handles the GetTriggeredWebJob response.
func (client *WebAppsClient) getTriggeredWebJobHandleResponse(resp *http.Response) (WebAppsClientGetTriggeredWebJobResponse, error) {
	result := WebAppsClientGetTriggeredWebJobResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TriggeredWebJob); err != nil {
		return WebAppsClientGetTriggeredWebJobResponse{}, err
	}
	return result, nil
}

// GetTriggeredWebJobHistory - Description for Gets a triggered web job's history by its ID for an app, , or a deployment
// slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// id - History ID.
// options - WebAppsClientGetTriggeredWebJobHistoryOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobHistory
// method.
func (client *WebAppsClient) GetTriggeredWebJobHistory(ctx context.Context, resourceGroupName string, name string, webJobName string, id string, options *WebAppsClientGetTriggeredWebJobHistoryOptions) (WebAppsClientGetTriggeredWebJobHistoryResponse, error) {
	req, err := client.getTriggeredWebJobHistoryCreateRequest(ctx, resourceGroupName, name, webJobName, id, options)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobHistoryResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobHistoryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetTriggeredWebJobHistoryResponse{}, runtime.NewResponseError(resp)
	}
	return client.getTriggeredWebJobHistoryHandleResponse(resp)
}

// getTriggeredWebJobHistoryCreateRequest creates the GetTriggeredWebJobHistory request.
func (client *WebAppsClient) getTriggeredWebJobHistoryCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, id string, options *WebAppsClientGetTriggeredWebJobHistoryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getTriggeredWebJobHistoryHandleResponse handles the GetTriggeredWebJobHistory response.
func (client *WebAppsClient) getTriggeredWebJobHistoryHandleResponse(resp *http.Response) (WebAppsClientGetTriggeredWebJobHistoryResponse, error) {
	result := WebAppsClientGetTriggeredWebJobHistoryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TriggeredJobHistory); err != nil {
		return WebAppsClientGetTriggeredWebJobHistoryResponse{}, err
	}
	return result, nil
}

// GetTriggeredWebJobHistorySlot - Description for Gets a triggered web job's history by its ID for an app, , or a deployment
// slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// id - History ID.
// slot - Name of the deployment slot. If a slot is not specified, the API uses the production slot.
// options - WebAppsClientGetTriggeredWebJobHistorySlotOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobHistorySlot
// method.
func (client *WebAppsClient) GetTriggeredWebJobHistorySlot(ctx context.Context, resourceGroupName string, name string, webJobName string, id string, slot string, options *WebAppsClientGetTriggeredWebJobHistorySlotOptions) (WebAppsClientGetTriggeredWebJobHistorySlotResponse, error) {
	req, err := client.getTriggeredWebJobHistorySlotCreateRequest(ctx, resourceGroupName, name, webJobName, id, slot, options)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobHistorySlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobHistorySlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetTriggeredWebJobHistorySlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getTriggeredWebJobHistorySlotHandleResponse(resp)
}

// getTriggeredWebJobHistorySlotCreateRequest creates the GetTriggeredWebJobHistorySlot request.
func (client *WebAppsClient) getTriggeredWebJobHistorySlotCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, id string, slot string, options *WebAppsClientGetTriggeredWebJobHistorySlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history/{id}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getTriggeredWebJobHistorySlotHandleResponse handles the GetTriggeredWebJobHistorySlot response.
func (client *WebAppsClient) getTriggeredWebJobHistorySlotHandleResponse(resp *http.Response) (WebAppsClientGetTriggeredWebJobHistorySlotResponse, error) {
	result := WebAppsClientGetTriggeredWebJobHistorySlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TriggeredJobHistory); err != nil {
		return WebAppsClientGetTriggeredWebJobHistorySlotResponse{}, err
	}
	return result, nil
}

// GetTriggeredWebJobSlot - Description for Gets a triggered web job by its ID for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of Web Job.
// slot - Name of the deployment slot. If a slot is not specified, the API uses the production slot.
// options - WebAppsClientGetTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobSlot
// method.
func (client *WebAppsClient) GetTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientGetTriggeredWebJobSlotOptions) (WebAppsClientGetTriggeredWebJobSlotResponse, error) {
	req, err := client.getTriggeredWebJobSlotCreateRequest(ctx, resourceGroupName, name, webJobName, slot, options)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetTriggeredWebJobSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetTriggeredWebJobSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getTriggeredWebJobSlotHandleResponse(resp)
}

// getTriggeredWebJobSlotCreateRequest creates the GetTriggeredWebJobSlot request.
func (client *WebAppsClient) getTriggeredWebJobSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientGetTriggeredWebJobSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getTriggeredWebJobSlotHandleResponse handles the GetTriggeredWebJobSlot response.
func (client *WebAppsClient) getTriggeredWebJobSlotHandleResponse(resp *http.Response) (WebAppsClientGetTriggeredWebJobSlotResponse, error) {
	result := WebAppsClientGetTriggeredWebJobSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TriggeredWebJob); err != nil {
		return WebAppsClientGetTriggeredWebJobSlotResponse{}, err
	}
	return result, nil
}

// GetVnetConnection - Description for Gets a virtual network the app (or deployment slot) is connected to by name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the virtual network.
// options - WebAppsClientGetVnetConnectionOptions contains the optional parameters for the WebAppsClient.GetVnetConnection
// method.
func (client *WebAppsClient) GetVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, options *WebAppsClientGetVnetConnectionOptions) (WebAppsClientGetVnetConnectionResponse, error) {
	req, err := client.getVnetConnectionCreateRequest(ctx, resourceGroupName, name, vnetName, options)
	if err != nil {
		return WebAppsClientGetVnetConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetVnetConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetVnetConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getVnetConnectionHandleResponse(resp)
}

// getVnetConnectionCreateRequest creates the GetVnetConnection request.
func (client *WebAppsClient) getVnetConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, options *WebAppsClientGetVnetConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVnetConnectionHandleResponse handles the GetVnetConnection response.
func (client *WebAppsClient) getVnetConnectionHandleResponse(resp *http.Response) (WebAppsClientGetVnetConnectionResponse, error) {
	result := WebAppsClientGetVnetConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetInfoResource); err != nil {
		return WebAppsClientGetVnetConnectionResponse{}, err
	}
	return result, nil
}

// GetVnetConnectionGateway - Description for Gets an app's Virtual Network gateway.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the Virtual Network.
// gatewayName - Name of the gateway. Currently, the only supported string is "primary".
// options - WebAppsClientGetVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionGateway
// method.
func (client *WebAppsClient) GetVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, options *WebAppsClientGetVnetConnectionGatewayOptions) (WebAppsClientGetVnetConnectionGatewayResponse, error) {
	req, err := client.getVnetConnectionGatewayCreateRequest(ctx, resourceGroupName, name, vnetName, gatewayName, options)
	if err != nil {
		return WebAppsClientGetVnetConnectionGatewayResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetVnetConnectionGatewayResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetVnetConnectionGatewayResponse{}, runtime.NewResponseError(resp)
	}
	return client.getVnetConnectionGatewayHandleResponse(resp)
}

// getVnetConnectionGatewayCreateRequest creates the GetVnetConnectionGateway request.
func (client *WebAppsClient) getVnetConnectionGatewayCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, options *WebAppsClientGetVnetConnectionGatewayOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if gatewayName == "" {
		return nil, errors.New("parameter gatewayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gatewayName}", url.PathEscape(gatewayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVnetConnectionGatewayHandleResponse handles the GetVnetConnectionGateway response.
func (client *WebAppsClient) getVnetConnectionGatewayHandleResponse(resp *http.Response) (WebAppsClientGetVnetConnectionGatewayResponse, error) {
	result := WebAppsClientGetVnetConnectionGatewayResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetGateway); err != nil {
		return WebAppsClientGetVnetConnectionGatewayResponse{}, err
	}
	return result, nil
}

// GetVnetConnectionGatewaySlot - Description for Gets an app's Virtual Network gateway.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the Virtual Network.
// gatewayName - Name of the gateway. Currently, the only supported string is "primary".
// slot - Name of the deployment slot. If a slot is not specified, the API will get a gateway for the production slot's Virtual
// Network.
// options - WebAppsClientGetVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionGatewaySlot
// method.
func (client *WebAppsClient) GetVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string, options *WebAppsClientGetVnetConnectionGatewaySlotOptions) (WebAppsClientGetVnetConnectionGatewaySlotResponse, error) {
	req, err := client.getVnetConnectionGatewaySlotCreateRequest(ctx, resourceGroupName, name, vnetName, gatewayName, slot, options)
	if err != nil {
		return WebAppsClientGetVnetConnectionGatewaySlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetVnetConnectionGatewaySlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetVnetConnectionGatewaySlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getVnetConnectionGatewaySlotHandleResponse(resp)
}

// getVnetConnectionGatewaySlotCreateRequest creates the GetVnetConnectionGatewaySlot request.
func (client *WebAppsClient) getVnetConnectionGatewaySlotCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string, options *WebAppsClientGetVnetConnectionGatewaySlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if gatewayName == "" {
		return nil, errors.New("parameter gatewayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gatewayName}", url.PathEscape(gatewayName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVnetConnectionGatewaySlotHandleResponse handles the GetVnetConnectionGatewaySlot response.
func (client *WebAppsClient) getVnetConnectionGatewaySlotHandleResponse(resp *http.Response) (WebAppsClientGetVnetConnectionGatewaySlotResponse, error) {
	result := WebAppsClientGetVnetConnectionGatewaySlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetGateway); err != nil {
		return WebAppsClientGetVnetConnectionGatewaySlotResponse{}, err
	}
	return result, nil
}

// GetVnetConnectionSlot - Description for Gets a virtual network the app (or deployment slot) is connected to by name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// vnetName - Name of the virtual network.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the named virtual network for the production
// slot.
// options - WebAppsClientGetVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionSlot
// method.
func (client *WebAppsClient) GetVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, options *WebAppsClientGetVnetConnectionSlotOptions) (WebAppsClientGetVnetConnectionSlotResponse, error) {
	req, err := client.getVnetConnectionSlotCreateRequest(ctx, resourceGroupName, name, vnetName, slot, options)
	if err != nil {
		return WebAppsClientGetVnetConnectionSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetVnetConnectionSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetVnetConnectionSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getVnetConnectionSlotHandleResponse(resp)
}

// getVnetConnectionSlotCreateRequest creates the GetVnetConnectionSlot request.
func (client *WebAppsClient) getVnetConnectionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string, options *WebAppsClientGetVnetConnectionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVnetConnectionSlotHandleResponse handles the GetVnetConnectionSlot response.
func (client *WebAppsClient) getVnetConnectionSlotHandleResponse(resp *http.Response) (WebAppsClientGetVnetConnectionSlotResponse, error) {
	result := WebAppsClientGetVnetConnectionSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetInfoResource); err != nil {
		return WebAppsClientGetVnetConnectionSlotResponse{}, err
	}
	return result, nil
}

// GetWebJob - Description for Get webjob information for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of the web job.
// options - WebAppsClientGetWebJobOptions contains the optional parameters for the WebAppsClient.GetWebJob method.
func (client *WebAppsClient) GetWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientGetWebJobOptions) (WebAppsClientGetWebJobResponse, error) {
	req, err := client.getWebJobCreateRequest(ctx, resourceGroupName, name, webJobName, options)
	if err != nil {
		return WebAppsClientGetWebJobResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetWebJobResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetWebJobResponse{}, runtime.NewResponseError(resp)
	}
	return client.getWebJobHandleResponse(resp)
}

// getWebJobCreateRequest creates the GetWebJob request.
func (client *WebAppsClient) getWebJobCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, options *WebAppsClientGetWebJobOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getWebJobHandleResponse handles the GetWebJob response.
func (client *WebAppsClient) getWebJobHandleResponse(resp *http.Response) (WebAppsClientGetWebJobResponse, error) {
	result := WebAppsClientGetWebJobResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebJob); err != nil {
		return WebAppsClientGetWebJobResponse{}, err
	}
	return result, nil
}

// GetWebJobSlot - Description for Get webjob information for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// webJobName - Name of the web job.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientGetWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetWebJobSlot method.
func (client *WebAppsClient) GetWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientGetWebJobSlotOptions) (WebAppsClientGetWebJobSlotResponse, error) {
	req, err := client.getWebJobSlotCreateRequest(ctx, resourceGroupName, name, webJobName, slot, options)
	if err != nil {
		return WebAppsClientGetWebJobSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetWebJobSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientGetWebJobSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.getWebJobSlotHandleResponse(resp)
}

// getWebJobSlotCreateRequest creates the GetWebJobSlot request.
func (client *WebAppsClient) getWebJobSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string, options *WebAppsClientGetWebJobSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs/{webJobName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if webJobName == "" {
		return nil, errors.New("parameter webJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{webJobName}", url.PathEscape(webJobName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getWebJobSlotHandleResponse handles the GetWebJobSlot response.
func (client *WebAppsClient) getWebJobSlotHandleResponse(resp *http.Response) (WebAppsClientGetWebJobSlotResponse, error) {
	result := WebAppsClientGetWebJobSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebJob); err != nil {
		return WebAppsClientGetWebJobSlotResponse{}, err
	}
	return result, nil
}

// GetWebSiteContainerLogs - Description for Gets the last lines of docker logs for the given site
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientGetWebSiteContainerLogsOptions contains the optional parameters for the WebAppsClient.GetWebSiteContainerLogs
// method.
func (client *WebAppsClient) GetWebSiteContainerLogs(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetWebSiteContainerLogsOptions) (WebAppsClientGetWebSiteContainerLogsResponse, error) {
	req, err := client.getWebSiteContainerLogsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientGetWebSiteContainerLogsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetWebSiteContainerLogsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientGetWebSiteContainerLogsResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetWebSiteContainerLogsResponse{Body: resp.Body}, nil
}

// getWebSiteContainerLogsCreateRequest creates the GetWebSiteContainerLogs request.
func (client *WebAppsClient) getWebSiteContainerLogsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientGetWebSiteContainerLogsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/octet-stream"}
	return req, nil
}

// GetWebSiteContainerLogsSlot - Description for Gets the last lines of docker logs for the given site
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientGetWebSiteContainerLogsSlotOptions contains the optional parameters for the WebAppsClient.GetWebSiteContainerLogsSlot
// method.
func (client *WebAppsClient) GetWebSiteContainerLogsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetWebSiteContainerLogsSlotOptions) (WebAppsClientGetWebSiteContainerLogsSlotResponse, error) {
	req, err := client.getWebSiteContainerLogsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientGetWebSiteContainerLogsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientGetWebSiteContainerLogsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return WebAppsClientGetWebSiteContainerLogsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientGetWebSiteContainerLogsSlotResponse{Body: resp.Body}, nil
}

// getWebSiteContainerLogsSlotCreateRequest creates the GetWebSiteContainerLogsSlot request.
func (client *WebAppsClient) getWebSiteContainerLogsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientGetWebSiteContainerLogsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/octet-stream"}
	return req, nil
}

// BeginInstallSiteExtension - Description for Install site extension on a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// siteExtensionID - Site extension name.
// options - WebAppsClientBeginInstallSiteExtensionOptions contains the optional parameters for the WebAppsClient.BeginInstallSiteExtension
// method.
func (client *WebAppsClient) BeginInstallSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *WebAppsClientBeginInstallSiteExtensionOptions) (*runtime.Poller[WebAppsClientInstallSiteExtensionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.installSiteExtension(ctx, resourceGroupName, name, siteExtensionID, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientInstallSiteExtensionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientInstallSiteExtensionResponse](options.ResumeToken, client.pl, nil)
	}
}

// InstallSiteExtension - Description for Install site extension on a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) installSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *WebAppsClientBeginInstallSiteExtensionOptions) (*http.Response, error) {
	req, err := client.installSiteExtensionCreateRequest(ctx, resourceGroupName, name, siteExtensionID, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// installSiteExtensionCreateRequest creates the InstallSiteExtension request.
func (client *WebAppsClient) installSiteExtensionCreateRequest(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, options *WebAppsClientBeginInstallSiteExtensionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if siteExtensionID == "" {
		return nil, errors.New("parameter siteExtensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteExtensionId}", url.PathEscape(siteExtensionID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginInstallSiteExtensionSlot - Description for Install site extension on a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// siteExtensionID - Site extension name.
// slot - Name of the deployment slot. If a slot is not specified, the API uses the production slot.
// options - WebAppsClientBeginInstallSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.BeginInstallSiteExtensionSlot
// method.
func (client *WebAppsClient) BeginInstallSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *WebAppsClientBeginInstallSiteExtensionSlotOptions) (*runtime.Poller[WebAppsClientInstallSiteExtensionSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.installSiteExtensionSlot(ctx, resourceGroupName, name, siteExtensionID, slot, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientInstallSiteExtensionSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientInstallSiteExtensionSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// InstallSiteExtensionSlot - Description for Install site extension on a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) installSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *WebAppsClientBeginInstallSiteExtensionSlotOptions) (*http.Response, error) {
	req, err := client.installSiteExtensionSlotCreateRequest(ctx, resourceGroupName, name, siteExtensionID, slot, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// installSiteExtensionSlotCreateRequest creates the InstallSiteExtensionSlot request.
func (client *WebAppsClient) installSiteExtensionSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string, options *WebAppsClientBeginInstallSiteExtensionSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if siteExtensionID == "" {
		return nil, errors.New("parameter siteExtensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteExtensionId}", url.PathEscape(siteExtensionID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// IsCloneable - Description for Shows whether an app can be cloned to another resource group or subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientIsCloneableOptions contains the optional parameters for the WebAppsClient.IsCloneable method.
func (client *WebAppsClient) IsCloneable(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientIsCloneableOptions) (WebAppsClientIsCloneableResponse, error) {
	req, err := client.isCloneableCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientIsCloneableResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientIsCloneableResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientIsCloneableResponse{}, runtime.NewResponseError(resp)
	}
	return client.isCloneableHandleResponse(resp)
}

// isCloneableCreateRequest creates the IsCloneable request.
func (client *WebAppsClient) isCloneableCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientIsCloneableOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// isCloneableHandleResponse handles the IsCloneable response.
func (client *WebAppsClient) isCloneableHandleResponse(resp *http.Response) (WebAppsClientIsCloneableResponse, error) {
	result := WebAppsClientIsCloneableResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteCloneability); err != nil {
		return WebAppsClientIsCloneableResponse{}, err
	}
	return result, nil
}

// IsCloneableSlot - Description for Shows whether an app can be cloned to another resource group or subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. By default, this API returns information on the production slot.
// options - WebAppsClientIsCloneableSlotOptions contains the optional parameters for the WebAppsClient.IsCloneableSlot method.
func (client *WebAppsClient) IsCloneableSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientIsCloneableSlotOptions) (WebAppsClientIsCloneableSlotResponse, error) {
	req, err := client.isCloneableSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientIsCloneableSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientIsCloneableSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientIsCloneableSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.isCloneableSlotHandleResponse(resp)
}

// isCloneableSlotCreateRequest creates the IsCloneableSlot request.
func (client *WebAppsClient) isCloneableSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientIsCloneableSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// isCloneableSlotHandleResponse handles the IsCloneableSlot response.
func (client *WebAppsClient) isCloneableSlotHandleResponse(resp *http.Response) (WebAppsClientIsCloneableSlotResponse, error) {
	result := WebAppsClientIsCloneableSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteCloneability); err != nil {
		return WebAppsClientIsCloneableSlotResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for Get all apps for a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebAppsClientListOptions contains the optional parameters for the WebAppsClient.List method.
func (client *WebAppsClient) NewListPager(options *WebAppsClientListOptions) *runtime.Pager[WebAppsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListResponse]{
		More: func(page WebAppsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListResponse) (WebAppsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *WebAppsClient) listCreateRequest(ctx context.Context, options *WebAppsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *WebAppsClient) listHandleResponse(resp *http.Response) (WebAppsClientListResponse, error) {
	result := WebAppsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return WebAppsClientListResponse{}, err
	}
	return result, nil
}

// ListApplicationSettings - Description for Gets the application settings of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListApplicationSettingsOptions contains the optional parameters for the WebAppsClient.ListApplicationSettings
// method.
func (client *WebAppsClient) ListApplicationSettings(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListApplicationSettingsOptions) (WebAppsClientListApplicationSettingsResponse, error) {
	req, err := client.listApplicationSettingsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListApplicationSettingsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListApplicationSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListApplicationSettingsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listApplicationSettingsHandleResponse(resp)
}

// listApplicationSettingsCreateRequest creates the ListApplicationSettings request.
func (client *WebAppsClient) listApplicationSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListApplicationSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listApplicationSettingsHandleResponse handles the ListApplicationSettings response.
func (client *WebAppsClient) listApplicationSettingsHandleResponse(resp *http.Response) (WebAppsClientListApplicationSettingsResponse, error) {
	result := WebAppsClientListApplicationSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return WebAppsClientListApplicationSettingsResponse{}, err
	}
	return result, nil
}

// ListApplicationSettingsSlot - Description for Gets the application settings of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the application settings for the production
// slot.
// options - WebAppsClientListApplicationSettingsSlotOptions contains the optional parameters for the WebAppsClient.ListApplicationSettingsSlot
// method.
func (client *WebAppsClient) ListApplicationSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListApplicationSettingsSlotOptions) (WebAppsClientListApplicationSettingsSlotResponse, error) {
	req, err := client.listApplicationSettingsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListApplicationSettingsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListApplicationSettingsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListApplicationSettingsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listApplicationSettingsSlotHandleResponse(resp)
}

// listApplicationSettingsSlotCreateRequest creates the ListApplicationSettingsSlot request.
func (client *WebAppsClient) listApplicationSettingsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListApplicationSettingsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listApplicationSettingsSlotHandleResponse handles the ListApplicationSettingsSlot response.
func (client *WebAppsClient) listApplicationSettingsSlotHandleResponse(resp *http.Response) (WebAppsClientListApplicationSettingsSlotResponse, error) {
	result := WebAppsClientListApplicationSettingsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return WebAppsClientListApplicationSettingsSlotResponse{}, err
	}
	return result, nil
}

// ListAzureStorageAccounts - Description for Gets the Azure storage account configurations of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListAzureStorageAccountsOptions contains the optional parameters for the WebAppsClient.ListAzureStorageAccounts
// method.
func (client *WebAppsClient) ListAzureStorageAccounts(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListAzureStorageAccountsOptions) (WebAppsClientListAzureStorageAccountsResponse, error) {
	req, err := client.listAzureStorageAccountsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListAzureStorageAccountsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListAzureStorageAccountsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListAzureStorageAccountsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listAzureStorageAccountsHandleResponse(resp)
}

// listAzureStorageAccountsCreateRequest creates the ListAzureStorageAccounts request.
func (client *WebAppsClient) listAzureStorageAccountsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListAzureStorageAccountsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAzureStorageAccountsHandleResponse handles the ListAzureStorageAccounts response.
func (client *WebAppsClient) listAzureStorageAccountsHandleResponse(resp *http.Response) (WebAppsClientListAzureStorageAccountsResponse, error) {
	result := WebAppsClientListAzureStorageAccountsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureStoragePropertyDictionaryResource); err != nil {
		return WebAppsClientListAzureStorageAccountsResponse{}, err
	}
	return result, nil
}

// ListAzureStorageAccountsSlot - Description for Gets the Azure storage account configurations of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will update the Azure storage account configurations
// for the production slot.
// options - WebAppsClientListAzureStorageAccountsSlotOptions contains the optional parameters for the WebAppsClient.ListAzureStorageAccountsSlot
// method.
func (client *WebAppsClient) ListAzureStorageAccountsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListAzureStorageAccountsSlotOptions) (WebAppsClientListAzureStorageAccountsSlotResponse, error) {
	req, err := client.listAzureStorageAccountsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListAzureStorageAccountsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListAzureStorageAccountsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListAzureStorageAccountsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listAzureStorageAccountsSlotHandleResponse(resp)
}

// listAzureStorageAccountsSlotCreateRequest creates the ListAzureStorageAccountsSlot request.
func (client *WebAppsClient) listAzureStorageAccountsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListAzureStorageAccountsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAzureStorageAccountsSlotHandleResponse handles the ListAzureStorageAccountsSlot response.
func (client *WebAppsClient) listAzureStorageAccountsSlotHandleResponse(resp *http.Response) (WebAppsClientListAzureStorageAccountsSlotResponse, error) {
	result := WebAppsClientListAzureStorageAccountsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureStoragePropertyDictionaryResource); err != nil {
		return WebAppsClientListAzureStorageAccountsSlotResponse{}, err
	}
	return result, nil
}

// ListBackupStatusSecrets - Description for Gets status of a web app backup that may be in progress, including secrets associated
// with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
// backup if a new URL is passed in the request body.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// backupID - ID of backup.
// request - Information on backup request.
// options - WebAppsClientListBackupStatusSecretsOptions contains the optional parameters for the WebAppsClient.ListBackupStatusSecrets
// method.
func (client *WebAppsClient) ListBackupStatusSecrets(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest, options *WebAppsClientListBackupStatusSecretsOptions) (WebAppsClientListBackupStatusSecretsResponse, error) {
	req, err := client.listBackupStatusSecretsCreateRequest(ctx, resourceGroupName, name, backupID, request, options)
	if err != nil {
		return WebAppsClientListBackupStatusSecretsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListBackupStatusSecretsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListBackupStatusSecretsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listBackupStatusSecretsHandleResponse(resp)
}

// listBackupStatusSecretsCreateRequest creates the ListBackupStatusSecrets request.
func (client *WebAppsClient) listBackupStatusSecretsCreateRequest(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest, options *WebAppsClientListBackupStatusSecretsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if backupID == "" {
		return nil, errors.New("parameter backupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupId}", url.PathEscape(backupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, request)
}

// listBackupStatusSecretsHandleResponse handles the ListBackupStatusSecrets response.
func (client *WebAppsClient) listBackupStatusSecretsHandleResponse(resp *http.Response) (WebAppsClientListBackupStatusSecretsResponse, error) {
	result := WebAppsClientListBackupStatusSecretsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItem); err != nil {
		return WebAppsClientListBackupStatusSecretsResponse{}, err
	}
	return result, nil
}

// ListBackupStatusSecretsSlot - Description for Gets status of a web app backup that may be in progress, including secrets
// associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
// backup if a new URL is passed in the request body.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// backupID - ID of backup.
// slot - Name of web app slot. If not specified then will default to production slot.
// request - Information on backup request.
// options - WebAppsClientListBackupStatusSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListBackupStatusSecretsSlot
// method.
func (client *WebAppsClient) ListBackupStatusSecretsSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, request BackupRequest, options *WebAppsClientListBackupStatusSecretsSlotOptions) (WebAppsClientListBackupStatusSecretsSlotResponse, error) {
	req, err := client.listBackupStatusSecretsSlotCreateRequest(ctx, resourceGroupName, name, backupID, slot, request, options)
	if err != nil {
		return WebAppsClientListBackupStatusSecretsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListBackupStatusSecretsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListBackupStatusSecretsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listBackupStatusSecretsSlotHandleResponse(resp)
}

// listBackupStatusSecretsSlotCreateRequest creates the ListBackupStatusSecretsSlot request.
func (client *WebAppsClient) listBackupStatusSecretsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, backupID string, slot string, request BackupRequest, options *WebAppsClientListBackupStatusSecretsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if backupID == "" {
		return nil, errors.New("parameter backupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupId}", url.PathEscape(backupID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, request)
}

// listBackupStatusSecretsSlotHandleResponse handles the ListBackupStatusSecretsSlot response.
func (client *WebAppsClient) listBackupStatusSecretsSlotHandleResponse(resp *http.Response) (WebAppsClientListBackupStatusSecretsSlotResponse, error) {
	result := WebAppsClientListBackupStatusSecretsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItem); err != nil {
		return WebAppsClientListBackupStatusSecretsSlotResponse{}, err
	}
	return result, nil
}

// NewListBackupsPager - Description for Gets existing backups of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListBackupsOptions contains the optional parameters for the WebAppsClient.ListBackups method.
func (client *WebAppsClient) NewListBackupsPager(resourceGroupName string, name string, options *WebAppsClientListBackupsOptions) *runtime.Pager[WebAppsClientListBackupsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListBackupsResponse]{
		More: func(page WebAppsClientListBackupsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListBackupsResponse) (WebAppsClientListBackupsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBackupsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListBackupsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListBackupsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListBackupsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBackupsHandleResponse(resp)
		},
	})
}

// listBackupsCreateRequest creates the ListBackups request.
func (client *WebAppsClient) listBackupsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListBackupsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBackupsHandleResponse handles the ListBackups response.
func (client *WebAppsClient) listBackupsHandleResponse(resp *http.Response) (WebAppsClientListBackupsResponse, error) {
	result := WebAppsClientListBackupsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItemCollection); err != nil {
		return WebAppsClientListBackupsResponse{}, err
	}
	return result, nil
}

// NewListBackupsSlotPager - Description for Gets existing backups of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get backups of the production slot.
// options - WebAppsClientListBackupsSlotOptions contains the optional parameters for the WebAppsClient.ListBackupsSlot method.
func (client *WebAppsClient) NewListBackupsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListBackupsSlotOptions) *runtime.Pager[WebAppsClientListBackupsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListBackupsSlotResponse]{
		More: func(page WebAppsClientListBackupsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListBackupsSlotResponse) (WebAppsClientListBackupsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBackupsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListBackupsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListBackupsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListBackupsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBackupsSlotHandleResponse(resp)
		},
	})
}

// listBackupsSlotCreateRequest creates the ListBackupsSlot request.
func (client *WebAppsClient) listBackupsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListBackupsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBackupsSlotHandleResponse handles the ListBackupsSlot response.
func (client *WebAppsClient) listBackupsSlotHandleResponse(resp *http.Response) (WebAppsClientListBackupsSlotResponse, error) {
	result := WebAppsClientListBackupsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItemCollection); err != nil {
		return WebAppsClientListBackupsSlotResponse{}, err
	}
	return result, nil
}

// NewListBasicPublishingCredentialsPoliciesPager - Description for Returns whether Scm basic auth is allowed and whether
// Ftp is allowed for a given site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListBasicPublishingCredentialsPoliciesOptions contains the optional parameters for the WebAppsClient.ListBasicPublishingCredentialsPolicies
// method.
func (client *WebAppsClient) NewListBasicPublishingCredentialsPoliciesPager(resourceGroupName string, name string, options *WebAppsClientListBasicPublishingCredentialsPoliciesOptions) *runtime.Pager[WebAppsClientListBasicPublishingCredentialsPoliciesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListBasicPublishingCredentialsPoliciesResponse]{
		More: func(page WebAppsClientListBasicPublishingCredentialsPoliciesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListBasicPublishingCredentialsPoliciesResponse) (WebAppsClientListBasicPublishingCredentialsPoliciesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBasicPublishingCredentialsPoliciesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListBasicPublishingCredentialsPoliciesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListBasicPublishingCredentialsPoliciesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListBasicPublishingCredentialsPoliciesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBasicPublishingCredentialsPoliciesHandleResponse(resp)
		},
	})
}

// listBasicPublishingCredentialsPoliciesCreateRequest creates the ListBasicPublishingCredentialsPolicies request.
func (client *WebAppsClient) listBasicPublishingCredentialsPoliciesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListBasicPublishingCredentialsPoliciesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBasicPublishingCredentialsPoliciesHandleResponse handles the ListBasicPublishingCredentialsPolicies response.
func (client *WebAppsClient) listBasicPublishingCredentialsPoliciesHandleResponse(resp *http.Response) (WebAppsClientListBasicPublishingCredentialsPoliciesResponse, error) {
	result := WebAppsClientListBasicPublishingCredentialsPoliciesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublishingCredentialsPoliciesCollection); err != nil {
		return WebAppsClientListBasicPublishingCredentialsPoliciesResponse{}, err
	}
	return result, nil
}

// NewListBasicPublishingCredentialsPoliciesSlotPager - Description for Returns whether Scm basic auth is allowed and whether
// Ftp is allowed for a given site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListBasicPublishingCredentialsPoliciesSlotOptions contains the optional parameters for the WebAppsClient.ListBasicPublishingCredentialsPoliciesSlot
// method.
func (client *WebAppsClient) NewListBasicPublishingCredentialsPoliciesSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListBasicPublishingCredentialsPoliciesSlotOptions) *runtime.Pager[WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse]{
		More: func(page WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse) (WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBasicPublishingCredentialsPoliciesSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBasicPublishingCredentialsPoliciesSlotHandleResponse(resp)
		},
	})
}

// listBasicPublishingCredentialsPoliciesSlotCreateRequest creates the ListBasicPublishingCredentialsPoliciesSlot request.
func (client *WebAppsClient) listBasicPublishingCredentialsPoliciesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListBasicPublishingCredentialsPoliciesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBasicPublishingCredentialsPoliciesSlotHandleResponse handles the ListBasicPublishingCredentialsPoliciesSlot response.
func (client *WebAppsClient) listBasicPublishingCredentialsPoliciesSlotHandleResponse(resp *http.Response) (WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse, error) {
	result := WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublishingCredentialsPoliciesCollection); err != nil {
		return WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Description for Gets all web, mobile, and API apps in the specified resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// options - WebAppsClientListByResourceGroupOptions contains the optional parameters for the WebAppsClient.ListByResourceGroup
// method.
func (client *WebAppsClient) NewListByResourceGroupPager(resourceGroupName string, options *WebAppsClientListByResourceGroupOptions) *runtime.Pager[WebAppsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListByResourceGroupResponse]{
		More: func(page WebAppsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListByResourceGroupResponse) (WebAppsClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *WebAppsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *WebAppsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IncludeSlots != nil {
		reqQP.Set("includeSlots", strconv.FormatBool(*options.IncludeSlots))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *WebAppsClient) listByResourceGroupHandleResponse(resp *http.Response) (WebAppsClientListByResourceGroupResponse, error) {
	result := WebAppsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return WebAppsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListConfigurationSnapshotInfoPager - Description for Gets a list of web app configuration snapshots identifiers. Each
// element of the list contains a timestamp and the ID of the snapshot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListConfigurationSnapshotInfoOptions contains the optional parameters for the WebAppsClient.ListConfigurationSnapshotInfo
// method.
func (client *WebAppsClient) NewListConfigurationSnapshotInfoPager(resourceGroupName string, name string, options *WebAppsClientListConfigurationSnapshotInfoOptions) *runtime.Pager[WebAppsClientListConfigurationSnapshotInfoResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListConfigurationSnapshotInfoResponse]{
		More: func(page WebAppsClientListConfigurationSnapshotInfoResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListConfigurationSnapshotInfoResponse) (WebAppsClientListConfigurationSnapshotInfoResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listConfigurationSnapshotInfoCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListConfigurationSnapshotInfoResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListConfigurationSnapshotInfoResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListConfigurationSnapshotInfoResponse{}, runtime.NewResponseError(resp)
			}
			return client.listConfigurationSnapshotInfoHandleResponse(resp)
		},
	})
}

// listConfigurationSnapshotInfoCreateRequest creates the ListConfigurationSnapshotInfo request.
func (client *WebAppsClient) listConfigurationSnapshotInfoCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListConfigurationSnapshotInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listConfigurationSnapshotInfoHandleResponse handles the ListConfigurationSnapshotInfo response.
func (client *WebAppsClient) listConfigurationSnapshotInfoHandleResponse(resp *http.Response) (WebAppsClientListConfigurationSnapshotInfoResponse, error) {
	result := WebAppsClientListConfigurationSnapshotInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigurationSnapshotInfoCollection); err != nil {
		return WebAppsClientListConfigurationSnapshotInfoResponse{}, err
	}
	return result, nil
}

// NewListConfigurationSnapshotInfoSlotPager - Description for Gets a list of web app configuration snapshots identifiers.
// Each element of the list contains a timestamp and the ID of the snapshot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will return configuration for the production slot.
// options - WebAppsClientListConfigurationSnapshotInfoSlotOptions contains the optional parameters for the WebAppsClient.ListConfigurationSnapshotInfoSlot
// method.
func (client *WebAppsClient) NewListConfigurationSnapshotInfoSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListConfigurationSnapshotInfoSlotOptions) *runtime.Pager[WebAppsClientListConfigurationSnapshotInfoSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListConfigurationSnapshotInfoSlotResponse]{
		More: func(page WebAppsClientListConfigurationSnapshotInfoSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListConfigurationSnapshotInfoSlotResponse) (WebAppsClientListConfigurationSnapshotInfoSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listConfigurationSnapshotInfoSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListConfigurationSnapshotInfoSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListConfigurationSnapshotInfoSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListConfigurationSnapshotInfoSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listConfigurationSnapshotInfoSlotHandleResponse(resp)
		},
	})
}

// listConfigurationSnapshotInfoSlotCreateRequest creates the ListConfigurationSnapshotInfoSlot request.
func (client *WebAppsClient) listConfigurationSnapshotInfoSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListConfigurationSnapshotInfoSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listConfigurationSnapshotInfoSlotHandleResponse handles the ListConfigurationSnapshotInfoSlot response.
func (client *WebAppsClient) listConfigurationSnapshotInfoSlotHandleResponse(resp *http.Response) (WebAppsClientListConfigurationSnapshotInfoSlotResponse, error) {
	result := WebAppsClientListConfigurationSnapshotInfoSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigurationSnapshotInfoCollection); err != nil {
		return WebAppsClientListConfigurationSnapshotInfoSlotResponse{}, err
	}
	return result, nil
}

// NewListConfigurationsPager - Description for List the configurations of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListConfigurationsOptions contains the optional parameters for the WebAppsClient.ListConfigurations
// method.
func (client *WebAppsClient) NewListConfigurationsPager(resourceGroupName string, name string, options *WebAppsClientListConfigurationsOptions) *runtime.Pager[WebAppsClientListConfigurationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListConfigurationsResponse]{
		More: func(page WebAppsClientListConfigurationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListConfigurationsResponse) (WebAppsClientListConfigurationsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listConfigurationsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListConfigurationsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListConfigurationsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListConfigurationsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listConfigurationsHandleResponse(resp)
		},
	})
}

// listConfigurationsCreateRequest creates the ListConfigurations request.
func (client *WebAppsClient) listConfigurationsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListConfigurationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listConfigurationsHandleResponse handles the ListConfigurations response.
func (client *WebAppsClient) listConfigurationsHandleResponse(resp *http.Response) (WebAppsClientListConfigurationsResponse, error) {
	result := WebAppsClientListConfigurationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResourceCollection); err != nil {
		return WebAppsClientListConfigurationsResponse{}, err
	}
	return result, nil
}

// NewListConfigurationsSlotPager - Description for List the configurations of an app
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will return configuration for the production slot.
// options - WebAppsClientListConfigurationsSlotOptions contains the optional parameters for the WebAppsClient.ListConfigurationsSlot
// method.
func (client *WebAppsClient) NewListConfigurationsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListConfigurationsSlotOptions) *runtime.Pager[WebAppsClientListConfigurationsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListConfigurationsSlotResponse]{
		More: func(page WebAppsClientListConfigurationsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListConfigurationsSlotResponse) (WebAppsClientListConfigurationsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listConfigurationsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListConfigurationsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListConfigurationsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListConfigurationsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listConfigurationsSlotHandleResponse(resp)
		},
	})
}

// listConfigurationsSlotCreateRequest creates the ListConfigurationsSlot request.
func (client *WebAppsClient) listConfigurationsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListConfigurationsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listConfigurationsSlotHandleResponse handles the ListConfigurationsSlot response.
func (client *WebAppsClient) listConfigurationsSlotHandleResponse(resp *http.Response) (WebAppsClientListConfigurationsSlotResponse, error) {
	result := WebAppsClientListConfigurationsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteConfigResourceCollection); err != nil {
		return WebAppsClientListConfigurationsSlotResponse{}, err
	}
	return result, nil
}

// ListConnectionStrings - Description for Gets the connection strings of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListConnectionStringsOptions contains the optional parameters for the WebAppsClient.ListConnectionStrings
// method.
func (client *WebAppsClient) ListConnectionStrings(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListConnectionStringsOptions) (WebAppsClientListConnectionStringsResponse, error) {
	req, err := client.listConnectionStringsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListConnectionStringsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListConnectionStringsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListConnectionStringsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listConnectionStringsHandleResponse(resp)
}

// listConnectionStringsCreateRequest creates the ListConnectionStrings request.
func (client *WebAppsClient) listConnectionStringsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListConnectionStringsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listConnectionStringsHandleResponse handles the ListConnectionStrings response.
func (client *WebAppsClient) listConnectionStringsHandleResponse(resp *http.Response) (WebAppsClientListConnectionStringsResponse, error) {
	result := WebAppsClientListConnectionStringsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConnectionStringDictionary); err != nil {
		return WebAppsClientListConnectionStringsResponse{}, err
	}
	return result, nil
}

// ListConnectionStringsSlot - Description for Gets the connection strings of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the connection settings for the production
// slot.
// options - WebAppsClientListConnectionStringsSlotOptions contains the optional parameters for the WebAppsClient.ListConnectionStringsSlot
// method.
func (client *WebAppsClient) ListConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListConnectionStringsSlotOptions) (WebAppsClientListConnectionStringsSlotResponse, error) {
	req, err := client.listConnectionStringsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListConnectionStringsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListConnectionStringsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListConnectionStringsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listConnectionStringsSlotHandleResponse(resp)
}

// listConnectionStringsSlotCreateRequest creates the ListConnectionStringsSlot request.
func (client *WebAppsClient) listConnectionStringsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListConnectionStringsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listConnectionStringsSlotHandleResponse handles the ListConnectionStringsSlot response.
func (client *WebAppsClient) listConnectionStringsSlotHandleResponse(resp *http.Response) (WebAppsClientListConnectionStringsSlotResponse, error) {
	result := WebAppsClientListConnectionStringsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConnectionStringDictionary); err != nil {
		return WebAppsClientListConnectionStringsSlotResponse{}, err
	}
	return result, nil
}

// NewListContinuousWebJobsPager - Description for List continuous web jobs for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// options - WebAppsClientListContinuousWebJobsOptions contains the optional parameters for the WebAppsClient.ListContinuousWebJobs
// method.
func (client *WebAppsClient) NewListContinuousWebJobsPager(resourceGroupName string, name string, options *WebAppsClientListContinuousWebJobsOptions) *runtime.Pager[WebAppsClientListContinuousWebJobsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListContinuousWebJobsResponse]{
		More: func(page WebAppsClientListContinuousWebJobsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListContinuousWebJobsResponse) (WebAppsClientListContinuousWebJobsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listContinuousWebJobsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListContinuousWebJobsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListContinuousWebJobsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListContinuousWebJobsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listContinuousWebJobsHandleResponse(resp)
		},
	})
}

// listContinuousWebJobsCreateRequest creates the ListContinuousWebJobs request.
func (client *WebAppsClient) listContinuousWebJobsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListContinuousWebJobsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listContinuousWebJobsHandleResponse handles the ListContinuousWebJobs response.
func (client *WebAppsClient) listContinuousWebJobsHandleResponse(resp *http.Response) (WebAppsClientListContinuousWebJobsResponse, error) {
	result := WebAppsClientListContinuousWebJobsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ContinuousWebJobCollection); err != nil {
		return WebAppsClientListContinuousWebJobsResponse{}, err
	}
	return result, nil
}

// NewListContinuousWebJobsSlotPager - Description for List continuous web jobs for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// slot - Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
// options - WebAppsClientListContinuousWebJobsSlotOptions contains the optional parameters for the WebAppsClient.ListContinuousWebJobsSlot
// method.
func (client *WebAppsClient) NewListContinuousWebJobsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListContinuousWebJobsSlotOptions) *runtime.Pager[WebAppsClientListContinuousWebJobsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListContinuousWebJobsSlotResponse]{
		More: func(page WebAppsClientListContinuousWebJobsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListContinuousWebJobsSlotResponse) (WebAppsClientListContinuousWebJobsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listContinuousWebJobsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListContinuousWebJobsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListContinuousWebJobsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListContinuousWebJobsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listContinuousWebJobsSlotHandleResponse(resp)
		},
	})
}

// listContinuousWebJobsSlotCreateRequest creates the ListContinuousWebJobsSlot request.
func (client *WebAppsClient) listContinuousWebJobsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListContinuousWebJobsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listContinuousWebJobsSlotHandleResponse handles the ListContinuousWebJobsSlot response.
func (client *WebAppsClient) listContinuousWebJobsSlotHandleResponse(resp *http.Response) (WebAppsClientListContinuousWebJobsSlotResponse, error) {
	result := WebAppsClientListContinuousWebJobsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ContinuousWebJobCollection); err != nil {
		return WebAppsClientListContinuousWebJobsSlotResponse{}, err
	}
	return result, nil
}

// ListDeploymentLog - Description for List deployment log for specific deployment for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - The ID of a specific deployment. This is the value of the name property in the JSON response from "GET /api/sites/{siteName}/deployments".
// options - WebAppsClientListDeploymentLogOptions contains the optional parameters for the WebAppsClient.ListDeploymentLog
// method.
func (client *WebAppsClient) ListDeploymentLog(ctx context.Context, resourceGroupName string, name string, id string, options *WebAppsClientListDeploymentLogOptions) (WebAppsClientListDeploymentLogResponse, error) {
	req, err := client.listDeploymentLogCreateRequest(ctx, resourceGroupName, name, id, options)
	if err != nil {
		return WebAppsClientListDeploymentLogResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListDeploymentLogResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListDeploymentLogResponse{}, runtime.NewResponseError(resp)
	}
	return client.listDeploymentLogHandleResponse(resp)
}

// listDeploymentLogCreateRequest creates the ListDeploymentLog request.
func (client *WebAppsClient) listDeploymentLogCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, options *WebAppsClientListDeploymentLogOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}/log"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentLogHandleResponse handles the ListDeploymentLog response.
func (client *WebAppsClient) listDeploymentLogHandleResponse(resp *http.Response) (WebAppsClientListDeploymentLogResponse, error) {
	result := WebAppsClientListDeploymentLogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Deployment); err != nil {
		return WebAppsClientListDeploymentLogResponse{}, err
	}
	return result, nil
}

// ListDeploymentLogSlot - Description for List deployment log for specific deployment for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// id - The ID of a specific deployment. This is the value of the name property in the JSON response from "GET /api/sites/{siteName}/deployments".
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientListDeploymentLogSlotOptions contains the optional parameters for the WebAppsClient.ListDeploymentLogSlot
// method.
func (client *WebAppsClient) ListDeploymentLogSlot(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *WebAppsClientListDeploymentLogSlotOptions) (WebAppsClientListDeploymentLogSlotResponse, error) {
	req, err := client.listDeploymentLogSlotCreateRequest(ctx, resourceGroupName, name, id, slot, options)
	if err != nil {
		return WebAppsClientListDeploymentLogSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListDeploymentLogSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListDeploymentLogSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listDeploymentLogSlotHandleResponse(resp)
}

// listDeploymentLogSlotCreateRequest creates the ListDeploymentLogSlot request.
func (client *WebAppsClient) listDeploymentLogSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, id string, slot string, options *WebAppsClientListDeploymentLogSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}/log"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if id == "" {
		return nil, errors.New("parameter id cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{id}", url.PathEscape(id))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentLogSlotHandleResponse handles the ListDeploymentLogSlot response.
func (client *WebAppsClient) listDeploymentLogSlotHandleResponse(resp *http.Response) (WebAppsClientListDeploymentLogSlotResponse, error) {
	result := WebAppsClientListDeploymentLogSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Deployment); err != nil {
		return WebAppsClientListDeploymentLogSlotResponse{}, err
	}
	return result, nil
}

// NewListDeploymentsPager - Description for List deployments for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListDeploymentsOptions contains the optional parameters for the WebAppsClient.ListDeployments method.
func (client *WebAppsClient) NewListDeploymentsPager(resourceGroupName string, name string, options *WebAppsClientListDeploymentsOptions) *runtime.Pager[WebAppsClientListDeploymentsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListDeploymentsResponse]{
		More: func(page WebAppsClientListDeploymentsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListDeploymentsResponse) (WebAppsClientListDeploymentsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listDeploymentsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListDeploymentsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListDeploymentsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListDeploymentsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listDeploymentsHandleResponse(resp)
		},
	})
}

// listDeploymentsCreateRequest creates the ListDeployments request.
func (client *WebAppsClient) listDeploymentsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListDeploymentsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentsHandleResponse handles the ListDeployments response.
func (client *WebAppsClient) listDeploymentsHandleResponse(resp *http.Response) (WebAppsClientListDeploymentsResponse, error) {
	result := WebAppsClientListDeploymentsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentCollection); err != nil {
		return WebAppsClientListDeploymentsResponse{}, err
	}
	return result, nil
}

// NewListDeploymentsSlotPager - Description for List deployments for an app, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientListDeploymentsSlotOptions contains the optional parameters for the WebAppsClient.ListDeploymentsSlot
// method.
func (client *WebAppsClient) NewListDeploymentsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListDeploymentsSlotOptions) *runtime.Pager[WebAppsClientListDeploymentsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListDeploymentsSlotResponse]{
		More: func(page WebAppsClientListDeploymentsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListDeploymentsSlotResponse) (WebAppsClientListDeploymentsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listDeploymentsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListDeploymentsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListDeploymentsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListDeploymentsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listDeploymentsSlotHandleResponse(resp)
		},
	})
}

// listDeploymentsSlotCreateRequest creates the ListDeploymentsSlot request.
func (client *WebAppsClient) listDeploymentsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListDeploymentsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentsSlotHandleResponse handles the ListDeploymentsSlot response.
func (client *WebAppsClient) listDeploymentsSlotHandleResponse(resp *http.Response) (WebAppsClientListDeploymentsSlotResponse, error) {
	result := WebAppsClientListDeploymentsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentCollection); err != nil {
		return WebAppsClientListDeploymentsSlotResponse{}, err
	}
	return result, nil
}

// NewListDomainOwnershipIdentifiersPager - Description for Lists ownership identifiers for domain associated with web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListDomainOwnershipIdentifiersOptions contains the optional parameters for the WebAppsClient.ListDomainOwnershipIdentifiers
// method.
func (client *WebAppsClient) NewListDomainOwnershipIdentifiersPager(resourceGroupName string, name string, options *WebAppsClientListDomainOwnershipIdentifiersOptions) *runtime.Pager[WebAppsClientListDomainOwnershipIdentifiersResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListDomainOwnershipIdentifiersResponse]{
		More: func(page WebAppsClientListDomainOwnershipIdentifiersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListDomainOwnershipIdentifiersResponse) (WebAppsClientListDomainOwnershipIdentifiersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listDomainOwnershipIdentifiersCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListDomainOwnershipIdentifiersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListDomainOwnershipIdentifiersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListDomainOwnershipIdentifiersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listDomainOwnershipIdentifiersHandleResponse(resp)
		},
	})
}

// listDomainOwnershipIdentifiersCreateRequest creates the ListDomainOwnershipIdentifiers request.
func (client *WebAppsClient) listDomainOwnershipIdentifiersCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListDomainOwnershipIdentifiersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDomainOwnershipIdentifiersHandleResponse handles the ListDomainOwnershipIdentifiers response.
func (client *WebAppsClient) listDomainOwnershipIdentifiersHandleResponse(resp *http.Response) (WebAppsClientListDomainOwnershipIdentifiersResponse, error) {
	result := WebAppsClientListDomainOwnershipIdentifiersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IdentifierCollection); err != nil {
		return WebAppsClientListDomainOwnershipIdentifiersResponse{}, err
	}
	return result, nil
}

// NewListDomainOwnershipIdentifiersSlotPager - Description for Lists ownership identifiers for domain associated with web
// app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// options - WebAppsClientListDomainOwnershipIdentifiersSlotOptions contains the optional parameters for the WebAppsClient.ListDomainOwnershipIdentifiersSlot
// method.
func (client *WebAppsClient) NewListDomainOwnershipIdentifiersSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListDomainOwnershipIdentifiersSlotOptions) *runtime.Pager[WebAppsClientListDomainOwnershipIdentifiersSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListDomainOwnershipIdentifiersSlotResponse]{
		More: func(page WebAppsClientListDomainOwnershipIdentifiersSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListDomainOwnershipIdentifiersSlotResponse) (WebAppsClientListDomainOwnershipIdentifiersSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listDomainOwnershipIdentifiersSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListDomainOwnershipIdentifiersSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListDomainOwnershipIdentifiersSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListDomainOwnershipIdentifiersSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listDomainOwnershipIdentifiersSlotHandleResponse(resp)
		},
	})
}

// listDomainOwnershipIdentifiersSlotCreateRequest creates the ListDomainOwnershipIdentifiersSlot request.
func (client *WebAppsClient) listDomainOwnershipIdentifiersSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListDomainOwnershipIdentifiersSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDomainOwnershipIdentifiersSlotHandleResponse handles the ListDomainOwnershipIdentifiersSlot response.
func (client *WebAppsClient) listDomainOwnershipIdentifiersSlotHandleResponse(resp *http.Response) (WebAppsClientListDomainOwnershipIdentifiersSlotResponse, error) {
	result := WebAppsClientListDomainOwnershipIdentifiersSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IdentifierCollection); err != nil {
		return WebAppsClientListDomainOwnershipIdentifiersSlotResponse{}, err
	}
	return result, nil
}

// ListFunctionKeys - Description for Get function keys for a function in a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// options - WebAppsClientListFunctionKeysOptions contains the optional parameters for the WebAppsClient.ListFunctionKeys
// method.
func (client *WebAppsClient) ListFunctionKeys(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientListFunctionKeysOptions) (WebAppsClientListFunctionKeysResponse, error) {
	req, err := client.listFunctionKeysCreateRequest(ctx, resourceGroupName, name, functionName, options)
	if err != nil {
		return WebAppsClientListFunctionKeysResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListFunctionKeysResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListFunctionKeysResponse{}, runtime.NewResponseError(resp)
	}
	return client.listFunctionKeysHandleResponse(resp)
}

// listFunctionKeysCreateRequest creates the ListFunctionKeys request.
func (client *WebAppsClient) listFunctionKeysCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientListFunctionKeysOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listkeys"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFunctionKeysHandleResponse handles the ListFunctionKeys response.
func (client *WebAppsClient) listFunctionKeysHandleResponse(resp *http.Response) (WebAppsClientListFunctionKeysResponse, error) {
	result := WebAppsClientListFunctionKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return WebAppsClientListFunctionKeysResponse{}, err
	}
	return result, nil
}

// ListFunctionKeysSlot - Description for Get function keys for a function in a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// slot - Name of the deployment slot.
// options - WebAppsClientListFunctionKeysSlotOptions contains the optional parameters for the WebAppsClient.ListFunctionKeysSlot
// method.
func (client *WebAppsClient) ListFunctionKeysSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientListFunctionKeysSlotOptions) (WebAppsClientListFunctionKeysSlotResponse, error) {
	req, err := client.listFunctionKeysSlotCreateRequest(ctx, resourceGroupName, name, functionName, slot, options)
	if err != nil {
		return WebAppsClientListFunctionKeysSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListFunctionKeysSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListFunctionKeysSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listFunctionKeysSlotHandleResponse(resp)
}

// listFunctionKeysSlotCreateRequest creates the ListFunctionKeysSlot request.
func (client *WebAppsClient) listFunctionKeysSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientListFunctionKeysSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listkeys"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFunctionKeysSlotHandleResponse handles the ListFunctionKeysSlot response.
func (client *WebAppsClient) listFunctionKeysSlotHandleResponse(resp *http.Response) (WebAppsClientListFunctionKeysSlotResponse, error) {
	result := WebAppsClientListFunctionKeysSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return WebAppsClientListFunctionKeysSlotResponse{}, err
	}
	return result, nil
}

// ListFunctionSecrets - Description for Get function secrets for a function in a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// options - WebAppsClientListFunctionSecretsOptions contains the optional parameters for the WebAppsClient.ListFunctionSecrets
// method.
func (client *WebAppsClient) ListFunctionSecrets(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientListFunctionSecretsOptions) (WebAppsClientListFunctionSecretsResponse, error) {
	req, err := client.listFunctionSecretsCreateRequest(ctx, resourceGroupName, name, functionName, options)
	if err != nil {
		return WebAppsClientListFunctionSecretsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListFunctionSecretsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListFunctionSecretsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listFunctionSecretsHandleResponse(resp)
}

// listFunctionSecretsCreateRequest creates the ListFunctionSecrets request.
func (client *WebAppsClient) listFunctionSecretsCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, options *WebAppsClientListFunctionSecretsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listsecrets"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFunctionSecretsHandleResponse handles the ListFunctionSecrets response.
func (client *WebAppsClient) listFunctionSecretsHandleResponse(resp *http.Response) (WebAppsClientListFunctionSecretsResponse, error) {
	result := WebAppsClientListFunctionSecretsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionSecrets); err != nil {
		return WebAppsClientListFunctionSecretsResponse{}, err
	}
	return result, nil
}

// ListFunctionSecretsSlot - Description for Get function secrets for a function in a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// functionName - Function name.
// slot - Name of the deployment slot.
// options - WebAppsClientListFunctionSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListFunctionSecretsSlot
// method.
func (client *WebAppsClient) ListFunctionSecretsSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientListFunctionSecretsSlotOptions) (WebAppsClientListFunctionSecretsSlotResponse, error) {
	req, err := client.listFunctionSecretsSlotCreateRequest(ctx, resourceGroupName, name, functionName, slot, options)
	if err != nil {
		return WebAppsClientListFunctionSecretsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListFunctionSecretsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListFunctionSecretsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listFunctionSecretsSlotHandleResponse(resp)
}

// listFunctionSecretsSlotCreateRequest creates the ListFunctionSecretsSlot request.
func (client *WebAppsClient) listFunctionSecretsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, options *WebAppsClientListFunctionSecretsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listsecrets"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionName == "" {
		return nil, errors.New("parameter functionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionName}", url.PathEscape(functionName))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFunctionSecretsSlotHandleResponse handles the ListFunctionSecretsSlot response.
func (client *WebAppsClient) listFunctionSecretsSlotHandleResponse(resp *http.Response) (WebAppsClientListFunctionSecretsSlotResponse, error) {
	result := WebAppsClientListFunctionSecretsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionSecrets); err != nil {
		return WebAppsClientListFunctionSecretsSlotResponse{}, err
	}
	return result, nil
}

// NewListFunctionsPager - Description for List the functions for a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// options - WebAppsClientListFunctionsOptions contains the optional parameters for the WebAppsClient.ListFunctions method.
func (client *WebAppsClient) NewListFunctionsPager(resourceGroupName string, name string, options *WebAppsClientListFunctionsOptions) *runtime.Pager[WebAppsClientListFunctionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListFunctionsResponse]{
		More: func(page WebAppsClientListFunctionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListFunctionsResponse) (WebAppsClientListFunctionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listFunctionsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListFunctionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListFunctionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListFunctionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listFunctionsHandleResponse(resp)
		},
	})
}

// listFunctionsCreateRequest creates the ListFunctions request.
func (client *WebAppsClient) listFunctionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListFunctionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFunctionsHandleResponse handles the ListFunctions response.
func (client *WebAppsClient) listFunctionsHandleResponse(resp *http.Response) (WebAppsClientListFunctionsResponse, error) {
	result := WebAppsClientListFunctionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionEnvelopeCollection); err != nil {
		return WebAppsClientListFunctionsResponse{}, err
	}
	return result, nil
}

// ListHostKeys - Description for Get host secrets for a function app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// options - WebAppsClientListHostKeysOptions contains the optional parameters for the WebAppsClient.ListHostKeys method.
func (client *WebAppsClient) ListHostKeys(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListHostKeysOptions) (WebAppsClientListHostKeysResponse, error) {
	req, err := client.listHostKeysCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListHostKeysResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListHostKeysResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListHostKeysResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHostKeysHandleResponse(resp)
}

// listHostKeysCreateRequest creates the ListHostKeys request.
func (client *WebAppsClient) listHostKeysCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListHostKeysOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listkeys"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHostKeysHandleResponse handles the ListHostKeys response.
func (client *WebAppsClient) listHostKeysHandleResponse(resp *http.Response) (WebAppsClientListHostKeysResponse, error) {
	result := WebAppsClientListHostKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostKeys); err != nil {
		return WebAppsClientListHostKeysResponse{}, err
	}
	return result, nil
}

// ListHostKeysSlot - Description for Get host secrets for a function app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// slot - Name of the deployment slot.
// options - WebAppsClientListHostKeysSlotOptions contains the optional parameters for the WebAppsClient.ListHostKeysSlot
// method.
func (client *WebAppsClient) ListHostKeysSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListHostKeysSlotOptions) (WebAppsClientListHostKeysSlotResponse, error) {
	req, err := client.listHostKeysSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListHostKeysSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListHostKeysSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListHostKeysSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHostKeysSlotHandleResponse(resp)
}

// listHostKeysSlotCreateRequest creates the ListHostKeysSlot request.
func (client *WebAppsClient) listHostKeysSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListHostKeysSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/listkeys"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHostKeysSlotHandleResponse handles the ListHostKeysSlot response.
func (client *WebAppsClient) listHostKeysSlotHandleResponse(resp *http.Response) (WebAppsClientListHostKeysSlotResponse, error) {
	result := WebAppsClientListHostKeysSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostKeys); err != nil {
		return WebAppsClientListHostKeysSlotResponse{}, err
	}
	return result, nil
}

// NewListHostNameBindingsPager - Description for Get hostname bindings for an app or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListHostNameBindingsOptions contains the optional parameters for the WebAppsClient.ListHostNameBindings
// method.
func (client *WebAppsClient) NewListHostNameBindingsPager(resourceGroupName string, name string, options *WebAppsClientListHostNameBindingsOptions) *runtime.Pager[WebAppsClientListHostNameBindingsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListHostNameBindingsResponse]{
		More: func(page WebAppsClientListHostNameBindingsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListHostNameBindingsResponse) (WebAppsClientListHostNameBindingsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listHostNameBindingsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListHostNameBindingsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListHostNameBindingsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListHostNameBindingsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHostNameBindingsHandleResponse(resp)
		},
	})
}

// listHostNameBindingsCreateRequest creates the ListHostNameBindings request.
func (client *WebAppsClient) listHostNameBindingsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListHostNameBindingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHostNameBindingsHandleResponse handles the ListHostNameBindings response.
func (client *WebAppsClient) listHostNameBindingsHandleResponse(resp *http.Response) (WebAppsClientListHostNameBindingsResponse, error) {
	result := WebAppsClientListHostNameBindingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostNameBindingCollection); err != nil {
		return WebAppsClientListHostNameBindingsResponse{}, err
	}
	return result, nil
}

// NewListHostNameBindingsSlotPager - Description for Get hostname bindings for an app or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API gets hostname bindings for the production slot.
// options - WebAppsClientListHostNameBindingsSlotOptions contains the optional parameters for the WebAppsClient.ListHostNameBindingsSlot
// method.
func (client *WebAppsClient) NewListHostNameBindingsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListHostNameBindingsSlotOptions) *runtime.Pager[WebAppsClientListHostNameBindingsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListHostNameBindingsSlotResponse]{
		More: func(page WebAppsClientListHostNameBindingsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListHostNameBindingsSlotResponse) (WebAppsClientListHostNameBindingsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listHostNameBindingsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListHostNameBindingsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListHostNameBindingsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListHostNameBindingsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHostNameBindingsSlotHandleResponse(resp)
		},
	})
}

// listHostNameBindingsSlotCreateRequest creates the ListHostNameBindingsSlot request.
func (client *WebAppsClient) listHostNameBindingsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListHostNameBindingsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHostNameBindingsSlotHandleResponse handles the ListHostNameBindingsSlot response.
func (client *WebAppsClient) listHostNameBindingsSlotHandleResponse(resp *http.Response) (WebAppsClientListHostNameBindingsSlotResponse, error) {
	result := WebAppsClientListHostNameBindingsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostNameBindingCollection); err != nil {
		return WebAppsClientListHostNameBindingsSlotResponse{}, err
	}
	return result, nil
}

// ListHybridConnections - Description for Retrieves all Service Bus Hybrid Connections used by this Web App.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// options - WebAppsClientListHybridConnectionsOptions contains the optional parameters for the WebAppsClient.ListHybridConnections
// method.
func (client *WebAppsClient) ListHybridConnections(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListHybridConnectionsOptions) (WebAppsClientListHybridConnectionsResponse, error) {
	req, err := client.listHybridConnectionsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListHybridConnectionsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListHybridConnectionsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListHybridConnectionsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHybridConnectionsHandleResponse(resp)
}

// listHybridConnectionsCreateRequest creates the ListHybridConnections request.
func (client *WebAppsClient) listHybridConnectionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListHybridConnectionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHybridConnectionsHandleResponse handles the ListHybridConnections response.
func (client *WebAppsClient) listHybridConnectionsHandleResponse(resp *http.Response) (WebAppsClientListHybridConnectionsResponse, error) {
	result := WebAppsClientListHybridConnectionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnection); err != nil {
		return WebAppsClientListHybridConnectionsResponse{}, err
	}
	return result, nil
}

// ListHybridConnectionsSlot - Description for Retrieves all Service Bus Hybrid Connections used by this Web App.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - The name of the web app.
// slot - The name of the slot for the web app.
// options - WebAppsClientListHybridConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListHybridConnectionsSlot
// method.
func (client *WebAppsClient) ListHybridConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListHybridConnectionsSlotOptions) (WebAppsClientListHybridConnectionsSlotResponse, error) {
	req, err := client.listHybridConnectionsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListHybridConnectionsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListHybridConnectionsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListHybridConnectionsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHybridConnectionsSlotHandleResponse(resp)
}

// listHybridConnectionsSlotCreateRequest creates the ListHybridConnectionsSlot request.
func (client *WebAppsClient) listHybridConnectionsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListHybridConnectionsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHybridConnectionsSlotHandleResponse handles the ListHybridConnectionsSlot response.
func (client *WebAppsClient) listHybridConnectionsSlotHandleResponse(resp *http.Response) (WebAppsClientListHybridConnectionsSlotResponse, error) {
	result := WebAppsClientListHybridConnectionsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnection); err != nil {
		return WebAppsClientListHybridConnectionsSlotResponse{}, err
	}
	return result, nil
}

// NewListInstanceFunctionsSlotPager - Description for List the functions for a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// slot - Name of the deployment slot.
// options - WebAppsClientListInstanceFunctionsSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceFunctionsSlot
// method.
func (client *WebAppsClient) NewListInstanceFunctionsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListInstanceFunctionsSlotOptions) *runtime.Pager[WebAppsClientListInstanceFunctionsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceFunctionsSlotResponse]{
		More: func(page WebAppsClientListInstanceFunctionsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceFunctionsSlotResponse) (WebAppsClientListInstanceFunctionsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceFunctionsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceFunctionsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceFunctionsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceFunctionsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceFunctionsSlotHandleResponse(resp)
		},
	})
}

// listInstanceFunctionsSlotCreateRequest creates the ListInstanceFunctionsSlot request.
func (client *WebAppsClient) listInstanceFunctionsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListInstanceFunctionsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceFunctionsSlotHandleResponse handles the ListInstanceFunctionsSlot response.
func (client *WebAppsClient) listInstanceFunctionsSlotHandleResponse(resp *http.Response) (WebAppsClientListInstanceFunctionsSlotResponse, error) {
	result := WebAppsClientListInstanceFunctionsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionEnvelopeCollection); err != nil {
		return WebAppsClientListInstanceFunctionsSlotResponse{}, err
	}
	return result, nil
}

// NewListInstanceIdentifiersPager - Description for Gets all scale-out instances of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListInstanceIdentifiersOptions contains the optional parameters for the WebAppsClient.ListInstanceIdentifiers
// method.
func (client *WebAppsClient) NewListInstanceIdentifiersPager(resourceGroupName string, name string, options *WebAppsClientListInstanceIdentifiersOptions) *runtime.Pager[WebAppsClientListInstanceIdentifiersResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceIdentifiersResponse]{
		More: func(page WebAppsClientListInstanceIdentifiersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceIdentifiersResponse) (WebAppsClientListInstanceIdentifiersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceIdentifiersCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceIdentifiersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceIdentifiersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceIdentifiersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceIdentifiersHandleResponse(resp)
		},
	})
}

// listInstanceIdentifiersCreateRequest creates the ListInstanceIdentifiers request.
func (client *WebAppsClient) listInstanceIdentifiersCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListInstanceIdentifiersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceIdentifiersHandleResponse handles the ListInstanceIdentifiers response.
func (client *WebAppsClient) listInstanceIdentifiersHandleResponse(resp *http.Response) (WebAppsClientListInstanceIdentifiersResponse, error) {
	result := WebAppsClientListInstanceIdentifiersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppInstanceStatusCollection); err != nil {
		return WebAppsClientListInstanceIdentifiersResponse{}, err
	}
	return result, nil
}

// NewListInstanceIdentifiersSlotPager - Description for Gets all scale-out instances of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API gets the production slot instances.
// options - WebAppsClientListInstanceIdentifiersSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceIdentifiersSlot
// method.
func (client *WebAppsClient) NewListInstanceIdentifiersSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListInstanceIdentifiersSlotOptions) *runtime.Pager[WebAppsClientListInstanceIdentifiersSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceIdentifiersSlotResponse]{
		More: func(page WebAppsClientListInstanceIdentifiersSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceIdentifiersSlotResponse) (WebAppsClientListInstanceIdentifiersSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceIdentifiersSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceIdentifiersSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceIdentifiersSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceIdentifiersSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceIdentifiersSlotHandleResponse(resp)
		},
	})
}

// listInstanceIdentifiersSlotCreateRequest creates the ListInstanceIdentifiersSlot request.
func (client *WebAppsClient) listInstanceIdentifiersSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListInstanceIdentifiersSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceIdentifiersSlotHandleResponse handles the ListInstanceIdentifiersSlot response.
func (client *WebAppsClient) listInstanceIdentifiersSlotHandleResponse(resp *http.Response) (WebAppsClientListInstanceIdentifiersSlotResponse, error) {
	result := WebAppsClientListInstanceIdentifiersSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppInstanceStatusCollection); err != nil {
		return WebAppsClientListInstanceIdentifiersSlotResponse{}, err
	}
	return result, nil
}

// NewListInstanceProcessModulesPager - Description for List module information for a process by its ID for a specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientListInstanceProcessModulesOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessModules
// method.
func (client *WebAppsClient) NewListInstanceProcessModulesPager(resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientListInstanceProcessModulesOptions) *runtime.Pager[WebAppsClientListInstanceProcessModulesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceProcessModulesResponse]{
		More: func(page WebAppsClientListInstanceProcessModulesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceProcessModulesResponse) (WebAppsClientListInstanceProcessModulesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceProcessModulesCreateRequest(ctx, resourceGroupName, name, processID, instanceID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceProcessModulesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceProcessModulesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceProcessModulesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceProcessModulesHandleResponse(resp)
		},
	})
}

// listInstanceProcessModulesCreateRequest creates the ListInstanceProcessModules request.
func (client *WebAppsClient) listInstanceProcessModulesCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientListInstanceProcessModulesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceProcessModulesHandleResponse handles the ListInstanceProcessModules response.
func (client *WebAppsClient) listInstanceProcessModulesHandleResponse(resp *http.Response) (WebAppsClientListInstanceProcessModulesResponse, error) {
	result := WebAppsClientListInstanceProcessModulesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfoCollection); err != nil {
		return WebAppsClientListInstanceProcessModulesResponse{}, err
	}
	return result, nil
}

// NewListInstanceProcessModulesSlotPager - Description for List module information for a process by its ID for a specific
// scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientListInstanceProcessModulesSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessModulesSlot
// method.
func (client *WebAppsClient) NewListInstanceProcessModulesSlotPager(resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientListInstanceProcessModulesSlotOptions) *runtime.Pager[WebAppsClientListInstanceProcessModulesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceProcessModulesSlotResponse]{
		More: func(page WebAppsClientListInstanceProcessModulesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceProcessModulesSlotResponse) (WebAppsClientListInstanceProcessModulesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceProcessModulesSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, instanceID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceProcessModulesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceProcessModulesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceProcessModulesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceProcessModulesSlotHandleResponse(resp)
		},
	})
}

// listInstanceProcessModulesSlotCreateRequest creates the ListInstanceProcessModulesSlot request.
func (client *WebAppsClient) listInstanceProcessModulesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientListInstanceProcessModulesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceProcessModulesSlotHandleResponse handles the ListInstanceProcessModulesSlot response.
func (client *WebAppsClient) listInstanceProcessModulesSlotHandleResponse(resp *http.Response) (WebAppsClientListInstanceProcessModulesSlotResponse, error) {
	result := WebAppsClientListInstanceProcessModulesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfoCollection); err != nil {
		return WebAppsClientListInstanceProcessModulesSlotResponse{}, err
	}
	return result, nil
}

// NewListInstanceProcessThreadsPager - Description for List the threads in a process by its ID for a specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientListInstanceProcessThreadsOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessThreads
// method.
func (client *WebAppsClient) NewListInstanceProcessThreadsPager(resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientListInstanceProcessThreadsOptions) *runtime.Pager[WebAppsClientListInstanceProcessThreadsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceProcessThreadsResponse]{
		More: func(page WebAppsClientListInstanceProcessThreadsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceProcessThreadsResponse) (WebAppsClientListInstanceProcessThreadsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceProcessThreadsCreateRequest(ctx, resourceGroupName, name, processID, instanceID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceProcessThreadsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceProcessThreadsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceProcessThreadsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceProcessThreadsHandleResponse(resp)
		},
	})
}

// listInstanceProcessThreadsCreateRequest creates the ListInstanceProcessThreads request.
func (client *WebAppsClient) listInstanceProcessThreadsCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string, options *WebAppsClientListInstanceProcessThreadsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceProcessThreadsHandleResponse handles the ListInstanceProcessThreads response.
func (client *WebAppsClient) listInstanceProcessThreadsHandleResponse(resp *http.Response) (WebAppsClientListInstanceProcessThreadsResponse, error) {
	result := WebAppsClientListInstanceProcessThreadsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessThreadInfoCollection); err != nil {
		return WebAppsClientListInstanceProcessThreadsResponse{}, err
	}
	return result, nil
}

// NewListInstanceProcessThreadsSlotPager - Description for List the threads in a process by its ID for a specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientListInstanceProcessThreadsSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessThreadsSlot
// method.
func (client *WebAppsClient) NewListInstanceProcessThreadsSlotPager(resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientListInstanceProcessThreadsSlotOptions) *runtime.Pager[WebAppsClientListInstanceProcessThreadsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceProcessThreadsSlotResponse]{
		More: func(page WebAppsClientListInstanceProcessThreadsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceProcessThreadsSlotResponse) (WebAppsClientListInstanceProcessThreadsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceProcessThreadsSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, instanceID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceProcessThreadsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceProcessThreadsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceProcessThreadsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceProcessThreadsSlotHandleResponse(resp)
		},
	})
}

// listInstanceProcessThreadsSlotCreateRequest creates the ListInstanceProcessThreadsSlot request.
func (client *WebAppsClient) listInstanceProcessThreadsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string, options *WebAppsClientListInstanceProcessThreadsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceProcessThreadsSlotHandleResponse handles the ListInstanceProcessThreadsSlot response.
func (client *WebAppsClient) listInstanceProcessThreadsSlotHandleResponse(resp *http.Response) (WebAppsClientListInstanceProcessThreadsSlotResponse, error) {
	result := WebAppsClientListInstanceProcessThreadsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessThreadInfoCollection); err != nil {
		return WebAppsClientListInstanceProcessThreadsSlotResponse{}, err
	}
	return result, nil
}

// NewListInstanceProcessesPager - Description for Get list of processes for a web site, or a deployment slot, or for a specific
// scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientListInstanceProcessesOptions contains the optional parameters for the WebAppsClient.ListInstanceProcesses
// method.
func (client *WebAppsClient) NewListInstanceProcessesPager(resourceGroupName string, name string, instanceID string, options *WebAppsClientListInstanceProcessesOptions) *runtime.Pager[WebAppsClientListInstanceProcessesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceProcessesResponse]{
		More: func(page WebAppsClientListInstanceProcessesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceProcessesResponse) (WebAppsClientListInstanceProcessesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceProcessesCreateRequest(ctx, resourceGroupName, name, instanceID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceProcessesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceProcessesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceProcessesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceProcessesHandleResponse(resp)
		},
	})
}

// listInstanceProcessesCreateRequest creates the ListInstanceProcesses request.
func (client *WebAppsClient) listInstanceProcessesCreateRequest(ctx context.Context, resourceGroupName string, name string, instanceID string, options *WebAppsClientListInstanceProcessesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceProcessesHandleResponse handles the ListInstanceProcesses response.
func (client *WebAppsClient) listInstanceProcessesHandleResponse(resp *http.Response) (WebAppsClientListInstanceProcessesResponse, error) {
	result := WebAppsClientListInstanceProcessesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfoCollection); err != nil {
		return WebAppsClientListInstanceProcessesResponse{}, err
	}
	return result, nil
}

// NewListInstanceProcessesSlotPager - Description for Get list of processes for a web site, or a deployment slot, or for
// a specific scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
// options - WebAppsClientListInstanceProcessesSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessesSlot
// method.
func (client *WebAppsClient) NewListInstanceProcessesSlotPager(resourceGroupName string, name string, slot string, instanceID string, options *WebAppsClientListInstanceProcessesSlotOptions) *runtime.Pager[WebAppsClientListInstanceProcessesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListInstanceProcessesSlotResponse]{
		More: func(page WebAppsClientListInstanceProcessesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListInstanceProcessesSlotResponse) (WebAppsClientListInstanceProcessesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listInstanceProcessesSlotCreateRequest(ctx, resourceGroupName, name, slot, instanceID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListInstanceProcessesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListInstanceProcessesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListInstanceProcessesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listInstanceProcessesSlotHandleResponse(resp)
		},
	})
}

// listInstanceProcessesSlotCreateRequest creates the ListInstanceProcessesSlot request.
func (client *WebAppsClient) listInstanceProcessesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, options *WebAppsClientListInstanceProcessesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if instanceID == "" {
		return nil, errors.New("parameter instanceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instanceId}", url.PathEscape(instanceID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInstanceProcessesSlotHandleResponse handles the ListInstanceProcessesSlot response.
func (client *WebAppsClient) listInstanceProcessesSlotHandleResponse(resp *http.Response) (WebAppsClientListInstanceProcessesSlotResponse, error) {
	result := WebAppsClientListInstanceProcessesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfoCollection); err != nil {
		return WebAppsClientListInstanceProcessesSlotResponse{}, err
	}
	return result, nil
}

// ListMetadata - Description for Gets the metadata of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListMetadataOptions contains the optional parameters for the WebAppsClient.ListMetadata method.
func (client *WebAppsClient) ListMetadata(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListMetadataOptions) (WebAppsClientListMetadataResponse, error) {
	req, err := client.listMetadataCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListMetadataResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListMetadataResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListMetadataResponse{}, runtime.NewResponseError(resp)
	}
	return client.listMetadataHandleResponse(resp)
}

// listMetadataCreateRequest creates the ListMetadata request.
func (client *WebAppsClient) listMetadataCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListMetadataOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetadataHandleResponse handles the ListMetadata response.
func (client *WebAppsClient) listMetadataHandleResponse(resp *http.Response) (WebAppsClientListMetadataResponse, error) {
	result := WebAppsClientListMetadataResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return WebAppsClientListMetadataResponse{}, err
	}
	return result, nil
}

// ListMetadataSlot - Description for Gets the metadata of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the metadata for the production slot.
// options - WebAppsClientListMetadataSlotOptions contains the optional parameters for the WebAppsClient.ListMetadataSlot
// method.
func (client *WebAppsClient) ListMetadataSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListMetadataSlotOptions) (WebAppsClientListMetadataSlotResponse, error) {
	req, err := client.listMetadataSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListMetadataSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListMetadataSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListMetadataSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listMetadataSlotHandleResponse(resp)
}

// listMetadataSlotCreateRequest creates the ListMetadataSlot request.
func (client *WebAppsClient) listMetadataSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListMetadataSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetadataSlotHandleResponse handles the ListMetadataSlot response.
func (client *WebAppsClient) listMetadataSlotHandleResponse(resp *http.Response) (WebAppsClientListMetadataSlotResponse, error) {
	result := WebAppsClientListMetadataSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return WebAppsClientListMetadataSlotResponse{}, err
	}
	return result, nil
}

// ListNetworkFeatures - Description for Gets all network features used by the app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// view - The type of view. Only "summary" is supported at this time.
// options - WebAppsClientListNetworkFeaturesOptions contains the optional parameters for the WebAppsClient.ListNetworkFeatures
// method.
func (client *WebAppsClient) ListNetworkFeatures(ctx context.Context, resourceGroupName string, name string, view string, options *WebAppsClientListNetworkFeaturesOptions) (WebAppsClientListNetworkFeaturesResponse, error) {
	req, err := client.listNetworkFeaturesCreateRequest(ctx, resourceGroupName, name, view, options)
	if err != nil {
		return WebAppsClientListNetworkFeaturesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListNetworkFeaturesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListNetworkFeaturesResponse{}, runtime.NewResponseError(resp)
	}
	return client.listNetworkFeaturesHandleResponse(resp)
}

// listNetworkFeaturesCreateRequest creates the ListNetworkFeatures request.
func (client *WebAppsClient) listNetworkFeaturesCreateRequest(ctx context.Context, resourceGroupName string, name string, view string, options *WebAppsClientListNetworkFeaturesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if view == "" {
		return nil, errors.New("parameter view cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{view}", url.PathEscape(view))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listNetworkFeaturesHandleResponse handles the ListNetworkFeatures response.
func (client *WebAppsClient) listNetworkFeaturesHandleResponse(resp *http.Response) (WebAppsClientListNetworkFeaturesResponse, error) {
	result := WebAppsClientListNetworkFeaturesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkFeatures); err != nil {
		return WebAppsClientListNetworkFeaturesResponse{}, err
	}
	return result, nil
}

// ListNetworkFeaturesSlot - Description for Gets all network features used by the app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// view - The type of view. Only "summary" is supported at this time.
// slot - Name of the deployment slot. If a slot is not specified, the API will get network features for the production slot.
// options - WebAppsClientListNetworkFeaturesSlotOptions contains the optional parameters for the WebAppsClient.ListNetworkFeaturesSlot
// method.
func (client *WebAppsClient) ListNetworkFeaturesSlot(ctx context.Context, resourceGroupName string, name string, view string, slot string, options *WebAppsClientListNetworkFeaturesSlotOptions) (WebAppsClientListNetworkFeaturesSlotResponse, error) {
	req, err := client.listNetworkFeaturesSlotCreateRequest(ctx, resourceGroupName, name, view, slot, options)
	if err != nil {
		return WebAppsClientListNetworkFeaturesSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListNetworkFeaturesSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListNetworkFeaturesSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listNetworkFeaturesSlotHandleResponse(resp)
}

// listNetworkFeaturesSlotCreateRequest creates the ListNetworkFeaturesSlot request.
func (client *WebAppsClient) listNetworkFeaturesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, view string, slot string, options *WebAppsClientListNetworkFeaturesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if view == "" {
		return nil, errors.New("parameter view cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{view}", url.PathEscape(view))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listNetworkFeaturesSlotHandleResponse handles the ListNetworkFeaturesSlot response.
func (client *WebAppsClient) listNetworkFeaturesSlotHandleResponse(resp *http.Response) (WebAppsClientListNetworkFeaturesSlotResponse, error) {
	result := WebAppsClientListNetworkFeaturesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkFeatures); err != nil {
		return WebAppsClientListNetworkFeaturesSlotResponse{}, err
	}
	return result, nil
}

// NewListPerfMonCountersPager - Description for Gets perfmon counters for web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientListPerfMonCountersOptions contains the optional parameters for the WebAppsClient.ListPerfMonCounters
// method.
func (client *WebAppsClient) NewListPerfMonCountersPager(resourceGroupName string, name string, options *WebAppsClientListPerfMonCountersOptions) *runtime.Pager[WebAppsClientListPerfMonCountersResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListPerfMonCountersResponse]{
		More: func(page WebAppsClientListPerfMonCountersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListPerfMonCountersResponse) (WebAppsClientListPerfMonCountersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listPerfMonCountersCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListPerfMonCountersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListPerfMonCountersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListPerfMonCountersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listPerfMonCountersHandleResponse(resp)
		},
	})
}

// listPerfMonCountersCreateRequest creates the ListPerfMonCounters request.
func (client *WebAppsClient) listPerfMonCountersCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListPerfMonCountersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPerfMonCountersHandleResponse handles the ListPerfMonCounters response.
func (client *WebAppsClient) listPerfMonCountersHandleResponse(resp *http.Response) (WebAppsClientListPerfMonCountersResponse, error) {
	result := WebAppsClientListPerfMonCountersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PerfMonCounterCollection); err != nil {
		return WebAppsClientListPerfMonCountersResponse{}, err
	}
	return result, nil
}

// NewListPerfMonCountersSlotPager - Description for Gets perfmon counters for web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientListPerfMonCountersSlotOptions contains the optional parameters for the WebAppsClient.ListPerfMonCountersSlot
// method.
func (client *WebAppsClient) NewListPerfMonCountersSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListPerfMonCountersSlotOptions) *runtime.Pager[WebAppsClientListPerfMonCountersSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListPerfMonCountersSlotResponse]{
		More: func(page WebAppsClientListPerfMonCountersSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListPerfMonCountersSlotResponse) (WebAppsClientListPerfMonCountersSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listPerfMonCountersSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListPerfMonCountersSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListPerfMonCountersSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListPerfMonCountersSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listPerfMonCountersSlotHandleResponse(resp)
		},
	})
}

// listPerfMonCountersSlotCreateRequest creates the ListPerfMonCountersSlot request.
func (client *WebAppsClient) listPerfMonCountersSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListPerfMonCountersSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPerfMonCountersSlotHandleResponse handles the ListPerfMonCountersSlot response.
func (client *WebAppsClient) listPerfMonCountersSlotHandleResponse(resp *http.Response) (WebAppsClientListPerfMonCountersSlotResponse, error) {
	result := WebAppsClientListPerfMonCountersSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PerfMonCounterCollection); err != nil {
		return WebAppsClientListPerfMonCountersSlotResponse{}, err
	}
	return result, nil
}

// ListPremierAddOns - Description for Gets the premier add-ons of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListPremierAddOnsOptions contains the optional parameters for the WebAppsClient.ListPremierAddOns
// method.
func (client *WebAppsClient) ListPremierAddOns(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListPremierAddOnsOptions) (WebAppsClientListPremierAddOnsResponse, error) {
	req, err := client.listPremierAddOnsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListPremierAddOnsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListPremierAddOnsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListPremierAddOnsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listPremierAddOnsHandleResponse(resp)
}

// listPremierAddOnsCreateRequest creates the ListPremierAddOns request.
func (client *WebAppsClient) listPremierAddOnsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListPremierAddOnsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPremierAddOnsHandleResponse handles the ListPremierAddOns response.
func (client *WebAppsClient) listPremierAddOnsHandleResponse(resp *http.Response) (WebAppsClientListPremierAddOnsResponse, error) {
	result := WebAppsClientListPremierAddOnsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PremierAddOn); err != nil {
		return WebAppsClientListPremierAddOnsResponse{}, err
	}
	return result, nil
}

// ListPremierAddOnsSlot - Description for Gets the premier add-ons of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the premier add-ons for the production
// slot.
// options - WebAppsClientListPremierAddOnsSlotOptions contains the optional parameters for the WebAppsClient.ListPremierAddOnsSlot
// method.
func (client *WebAppsClient) ListPremierAddOnsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListPremierAddOnsSlotOptions) (WebAppsClientListPremierAddOnsSlotResponse, error) {
	req, err := client.listPremierAddOnsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListPremierAddOnsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListPremierAddOnsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListPremierAddOnsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listPremierAddOnsSlotHandleResponse(resp)
}

// listPremierAddOnsSlotCreateRequest creates the ListPremierAddOnsSlot request.
func (client *WebAppsClient) listPremierAddOnsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListPremierAddOnsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPremierAddOnsSlotHandleResponse handles the ListPremierAddOnsSlot response.
func (client *WebAppsClient) listPremierAddOnsSlotHandleResponse(resp *http.Response) (WebAppsClientListPremierAddOnsSlotResponse, error) {
	result := WebAppsClientListPremierAddOnsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PremierAddOn); err != nil {
		return WebAppsClientListPremierAddOnsSlotResponse{}, err
	}
	return result, nil
}

// NewListProcessModulesPager - Description for List module information for a process by its ID for a specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// options - WebAppsClientListProcessModulesOptions contains the optional parameters for the WebAppsClient.ListProcessModules
// method.
func (client *WebAppsClient) NewListProcessModulesPager(resourceGroupName string, name string, processID string, options *WebAppsClientListProcessModulesOptions) *runtime.Pager[WebAppsClientListProcessModulesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListProcessModulesResponse]{
		More: func(page WebAppsClientListProcessModulesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListProcessModulesResponse) (WebAppsClientListProcessModulesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProcessModulesCreateRequest(ctx, resourceGroupName, name, processID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListProcessModulesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListProcessModulesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListProcessModulesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProcessModulesHandleResponse(resp)
		},
	})
}

// listProcessModulesCreateRequest creates the ListProcessModules request.
func (client *WebAppsClient) listProcessModulesCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientListProcessModulesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProcessModulesHandleResponse handles the ListProcessModules response.
func (client *WebAppsClient) listProcessModulesHandleResponse(resp *http.Response) (WebAppsClientListProcessModulesResponse, error) {
	result := WebAppsClientListProcessModulesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfoCollection); err != nil {
		return WebAppsClientListProcessModulesResponse{}, err
	}
	return result, nil
}

// NewListProcessModulesSlotPager - Description for List module information for a process by its ID for a specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientListProcessModulesSlotOptions contains the optional parameters for the WebAppsClient.ListProcessModulesSlot
// method.
func (client *WebAppsClient) NewListProcessModulesSlotPager(resourceGroupName string, name string, processID string, slot string, options *WebAppsClientListProcessModulesSlotOptions) *runtime.Pager[WebAppsClientListProcessModulesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListProcessModulesSlotResponse]{
		More: func(page WebAppsClientListProcessModulesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListProcessModulesSlotResponse) (WebAppsClientListProcessModulesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProcessModulesSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListProcessModulesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListProcessModulesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListProcessModulesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProcessModulesSlotHandleResponse(resp)
		},
	})
}

// listProcessModulesSlotCreateRequest creates the ListProcessModulesSlot request.
func (client *WebAppsClient) listProcessModulesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientListProcessModulesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProcessModulesSlotHandleResponse handles the ListProcessModulesSlot response.
func (client *WebAppsClient) listProcessModulesSlotHandleResponse(resp *http.Response) (WebAppsClientListProcessModulesSlotResponse, error) {
	result := WebAppsClientListProcessModulesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessModuleInfoCollection); err != nil {
		return WebAppsClientListProcessModulesSlotResponse{}, err
	}
	return result, nil
}

// NewListProcessThreadsPager - Description for List the threads in a process by its ID for a specific scaled-out instance
// in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// options - WebAppsClientListProcessThreadsOptions contains the optional parameters for the WebAppsClient.ListProcessThreads
// method.
func (client *WebAppsClient) NewListProcessThreadsPager(resourceGroupName string, name string, processID string, options *WebAppsClientListProcessThreadsOptions) *runtime.Pager[WebAppsClientListProcessThreadsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListProcessThreadsResponse]{
		More: func(page WebAppsClientListProcessThreadsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListProcessThreadsResponse) (WebAppsClientListProcessThreadsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProcessThreadsCreateRequest(ctx, resourceGroupName, name, processID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListProcessThreadsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListProcessThreadsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListProcessThreadsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProcessThreadsHandleResponse(resp)
		},
	})
}

// listProcessThreadsCreateRequest creates the ListProcessThreads request.
func (client *WebAppsClient) listProcessThreadsCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, options *WebAppsClientListProcessThreadsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProcessThreadsHandleResponse handles the ListProcessThreads response.
func (client *WebAppsClient) listProcessThreadsHandleResponse(resp *http.Response) (WebAppsClientListProcessThreadsResponse, error) {
	result := WebAppsClientListProcessThreadsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessThreadInfoCollection); err != nil {
		return WebAppsClientListProcessThreadsResponse{}, err
	}
	return result, nil
}

// NewListProcessThreadsSlotPager - Description for List the threads in a process by its ID for a specific scaled-out instance
// in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// processID - PID.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientListProcessThreadsSlotOptions contains the optional parameters for the WebAppsClient.ListProcessThreadsSlot
// method.
func (client *WebAppsClient) NewListProcessThreadsSlotPager(resourceGroupName string, name string, processID string, slot string, options *WebAppsClientListProcessThreadsSlotOptions) *runtime.Pager[WebAppsClientListProcessThreadsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListProcessThreadsSlotResponse]{
		More: func(page WebAppsClientListProcessThreadsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListProcessThreadsSlotResponse) (WebAppsClientListProcessThreadsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProcessThreadsSlotCreateRequest(ctx, resourceGroupName, name, processID, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListProcessThreadsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListProcessThreadsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListProcessThreadsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProcessThreadsSlotHandleResponse(resp)
		},
	})
}

// listProcessThreadsSlotCreateRequest creates the ListProcessThreadsSlot request.
func (client *WebAppsClient) listProcessThreadsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, processID string, slot string, options *WebAppsClientListProcessThreadsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if processID == "" {
		return nil, errors.New("parameter processID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{processId}", url.PathEscape(processID))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProcessThreadsSlotHandleResponse handles the ListProcessThreadsSlot response.
func (client *WebAppsClient) listProcessThreadsSlotHandleResponse(resp *http.Response) (WebAppsClientListProcessThreadsSlotResponse, error) {
	result := WebAppsClientListProcessThreadsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessThreadInfoCollection); err != nil {
		return WebAppsClientListProcessThreadsSlotResponse{}, err
	}
	return result, nil
}

// NewListProcessesPager - Description for Get list of processes for a web site, or a deployment slot, or for a specific scaled-out
// instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// options - WebAppsClientListProcessesOptions contains the optional parameters for the WebAppsClient.ListProcesses method.
func (client *WebAppsClient) NewListProcessesPager(resourceGroupName string, name string, options *WebAppsClientListProcessesOptions) *runtime.Pager[WebAppsClientListProcessesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListProcessesResponse]{
		More: func(page WebAppsClientListProcessesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListProcessesResponse) (WebAppsClientListProcessesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProcessesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListProcessesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListProcessesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListProcessesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProcessesHandleResponse(resp)
		},
	})
}

// listProcessesCreateRequest creates the ListProcesses request.
func (client *WebAppsClient) listProcessesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListProcessesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProcessesHandleResponse handles the ListProcesses response.
func (client *WebAppsClient) listProcessesHandleResponse(resp *http.Response) (WebAppsClientListProcessesResponse, error) {
	result := WebAppsClientListProcessesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfoCollection); err != nil {
		return WebAppsClientListProcessesResponse{}, err
	}
	return result, nil
}

// NewListProcessesSlotPager - Description for Get list of processes for a web site, or a deployment slot, or for a specific
// scaled-out instance in a web site.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// slot - Name of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
// options - WebAppsClientListProcessesSlotOptions contains the optional parameters for the WebAppsClient.ListProcessesSlot
// method.
func (client *WebAppsClient) NewListProcessesSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListProcessesSlotOptions) *runtime.Pager[WebAppsClientListProcessesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListProcessesSlotResponse]{
		More: func(page WebAppsClientListProcessesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListProcessesSlotResponse) (WebAppsClientListProcessesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProcessesSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListProcessesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListProcessesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListProcessesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProcessesSlotHandleResponse(resp)
		},
	})
}

// listProcessesSlotCreateRequest creates the ListProcessesSlot request.
func (client *WebAppsClient) listProcessesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListProcessesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProcessesSlotHandleResponse handles the ListProcessesSlot response.
func (client *WebAppsClient) listProcessesSlotHandleResponse(resp *http.Response) (WebAppsClientListProcessesSlotResponse, error) {
	result := WebAppsClientListProcessesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProcessInfoCollection); err != nil {
		return WebAppsClientListProcessesSlotResponse{}, err
	}
	return result, nil
}

// NewListProductionSiteDeploymentStatusesPager - List deployment statuses for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListProductionSiteDeploymentStatusesOptions contains the optional parameters for the WebAppsClient.ListProductionSiteDeploymentStatuses
// method.
func (client *WebAppsClient) NewListProductionSiteDeploymentStatusesPager(resourceGroupName string, name string, options *WebAppsClientListProductionSiteDeploymentStatusesOptions) *runtime.Pager[WebAppsClientListProductionSiteDeploymentStatusesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListProductionSiteDeploymentStatusesResponse]{
		More: func(page WebAppsClientListProductionSiteDeploymentStatusesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListProductionSiteDeploymentStatusesResponse) (WebAppsClientListProductionSiteDeploymentStatusesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProductionSiteDeploymentStatusesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListProductionSiteDeploymentStatusesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListProductionSiteDeploymentStatusesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListProductionSiteDeploymentStatusesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProductionSiteDeploymentStatusesHandleResponse(resp)
		},
	})
}

// listProductionSiteDeploymentStatusesCreateRequest creates the ListProductionSiteDeploymentStatuses request.
func (client *WebAppsClient) listProductionSiteDeploymentStatusesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListProductionSiteDeploymentStatusesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deploymentStatus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProductionSiteDeploymentStatusesHandleResponse handles the ListProductionSiteDeploymentStatuses response.
func (client *WebAppsClient) listProductionSiteDeploymentStatusesHandleResponse(resp *http.Response) (WebAppsClientListProductionSiteDeploymentStatusesResponse, error) {
	result := WebAppsClientListProductionSiteDeploymentStatusesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmDeploymentStatusCollection); err != nil {
		return WebAppsClientListProductionSiteDeploymentStatusesResponse{}, err
	}
	return result, nil
}

// NewListPublicCertificatesPager - Description for Get public certificates for an app or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListPublicCertificatesOptions contains the optional parameters for the WebAppsClient.ListPublicCertificates
// method.
func (client *WebAppsClient) NewListPublicCertificatesPager(resourceGroupName string, name string, options *WebAppsClientListPublicCertificatesOptions) *runtime.Pager[WebAppsClientListPublicCertificatesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListPublicCertificatesResponse]{
		More: func(page WebAppsClientListPublicCertificatesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListPublicCertificatesResponse) (WebAppsClientListPublicCertificatesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listPublicCertificatesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListPublicCertificatesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListPublicCertificatesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListPublicCertificatesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listPublicCertificatesHandleResponse(resp)
		},
	})
}

// listPublicCertificatesCreateRequest creates the ListPublicCertificates request.
func (client *WebAppsClient) listPublicCertificatesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListPublicCertificatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPublicCertificatesHandleResponse handles the ListPublicCertificates response.
func (client *WebAppsClient) listPublicCertificatesHandleResponse(resp *http.Response) (WebAppsClientListPublicCertificatesResponse, error) {
	result := WebAppsClientListPublicCertificatesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublicCertificateCollection); err != nil {
		return WebAppsClientListPublicCertificatesResponse{}, err
	}
	return result, nil
}

// NewListPublicCertificatesSlotPager - Description for Get public certificates for an app or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API gets hostname bindings for the production slot.
// options - WebAppsClientListPublicCertificatesSlotOptions contains the optional parameters for the WebAppsClient.ListPublicCertificatesSlot
// method.
func (client *WebAppsClient) NewListPublicCertificatesSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListPublicCertificatesSlotOptions) *runtime.Pager[WebAppsClientListPublicCertificatesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListPublicCertificatesSlotResponse]{
		More: func(page WebAppsClientListPublicCertificatesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListPublicCertificatesSlotResponse) (WebAppsClientListPublicCertificatesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listPublicCertificatesSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListPublicCertificatesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListPublicCertificatesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListPublicCertificatesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listPublicCertificatesSlotHandleResponse(resp)
		},
	})
}

// listPublicCertificatesSlotCreateRequest creates the ListPublicCertificatesSlot request.
func (client *WebAppsClient) listPublicCertificatesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListPublicCertificatesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPublicCertificatesSlotHandleResponse handles the ListPublicCertificatesSlot response.
func (client *WebAppsClient) listPublicCertificatesSlotHandleResponse(resp *http.Response) (WebAppsClientListPublicCertificatesSlotResponse, error) {
	result := WebAppsClientListPublicCertificatesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublicCertificateCollection); err != nil {
		return WebAppsClientListPublicCertificatesSlotResponse{}, err
	}
	return result, nil
}

// BeginListPublishingCredentials - Description for Gets the Git/FTP publishing credentials of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientBeginListPublishingCredentialsOptions contains the optional parameters for the WebAppsClient.BeginListPublishingCredentials
// method.
func (client *WebAppsClient) BeginListPublishingCredentials(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientBeginListPublishingCredentialsOptions) (*runtime.Poller[WebAppsClientListPublishingCredentialsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.listPublishingCredentials(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientListPublishingCredentialsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientListPublishingCredentialsResponse](options.ResumeToken, client.pl, nil)
	}
}

// ListPublishingCredentials - Description for Gets the Git/FTP publishing credentials of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) listPublishingCredentials(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientBeginListPublishingCredentialsOptions) (*http.Response, error) {
	req, err := client.listPublishingCredentialsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// listPublishingCredentialsCreateRequest creates the ListPublishingCredentials request.
func (client *WebAppsClient) listPublishingCredentialsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientBeginListPublishingCredentialsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginListPublishingCredentialsSlot - Description for Gets the Git/FTP publishing credentials of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials for the production
// slot.
// options - WebAppsClientBeginListPublishingCredentialsSlotOptions contains the optional parameters for the WebAppsClient.BeginListPublishingCredentialsSlot
// method.
func (client *WebAppsClient) BeginListPublishingCredentialsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientBeginListPublishingCredentialsSlotOptions) (*runtime.Poller[WebAppsClientListPublishingCredentialsSlotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.listPublishingCredentialsSlot(ctx, resourceGroupName, name, slot, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[WebAppsClientListPublishingCredentialsSlotResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[WebAppsClientListPublishingCredentialsSlotResponse](options.ResumeToken, client.pl, nil)
	}
}

// ListPublishingCredentialsSlot - Description for Gets the Git/FTP publishing credentials of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *WebAppsClient) listPublishingCredentialsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientBeginListPublishingCredentialsSlotOptions) (*http.Response, error) {
	req, err := client.listPublishingCredentialsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// listPublishingCredentialsSlotCreateRequest creates the ListPublishingCredentialsSlot request.
func (client *WebAppsClient) listPublishingCredentialsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientBeginListPublishingCredentialsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// ListPublishingProfileXMLWithSecrets - Description for Gets the publishing profile for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// publishingProfileOptions - Specifies publishingProfileOptions for publishing profile. For example, use {"format": "FileZilla3"}
// to get a FileZilla publishing profile.
// options - WebAppsClientListPublishingProfileXMLWithSecretsOptions contains the optional parameters for the WebAppsClient.ListPublishingProfileXMLWithSecrets
// method.
func (client *WebAppsClient) ListPublishingProfileXMLWithSecrets(ctx context.Context, resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions, options *WebAppsClientListPublishingProfileXMLWithSecretsOptions) (WebAppsClientListPublishingProfileXMLWithSecretsResponse, error) {
	req, err := client.listPublishingProfileXMLWithSecretsCreateRequest(ctx, resourceGroupName, name, publishingProfileOptions, options)
	if err != nil {
		return WebAppsClientListPublishingProfileXMLWithSecretsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListPublishingProfileXMLWithSecretsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListPublishingProfileXMLWithSecretsResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientListPublishingProfileXMLWithSecretsResponse{Body: resp.Body}, nil
}

// listPublishingProfileXMLWithSecretsCreateRequest creates the ListPublishingProfileXMLWithSecrets request.
func (client *WebAppsClient) listPublishingProfileXMLWithSecretsCreateRequest(ctx context.Context, resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions, options *WebAppsClientListPublishingProfileXMLWithSecretsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, runtime.MarshalAsJSON(req, publishingProfileOptions)
}

// ListPublishingProfileXMLWithSecretsSlot - Description for Gets the publishing profile for an app (or deployment slot, if
// specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the publishing profile for the production
// slot.
// publishingProfileOptions - Specifies publishingProfileOptions for publishing profile. For example, use {"format": "FileZilla3"}
// to get a FileZilla publishing profile.
// options - WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListPublishingProfileXMLWithSecretsSlot
// method.
func (client *WebAppsClient) ListPublishingProfileXMLWithSecretsSlot(ctx context.Context, resourceGroupName string, name string, slot string, publishingProfileOptions CsmPublishingProfileOptions, options *WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions) (WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse, error) {
	req, err := client.listPublishingProfileXMLWithSecretsSlotCreateRequest(ctx, resourceGroupName, name, slot, publishingProfileOptions, options)
	if err != nil {
		return WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse{Body: resp.Body}, nil
}

// listPublishingProfileXMLWithSecretsSlotCreateRequest creates the ListPublishingProfileXMLWithSecretsSlot request.
func (client *WebAppsClient) listPublishingProfileXMLWithSecretsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, publishingProfileOptions CsmPublishingProfileOptions, options *WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, runtime.MarshalAsJSON(req, publishingProfileOptions)
}

// ListRelayServiceConnections - Description for Gets hybrid connections configured for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListRelayServiceConnectionsOptions contains the optional parameters for the WebAppsClient.ListRelayServiceConnections
// method.
func (client *WebAppsClient) ListRelayServiceConnections(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListRelayServiceConnectionsOptions) (WebAppsClientListRelayServiceConnectionsResponse, error) {
	req, err := client.listRelayServiceConnectionsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListRelayServiceConnectionsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListRelayServiceConnectionsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListRelayServiceConnectionsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listRelayServiceConnectionsHandleResponse(resp)
}

// listRelayServiceConnectionsCreateRequest creates the ListRelayServiceConnections request.
func (client *WebAppsClient) listRelayServiceConnectionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListRelayServiceConnectionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRelayServiceConnectionsHandleResponse handles the ListRelayServiceConnections response.
func (client *WebAppsClient) listRelayServiceConnectionsHandleResponse(resp *http.Response) (WebAppsClientListRelayServiceConnectionsResponse, error) {
	result := WebAppsClientListRelayServiceConnectionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RelayServiceConnectionEntity); err != nil {
		return WebAppsClientListRelayServiceConnectionsResponse{}, err
	}
	return result, nil
}

// ListRelayServiceConnectionsSlot - Description for Gets hybrid connections configured for an app (or deployment slot, if
// specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get hybrid connections for the production
// slot.
// options - WebAppsClientListRelayServiceConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListRelayServiceConnectionsSlot
// method.
func (client *WebAppsClient) ListRelayServiceConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListRelayServiceConnectionsSlotOptions) (WebAppsClientListRelayServiceConnectionsSlotResponse, error) {
	req, err := client.listRelayServiceConnectionsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListRelayServiceConnectionsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListRelayServiceConnectionsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListRelayServiceConnectionsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listRelayServiceConnectionsSlotHandleResponse(resp)
}

// listRelayServiceConnectionsSlotCreateRequest creates the ListRelayServiceConnectionsSlot request.
func (client *WebAppsClient) listRelayServiceConnectionsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListRelayServiceConnectionsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRelayServiceConnectionsSlotHandleResponse handles the ListRelayServiceConnectionsSlot response.
func (client *WebAppsClient) listRelayServiceConnectionsSlotHandleResponse(resp *http.Response) (WebAppsClientListRelayServiceConnectionsSlotResponse, error) {
	result := WebAppsClientListRelayServiceConnectionsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RelayServiceConnectionEntity); err != nil {
		return WebAppsClientListRelayServiceConnectionsSlotResponse{}, err
	}
	return result, nil
}

// NewListSiteBackupsPager - Description for Gets existing backups of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListSiteBackupsOptions contains the optional parameters for the WebAppsClient.ListSiteBackups method.
func (client *WebAppsClient) NewListSiteBackupsPager(resourceGroupName string, name string, options *WebAppsClientListSiteBackupsOptions) *runtime.Pager[WebAppsClientListSiteBackupsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSiteBackupsResponse]{
		More: func(page WebAppsClientListSiteBackupsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSiteBackupsResponse) (WebAppsClientListSiteBackupsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteBackupsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSiteBackupsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSiteBackupsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSiteBackupsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteBackupsHandleResponse(resp)
		},
	})
}

// listSiteBackupsCreateRequest creates the ListSiteBackups request.
func (client *WebAppsClient) listSiteBackupsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSiteBackupsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listbackups"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteBackupsHandleResponse handles the ListSiteBackups response.
func (client *WebAppsClient) listSiteBackupsHandleResponse(resp *http.Response) (WebAppsClientListSiteBackupsResponse, error) {
	result := WebAppsClientListSiteBackupsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItemCollection); err != nil {
		return WebAppsClientListSiteBackupsResponse{}, err
	}
	return result, nil
}

// NewListSiteBackupsSlotPager - Description for Gets existing backups of an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get backups of the production slot.
// options - WebAppsClientListSiteBackupsSlotOptions contains the optional parameters for the WebAppsClient.ListSiteBackupsSlot
// method.
func (client *WebAppsClient) NewListSiteBackupsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListSiteBackupsSlotOptions) *runtime.Pager[WebAppsClientListSiteBackupsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSiteBackupsSlotResponse]{
		More: func(page WebAppsClientListSiteBackupsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSiteBackupsSlotResponse) (WebAppsClientListSiteBackupsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteBackupsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSiteBackupsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSiteBackupsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSiteBackupsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteBackupsSlotHandleResponse(resp)
		},
	})
}

// listSiteBackupsSlotCreateRequest creates the ListSiteBackupsSlot request.
func (client *WebAppsClient) listSiteBackupsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListSiteBackupsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/listbackups"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteBackupsSlotHandleResponse handles the ListSiteBackupsSlot response.
func (client *WebAppsClient) listSiteBackupsSlotHandleResponse(resp *http.Response) (WebAppsClientListSiteBackupsSlotResponse, error) {
	result := WebAppsClientListSiteBackupsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupItemCollection); err != nil {
		return WebAppsClientListSiteBackupsSlotResponse{}, err
	}
	return result, nil
}

// NewListSiteExtensionsPager - Description for Get list of siteextensions for a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// options - WebAppsClientListSiteExtensionsOptions contains the optional parameters for the WebAppsClient.ListSiteExtensions
// method.
func (client *WebAppsClient) NewListSiteExtensionsPager(resourceGroupName string, name string, options *WebAppsClientListSiteExtensionsOptions) *runtime.Pager[WebAppsClientListSiteExtensionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSiteExtensionsResponse]{
		More: func(page WebAppsClientListSiteExtensionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSiteExtensionsResponse) (WebAppsClientListSiteExtensionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteExtensionsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSiteExtensionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSiteExtensionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSiteExtensionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteExtensionsHandleResponse(resp)
		},
	})
}

// listSiteExtensionsCreateRequest creates the ListSiteExtensions request.
func (client *WebAppsClient) listSiteExtensionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSiteExtensionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteExtensionsHandleResponse handles the ListSiteExtensions response.
func (client *WebAppsClient) listSiteExtensionsHandleResponse(resp *http.Response) (WebAppsClientListSiteExtensionsResponse, error) {
	result := WebAppsClientListSiteExtensionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteExtensionInfoCollection); err != nil {
		return WebAppsClientListSiteExtensionsResponse{}, err
	}
	return result, nil
}

// NewListSiteExtensionsSlotPager - Description for Get list of siteextensions for a web site, or a deployment slot.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Site name.
// slot - Name of the deployment slot. If a slot is not specified, the API uses the production slot.
// options - WebAppsClientListSiteExtensionsSlotOptions contains the optional parameters for the WebAppsClient.ListSiteExtensionsSlot
// method.
func (client *WebAppsClient) NewListSiteExtensionsSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListSiteExtensionsSlotOptions) *runtime.Pager[WebAppsClientListSiteExtensionsSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSiteExtensionsSlotResponse]{
		More: func(page WebAppsClientListSiteExtensionsSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSiteExtensionsSlotResponse) (WebAppsClientListSiteExtensionsSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteExtensionsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSiteExtensionsSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSiteExtensionsSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSiteExtensionsSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteExtensionsSlotHandleResponse(resp)
		},
	})
}

// listSiteExtensionsSlotCreateRequest creates the ListSiteExtensionsSlot request.
func (client *WebAppsClient) listSiteExtensionsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListSiteExtensionsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSiteExtensionsSlotHandleResponse handles the ListSiteExtensionsSlot response.
func (client *WebAppsClient) listSiteExtensionsSlotHandleResponse(resp *http.Response) (WebAppsClientListSiteExtensionsSlotResponse, error) {
	result := WebAppsClientListSiteExtensionsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteExtensionInfoCollection); err != nil {
		return WebAppsClientListSiteExtensionsSlotResponse{}, err
	}
	return result, nil
}

// ListSitePushSettings - Description for Gets the Push settings associated with web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// options - WebAppsClientListSitePushSettingsOptions contains the optional parameters for the WebAppsClient.ListSitePushSettings
// method.
func (client *WebAppsClient) ListSitePushSettings(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSitePushSettingsOptions) (WebAppsClientListSitePushSettingsResponse, error) {
	req, err := client.listSitePushSettingsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListSitePushSettingsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListSitePushSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListSitePushSettingsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSitePushSettingsHandleResponse(resp)
}

// listSitePushSettingsCreateRequest creates the ListSitePushSettings request.
func (client *WebAppsClient) listSitePushSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSitePushSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSitePushSettingsHandleResponse handles the ListSitePushSettings response.
func (client *WebAppsClient) listSitePushSettingsHandleResponse(resp *http.Response) (WebAppsClientListSitePushSettingsResponse, error) {
	result := WebAppsClientListSitePushSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PushSettings); err != nil {
		return WebAppsClientListSitePushSettingsResponse{}, err
	}
	return result, nil
}

// ListSitePushSettingsSlot - Description for Gets the Push settings associated with web app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of web app.
// slot - Name of web app slot. If not specified then will default to production slot.
// options - WebAppsClientListSitePushSettingsSlotOptions contains the optional parameters for the WebAppsClient.ListSitePushSettingsSlot
// method.
func (client *WebAppsClient) ListSitePushSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListSitePushSettingsSlotOptions) (WebAppsClientListSitePushSettingsSlotResponse, error) {
	req, err := client.listSitePushSettingsSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
	if err != nil {
		return WebAppsClientListSitePushSettingsSlotResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListSitePushSettingsSlotResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListSitePushSettingsSlotResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSitePushSettingsSlotHandleResponse(resp)
}

// listSitePushSettingsSlotCreateRequest creates the ListSitePushSettingsSlot request.
func (client *WebAppsClient) listSitePushSettingsSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListSitePushSettingsSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSitePushSettingsSlotHandleResponse handles the ListSitePushSettingsSlot response.
func (client *WebAppsClient) listSitePushSettingsSlotHandleResponse(resp *http.Response) (WebAppsClientListSitePushSettingsSlotResponse, error) {
	result := WebAppsClientListSitePushSettingsSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PushSettings); err != nil {
		return WebAppsClientListSitePushSettingsSlotResponse{}, err
	}
	return result, nil
}

// ListSlotConfigurationNames - Description for Gets the names of app settings and connection strings that stick to the slot
// (not swapped).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListSlotConfigurationNamesOptions contains the optional parameters for the WebAppsClient.ListSlotConfigurationNames
// method.
func (client *WebAppsClient) ListSlotConfigurationNames(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSlotConfigurationNamesOptions) (WebAppsClientListSlotConfigurationNamesResponse, error) {
	req, err := client.listSlotConfigurationNamesCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return WebAppsClientListSlotConfigurationNamesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebAppsClientListSlotConfigurationNamesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebAppsClientListSlotConfigurationNamesResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSlotConfigurationNamesHandleResponse(resp)
}

// listSlotConfigurationNamesCreateRequest creates the ListSlotConfigurationNames request.
func (client *WebAppsClient) listSlotConfigurationNamesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSlotConfigurationNamesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSlotConfigurationNamesHandleResponse handles the ListSlotConfigurationNames response.
func (client *WebAppsClient) listSlotConfigurationNamesHandleResponse(resp *http.Response) (WebAppsClientListSlotConfigurationNamesResponse, error) {
	result := WebAppsClientListSlotConfigurationNamesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SlotConfigNamesResource); err != nil {
		return WebAppsClientListSlotConfigurationNamesResponse{}, err
	}
	return result, nil
}

// NewListSlotDifferencesFromProductionPager - Description for Get the difference in configuration settings between two web
// app slots.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slotSwapEntity - JSON object that contains the target slot name. See example.
// options - WebAppsClientListSlotDifferencesFromProductionOptions contains the optional parameters for the WebAppsClient.ListSlotDifferencesFromProduction
// method.
func (client *WebAppsClient) NewListSlotDifferencesFromProductionPager(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, options *WebAppsClientListSlotDifferencesFromProductionOptions) *runtime.Pager[WebAppsClientListSlotDifferencesFromProductionResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSlotDifferencesFromProductionResponse]{
		More: func(page WebAppsClientListSlotDifferencesFromProductionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSlotDifferencesFromProductionResponse) (WebAppsClientListSlotDifferencesFromProductionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSlotDifferencesFromProductionCreateRequest(ctx, resourceGroupName, name, slotSwapEntity, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSlotDifferencesFromProductionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSlotDifferencesFromProductionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSlotDifferencesFromProductionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSlotDifferencesFromProductionHandleResponse(resp)
		},
	})
}

// listSlotDifferencesFromProductionCreateRequest creates the ListSlotDifferencesFromProduction request.
func (client *WebAppsClient) listSlotDifferencesFromProductionCreateRequest(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, options *WebAppsClientListSlotDifferencesFromProductionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, slotSwapEntity)
}

// listSlotDifferencesFromProductionHandleResponse handles the ListSlotDifferencesFromProduction response.
func (client *WebAppsClient) listSlotDifferencesFromProductionHandleResponse(resp *http.Response) (WebAppsClientListSlotDifferencesFromProductionResponse, error) {
	result := WebAppsClientListSlotDifferencesFromProductionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SlotDifferenceCollection); err != nil {
		return WebAppsClientListSlotDifferencesFromProductionResponse{}, err
	}
	return result, nil
}

// NewListSlotDifferencesSlotPager - Description for Get the difference in configuration settings between two web app slots.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the source slot. If a slot is not specified, the production slot is used as the source slot.
// slotSwapEntity - JSON object that contains the target slot name. See example.
// options - WebAppsClientListSlotDifferencesSlotOptions contains the optional parameters for the WebAppsClient.ListSlotDifferencesSlot
// method.
func (client *WebAppsClient) NewListSlotDifferencesSlotPager(resourceGroupName string, name string, slot string, slotSwapEntity CsmSlotEntity, options *WebAppsClientListSlotDifferencesSlotOptions) *runtime.Pager[WebAppsClientListSlotDifferencesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSlotDifferencesSlotResponse]{
		More: func(page WebAppsClientListSlotDifferencesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSlotDifferencesSlotResponse) (WebAppsClientListSlotDifferencesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSlotDifferencesSlotCreateRequest(ctx, resourceGroupName, name, slot, slotSwapEntity, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSlotDifferencesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSlotDifferencesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSlotDifferencesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSlotDifferencesSlotHandleResponse(resp)
		},
	})
}

// listSlotDifferencesSlotCreateRequest creates the ListSlotDifferencesSlot request.
func (client *WebAppsClient) listSlotDifferencesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, slotSwapEntity CsmSlotEntity, options *WebAppsClientListSlotDifferencesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, slotSwapEntity)
}

// listSlotDifferencesSlotHandleResponse handles the ListSlotDifferencesSlot response.
func (client *WebAppsClient) listSlotDifferencesSlotHandleResponse(resp *http.Response) (WebAppsClientListSlotDifferencesSlotResponse, error) {
	result := WebAppsClientListSlotDifferencesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SlotDifferenceCollection); err != nil {
		return WebAppsClientListSlotDifferencesSlotResponse{}, err
	}
	return result, nil
}

// NewListSlotSiteDeploymentStatusesSlotPager - List deployment statuses for an app (or deployment slot, if specified).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// slot - Name of the deployment slot. If a slot is not specified, the API will get the deployment status for the production
// slot.
// options - WebAppsClientListSlotSiteDeploymentStatusesSlotOptions contains the optional parameters for the WebAppsClient.ListSlotSiteDeploymentStatusesSlot
// method.
func (client *WebAppsClient) NewListSlotSiteDeploymentStatusesSlotPager(resourceGroupName string, name string, slot string, options *WebAppsClientListSlotSiteDeploymentStatusesSlotOptions) *runtime.Pager[WebAppsClientListSlotSiteDeploymentStatusesSlotResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSlotSiteDeploymentStatusesSlotResponse]{
		More: func(page WebAppsClientListSlotSiteDeploymentStatusesSlotResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSlotSiteDeploymentStatusesSlotResponse) (WebAppsClientListSlotSiteDeploymentStatusesSlotResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSlotSiteDeploymentStatusesSlotCreateRequest(ctx, resourceGroupName, name, slot, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSlotSiteDeploymentStatusesSlotResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSlotSiteDeploymentStatusesSlotResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSlotSiteDeploymentStatusesSlotResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSlotSiteDeploymentStatusesSlotHandleResponse(resp)
		},
	})
}

// listSlotSiteDeploymentStatusesSlotCreateRequest creates the ListSlotSiteDeploymentStatusesSlot request.
func (client *WebAppsClient) listSlotSiteDeploymentStatusesSlotCreateRequest(ctx context.Context, resourceGroupName string, name string, slot string, options *WebAppsClientListSlotSiteDeploymentStatusesSlotOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deploymentStatus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if slot == "" {
		return nil, errors.New("parameter slot cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{slot}", url.PathEscape(slot))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSlotSiteDeploymentStatusesSlotHandleResponse handles the ListSlotSiteDeploymentStatusesSlot response.
func (client *WebAppsClient) listSlotSiteDeploymentStatusesSlotHandleResponse(resp *http.Response) (WebAppsClientListSlotSiteDeploymentStatusesSlotResponse, error) {
	result := WebAppsClientListSlotSiteDeploymentStatusesSlotResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmDeploymentStatusCollection); err != nil {
		return WebAppsClientListSlotSiteDeploymentStatusesSlotResponse{}, err
	}
	return result, nil
}

// NewListSlotsPager - Description for Gets an app's deployment slots.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the app.
// options - WebAppsClientListSlotsOptions contains the optional parameters for the WebAppsClient.ListSlots method.
func (client *WebAppsClient) NewListSlotsPager(resourceGroupName string, name string, options *WebAppsClientListSlotsOptions) *runtime.Pager[WebAppsClientListSlotsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSlotsResponse]{
		More: func(page WebAppsClientListSlotsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSlotsResponse) (WebAppsClientListSlotsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSlotsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSlotsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSlotsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSlotsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSlotsHandleResponse(resp)
		},
	})
}

// listSlotsCreateRequest creates the ListSlots request.
func (client *WebAppsClient) listSlotsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSlotsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSlotsHandleResponse handles the ListSlots response.
func (client *WebAppsClient) listSlotsHandleResponse(resp *http.Response) (WebAppsClientListSlotsResponse, error) {
	result := WebAppsClientListSlotsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return WebAppsClientListSlotsResponse{}, err
	}
	return result, nil
}

// NewListSnapshotsPager - Description for Returns all Snapshots to the user.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Website Name.
// options - WebAppsClientListSnapshotsOptions contains the optional parameters for the WebAppsClient.ListSnapshots method.
func (client *WebAppsClient) NewListSnapshotsPager(resourceGroupName string, name string, options *WebAppsClientListSnapshotsOptions) *runtime.Pager[WebAppsClientListSnapshotsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSnapshotsResponse]{
		More: func(page WebAppsClientListSnapshotsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSnapshotsResponse) (WebAppsClientListSnapshotsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSnapshotsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSnapshotsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSnapshotsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSnapshotsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSnapshotsHandleResponse(resp)
		},
	})
}

// listSnapshotsCreateRequest creates the ListSnapshots request.
func (client *WebAppsClient) listSnapshotsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSnapshotsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSnapshotsHandleResponse handles the ListSnapshots response.
func (client *WebAppsClient) listSnapshotsHandleResponse(resp *http.Response) (WebAppsClientListSnapshotsResponse, error) {
	result := WebAppsClientListSnapshotsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SnapshotCollection); err != nil {
		return WebAppsClientListSnapshotsResponse{}, err
	}
	return result, nil
}

// NewListSnapshotsFromDRSecondaryPager - Description for Returns all Snapshots to the user from DRSecondary endpoint.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Website Name.
// options - WebAppsClientListSnapshotsFromDRSecondaryOptions contains the optional parameters for the WebAppsClient.ListSnapshotsFromDRSecondary
// method.
func (client *WebAppsClient) NewListSnapshotsFromDRSecondaryPager(resourceGroupName string, name string, options *WebAppsClientListSnapshotsFromDRSecondaryOptions) *runtime.Pager[WebAppsClientListSnapshotsFromDRSecondaryResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebAppsClientListSnapshotsFromDRSecondaryResponse]{
		More: func(page WebAppsClientListSnapshotsFromDRSecondaryResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebAppsClientListSnapshotsFromDRSecondaryResponse) (WebAppsClientListSnapshotsFromDRSecondaryResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSnapshotsFromDRSecondaryCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebAppsClientListSnapshotsFromDRSecondaryResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebAppsClientListSnapshotsFromDRSecondaryResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebAppsClientListSnapshotsFromDRSecondaryResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSnapshotsFromDRSecondaryHandleResponse(resp)
		},
	})
}

// listSnapshotsFromDRSecondaryCreateRequest creates the ListSnapshotsFromDRSecondary request.
func (client *WebAppsClient) listSnapshotsFromDRSecondaryCreateRequest(ctx context.Context, resourceGroupName string, name string, options *WebAppsClientListSnapshotsFromDRSecondaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshotsdr"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSnapshotsFromDRSecondaryHandleResponse handles the ListSnapshotsFromDRSecondary response.
func (client *WebAppsClient) listSnapshotsFromDRSecondaryHandleResponse(resp *http.Response) (WebAppsClientListSnapshotsFromDRSecondaryResponse, error) {
	result := WebAppsClientListSnapshotsFromDRSecondaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SnapshotCollection); err != nil {
		return WebAppsClientListSnapshotsFromDRSecondaryResponse{}, err
	}
	return result, nil
}

// NewListSnapshotsFromDRSecondarySlotPager - Description for Returns all Snapsho