// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/dialogflow/cx/v3/generator.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Generators contain prompt to be sent to the LLM model to generate text. The
// prompt can contain parameters which will be resolved before calling the
// model. It can optionally contain banned phrases to ensure the model responses
// are safe.
type Generator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the generator.
	// Must be set for the
	// [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator]
	// method. [Generators.CreateGenerate][] populates the name automatically.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/generators/<Generator ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the generator, unique within the
	// agent. The prompt contains pre-defined parameters such as $conversation,
	// $last-user-utterance, etc. populated by Dialogflow. It can also contain
	// custom placeholders which will be resolved during fulfillment.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Prompt for the LLM model.
	PromptText *Phrase `protobuf:"bytes,3,opt,name=prompt_text,json=promptText,proto3" json:"prompt_text,omitempty"`
	// Optional. List of custom placeholders in the prompt text.
	Placeholders []*Generator_Placeholder `protobuf:"bytes,5,rep,name=placeholders,proto3" json:"placeholders,omitempty"`
}

func (x *Generator) Reset() {
	*x = Generator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Generator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Generator) ProtoMessage() {}

func (x *Generator) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Generator.ProtoReflect.Descriptor instead.
func (*Generator) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{0}
}

func (x *Generator) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Generator) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Generator) GetPromptText() *Phrase {
	if x != nil {
		return x.PromptText
	}
	return nil
}

func (x *Generator) GetPlaceholders() []*Generator_Placeholder {
	if x != nil {
		return x.Placeholders
	}
	return nil
}

// Text input which can be used for prompt or banned phrases.
type Phrase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Text input which can be used for prompt or banned phrases.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *Phrase) Reset() {
	*x = Phrase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Phrase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Phrase) ProtoMessage() {}

func (x *Phrase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Phrase.ProtoReflect.Descriptor instead.
func (*Phrase) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{1}
}

func (x *Phrase) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// The request message for
// [Generators.ListGenerators][google.cloud.dialogflow.cx.v3.Generators.ListGenerators].
type ListGeneratorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list all generators for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The language to list generators for.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGeneratorsRequest) Reset() {
	*x = ListGeneratorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGeneratorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGeneratorsRequest) ProtoMessage() {}

func (x *ListGeneratorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGeneratorsRequest.ProtoReflect.Descriptor instead.
func (*ListGeneratorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{2}
}

func (x *ListGeneratorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGeneratorsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListGeneratorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGeneratorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Generators.ListGenerators][google.cloud.dialogflow.cx.v3.Generators.ListGenerators].
type ListGeneratorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of generators. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Generators []*Generator `protobuf:"bytes,1,rep,name=generators,proto3" json:"generators,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGeneratorsResponse) Reset() {
	*x = ListGeneratorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGeneratorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGeneratorsResponse) ProtoMessage() {}

func (x *ListGeneratorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGeneratorsResponse.ProtoReflect.Descriptor instead.
func (*ListGeneratorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{3}
}

func (x *ListGeneratorsResponse) GetGenerators() []*Generator {
	if x != nil {
		return x.Generators
	}
	return nil
}

func (x *ListGeneratorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Generators.GetGenerator][google.cloud.dialogflow.cx.v3.Generators.GetGenerator].
type GetGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the generator.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/generators/<Generator ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The language to list generators for.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetGeneratorRequest) Reset() {
	*x = GetGeneratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGeneratorRequest) ProtoMessage() {}

func (x *GetGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGeneratorRequest.ProtoReflect.Descriptor instead.
func (*GetGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{4}
}

func (x *GetGeneratorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetGeneratorRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [Generators.CreateGenerator][google.cloud.dialogflow.cx.v3.Generators.CreateGenerator].
type CreateGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a generator for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The generator to create.
	Generator *Generator `protobuf:"bytes,2,opt,name=generator,proto3" json:"generator,omitempty"`
	// The language to create generators for the following fields:
	// *  `Generator.prompt_text.text`
	// If not specified, the agent's default language is used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *CreateGeneratorRequest) Reset() {
	*x = CreateGeneratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGeneratorRequest) ProtoMessage() {}

func (x *CreateGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGeneratorRequest.ProtoReflect.Descriptor instead.
func (*CreateGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{5}
}

func (x *CreateGeneratorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGeneratorRequest) GetGenerator() *Generator {
	if x != nil {
		return x.Generator
	}
	return nil
}

func (x *CreateGeneratorRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator].
type UpdateGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator to update.
	Generator *Generator `protobuf:"bytes,1,opt,name=generator,proto3" json:"generator,omitempty"`
	// The language to list generators for.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGeneratorRequest) Reset() {
	*x = UpdateGeneratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGeneratorRequest) ProtoMessage() {}

func (x *UpdateGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGeneratorRequest.ProtoReflect.Descriptor instead.
func (*UpdateGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateGeneratorRequest) GetGenerator() *Generator {
	if x != nil {
		return x.Generator
	}
	return nil
}

func (x *UpdateGeneratorRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *UpdateGeneratorRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Generators.DeleteGenerator][google.cloud.dialogflow.cx.v3.Generators.DeleteGenerator].
type DeleteGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the generator to delete.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/generators/<Generator ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field has no effect for generators not being used.
	// For generators that are used by pages/flows/transition route groups:
	//
	//   - If `force` is set to false, an error will be returned with message
	//     indicating the referenced resources.
	//   - If `force` is set to true, Dialogflow will remove the generator, as well
	//     as any references to the generator (i.e.
	//     [Generator][Fulfillment.generator]) in fulfillments.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteGeneratorRequest) Reset() {
	*x = DeleteGeneratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGeneratorRequest) ProtoMessage() {}

func (x *DeleteGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGeneratorRequest.ProtoReflect.Descriptor instead.
func (*DeleteGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteGeneratorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGeneratorRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Represents a custom placeholder in the prompt text.
type Generator_Placeholder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID used to map custom placeholder to parameters in fulfillment.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Custom placeholder value in the prompt text.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Generator_Placeholder) Reset() {
	*x = Generator_Placeholder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Generator_Placeholder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Generator_Placeholder) ProtoMessage() {}

func (x *Generator_Placeholder) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Generator_Placeholder.ProtoReflect.Descriptor instead.
func (*Generator_Placeholder) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Generator_Placeholder) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Generator_Placeholder) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_dialogflow_cx_v3_generator_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_generator_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9f, 0x03, 0x0a, 0x09, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x70, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x54, 0x65, 0x78, 0x74, 0x12, 0x5d, 0x0a, 0x0c, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x1a, 0x31, 0x0a, 0x0b, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a, 0x23,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x7d, 0x22, 0x21, 0x0a, 0x06, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0xbd, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x48, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x0a,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22,
	0xcf, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x12, 0x23, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x4b, 0x0a, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x22, 0xc7, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x09,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6f, 0x0a, 0x16, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x32, 0xe9, 0x08, 0x0a,
	0x0a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xc7, 0x01, 0x0a, 0x0e,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76,
	0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd1, 0x01, 0x0a,
	0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x22, 0x5d, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x09, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x37, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73,
	0x12, 0xe0, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x6c, 0xda, 0x41, 0x15, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x32, 0x41, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xa8, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78,
	0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xb4, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x42, 0x0e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x31, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63,
	0x78, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0xea, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_generator_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_generator_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_dialogflow_cx_v3_generator_proto_goTypes = []interface{}{
	(*Generator)(nil),              // 0: google.cloud.dialogflow.cx.v3.Generator
	(*Phrase)(nil),                 // 1: google.cloud.dialogflow.cx.v3.Phrase
	(*ListGeneratorsRequest)(nil),  // 2: google.cloud.dialogflow.cx.v3.ListGeneratorsRequest
	(*ListGeneratorsResponse)(nil), // 3: google.cloud.dialogflow.cx.v3.ListGeneratorsResponse
	(*GetGeneratorRequest)(nil),    // 4: google.cloud.dialogflow.cx.v3.GetGeneratorRequest
	(*CreateGeneratorRequest)(nil), // 5: google.cloud.dialogflow.cx.v3.CreateGeneratorRequest
	(*UpdateGeneratorRequest)(nil), // 6: google.cloud.dialogflow.cx.v3.UpdateGeneratorRequest
	(*DeleteGeneratorRequest)(nil), // 7: google.cloud.dialogflow.cx.v3.DeleteGeneratorRequest
	(*Generator_Placeholder)(nil),  // 8: google.cloud.dialogflow.cx.v3.Generator.Placeholder
	(*fieldmaskpb.FieldMask)(nil),  // 9: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),          // 10: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3_generator_proto_depIdxs = []int32{
	1,  // 0: google.cloud.dialogflow.cx.v3.Generator.prompt_text:type_name -> google.cloud.dialogflow.cx.v3.Phrase
	8,  // 1: google.cloud.dialogflow.cx.v3.Generator.placeholders:type_name -> google.cloud.dialogflow.cx.v3.Generator.Placeholder
	0,  // 2: google.cloud.dialogflow.cx.v3.ListGeneratorsResponse.generators:type_name -> google.cloud.dialogflow.cx.v3.Generator
	0,  // 3: google.cloud.dialogflow.cx.v3.CreateGeneratorRequest.generator:type_name -> google.cloud.dialogflow.cx.v3.Generator
	0,  // 4: google.cloud.dialogflow.cx.v3.UpdateGeneratorRequest.generator:type_name -> google.cloud.dialogflow.cx.v3.Generator
	9,  // 5: google.cloud.dialogflow.cx.v3.UpdateGeneratorRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 6: google.cloud.dialogflow.cx.v3.Generators.ListGenerators:input_type -> google.cloud.dialogflow.cx.v3.ListGeneratorsRequest
	4,  // 7: google.cloud.dialogflow.cx.v3.Generators.GetGenerator:input_type -> google.cloud.dialogflow.cx.v3.GetGeneratorRequest
	5,  // 8: google.cloud.dialogflow.cx.v3.Generators.CreateGenerator:input_type -> google.cloud.dialogflow.cx.v3.CreateGeneratorRequest
	6,  // 9: google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator:input_type -> google.cloud.dialogflow.cx.v3.UpdateGeneratorRequest
	7,  // 10: google.cloud.dialogflow.cx.v3.Generators.DeleteGenerator:input_type -> google.cloud.dialogflow.cx.v3.DeleteGeneratorRequest
	3,  // 11: google.cloud.dialogflow.cx.v3.Generators.ListGenerators:output_type -> google.cloud.dialogflow.cx.v3.ListGeneratorsResponse
	0,  // 12: google.cloud.dialogflow.cx.v3.Generators.GetGenerator:output_type -> google.cloud.dialogflow.cx.v3.Generator
	0,  // 13: google.cloud.dialogflow.cx.v3.Generators.CreateGenerator:output_type -> google.cloud.dialogflow.cx.v3.Generator
	0,  // 14: google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator:output_type -> google.cloud.dialogflow.cx.v3.Generator
	10, // 15: google.cloud.dialogflow.cx.v3.Generators.DeleteGenerator:output_type -> google.protobuf.Empty
	11, // [11:16] is the sub-list for method output_type
	6,  // [6:11] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_generator_proto_init() }
func file_google_cloud_dialogflow_cx_v3_generator_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_generator_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Generator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Phrase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGeneratorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGeneratorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGeneratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGeneratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGeneratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGeneratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Generator_Placeholder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_generator_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_generator_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_generator_proto_depIdxs,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_generator_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_generator_proto = out.File
	file_google_cloud_dialogflow_cx_v3_generator_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_generator_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_generator_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GeneratorsClient is the client API for Generators service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GeneratorsClient interface {
	// Returns the list of all generators in the specified agent.
	ListGenerators(ctx context.Context, in *ListGeneratorsRequest, opts ...grpc.CallOption) (*ListGeneratorsResponse, error)
	// Retrieves the specified generator.
	GetGenerator(ctx context.Context, in *GetGeneratorRequest, opts ...grpc.CallOption) (*Generator, error)
	// Creates a generator in the specified agent.
	CreateGenerator(ctx context.Context, in *CreateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error)
	// Update the specified generator.
	UpdateGenerator(ctx context.Context, in *UpdateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error)
	// Deletes the specified generators.
	DeleteGenerator(ctx context.Context, in *DeleteGeneratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type generatorsClient struct {
	cc grpc.ClientConnInterface
}

func NewGeneratorsClient(cc grpc.ClientConnInterface) GeneratorsClient {
	return &generatorsClient{cc}
}

func (c *generatorsClient) ListGenerators(ctx context.Context, in *ListGeneratorsRequest, opts ...grpc.CallOption) (*ListGeneratorsResponse, error) {
	out := new(ListGeneratorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Generators/ListGenerators", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) GetGenerator(ctx context.Context, in *GetGeneratorRequest, opts ...grpc.CallOption) (*Generator, error) {
	out := new(Generator)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Generators/GetGenerator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) CreateGenerator(ctx context.Context, in *CreateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error) {
	out := new(Generator)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Generators/CreateGenerator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) UpdateGenerator(ctx context.Context, in *UpdateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error) {
	out := new(Generator)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Generators/UpdateGenerator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) DeleteGenerator(ctx context.Context, in *DeleteGeneratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Generators/DeleteGenerator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GeneratorsServer is the server API for Generators service.
type GeneratorsServer interface {
	// Returns the list of all generators in the specified agent.
	ListGenerators(context.Context, *ListGeneratorsRequest) (*ListGeneratorsResponse, error)
	// Retrieves the specified generator.
	GetGenerator(context.Context, *GetGeneratorRequest) (*Generator, error)
	// Creates a generator in the specified agent.
	CreateGenerator(context.Context, *CreateGeneratorRequest) (*Generator, error)
	// Update the specified generator.
	UpdateGenerator(context.Context, *UpdateGeneratorRequest) (*Generator, error)
	// Deletes the specified generators.
	DeleteGenerator(context.Context, *DeleteGeneratorRequest) (*emptypb.Empty, error)
}

// UnimplementedGeneratorsServer can be embedded to have forward compatible implementations.
type UnimplementedGeneratorsServer struct {
}

func (*UnimplementedGeneratorsServer) ListGenerators(context.Context, *ListGeneratorsRequest) (*ListGeneratorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGenerators not implemented")
}
func (*UnimplementedGeneratorsServer) GetGenerator(context.Context, *GetGeneratorRequest) (*Generator, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGenerator not implemented")
}
func (*UnimplementedGeneratorsServer) CreateGenerator(context.Context, *CreateGeneratorRequest) (*Generator, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGenerator not implemented")
}
func (*UnimplementedGeneratorsServer) UpdateGenerator(context.Context, *UpdateGeneratorRequest) (*Generator, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGenerator not implemented")
}
func (*UnimplementedGeneratorsServer) DeleteGenerator(context.Context, *DeleteGeneratorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGenerator not implemented")
}

func RegisterGeneratorsServer(s *grpc.Server, srv GeneratorsServer) {
	s.RegisterService(&_Generators_serviceDesc, srv)
}

func _Generators_ListGenerators_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGeneratorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).ListGenerators(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Generators/ListGenerators",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).ListGenerators(ctx, req.(*ListGeneratorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_GetGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).GetGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Generators/GetGenerator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).GetGenerator(ctx, req.(*GetGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_CreateGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).CreateGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Generators/CreateGenerator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).CreateGenerator(ctx, req.(*CreateGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_UpdateGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).UpdateGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Generators/UpdateGenerator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).UpdateGenerator(ctx, req.(*UpdateGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_DeleteGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).DeleteGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Generators/DeleteGenerator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).DeleteGenerator(ctx, req.(*DeleteGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Generators_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Generators",
	HandlerType: (*GeneratorsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListGenerators",
			Handler:    _Generators_ListGenerators_Handler,
		},
		{
			MethodName: "GetGenerator",
			Handler:    _Generators_GetGenerator_Handler,
		},
		{
			MethodName: "CreateGenerator",
			Handler:    _Generators_CreateGenerator_Handler,
		},
		{
			MethodName: "UpdateGenerator",
			Handler:    _Generators_UpdateGenerator_Handler,
		},
		{
			MethodName: "DeleteGenerator",
			Handler:    _Generators_DeleteGenerator_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/generator.proto",
}
