#pragma once

#include <atomic>

class XwlPrimary;
class XwlClipboard;
class ClipData;

class XwlDataBridge
{
public:
    XwlDataBridge(bool force = false);
    ~XwlDataBridge();

    int eventLoop();
    void stop();
    void setClipData(ClipData *clipData);

private:
    std::atomic<bool> m_enableXwlClipboard{false};
    std::atomic<bool> m_xwlClipboardExists{false};
    std::atomic<bool> m_active{false};
    std::atomic<bool> m_stop{false};
    std::atomic<bool> m_clipDataChange{false};
    XwlPrimary *m_primary{nullptr};
    XwlClipboard *m_clipboard{nullptr};
    ClipData *m_clipData{nullptr};
};
