/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef KVM_H
#define KVM_H

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

enum kvm_pointer_button_state {
    buttonRelease,
    buttonPress,
};

enum kvm_pointer_scroll_type {
    vertical,
    horizontal,
};

enum kvm_keyboard_key_state {
    keyRelease,
    keyPress,
};

enum kvm_bool {
    kvmDisable = 0,
    kvmEnable,
};

typedef void (*kvm_pointer_motion_cb)(void *user_data, unsigned int time, double x, double y);
typedef void (*kvm_pointer_button_cb)(void *user_data, unsigned int time, unsigned int serial, kvm_pointer_button_state state);
typedef void (*kvm_pointer_axis_cb)(void *user_data, unsigned int time, kvm_pointer_scroll_type type, double value);
typedef void (*kvm_keyboard_key_cb)(void *user_data, unsigned int time, unsigned int serial, kvm_keyboard_key_state state, unsigned int key);

void kvm_register_pointer_motion(void *data, kvm_pointer_motion_cb cb);
void kvm_register_pointer_button(void* data, kvm_pointer_button_cb cb);
void kvm_register_pointer_axis(void* data, kvm_pointer_axis_cb cb);
void kvm_register_keyboard_key(void* data, kvm_keyboard_key_cb cb);

void kvm_unregister_pointer_motion(kvm_pointer_motion_cb cb);
void kvm_unregister_pointer_button(kvm_pointer_button_cb cb);
void kvm_unregister_pointer_axis(kvm_pointer_axis_cb cb);
void kvm_unregister_keyboard_key(kvm_keyboard_key_cb cb);

int init_kvm();
int destory_kvm();

void kvm_enable_pointer(kvm_bool is_enable);
void kvm_enable_cursor(kvm_bool is_enable);
void kvm_pointer_set_pos(double x, double y);
void kvm_enable_keyboard(kvm_bool is_enable);

#ifdef __cplusplus
}
#endif

#endif
