/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CLIPBOARDSTRUCT_H
#define CLIPBOARDSTRUCT_H

#include <string>
#include <vector>

using namespace std;
// 此结构仅用于数据返回使用

struct ClipboardDataProperty {
    int chunkSize;                       // 属性数据大小
    int pid;                             // 进程id
    char datasourceType;                 // 数据来源 0 x11 1wayland
    long long wirteTime;                 // 写入时间 ms
    void *data;                          // 属性数据
};

struct ClipboardDataRecord {
    int chunkSize;                       // 属性数据大小
    int recordIndex;                     // 索引
    char  dataType;                      // 数据类型 字符串  text image等
    void *data;                          // 数据
};

//struct ClipboardData
//{
//    int dataindex;                       // 数据索引
//    int datacount;                       // datacount数目
//    bool enable;                         // 是否被激活
//    ClipboardDataRecord listrecorddata; // 多个记录数据
//    ClipboardDataProperty *propertys;    // 属性数据
//};
struct ClipDataRecordInfo {
    string vDataType;
    string vMimeType;
    int vWidth;
    int vHeight;
    uint32_t bufferSize;
    string vDataPath;
    int len;
    char *vSmallData;           //注意用完需要释放
    vector<string> vUrls;
};

struct ClipDataPropertyInfo {
    string name;
    long long vTimestamp;
    vector<string> vMimeTypes;
};

#endif // ITEMINFO_H
