.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkIntro.man,v 1.1.1.1 2002/10/19 08:27:44 aida_s Exp $ NEC;
.TH "DICLIBINTRO" "3"
.SH "NAME"
\f4DICLib intro\f1 \- dictionary access library introduction
.SH "DESCRIPTION"
The dictionary access library provides basic functions for kana-kanji conversion.  The following files are prerequisite to using the dictionary access library:
.IP "Header file" 
\f4canna/RK.h\f1
.br
An include file that contains data and function declarations for use by the kana-kanji conversion library.  Include this file at compile time.
.IP "Libraries"
\f4libcanna.a, libcanna.so\f1
.br
Kana-kanji conversion libraries.  Specify "\f4-lcanna\f1" at link time.
.SH "SUMMARY"
The dictionary access library provides three major categories of functions:
.IP "" 3
Code conversion functions
.RS
.P
Convert character string codes between double-width and single-width characters and between hiragana and katakana.  External data and initialization procedures are not required.
.RE
.IP "" 3
Romaji-kana conversion functions
.RS
.PP
Convert Romaji to kana by using a Romaji-kana conversion table that defines the correspondence between Romaji and kana.  The rules of Romaji-kana conversion can be altered by making modifications to this table.
.RE
.IP "" 3
Kana-kanji conversion functions
.RS
.P
Convert kana to kanji through continuous clause conversion by using a kana-kanji conversion dictionary that defines the correspondence between readings and words.  Kana-kanji conversion can be performed to meet specific applications by making modifications to this dictionary.
.RE
.P
Among all the functions of Japanese input processing, this library performs only data conversion.  To be able to enter Japanese text from a keyboard, therefore, it is necessary for users to write a keyboard handling routine within the application program.  
.IP "" 3
Code conversion functions
.RS
.IP "\f4Rk(w)CvtZen\f1" 22
Convert ASCII characters and single-width katakana to double-width characters.
.IP "\f4RkCvtHan\f1" 22
Convert double-width symbols, alphanumeric characters, hiragana, and katakana to single-width characters.
.IP "\f4RkCvtKana\f1" 22
Convert double-width hiragana to double-width katakana.
.IP "\f4RkCvtHira\f1" 22
Convert double-width katakana to double-width hiragana.
.IP "\f4RkCvtEuc\f1" 22
Convert shift JIS code to EUC code.
.RE
.IP "" 3
Romaji-kana conversion functions
.RS
.IP "\f4RkOpenRoma\f1" 22
Open the dictionary to use for Romaji-kana conversion.
.IP "\f4RkCloseRoma\f1" 22
Close the dictionary used for Romaji-kana conversion.
.IP "\f4RkMapRoma\f1" 22
Perform Romaji-kana conversion by using a specified 
Romaji-kana conversion dictionary.
.IP "\f4RkCvtRoma\f1" 22
Convert an entire character string from Romaji to kana by iteratively using \f4RkMapRoma\f1.
.RE
.IP "" 3
Kana-kanji conversion functions
.RS
.IP "\f4RkInitialize\f1" 22
Initialize the kana-kanji conversion functions.
.IP "\f4RkFinalize\f1" 22
Terminate the kana-kanji conversion functions.
.IP "\f4RkCreateContext\f1" 22
Create a new conversion context.
.IP "\f4RkDuplicateContext\f1" 22
Create a context having the same conversion environment as a specified context.
.IP "\f4RkCloseContext\f1" 22
Close a specified conversion context.
.IP "\f4RkGetDicList\f1" 22
Get the names of  dictionaries that can be added to the dictionary list.
.IP "\f4RkMountDic\f1" 22
Mount a dictionary in the dictionary list.
.IP "\f4RkGetMountList\f1" 22
Get the names of the currently mounted dictionaries. (or characters for RkwResize)
.IP "\f4RkUnmountDic\f1" 22
Unmount a specified dictionary from the dictionary list.
.IP "\f4RkRemountDic\f1" 22
Alter the priority order of a dictionary already in the dictionary list.
.IP "\f4RkBgnBun\f1" 22
Convert the reading of a specified length to kanji.
.IP "\f4RkEndBun\f1" 22
Terminate kana-kanji conversion.
.IP "\f4RkGoTo\f1" 22
Set the clause with a specified clause number as the current clause.
.IP "\f4RkLeft\f1" 22
Move the current clause to the clause to its left.
.IP "\f4RkRight\f1" 22
Move the current clause to its right.
.IP "\f4RkXfer\f1" 22
Set the candidate with a specified candidate number as the current candidate.
.IP "\f4RkNext\f1" 22
Set the next candidate as the current candidate.
.IP "\f4RkPrev\f1" 22
Set the previous candidate as the current candidate.
.IP "\f4RkNfer\f1" 22
Set a reading itself as the current candidate.
.IP "\f4RkResize\f1" 22
Change the reading length of the current clause to \f4len\f1 bytes.
.IP "\f4RkEnlarge\f1" 22
Enlarge the reading of the current clause.
.IP "\f4RkShorten\f1" 22
Shorten the reading of the current clause.
.IP "\f4RkStoreYomi\f1" 22
Change the reading of the current clause to a specified reading, reconverting the subsequent clauses.
.IP "\f4RkGetYomi\f1" 22
Get the reading of the current clause.
.IP "\f4RkGetKanji\f1" 22
Get the current candidate for the current clause.
.IP "\f4RkGetKanjiList" 22
Get all kanji candidates for the current clause.
.IP "\f4RkGetStat\f1" 22
Get analysis information about the current candidate.
.IP "\f4RkGetLex\f1" 22
Get morphemic information on each word that makes up the current candidate.
.IP "\f4RkDefineDic\f1" 22
Define a specified candidate in a dictionary.
.IP "\f4RkDeleteDic\f1" 22
Delete a specified candidate from a dictionary.
.RE
