; FTY Library
;
; Copyright (C) 2020 Kestrel Institute (http://www.kestrel.edu)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (coglio@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package "FTY")

;; defset has been moved to centaur/fty/deftypes.lisp so that it can be used recursively in fty::deftypes
;; the implementation has been moved to fty-set.lisp
(include-book "centaur/fty/top" :dir :system)

#|
(include-book "std/osets/top" :dir :system)
(include-book "std/util/defrule" :dir :system)
(include-book "xdoc/constructors" :dir :system)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define defset-fn (type
                   elt-type
                   elementp-of-nil
                   pred
                   fix
                   equiv
                   parents
                   short
                   long
                   state)
  :returns (event "A @(tsee acl2::maybe-pseudo-event-formp).")
  :mode :program
  :parents (defset-implementation)
  :short "Event generated by @(tsee defset)."
  (b* (;; validate the TYPE input:
       ((unless (symbolp type))
        (raise "The TYPE input must be a symbol, ~
                but it is ~x0 instead." type))
       ;; retrieve the table of all fixtypes:
       (fty-table (get-fixtypes-alist (w state)))
       ;; validate the :ELT-TYPE input:
       ((unless (symbolp elt-type))
        (raise "The :ELT-TYPE input must be a symbol, ~
                but it is ~x0 instead." elt-type))
       (elt-info (find-fixtype elt-type fty-table))
       ((unless elt-info)
        (raise "The :ELT-TYPE input ~x0 must name a fixtype, ~
                but it does not." elt-type))
       (elt-pred (fixtype->pred elt-info))
       ;; validate the :ELEMENTP-OF-NIL input:
       ((unless (or (booleanp elementp-of-nil)
                    (eq elementp-of-nil :unknown)))
        (raise "The :ELEMENTP-OF-NIL input must be T, NIL, or :UNKNOWN, ~
                but it is ~x0 instead." elementp-of-nil))
       ;; validate the :PRED input:
       ((unless (symbolp pred))
        (raise "The :PRED input must be a symbol, ~
                but it is ~x0 instead." pred))
       ;; validate the :FIX input:
       ((unless (symbolp fix))
        (raise "The :FIX input must be a symbol, ~
                but it is ~x0 instead." fix))
       ;; validate the :EQUIV input:
       ((unless (symbolp equiv))
        (raise "The :EQUIV input must be a symbol, ~
                but it is ~x0 instead." equiv))
       ;; package for the generated theorem and variable names:
       (pkg (symbol-package-name type))
       (pkg (if (equal pkg *main-lisp-package-name*) "ACL2" pkg))
       (pkg-witness (pkg-witness pkg))
       ;; variables to use in the generated functions and theorems:
       (x (intern-in-package-of-symbol "X" pkg-witness))
       (y (intern-in-package-of-symbol "Y" pkg-witness))
       (a (intern-in-package-of-symbol "A" pkg-witness))
       ;; names of the generated functions:
       (pred (or pred (acl2::add-suffix-to-fn type "-P")))
       (fix (or fix (acl2::add-suffix-to-fn type "-FIX")))
       (equiv (or equiv (acl2::add-suffix-to-fn type "-EQUIV")))
       ;; names of the generated theorems:
       (booleanp-of-pred (acl2::packn-pos (list 'booleanp-of pred) pkg-witness))
       (pred-of-fix (acl2::packn-pos (list pred '-of- fix) pkg-witness))
       (fix-when-pred (acl2::packn-pos (list fix '-when- pred) pkg-witness))
       (setp-when-pred (acl2::packn-pos (list 'setp-when- pred) pkg-witness))
       (elt-pred-of-head (acl2::packn-pos (list elt-pred '-of-head-when- pred)
                                          pkg-witness))
       (pred-of-tail (acl2::packn-pos (list pred '-of-tail-when- pred)
                                      pkg-witness))
       (pred-of-insert (acl2::packn-pos (list pred '-of-insert) pkg-witness))
       (elt-pred-when-in-pred (acl2::packn-pos (list elt-pred
                                                     '-when-in-
                                                     pred
                                                     '-binds-free-
                                                     x)
                                               pkg-witness))
       (pred-of-union (acl2::packn-pos (list pred '-of-union) pkg-witness))
       (pred-of-difference (acl2::packn-pos (list pred '-of-difference)
                                            pkg-witness))
       (pred-of-delete (acl2::packn-pos (list pred '-of-delete) pkg-witness))
       ;; reference to the fixtype for the generated XDOC documentation:
       (type-ref (concatenate 'string
                              "@(tsee "
                              (acl2::string-downcase (symbol-package-name type))
                              "::"
                              (acl2::string-downcase (symbol-name type))
                              ")"))
       ;; generated events:
       (pred-event
        `(define ,pred (,x)
           :parents (,type)
           :short ,(concatenate 'string "Recognizer for " type-ref ".")
           (if (atom ,x)
               (null ,x)
             (and (,elt-pred (car ,x))
                  (or (null (cdr ,x))
                      (and (consp (cdr ,x))
                           (acl2::fast-<< (car ,x) (cadr ,x))
                           (,pred (cdr ,x))))))
           :no-function t
           ///
           (defrule ,booleanp-of-pred
             (booleanp (,pred ,x)))
           (defrule ,setp-when-pred
             (implies (,pred ,x)
                      (set::setp ,x))
             :enable set::setp)
           (defrule ,elt-pred-of-head
             (implies (,pred ,x)
                      ,(cond ((eq elementp-of-nil t)
                              `(,elt-pred (set::head ,x)))
                             ((eq elementp-of-nil nil)
                              `(equal (,elt-pred (set::head ,x))
                                      (not (set::empty ,x))))
                             (t `(implies (not (set::empty ,x))
                                          (,elt-pred (set::head ,x))))))
             :enable (set::head set::empty))
           (defrule ,pred-of-tail
             (implies (,pred ,x)
                      (,pred (set::tail ,x)))
             :enable set::tail)
           (defrule ,pred-of-insert
             (equal (,pred (set::insert ,a ,x))
                    (and (,elt-pred ,a)
                         (,pred (set::sfix ,x))))
             :enable (set::insert set::empty set::head set::tail set::setp))
           (defrule ,elt-pred-when-in-pred
             (implies (and (set::in ,a ,x) ; binds free X
                           (,pred ,x))
                      (,elt-pred ,a))
             :enable (set::in set::head))
           (defrule ,pred-of-union
             (equal (,pred (set::union ,x ,y))
                    (and (,pred (set::sfix ,x))
                         (,pred (set::sfix ,y))))
             :enable (set::union set::empty set::setp set::head set::tail))
           (defrule ,pred-of-difference
             (implies (,pred ,x)
                      (,pred (set::difference ,x ,y)))
             :enable set::difference)
           (defrule ,pred-of-delete
             (implies (,pred ,x)
                      (,pred (set::delete ,a ,x)))
             :enable set::delete)))
       (fix-event
        `(define ,fix ((,x ,pred))
           :parents (,type)
           :short ,(concatenate 'string "Fixer for " type-ref ".")
           (mbe :logic (if (,pred ,x) ,x nil)
                :exec ,x)
           :no-function t
           ///
           (defrule ,pred-of-fix
             (,pred (,fix ,x)))
           (defrule ,fix-when-pred
             (implies (,pred ,x)
                      (equal (,fix ,x) ,x)))))
       (type-event
        `(defsection ,type
           ,@(and parents (list :parents parents))
           ,@(and short (list :short short))
           ,@(and long (list :long long))
           (fty::deffixtype ,type
             :pred ,pred
             :fix ,fix
             :equiv ,equiv
             :define t
             :forward t))))
    ;; top-level event:
    `(encapsulate
       ()
       (logic)
       ,pred-event
       ,fix-event
       ,type-event)))

(defsection defset-macro-definition
  :parents (defset-implementation)
  :short "Definition of the @(tsee defset) macro."
  :long (xdoc::topstring-@def "defset")
  (defmacro defset (type &key
                         elt-type
                         (elementp-of-nil ':unknown)
                         pred
                         fix
                         equiv
                         parents
                         short
                         long)
    `(make-event (defset-fn
                   ',type
                   ',elt-type
                   ',elementp-of-nil
                   ',pred
                   ',fix
                   ',equiv
                   ',parents
                   ,short
                   ,long
                   state))))
|#
