//
// Created by uos on 2022/3/16.
//

#ifndef UOS_RECOVERY_RESTOREWIDGET_H
#define UOS_RECOVERY_RESTOREWIDGET_H

#include "common/HelpDialog.h"
#include <DGuiApplicationHelper>
#include <DWidget>
#include <QStandardItemModel>
#include <DLabel>
#include <DListView>
#include <DPushButton>
#include <DSpinner>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class RestoreWidget : public DWidget
{
Q_OBJECT
public:
    explicit RestoreWidget(DWidget *parent = nullptr);
    void startCalculateTip(bool start, const QString &tipInfo);
    void setErrorInfo(const QString &tipInfo);

private:
    void initUI();
    void initHelpDialog();
    int getRestoreUiLayoutType();
    void uiHorizontalLayout();
    void uiVerticalLayout();
    void initHelpLayout();

Q_SIGNALS:
    void notifySystemRestore();
    void notifyDataRestore();
    void notifyInitializeRestore();
    void notifyOtherRestore();
    void enter();
    void leave();

protected:
    bool eventFilter(QObject* watched, QEvent* event);

private Q_SLOTS:
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);
    void onItemChanged(bool checked);
private:
    QStandardItemModel *m_model = nullptr;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DLabel *m_title = nullptr;
    DListView *m_restoreView = nullptr;
    DPushButton *m_nextBtn = nullptr;
    QStringList m_iconList;
    QLabel *m_helpLabel = nullptr;
    HelpDialog* m_helpDialog = nullptr;
    DLabel *m_errorInfoLabel = nullptr;
    DSpinner *m_calculateTip = nullptr;
    bool m_bDirectionRTL = false;
    bool m_isSupportOtherWays = false;
};


#endif //UOS_RECOVERY_RESTOREWIDGET_H
