//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/12/4.
//
#include "ImmuItemFrame.h"
#include "utils/Utils.h"
#include <QVBoxLayout>
#include <DFontSizeManager>

SpaceItemFrame::SpaceItemFrame(QWidget *parent) : DFrame(parent)
{}

void SpaceItemFrame::paintEvent(QPaintEvent *event)
{
    QBitmap mask(this->size());
    mask.fill(Qt::color0);
    QPainter painter(&mask);
    painter.setBrush(Qt::color1);
    painter.setRenderHint(QPainter::Antialiasing);
    painter.drawRoundedRect(rect(), 3, 3);
    this->setMask(mask);

    DFrame::paintEvent(event);
}

ImmuItemFrame::ImmuItemFrame(const QString &title, const QString &titleDes, const QString &icon, QWidget *parent)
        : DFrame(parent)
{
    setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding);
    setAttribute(Qt::WA_Hover,true);
    setObjectName("ImmuItemFrame");
    setBackgroundRole(DPalette::ItemBackground);
    setLineWidth(0);

    m_greenPixmap = Utils::hidpiPixmap(":/resources/icons/v25/space_green.svg", QSize(12, 12));
    m_redPixmap = Utils::hidpiPixmap(":/resources/icons/v25/space_red.svg", QSize(12, 12));
    m_grayPixmap = Utils::hidpiPixmap(":/resources/icons/v25/space_gray.svg", QSize(12, 12));
    m_grayDarkPixmap = Utils::hidpiPixmap(":/resources/icons/v25/space_gray_dark.svg", QSize(12, 12));

    m_icon = new DLabel(this);
    m_title = new DLabel(this);
    m_title->setText(title);

    m_titleDes = new DTipLabel("", this);
    m_titleDes->setText(titleDes);
    m_titleDes->setMinimumWidth(620);
    m_titleDes->setWordWrap(true);

    m_storeUsed = new DColoredProgressBar(this);
    m_storeUsed->setFixedSize(610, 30);
    m_storeUsed->setAlignment(Qt::AlignCenter);
    m_storeUsed->setRange(0, 100);
    //m_storeUsed->addThreshold(0, QColor(0xFF0080FF));
    m_storeUsed->addThreshold(0, m_greenColor);
    //m_storeUsed->addThreshold(70, QColor(0xFFFFAE00));
    m_storeUsed->addThreshold(50, m_redColor);
    //m_storeUsed->addThreshold(90, QColor(0xFFFF0000));
    m_storeUsed->setTextVisible(false);

    m_usedLabelIcon = new DLabel(this);
    m_usedLabelIcon->setFixedSize(12, 12);
    m_usedLabelIcon->setAutoFillBackground(true);
    m_usedLabelIcon->setFrameShape(QFrame::NoFrame);
    m_usedLabelIcon->setWindowFlags(Qt::WindowTransparentForInput);
    m_usedLabelIcon->setAttribute(Qt::WA_TransparentForMouseEvents, true);
    m_usedLabelIcon->setFocusPolicy(Qt::NoFocus);

    m_usedLabel = new DTipLabel();
    m_usedLabel->setText(tr("Used"));
    QFont usedLabelFont = m_usedLabel->font();
    usedLabelFont.setWeight(QFont::Normal);
    m_usedLabel->setFont(usedLabelFont);
    DFontSizeManager::instance()->bind(m_usedLabel, DFontSizeManager::T6);

    m_availableLabelIcon = new DLabel(this);
    m_availableLabelIcon->setFixedSize(12, 12);
    m_availableLabelIcon->setAutoFillBackground(true);
    m_availableLabelIcon->setFrameShape(QFrame::NoFrame);
    m_availableLabelIcon->setWindowFlags(Qt::WindowTransparentForInput);
    m_availableLabelIcon->setAttribute(Qt::WA_TransparentForMouseEvents, true);
    m_availableLabelIcon->setFocusPolicy(Qt::NoFocus);

    m_availableLabel = new DTipLabel();
    m_availableLabel->setText(tr("Available"));
    QFont availableLabelFont = m_availableLabel->font();
    availableLabelFont.setWeight(QFont::Normal);
    m_availableLabel->setFont(availableLabelFont);
    DFontSizeManager::instance()->bind(m_availableLabel, DFontSizeManager::T6);
    updateTheme();
    connect(DGuiApplicationHelper::instance(), &DGuiApplicationHelper::themeTypeChanged,
            this, [this]() {
                updateTheme();
            });
}

ImmuItemFrame::~ImmuItemFrame()
{

}

void ImmuItemFrame::updateTheme()
{
    if (DGuiApplicationHelper::instance()->themeType() == DGuiApplicationHelper::DarkType) {
        m_availableLabelIcon->setPixmap(m_grayDarkPixmap);
        if (needUpdateUsedLabelIcon) {
            m_usedLabelIcon->setPixmap(m_grayDarkPixmap);
        }
    } else {
        m_availableLabelIcon->setPixmap(m_grayPixmap);
        if (needUpdateUsedLabelIcon) {
            m_usedLabelIcon->setPixmap(m_grayPixmap);
        }
    }
}

void ImmuItemFrame::setIconPixmap(const QString &iconRes, const QSize &iconSize)
{
    if (nullptr != m_icon) {
        m_icon->setPixmap(Utils::hidpiPixmap(iconRes, iconSize));
    }
}

void ImmuItemFrame::setStoreText(const QString &text)
{
    if (nullptr != m_storeText) {
        m_storeText->setText(text);
    }
}

void ImmuItemFrame::setStoreUsedValue(int value)
{
    if (nullptr != m_storeUsed) {
        m_storeUsed->setValue(value);
    }

    needUpdateUsedLabelIcon = false;
    if (value <= 0) {
        needUpdateUsedLabelIcon = true;
        updateTheme();
    } else if (value < 50) {
        m_usedLabelIcon->setPixmap(m_greenPixmap);
    } else {
        m_usedLabelIcon->setPixmap(m_redPixmap);
    }
}

void ImmuItemFrame::setItemFrameAccessibleName(const QString &name)
{
    this->setAccessibleName(name);
}

void ImmuItemFrame::setTitleAccessibleName(const QString &name)
{
    if (nullptr != m_title) {
        m_title->setAccessibleName(name);
    }
}

void ImmuItemFrame::setTitleDesAccessibleName(const QString &name)
{
    if (nullptr != m_titleDes) {
        m_titleDes->setAccessibleName(name);
    }
}

void ImmuItemFrame::setIconAccessibleName(const QString &name)
{
    if (nullptr != m_icon) {
        m_icon->setAccessibleName(name);
    }
}
