//
// Created by uos on 2022/3/18.
//

#ifndef UOS_RECOVERY_ITEMFRAME_H
#define UOS_RECOVERY_ITEMFRAME_H

#include <DFrame>
#include <DLabel>
#include <DPushButton>
#include <QStandardItem>
#include <QPixmap>
#include <DTipLabel>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ItemFrame : public DFrame
{
    Q_OBJECT
public:
    explicit ItemFrame(const QString &title, const QString &description, const QString &icon, QWidget *parent = nullptr);
    void setCheckState(bool checked);
    bool checkState();
    void showDescription(bool isShow);
    void setLayoutStype(int layout);
    virtual void initLayout();
    void setIconPixmap(const QString &iconRes, const QSize &iconSize);

    void setItemFrameAccessibleName(const QString &name);
    void setTitleAccessibleName(const QString &name);
    void setDescriptionAccessibleName(const QString &name);
    void setIconAccessibleName(const QString &name);
    void setCheckIconAccessibleName(const QString &name);
    void setSelected(bool select);
    bool isSelected();
    QString getDescriptionOriginText();

    virtual void setSelectedBackground(const QString &selectStat) {}; // 设置选中背景

Q_SIGNALS:
    void clicked(bool checked);

protected:
    bool event(QEvent *e) override;

protected:
    virtual void initHorizontalLayout();
    virtual void initVerticalLayout();

protected:
    DLabel *m_title = nullptr;
    DTipLabel *m_description = nullptr;
    QString m_descriptionText;
    DLabel *m_icon = nullptr;
    DLabel *m_checkIcon = nullptr;
    bool m_bChecked = false;
    bool m_showDescription = false;
    bool m_selected = false;
    QPixmap m_radioPixmap;
    int m_layout = -1;
};


#endif //UOS_RECOVERY_ITEMFRAME_H
