//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/1/29.
//

#ifndef UOS_RECOVERY_AUTHORITY_UTILS_H
#define UOS_RECOVERY_AUTHORITY_UTILS_H

#include <QObject>
#include <QThread>

enum class AuthorityType {
    Invalid = -1,
    SystemBackupV20 = 0,
    SystemRestoreV20,
    InitRestoreV20,
    GhostBackup,
    DataBackup,
    DataRestore,
    DeleteSystemBackupV20,
    DeleteDataBackup,
    DeleteGhost,
    ShowSystemBackupSetting,
    DeleteImmutableSystemBackup,
    DeleteSystemBackup,
    ImmuFactoryRestore,
    ImmuSystemBackup,
    ImmuSystemRestore
};

class AuthorityWorker : public QObject {
    Q_OBJECT
public:
    explicit AuthorityWorker();
    ~AuthorityWorker();

public Q_SLOTS:
    void authorization(int type);
    void checkCommonUserAuthentication(int type);

Q_SIGNALS:
    void notifyAdminAuthority(bool result, int type);
    void notifyCommonUserAuthority(bool result, int type);

private:
    bool checkAuthority(const QString &actionId, qint64 pid);
};

class AuthorityUtils : public QObject {
    Q_OBJECT
public:
    explicit AuthorityUtils();
    ~AuthorityUtils();

    void authorization(AuthorityType type);
    void checkCommonUserAuthentication(AuthorityType type);

Q_SIGNALS:
    void checkAdminAuthority(int type);
    void checkCommonUserAuthority(int type);
    void notifyAdminAuthority(bool result, int authType);
    void notifyCommonUserAuthority(bool result, int authType);

private:
    AuthorityWorker m_adminAuthWorker;
    AuthorityWorker m_commonUserAuthWorker;
    QThread m_adminAuthThread;
    QThread m_commonUserAuthThread;
};
#endif //UOS_RECOVERY_AUTHORITY_UTILS_H
