/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_SCREENACE_WAYLAND_H
#define DTK_SCREENACE_WAYLAND_H

#include <pthread.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct Dtk_Wayland_Client_Backend
{
    struct wl_display *display;
    pthread_mutex_t cond_lock;
    pthread_t dispatch;
    bool lock;

    void *restrict_interface;
} WaylandClientBackend;

typedef struct Dtk_Wayland_Client_Backend *WaylandClientBackendPtr;

/**
 * @brief init wayland display content
 */
int initWaylandScreenAce();

/**
 * @brief destory wayland display content
 */
void destoryWaylandScreenAce();

/**
 * @brief set protected windowid to prohibit screenshot
 * @param wid: window ID
 * @return true: success
 */
bool wSetProtectedWindow(int32_t window);

/**
 * @brief remove protected windowid to enable screenshot
 * @param wid: window ID
 * @return true: success
 */
bool wRemoveProtectedWindow(int32_t window);

/**
 * @brief set screenshot tools blacklist
 * @param name:blacklist
 * @return true: success
 */
bool wSetScreenShotTools(const char *name);

/**
 * @brief remove screenshot tools blacklist
 * @param name: blacklist
 * @return true: success
 */
bool wRemoveScreenShotTools(char *name);

/**
 * @brief free screenshot tools pointer
 */
void wFreeScreenShotTools();

/**
 * @brief set prohibited
 */
void wSetProhibited(const char* white_lists, bool prohibit);

#ifdef __cplusplus
}
#endif

#endif
