/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "clipdatarecord.h"
#include <stdio.h>
#include <string.h>

const string DataType[5] = {"Unknown", "Text", "Image", "File", "Html"};

ClipDataRecord::ClipDataRecord()
{
    m_datatype = "Unknown"; // 数据类型 字符串  text image大的类型
    m_mimetype = "";        // 当前数据的类型
    m_urls.clear();         // 当前数据的url地址
    m_width = 0;
    m_height = 0;
    m_smalllen = 0;
    m_smalldata = NULL;
}

ClipDataRecord::~ClipDataRecord()
{
    if (!m_datapath.empty())
        remove(m_datapath.c_str());
    if (m_smalldata) {
        free(m_smalldata);
        m_smalldata = NULL;
    }
}

string ClipDataRecord::getPlainText()
{
    if (m_datatype == "Text")
        return string(m_smalldata);
    return string();
}

string ClipDataRecord::getHtmlText()
{
    if (m_datatype == "Html")
        return string(m_smalldata);
    return string();
}

vector<string> ClipDataRecord::getUrls()
{
    return m_urls;
}

string ClipDataRecord::getIntent()
{
    return string();
}

void ClipDataRecord::setUri(const vector<string> &uris)
{
    m_urls = uris;
}

void ClipDataRecord::setImageSize(const int &w, const int &h)
{
    m_width = w;
    m_height = h;
}

string ClipDataRecord::getMimeType()
{
    return m_mimetype;
}

void ClipDataRecord::setMimeType(const string &str)
{
    m_mimetype = str;
}

string ClipDataRecord::getDataType()
{
    return m_datatype;
}

void ClipDataRecord::setDataType(const string &str)
{
    m_datatype = str;
}

void ClipDataRecord::setData(const char *data, const int &len)
{
    m_smalllen = len;
    m_smalldata = (char *)malloc(len);
    memset(m_smalldata, 0, len);
    memcpy(m_smalldata, data, len);
}

char *ClipDataRecord::getData(int &len)
{
    len = m_smalllen;
    return m_smalldata;
}

void ClipDataRecord::setDataPath(const string &path)
{
    m_datapath = path;
}

string ClipDataRecord::getDataPath()
{
    return m_datapath;
}

bool ClipDataRecord::contains(const string &allstr, const string &inStr)
{
    size_t found = allstr.find(inStr);
    if (found != string::npos) {
        return true;
    }
    return false;
}

int ClipDataRecord::getImgWidth()
{
    return m_width;
}

int ClipDataRecord::getImgHeight()
{
    return m_height;
}

void ClipDataRecord::save(ofstream &file)
{
    // 写入数据类型的长度和内容
    int len = m_datatype.size();
    file.write((char *)&len, sizeof(int));
    file.write(m_datatype.c_str(), len);

    // 写入图片大小
    file.write((char *)&m_width, sizeof(int));
    file.write((char *)&m_height, sizeof(int));

    // 写入缩略数据的内容
    file.write((char *)&m_smalllen, sizeof(int));
    file.write(m_smalldata, m_smalllen);

    // 写入当前数据类型的长度和内容
    len = m_mimetype.size();
    file.write((char *)&len, sizeof(int));
    file.write(m_mimetype.c_str(), len);

    // 写入当前真实数据的url地址的数量
    int count = m_urls.size();
    file.write((char *)&count, sizeof(int));

    // 遍历每个url地址，并将其长度和内容写入文件
    for (int i = 0; i < count; i++) {
        len = m_urls[i].size();
        file.write((char *)&len, sizeof(int));
        file.write(m_urls[i].c_str(), len);
    }

    // 写入数据落盘路径的长度和内容
    len = m_datapath.size();
    file.write((char *)&len, sizeof(int));
    file.write(m_datapath.c_str(), len);
}

void ClipDataRecord::load(ifstream &file)
{
    // 读取数据类型的长度和内容
    int len = 0;
    file.read((char *)&len, sizeof(int));
    char *datatype = new char[len + 1];
    file.read(datatype, len);
    datatype[len] = '\0';
    m_datatype = string(datatype);
    // 释放内存
    delete[] datatype;
    // 读取图片大小
    file.read((char *)&m_width, sizeof(int));
    file.read((char *)&m_height, sizeof(int));

    // 读取缩略数据的内容
    m_smalllen = 0;
    file.read((char *)&m_smalllen, sizeof(int));

    m_smalldata = (char *)malloc(m_smalllen);
    memset(m_smalldata, 0, m_smalllen);

    file.read(m_smalldata, m_smalllen);

    // 写入当前数据类型的长度和内容
    len = 0;
    file.read((char *)&len, sizeof(int));
    char *mimetype = new char[len + 1];
    file.read(mimetype, len);
    mimetype[len] = '\0';
    m_mimetype = string(mimetype);
    // 释放内存
    delete[] mimetype;



    // 写入当前真实数据的url地址的数量
    int count = 0;
    file.read((char *)&count, sizeof(int));
    m_urls.resize(count);
    // 遍历每个url地址，并将其长度和内容写入文件
    for (int i = 0; i < count; i++) {
        len = 0;
        file.read((char *)&len, sizeof(int));
        char *url = new char[len + 1];
        file.read(url, len);
        url[len] = '\0';
        m_urls[i] = string(url);
        // 释放内存
        delete[] url;
    }

    len = 0;
    file.read((char *)&len, sizeof(int));
    char *datapath = new char[len + 1];
    file.read(datapath, len);
    datapath[len] = '\0';
    m_datapath = string(datapath);
    // 释放内存
    delete[] datapath;
}

int ClipDataRecord::getLength()
{
    // 计算需要的内存空间
    int size = sizeof(int) * 7 + m_smalllen; // 基本数据类型和字符串的空间

    for (int i = 0; i < m_urls.size(); i++) { // url地址的空间
        size += sizeof(int) + m_urls[i].size();
    }
    size += m_datatype.size();
    size += m_mimetype.size();
    size +=  sizeof(uint32_t);
    size += m_datapath.size();
    return size;
}
