# setup.py - Distutils interface for building mglutilc  extensions


from distutils.core import setup, Extension
from distutils.command.build import build
from distutils.command.sdist import sdist
import sys
from os import path

pack_name = "cMolKit"


xtc_source = [path.join(pack_name,"xtcparser.i"),  path.join("src", "libxdrf.c"),
              path.join("src","xtcio.c")]
if sys.platform == "win32":
    xtc_source.append(path.join("src","gmx_system_xdr.c"))

import numpy
numpy_include =  numpy.get_include()
include_dirs = [path.join(".", "src"), numpy_include]

    
# Change the order of commands that are called by "build"
# so that "build_py" command is called after "build_ext". In this case
# "build_py" will install (copy to the build directory) python
# modules generated by "build_ext'.

class modified_build(build):

    sub_commands = [('build_clib',    build.has_c_libraries),
                    ('build_ext',     build.has_ext_modules),
                    ('build_py',      build.has_pure_modules),
                    ('build_scripts', build.has_scripts),
                    ]

# Overwrite the prune_file_list method of sdist to not
# remove automatically the RCS/CVS directory from the distribution.

class modified_sdist(sdist):
    def prune_file_list(self):

        build = self.get_finalized_command('build')
        base_dir = self.distribution.get_fullname()
        self.filelist.exclude_pattern(None, prefix=build.build_base)
        self.filelist.exclude_pattern(None, prefix=base_dir)

try:   
    from version import VERSION
except:
    VERSION = "1.0"
# setup()      
dist = setup(name="cMolKit",
             version=VERSION,
             description = "Python extension module",
             author = "Molecular Graphics Laboratory",
             author_email = "mgltools@scripps.edu",
             url = "http://www.scripps.edu/~sanner/python/packager.html",
             py_modules = ['cMolKit/xtcparser', 'cMolKit.__init__'],
             #packages = ["cMolKit.Tests"],
             cmdclass = {"build" : modified_build,
                         'sdist' : modified_sdist},
             ext_package = pack_name,
             ext_modules = [Extension ("_xtcparser", xtc_source,
                                  include_dirs = include_dirs,
                                  #define_macros = [('UNIX', None),],
                                       ) ] ,)


