/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __UOSNNTP_H__
#define __UOSNNTP_H__

#include "libsylph/nntp.h"
#include "uossession.h"
#if USE_SSL
#  include "uosssl.h"
#endif
#include "uossocks.h"

typedef SocksInfo UosSocksInfo;

typedef NNTPSession UosNNTPSession;

#define UOSNNTP_SESSION(obj) NNTP_SESSION(obj)

#define UOSNN_SUCCESS	NN_SUCCESS
#define UOSNN_SOCKET	NN_SOCKET
#define UOSNN_AUTHFAIL	NN_AUTHFAIL
#define UOSNN_PROTOCOL	NN_PROTOCOL
#define UOSNN_SYNTAX	NN_SYNTAX
#define UOSNN_IOERR	NN_IOERR
#define UOSNN_ERROR	NN_ERROR
#define UOSNN_AUTHREQ	NN_AUTHREQ
#define UOSNN_AUTHCONT	NN_AUTHCONT

#define UOSNNTPBUFSIZE	NNTPBUFSIZE

#if USE_SSL
UosSession *uos_nntp_session_new	(const gchar	*server,
				 gushort	 port,
				 gchar		*buf,
				 const gchar	*userid,
				 const gchar	*passwd,
				 SSLType	 ssl_type);
UosSession *uos_nntp_session_new_full	(const gchar	*server,
				 gushort	 port,
                 UosSocksInfo	*socks_info,
				 gchar		*buf,
				 const gchar	*userid,
				 const gchar	*passwd,
				 SSLType	 ssl_type);
#else
UosSession *uos_nntp_session_new	(const gchar	*server,
				 gushort	 port,
				 gchar		*buf,
				 const gchar	*userid,
				 const gchar	*passwd);
UosSession *uos_nntp_session_new_full	(const gchar	*server,
				 gushort	 port,
				 SocksInfo	*socks_info,
				 gchar		*buf,
				 const gchar	*userid,
				 const gchar	*passwd);
#endif

gint uos_nntp_group			(UosNNTPSession	*session,
				 const gchar	*group,
				 gint		*num,
				 gint		*first,
				 gint		*last);
gint uos_nntp_get_article		(UosNNTPSession	*session,
				 const gchar	*cmd,
				 gint		 num,
				 gchar	       **msgid);
gint uos_nntp_article		(UosNNTPSession	*session,
				 gint		 num,
				 gchar	       **msgid);
gint uos_nntp_body			(UosNNTPSession	*session,
				 gint		 num,
				 gchar	       **msgid);
gint uos_nntp_head			(UosNNTPSession	*session,
				 gint		 num,
				 gchar	       **msgid);
gint uos_nntp_stat			(UosNNTPSession	*session,
				 gint		 num,
				 gchar	       **msgid);
gint uos_nntp_next			(UosNNTPSession	*session,
				 gint		*num,
				 gchar	       **msgid);
gint uos_nntp_xover			(UosNNTPSession	*session,
				 gint		 first,
				 gint		 last);
gint uos_nntp_xhdr			(UosNNTPSession	*session,
				 const gchar	*header,
				 gint		 first,
				 gint		 last);
gint uos_nntp_list			(UosNNTPSession	*session);
gint uos_nntp_post			(UosNNTPSession	*session,
				 FILE		*fp);
gint uos_nntp_newgroups		(UosNNTPSession	*session);
gint uos_nntp_newnews		(UosNNTPSession	*session);
gint uos_nntp_mode			(UosNNTPSession	*session,
				 gboolean	 stream);

#endif /* __UOSNNTP_H__ */
