#include "toolbar.h"
#include <QDebug>
ToolBar::ToolBar(QWidget *parent) : QWidget(parent)
{
    initUI();
    initConnections();
}

void ToolBar::initUI()
{

    QHBoxLayout *mainHlayout = new QHBoxLayout(this);
    mainHlayout->setContentsMargins(0,6,0,10);
    mainHlayout->setSpacing(10);
    iconLable = new DLabel;
    QIcon logo_icon=QIcon::fromTheme("ndm_preferencesystem");
    iconLable->setPixmap(logo_icon.pixmap(32,32));
    iconLable->setFixedSize(36,36);
    searchEdit =new DSearchEdit();
    searchEdit->setMinimumWidth(350);
    searchEdit->setFixedHeight(36);
    //searchEdit->setFixedSize(350,36);
    newDownloadBtn = new DIconButton(this);
    newDownloadBtn->setFixedSize(36,36);
    newDownloadBtn->setIcon(QIcon::fromTheme("ndm_newdownload"));

    pauseDownloadBtn = new DIconButton(this);
    //pauseDownloadBtn->setFixedSize(36,36);
    pauseDownloadBtn->setIcon(QIcon::fromTheme("ndm_list_icon_pause"));
    pauseDownloadBtn->setEnabled(false);
    pauseDownloadBtn->setGeometry(90,0,36,36);

    startDownloadBtn = new DIconButton(this);
    startDownloadBtn->setFixedSize(36,36);
    startDownloadBtn->setIcon(QIcon::fromTheme("ndm_icon_start"));
    startDownloadBtn->setEnabled(false);

    deleteDownloadBtn = new DIconButton(this);
    deleteDownloadBtn->setFixedSize(36,36);
    deleteDownloadBtn->setIcon(QIcon::fromTheme("ndm_list_icon_delete"));
    deleteDownloadBtn->setEnabled(false);

    mainHlayout->addSpacing(5);
    mainHlayout->addWidget(iconLable);
    mainHlayout->addSpacing(7);
    mainHlayout->addWidget(pauseDownloadBtn);
    mainHlayout->addWidget(startDownloadBtn);

    mainHlayout->addWidget(deleteDownloadBtn);
    mainHlayout->addWidget(newDownloadBtn);

    mainHlayout->addWidget(searchEdit);
    //mainHlayout->addStretch();

}

void ToolBar::initConnections()
{
    connect(newDownloadBtn, &DIconButton::clicked, this, &ToolBar::newDownloadBtnClicked);
    connect(pauseDownloadBtn, &DIconButton::clicked, this, &ToolBar::pauseDownloadBtnClicked);
    connect(startDownloadBtn, &DIconButton::clicked, this, &ToolBar::startDownloadBtnClicked);
    connect(deleteDownloadBtn, &DIconButton::clicked, this, &ToolBar::deleteDownloadBtnClicked);

    connect(searchEdit, &DSearchEdit::focusChanged, this, &ToolBar::getSearchEditFocus);
    connect(searchEdit,&DSearchEdit::textChanged,this,&ToolBar::getSearchEditTextChange);
}


void ToolBar::get_table_changed(int index)
{
    if(index==1||index==2)
    {
        startDownloadBtn->setEnabled(false);
        pauseDownloadBtn->setEnabled(false);
        deleteDownloadBtn->setEnabled(false);
        if(index==2)
        {
            deleteDownloadBtn->setIcon(QIcon::fromTheme("ndm_recycel_delete"));
        }
        else {
            deleteDownloadBtn->setIcon(QIcon::fromTheme("ndm_list_icon_delete"));
        }
    }
    else
    {
        startDownloadBtn->setEnabled(false);
        pauseDownloadBtn->setEnabled(false);
        deleteDownloadBtn->setEnabled(false);
        deleteDownloadBtn->setIcon(QIcon::fromTheme("ndm_list_icon_delete"));


    }
}
