// $Id: ActiveMessageC.nc,v 1.9 2010-06-29 22:07:54 scipio Exp $

/*
 * Copyright (c) 2004-2005 The Regents of the University  of California.  
 * Copyright (c) 2004-2005 Intel Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the copyright holders nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/*
 *
 * Authors:		Philip Levis
 * Date last modified:  $Id: ActiveMessageC.nc,v 1.9 2010-06-29 22:07:54 scipio Exp $
 *
 */

/**
 *
 * The Active Message layer on the Telos platform. This is a naming wrapper
 * around the CC2420 Active Message layer.
 *
 * @author Philip Levis
 * @version $Revision: 1.9 $ $Date: 2010-06-29 22:07:54 $
 */
#include "Timer.h"

configuration ActiveMessageC {
  provides {
    interface SplitControl;

    interface AMSend[am_id_t id];
    interface Receive[am_id_t id];
    interface Receive as Snoop[am_id_t id];

    interface Packet;
    interface AMPacket;
    interface PacketAcknowledgements;
    interface PacketTimeStamp<T32khz, uint32_t> as PacketTimeStamp32khz;
    interface PacketTimeStamp<TMilli, uint32_t> as PacketTimeStampMilli;
    interface LowPowerListening;
  }
}
implementation {
#ifdef RFXLINK
  components CC2420XActiveMessageC as AM;
#else
  components CC2420ActiveMessageC as AM;
#endif

  SplitControl = AM;
  
  AMSend       = AM;
  Receive      = AM.Receive;
  Snoop        = AM.Snoop;
  Packet       = AM;
  AMPacket     = AM;
  PacketAcknowledgements = AM;
  LowPowerListening = AM;

#ifdef RFXLINK
  PacketTimeStamp32khz = AM;
  PacketTimeStampMilli = AM;
#else
  components CC2420PacketC;
  PacketTimeStamp32khz = CC2420PacketC;
  PacketTimeStampMilli = CC2420PacketC;
#endif
}
