#ifndef TC_TPM2_H
#define TC_TPM2_H

#include "tc_private/tc_private.h"

#ifdef __cplusplus
extern "C" {
#endif

/*  初始化  */
TC_RC tpm2_start(API_CTX *ctx);

TC_RC tpm2_start_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_start_free(struct api_ctx_st *api_ctx);

/*  释放    */
TC_RC tpm2_end(API_CTX *ctx);

TC_RC tpm2_end_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_end_free(struct api_ctx_st *api_ctx);

/*  创建主密钥/主对象    */
TC_RC tpm2_createprimary(API_CTX *ctx);

TC_RC tpm2_createprimary_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_createprimary_free(struct api_ctx_st *api_ctx);

/*  创建子对象/子密钥    */
TC_RC tpm2_create(API_CTX *ctx);

TC_RC tpm2_create_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_create_free(struct api_ctx_st *api_ctx);

/*  对象/密钥导入    */
TC_RC tpm2_load(API_CTX *ctx);

TC_RC tpm2_load_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_load_free(struct api_ctx_st *api_ctx);

/*  加密    */
TC_RC tpm2_encrypt(API_CTX *ctx);

TC_RC tpm2_encrypt_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_encrypt_free(struct api_ctx_st *api_ctx);

/*  加密    */
TC_RC tpm2_decrypt(API_CTX *ctx);

TC_RC tpm2_decrypt_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_decrypt_free(struct api_ctx_st *api_ctx);

/*  哈希    */
TC_RC tpm2_hash(API_CTX *ctx);

TC_RC tpm2_hash_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_hash_free(struct api_ctx_st *api_ctx);

/*  签名    */
TC_RC tpm2_sign(API_CTX *ctx);

TC_RC tpm2_sign_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_sign_free(struct api_ctx_st *api_ctx);

/*  验证签名    */
TC_RC tpm2_verifysignature(API_CTX *ctx);

TC_RC tpm2_verifysignature_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_verifysignature_free(struct api_ctx_st *api_ctx);

/*  临时对象持久化或驱逐持久性对象    */
TC_RC tpm2_evictcontrol(API_CTX *ctx);

TC_RC tpm2_evictcontrol_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_evictcontrol_free(struct api_ctx_st *api_ctx);

// /*  持久性对象列表查看    */
// TC_RC tpm2_listpersistent(API_CTX *ctx);

// TC_RC tpm2_listpersistent_init(struct api_ctx_st *api_ctx, int num, ...);
// TC_RC tpm2_listpersistent_free(struct api_ctx_st *api_ctx);

/*  定义NV    */
TC_RC tpm2_nvdefine(API_CTX *ctx);

TC_RC tpm2_nvdefine_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_nvdefine_free(struct api_ctx_st *api_ctx);

/*  释放NV    */
TC_RC tpm2_nvrelease(API_CTX *ctx);

TC_RC tpm2_nvrelease_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_nvrelease_free(struct api_ctx_st *api_ctx);

/*  读取NV    */
TC_RC tpm2_nvread(API_CTX *ctx);

TC_RC tpm2_nvread_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_nvread_free(struct api_ctx_st *api_ctx);

/*  写入NV    */
TC_RC tpm2_nvwrite(API_CTX *ctx);

TC_RC tpm2_nvwrite_init(struct api_ctx_st *api_ctx, int num, ...);
TC_RC tpm2_nvwrite_free(struct api_ctx_st *api_ctx);

#ifdef __cplusplus
}
#endif

#endif /* TC_TPM2_H */