/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "CreateRepositoryDialog.h"
#include "ExternProvider.h"
#include "Settings.h"
#include "sublib/Gui.h"
#include "sublib/Utility.h"
#include "sublib/ExternButton.h"
#include "sublib/settings/LayoutSettings.h"
#include "util/String.h"
#include "util/max.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QFileDialog>
#include <QtGui/QToolTip>
#include <QtGui/QComboBox>
#include <QtGui/QCheckBox>
#include <QtGui/QGroupBox>
#include <QtGui/QDialogButtonBox>



CreateRepositoryDialog::CreateRepositoryDialog( ExternProvider* p, QWidget* parent )
: super(parent, 0, true), _p(p)
{
  setName( "CreateRepository" );
  setCaption( _q("subcommander:create local repository") );

  QVBoxLayout *vbl = new QVBoxLayout(this);
  vbl->setContentsMargins(5,5,5,5);
  {
    QGroupBox* gb = new QGroupBox(this);
    gb->setTitle( _q("create options: ") );
    gb->setFlat(true);
    vbl->addWidget(gb,0);
    {
      QGridLayout* gl = new QGridLayout(gb);
      int left, top, right, bottom;
      gl->getContentsMargins(&left,&top,&right,&bottom);
      gl->setContentsMargins(0,top,0,bottom);
      gl->setColStretch( 0, 0 );
      gl->setColStretch( 1, 4 );
      {
        QComboBox* tc = new QComboBox( false, this );
        QLabel*    tl = new QLabel( tc, _q("repository type:"), this );
        tc->insertItem( getPixmap(), getType() );

        gl->addWidget( tl, 0, 0 );
        gl->addWidget( tc, 0, 1, 1, 2 );


        _name = new QLineEdit(this); 
        _path = new QComboBox(this);
        QLabel* ln = new QLabel( _name, _q("&name"), this );
        QLabel* ls = new QLabel( _path, _q("&path"), this );
        gl->addWidget( ln, 1, 0, 1, 1 );
        gl->addWidget( ls, 1, 1, 1, 2 );

        _ex = new ExternButton(this);
        _path->setEditable(true);
        _name->setFocus();

        gl->addWidget( _name, 2, 0 ); 
        gl->addWidget( _path, 2, 1 ); 
        gl->addWidget( _ex,   2, 2 );

        connect( _name, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _path, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _ex, SIGNAL(clicked()), SLOT(selectExtern()) );
      }
    }

    QDialogButtonBox* db = new QDialogButtonBox(this);
    vbl->addWidget(db);
    {
      int minWidth = 0;
 
      _ok = new QPushButton(this);
      _ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      db->addButton( _ok, QDialogButtonBox::AcceptRole );
      minWidth = std::max( minWidth, _ok->sizeHint().width() );

      _ca = new QPushButton(this);
      _ca->setText( _q("&Cancel") );
      db->addButton( _ca, QDialogButtonBox::RejectRole );
      minWidth = std::max( minWidth, _ca->sizeHint().width() );
      
      _ok->setMinimumWidth(minWidth);
      _ca->setMinimumWidth(minWidth);

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( _ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  Settings s;
  resize( s.layout().getSize(name(),QSize()) );
  setMaximumHeight( sizeHint().height() );
}

CreateRepositoryDialog::~CreateRepositoryDialog()
{
  Settings s;
  s.layout().setSize( name(), size() );
}

QString CreateRepositoryDialog::getName()
{
  return _name->text();
}

QString CreateRepositoryDialog::getPath()
{
  return _path->currentText();
}

void CreateRepositoryDialog::checkOk( const QString& text )
{
  QString name = _name->text();
  QString path = _path->currentText();

  if( ! name.isEmpty() && ! path.isEmpty() )
    _ok->setEnabled(true);
  else
    _ok->setEnabled(false);
}

void CreateRepositoryDialog::selectExtern()
{
  sc::String res;

  if( _p->selectPath( this, sc::String(_path->currentText().utf8()), res, ExternProvider::Dir ) )
  {
    _path->setCurrentText(QString::fromUtf8(res));
  }
}

QPixmap CreateRepositoryDialog::getPixmap()
{
  return QPixmap(getIconDir() + "BookmarkRepository.png");
}

QString CreateRepositoryDialog::getType()
{
  return _q("fsfs repository");
}
