 /*****************************************************************************
 **  This is part of the SpaceZero program
 **  Copyleft (C) 2006-2011  M.Revenga
 **
 **  This program is free software; you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License (version 3), or
 **  (at your option) any later version, as published by the Free Software 
 **  Foundation.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with this program; if not, write to the Free Software
 **  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

/*************  SpaceZero  M.R.H. 2006-2011 ******************
		Author: M.Revenga
		E-mail: mrevenga at users.sourceforge.net
		version 0.80 May 2011
****/

#ifndef _SPACECOMM_
#define _SPACECOMM_


#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pthread.h>
#include <semaphore.h>
#include <signal.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "general.h"
#include "objects.h"
#include "help.h"
#include "comm.h"



#define DEFAULT_IP "127.0.0.1"
#define DEFAULT_PORT 8000


#define NETSTEP 3


/* types of orders among server and clients 
   Orders to Threads
*/

#define OTSENDPING 1 
#define OTSENDOBJS 2    /* send modified objects */
#define OTSENDSAVE 3    /* sendallobjects */
#define OTSENDLOAD 4    /* load game */
#define OTSENDKILL 5    /* kill client */   
#define OTSENDEND  6     /* no more messages */

/* 
   header messages ids
*/


#define SENDGLOBAL 17
#define SENDPLAYER 18
#define SENDPLAYERMOD 19
#define SENDPLANET 20
#define SENDSTR 21
#define SENDPLANETLIST 22 
#define SENDSECTORLIST 23
#define SENDPAUSE 24
#define SENDOK 25
#define SENDEND 26

/* object modify types, used in transmission buffer */

#define SENDOBJUNMOD   33 /* obj unmodified, dont send */
#define SENDOBJMOD0    34 /* obj modified, send only position */
#define SENDOBJMOD     35 /* obj modified, send more information */
#define SENDOBJAALL    36 /* obj modified, send almost all info */
#define SENDOBJALL     37 /* obj modified, send all info */
#define SENDOBJKILL    38 /* delete the object  */
#define SENDOBJNEW     39 /* new obj */
#define SENDOBJDEAD    40 /* dont send and remove */
#define SENDOBJPLANET  41 /* send all info planet */
#define SENDOBJSTR     42 /* send a text message */
#define SENDOBJSEND    43 /* object just sended */
#define SENDOBJNOTSEND 44 /* dont send */



struct Thread_arg{
  int sfd;
  int sfd2;
  int id;
  int n;
};



/* Declaracion de funciones */

int OpenComm(int mode,struct Parametres param);
void *CommClient(struct Thread_arg *);
void *CommServer(struct Thread_arg *);

int ReadObjsfromBuffer(char *buf);

int AddPlayerOrders2Buffer(int player, char *);
int CopyPlayerOrdersfromBuffer(int player,char *);

int AddObjOrders2Buffer(struct Buffer *buffer,Object *obj);
int CopyObjOrdersfromBuffer(Object *obj0,char *buf);


void Print_Message(struct Message *mess);
void SendTextMessage(char *mess);
int PendingTextMessage(void);
void GetTextMessage(char *mess);

int SetModified(Object *obj,int mode);
int SetModifiedAll(struct HeadObjList *lh,int type,int mode,int force);
int CheckModifiedPre(struct HeadObjList *lh,int proc);
int CheckModifiedPost(struct HeadObjList *lh,int proc);
void Setttl0(struct HeadObjList *lh);
void Setttl(struct HeadObjList *lh,int ttl);


void LoadBuffer(int order,struct Buffer *buf,int mode);
int CopyObjs2Buffer(struct Buffer *buffer,struct HeadObjList hl);
int CopyObj2Buffer(struct Buffer *buffer,void *object,int modtype);
int CopyMessHeader2Buffer(struct Buffer *buffer,  struct MessageHeader *messh);
int CopyGlobal2Buffer(struct Buffer *buf);
int CopyPlayer2Buffer(struct Buffer *buffer,  struct Player *player);
int CopyOrder2Buffer(struct Buffer *buffer,  struct Order *order);
int CopyInt2Buffer(struct Buffer *buffer,int *i);

int ServerProcessBuffer(struct Buffer *buffer);
int ClientProcessBuffer(struct Buffer *buffer);
int CopyPlayerMod2Buffer(struct Buffer *buffer,  struct Player *player);


#endif

