/*
 * Test program for the BASIL ENGINE-type "QUERY" method
 */
#include "basil_alps.h"
#include "cmdline.h"

int main(int argc, char **argv)
{
	struct gengetopt_args_info args;

	if (cmdline_parser(argc, argv, &args) != 0)
		return EXIT_FAILURE;

	if (args.basil_flag) {
		enum basil_version version = get_basil_version();

		if (args.verbose_flag)
			printf( "BASIL release:  %s\nBASIL protocol: ",
				bv_names_long[version]);
		printf("%s\n", bv_names[version]);
	} else { /* args.engine_flag */
		char alps_engine[BASIL_STRING_LONG];

		if (get_alps_engine(alps_engine, sizeof(alps_engine)) == NULL)
			return EXIT_FAILURE;
		printf("ALPS engine version '%s'\n", alps_engine);
	}

	return EXIT_SUCCESS;
}

