/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * AtFS -- Attribute Filesystem
 *
 * config.h -- system dependent definitions
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: config.h[7.1] Tue Aug 23 16:58:49 1994 andy@cs.tu-berlin.de frozen $
 */

/* do only once */
#ifndef _defs_
#define _defs_

/* if no explicit system type is defined */
#if (!defined(s_aix) && !defined(s_hpux) && !defined(s_irix) && !defined(s_mach) && !defined(s_sunos_4) && !defined(s_svr_4) && !defined(s_ultrix) && !defined(s_linux))
#  define _system_
#endif

#ifdef __STDC__
#  define A(alist) alist
#else
#  define A(alist) ()
#endif

/*=====================
 *  includes
 *=====================*/

/* POSIX include files */
#include <locale.h>
#include <limits.h>
#include <signal.h>
#include <stddef.h>
#if !defined(s_irix)
#ifdef NULL
#  undef NULL
#endif
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#if defined(s_mach)
#  include <sys/dir.h>
#  include <sys/dirent.h>
#  include <sys/fcntl.h>
#  include <sys/ioctl.h>
#else
#  include <dirent.h>
#  include <fcntl.h>
#  include <unistd.h>
#  include <utime.h>
#  include <termios.h>
#endif

/* system dependent includes */
#if !defined(_POSIX_SOURCE)
#  include <sys/param.h>
#  include <sys/time.h>
#endif

/* debugging */
#ifdef DEBUG_MALLOC
#include "malloc.h"
#endif

/*==================================
 *  constants and macros and types
 *==================================*/

/*** general ***/

#define Sfunc_t  int         /* type of function argument to signal call */
#define Sigret_t void	     /* return type of signal system call */

#if defined(s_aix)
# if defined(_POSIX_SOURCE)
#  include <sys/dir.h>
#  include <sys/param.h>
#  define NAME_MAX	_D_NAME_MAX
# else
#  define NAME_MAX	MAXNAMLEN
#  define MAXHOSTNAMELEN 32
# endif
#  define MAXDOMAIN 255
#  define NEED_MNTENT
#  define vfork fork

#elif defined(s_hpux)
#  define MAXDOMAIN 255
#  define PATH_MAX	MAXPATHLEN
#  define NAME_MAX	MAXNAMLEN
#  define OPEN_MAX      NOFILE
#  define NEED_REGEX
#  define HAS_MNTENT

#elif defined(s_irix)
#  define MAXDOMAIN 255
#  define vfork fork
#  define HAS_MNTENT

#elif defined(s_mach)
#  define MAXDOMAIN 255
#  define PATH_MAX	MAXPATHLEN
#  define NAME_MAX	MAXNAMLEN
#  define OPEN_MAX      NOFILE
#  define NGROUPS_MAX	NGROUPS
typedef unsigned short mode_t;
typedef int            pid_t;
#  define dirent direct
#  define NO_SIGSET
#  define NEED_GETCWD
#  define NEED_STRDUP
#  define NEED_UTIMBUF
#  define HAS_MNTENT

#elif defined(s_osf1)
# include <sys/param.h>
# include <sys/time.h>
# define MAXDOMAIN	255
# define OPEN_MAX	NOFILE
# define NEED_MNTENT

#elif defined(s_sunos_4)
# if defined(_POSIX_SOURCE)
#  define MAXDOMAIN      255
#  define MAXHOSTNAMELEN 64
#  define PATH_MAX	 1024
#  define NAME_MAX	 255
#  define OPEN_MAX	 64
# else
#  define PATH_MAX	MAXPATHLEN
#  define NAME_MAX	MAXNAMLEN
#  define OPEN_MAX	NOFILE
# endif
#  define HAS_MNTENT

#elif defined(s_svr_4) /* Solaris_2 */
#  define MAXDOMAIN 	 255
#  define MAXHOSTNAMELEN 64
# if defined(_POSIX_SOURCE)
#  define NAME_MAX	 512
#  define OPEN_MAX	 64
# else
#  ifndef PATH_MAX
#   define PATH_MAX	MAXPATHLEN
#  endif
#  ifndef NAME_MAX
#   define NAME_MAX	MAXNAMLEN
#  endif
#  ifndef OPEN_MAX
#   define OPEN_MAX	NOFILE
#  endif
# endif
#  define NEED_REGEX
#  define HAS_MNTTAB

#elif defined(s_linux) 
#  include <sys/param.h>
#  include <sys/time.h>
#  define MAXDOMAIN 	 255
#  define HAS_MNTENT

#elif defined(s_ultrix)
#  define MAXDOMAIN 255
#  define NEED_MNTENT
#  define NEED_STRDUP
#endif

/*** mount table stuff ***/

#if defined(HAS_MNTENT)
#  include <mntent.h>
#  define atMntent      mntent
#  define at_mnt_dir    mnt_dir
#  define at_mnt_fsname mnt_fsname
#  define atSetmntent   setmntent
#  define atGetmntent   getmntent
#  define atEndmntent   endmntent
#elif defined(HAS_MNTTAB)
#  include <sys/mnttab.h>
#  define atMntent      mnttab
#  define at_mnt_dir    mnt_mountp
#  define at_mnt_fsname mnt_special
#  define atSetmntent   fopen
#  define atEndmntent   fclose
  struct atMntent* atGetmntent	A((FILE *file));
  
#else /* NEED_MNTENT */
  struct atMntent {
    char *at_mnt_fsname;
    char *at_mnt_dir;
    char *at_mnt_type;
    char *at_mnt_opts;
    int  at_mnt_freq;
    int  at_mnt_passno;
  };

  int		   atEndmntent	A((FILE *file));
  struct atMntent* atGetmntent	A((FILE *file));
  FILE*		   atSetmntent	A((const char *path, const char *type));
#endif


/*** specials ***/

#if defined(s_mach)
#define	S_IRWXU 0000700	/* rwx------ */
#define	S_IRUSR	0000400	/* r-------- */
#define	S_IWUSR	0000200	/* -w------- */
#define	S_IXUSR	0000100	/* --x------ */
#define	S_IRWXG	0000070	/* ---rwx--- */
#define	S_IRGRP	0000040	/* ---r----- */
#define	S_IWGRP	0000020	/* ----w---- */
#define	S_IXGRP	0000010	/* -----x--- */
#define	S_IRWXO	0000007	/* ------rwx */
#define	S_IROTH	0000004	/* ------r-- */
#define	S_IWOTH	0000002	/* -------w- */
#define	S_IXOTH	0000001	/* --------x */

#define	S_ISBLK(mode)	((mode & S_IFMT) == S_IFBLK)
#define	S_ISCHR(mode)	((mode & S_IFMT) == S_IFCHR)
#define	S_ISDIR(mode)	((mode & S_IFMT) == S_IFDIR)
#define	S_ISFIFO(mode)	((mode & S_IFMT) == S_IFIFO)
#define	S_ISREG(mode)	((mode & S_IFMT) == S_IFREG)

#define WEXITSTATUS(a) ((a).w_T.w_Retcode)
#endif

/*** own definitions ***/
#define TYPE_MAX	NAME_MAX
#define HOST_MAX	MAXHOSTNAMELEN
#define DOMAIN_MAX	MAXDOMAIN

/*** obsolete definitions ***/
#define MAXUSERNAMELEN 64

/*=====================
 *  types
 *=====================*/

#if defined(s_mach)
#define Wait_t   union wait
#else
#define Wait_t   int         /* type of argument for wait call */
#endif

#if defined(NEED_UTIMBUF)
struct  utimbuf {
        time_t  actime;         /* set the access time */
        time_t  modtime;        /* set the modification time */
};
#endif

/*=====================
 *  prototypes
 *=====================*/

/*** missing POSIX prototypes ***/

#if defined(s_aix)
#elif defined(s_mach)
void	_exit		A((int status));
int	access		A((const char *path, int amode));
int	chdir		A((const char *path));
int	chmod		A((const char *path, mode_t mode));
int	chown		A((const char *path, uid_t owner, gid_t group));
int	close		A((int filedes));
int	creat		A((const char *path, mode_t mode));
int	dup		A((int filedes));
int	execve		A((const char *path, const char *argv[], const char *envp[]));
int	execvp		A((const char *file, const char *argv[])); 
int	fcntl		A((int filedes, int cmd, ...));
FILE	*fdopen		A((int filedes, const char *type));
int	fileno		A((FILE *stream));
pid_t	fork		A((void));
char	*getcwd		A((char *buf, size_t size));
gid_t	getegid		A((void));
uid_t	geteuid		A((void));
int	getgroups	A((int gidsetsize, gid_t grouplist[]));
pid_t	getpid		A((void));
pid_t	getppid		A((void));
int	isatty		A((int filedes));
int	kill		A((pid_t oid, int signal));
int	link		A((const char *existing, const char *new));
int	mkdir		A((const char *path, mode_t mode));
int	open		A((const char *path, int oflag, ...));
int	pipe		A((int filedes[2]));
int	read		A((int filedes, void *buf, unsigned int nbyte));
unsigned int sleep	A((unsigned int seconds));
int	tolower		A((int c));
mode_t	umask		A((mode_t cmask));
int	unlink		A((const char *path));
int	utime		A((const char *path, const struct utimbuf *times));
int	write		A((int filedes, const void*buf, unsigned int nbyte));
#elif defined(s_sunos_4)
int	fflush		A((FILE *stream));
int	fclose		A((FILE *stream));
int	fprintf		A((FILE *stream, const char *format, ...));
int	printf		A((const char *format, ...));
int	fscanf		A((FILE *stream, const char *format, ...));
int	fputs		A((const char *s, FILE *stream));
int	fgetc		A((FILE *stream));
int	fputc		A((int c, FILE *stream));
size_t	fread		A((void *ptr, size_t size, size_t nobj, FILE *stream));
size_t	fwrite		A((const void *ptr, size_t size, size_t nobj, FILE *stream));
void	perror		A((const char *s));

#ifndef DEBUG_MALLOC
void	*memmove	A((void *dest, const void *source, size_t len));
void	*memchr		A((const void *string, int chr, size_t len));
void	*memset		A((void *string, int c, size_t len));
#endif

time_t	time		A((time_t *timeptr));
time_t	mktime		A((struct tm *timeptr));

int	system		A((const char *string));
int	tolower		A((int c));
#elif defined(s_svr_4)
int	tolower		A((int c));
#endif

/*** non POSIX prototypes ***/

int	openlog		A((char *ident, int logopt, int facility));
int	syslog		A((int priority, char *message, ...));
int	closelog	A((void));
FILE*	popen		A((const char *command, const char *mode));
int	pclose		A((FILE *stream));
#if (!defined(s_linux))
int	getdomainname	A((char *name, int namelen));
#endif
#if !defined(s_irix)
char*	re_comp		A((char *string));
int	re_exec		A((char *string));
#endif
char*	strdup		A((const char *string));
int	symlink		A((const char *name1, const char *name2));
#if (!defined(s_hpux) && !defined(s_svr_4) && !defined(s_irix))
int	ioctl		A((int fd, int request, caddr_t arg));
int	vfork		A((void));
#if (!defined(s_linux))
int	getopt		A((int argc, char **argv, char *optstring));
#endif
#endif
#if (!defined(s_hpux) && !defined(s_linux)) 
int	gethostname	A((char *name, int namelen));
#endif

/*** own prototypes ***/

void	disableSig	A((int signo));
void	enableSig	A((void));

#endif /* _defs_ */
