///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// i/o in cemagref topo format

#include "rheolef/field.h"
using namespace rheolef;
using namespace std;

ostream&
field::put_cemagref (ostream& out) const
{
#ifdef TODO
    get_geo().put_cemagref (out, *this, true);
#else
    fatal_macro ("put_cemagref: no more supported");
#endif
    return out;
}
istream&
field::get_cemagref (istream& in)
{
    string basename = iorheo::getbasename(in);
    geo g;
    if (basename.length() != 0) {
        g.set_name(basename);
    } else {
        g.set_name("unnamed");
	warning_macro ("unnamed input mesh has been named `" << g.name() << "'");
    }
#ifdef TODO
    return g.get_cemagref (in, *this, true);
#else
    fatal_macro ("get_cemagref: no more supported");
#endif
    return in;
}   

