#!/bin/sh
basis_list=$*

cat << EOF1
// file automatically generated by: $0
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/basis.h"
#include "basis_fem_Pk_lagrange.h"
#include "basis_fem_Pk_bernstein.h"
#include "basis_fem_Pk_sherwin.h"
#include "basis_fem_RTk.h"
EOF1

for basis in ${basis_list}; do
 echo "#include \"${basis}.h\""
done

cat << EOF2
namespace rheolef {
using namespace std;

template<class T>
bool
basis_rep<T>::have_degree_parameter (std::string name) {
EOF2

for basis in ${basis_list}; do
  is_Pk=`echo "$basis" | grep '^P[0-9]$'`
  if test x"$is_Pk" != x""; then continue; fi
  echo "  if (name == \"${basis}\") return false;"
done

cat << EOF3
  return true;
}
template<class T>
bool
basis_rep<T>::have_continuous_feature (std::string name) {
EOF3

for basis in ${basis_list}; do
  is_Pk_C0=`echo "$basis" | grep '^P[1-9]$'`
  if test x"$is_Pk_C0" != x""; then continue; fi
  echo "  if (name == \"${basis}\") return false;"
done

cat << EOF4
  return true;
}
template<class T>
basis_rep<T>*
basis_rep<T>::make_ptr (
    std::string              name,
    const basis_option& sopt)
{
  // TODO: how to a user's defined basis to the list ?
  // TODO: use gperf or hashtable instead of a long if-else test suite
  if (name == "") return 0;
EOF4

for basis in ${basis_list}; do
  is_Pk_C0=`echo "$basis" | grep '^P[1-9]$'`
  if test x"$is_Pk_C0" != x""; then
    echo "  if (name == \"${basis}\") return new_macro(basis_${basis}<T>(sopt));"
  else
    echo "  if (name == \"${basis}\") return new_macro(basis_${basis}<T>);"
  fi
done

cat << EOF5
  if (name[0] == 'P') return new_macro(basis_fem_Pk_lagrange<T>(name, sopt));
  if (name[0] == 'B') return new_macro(basis_fem_Pk_bernstein<T>(name, sopt));
  if (name[0] == 'S') return new_macro(basis_fem_Pk_sherwin<T>(name, sopt));
  if (name.length() >= 2 && name[0] == 'R' && name[1] == 'T')
                    return new_macro(basis_fem_RTk<T>(name, sopt));
  error_macro ("undefined basis \`" << name << "'");
  return 0;
}
// instanciation in library:
template basis_rep<Float>* basis_rep<Float>::make_ptr (string, const basis_option&);
template bool              basis_rep<Float>::have_degree_parameter   (std::string family_name);
template bool              basis_rep<Float>::have_continuous_feature (std::string family_name);

} // namespace rheolef
EOF5

exit 0
