// file automatically generated by: ../../../rheolef/nfem/pbasis/make_basis_list_cxx.sh
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/basis_raw.h"
#include "rheolef/iorheo.h"
namespace rheolef {
using namespace std;

template<class T>
void
basis_raw_rep<T>::put (ostream& os, reference_element hat_K) const
{
  typedef reference_element::size_type  size_type;
  bool verbose  = iorheo::getverbose(os);
  bool clean    = iorheo::getclean(os);
  bool execute  = iorheo::getexecute(os);
  size_type nsub = iorheo::getsubdivide(os);
  if (nsub <= 1) nsub = 20; // default value

  size_type loc_ndof = reference_element::n_node(hat_K.variant(), degree());
  string basename  = "basis-" + name() + "-" + hat_K.name();
  string filelist;
  // --------------------
  // .plot
  // --------------------
  string plot_name = basename + ".plot";
  string gdat_name = basename + ".gdat";
  ofstream plot (plot_name.c_str());
  cerr << "! file \"" << plot_name << "\" created" << endl;
  filelist += " " + plot_name;
  size_t d = hat_K.dimension();
  check_macro (d==1 || d==2, "unsupported dimension " << d);
  plot << "gdat = \"" << gdat_name << "\"" << endl
       << "set colors classic" << endl
       << "set size square" << endl
    ;
  if (d == 1) {
    plot << "plot \\" << endl
      ;
    for (size_t loc_idof = 0; loc_idof < loc_ndof; ++loc_idof) {
      plot << "  gdat u 1:"<<loc_idof+2 << " t \"L" << loc_idof+1 << "\" w l";
      if (loc_idof+1 != loc_ndof) {
        plot << ",\\";
      }
      plot << endl;
    }
  } else if (d == 2) {
    plot << "pause_duration = 0.5" << endl
         << "d    = 2" << endl
         << "i    = d+1" << endl
         << "imax = d+" << loc_ndof << endl
         << "set hidden3d back # offset 1 trianglepattern 3 undefined 1 altdiagonal bentover" << endl
         << "set linetype 1 lw 1 lc rgb \"#000000\"" << endl
         << "set linetype 2 lw 1 lc rgb \"#0000ff\"" << endl
         << "splot gdat u 1:2:i t sprintf(\"P%d\",i-d) w l lc 0" << endl
         << "load \"" << basename << ".loop\"" << endl
      ;
    string loop_name = basename + ".loop";
    ofstream loop (loop_name.c_str());
    cerr << "! file \"" << loop_name << "\" created" << endl;
    filelist += " " + loop_name;
    loop << "i = i+1" << endl
         << "if (i <= imax) \\" << endl
         << "  pause pause_duration; \\" << endl
         << "  replot; \\" << endl
         << "  reread" << endl
      ;
  }
  plot << "pause -1 \"<return>\"" << endl;
  plot.close();

  // --------------------
  // .gdat
  // --------------------
  ofstream gdat (gdat_name.c_str());
  cerr << "! file \"" << gdat_name << "\" created" << endl;
  filelist += " " + gdat_name;
  gdat << setprecision(std::numeric_limits<T>::digits10)
       << "# basis   " << name() << endl
       << "# element " << hat_K.name() << endl
       << "# degree  " << degree() << endl
    ;
  arma::Col<T> value;
  switch (hat_K.variant()) {
    case reference_element::p: {
      break;
    } 
    case reference_element::e: {
      gdat << "# size " << loc_ndof << endl
           << "# x";
      for (size_t loc_idof = 0; loc_idof < loc_ndof; ++loc_idof) {
        gdat << " L" << loc_idof+1;
      }
      gdat << endl;
      for (size_type i = 0; i <= nsub; i++) { 
        point_basic<T> hat_x (T(int(i))/T(int(nsub)));
        eval (hat_K, hat_x, value);
	gdat << hat_x[0];
	for (size_t loc_idof = 0, loc_ndof = value.size(); loc_idof < loc_ndof; ++loc_idof) {
	  gdat << " " << value[loc_idof];
        }
        gdat << endl;
      }
      break;
    }
    case reference_element::t: {
      for (size_type j = 0; j <= nsub; j++) {
        for (size_type i1 = 0; i1 <= nsub; i1++) {
          size_type i = std::min(i1, nsub-j);
          point_basic<T> hat_x (T(int(i))/T(int(nsub)), T(int(j))/T(int(nsub)));
          eval (hat_K, hat_x, value);
	  gdat << hat_x[0] << " " << hat_x[1];
	  for (size_t loc_idof = 0, loc_ndof = value.size(); loc_idof < loc_ndof; ++loc_idof) {
	    gdat << " " << value[loc_idof];
          }
          gdat << endl;
        }
        gdat << endl;
      }
      break;
    } 
    case reference_element::q: {
      for (size_type j = 0; j <= nsub; j++) { 
        for (size_type i = 0; i <= nsub; i++) { 
          point_basic<T> hat_x (2*T(int(i))/T(int(nsub))-1, 2*T(int(j))/T(int(nsub))-1);
          eval (hat_K, hat_x, value);
	  gdat << hat_x[0] << " " << hat_x[1];
	  for (size_t loc_idof = 0, loc_ndof = value.size(); loc_idof < loc_ndof; ++loc_idof) {
	    gdat << " " << value[loc_idof];
          }
          gdat << endl;
        }
        gdat << endl;
      }
      break;
    } 
#ifdef TODO // 3D visu ?
    case reference_element::T: {
      for (size_type k = 0; k <= nsub; k++) {
        for (size_type j = 0; j+k <= nsub; j++) {
          for (size_type i = 0; i+j+k <= nsub; i++) { 
            point_basic<T> hat_x (T(i)/T(nsub), T(j)/T(nsub), T(k)/T(nsub));
            eval_lagrange (hat_x, hat_K, degree, sopt, inv_vdm, value);
            Lambda = max(Lambda, norm(value,1));
          }
        }
      }
      return Lambda;
    }
    case reference_element::P: {
      for (size_type k = 0; k <= degree; k++) { 
        for (size_type j = 0; j <= degree; j++) { 
          for (size_type i = 0; i+j <= degree; i++) { 
            point_basic<T> hat_x (T(i)/T(nsub), T(j)/T(nsub), 2*T(k)/T(nsub)-1);
            eval_lagrange (hat_x, hat_K, degree, sopt, inv_vdm, value);
            Lambda = max(Lambda, norm(value,1));
          }
        }
      }
      break;
    } 
    case reference_element::H: {
      for (size_type k = 0; k <= degree; k++) { 
        for (size_type j = 0; j <= degree; j++) { 
          for (size_type i = 0; i <= degree; i++) { 
            point_basic<T> hat_x (2*T(i)/T(nsub)-1, 2*T(j)/T(nsub), 2*T(k)/T(nsub)-1);
            eval_lagrange (hat_x, hat_K, degree, sopt, inv_vdm, value);
            Lambda = max(Lambda, norm(value,1));
          }
        }
      }
      break;
    } 
#endif // TODO
    default:
      error_macro ("unexpected element type `"<<hat_K.name()<<"'");
  } 
  // -----------
  if (execute) {
  // -----------
    string command = "gnuplot " + plot_name;
    if (verbose) clog << "! " << command << endl;
    int status = system (command.c_str());
  }
  // -----------
  if (clean) {
  // -----------
    string command = "/bin/rm -f " + filelist;
    if (verbose) clog << "! " << command << endl;
    int status = system (command.c_str());
  }
}
// --------------------------
// instanciation in library:
// --------------------------
template void basis_raw_rep<Float>::put (ostream& os, reference_element hat_K) const;

} // namespace rheolef
