#ifndef _RHEOLEF_ARMADILLO_UTIL_H
#define _RHEOLEF_ARMADILLO_UTIL_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// arma include, with some possible extended float support 

#include "rheolef/compiler.h"

// for arma: get math in std:: as std::sqrt -> retirect to boost::multiprecision::
#if defined(_RHEOLEF_HAVE_FLOAT128)
namespace std {
  inline rheolef::Float abs (const rheolef::Float& x)        { return fabs(x); }
  inline rheolef::Float sqrt(const rheolef::Float& x)        { return boost::multiprecision::sqrt(x); }
  inline rheolef::Float pow (const rheolef::Float& x, int k) { return boost::multiprecision::pow(x,k); }
  inline rheolef::Float pow (const rheolef::Float& x, const rheolef::Float& y) { return boost::multiprecision::pow(x,y); }
} // namespace std

#include "rheolef/space_constant.h" // is_scalar<T>::value used in patched <armadillo>
#endif // EXTENDED_FLOAT

#include <armadillo>

#if defined(_RHEOLEF_HAVE_FLOAT128)
namespace arma {
  template<> struct is_supported_elem_type <rheolef::Float> { static const bool value = true; };
  template<> struct is_supported_blas_type <rheolef::Float> { static const bool value = true; };
  template<> struct arma_real_only         <rheolef::Float> { typedef rheolef::Float  result; };
  template<> struct arma_real_or_cx_only   <rheolef::Float> { typedef rheolef::Float  result; };
  template<> struct arma_blas_type_only    <rheolef::Float> { typedef rheolef::Float  result; };
} // namespace arma
#endif // EXTENDED_FLOAT

#endif // _RHEOLEF_ARMADILLO_UTIL_H
